/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.eventmanager.tests.framework;

import junit.framework.TestCase;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.DynamicEObjectImpl;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.ocl.examples.eventmanager.EventFilter;
import org.eclipse.ocl.examples.eventmanager.EventManager;
import org.eclipse.ocl.examples.eventmanager.EventManagerFactory;

public class IncludeSubclassesTest
extends TestCase {
    private ResourceSet set;

    public void setUp() {
        try {
            super.setUp();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.set = new ResourceSetImpl();
        ResourceImpl r = new ResourceImpl();
        this.set.getResources().add((Object)r);
    }

    public void tearDown() {
        this.set = null;
        try {
            super.tearDown();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIncludingSubclassesFilterElementInsertionClassGetClass() {
        EventManager m = EventManagerFactory.eINSTANCE.createEventManagerFor(this.set);
        EClass cls = EcoreFactory.eINSTANCE.createEClass();
        EventFilter filter = EventManagerFactory.eINSTANCE.createFilterForElementInsertion(cls);
        EReference ref = EcoreFactory.eINSTANCE.createEReference();
        ref.setContainment(true);
        ENotificationImpl noti = new ENotificationImpl(null, 1, (EStructuralFeature)ref, null, (Object)new DynamicEObjectImpl(cls));
        App app = new App();
        m.subscribe(filter, (Adapter)app);
        m.handleEMFEvent((Notification)noti);
        IncludeSubclassesTest.assertTrue((String)"Application not notified", (boolean)app.noti);
        app.noti = false;
        EList eAdapters = ((Resource)this.set.getResources().get(0)).eAdapters();
        int i = 0;
        while (i < eAdapters.size()) {
            ((Adapter)eAdapters.get(i)).notifyChanged((Notification)noti);
            ++i;
        }
        IncludeSubclassesTest.assertTrue((String)"Application not notified", (boolean)app.noti);
    }

    public void testIncludingSubclassesFilterElementInsertionClassGetSubclass() {
        EventManager m = EventManagerFactory.eINSTANCE.createEventManagerFor(this.set);
        EClass cls = EcoreFactory.eINSTANCE.createEClass();
        EClass subcls = EcoreFactory.eINSTANCE.createEClass();
        subcls.getESuperTypes().add((Object)cls);
        EventFilter filter = EventManagerFactory.eINSTANCE.createFilterForElementInsertion(cls);
        EReference ref = EcoreFactory.eINSTANCE.createEReference();
        ref.setContainment(true);
        ENotificationImpl noti = new ENotificationImpl(null, 1, (EStructuralFeature)ref, null, (Object)new DynamicEObjectImpl(subcls));
        App app = new App();
        m.subscribe(filter, (Adapter)app);
        m.handleEMFEvent((Notification)noti);
        IncludeSubclassesTest.assertTrue((String)"Application not notified", (boolean)app.noti);
        app.noti = false;
        EList eAdapters = ((Resource)this.set.getResources().get(0)).eAdapters();
        int i = 0;
        while (i < eAdapters.size()) {
            ((Adapter)eAdapters.get(i)).notifyChanged((Notification)noti);
            ++i;
        }
        IncludeSubclassesTest.assertTrue((String)"Application not notified", (boolean)app.noti);
    }

    public void testDoubleSubscriptionExpectSubclassButNoSuperClass() {
        EventManager m = EventManagerFactory.eINSTANCE.createEventManagerFor(this.set);
        EClass classA = EcoreFactory.eINSTANCE.createEClass();
        EClass classB = EcoreFactory.eINSTANCE.createEClass();
        classB.getESuperTypes().add((Object)classA);
        EventFilter filter = EventManagerFactory.eINSTANCE.createAndFilterFor(new EventFilter[]{EventManagerFactory.eINSTANCE.createNotFilter(EventManagerFactory.eINSTANCE.createClassFilterIncludingSubclasses(classA)), EventManagerFactory.eINSTANCE.createClassFilterIncludingSubclasses(classB)});
        App app = new App();
        m.subscribe(filter, (Adapter)app);
        DynamicEObjectImpl object = new DynamicEObjectImpl(classB);
        ENotificationImpl noti = new ENotificationImpl((InternalEObject)object, 0, null, null, null);
        m.handleEMFEvent((Notification)noti);
        m.unsubscribe((Adapter)app);
        DynamicEObjectImpl object2 = new DynamicEObjectImpl(classA);
        ENotificationImpl noti2 = new ENotificationImpl((InternalEObject)object2, 0, null, null, null);
        App app2 = new App();
        m.subscribe(filter, (Adapter)app2);
        m.handleEMFEvent((Notification)noti2);
        IncludeSubclassesTest.assertFalse((String)"Application wrongly notified", (boolean)app2.noti);
        m.unsubscribe((Adapter)app2);
        ENotificationImpl noti3 = new ENotificationImpl(null, 0, null, null, null);
        App app3 = new App();
        m.subscribe(filter, (Adapter)app3);
        m.handleEMFEvent((Notification)noti3);
        IncludeSubclassesTest.assertFalse((String)"Application wrongly notified", (boolean)app3.noti);
        m.unsubscribe((Adapter)app3);
    }

    public void testDoubleSubscriptionExpectSuperclassButNoSubClass() {
        EventManager m = EventManagerFactory.eINSTANCE.createEventManagerFor(this.set);
        EClass classA = EcoreFactory.eINSTANCE.createEClass();
        EClass classB = EcoreFactory.eINSTANCE.createEClass();
        classB.getESuperTypes().add((Object)classA);
        EventFilter filter = EventManagerFactory.eINSTANCE.createAndFilterFor(new EventFilter[]{EventManagerFactory.eINSTANCE.createNotFilter(EventManagerFactory.eINSTANCE.createClassFilterIncludingSubclasses(classB)), EventManagerFactory.eINSTANCE.createClassFilterIncludingSubclasses(classA)});
        App app = new App();
        m.subscribe(filter, (Adapter)app);
        DynamicEObjectImpl object = new DynamicEObjectImpl(classB);
        ENotificationImpl noti = new ENotificationImpl((InternalEObject)object, 0, null, null, null);
        m.handleEMFEvent((Notification)noti);
        m.unsubscribe((Adapter)app);
        DynamicEObjectImpl object2 = new DynamicEObjectImpl(classA);
        ENotificationImpl noti2 = new ENotificationImpl((InternalEObject)object2, 0, null, null, null);
        App app2 = new App();
        m.subscribe(filter, (Adapter)app2);
        m.handleEMFEvent((Notification)noti2);
        IncludeSubclassesTest.assertTrue((String)"Application not notified", (boolean)app2.noti);
        m.unsubscribe((Adapter)app2);
        ENotificationImpl noti3 = new ENotificationImpl(null, 0, null, null, null);
        App app3 = new App();
        m.subscribe(filter, (Adapter)app3);
        m.handleEMFEvent((Notification)noti3);
        IncludeSubclassesTest.assertFalse((String)"Application wrongly notified", (boolean)app3.noti);
        m.unsubscribe((Adapter)app3);
    }

    public void testNegatedSubscriptionClassANotificationSubclassB() {
        EventManager m = EventManagerFactory.eINSTANCE.createEventManagerFor(this.set);
        EClass classA = EcoreFactory.eINSTANCE.createEClass();
        EClass classB = EcoreFactory.eINSTANCE.createEClass();
        classB.getESuperTypes().add((Object)classA);
        EventFilter filter = EventManagerFactory.eINSTANCE.createNotFilter(EventManagerFactory.eINSTANCE.createClassFilterIncludingSubclasses(classA));
        App app = new App();
        m.subscribe(filter, (Adapter)app);
        DynamicEObjectImpl object = new DynamicEObjectImpl(classB);
        ENotificationImpl noti = new ENotificationImpl((InternalEObject)object, 0, null, null, null);
        m.handleEMFEvent((Notification)noti);
        m.unsubscribe((Adapter)app);
        IncludeSubclassesTest.assertFalse((String)"Get wrongly notified", (boolean)app.noti);
    }

    class App
    extends AdapterImpl {
        public boolean noti = false;

        App() {
        }

        public void notifyChanged(Notification msg) {
            this.noti = true;
        }
    }
}

