/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.test.xtext;

import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.xtext.tests.TestUIUtil;
import org.eclipse.ocl.examples.xtext.tests.XtextTestCase;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.internal.manager.MetamodelManagerInternal;
import org.eclipse.ocl.pivot.internal.utilities.OCLInternal;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;

public class DebuggerTests
extends XtextTestCase {
    protected ILaunchConfigurationWorkingCopy createLaunchConfiguration(@NonNull IProject iProject, @NonNull Constraint constraint, @NonNull EObject eObject) throws CoreException {
        URI contextURI = EcoreUtil.getURI((EObject)eObject);
        URI constraintURI = EcoreUtil.getURI((EObject)constraint);
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType launchConfigurationType = launchManager.getLaunchConfigurationType("org.eclipse.ocl.examples.debug.launching.OCLLaunchConfigurationDelegate");
        ILaunchConfigurationWorkingCopy launchConfiguration = launchConfigurationType.newInstance((IContainer)iProject, constraint.getName());
        launchConfiguration.setAttribute("constraint", constraintURI.toString());
        launchConfiguration.setAttribute("context", contextURI.toString());
        return launchConfiguration;
    }

    public void testDebugger_Launch() throws Exception {
        TestUIUtil.closeIntro();
        TestUIUtil.enableSwitchToDebugPerspectivePreference();
        IProject iProject = TestUIUtil.createIProject("DebuggerTests");
        IFile xmiFile = TestUIUtil.copyIFile(iProject.getFile("RoyalAndLoyal.xmi"), this.getProjectFileURI("RoyalAndLoyal.xmi"), null);
        IFile ecoreFile = TestUIUtil.copyIFile(iProject.getFile("RoyalAndLoyal.ecore"), this.getProjectFileURI("RoyalAndLoyal.ecore"), null);
        IFile oclFile = TestUIUtil.copyIFile(iProject.getFile("RoyalAndLoyal.ocl"), this.getProjectFileURI("RoyalAndLoyal.ocl"), "UTF-8");
        URI xmiURI = URI.createPlatformResourceURI((String)xmiFile.getFullPath().toString(), (boolean)true);
        URI oclURI = URI.createPlatformResourceURI((String)oclFile.getFullPath().toString(), (boolean)true);
        OCLInternal ocl = OCLInternal.newInstance((ProjectManager)DebuggerTests.getProjectMap(), null);
        Resource xmiResource = ocl.getResourceSet().getResource(xmiURI, true);
        EObject xmiRoot = (EObject)ClassUtil.nonNullState((Object)((EObject)xmiResource.getContents().get(0)));
        DebuggerTests.assertNoResourceErrors("Load failed", xmiResource);
        DebuggerTests.assertNoUnresolvedProxies("Unresolved proxies", xmiResource);
        DebuggerTests.assertNoValidationErrors("Validation errors", xmiRoot);
        Resource oclResource = (Resource)ClassUtil.nonNullState((Object)ocl.getResourceSet().getResource(oclURI, true));
        DebuggerTests.assertNoResourceErrors("Load failed", oclResource);
        DebuggerTests.assertNoUnresolvedProxies("Unresolved proxies", oclResource);
        DebuggerTests.assertNoValidationErrors("Validation errors", (EObject)ClassUtil.nonNullState((Object)((EObject)oclResource.getContents().get(0))));
        EStructuralFeature ref_RandL_Customer = xmiRoot.eClass().getEStructuralFeature("ref_RandL_Customer");
        List customers = (List)xmiRoot.eGet(ref_RandL_Customer);
        EObject eObject = (EObject)customers.get(0);
        MetamodelManagerInternal metamodelManager = ocl.getMetamodelManager();
        Class customerClass = (Class)ClassUtil.nonNullState((Object)((Class)metamodelManager.getASOf(Class.class, (EObject)eObject.eClass())));
        Iterable customerInvariants = metamodelManager.getAllInvariants((Type)customerClass);
        Constraint constraint = (Constraint)ClassUtil.nonNullState((Object)((Constraint)NameUtil.getNameable((Iterable)customerInvariants, (String)"invariant_sizesAgree")));
        ILaunchConfigurationWorkingCopy launchConfiguration = this.createLaunchConfiguration(iProject, constraint, eObject);
        launchConfiguration.doSave();
        TestUIUtil.flushEvents();
        ILaunch launch = launchConfiguration.launch("debug", null);
        assert (launch != null);
        TestUIUtil.waitForLaunchToTerminate(launch);
        ocl.dispose();
    }
}

