/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.java.types;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.generator.CodeGenerator;
import org.eclipse.ocl.examples.codegen.generator.TypeDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.AbstractValueDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.BoxedDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.EcoreDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.UnboxedDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.UnboxedValueDescriptor;
import org.eclipse.ocl.pivot.ids.ElementId;

public abstract class BoxedValueDescriptor
extends AbstractValueDescriptor
implements BoxedDescriptor {
    private EcoreDescriptor ecoreDescriptor;
    private UnboxedDescriptor unboxedDescriptor;

    public BoxedValueDescriptor(@NonNull ElementId elementId, @NonNull Class<?> javaClass) {
        super(elementId, javaClass);
    }

    protected abstract @NonNull EcoreDescriptor createEcoreDescriptor();

    protected abstract @NonNull UnboxedDescriptor createUnboxedDescriptor();

    @Override
    public @NonNull EcoreDescriptor getEcoreDescriptor(@NonNull CodeGenerator codeGenerator, @Nullable Class<?> instanceClass) {
        EcoreDescriptor ecoreDescriptor2;
        if (instanceClass != null) {
            if (BigDecimal.class == instanceClass) {
                return new UnboxedValueDescriptor(this.elementId, BigDecimal.class);
            }
            if (BigInteger.class == instanceClass) {
                return new UnboxedValueDescriptor(this.elementId, BigInteger.class);
            }
            if (Byte.class == instanceClass) {
                return new UnboxedValueDescriptor(this.elementId, Byte.class);
            }
            if (Character.class == instanceClass) {
                return new UnboxedValueDescriptor(this.elementId, Character.class);
            }
            if (Double.class == instanceClass) {
                return new UnboxedValueDescriptor(this.elementId, Double.class);
            }
            if (Float.class == instanceClass) {
                return new UnboxedValueDescriptor(this.elementId, Float.class);
            }
            if (Integer.class == instanceClass) {
                return new UnboxedValueDescriptor(this.elementId, Integer.class);
            }
            if (Long.class == instanceClass) {
                return new UnboxedValueDescriptor(this.elementId, Long.class);
            }
            if (Short.class == instanceClass) {
                return new UnboxedValueDescriptor(this.elementId, Short.class);
            }
            if (Byte.TYPE == instanceClass) {
                return new UnboxedValueDescriptor(this.elementId, Byte.TYPE);
            }
            if (Character.TYPE == instanceClass) {
                return new UnboxedValueDescriptor(this.elementId, Character.TYPE);
            }
            if (Double.TYPE == instanceClass) {
                return new UnboxedValueDescriptor(this.elementId, Double.TYPE);
            }
            if (Float.TYPE == instanceClass) {
                return new UnboxedValueDescriptor(this.elementId, Float.TYPE);
            }
            if (Integer.TYPE == instanceClass) {
                return new UnboxedValueDescriptor(this.elementId, Integer.TYPE);
            }
            if (Long.TYPE == instanceClass) {
                return new UnboxedValueDescriptor(this.elementId, Long.TYPE);
            }
            if (Short.TYPE == instanceClass) {
                return new UnboxedValueDescriptor(this.elementId, Short.TYPE);
            }
        }
        if ((ecoreDescriptor2 = this.ecoreDescriptor) == null) {
            this.ecoreDescriptor = ecoreDescriptor2 = this.createEcoreDescriptor();
        }
        return ecoreDescriptor2;
    }

    @Override
    public @NonNull UnboxedDescriptor getUnboxedDescriptor(@NonNull CodeGenerator codeGenerator) {
        UnboxedDescriptor unboxedDescriptor2 = this.unboxedDescriptor;
        if (unboxedDescriptor2 == null) {
            this.unboxedDescriptor = unboxedDescriptor2 = this.createUnboxedDescriptor();
        }
        return unboxedDescriptor2;
    }

    @Override
    public final boolean isAssignableFrom(@NonNull TypeDescriptor typeDescriptor) {
        if (typeDescriptor == this) {
            return true;
        }
        if (!(typeDescriptor instanceof BoxedDescriptor)) {
            return false;
        }
        return this.javaClass.isAssignableFrom(typeDescriptor.getJavaClass());
    }
}

