/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.oclinecore;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenClassifier;
import org.eclipse.emf.codegen.ecore.genmodel.GenEnum;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.common.NameQueries;
import org.eclipse.ocl.examples.codegen.generator.AbstractGenModelHelper;
import org.eclipse.ocl.examples.codegen.java.ImportUtils;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Enumeration;
import org.eclipse.ocl.pivot.EnumerationLiteral;
import org.eclipse.ocl.pivot.LambdaType;
import org.eclipse.ocl.pivot.Library;
import org.eclipse.ocl.pivot.MapType;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.Namespace;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.ParameterTypes;
import org.eclipse.ocl.pivot.PrimitiveType;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.TemplateBinding;
import org.eclipse.ocl.pivot.TemplateParameter;
import org.eclipse.ocl.pivot.TemplateParameterSubstitution;
import org.eclipse.ocl.pivot.TemplateableElement;
import org.eclipse.ocl.pivot.TupleType;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.VoidType;
import org.eclipse.ocl.pivot.ids.BuiltInTypeId;
import org.eclipse.ocl.pivot.ids.LambdaTypeId;
import org.eclipse.ocl.pivot.ids.ParametersId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.complete.CompleteClassInternal;
import org.eclipse.ocl.pivot.internal.complete.StandardLibraryInternal;
import org.eclipse.ocl.pivot.internal.ecore.es2as.Ecore2AS;
import org.eclipse.ocl.pivot.internal.library.executor.ExecutorLambdaType;
import org.eclipse.ocl.pivot.internal.library.executor.ExecutorSpecializedType;
import org.eclipse.ocl.pivot.internal.library.executor.ExecutorTupleType;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.prettyprint.PrettyPrinter;
import org.eclipse.ocl.pivot.internal.resource.EnvironmentFactoryAdapter;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.OCLInternal;
import org.eclipse.ocl.pivot.internal.utilities.PivotConstantsInternal;
import org.eclipse.ocl.pivot.library.LibraryConstants;
import org.eclipse.ocl.pivot.util.AbstractExtendingVisitor;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.Nameable;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.xtext.util.Strings;

public class OCLinEcoreTablesUtils {
    public Comparator<ParameterTypes> templateBindingNameComparator = new Comparator<ParameterTypes>(){

        @Override
        public int compare(ParameterTypes o1, ParameterTypes o2) {
            if (!($assertionsDisabled || o1 != null && o2 != null)) {
                throw new AssertionError();
            }
            String n1 = OCLinEcoreTablesUtils.this.getTemplateBindingsName(o1);
            String n2 = OCLinEcoreTablesUtils.this.getTemplateBindingsName(o2);
            return n1.compareTo(n2);
        }
    };
    public static Comparator<Nameable> nameComparator = new Comparator<Nameable>(){

        @Override
        public int compare(Nameable o1, Nameable o2) {
            String n1 = String.valueOf(o1.getName());
            String n2 = String.valueOf(o2.getName());
            return n1.compareTo(n2);
        }
    };
    public static final @NonNull Comparator<Property> propertyComparator = new Comparator<Property>(){

        @Override
        public int compare(Property p1, Property p2) {
            String n2;
            boolean b2;
            boolean b1 = p1.isIsImplicit();
            if (b1 != (b2 = p2.isIsImplicit())) {
                return b1 ? 1 : -1;
            }
            String n1 = String.valueOf(p1.getName());
            int diff = n1.compareTo(n2 = String.valueOf(p2.getName()));
            if (diff != 0) {
                return diff;
            }
            Property o1 = p1.getOpposite();
            Property o2 = p2.getOpposite();
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            n1 = String.valueOf(o1.getName());
            n2 = String.valueOf(o2.getName());
            return n1.compareTo(n2);
        }
    };
    public static Comparator<Operation> signatureComparator = new Comparator<Operation>(){

        @Override
        public int compare(Operation o1, Operation o2) {
            if (!($assertionsDisabled || o1 != null && o2 != null)) {
                throw new AssertionError();
            }
            String n1 = String.valueOf(OCLinEcoreTablesUtils.getSignature(o1));
            String n2 = String.valueOf(OCLinEcoreTablesUtils.getSignature(o2));
            return n1.compareTo(n2);
        }
    };
    protected final @NonNull CodeGenString s = new CodeGenString();
    protected final @NonNull GenPackage genPackage;
    protected final @NonNull PivotMetamodelManager metamodelManager;
    protected final @NonNull EnvironmentFactoryInternal environmentFactory;
    protected final @NonNull StandardLibraryInternal standardLibrary;
    protected final @NonNull Package pPackage;
    protected final @NonNull DeclareParameterTypeVisitor declareParameterTypeVisitor = new DeclareParameterTypeVisitor(this.s);
    protected final @NonNull EmitLiteralVisitor emitLiteralVisitor = new EmitLiteralVisitor(this.s);
    protected final @NonNull EmitQualifiedLiteralVisitor emitQualifiedLiteralVisitor = new EmitQualifiedLiteralVisitor(this.s);
    protected final @NonNull Iterable<Class> activeClassesSortedByName;
    protected final @NonNull Map<ParameterTypes, String> templateBindingsNames = new HashMap<ParameterTypes, String>();

    private static <T extends GenPackage> @Nullable T getLibraryGenPackage(List<T> genPackages) {
        for (GenPackage genPackage : genPackages) {
            EPackage ecorePackage = genPackage.getEcorePackage();
            EClassifier eClassifier = ecorePackage.getEClassifier("_Dummy");
            if (eClassifier == null) continue;
            return (T)genPackage;
        }
        return null;
    }

    private static <T extends GenPackage> @Nullable T getMetamodelGenPackage(@NonNull List<T> genPackages) {
        for (GenPackage genPackage : genPackages) {
            EPackage ecorePackage = genPackage.getEcorePackage();
            EClassifier eClassifier = ecorePackage.getEClassifier("Element");
            if (eClassifier == null) continue;
            return (T)genPackage;
        }
        return null;
    }

    private static <T extends GenClassifier> @Nullable T getNamedElement1(@Nullable List<T> genClasses, @NonNull String name) {
        if (genClasses != null) {
            for (GenClassifier genClass : genClasses) {
                if (!genClass.getName().equals(name)) continue;
                return (T)genClass;
            }
        }
        return null;
    }

    private static <T extends GenFeature> @Nullable T getNamedElement2(@Nullable List<T> genClasses, @NonNull String name) {
        if (genClasses != null) {
            for (GenFeature genClass : genClasses) {
                if (!genClass.getName().equals(name)) continue;
                return (T)genClass;
            }
        }
        return null;
    }

    public @NonNull String getPagedName(@NonNull String name, int i, int iMax) {
        if (i < iMax) {
            return String.valueOf(name) + i;
        }
        return name;
    }

    public static @NonNull Boolean isBuiltInType(@NonNull Type type) {
        return type.getTypeId() instanceof BuiltInTypeId;
    }

    private static @NonNull GenPackage loadGenPackage(@NonNull ResourceSet resourceSet, @NonNull URI genModelURI) {
        Resource resource = resourceSet.getResource(genModelURI, true);
        GenModel genModel = (GenModel)resource.getContents().get(0);
        GenPackage genPackage = (GenPackage)genModel.getGenPackages().get(0);
        assert (genPackage != null);
        return genPackage;
    }

    protected OCLinEcoreTablesUtils(@NonNull GenPackage genPackage) {
        this.genPackage = genPackage;
        Resource genModelResource = genPackage.eResource();
        ResourceSet genModelResourceSet = genModelResource.getResourceSet();
        assert (genModelResourceSet != null);
        EnvironmentFactoryAdapter resourceSetAdapter = OCLInternal.adapt((Notifier)genModelResourceSet);
        this.metamodelManager = resourceSetAdapter.getMetamodelManager();
        this.environmentFactory = this.metamodelManager.getEnvironmentFactory();
        this.standardLibrary = this.environmentFactory.getStandardLibrary();
        this.pPackage = (Package)ClassUtil.nonNullModel((Object)this.getPivotPackage(genPackage));
        this.activeClassesSortedByName = this.getActiveClassesSortedByName(this.pPackage);
    }

    protected @NonNull Iterable<Class> getActiveClassesSortedByName(@NonNull Package pPackage) {
        ArrayList<Class> sortedClasses = new ArrayList<Class>(this.getActiveTypes(pPackage));
        Collections.sort(sortedClasses, nameComparator);
        return sortedClasses;
    }

    protected @NonNull Set<? extends Class> getActiveTypes(@NonNull Package pPackage) {
        Package oclstdlibPackage = this.standardLibrary.getBooleanType().getOwningPackage();
        Package pivotMetamodel = this.metamodelManager.getASmetamodel();
        Class elementType = this.metamodelManager.getASClass("Element");
        if (oclstdlibPackage == pPackage) {
            VoidType oclVoidType = this.metamodelManager.getStandardLibrary().getOclVoidType();
            HashSet<Class> types = new HashSet<Class>();
            for (Class type : oclstdlibPackage.getOwnedClasses()) {
                assert (type != null);
                CompleteClassInternal completeClass = this.metamodelManager.getCompleteClass((Type)type);
                if (elementType != null && this.isElementType((CompleteClass)completeClass, (Type)elementType, oclVoidType)) continue;
                types.add(type);
            }
            return types;
        }
        if (pivotMetamodel == pPackage) {
            HashSet<Class> types = new HashSet<Class>();
            for (Class type : pivotMetamodel.getOwnedClasses()) {
                assert (type != null);
                boolean pruned = false;
                Class myType = null;
                CompleteClassInternal completeClass = this.metamodelManager.getCompleteClass((Type)type);
                for (Class partialClass : completeClass.getPartialClasses()) {
                    Package partialPackage = partialClass.getOwningPackage();
                    if (partialPackage == oclstdlibPackage) {
                        if (elementType == null || completeClass.conformsTo((Type)elementType)) continue;
                        pruned = true;
                        continue;
                    }
                    if (partialPackage != pPackage) continue;
                    myType = type;
                }
                if (pruned || !(myType instanceof Class)) continue;
                types.add(myType);
            }
            return types;
        }
        return new HashSet(pPackage.getOwnedClasses());
    }

    protected @NonNull Iterable<Class> getAllProperSupertypesSortedByName(@NonNull Class pClass) {
        Class theClass = this.metamodelManager.getPrimaryClass(pClass);
        HashMap<Class, Integer> results = new HashMap<Class, Integer>();
        this.getAllSuperClasses(results, theClass);
        ArrayList<Class> sortedClasses = new ArrayList<Class>(results.keySet());
        sortedClasses.remove(theClass);
        Collections.sort(sortedClasses, nameComparator);
        return sortedClasses;
    }

    protected @NonNull List<Class> getAllSupertypesSortedByName(@NonNull Class pClass) {
        HashMap<Class, Integer> results = new HashMap<Class, Integer>();
        this.getAllSuperClasses(results, pClass);
        ArrayList<Class> sortedClasses = new ArrayList<Class>(results.keySet());
        Collections.sort(sortedClasses, nameComparator);
        return sortedClasses;
    }

    protected int getAllSuperClasses(@NonNull Map<Class, Integer> results, @NonNull Class aClass) {
        Class theClass = this.metamodelManager.getPrimaryClass(aClass);
        Integer depth = results.get(theClass);
        if (depth != null) {
            return depth;
        }
        int myDepth = 0;
        for (CompleteClass superCompleteClass : this.metamodelManager.getAllSuperCompleteClasses((Type)theClass)) {
            int superDepth;
            Class superClass = superCompleteClass.getPrimaryClass();
            if (superClass == theClass || (superDepth = this.getAllSuperClasses(results, superClass = (Class)PivotUtil.getUnspecializedTemplateableElement((TemplateableElement)superClass))) < myDepth) continue;
            myDepth = superDepth + 1;
        }
        results.put(theClass, myDepth);
        return myDepth;
    }

    protected @Nullable Package getExtendedPackage(@NonNull Package pPackage) {
        Package oclstdlibPackage = this.standardLibrary.getBooleanType().getOwningPackage();
        Package pivotMetamodel = this.metamodelManager.getASmetamodel();
        if (oclstdlibPackage == pPackage) {
            return null;
        }
        if (pivotMetamodel == pPackage) {
            return oclstdlibPackage;
        }
        return null;
    }

    public @NonNull GenPackage getGenPackage() {
        return this.genPackage;
    }

    protected @Nullable GenPackage getGenPackage(@NonNull Class type) {
        Package pPackage = type.getOwningPackage();
        assert (pPackage != null);
        Package oclstdlibPackage = this.standardLibrary.getBooleanType().getOwningPackage();
        Class elementType = this.metamodelManager.getASClass("Element");
        if (elementType != null && oclstdlibPackage != null) {
            VoidType oclVoidType = this.metamodelManager.getStandardLibrary().getOclVoidType();
            Package pivotMetamodel = elementType.getOwningPackage();
            assert (pivotMetamodel != null);
            if (oclstdlibPackage == pPackage) {
                CompleteClassInternal completeClass = this.metamodelManager.getCompleteClass((Type)type);
                if (this.isElementType((CompleteClass)completeClass, (Type)elementType, oclVoidType)) {
                    return this.getGenPackage(pivotMetamodel);
                }
                return this.getGenPackage(oclstdlibPackage);
            }
            if (pivotMetamodel == pPackage) {
                CompleteClassInternal completeClass = this.metamodelManager.getCompleteClass((Type)type);
                for (Class partialClass : completeClass.getPartialClasses()) {
                    Package partialPackage = partialClass.getOwningPackage();
                    if (partialPackage != oclstdlibPackage || this.isElementType((CompleteClass)completeClass, (Type)elementType, oclVoidType)) continue;
                    return this.getGenPackage(oclstdlibPackage);
                }
                return this.getGenPackage(pivotMetamodel);
            }
        }
        return this.getGenPackage(pPackage);
    }

    protected @Nullable GenPackage getGenPackage(@NonNull Package asPackage) {
        EPackage firstEPackage = this.genPackage.getEcorePackage();
        if (firstEPackage.getName().equals(asPackage.getName())) {
            return this.genPackage;
        }
        EList usedGenPackages = this.genPackage.getGenModel().getUsedGenPackages();
        assert (usedGenPackages != null);
        Resource genModelResource = this.genPackage.eResource();
        ResourceSet genModelResourceSet = genModelResource.getResourceSet();
        assert (genModelResourceSet != null);
        Package metamodelPackage = this.metamodelManager.getASmetamodel();
        Package libraryPackage = (Package)this.metamodelManager.getLibraries().get(0);
        if (asPackage == libraryPackage) {
            Object libraryGenPackage = OCLinEcoreTablesUtils.getLibraryGenPackage(usedGenPackages);
            if (libraryGenPackage == null) {
                libraryGenPackage = OCLinEcoreTablesUtils.loadGenPackage(genModelResourceSet, LibraryConstants.GEN_MODEL_URI);
            }
            return libraryGenPackage;
        }
        if (asPackage == metamodelPackage) {
            Object metamodelGenPackage = OCLinEcoreTablesUtils.getMetamodelGenPackage(usedGenPackages);
            if (metamodelGenPackage == null) {
                metamodelGenPackage = OCLinEcoreTablesUtils.loadGenPackage(genModelResourceSet, PivotConstantsInternal.GEN_MODEL_URI);
            }
            return metamodelGenPackage;
        }
        String nsURI = asPackage.getURI();
        if (nsURI != null) {
            GenPackage genPackage2 = this.metamodelManager.getGenPackage(nsURI);
            if (genPackage2 != null) {
                return genPackage2;
            }
            for (GenPackage usedGenPackage : usedGenPackages) {
                if (usedGenPackage == null) continue;
                this.metamodelManager.addGenPackage(usedGenPackage);
            }
            genPackage2 = this.metamodelManager.getGenPackage(nsURI);
            if (genPackage2 != null) {
                return genPackage2;
            }
        }
        throw new IllegalStateException("No GenPackage for '" + nsURI + "'");
    }

    protected @NonNull String getImplementationName(@NonNull Operation operation) {
        if (operation.getImplementationClass() != null) {
            return String.valueOf(operation.getImplementationClass()) + ".INSTANCE";
        }
        return "null";
    }

    protected @NonNull Iterable<Operation> getLocalOperationsSortedBySignature(@NonNull Class pClass) {
        ArrayList<Operation> sortedOperations = new ArrayList<Operation>(this.getOperations(pClass));
        Collections.sort(sortedOperations, signatureComparator);
        return sortedOperations;
    }

    protected @NonNull List<Property> getLocalPropertiesSortedByName(@NonNull Class pClass) {
        ArrayList<Property> sortedProperties = new ArrayList<Property>();
        for (Property property : this.getProperties(pClass)) {
            assert (property != null);
            if (!this.isProperty(property)) continue;
            sortedProperties.add(property);
        }
        Collections.sort(sortedProperties, propertyComparator);
        return sortedProperties;
    }

    protected @NonNull LinkedHashSet<Operation> getOperations(@NonNull Class type) {
        LinkedHashSet<Operation> operations = new LinkedHashSet<Operation>();
        for (Operation operation : this.metamodelManager.getMemberOperations(type, false)) {
            operations.add(operation);
        }
        for (Operation operation : this.metamodelManager.getMemberOperations(type, true)) {
            operations.add(operation);
        }
        return operations;
    }

    protected @NonNull Operation getOverloadOp(@NonNull Class pClass, @NonNull Operation baseOp) {
        String baseSignature = OCLinEcoreTablesUtils.getSignature(baseOp);
        HashMap<Class, @NonNull Integer> results = new HashMap<Class, Integer>();
        this.getAllSuperClasses(results, pClass);
        int bestDepth = -1;
        Operation best = null;
        for (Class aClass : results.keySet()) {
            Integer aDepth = (Integer)results.get(aClass);
            assert (aDepth != null);
            for (Operation op : this.getOperations((Class)ClassUtil.nonNullState((Object)aClass))) {
                if (!baseSignature.equals(OCLinEcoreTablesUtils.getSignature((Operation)ClassUtil.nonNullState((Object)op))) || aDepth <= bestDepth) continue;
                bestDepth = aDepth;
                best = op;
            }
        }
        assert (best != null);
        return best;
    }

    protected Package getPivotPackage(@NonNull GenPackage genPackage) {
        EPackage ePackage = genPackage.getEcorePackage();
        Resource ecoreResource = ePackage.eResource();
        if (ecoreResource == null) {
            return null;
        }
        Ecore2AS ecore2as = Ecore2AS.getAdapter((Resource)ecoreResource, (EnvironmentFactoryInternal)this.environmentFactory);
        Package asPackage = (Package)ecore2as.getCreated(Package.class, (EObject)ePackage);
        if (asPackage == null) {
            return null;
        }
        if (asPackage.getURI().equals("http://www.eclipse.org/ocl/2015/Library")) {
            this.mergeLibrary(asPackage);
        }
        return asPackage;
    }

    protected @NonNull LinkedHashSet<Property> getProperties(@NonNull Class type) {
        HashSet<String> names = new HashSet<String>();
        LinkedHashSet<Property> properties = new LinkedHashSet<Property>();
        for (Property property : this.metamodelManager.getMemberProperties(type, true)) {
            names.add(property.getName());
            properties.add(this.metamodelManager.getPrimaryProperty(property));
        }
        for (Property property : this.metamodelManager.getMemberProperties(type, false)) {
            if (names.contains(property.getName())) continue;
            properties.add(this.metamodelManager.getPrimaryProperty(property));
        }
        return properties;
    }

    protected @NonNull String getQualifiedTablesClassName(@NonNull Class type) {
        GenPackage genPackage = this.getGenPackage(type);
        if (genPackage != null) {
            return String.valueOf(genPackage.getReflectionPackageName()) + "." + this.getTablesClassName(genPackage);
        }
        return "UnknownMetamodelTables";
    }

    protected @NonNull String getQualifiedTablesClassName(@NonNull Package pPackage) {
        GenPackage genPackage = this.getGenPackage(pPackage);
        if (genPackage != null) {
            return String.valueOf(genPackage.getReflectionPackageName()) + "." + this.getTablesClassName(genPackage);
        }
        return "UnknownMetamodelTables";
    }

    protected @NonNull String getSharedLibrary() {
        GenPackage gPackage;
        PrimitiveType booleanType;
        Package libraryPackage;
        Package thisPackage = this.getPivotPackage(this.genPackage);
        if (thisPackage != null && (libraryPackage = (booleanType = this.standardLibrary.getBooleanType()).getOwningPackage()) != null && (gPackage = this.getGenPackage(libraryPackage)) != null) {
            return String.valueOf(gPackage.getReflectionPackageName()) + "." + gPackage.getPrefix() + "Tables";
        }
        return "";
    }

    public static @NonNull String getSignature(@NonNull Operation anOperation) {
        Class owningType = anOperation.getOwningClass();
        if (owningType == null) {
            return "null";
        }
        String qualifiedSignature = PrettyPrinter.printType((Element)anOperation, (Namespace)owningType);
        int colonColonIndex = qualifiedSignature.indexOf("::");
        int parenthesisIndex = qualifiedSignature.indexOf("(");
        if (parenthesisIndex < 0 ? colonColonIndex > 0 : colonColonIndex < parenthesisIndex) {
            @NonNull String substring = qualifiedSignature.substring(colonColonIndex + 1);
            return substring;
        }
        return qualifiedSignature;
    }

    public @NonNull String getTablesClassName() {
        return this.getTablesClassName(this.genPackage);
    }

    protected @NonNull String getTablesClassName(@NonNull GenPackage genPackage) {
        return String.valueOf(genPackage.getPrefix()) + "Tables";
    }

    protected @NonNull String getTemplateBindingsName(@NonNull ParameterTypes templateBindings) {
        String name2 = this.templateBindingsNames.get(templateBindings);
        if (name2 == null) {
            StringBuilder s = new StringBuilder();
            s.append("_");
            if (templateBindings.size() > 0) {
                int i = 0;
                while (i < templateBindings.size()) {
                    if (i > 0) {
                        s.append("___");
                    }
                    Type element = templateBindings.get(i);
                    this.getTemplateBindingsName(s, element);
                    ++i;
                }
            }
            name2 = s.toString();
            this.templateBindingsNames.put(templateBindings, name2);
        }
        return name2;
    }

    private void getTemplateBindingsName(@NonNull StringBuilder s, @NonNull Type element) {
        List templateBindings;
        TemplateParameter templateParameter = element.isTemplateParameter();
        if (templateParameter != null) {
            TemplateableElement template = templateParameter.getOwningSignature().getOwningElement();
            if (template instanceof Operation) {
                s.append(AbstractGenModelHelper.encodeName((NamedElement)ClassUtil.nonNullModel((Object)((Operation)template).getOwningClass())));
                s.append("_");
            }
            s.append(AbstractGenModelHelper.encodeName((NamedElement)ClassUtil.nonNullModel((Object)((NamedElement)template))));
            s.append("_");
        }
        s.append(AbstractGenModelHelper.encodeName((NamedElement)element));
        if (element instanceof TemplateableElement && (templateBindings = ((TemplateableElement)element).getOwnedBindings()).size() > 0) {
            s.append("_");
            for (TemplateBinding templateBinding : templateBindings) {
                for (TemplateParameterSubstitution templateParameterSubstitution : templateBinding.getOwnedSubstitutions()) {
                    s.append("_");
                    this.getTemplateBindingsName(s, (Type)ClassUtil.nonNullModel((Object)templateParameterSubstitution.getActual()));
                }
            }
            s.append("__");
        }
        if (element instanceof LambdaType) {
            LambdaType lambdaType = (LambdaType)element;
            s.append("_");
            this.getTemplateBindingsName(s, (Type)ClassUtil.nonNullModel((Object)lambdaType.getContextType()));
            for (Type type : lambdaType.getParameterType()) {
                assert (type != null);
                s.append("_");
                this.getTemplateBindingsName(s, type);
            }
            s.append("_");
            this.getTemplateBindingsName(s, (Type)ClassUtil.nonNullModel((Object)lambdaType.getResultType()));
        }
    }

    protected @NonNull Boolean hasEcore(@NonNull Property property) {
        Class owningType = property.getOwningClass();
        if (owningType == null) {
            return false;
        }
        String typeName = owningType.getName();
        if (typeName == null) {
            return false;
        }
        GenClass genClass = (GenClass)OCLinEcoreTablesUtils.getNamedElement1(this.genPackage.getGenClasses(), typeName);
        if (genClass == null) {
            return false;
        }
        String propertyName = property.getName();
        if (propertyName == null) {
            return false;
        }
        Object genFeature = OCLinEcoreTablesUtils.getNamedElement2(genClass.getAllGenFeatures(), propertyName);
        if (genFeature == null) {
            return false;
        }
        return true;
    }

    protected @NonNull Boolean hasSharedLibrary() {
        PrimitiveType booleanType;
        Package libraryPackage;
        Package thisPackage = this.getPivotPackage(this.genPackage);
        if (thisPackage != (libraryPackage = (booleanType = this.standardLibrary.getBooleanType()).getOwningPackage())) {
            return true;
        }
        return false;
    }

    protected boolean isElementType(@NonNull CompleteClass completeClass, @NonNull Type elementType, @NonNull VoidType oclVoidType) {
        return completeClass.conformsTo(elementType) && !completeClass.conformsTo((Type)oclVoidType);
    }

    protected boolean isLambdaParameterList(@NonNull ParametersId parametersId) {
        for (TypeId typeId : parametersId) {
            if (!(typeId instanceof LambdaTypeId)) continue;
            return true;
        }
        return false;
    }

    protected boolean isProperty(@NonNull Property prop) {
        if (this.hasEcore(prop).booleanValue()) {
            return true;
        }
        Property opposite = prop.getOpposite();
        return opposite != null && this.hasEcore(opposite) != false;
    }

    protected @NonNull Boolean hasEcore(@NonNull Type type) {
        String typeName = type.getName();
        if (typeName != null) {
            GenClass genClass = (GenClass)OCLinEcoreTablesUtils.getNamedElement1(this.genPackage.getGenClasses(), typeName);
            if (genClass != null) {
                return true;
            }
            GenEnum genEnum = (GenEnum)OCLinEcoreTablesUtils.getNamedElement1(this.genPackage.getGenEnums(), typeName);
            if (genEnum != null) {
                return true;
            }
        }
        return false;
    }

    protected void mergeLibrary(@NonNull Package primaryPackage) {
        List primaryTypes = primaryPackage.getOwnedClasses();
        for (Library library : this.metamodelManager.getLibraries()) {
            Class primaryType;
            HashMap<Class, Class> typeMap = new HashMap<Class, Class>();
            ArrayList libraryTypes = new ArrayList(library.getOwnedClasses());
            for (Class secondaryType : libraryTypes) {
                primaryType = (Class)NameUtil.getNameable((Iterable)primaryTypes, (String)secondaryType.getName());
                if (primaryType != null) {
                    typeMap.put(secondaryType, primaryType);
                    continue;
                }
                primaryTypes.add(secondaryType);
            }
            for (Class secondaryType : libraryTypes) {
                primaryType = (Class)typeMap.get(secondaryType);
                if (primaryType == null) continue;
                List primarySuperClasses = primaryType.getSuperClasses();
                for (Class secondarySuperClass : secondaryType.getSuperClasses()) {
                    Class primarySuperClass = (Class)typeMap.get(secondarySuperClass);
                    if (primarySuperClass == null) {
                        primarySuperClasses.add(secondarySuperClass);
                        continue;
                    }
                    if (primarySuperClasses.contains(primarySuperClass)) continue;
                    primarySuperClasses.add(primarySuperClass);
                }
                primaryType.getOwnedOperations().addAll(secondaryType.getOwnedOperations());
                primaryType.getOwnedProperties().addAll(secondaryType.getOwnedProperties());
            }
        }
        for (Class primaryType : primaryTypes) {
            List primarySuperClasses = primaryType.getSuperClasses();
            Type classType = (Type)NameUtil.getNameable((Iterable)primarySuperClasses, (String)"Class");
            Type metaclass = (Type)NameUtil.getNameable((Iterable)primarySuperClasses, (String)"Classifier");
            if (classType == null || metaclass == null) continue;
            primarySuperClasses.remove(classType);
        }
    }

    public static class CodeGenString {
        private final @NonNull StringBuilder s = new StringBuilder();
        private @NonNull Map<@NonNull String, @Nullable String> classReferences = new HashMap<String, String>();
        protected final @NonNull Map<Type, String> typeNameMap = new HashMap<Type, String>();
        protected final @NonNull Set<String> typeNameUse = new HashSet<String>();

        public void append(@Nullable String string) {
            if (string != null) {
                this.s.append(string);
            }
        }

        public void addClassReference(@NonNull java.lang.Class<?> referencedClass) {
            @NonNull String simpleName = referencedClass.getSimpleName();
            @NonNull String fullName = referencedClass.getName();
            this.addClassReference(simpleName, fullName);
        }

        protected String addClassReference(@NonNull String simpleName, @NonNull String fullName) {
            return this.classReferences.put(simpleName, fullName);
        }

        public void appendClassReference(@NonNull java.lang.Class<?> referencedClass) {
            this.s.append(referencedClass.getSimpleName());
            this.addClassReference(referencedClass);
        }

        public void appendClassReference(@NonNull String referencedClass) {
            String key = referencedClass;
            int i = referencedClass.lastIndexOf(".");
            if (i > 0) {
                String trimmedKey;
                key = trimmedKey = referencedClass.substring(i + 1);
                this.s.append(key);
            } else {
                this.s.append(referencedClass);
            }
            this.addClassReference(key, referencedClass);
        }

        public void appendName(@NonNull NamedElement namedElement) {
            this.s.append(AbstractGenModelHelper.encodeName(namedElement));
        }

        public void appendParameterName(@NonNull NamedElement namedElement) {
            this.s.append(AbstractGenModelHelper.encodeName(namedElement));
        }

        public void appendScopedTypeName(@NonNull Type theType) {
            this.s.append("_" + AbstractGenModelHelper.encodeName((NamedElement)theType));
        }

        protected void appendString(@NonNull String string) {
            @NonNull String javaString = Strings.convertToJavaString((String)string);
            this.s.append("\"");
            this.s.append(javaString);
            this.s.append("\"");
        }

        public void appendUnscopedTypeName(@NonNull PivotMetamodelManager metamodelManager, @NonNull Type theType) {
            this.s.append(this.getTypeName(metamodelManager.getPrimaryType(theType)));
        }

        private @NonNull String getTypeName(@NonNull Type theType) {
            String name = this.typeNameMap.get(theType);
            if (name != null) {
                return name;
            }
            name = AbstractGenModelHelper.encodeName((NamedElement)theType);
            if (this.typeNameUse.contains(name)) {
                int index = 1;
                String candidateName = String.valueOf(name) + '_' + index;
                while (this.typeNameUse.contains(String.valueOf(name) + '_' + index)) {
                    ++index;
                }
                name = candidateName;
            }
            this.typeNameMap.put(theType, name);
            this.typeNameUse.add(name);
            return name;
        }

        public @NonNull List<String> getClassReferences() {
            ArrayList<String> names = new ArrayList<String>(this.classReferences.values());
            Collections.sort(names);
            return names;
        }

        public @NonNull String rewriteManagedImports(@NonNull String source) {
            return ImportUtils.resolveImports(source, this.classReferences, true);
        }

        public @NonNull String toString() {
            return this.s.toString();
        }
    }

    public class DeclareParameterTypeVisitor
    extends AbstractExtendingVisitor<Object, Object> {
        protected DeclareParameterTypeVisitor(Object context) {
            super(context);
        }

        public @Nullable Object visiting(@NonNull Visitable visitable) {
            throw new UnsupportedOperationException("Unsupported DeclareParameterTypeVisitor for " + visitable.eClass().getName());
        }

        public @Nullable Object visitClass(@NonNull Class type) {
            type.accept((Visitor)OCLinEcoreTablesUtils.this.emitQualifiedLiteralVisitor);
            return null;
        }

        public @Nullable Object visitCollectionType(@NonNull CollectionType type) {
            OCLinEcoreTablesUtils.this.s.append("new ");
            OCLinEcoreTablesUtils.this.s.appendClassReference(ExecutorSpecializedType.class);
            OCLinEcoreTablesUtils.this.s.append("(");
            OCLinEcoreTablesUtils.this.s.appendString((String)ClassUtil.nonNullModel((Object)type.getName()));
            OCLinEcoreTablesUtils.this.s.append(", ");
            type.getElementType().accept((Visitor)this);
            OCLinEcoreTablesUtils.this.s.append(")");
            return null;
        }

        public @Nullable Object visitLambdaType(@NonNull LambdaType lambdaType) {
            OCLinEcoreTablesUtils.this.s.append("new ");
            OCLinEcoreTablesUtils.this.s.appendClassReference(ExecutorLambdaType.class);
            OCLinEcoreTablesUtils.this.s.append("(");
            OCLinEcoreTablesUtils.this.s.appendString((String)ClassUtil.nonNullModel((Object)lambdaType.getName()));
            OCLinEcoreTablesUtils.this.s.append(", ");
            lambdaType.getContextType().accept((Visitor)this);
            for (Type parameterType : lambdaType.getParameterType()) {
                OCLinEcoreTablesUtils.this.s.append(", ");
                parameterType.accept((Visitor)this);
            }
            OCLinEcoreTablesUtils.this.s.append(")");
            return null;
        }

        public @Nullable Object visitMapType(@NonNull MapType type) {
            OCLinEcoreTablesUtils.this.s.append("new ");
            OCLinEcoreTablesUtils.this.s.appendClassReference(ExecutorSpecializedType.class);
            OCLinEcoreTablesUtils.this.s.append("(");
            OCLinEcoreTablesUtils.this.s.appendString((String)ClassUtil.nonNullModel((Object)type.getName()));
            OCLinEcoreTablesUtils.this.s.append(", ");
            type.getKeyType().accept((Visitor)this);
            OCLinEcoreTablesUtils.this.s.append(", ");
            type.getValueType().accept((Visitor)this);
            OCLinEcoreTablesUtils.this.s.append(")");
            return null;
        }

        public @Nullable Object visitTupleType(@NonNull TupleType tupleType) {
            OCLinEcoreTablesUtils.this.s.append("new ");
            OCLinEcoreTablesUtils.this.s.appendClassReference(ExecutorTupleType.class);
            OCLinEcoreTablesUtils.this.s.append("(");
            OCLinEcoreTablesUtils.this.s.appendString((String)ClassUtil.nonNullModel((Object)tupleType.getName()));
            OCLinEcoreTablesUtils.this.s.append(", ");
            for (Property part : tupleType.getOwnedProperties()) {
                OCLinEcoreTablesUtils.this.s.append(", ");
                part.getType().accept((Visitor)this);
            }
            OCLinEcoreTablesUtils.this.s.append(")");
            return null;
        }

        public @Nullable Object visitTemplateParameter(@NonNull TemplateParameter type) {
            TemplateableElement template = type.getOwningSignature().getOwningElement();
            if (template instanceof Class) {
                Class containerType = (Class)template;
                assert (containerType != null);
                String prefix = OCLinEcoreTablesUtils.this.getQualifiedTablesClassName(containerType);
                if (prefix.length() <= 0) {
                    OCLinEcoreTablesUtils.this.s.append("(");
                    OCLinEcoreTablesUtils.this.s.appendClassReference(Type.class);
                    OCLinEcoreTablesUtils.this.s.append(")null/*containerType._package.name/");
                } else {
                    OCLinEcoreTablesUtils.this.s.appendClassReference(prefix);
                    OCLinEcoreTablesUtils.this.s.append(".TypeParameters.");
                    OCLinEcoreTablesUtils.this.s.appendScopedTypeName((Type)containerType);
                    OCLinEcoreTablesUtils.this.s.append("_");
                    OCLinEcoreTablesUtils.this.s.appendParameterName((NamedElement)type);
                }
            } else if (template instanceof Operation) {
                Operation containerOperation = (Operation)template;
                Class containerType = containerOperation.getOwningClass();
                assert (containerType != null);
                String prefix = OCLinEcoreTablesUtils.this.getQualifiedTablesClassName(containerType);
                if (prefix.length() <= 0) {
                    OCLinEcoreTablesUtils.this.s.append("(");
                    OCLinEcoreTablesUtils.this.s.appendClassReference(Type.class);
                    OCLinEcoreTablesUtils.this.s.append(")null/*containerOperation.owningType._package.name/");
                } else {
                    OCLinEcoreTablesUtils.this.s.appendClassReference(prefix);
                    OCLinEcoreTablesUtils.this.s.append(".TypeParameters._");
                    containerOperation.accept((Visitor)OCLinEcoreTablesUtils.this.emitLiteralVisitor);
                    OCLinEcoreTablesUtils.this.s.append("_");
                    OCLinEcoreTablesUtils.this.s.appendParameterName((NamedElement)type);
                }
            }
            return null;
        }
    }

    public class EmitLiteralVisitor
    extends AbstractExtendingVisitor<Object, Object> {
        protected EmitLiteralVisitor(Object context) {
            super(context);
        }

        public @Nullable Object visiting(@NonNull Visitable visitable) {
            throw new UnsupportedOperationException("Unsupported EmitLiteralVisitor for " + visitable.eClass().getName());
        }

        public @Nullable Object visitClass(@NonNull Class type) {
            OCLinEcoreTablesUtils.this.s.append("Types.");
            OCLinEcoreTablesUtils.this.s.appendScopedTypeName((Type)type);
            return null;
        }

        public @Nullable Object visitCollectionType(@NonNull CollectionType type) {
            CollectionType unspecializedType = (CollectionType)PivotUtil.getUnspecializedTemplateableElement((TemplateableElement)type);
            OCLinEcoreTablesUtils.this.s.append("Types.");
            OCLinEcoreTablesUtils.this.s.appendScopedTypeName((Type)unspecializedType);
            return null;
        }

        public @Nullable Object visitConstraint(@NonNull Constraint constraint) {
            Type type = (Type)ClassUtil.nonNullModel((Object)((Type)constraint.eContainer()));
            OCLinEcoreTablesUtils.this.s.appendScopedTypeName(type);
            OCLinEcoreTablesUtils.this.s.append("__");
            OCLinEcoreTablesUtils.this.s.append(NameQueries.getUniqueText((Element)type, constraint));
            return null;
        }

        public @Nullable Object visitEnumerationLiteral(@NonNull EnumerationLiteral enumerationLiteral) {
            Enumeration enumeration = (Enumeration)ClassUtil.nonNullModel((Object)enumerationLiteral.getOwningEnumeration());
            OCLinEcoreTablesUtils.this.s.append("EnumerationLiterals.");
            OCLinEcoreTablesUtils.this.s.appendScopedTypeName((Type)enumeration);
            OCLinEcoreTablesUtils.this.s.append("__");
            OCLinEcoreTablesUtils.this.s.appendName((NamedElement)enumerationLiteral);
            return null;
        }

        public @Nullable Object visitMapType(@NonNull MapType type) {
            MapType unspecializedType = (MapType)PivotUtil.getUnspecializedTemplateableElement((TemplateableElement)type);
            OCLinEcoreTablesUtils.this.s.append("Types.");
            OCLinEcoreTablesUtils.this.s.appendScopedTypeName((Type)unspecializedType);
            return null;
        }

        public @Nullable Object visitOperation(@NonNull Operation operation) {
            OCLinEcoreTablesUtils.this.s.appendScopedTypeName((Type)ClassUtil.nonNullModel((Object)operation.getOwningClass()));
            OCLinEcoreTablesUtils.this.s.append("__");
            OCLinEcoreTablesUtils.this.s.appendName((NamedElement)operation);
            return null;
        }

        public @Nullable Object visitPackage(@NonNull Package pkge) {
            OCLinEcoreTablesUtils.this.s.append("_");
            OCLinEcoreTablesUtils.this.s.appendName((NamedElement)pkge);
            return null;
        }

        public @Nullable Object visitProperty(@NonNull Property property) {
            Property opposite;
            OCLinEcoreTablesUtils.this.s.appendScopedTypeName((Type)ClassUtil.nonNullModel((Object)property.getOwningClass()));
            OCLinEcoreTablesUtils.this.s.append("__");
            OCLinEcoreTablesUtils.this.s.appendName((NamedElement)property);
            if (property.isIsImplicit() && (opposite = property.getOpposite()) != null) {
                OCLinEcoreTablesUtils.this.s.append("__");
                OCLinEcoreTablesUtils.this.s.appendName((NamedElement)opposite);
            }
            return null;
        }

        public @Nullable Object visitTemplateParameter(@NonNull TemplateParameter type) {
            OCLinEcoreTablesUtils.this.s.append("null");
            return null;
        }
    }

    public class EmitQualifiedLiteralVisitor
    extends EmitLiteralVisitor {
        protected EmitQualifiedLiteralVisitor(Object context) {
            super(context);
        }

        @Override
        public @Nullable Object visiting(@NonNull Visitable visitable) {
            throw new UnsupportedOperationException("Unsupported EmitQualifiedLiteralVisitor for " + visitable.eClass().getName());
        }

        @Override
        public @Nullable Object visitClass(@NonNull Class type) {
            OCLinEcoreTablesUtils.this.s.appendClassReference(OCLinEcoreTablesUtils.this.getQualifiedTablesClassName(type));
            OCLinEcoreTablesUtils.this.s.append(".Types.");
            OCLinEcoreTablesUtils.this.s.appendScopedTypeName((Type)type);
            return null;
        }

        @Override
        public @Nullable Object visitCollectionType(@NonNull CollectionType object) {
            CollectionType unspecializedObject = (CollectionType)PivotUtil.getUnspecializedTemplateableElement((TemplateableElement)object);
            OCLinEcoreTablesUtils.this.s.appendClassReference(OCLinEcoreTablesUtils.this.getQualifiedTablesClassName((Class)unspecializedObject));
            OCLinEcoreTablesUtils.this.s.append(".Types.");
            OCLinEcoreTablesUtils.this.s.appendScopedTypeName((Type)unspecializedObject);
            return null;
        }

        @Override
        public @Nullable Object visitEnumerationLiteral(@NonNull EnumerationLiteral enumerationLiteral) {
            Enumeration enumeration = (Enumeration)ClassUtil.nonNullModel((Object)enumerationLiteral.getOwningEnumeration());
            OCLinEcoreTablesUtils.this.s.appendClassReference(OCLinEcoreTablesUtils.this.getQualifiedTablesClassName((Class)enumeration));
            OCLinEcoreTablesUtils.this.s.append(".EnumerationLiterals.");
            OCLinEcoreTablesUtils.this.s.appendScopedTypeName((Type)enumeration);
            OCLinEcoreTablesUtils.this.s.append("__");
            OCLinEcoreTablesUtils.this.s.appendName((NamedElement)enumerationLiteral);
            return null;
        }

        @Override
        public @Nullable Object visitMapType(@NonNull MapType object) {
            MapType unspecializedObject = (MapType)PivotUtil.getUnspecializedTemplateableElement((TemplateableElement)object);
            OCLinEcoreTablesUtils.this.s.appendClassReference(OCLinEcoreTablesUtils.this.getQualifiedTablesClassName((Class)unspecializedObject));
            OCLinEcoreTablesUtils.this.s.append(".Types.");
            OCLinEcoreTablesUtils.this.s.appendScopedTypeName((Type)unspecializedObject);
            return null;
        }

        @Override
        public @Nullable Object visitOperation(@NonNull Operation operation) {
            Class type = (Class)ClassUtil.nonNullModel((Object)operation.getOwningClass());
            OCLinEcoreTablesUtils.this.s.appendClassReference(OCLinEcoreTablesUtils.this.getQualifiedTablesClassName(type));
            OCLinEcoreTablesUtils.this.s.append(".Operations.");
            return super.visitOperation(operation);
        }

        @Override
        public @Nullable Object visitProperty(@NonNull Property property) {
            Class type = (Class)ClassUtil.nonNullModel((Object)property.getOwningClass());
            OCLinEcoreTablesUtils.this.s.appendClassReference(OCLinEcoreTablesUtils.this.getQualifiedTablesClassName(type));
            OCLinEcoreTablesUtils.this.s.append(".Properties.");
            return super.visitProperty(property);
        }

        public @Nullable Object visitTupleType(@NonNull TupleType type) {
            OCLinEcoreTablesUtils.this.s.appendClassReference(OCLinEcoreTablesUtils.this.getQualifiedTablesClassName((Class)type));
            OCLinEcoreTablesUtils.this.s.append(".tuple_type_");
            OCLinEcoreTablesUtils.this.s.appendUnscopedTypeName(OCLinEcoreTablesUtils.this.metamodelManager, (Type)type);
            return null;
        }
    }
}

