/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.emf.validation.validity.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.emf.validation.validity.AbstractNode;
import org.eclipse.ocl.examples.emf.validation.validity.Result;
import org.eclipse.ocl.examples.emf.validation.validity.ValidityPackage;
import org.eclipse.ocl.examples.emf.validation.validity.utilities.IVisibilityFilter;

public abstract class AbstractNodeImpl
extends MinimalEObjectImpl.Container
implements AbstractNode {
    protected static final boolean ENABLED_EDEFAULT = true;
    protected boolean enabled = true;
    protected static final boolean GRAYED_EDEFAULT = false;
    protected boolean grayed = false;
    protected static final boolean VISIBLE_EDEFAULT = true;
    protected boolean visible = true;
    protected static final String LABEL_EDEFAULT = "";
    protected String label = "";
    protected Result worstResult;
    public static final @NonNull AbstractNode @NonNull [] NO_CHILDREN = new AbstractNode[0];
    private @NonNull AbstractNode @NonNull [] visibleChildren = NO_CHILDREN;

    protected AbstractNodeImpl() {
    }

    protected EClass eStaticClass() {
        return ValidityPackage.Literals.ABSTRACT_NODE;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean newEnabled) {
        this.enabled = newEnabled;
    }

    @Override
    public boolean isGrayed() {
        return this.grayed;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String newLabel) {
        this.label = newLabel;
    }

    @Override
    public Result getWorstResult() {
        return this.worstResult;
    }

    public void setWorstResultGen(Result newWorstResult) {
        this.worstResult = newWorstResult;
    }

    @Override
    public void setWorstResult(Result newWorstResult) {
        if (newWorstResult != this.worstResult) {
            AbstractNode parent;
            Result oldWorstResult = this.worstResult;
            this.setWorstResultGen(newWorstResult);
            if (this.isWorstResult(newWorstResult, oldWorstResult) && (parent = this.getParent()) != null && this.isWorstResult(newWorstResult, parent.getWorstResult())) {
                parent.setWorstResult(newWorstResult);
            }
        }
    }

    private boolean isWorstResult(Result newWorstResult, Result oldWorstResult) {
        if (newWorstResult == null) {
            return false;
        }
        if (oldWorstResult == null) {
            return true;
        }
        return newWorstResult.getSeverity().ordinal() > oldWorstResult.getSeverity().ordinal();
    }

    @Override
    public abstract AbstractNode getParent();

    @Override
    public abstract @NonNull EList<? extends AbstractNode> getChildren();

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.isEnabled();
            }
            case 1: {
                return this.isGrayed();
            }
            case 2: {
                return this.isVisible();
            }
            case 3: {
                return this.getLabel();
            }
            case 4: {
                return this.getWorstResult();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setEnabled((Boolean)newValue);
                return;
            }
            case 3: {
                this.setLabel((String)newValue);
                return;
            }
            case 4: {
                this.setWorstResult((Result)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setEnabled(true);
                return;
            }
            case 3: {
                this.setLabel(LABEL_EDEFAULT);
                return;
            }
            case 4: {
                this.setWorstResult(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return !this.enabled;
            }
            case 1: {
                return this.grayed;
            }
            case 2: {
                return !this.visible;
            }
            case 3: {
                return LABEL_EDEFAULT == null ? this.label != null : !LABEL_EDEFAULT.equals(this.label);
            }
            case 4: {
                return this.worstResult != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        return String.valueOf(this.label);
    }

    @Override
    public int countVisibleChildren() {
        int allChildren = 1;
        AbstractNode[] abstractNodeArray = this.visibleChildren;
        int n = this.visibleChildren.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractNode child = abstractNodeArray[n2];
            allChildren += child.countVisibleChildren();
            ++n2;
        }
        return allChildren;
    }

    @Override
    public void getGrayedElements(@NonNull List<AbstractNode> grayedNodes) {
        if (this.grayed) {
            grayedNodes.add(this);
        }
        AbstractNode[] abstractNodeArray = this.visibleChildren;
        int n = this.visibleChildren.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractNode child = abstractNodeArray[n2];
            child.getGrayedElements(grayedNodes);
            ++n2;
        }
    }

    @Override
    public @NonNull AbstractNode @NonNull [] getVisibleChildren() {
        return this.visibleChildren;
    }

    @Override
    public int refreshGrayed() {
        boolean isEnabled = this.enabled;
        boolean isDisabled = !isEnabled;
        AbstractNode[] abstractNodeArray = this.visibleChildren;
        int n = this.visibleChildren.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractNode child = abstractNodeArray[n2];
            int childStatus = child.refreshGrayed();
            if (childStatus >= 0) {
                isEnabled = true;
            }
            if (childStatus <= 0) {
                isDisabled = true;
            }
            ++n2;
        }
        if (!isDisabled) {
            this.grayed = false;
            return 1;
        }
        if (!isEnabled) {
            this.grayed = false;
            return -1;
        }
        this.grayed = true;
        return 0;
    }

    @Override
    public boolean refreshVisibleChildren(@NonNull Iterable<IVisibilityFilter> visibilityFilters) {
        ArrayList<? extends AbstractNode> children = new ArrayList<AbstractNode>((Collection<? extends AbstractNode>)this.getChildren());
        ArrayList<AbstractNode> list = new ArrayList<AbstractNode>(children.size());
        for (AbstractNode abstractNode : children) {
            if (!abstractNode.refreshVisibleChildren(visibilityFilters)) continue;
            list.add(abstractNode);
        }
        for (IVisibilityFilter iVisibilityFilter : visibilityFilters) {
            if (iVisibilityFilter.isVisible(this)) continue;
            this.visibleChildren = NO_CHILDREN;
            this.visible = false;
            return false;
        }
        @NonNull AbstractNode @NonNull [] abstractNodeArray = list.toArray(new AbstractNode[list.size()]);
        this.visibleChildren = abstractNodeArray;
        this.visible = true;
        return true;
    }
}

