/*
 * Decompiled with CFR 0.152.
 */
package codegen.company.util;

import codegen.company.Bug418716;
import codegen.company.CodegencompanyPackage;
import codegen.company.Company;
import codegen.company.CompanySizeKind;
import codegen.company.Employee;
import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;

public class CodegencompanyValidator
extends EObjectValidator {
    public static final CodegencompanyValidator INSTANCE = new CodegencompanyValidator();
    public static final String DIAGNOSTIC_SOURCE = "codegen.company";
    public static final int COMPANY__DUMMY_INVARIANT = 1;
    public static final int EMPLOYEE__NO_MANAGER_IMPLIES_DIRECT_REPORTS = 2;
    public static final int EMPLOYEE__MUST_HAVE_NAME = 3;
    public static final int EMPLOYEE__MUST_HAVE_NON_EMPTY_NAME = 4;
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 4;
    protected static final int DIAGNOSTIC_CODE_COUNT = 4;

    protected EPackage getEPackage() {
        return CodegencompanyPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateCompany((Company)value, diagnostics, context);
            }
            case 1: {
                return this.validateEmployee((Employee)value, diagnostics, context);
            }
            case 2: {
                return this.validateBug418716((Bug418716)value, diagnostics, context);
            }
            case 3: {
                return this.validateCompanySizeKind((CompanySizeKind)((Object)value), diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateCompany(Company company, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(company, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(company, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(company, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(company, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(company, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(company, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(company, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(company, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(company, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateCompany_dummyInvariant(company, diagnostics, context);
        }
        return result;
    }

    public boolean validateCompany_dummyInvariant(Company company, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return company.dummyInvariant(diagnostics, context);
    }

    public boolean validateEmployee(Employee employee, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(employee, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(employee, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(employee, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(employee, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(employee, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(employee, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(employee, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(employee, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(employee, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateEmployee_mustHaveName(employee, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateEmployee_mustHaveNonEmptyName(employee, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateEmployee_noManagerImpliesDirectReports(employee, diagnostics, context);
        }
        return result;
    }

    public boolean validateEmployee_mustHaveName(Employee employee, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return employee.mustHaveName(diagnostics, context);
    }

    public boolean validateEmployee_mustHaveNonEmptyName(Employee employee, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return employee.mustHaveNonEmptyName(diagnostics, context);
    }

    public boolean validateEmployee_noManagerImpliesDirectReports(Employee employee, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return employee.noManagerImpliesDirectReports(diagnostics, context);
    }

    public boolean validateBug418716(Bug418716 bug418716, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(bug418716, diagnostics, context);
    }

    public boolean validateCompanySizeKind(CompanySizeKind companySizeKind, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

