/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.tests;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EValidatorRegistryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.common.internal.options.CommonOptions;
import org.eclipse.ocl.ecore.delegate.OCLDelegateDomain;
import org.eclipse.ocl.examples.pivot.tests.AbstractValidateTests;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.internal.resource.OCLASResourceFactory;
import org.eclipse.ocl.pivot.internal.resource.ProjectMap;
import org.eclipse.ocl.pivot.internal.validation.EcoreOCLEValidator;
import org.eclipse.ocl.pivot.messages.PivotMessages;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.uml.UMLStandaloneSetup;
import org.eclipse.ocl.pivot.uml.internal.es2as.UML2AS;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.LabelUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.utilities.StringUtil;
import org.eclipse.ocl.xtext.base.utilities.ElementUtil;
import org.eclipse.ocl.xtext.basecs.ModelElementCS;
import org.eclipse.ocl.xtext.completeocl.utilities.CompleteOCLLoader;
import org.eclipse.ocl.xtext.completeocl.validation.CompleteOCLEObjectValidator;
import org.eclipse.ocl.xtext.oclinecore.validation.OCLinEcoreEObjectValidator;
import org.eclipse.uml2.uml.Class;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.junit.After;
import org.junit.Before;

public class ValidateTests
extends AbstractValidateTests {
    public static @NonNull List<Diagnostic> assertEcoreOCLValidationDiagnostics(@Nullable OCL ocl, @NonNull String prefix, @NonNull Resource resource, String ... messages) {
        Map validationContext = LabelUtil.createDefaultContext((EValidator)Diagnostician.INSTANCE);
        if (ocl != null) {
            validationContext.put(OCL.class, ocl);
        }
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        for (EObject eObject : resource.getContents()) {
            EValidatorRegistryImpl registry = new EValidatorRegistryImpl();
            registry.put((Object)EcorePackage.eINSTANCE, (Object)EcoreOCLEValidator.INSTANCE);
            Diagnostician dignostician = new Diagnostician((EValidator.Registry)registry);
            Diagnostic diagnostic = dignostician.validate(eObject, validationContext);
            diagnostics.addAll(diagnostic.getChildren());
        }
        return ValidateTests.assertDiagnostics(prefix, diagnostics, messages);
    }

    public Resource doLoadEcore(OCL ocl, String stem) throws IOException {
        String ecoreName = String.valueOf(stem) + ".ecore";
        URI ecoreURI = this.getProjectFileURI(ecoreName);
        Resource ecoreResource = ocl.getResourceSet().getResource(ecoreURI, true);
        return ecoreResource;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void testValidate_Bug366229_oclinecore() throws IOException, InterruptedException {
        OCL ocl1 = this.createOCL();
        OCL ocl2 = this.createOCL();
        Resource ecoreResource = this.doLoadOCLinEcore(ocl1, "Bug366229");
        ocl2.getResourceSet().getResources().add((Object)ecoreResource);
        ocl1.dispose();
        EPackage overloadsPackage = (EPackage)ecoreResource.getContents().get(0);
        EObject testInstance = this.eCreate(overloadsPackage, "SubClass");
        EValidator.Registry.INSTANCE.put((Object)overloadsPackage, (Object)EObjectValidator.INSTANCE);
        ValidateTests.checkValidationDiagnostics(testInstance, 4, new String[0]);
        ocl2.dispose();
    }

    public void testValidate_Bug418551_ecore() throws IOException, InterruptedException {
        OCL ocl = this.createOCL();
        Resource ecoreResource = this.doLoadEcore(ocl, "Bug418551");
        EPackage temp = (EPackage)ecoreResource.getContents().get(0);
        EClass tester = (EClass)temp.getEClassifier("Tester");
        EOperation badOp = (EOperation)NameUtil.getENamedElement((Iterable)tester.getEOperations(), (String)"badOp");
        ValidateTests.checkValidationDiagnostics((EObject)temp, 4, new String[0]);
        ValidateTests.assertEcoreOCLValidationDiagnostics(ocl, "Ecore Load", ecoreResource, StringUtil.bind((String)"Missing ''{0}'' delegate for ''{1}''", (Object[])new Object[]{"invocationDelegates", LabelUtil.getLabel((Object)temp)}), StringUtil.bind((String)"Missing ''{0}'' delegate for ''{1}''", (Object[])new Object[]{"settingDelegates", LabelUtil.getLabel((Object)temp)}), StringUtil.bind((String)"Missing ''{0}'' delegate for ''{1}''", (Object[])new Object[]{"validationDelegates", LabelUtil.getLabel((Object)temp)}), StringUtil.bind((String)"Missing ''constraints'' annotation entry for ''{0}'' in ''{1}''", (Object[])new Object[]{"extraInvariant", LabelUtil.getLabel((Object)tester)}), StringUtil.bind((String)"Extra ''constraints'' annotation entry for ''{0}'' in ''{1}''", (Object[])new Object[]{"missingInvariant", LabelUtil.getLabel((Object)tester)}), StringUtil.bind((String)"Incompatible type ''{0}'' for ''{1}'' ''{2}''", (Object[])new Object[]{"String", LabelUtil.getLabel((Object)badOp), "body"}), StringUtil.bind((String)"Incompatible type ''{0}'' for ''{1}'' ''{2}''", (Object[])new Object[]{"Integer", LabelUtil.getLabel((Object)badOp), "pre"}), StringUtil.bind((String)"Incompatible type ''{0}'' for ''{1}'' ''{2}''", (Object[])new Object[]{"Integer", LabelUtil.getLabel((Object)badOp), "post"}), StringUtil.bind((String)"Incompatible type ''{0}'' for ''{1}''", (Object[])new Object[]{"Boolean", LabelUtil.getLabel((Object)tester.getEStructuralFeature("badType"))}), StringUtil.bind((String)"Missing ''derivation'' or ''initial'' detail for ''{0}''", (Object[])new Object[]{LabelUtil.getLabel((Object)tester.getEStructuralFeature("badDetailName"))}), StringUtil.bind((String)"Both ''derivation'' and ''initial'' detail for ''{0}''", (Object[])new Object[]{LabelUtil.getLabel((Object)tester.getEStructuralFeature("derivationAndInitial"))}));
        ocl.dispose();
    }

    public void testValidate_Bug418552_oclinecore() throws IOException, InterruptedException {
        String testDocument = "import ecore : 'http://www.eclipse.org/emf/2002/Ecore#/';\n\npackage temp : Test = 'http://www.eclipse.org/mdt/ocl/oclinecore/tutorial'\n{\n\tclass Tester\n\t{\n\t\tattribute total : ecore::EDoubleObject { derived volatile }\n\t\t{\n\t\t\tderivation: true;\n\t\t}\n\t}\n}\n";
        this.createOCLinEcoreFile("Bug418552.oclinecore", testDocument);
        OCL ocl1 = this.createOCL();
        @NonNull List<Diagnostic> diagnostics = this.doValidateOCLinEcore(ocl1, "Bug418552", StringUtil.bind((String)PivotMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"Property::CompatibleDefaultExpression", "temp::Tester::total"}));
        Object property = diagnostics.get(0).getData().get(0);
        assert (property != null);
        ValidateTests.assertEquals((Object)PivotPackage.Literals.PROPERTY, (Object)((EObject)property).eClass());
        ModelElementCS csElement = ElementUtil.getCsElement((Element)((Element)property));
        ICompositeNode node = NodeModelUtils.getNode((EObject)csElement);
        assert (node != null);
        ValidateTests.assertEquals((int)7, (int)node.getStartLine());
        ValidateTests.assertEquals((int)10, (int)node.getEndLine());
        ocl1.dispose();
    }

    public void testValidate_Pivot_ecore() throws IOException, InterruptedException {
        OCL ocl = OCL.newInstance((ProjectManager)ValidateTests.getProjectMap());
        URI ecoreURI = URI.createPlatformResourceURI((String)"/org.eclipse.ocl.pivot/model/Pivot.ecore", (boolean)true);
        Resource ecoreResource = ocl.getResourceSet().getResource(ecoreURI, true);
        assert (ecoreResource != null);
        ValidateTests.assertEcoreOCLValidationDiagnostics(ocl, "Ecore Load", ecoreResource, new String[0]);
        ocl.dispose();
    }

    public void testValidate_OCL_2_5_oclas() throws IOException, InterruptedException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            ValidateTests.getProjectMap().initializeResourceSet((ResourceSet)resourceSet);
        }
        Resource resource = resourceSet.getResource(URI.createPlatformResourceURI((String)"org.eclipse.ocl.pivot/model-gen/OCL-2.5.oclas", (boolean)true), true);
        ValidateTests.assertNoValidationErrors("Validating", (Resource)ClassUtil.nonNullState((Object)resource));
    }

    public void testValidate_Pivot_oclas() throws IOException, InterruptedException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            ValidateTests.getProjectMap().initializeResourceSet((ResourceSet)resourceSet);
            OCLASResourceFactory.getInstance().configure((ResourceSet)resourceSet);
        }
        Resource resource = resourceSet.getResource(URI.createPlatformResourceURI((String)"org.eclipse.ocl.pivot/model-gen/Pivot.oclas", (boolean)true), true);
        ValidateTests.assertNoValidationErrors("Validating", (Resource)ClassUtil.nonNullState((Object)resource));
    }

    public void testValidate_Validate_completeocl() throws IOException, InterruptedException {
        OCL ocl0 = this.createOCL();
        OCL ocl1 = this.createOCL();
        OCL ocl2 = this.createOCL();
        Resource ecoreResource1 = this.doLoadOCLinEcore(ocl1, "Validate");
        Resource ecoreResource2 = this.doLoadOCLinEcore(ocl2, "Validate");
        EPackage validatePackage1 = (EPackage)ClassUtil.nonNullState((Object)((EPackage)ecoreResource1.getContents().get(0)));
        EPackage validatePackage2 = (EPackage)ClassUtil.nonNullState((Object)((EPackage)ecoreResource2.getContents().get(0)));
        URI oclURI = this.getProjectFileURI("Validate.ocl");
        CompleteOCLEObjectValidator completeOCLEObjectValidator = new CompleteOCLEObjectValidator(validatePackage1, oclURI, ocl0.getEnvironmentFactory());
        EValidator.Registry.INSTANCE.put((Object)validatePackage1, (Object)completeOCLEObjectValidator);
        try {
            EObject testInstance1 = this.eCreate(validatePackage1, "Level3");
            EObject testInstance2 = this.eCreate(validatePackage2, "Level3");
            String template = PivotMessages.ValidationConstraintIsNotSatisfied_ERROR_;
            this.eSet(testInstance1, "ref", "xx");
            this.eSet(testInstance1, "l1", "xx");
            this.eSet(testInstance1, "l2a", "xx");
            this.eSet(testInstance1, "l2b", "xx");
            this.eSet(testInstance1, "l3", "xx");
            this.eSet(testInstance2, "ref", "yy");
            this.eSet(testInstance2, "l1", "yy");
            this.eSet(testInstance2, "l2a", "yy");
            this.eSet(testInstance2, "l2b", "yy");
            this.eSet(testInstance2, "l3", "yy");
            ValidateTests.checkValidationDiagnostics(testInstance1, 2, new String[0]);
            ValidateTests.checkValidationDiagnostics(testInstance2, 2, new String[0]);
            this.eSet(testInstance1, "ref", "xxx");
            this.eSet(testInstance1, "l1", "xxx");
            this.eSet(testInstance1, "l2a", "xxx");
            this.eSet(testInstance1, "l2b", "xxx");
            this.eSet(testInstance1, "l3", "xxx");
            this.eSet(testInstance2, "ref", "yyy");
            this.eSet(testInstance2, "l1", "yyy");
            this.eSet(testInstance2, "l2a", "yyy");
            this.eSet(testInstance2, "l2b", "yyy");
            this.eSet(testInstance2, "l3", "yyy");
            String objectLabel = LabelUtil.getLabel((Object)testInstance1);
            ValidateTests.checkValidationDiagnostics(testInstance1, 2, StringUtil.bind((String)template, (Object[])new Object[]{"Level1::V1", objectLabel}), StringUtil.bind((String)template, (Object[])new Object[]{"Level2a::V2a", objectLabel}), StringUtil.bind((String)template, (Object[])new Object[]{"Level2b::V2b", objectLabel}), StringUtil.bind((String)template, (Object[])new Object[]{"Level3::V3", objectLabel}));
            ValidateTests.checkValidationDiagnostics(testInstance2, 2, new String[0]);
            this.eSet(testInstance1, "ref", "ok");
            this.eSet(testInstance1, "l1", "ok");
            this.eSet(testInstance1, "l2a", "bad");
            this.eSet(testInstance1, "l2b", "ok");
            this.eSet(testInstance1, "l3", "ok");
            this.eSet(testInstance2, "ref", "ok");
            this.eSet(testInstance2, "l1", "ok");
            this.eSet(testInstance2, "l2a", "bad");
            this.eSet(testInstance2, "l2b", "ok");
            this.eSet(testInstance2, "l3", "ok");
            objectLabel = LabelUtil.getLabel((Object)testInstance1);
            ValidateTests.checkValidationDiagnostics(testInstance1, 2, StringUtil.bind((String)template, (Object[])new Object[]{"Level2a::L2a", objectLabel}), StringUtil.bind((String)template, (Object[])new Object[]{"Level2a::V2a", objectLabel}));
            objectLabel = LabelUtil.getLabel((Object)testInstance2);
            ValidateTests.checkValidationDiagnostics(testInstance2, 4, StringUtil.bind((String)"The ''{0}'' constraint is violated on ''{1}''", (Object[])new Object[]{"L2a", "Level3 ok", objectLabel}));
        }
        finally {
            ocl0.dispose();
            ocl1.dispose();
            ocl2.dispose();
            EValidator.Registry.INSTANCE.remove((Object)validatePackage1);
        }
    }

    public void testValidate_Validate_completeocl_loadresource() throws IOException, InterruptedException {
        OCL ocl = this.createOCL();
        CommonOptions.DEFAULT_DELEGATION_MODE.setDefaultValue((Object)"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot");
        ResourceSet resourceSet = ocl.getResourceSet();
        OCLDelegateDomain.initialize((ResourceSet)resourceSet);
        org.eclipse.ocl.pivot.internal.delegate.OCLDelegateDomain.initialize((ResourceSet)resourceSet, (String)"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot");
        URI ecoreURI = this.getTestModelURI("model/OCLinEcoreTutorial.ecore");
        URI xmiURI = this.getTestModelURI("model/OCLinEcoreTutorial.xmi");
        URI oclURI = this.getProjectFileURI("ExtraOCLinEcoreTutorial.ocl");
        String testDocument = "import '" + ecoreURI.toString() + "'\n" + "package tutorial\n" + "context Book\n" + "inv ExactlyOneCopy: copies=1\n" + "endpackage\n";
        this.createOCLinEcoreFile("ExtraOCLinEcoreTutorial.ocl", testDocument);
        Resource resource = (Resource)ClassUtil.nonNullState((Object)resourceSet.getResource(xmiURI, true));
        ValidateTests.assertValidationDiagnostics("Without Complete OCL", resource, StringUtil.bind((String)"The ''{0}'' constraint is violated on ''{1}''", (Object[])new Object[]{"SufficientCopies", "Library lib::Book b2"}), StringUtil.bind((String)"The ''{0}'' constraint is violated on ''{1}''", (Object[])new Object[]{"AtMostTwoLoans", "Library lib::Member m3"}), StringUtil.bind((String)"The ''{0}'' constraint is violated on ''{1}''", (Object[])new Object[]{"UniqueLoans", "Library lib::Member m3"}));
        CompleteOCLLoader helper = new CompleteOCLLoader(ocl.getEnvironmentFactory()){

            protected boolean error(@NonNull String primaryMessage, @Nullable String detailMessage) {
                TestCase.fail((String)(String.valueOf(primaryMessage) + "\n\t" + detailMessage));
                return false;
            }
        };
        ValidateTests.assertTrue((boolean)helper.loadMetamodels());
        ValidateTests.assertTrue((boolean)helper.loadDocument(oclURI));
        helper.installPackages();
        ValidateTests.assertValidationDiagnostics("Without Complete OCL", resource, StringUtil.bind((String)"The ''{0}'' constraint is violated on ''{1}''", (Object[])new Object[]{"SufficientCopies", "Library lib::Book b2"}), StringUtil.bind((String)"The ''{0}'' constraint is violated on ''{1}''", (Object[])new Object[]{"AtMostTwoLoans", "Library lib::Member m3"}), StringUtil.bind((String)"The ''{0}'' constraint is violated on ''{1}''", (Object[])new Object[]{"UniqueLoans", "Library lib::Member m3"}), StringUtil.bind((String)PivotMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"Book::ExactlyOneCopy", "Library lib::Book b2"}));
        helper.dispose();
        ocl.dispose();
    }

    public void testValidate_Validate_completeocl_Bug422583() throws IOException, InterruptedException {
        UMLStandaloneSetup.init();
        CommonOptions.DEFAULT_DELEGATION_MODE.setDefaultValue((Object)"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot");
        OCL ocl = this.createOCL();
        ResourceSet resourceSet = ocl.getResourceSet();
        ProjectMap.initializeURIResourceMap((ResourceSet)resourceSet);
        Map uriMap = resourceSet.getURIConverter().getURIMap();
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            uriMap.putAll(EcorePlugin.computePlatformURIMap((boolean)false));
        }
        UML2AS.initialize((ResourceSet)resourceSet);
        OCLDelegateDomain.initialize((ResourceSet)resourceSet);
        org.eclipse.ocl.pivot.internal.delegate.OCLDelegateDomain.initialize((ResourceSet)resourceSet, (String)"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot");
        URI umlURI = this.getProjectFileURI("Names.uml");
        URI oclURI = this.getProjectFileURI("Bug422583.ocl");
        String testDocument = "import uml : 'http://www.eclipse.org/uml2/5.0.0/UML#/'\npackage uml\n  context Element\n  def: alwaysTrue() : Boolean = true\n  def: rootFalse() : Boolean = false\n  inv IsElement: self.alwaysTrue()\n  context Classifier\n  def: rootFalse() : Boolean = true\n  def: leafFalse() : Boolean = true\n  inv IsClassifier: self.alwaysTrue()\n  inv IsClassifierWrtLeaf: self.leafFalse()\n  context Class\n  def: leafFalse() : Boolean = false\n  inv IsClass: self.alwaysTrue()\n  inv IsClassWrtRoot: self.rootFalse()\n  inv IsClassWrtLeaf: self.leafFalse()\nendpackage\n";
        this.createOCLinEcoreFile("Bug422583.ocl", testDocument);
        Resource resource = (Resource)ClassUtil.nonNullState((Object)resourceSet.getResource(umlURI, true));
        Class uNamed = null;
        TreeIterator tit = resource.getAllContents();
        while (tit.hasNext()) {
            EObject eObject = (EObject)tit.next();
            if (!(eObject instanceof Class) || !"UNamed".equals(((Class)eObject).getName())) continue;
            uNamed = (Class)eObject;
            break;
        }
        assert (uNamed != null);
        ValidateTests.assertValidationDiagnostics("Without Complete OCL", resource, new String[0]);
        CompleteOCLLoader helper = new CompleteOCLLoader(ocl.getEnvironmentFactory()){

            protected boolean error(@NonNull String primaryMessage, @Nullable String detailMessage) {
                TestCase.fail((String)(String.valueOf(primaryMessage) + "\n\t" + detailMessage));
                return false;
            }
        };
        ValidateTests.assertTrue((boolean)helper.loadMetamodels());
        ValidateTests.assertTrue((boolean)helper.loadDocument(oclURI));
        helper.installPackages();
        String objectLabel1 = LabelUtil.getLabel((Object)uNamed);
        ValidateTests.assertValidationDiagnostics("Without Complete OCL", resource, StringUtil.bind((String)PivotMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"Classifier::IsClassifierWrtLeaf", objectLabel1}), StringUtil.bind((String)PivotMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"Class::IsClassWrtLeaf", objectLabel1}));
        helper.dispose();
        ocl.dispose();
    }

    public void testValidate_Validate_oclinecore() throws IOException, InterruptedException {
        OCL ocl1 = this.createOCL();
        Resource ecoreResource = this.doLoadOCLinEcore(ocl1, "Validate");
        ocl1.getEnvironmentFactory().adapt((Notifier)ecoreResource.getResourceSet());
        EPackage validatePackage = (EPackage)ecoreResource.getContents().get(0);
        EObject testInstance = this.eCreate(validatePackage, "Level3");
        this.eSet(testInstance, "ref", "ref");
        this.eSet(testInstance, "l1", "l1");
        this.eSet(testInstance, "l2a", "l2a");
        this.eSet(testInstance, "l2b", "l2b");
        this.eSet(testInstance, "l3", "l3");
        String objectLabel = LabelUtil.getLabel((Object)testInstance);
        EValidator.Registry.INSTANCE.put((Object)validatePackage, (Object)EObjectValidator.INSTANCE);
        try {
            String template = EcorePlugin.INSTANCE.getString("_UI_GenericConstraint_diagnostic");
            ValidateTests.checkValidationDiagnostics(testInstance, 4, StringUtil.bind((String)template, (Object[])new Object[]{"L1", objectLabel}), StringUtil.bind((String)template, (Object[])new Object[]{"L2a", objectLabel}), StringUtil.bind((String)template, (Object[])new Object[]{"L3", objectLabel}));
            EValidator.Registry.INSTANCE.put((Object)validatePackage, (Object)new OCLinEcoreEObjectValidator());
            template = PivotMessages.ValidationConstraintIsNotSatisfied_ERROR_;
            ValidateTests.checkValidationDiagnostics(testInstance, 2, StringUtil.bind((String)template, (Object[])new Object[]{"Level1::L1", objectLabel}), StringUtil.bind((String)template, (Object[])new Object[]{"Level2a::L2a", objectLabel}), StringUtil.bind((String)template, (Object[])new Object[]{"Level3::L3", objectLabel}));
            this.eSet(testInstance, "ref", "ok");
            this.eSet(testInstance, "l1", "ok");
            this.eSet(testInstance, "l2a", "ok");
            this.eSet(testInstance, "l2b", "ok");
            this.eSet(testInstance, "l3", "ok");
            objectLabel = LabelUtil.getLabel((Object)testInstance);
            ValidateTests.checkValidationDiagnostics(testInstance, 2, new String[0]);
            this.eSet(testInstance, "ref", "ok");
            this.eSet(testInstance, "l1", "bad");
            this.eSet(testInstance, "l2a", "ok");
            this.eSet(testInstance, "l2b", "ok");
            this.eSet(testInstance, "l3", "ok");
            objectLabel = LabelUtil.getLabel((Object)testInstance);
            ValidateTests.checkValidationDiagnostics(testInstance, 2, StringUtil.bind((String)template, (Object[])new Object[]{"Level1::L1", objectLabel}));
        }
        finally {
            ocl1.dispose();
            EValidator.Registry.INSTANCE.remove((Object)validatePackage);
        }
    }
}

