/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.test.standalone;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.emf.validation.validity.RootNode;
import org.eclipse.ocl.examples.emf.validation.validity.export.IValidityExporter;
import org.eclipse.ocl.examples.emf.validation.validity.export.ModelExporter;
import org.eclipse.ocl.examples.standalone.StandaloneApplication;
import org.eclipse.ocl.examples.standalone.StandaloneResponse;
import org.eclipse.ocl.examples.test.standalone.StandaloneTestCase;
import org.eclipse.ocl.examples.validity.locator.AbstractPivotConstraintLocator;
import org.eclipse.ocl.examples.xtext.tests.TestUtil;
import org.junit.Test;

public class StandaloneExecutionTests
extends StandaloneTestCase {
    protected static void assertNoLogFile(@NonNull String logFileName) {
        File file = new File(logFileName);
        StandaloneExecutionTests.assertFalse((boolean)file.exists());
    }

    private void doFailingTest(@NonNull String @NonNull [] arguments) throws CoreException {
        StandaloneApplication validityApplication = new StandaloneApplication();
        StandaloneResponse applicationResponse = validityApplication.execute(arguments);
        StandaloneExecutionTests.assertEquals((Object)StandaloneResponse.FAIL, (Object)applicationResponse);
        validityApplication.stop();
    }

    private void doOKTest(@NonNull String @NonNull [] arguments) throws CoreException {
        StandaloneApplication validityApplication = new StandaloneApplication();
        StandaloneResponse applicationResponse = validityApplication.execute(arguments);
        StandaloneExecutionTests.assertEquals((Object)StandaloneResponse.OK, (Object)applicationResponse);
        validityApplication.stop();
    }

    private @NonNull List<String> checkLogFile(@NonNull String logFileName, int oks, int infos, int warnings, int errors, int fails) throws IOException {
        File file = new File(logFileName);
        StandaloneExecutionTests.assertTrue((boolean)file.exists());
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader r = new BufferedReader(new FileReader(file));
        int metricsLine = 0;
        String line = r.readLine();
        while (line != null) {
            if ("==== METRICS ====".equals(line)) {
                metricsLine = lines.size();
            }
            lines.add(line);
            line = r.readLine();
        }
        r.close();
        StandaloneExecutionTests.assertEquals((String)("- Number of Success: " + oks), (String)((String)lines.get(metricsLine + 2)));
        StandaloneExecutionTests.assertEquals((String)("- Number of Infos: " + infos), (String)((String)lines.get(metricsLine + 3)));
        StandaloneExecutionTests.assertEquals((String)("- Number of Warnings: " + warnings), (String)((String)lines.get(metricsLine + 4)));
        StandaloneExecutionTests.assertEquals((String)("- Number of Errors: " + errors), (String)((String)lines.get(metricsLine + 5)));
        StandaloneExecutionTests.assertEquals((String)("- Number of Failures: " + fails), (String)((String)lines.get(metricsLine + 6)));
        return lines;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        AbstractPivotConstraintLocator.initialize();
    }

    @Test
    public void test_help() throws CoreException {
        @NonNull String @NonNull [] arguments = new String[]{"help"};
        this.doOKTest(arguments);
    }

    @Test
    public void test_mandatoryArgumentsOnly() throws CoreException {
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", this.inputModelName, "-rules", this.inputOCLFileName};
        this.doOKTest(arguments);
        StandaloneExecutionTests.assertNoLogFile(this.getTextLogFileName());
    }

    @Test
    public void test_missingOutputArgument() throws CoreException, IOException {
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", this.inputModelName, "-rules", this.inputOCLFileName, "-output"};
        this.doFailingTest(arguments);
        StandaloneExecutionTests.assertNoLogFile(this.getTextLogFileName());
    }

    @Test
    public void test_missingExporterArgument() throws CoreException, IOException {
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", this.inputModelName, "-rules", this.inputOCLFileName, "-exporter"};
        this.doFailingTest(arguments);
        StandaloneExecutionTests.assertNoLogFile(this.getTextLogFileName());
    }

    @Test
    public void test_missingUsingArgument() throws CoreException, IOException {
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", this.inputModelName, "-rules", this.inputOCLFileName, "-using"};
        this.doFailingTest(arguments);
        StandaloneExecutionTests.assertNoLogFile(this.getTextLogFileName());
    }

    @Test
    public void test_textExportedFile() throws CoreException, IOException {
        String textLogFileName = this.getTextLogFileName();
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", this.inputModelName, "-rules", this.inputOCLFileName, "-output", textLogFileName, "-exporter", "text"};
        this.doOKTest(arguments);
        this.checkLogFile(textLogFileName, 36, 1, 1, 1, 0);
    }

    @Test
    public void test_modelExportedFile() throws CoreException, IOException, InterruptedException {
        String modelLogFileName = this.getLogFileName((IValidityExporter)ModelExporter.INSTANCE);
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", this.inputModelName, "-rules", this.inputOCLFileName, "-output", modelLogFileName, "-exporter", "model"};
        this.doOKTest(arguments);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        URI newFileURI = URI.createFileURI((String)modelLogFileName);
        Resource newResource = resourceSet.getResource(newFileURI, true);
        EObject eObject = (EObject)newResource.getContents().get(0);
        StandaloneExecutionTests.assertTrue((boolean)(eObject instanceof RootNode));
        Resource refResource = resourceSet.getResource(newFileURI.trimFileExtension().appendFileExtension("reference").appendFileExtension("validity"), true);
        refResource.setURI(newFileURI);
        TestUtil.assertSameModel(refResource, newResource);
    }

    @Test
    public void test_htmlExportedFile() throws CoreException {
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", this.inputModelName, "-rules", this.inputOCLFileName, "-output", this.getHTMLLogFileName(), "-exporter", "html"};
        this.doOKTest(arguments);
        File file = new File(this.getHTMLLogFileName());
        StandaloneExecutionTests.assertTrue((boolean)file.exists());
    }

    @Test
    public void test_unknownExporter() throws CoreException {
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", this.inputModelName, "-rules", this.inputOCLFileName, "-output", this.getTextLogFileName(), "-exporter", "anotherExporterAttribute"};
        this.doFailingTest(arguments);
        StandaloneExecutionTests.assertNoLogFile(this.getTextLogFileName());
    }

    @Test
    public void test_nonExistentModelFile() throws CoreException {
        String textLogFileName = this.getTextLogFileName();
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", String.valueOf(this.getProjectFileURI("models/nonExistentModel.ecore")), "-rules", this.inputOCLFileName, "-output", textLogFileName, "-exporter", "text"};
        this.doFailingTest(arguments);
        StandaloneExecutionTests.assertNoLogFile(textLogFileName);
    }

    @Test
    public void test_nonExistentOclFile() throws CoreException, IOException {
        String textLogFileName = this.getTextLogFileName();
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", this.inputModelName, "-rules", String.valueOf(this.getProjectFileURI("models/nonExistentFile.ocl")), "-output", textLogFileName, "-exporter", "text"};
        this.doOKTest(arguments);
        this.checkLogFile(textLogFileName, 30, 0, 0, 0, 0);
    }

    @Test
    public void test_nonExistentOutputFolder() throws CoreException {
        String nonExistentOutputFolderPath = "nonExistent/anotherName.txt";
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", this.inputModelName, "-rules", this.inputOCLFileName, "-output", nonExistentOutputFolderPath, "-exporter", "text"};
        this.doFailingTest(arguments);
        StandaloneExecutionTests.assertNoLogFile(nonExistentOutputFolderPath);
    }

    @Test
    public void test_listOfOCLFiles() throws CoreException, IOException {
        String textLogFileName = this.getTextLogFileName();
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", this.inputModelName, "-rules", this.textInputOCLFileName, "-output", textLogFileName, "-exporter", "text"};
        this.doOKTest(arguments);
        this.checkLogFile(textLogFileName, 42, 2, 2, 2, 0);
    }

    @Test
    public void test_listOfOCLFilesToStdout() throws CoreException {
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", this.inputModelName, "-rules", this.textInputOCLFileName, "-exporter", "text"};
        this.doOKTest(arguments);
        StandaloneExecutionTests.assertNoLogFile(this.getTextLogFileName());
    }
}

