/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.ecore.tests;

import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.SemanticException;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.EcoreEnvironment;
import org.eclipse.ocl.ecore.EcoreEnvironmentFactory;
import org.eclipse.ocl.ecore.OCL;
import org.eclipse.ocl.ecore.SendSignalAction;
import org.eclipse.ocl.ecore.internal.UMLReflectionImpl;
import org.eclipse.ocl.ecore.tests.AbstractTestSuite;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.utilities.UMLReflection;

public class ValidationTest
extends AbstractTestSuite {
    public void test_callNonQueryOperation_136778() {
        OCLExpression expr = this.parseConstraintUnvalidated("package ocltest context Apple inv: Apple.allInstances()->includes(self.newApple()) endpackage");
        try {
            this.ocl.validate(expr);
            ValidationTest.fail((String)"Should not have successfully validated");
        }
        catch (SemanticException e) {
            System.out.println("Got expected exception: " + e.getLocalizedMessage());
        }
    }

    /*
     * Unable to fully structure code
     */
    public void test_callExpOnUnrecognizedVariable_226083() {
        block4: {
            this.helper.setContext((Object)this.apple);
            try {
                this.helper.createInvariant("noSuchVariable.noSuchProperty->includes(self.noSuchOperation())");
                ValidationTest.fail((String)"Should not have successfully parsed");
            }
            catch (SemanticException e) {
                diagnostic = e.getDiagnostic();
                ValidationTest.assertNotNull((Object)diagnostic);
                ValidationTest.assertEquals((int)4, (int)diagnostic.getSeverity());
                ValidationTest.assertTrue((boolean)diagnostic.getMessage().contains("noSuchVariable"));
                found = false;
                ** for (child : diagnostic.getChildren())
            }
lbl-1000:
            // 1 sources

            {
                ValidationTest.assertFalse((boolean)child.getMessage().contains("noSuchProperty"));
                v0 = found = found != false || child.getMessage().contains("noSuchOperation") != false;
                continue;
lbl17:
                // 1 sources

                break block4;
            }
            catch (ParserException e) {
                ValidationTest.fail((String)("Wrong kind of parse failure: " + e.getLocalizedMessage()));
            }
        }
    }

    public void test_bodyOfUnrcognizableIteratorSource_226083() {
        this.helper.setContext((Object)this.apple);
        try {
            this.helper.createInvariant("Set{noSuchVariable}->forAll(e | e.noSuchOperation())");
            ValidationTest.fail((String)"Should not have successfully parsed");
        }
        catch (SemanticException e) {
            Diagnostic diagnostic = e.getDiagnostic();
            ValidationTest.assertNotNull((Object)diagnostic);
            ValidationTest.assertEquals((int)4, (int)diagnostic.getSeverity());
            ValidationTest.assertTrue((boolean)diagnostic.getMessage().contains("noSuchVariable"));
            ValidationTest.assertEquals((int)0, (int)diagnostic.getChildren().size());
        }
        catch (ParserException e) {
            ValidationTest.fail((String)("Wrong kind of parse failure: " + e.getLocalizedMessage()));
        }
    }

    protected OCL createOCL() {
        return OCL.newInstance((EnvironmentFactory)new CustomFruitEnvironmentFactory());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CustomFruitEnvironment
    extends EcoreEnvironment {
        public CustomFruitEnvironment(CustomFruitEnvironmentFactory factory) {
            super((EcoreEnvironmentFactory)factory, null);
            this.setContextPackage((EPackage)ValidationTest.this.fruitPackage);
        }

        public CustomFruitEnvironment(CustomFruitEnvironmentFactory factory, Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> parent) {
            super(parent);
        }

        public UMLReflection<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint> getUMLReflection() {
            return new UMLReflectionImpl(){

                public boolean isQuery(EOperation operation) {
                    return operation != ((CustomFruitEnvironment)CustomFruitEnvironment.this).ValidationTest.this.apple_newApple;
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CustomFruitEnvironmentFactory
    extends EcoreEnvironmentFactory {
        public CustomFruitEnvironmentFactory() {
            super(resourceSet.getPackageRegistry());
        }

        public EcoreEnvironment createEnvironment() {
            return new CustomFruitEnvironment(this);
        }

        public EcoreEnvironment createEnvironment(Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> parent) {
            return new CustomFruitEnvironment(this, parent);
        }
    }
}

