/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.helper;

import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.internal.context.AbstractParserContext;
import org.eclipse.ocl.pivot.internal.context.ClassContext;
import org.eclipse.ocl.pivot.internal.context.ModelContext;
import org.eclipse.ocl.pivot.internal.context.OperationContext;
import org.eclipse.ocl.pivot.internal.context.PropertyContext;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.MetamodelManager;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.utilities.OCLHelper;
import org.eclipse.ocl.pivot.utilities.ParserException;

public class OCLHelperImpl
implements OCLHelper {
    protected final @NonNull OCL ocl;
    protected final @Nullable EObject context;
    private @Nullable Class contextClass = null;
    private @Nullable Operation contextOperation = null;
    private @Nullable Property contextProperty = null;

    public OCLHelperImpl(@NonNull OCL ocl, @Nullable EObject context) {
        this.ocl = ocl;
        this.context = context;
        if (context instanceof Class) {
            this.contextClass = (Class)context;
        } else if (context instanceof Operation) {
            this.contextOperation = (Operation)context;
            this.contextClass = this.contextOperation.getOwningClass();
        } else if (context instanceof Property) {
            this.contextProperty = (Property)context;
            this.contextClass = this.contextProperty.getOwningClass();
        } else if (context instanceof EClassifier) {
            this.contextClass = this.getMetamodelManager().getASOfEcore(Class.class, context);
        } else if (context instanceof EOperation) {
            this.contextOperation = this.getMetamodelManager().getASOfEcore(Operation.class, context);
            if (this.contextOperation != null) {
                this.contextClass = this.contextOperation.getOwningClass();
            }
        } else if (context instanceof EStructuralFeature) {
            this.contextProperty = this.getMetamodelManager().getASOfEcore(Property.class, context);
            if (this.contextProperty != null) {
                this.contextClass = this.contextProperty.getOwningClass();
            }
        } else if (context instanceof EStructuralFeature) {
            this.contextClass = null;
        }
    }

    @Override
    public @NonNull ExpressionInOCL createBodyCondition(@NonNull String expression) throws ParserException {
        Operation contextOperation = this.getContextOperation();
        if (contextOperation == null) {
            throw new IllegalStateException("Undefined contextOperation");
        }
        OperationContext parserContext = new OperationContext(this.getEnvironmentFactory(), null, contextOperation, null);
        return parserContext.parse(this.contextClass, expression);
    }

    @Override
    public @NonNull ExpressionInOCL createDerivedValueExpression(@NonNull String expression) throws ParserException {
        Property contextProperty = this.getContextProperty();
        if (contextProperty == null) {
            throw new IllegalStateException("Undefined contextProperty");
        }
        PropertyContext parserContext = new PropertyContext(this.getEnvironmentFactory(), null, contextProperty);
        return parserContext.parse(this.contextClass, expression);
    }

    @Override
    public @NonNull ExpressionInOCL createInvariant(@NonNull String expression) throws ParserException {
        if (this.contextClass == null) {
            throw new IllegalStateException("Undefined contextClass");
        }
        ClassContext parserContext = new ClassContext(this.getEnvironmentFactory(), null, this.contextClass, null);
        return parserContext.parse(this.contextClass, expression);
    }

    @Override
    public @NonNull ExpressionInOCL createPostcondition(@NonNull String expression) throws ParserException {
        Operation contextOperation = this.getContextOperation();
        if (contextOperation == null) {
            throw new IllegalStateException("Undefined contextOperation");
        }
        OperationContext parserContext = new OperationContext(this.getEnvironmentFactory(), null, contextOperation, "result");
        return parserContext.parse(this.contextClass, expression);
    }

    @Override
    public @NonNull ExpressionInOCL createPrecondition(@NonNull String expression) throws ParserException {
        Operation contextOperation = this.getContextOperation();
        if (contextOperation == null) {
            throw new IllegalStateException("Undefined contextOperation");
        }
        OperationContext parserContext = new OperationContext(this.getEnvironmentFactory(), null, contextOperation, null);
        return parserContext.parse(this.contextClass, expression);
    }

    @Override
    public @NonNull ExpressionInOCL createQuery(@NonNull String expression) throws ParserException {
        AbstractParserContext parserContext = this.contextClass != null ? new ClassContext(this.getEnvironmentFactory(), null, this.contextClass, null) : new ModelContext(this.getEnvironmentFactory(), null);
        return parserContext.parse(this.contextClass, expression);
    }

    protected @NonNull ExpressionInOCL createSpecification(@NonNull String expression) throws ParserException {
        if (this.contextClass == null) {
            throw new IllegalStateException("Undefined contextClassifier");
        }
        ClassContext parserContext = new ClassContext(this.getEnvironmentFactory(), null, this.contextClass, null);
        return parserContext.parse(this.contextClass, expression);
    }

    @Override
    public @Nullable Type getContextClass() {
        return this.contextClass;
    }

    @Override
    public @Nullable Property getContextProperty() {
        return this.contextProperty;
    }

    @Override
    public @Nullable Operation getContextOperation() {
        return this.contextOperation;
    }

    public @NonNull EnvironmentFactory getEnvironmentFactory() {
        return this.ocl.getEnvironmentFactory();
    }

    public @NonNull MetamodelManager getMetamodelManager() {
        return this.ocl.getMetamodelManager();
    }

    @Override
    public @NonNull OCL getOCL() {
        return this.ocl;
    }
}

