/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.tests;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.SemanticException;
import org.eclipse.ocl.SyntaxException;
import org.eclipse.ocl.internal.l10n.OCLMessages;
import org.eclipse.ocl.options.EvaluationOptions;
import org.eclipse.ocl.options.Option;
import org.eclipse.ocl.tests.GenericTestSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericIteratorsTest<E extends EObject, PK extends E, T extends E, C extends T, CLS extends C, DT extends C, PT extends C, ET extends DT, O extends E, PM extends E, P extends E, PA extends P, PR extends P, EL, S, COA, SSA, CT>
extends GenericTestSuite<E, PK, T, C, CLS, DT, PT, ET, O, PM, P, PA, PR, EL, S, COA, SSA, CT> {
    PK pkg1;
    PK pkg2;
    PK pkg3;
    PK pkg4;
    PK pkg5;
    PK jim;
    PK bob;
    PK george;

    @Override
    protected void setUp() {
        super.setUp();
        this.pkg1 = (EObject)this.reflection.createPackage("pkg1");
        this.pkg2 = (EObject)this.reflection.createNestedPackage(this.pkg1, "pkg2");
        this.jim = (EObject)this.reflection.createNestedPackage(this.pkg2, "jim");
        this.bob = (EObject)this.reflection.createNestedPackage(this.pkg1, "bob");
        this.pkg3 = (EObject)this.reflection.createNestedPackage(this.pkg1, "pkg3");
        this.pkg4 = (EObject)this.reflection.createNestedPackage(this.pkg3, "pkg4");
        this.pkg5 = (EObject)this.reflection.createNestedPackage(this.pkg3, "pkg5");
        this.george = (EObject)this.reflection.createNestedPackage(this.pkg5, "george");
        this.helper.setContext(this.getMetaclass(this.denormalize("%Package")));
    }

    public void test_iterate_143996() {
        Set<String> expected = GenericIteratorsTest.createSet("pkg2", "bob", "pkg3");
        this.assertQueryEquals(this.pkg1, expected, "%nestedPackage->iterate(p; s : Set(String) = Set{} | s->including(p.name))");
        this.assertQueryEquals(this.pkg1, expected, "%nestedPackage->iterate(p; s : Set(String) = Set{} | s->including(p.name))");
        this.assertQueryEquals(this.pkg1, expected, "%nestedPackage->iterate(s : Set(String) = Set{} | s->including(name))");
    }

    public void test_select() {
        boolean isOrdered = this.reflection.isOrdered("nestedPackage");
        Collection<EObject> expected = this.createCollection(isOrdered, true, this.pkg2, this.pkg3);
        this.assertQueryEquals(this.pkg1, expected, "%nestedPackage->select(p : %Package | p.name <> 'bob')");
        this.assertQueryEquals(this.pkg1, expected, "%nestedPackage->select(p | p.name <> 'bob')");
        this.assertQueryEquals(this.pkg1, expected, "%nestedPackage->select(name <> 'bob')");
        expected.clear();
        expected.addAll(this.reflection.getNestedPackages(this.pkg1));
        this.assertQueryEquals(this.pkg1, expected, "%nestedPackage->select(true)");
    }

    public void test_reject() {
        boolean isOrdered = this.reflection.isOrdered("nestedPackage");
        Collection<EObject> expected = this.createCollection(isOrdered, true, this.pkg2, this.pkg3);
        this.assertQueryEquals(this.pkg1, expected, "%nestedPackage->reject(p : %Package | p.name = 'bob')");
        this.assertQueryEquals(this.pkg1, expected, "%nestedPackage->reject(p | p.name = 'bob')");
        this.assertQueryEquals(this.pkg1, expected, "%nestedPackage->reject(name = 'bob')");
        expected.clear();
        this.assertQueryEquals(this.pkg1, expected, "%nestedPackage->reject(true)");
    }

    public void test_any() {
        this.assertQuerySame(this.pkg1, this.bob, "%nestedPackage->any(p : %Package | p.name = 'bob')");
        this.assertQuerySame(this.pkg1, this.bob, "%nestedPackage->any(p | p.name = 'bob')");
        this.assertQuerySame(this.pkg1, this.bob, "%nestedPackage->any(name = 'bob')");
        this.assertQueryNotSame(this.pkg1, this.bob, "%nestedPackage->any(name = 'pkg2')");
        this.assertQueryNotNull(this.pkg1, "%nestedPackage->any(true)");
        this.assertQueryNull(this.pkg1, "%nestedPackage->any(false)");
        this.assertQueryNull(null, "Sequence{}->any(s | s = false)");
        this.assertQueryFalse(null, "Sequence{false}->any(s | s = false)");
        this.assertQueryFalse(null, "Sequence{false, false}->any(s | s = false)");
        this.assertQueryNull(null, "Sequence{}->any(s | s = null)");
        this.assertQueryNull(null, "Sequence{null}->any(s | s = null)");
        this.assertQueryNull(null, "Sequence{null, null}->any(s | s = null)");
        EvaluationOptions.setOption((EvaluationEnvironment)this.ocl.getEvaluationEnvironment(), (Option)EvaluationOptions.ANY_LESS_IS_INVALID, (Object)true);
        this.assertQueryInvalid(null, "Sequence{}->any(s | s = false)");
        this.assertQueryInvalid(null, "Sequence{}->any(s | s = null)");
        this.assertQueryInvalid(this.pkg1, "%nestedPackage->any(false)");
        EvaluationOptions.setOption((EvaluationEnvironment)this.ocl.getEvaluationEnvironment(), (Option)EvaluationOptions.ANY_LESS_IS_INVALID, (Object)false);
        this.assertQueryNull(this.pkg1, "%nestedPackage->any(false)");
    }

    public void test_isUnique_126861() {
        this.assertQueryTrue(this.pkg1, "Sequence{'a', 'b', 'c', 'd', 'e'}->isUnique(e | e)");
        this.assertQueryFalse(this.pkg1, "Sequence{'a', 'b', 'c', 'c', 'e'}->isUnique(e | e)");
        this.assertQueryTrue(this.pkg1, "Sequence{}->isUnique(e | e)");
        this.assertQueryNotNull(this.pkg1, "%nestedPackage->isUnique(name)");
    }

    public void test_exists() {
        this.assertQueryTrue(this.pkg1, "Sequence{'a', 'b', 'c', 'd', 'e'}->exists(e | e = 'c')");
        this.assertQueryTrue(this.pkg1, "Sequence{'a', 'b', 'c', 'c', 'e'}->exists(e | e = 'c')");
        this.assertQueryFalse(this.pkg1, "Sequence{'a', 'b', 'd', 'e'}->exists(e | e = 'c')");
        this.assertQueryFalse(this.pkg1, "Sequence{}->exists(e | e = 'c')");
        this.assertQueryTrue(this.pkg1, "%nestedPackage->exists(true)");
    }

    public void test_forAll() {
        this.assertQueryFalse(this.pkg1, "Sequence{'a', 'b', 'c', 'd', 'e'}->forAll(e | e = 'c')");
        this.assertQueryFalse(this.pkg1, "Sequence{'a', 'b', 'd', 'e'}->forAll(e | e = 'c')");
        this.assertQueryTrue(this.pkg1, "Sequence{'c', 'c', 'c', 'c'}->forAll(e | e = 'c')");
        this.assertQueryTrue(this.pkg1, "Sequence{'c'}->forAll(e | e = 'c')");
        this.assertQueryTrue(this.pkg1, "Sequence{}->forAll(e | e = 'c')");
        this.assertQueryTrue(this.pkg1, "%nestedPackage->forAll(true)");
    }

    public void test_one() {
        this.assertQueryTrue(this.pkg1, "Sequence{'a', 'b', 'c', 'd', 'e'}->one(e | e = 'c')");
        this.assertQueryFalse(this.pkg1, "Sequence{'a', 'b', 'c', 'c', 'e'}->one(e | e = 'c')");
        this.assertQueryFalse(this.pkg1, "Sequence{'a', 'b', 'd', 'e'}->one(e | e = 'c')");
        this.assertQueryTrue(this.pkg1, "Sequence{'a'}->one(true)");
    }

    public void test_collect() {
        boolean isOrdered = this.reflection.isOrdered("nestedPackage");
        Collection<String> expected1 = this.createCollection(isOrdered, false, "pkg2", "bob", "pkg3");
        this.assertQueryEquals(this.pkg1, expected1, "%nestedPackage->collect(p : %Package | p.name)");
        this.assertQueryEquals(this.pkg1, expected1, "%nestedPackage->collect(p | p.name)");
        this.assertQueryEquals(this.pkg1, expected1, "%nestedPackage->collect(name)");
        this.assertQueryEquals(this.pkg1, expected1, "%nestedPackage.name");
        Collection<EObject> expected2 = this.createCollection(isOrdered, false, this.jim, this.pkg4, this.pkg5);
        this.assertQueryEquals(this.pkg1, expected2, "%nestedPackage.%nestedPackage");
    }

    public void test_implicitCollect_unknownAttribute_232669() {
        this.assertBadInvariant(SemanticException.class, 4, "%nestedPackage.unknownAttribute", OCLMessages.UnrecognizedVar_ERROR_, "unknownAttribute");
    }

    public void test_implicitCollect_unknownOperation_232669() {
        this.assertBadInvariant(SemanticException.class, 4, "%nestedPackage.unknownOperation(self)", OCLMessages.OperationNotFound_ERROR_, this.denormalize("unknownOperation(%Package)"), this.denormalize("%Package"));
    }

    public void test_collect_flattens_217461() {
        String self = "foo";
        List<String> expected = GenericIteratorsTest.createSequence("THIS AND", "THAT", "THE OTHER");
        this.assertQueryEquals(self, expected, "Sequence{Sequence{'this and', 'that'}, Sequence{'the other'}}->collect(s : Sequence(String) | s.toUpper())");
    }

    public void test_collect_empty_217461() {
        String self = "foo";
        List expected = Collections.emptyList();
        this.assertQueryEquals(self, expected, "let c : Sequence(OrderedSet(String)) = Sequence{} in c->collect(s : OrderedSet(String) | s.toUpper())");
    }

    public void test_collectNested() {
        boolean isOrdered = this.reflection.isOrdered("nestedPackage");
        Collection<String> expected1 = this.createCollection(isOrdered, false, "pkg2", "bob", "pkg3");
        this.assertQueryEquals(this.pkg1, expected1, "%nestedPackage->collectNested(p : %Package | p.name)");
        this.assertQueryEquals(this.pkg1, expected1, "%nestedPackage->collectNested(p | p.name)");
        this.assertQueryEquals(this.pkg1, expected1, "%nestedPackage->collectNested(name)");
        Set<PK> e1 = Collections.singleton(this.jim);
        Set e2 = Collections.EMPTY_SET;
        HashSet<Object> e3 = new HashSet<Object>(Arrays.asList(this.pkg4, this.pkg5));
        Collection<Set> expected2 = this.createCollection(isOrdered, false, e1, e2, e3);
        this.assertQueryEquals(this.pkg1, expected2, "%nestedPackage->collectNested(%nestedPackage)");
    }

    public void test_collect_returns_490982() {
        Collection<Boolean> expected1 = GenericIteratorsTest.createBag(false, true, true);
        List<Boolean> expected2 = GenericIteratorsTest.createSequence(true, false, true);
        this.assertQueryEquals(null, expected1, "Bag{1,2,3}->collect(p | (p.mod(2)) <> 0)");
        this.assertQueryEquals(null, expected2, "OrderedSet{1,2,3}->collect(p | (p.mod(2)) <> 0)");
        this.assertQueryEquals(null, expected2, "Sequence{1,2,3}->collect(p | (p.mod(2)) <> 0)");
        this.assertQueryEquals(null, expected1, "Set{1,2,3}->collect(p | (p.mod(2)) <> 0)");
    }

    public void test_collectNested_returns_490982() {
        Collection<Boolean> expected1 = GenericIteratorsTest.createBag(false, true, true);
        List<Boolean> expected2 = GenericIteratorsTest.createSequence(true, false, true);
        this.assertQueryEquals(null, false, "OrderedSet{1,2,3}->collectNested(p | (p.mod(2)) <> 0)->at(2)");
        this.assertQueryEquals(null, expected1, "Bag{1,2,3}->collectNested(p | (p.mod(2)) <> 0)");
        this.assertQueryEquals(null, expected2, "OrderedSet{1,2,3}->collectNested(p | (p.mod(2)) <> 0)");
        this.assertQueryEquals(null, expected2, "Sequence{1,2,3}->collectNested(p | (p.mod(2)) <> 0)");
        this.assertQueryEquals(null, expected1, "Set{1,2,3}->collectNested(p | (p.mod(2)) <> 0)");
        this.assertQueryEquals(null, false, "OrderedSet{1,2,3}->collectNested(p | (p.mod(2)) <> 0)->at(2)");
        this.assertQueryEquals(null, false, "Sequence{1,2,3}->collectNested(p | (p.mod(2)) <> 0)->at(2)");
    }

    public void test_sortedBy() {
        Set<EObject> expectedSet = GenericIteratorsTest.createSet(this.bob, this.pkg2, this.pkg3);
        this.assertQueryEquals(this.pkg1, expectedSet, "%nestedPackage->sortedBy(p : %Package | p.name)");
        this.assertQueryEquals(this.pkg1, expectedSet, "%nestedPackage->sortedBy(p | p.name)");
        this.assertQueryEquals(this.pkg1, expectedSet, "%nestedPackage->sortedBy(name)");
        List<String> expected = GenericIteratorsTest.createSequence("a", "b", "c", "d", "e");
        this.assertQueryEquals(this.pkg1, expected, "Bag{'d', 'b', 'e', 'a', 'c'}->sortedBy(e | e)");
    }

    public void test_closure() {
        boolean nestedIsOrdered = this.reflection.isOrdered("nestedPackage");
        boolean nestingIsOrdered = this.reflection.isOrdered("nestingPackage");
        Collection<EObject> expected11 = this.createCollection(nestingIsOrdered, true, this.pkg1, this.pkg3, this.pkg5);
        this.assertQueryEquals(this.george, expected11, "self->closure(%nestingPackage)");
        Collection<EObject> expected12 = this.createCollection(nestedIsOrdered, true, this.pkg2, this.jim, this.bob, this.pkg3, this.pkg4, this.pkg5, this.george);
        this.assertQueryEquals(this.pkg1, expected12, "self->closure(%nestedPackage)");
        this.assertQueryEquals(this.pkg1, expected12, "self->asSequence()->closure(%nestedPackage)");
        this.assertQueryEquals(this.pkg1, expected12, "self->closure(%nestedPackage->asSequence())");
        Set<EObject> expected13 = GenericIteratorsTest.createSet(this.pkg2, this.jim, this.bob, this.pkg3, this.pkg4, this.pkg5, this.george);
        this.assertQueryEquals(this.pkg1, expected13, "self->asBag()->closure(%nestedPackage)");
        this.assertQueryEquals(this.pkg1, expected13, "self->closure(%nestedPackage->asBag())");
        Collection<EObject> expected14 = this.createCollection(nestingIsOrdered, true, new EObject[0]);
        this.assertQueryEquals(this.pkg1, expected14, "self->closure(%nestingPackage)");
        this.assertQueryEquals(this.pkg1, expected14, "self->asSequence()->closure(%nestingPackage)");
        EvaluationOptions.setOption((EvaluationEnvironment)this.ocl.getEvaluationEnvironment(), (Option)EvaluationOptions.CLOSURE_INCLUDES_SOURCES, (Object)true);
        Collection<EObject> expected21 = this.createCollection(nestingIsOrdered, true, this.pkg1, this.pkg3, this.pkg5, this.george);
        this.assertQueryEquals(this.george, expected21, "self->closure(%nestingPackage)");
        Collection<EObject> expected22 = this.createCollection(nestedIsOrdered, true, this.pkg1, this.pkg2, this.jim, this.bob, this.pkg3, this.pkg4, this.pkg5, this.george);
        this.assertQueryEquals(this.pkg1, expected22, "self->closure(%nestedPackage)");
        this.assertQueryEquals(this.pkg1, expected22, "self->asSequence()->closure(%nestedPackage)");
        this.assertQueryEquals(this.pkg1, expected22, "self->closure(%nestedPackage->asSequence())");
        Set<EObject> expected23 = GenericIteratorsTest.createSet(this.pkg1, this.pkg2, this.jim, this.bob, this.pkg3, this.pkg4, this.pkg5, this.george);
        this.assertQueryEquals(this.pkg1, expected23, "self->asBag()->closure(%nestedPackage)");
        this.assertQueryEquals(this.pkg1, expected23, "self->closure(%nestedPackage->asBag())");
        Collection<EObject> expected24 = this.createCollection(nestingIsOrdered, true, this.pkg1);
        this.assertQueryEquals(this.pkg1, expected24, "self->closure(%nestingPackage)");
        this.assertQueryEquals(this.pkg1, expected24, "self->asSequence()->closure(%nestingPackage)");
        EvaluationOptions.setOption((EvaluationEnvironment)this.ocl.getEvaluationEnvironment(), (Option)EvaluationOptions.CLOSURE_INCLUDES_SOURCES, (Object)false);
        this.assertQueryEquals(this.george, expected11, "self->closure(%nestingPackage)");
        this.assertQueryEquals(this.pkg1, expected12, "self->closure(%nestedPackage)");
        this.assertQueryEquals(this.pkg1, expected12, "self->asSequence()->closure(%nestedPackage)");
        this.assertQueryEquals(this.pkg1, expected12, "self->closure(%nestedPackage->asSequence())");
        this.assertQueryEquals(this.pkg1, expected13, "self->asBag()->closure(%nestedPackage)");
        this.assertQueryEquals(this.pkg1, expected13, "self->closure(%nestedPackage->asBag())");
        this.assertQueryEquals(this.pkg1, expected14, "self->closure(%nestingPackage)");
        this.assertQueryEquals(this.pkg1, expected14, "self->asSequence()->closure(%nestingPackage)");
    }

    public void test_closure_cycles() {
        Object packageMetaclass = this.getMetaclass(this.denormalize("%Package"));
        EObject nestedPackage = (EObject)this.reflection.getAttribute(packageMetaclass, this.denormalize("%nestedPackage"), packageMetaclass);
        EObject nestingPackage = (EObject)this.reflection.getAttribute(packageMetaclass, this.denormalize("%nestingPackage"), packageMetaclass);
        this.helper.setContext(this.getMetaclass(this.denormalize("%Reference")));
        Set<EObject> expected = GenericIteratorsTest.createSet(nestedPackage, nestingPackage);
        this.assertQueryEquals(nestingPackage, expected, "self->closure(%opposite)");
        this.assertQueryEquals(nestedPackage, expected, "self->closure(%opposite)");
    }

    public void test_closure_operations() {
        EObject fakePkg = (EObject)this.reflection.createPackage("fake");
        EObject fake = (EObject)this.reflection.createOwnedClass(fakePkg, "Fake", false);
        EObject getFakes = (EObject)this.reflection.createOwnedOperation(fake, "getFakes", null, null, fake, true);
        this.reflection.setOperationUpper(getFakes, this.reflection.getUnlimitedValue());
        this.assertQuery(fake, "self->closure(getFakes())");
    }

    public void test_closureValidation() {
        this.assertBadQuery(SemanticException.class, 4, "self->closure(%ownedType)", OCLMessages.ElementTypeConformanceClosure_ERROR_, this.denormalize("%Type"), this.denormalize("%Package"));
    }

    public void test_closureValidation_typeConformance_154695() {
        EObject fakePkg = (EObject)this.reflection.createPackage("fake");
        EObject fake = (EObject)this.reflection.createOwnedClass(fakePkg, "Fake", false);
        EObject getFakes = (EObject)this.reflection.createOwnedOperation(fake, "getFakes", null, null, fake, true);
        this.reflection.setOperationUpper(getFakes, this.reflection.getUnlimitedValue());
        EObject subFake = (EObject)this.reflection.createOwnedClass(fakePkg, "Subfake", false);
        this.reflection.createGeneralization(subFake, fake);
        EObject getSubFakes = (EObject)this.reflection.createOwnedOperation(fake, "getSubFakes", null, null, subFake, true);
        this.reflection.setOperationUpper(getSubFakes, this.reflection.getUnlimitedValue());
        this.helper.setContext((Object)subFake);
        this.assertBadQuery(SemanticException.class, 4, "self->closure(getFakes())", OCLMessages.ElementTypeConformanceClosure_ERROR_, "Fake", "Subfake");
        this.assertQuery(fake, "self->closure(getSubFakes())");
    }

    public void test_forAll_invalidBody_142518() {
        this.assertQueryInvalid(EcorePackage.eINSTANCE, "let b:Boolean = null in Bag{1, 2, 3}->forAll(b and b)");
        this.assertInvariantFalse(EcorePackage.eINSTANCE, "let b:Boolean = null in Bag{1}->forAll(b and b)");
        this.assertQueryInvalid(EcorePackage.eINSTANCE, "Bag{1, 2, 3}->forAll(null.oclAsType(Boolean))");
    }

    public void test_exists_invalidBody_142518() {
        this.assertQueryInvalid(EcorePackage.eINSTANCE, "let b:Boolean = null in Bag{1, 2, 3}->exists(b and b)");
        this.assertQueryInvalid(EcorePackage.eINSTANCE, "Bag{1, 2, 3}->exists(null.oclAsType(Boolean))");
    }

    public void test_one_invalidBody_142518() {
        this.assertQueryInvalid(EcorePackage.eINSTANCE, "let b:Boolean = null in Bag{1, 2, 3}->one(b and b)");
        this.assertQueryInvalid(EcorePackage.eINSTANCE, "Bag{1, 2, 3}->one(null.oclAsType(Boolean))");
    }

    public void test_any_invalidBody_142518() {
        this.assertQueryInvalid(EcorePackage.eINSTANCE, "let b:Boolean = null in Bag{1, 2, 3}->any(b and b)");
        this.assertQueryInvalid(EcorePackage.eINSTANCE, "Bag{1, 2, 3}->any(null.oclAsType(Boolean))");
    }

    public void test_select_invalidBody_142518() {
        this.assertQueryInvalid(EcorePackage.eINSTANCE, "let b:Boolean = null in Bag{1, 2, 3}->select(b and b)");
        this.assertQueryInvalid(EcorePackage.eINSTANCE, "Bag{1, 2, 3}->select(null.oclAsType(Boolean))");
    }

    public void test_reject_invalidBody_142518() {
        this.assertQueryInvalid(EcorePackage.eINSTANCE, "let b:Boolean = null in Bag{1, 2, 3}->reject(b and b)");
        this.assertQueryInvalid(EcorePackage.eINSTANCE, "Bag{1, 2, 3}->reject(null.oclAsType(Boolean))");
    }

    public void test_isUnique_invalidBody_142518() {
        this.assertQueryFalse(EcorePackage.eINSTANCE, "let b:Boolean = null in Bag{1, 2, 3}->isUnique(b and b)");
        this.assertQueryFalse(EcorePackage.eINSTANCE, "let b:Boolean = null in Bag{1, 2, 3}->isUnique(null)");
    }

    public void test_collect_invalidBody_142518() {
        this.assertQueryInvalid(EcorePackage.eINSTANCE, "let b:Boolean = null in Bag{1, 2, 3}->collect(b and b)");
        Collection<Object> expected = GenericIteratorsTest.createBag(null, null, null);
        this.assertQueryEquals(EcorePackage.eINSTANCE, expected, "let b:Boolean = null in Bag{1, 2, 3}->collect(null)");
    }

    public void test_collectNested_invalidBody_142518() {
        this.assertQueryInvalid(EcorePackage.eINSTANCE, "let b:Boolean = null in Bag{1, 2, 3}->collectNested(b and b)");
        Set<Integer> e1 = Collections.singleton(new Integer(1));
        Object e2 = null;
        Set<Integer> e3 = Collections.singleton(new Integer(3));
        Collection<Set> expected = GenericIteratorsTest.createBag(e1, e2, e3);
        this.assertQueryEquals(EcorePackage.eINSTANCE, expected, "let b:Boolean = null in Bag{1, 2, 3}->collectNested(e | if e = 2 then null else Set{e} endif)");
    }

    public void test_closure_invalidBody_142518() {
        this.assertQueryInvalid(this.getUMLMetamodel(), "let c : %Type = invalid in %ownedType->closure(c)");
        Object result = this.assertQueryEvaluate(this.getUMLMetamodel(), "let c : Set(%Type) = Set{null} in %ownedType->closure(c)");
        GenericIteratorsTest.assertTrue((boolean)(result instanceof Collection));
        Collection collResult = (Collection)result;
        GenericIteratorsTest.assertEquals((int)1, (int)collResult.size());
        GenericIteratorsTest.assertNull(collResult.iterator().next());
        EvaluationOptions.setOption((EvaluationEnvironment)this.ocl.getEvaluationEnvironment(), (Option)EvaluationOptions.CLOSURE_INCLUDES_SOURCES, (Object)true);
        Set<Integer> expected3 = GenericIteratorsTest.createSet(null, 5);
        this.assertQueryEquals(this.pkg1, expected3, "let c : Set(UnlimitedNatural) = Set{null} in 5->closure(c)");
    }

    public void test_sortedBy_invalidBody_142518() {
        this.assertQueryInvalid(EcorePackage.eINSTANCE, "let s : String = null in Bag{1, 2, 3}->sortedBy(s.size())");
        this.assertQueryInvalid(EcorePackage.eINSTANCE, "Bag{1, 2, 3}->sortedBy(null.oclAsType(Integer))");
    }

    public void test_iterateWithNullSource_143996() {
        this.assertQueryInvalid(this.pkg1, "let e : Collection(%Package) = null in e->iterate(p : %Package; s : String = '' | s.concat(p.name))");
        this.assertQueryInvalid(this.pkg1, "let e : Collection(%Package) = invalid in e->iterate(p : %Package; s : String = '' | s.concat(p.name))");
    }

    public void test_existsWithNullSource_143996() {
        this.assertQueryInvalid(this.pkg1, "let e : Collection(%Package) = null in e->exists(p : %Package | p.name = 'bob')");
        this.assertQueryInvalid(this.pkg1, "let e : Collection(%Package) = invalid in e->exists(p : %Package | p.name = 'bob')");
    }

    public void test_exists_multipleIteratorVariables() {
        this.assertInvariantTrue(this.pkg1, "Sequence{1, 2, 3, 4}->exists(e1, e2 | e1 = e2)");
        this.assertInvariantFalse(this.pkg1, "Sequence{1, 2, 3, 4}->exists(e1, e2 | (e1 + e2) = 0)");
        this.assertInvariantFalse(this.pkg1, "Sequence{}->exists(e1, e2 | e1 = e2)");
    }

    public void test_forAll_multipleIteratorVariables() {
        this.assertInvariantFalse(this.pkg1, "Sequence{1, 2, 3, 4}->forAll(e1, e2 | e1 = e2)");
        this.assertInvariantTrue(this.pkg1, "Sequence{1, 2, 3, 4}->forAll(e1, e2 | (e1 + e2) > e1)");
        this.assertInvariantTrue(this.pkg1, "Sequence{}->forAll(e1, e2 | e1 = e2)");
    }

    public void test_invalidMultipleIteratorVariables() {
        this.assertBadQuery(SyntaxException.class, 4, "Sequence{'a', 'b', 'c'}->exists(e1, e2, e3 | e1 = e2)", OCLMessages.OCLParseErrorCodes_SUBSTITUTION_SECONDARY, "2:44:2:44", "\",\"", "\"|\"");
        this.assertBadQuery(SyntaxException.class, 4, "Sequence{'a', 'b', 'c'}->forAll(e1, e2, e3 | e1 = e2)", OCLMessages.OCLParseErrorCodes_SUBSTITUTION_SECONDARY, "1:44:1:44", "\",\"", "\"|\"");
        this.assertBadQuery(SemanticException.class, 4, "Sequence{'a', 'b', 'c'}->collect(e1, e2 | Tuple{a : String = e1, b : String = e2})", OCLMessages.TooManyIteratorVariables_ERROR_, "collect");
        this.assertBadQuery(SemanticException.class, 4, "Sequence{'a', 'b', 'c'}->any(e1, e2 | e1 = e2)", OCLMessages.TooManyIteratorVariables_ERROR_, "any");
        this.assertBadQuery(SemanticException.class, 4, "Sequence{'a', 'b', 'c'}->one(e1, e2 | e1 = e2)", OCLMessages.TooManyIteratorVariables_ERROR_, "one");
        this.assertBadQuery(SemanticException.class, 4, "Sequence{'a', 'b', 'c'}->select(e1, e2 | e1 = e2)", OCLMessages.TooManyIteratorVariables_ERROR_, "select");
        this.assertBadQuery(SemanticException.class, 4, "Sequence{'a', 'b', 'c'}->reject(e1, e2 | e1 = e2)", OCLMessages.TooManyIteratorVariables_ERROR_, "reject");
        this.assertBadQuery(SemanticException.class, 4, "Sequence{'a', 'b', 'c'}->isUnique(e1, e2 | e1 = e2)", OCLMessages.TooManyIteratorVariables_ERROR_, "isUnique");
    }

    public void test_sortedByRequiresComparability_192729() {
        Object context = this.getMetaclass(this.denormalize("%Package"));
        this.assertBadQuery(SemanticException.class, 4, "%ownedType->sortedBy(e | e)", OCLMessages.OperationNotFound_ERROR_, "<", this.denormalize("%Type"));
        this.assertQuery(context, "%ownedType->sortedBy(e | e.name)");
    }
}

