/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.ecore.tests;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.OCLInput;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.OCL;
import org.eclipse.ocl.ecore.SetType;
import org.eclipse.ocl.ecore.tests.AbstractTestSuite;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.helper.ChoiceKind;
import org.eclipse.ocl.helper.ConstraintKind;
import org.eclipse.ocl.internal.l10n.OCLMessages;
import org.eclipse.ocl.options.Option;
import org.eclipse.ocl.options.ParsingOptions;
import org.eclipse.ocl.util.TypeUtil;
import org.eclipse.ocl.utilities.UMLReflection;

public class DefExpressionTest
extends AbstractTestSuite {
    public void test_defExpression_raw_operation() {
        try {
            OCLExpression expr = this.parseDef("package ocltest context Fruit def: bestColor(c : Color) : Color = if self.color = Color::black then c else self.color endif endpackage");
            Constraint constraint = (Constraint)expr.eContainer().eContainer();
            DefExpressionTest.assertNotNull((Object)constraint);
            DefExpressionTest.assertEquals((String)"definition", (String)constraint.getStereotype());
            DefExpressionTest.assertSame((Object)this.color, (Object)expr.getType());
            expr = this.parse("package ocltest context Fruit inv: bestColor(Color::red) = Color::red endpackage");
            EObject anApple = this.fruitFactory.create(this.apple);
            anApple.eSet((EStructuralFeature)this.fruit_color, (Object)this.color_black);
            DefExpressionTest.assertTrue((boolean)this.ocl.check((Object)anApple, expr));
            anApple.eSet((EStructuralFeature)this.fruit_color, (Object)this.color_green);
            DefExpressionTest.assertFalse((boolean)this.ocl.check((Object)anApple, expr));
        }
        catch (Exception e) {
            DefExpressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_defExpression_helper_operation() {
        this.helper.setContext((Object)this.fruit);
        try {
            this.helper.defineOperation("bestColor(c : Color) : Color = if self.color = Color::black then c else self.color endif");
            Constraint expr = (Constraint)this.helper.createInvariant("bestColor(Color::red) = Color::red");
            EObject anApple = this.fruitFactory.create(this.apple);
            anApple.eSet((EStructuralFeature)this.fruit_color, (Object)this.color_black);
            DefExpressionTest.assertTrue((boolean)this.ocl.check((Object)anApple, (Object)expr));
            anApple.eSet((EStructuralFeature)this.fruit_color, (Object)this.color_green);
            DefExpressionTest.assertFalse((boolean)this.ocl.check((Object)anApple, (Object)expr));
        }
        catch (Exception e) {
            DefExpressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_defExpression_raw_attribute() {
        try {
            OCLExpression expr = this.parseDef("package ocltest context Apple def: fallen : Boolean = stem.oclIsUndefined() endpackage");
            Constraint constraint = (Constraint)expr.eContainer().eContainer();
            DefExpressionTest.assertNotNull((Object)constraint);
            DefExpressionTest.assertEquals((String)"definition", (String)constraint.getStereotype());
            DefExpressionTest.assertSame((Object)this.getOCLStandardLibrary().getBoolean(), (Object)expr.getType());
            expr = this.parse("package ocltest context Apple inv: not fallen endpackage");
            EObject anApple = this.fruitFactory.create(this.apple);
            anApple.eSet((EStructuralFeature)this.apple_stem, (Object)this.fruitFactory.create(this.stem));
            DefExpressionTest.assertTrue((boolean)this.ocl.check((Object)anApple, expr));
            anApple.eSet((EStructuralFeature)this.apple_stem, null);
            DefExpressionTest.assertFalse((boolean)this.ocl.check((Object)anApple, expr));
        }
        catch (Exception e) {
            DefExpressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_defExpression_helper_attribute() {
        this.helper.setContext((Object)this.apple);
        try {
            this.helper.defineAttribute("fallen : Boolean = stem.oclIsUndefined()");
            Constraint expr = (Constraint)this.helper.createInvariant("not fallen");
            EObject anApple = this.fruitFactory.create(this.apple);
            anApple.eSet((EStructuralFeature)this.apple_stem, (Object)this.fruitFactory.create(this.stem));
            DefExpressionTest.assertTrue((boolean)this.ocl.check((Object)anApple, (Object)expr));
            anApple.eSet((EStructuralFeature)this.apple_stem, null);
            DefExpressionTest.assertFalse((boolean)this.ocl.check((Object)anApple, (Object)expr));
        }
        catch (Exception e) {
            DefExpressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_defExpression_raw_reference() {
        try {
            OCLExpression expr = this.parseDef("package ocltest context Apple def: otherApples : Set(Apple) = Apple.allInstances()->excluding(self) endpackage");
            Constraint constraint = (Constraint)expr.eContainer().eContainer();
            DefExpressionTest.assertNotNull((Object)constraint);
            DefExpressionTest.assertEquals((String)"definition", (String)constraint.getStereotype());
            DefExpressionTest.assertTrue((boolean)(expr.getType() instanceof org.eclipse.ocl.types.SetType));
            DefExpressionTest.assertSame((Object)((SetType)expr.getType()).getElementType(), (Object)this.apple);
            expr = this.parse("package ocltest context Apple inv: self.otherApples endpackage");
            EObject anApple = this.fruitFactory.create(this.apple);
            EObject anotherApple = this.fruitFactory.create(this.apple);
            HashMap extentMap = new HashMap();
            HashSet<EObject> allApples = new HashSet<EObject>();
            allApples.add(anApple);
            allApples.add(anotherApple);
            extentMap.put(this.apple, allApples);
            this.ocl.setExtentMap(extentMap);
            Object otherApples = this.ocl.evaluate((Object)anApple, expr);
            DefExpressionTest.assertEquals(Collections.singleton(anotherApple), (Object)otherApples);
        }
        catch (Exception e) {
            DefExpressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_defExpression_inheritance_operation() {
        this.helper.setContext((Object)EcorePackage.Literals.ECLASSIFIER);
        try {
            this.helper.defineOperation("allParents() : Set(EClassifier) = if self.oclIsKindOf(EClass) then self.oclAsType(EClass)->closure(eSuperTypes) else Set{} endif");
            OCLExpression expr = this.helper.createQuery("self.allParents()");
            Object allParents = this.ocl.evaluate((Object)this.apple, expr);
            DefExpressionTest.assertTrue((boolean)(allParents instanceof Set));
            DefExpressionTest.assertTrue((boolean)((Set)allParents).contains(this.fruit));
            allParents = this.ocl.evaluate((Object)this.color, expr);
            DefExpressionTest.assertTrue((boolean)(allParents instanceof Set));
            DefExpressionTest.assertTrue((boolean)((Set)allParents).isEmpty());
        }
        catch (Exception e) {
            DefExpressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_defExpression_inheritance_attribute() {
        this.helper.setContext((Object)EcorePackage.Literals.ECLASSIFIER);
        try {
            this.helper.defineAttribute("allParents : Set(EClassifier) = if self.oclIsKindOf(EClass) then self.oclAsType(EClass)->closure(eSuperTypes) else Set{} endif");
            OCLExpression expr = this.helper.createQuery("self.allParents");
            Object allParents = this.ocl.evaluate((Object)this.apple, expr);
            DefExpressionTest.assertTrue((boolean)(allParents instanceof Set));
            DefExpressionTest.assertTrue((boolean)((Set)allParents).contains(this.fruit));
            allParents = this.ocl.evaluate((Object)this.color, expr);
            DefExpressionTest.assertTrue((boolean)(allParents instanceof Set));
            DefExpressionTest.assertTrue((boolean)((Set)allParents).isEmpty());
        }
        catch (Exception e) {
            DefExpressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_defExpression_static() {
        try {
            ParsingOptions.setOption((Environment)this.ocl.getEnvironment(), (Option)ParsingOptions.SUPPORT_STATIC_FEATURES, (Object)true);
            try {
                this.ocl.parse(new OCLInput("package ocltest context Fruit def: bestColor1() : Color = null static def: bestColor2() : Color = null def: goodColor1 : Color = null static def: goodColor2 : Color = null endpackage"));
                DefExpressionTest.fail((String)"Should have failed to parse the unimplemented static");
            }
            catch (ParserException e) {
                DefExpressionTest.assertEquals((String)OCLMessages.UnimplementedStatic_ERROR_, (String)e.getMessage());
                System.out.println("Got the expected exception: " + e.getLocalizedMessage());
            }
            ParsingOptions.setOption((Environment)this.ocl.getEnvironment(), (Option)ParsingOptions.SUPPORT_STATIC_FEATURES, (Object)false);
            try {
                this.ocl.parse(new OCLInput("package ocltest context Fruit def: bestColor3() : Color = null static def: bestColor4() : Color = null endpackage"));
                DefExpressionTest.fail((String)"Should have failed to parse the unsupported static");
            }
            catch (ParserException e) {
                DefExpressionTest.assertEquals((String)OCLMessages.UnsupportedStatic_ERROR_, (String)e.getMessage());
                System.out.println("Got the expected exception: " + e.getLocalizedMessage());
            }
        }
        catch (Exception e) {
            DefExpressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_malformedDefExpression_attribute() {
        this.helper.setContext((Object)EcorePackage.Literals.ECLASSIFIER);
        try {
            this.helper.defineAttribute("allParents : Set(EClassifier) = if self.oclIsKindOf(EClass) then self.name else '' endif");
            DefExpressionTest.fail((String)"Should not have parsed");
        }
        catch (Exception e) {
            System.out.println("Got expected error: " + e.getLocalizedMessage());
        }
        try {
            this.helper.defineAttribute("myName = if self.oclIsKindOf(EClass) then self.name else '' endif");
            DefExpressionTest.fail((String)"Should not have parsed");
        }
        catch (Exception e) {
            System.out.println("Got expected error: " + e.getLocalizedMessage());
        }
    }

    public void test_malformedDefExpression_operation() {
        this.helper.setContext((Object)EcorePackage.Literals.ECLASSIFIER);
        try {
            this.helper.defineOperation("allParents() : Set(EClassifier) = if self.oclIsKindOf(EClass) then self.name else '' endif");
            DefExpressionTest.fail((String)"Should not have parsed");
        }
        catch (Exception e) {
            System.out.println("Got expected error: " + e.getLocalizedMessage());
        }
        try {
            this.helper.defineOperation("bestName(s : String) = if self.oclIsKindOf(EClass) then self.name else s endif");
            DefExpressionTest.fail((String)"Should not have parsed");
        }
        catch (Exception e) {
            System.out.println("Got expected error: " + e.getLocalizedMessage());
        }
        try {
            this.helper.defineOperation("bestName(s) : String = if self.oclIsKindOf(EClass) then self.name else s endif");
            DefExpressionTest.fail((String)"Should not have parsed");
        }
        catch (Exception e) {
            System.out.println("Got expected error: " + e.getLocalizedMessage());
        }
    }

    public void test_duplicateDefinition_attribute() {
        this.helper.setContext((Object)EcorePackage.Literals.ECLASSIFIER);
        try {
            this.helper.defineAttribute("name : String = if self.oclIsKindOf(EClass) then 'foo' else '' endif");
            DefExpressionTest.fail((String)"Should not have parsed");
        }
        catch (Exception e) {
            System.out.println("Got expected error: " + e.getLocalizedMessage());
        }
        try {
            this.helper.defineAttribute("eAnnotations : Set(String) = Set{'a', 'b', 'c'}");
            DefExpressionTest.fail((String)"Should not have parsed");
        }
        catch (Exception e) {
            System.out.println("Got expected error: " + e.getLocalizedMessage());
        }
    }

    public void test_duplicateDefinition_operation() {
        this.helper.setContext((Object)this.apple);
        try {
            this.helper.defineOperation("preferredLabel(s : String) : String = if self.oclIsKindOf(EClass) then 'foo' else s endif");
            DefExpressionTest.fail((String)"Should not have parsed");
        }
        catch (Exception e) {
            System.out.println("Got expected error: " + e.getLocalizedMessage());
        }
        try {
            this.helper.defineOperation("preferredLabel(s : String) : Integer = if self.oclIsKindOf(EClass) then 0 else s.size() endif");
            DefExpressionTest.fail((String)"Should not have parsed");
        }
        catch (Exception e) {
            System.out.println("Got expected error: " + e.getLocalizedMessage());
        }
        try {
            this.helper.defineOperation("preferredLabel(text : Integer) : String = if text > 0 then 'foo' else 'bar' endif");
        }
        catch (Exception e) {
            DefExpressionTest.fail((String)("Failed to parse: " + e.getLocalizedMessage()));
        }
    }

    public void test_undefine_property_152018() {
        this.helper.setContext((Object)EcorePackage.Literals.ECLASS);
        EStructuralFeature property = null;
        try {
            property = (EStructuralFeature)this.helper.defineAttribute("other : EClass = if eSuperTypes->notEmpty() then eSuperTypes->first() else null endif");
        }
        catch (Exception e) {
            DefExpressionTest.fail((String)("Failed to parse: " + e.getLocalizedMessage()));
        }
        DefExpressionTest.assertNotNull((Object)property);
        this.ocl.getEnvironment().undefine((Object)property);
        DefExpressionTest.assertNull((Object)property.eContainer());
        DefExpressionTest.assertNull((Object)property.eResource());
        try {
            property = (EStructuralFeature)this.helper.defineAttribute("other : EClass = if eSuperTypes->notEmpty() then eSuperTypes->first() else null endif");
        }
        catch (Exception e) {
            DefExpressionTest.fail((String)("Failed to parse: " + e.getLocalizedMessage()));
        }
    }

    public void test_undefine_operation_152018() {
        this.helper.setContext((Object)EcorePackage.Literals.ECLASS);
        EOperation operation = null;
        try {
            operation = (EOperation)this.helper.defineOperation("other(x : Integer) : EClass = if eSuperTypes->notEmpty() then eSuperTypes->at(x) else null endif");
        }
        catch (Exception e) {
            DefExpressionTest.fail((String)("Failed to parse: " + e.getLocalizedMessage()));
        }
        DefExpressionTest.assertNotNull((Object)operation);
        this.ocl.getEnvironment().undefine((Object)operation);
        DefExpressionTest.assertNull((Object)operation.eContainer());
        DefExpressionTest.assertNull((Object)operation.eResource());
        try {
            operation = (EOperation)this.helper.defineOperation("other(x : Integer) : EClass = if eSuperTypes->size() >= x then eSuperTypes->at(x) else null endif");
        }
        catch (Exception e) {
            DefExpressionTest.fail((String)("Failed to parse: " + e.getLocalizedMessage()));
        }
    }

    public void test_recursive_property_152018() {
        this.helper.setContext((Object)EcorePackage.Literals.ECLASS);
        EStructuralFeature property = null;
        try {
            property = (EStructuralFeature)this.helper.defineAttribute("friend : EClass = if eSuperTypes->notEmpty() then ePackage else self endif");
            DefExpressionTest.fail((String)"Should not have parsed");
        }
        catch (Exception e) {
            System.out.println("Got expected error: " + e.getLocalizedMessage());
        }
        try {
            property = (EStructuralFeature)this.helper.defineAttribute("friend : EClass = if eSuperTypes->notEmpty() then eSuperTypes->first().friend else self endif");
        }
        catch (Exception e) {
            DefExpressionTest.fail((String)("Failed to parse: " + e.getLocalizedMessage()));
        }
        DefExpressionTest.assertNotNull((Object)property);
        try {
            this.helper.createInvariant("not friend.oclIsUndefined() implies friend = self");
        }
        catch (Exception e) {
            DefExpressionTest.fail((String)("Failed to parse: " + e.getLocalizedMessage()));
        }
    }

    public void test_recursive_operation_152018() {
        this.helper.setContext((Object)EcorePackage.Literals.ECLASS);
        EOperation operation = null;
        try {
            operation = (EOperation)this.helper.defineOperation("friend(x : Integer) : EClass = if eSuperTypes->size() >= x then ePackage else self endif");
            DefExpressionTest.fail((String)"Should not have parsed");
        }
        catch (Exception e) {
            System.out.println("Got expected error: " + e.getLocalizedMessage());
        }
        try {
            operation = (EOperation)this.helper.defineOperation("friend(x : Integer) : EClass = if eSuperTypes->size() >= x then eSuperTypes->at(x).friend(x) else self endif");
        }
        catch (Exception e) {
            DefExpressionTest.fail((String)("Failed to parse: " + e.getLocalizedMessage()));
        }
        DefExpressionTest.assertNotNull((Object)operation);
        try {
            this.helper.createInvariant("not friend(1).oclIsUndefined() implies friend(1) = self");
        }
        catch (Exception e) {
            DefExpressionTest.fail((String)("Failed to parse: " + e.getLocalizedMessage()));
        }
    }

    public void test_defExpression_completion_operation() {
        this.helper.setContext((Object)EcorePackage.Literals.ECLASSIFIER);
        try {
            this.helper.defineOperation("allParents() : Set(EClassifier) = if self.oclIsKindOf(EClass) then self.oclAsType(EClass)->closure(eSuperTypes) else Set{} endif");
            List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "self.");
            this.assertChoice(choices, ChoiceKind.OPERATION, "allParents");
        }
        catch (Exception e) {
            DefExpressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_defExpression_completion_attribute() {
        this.helper.setContext((Object)EcorePackage.Literals.ECLASSIFIER);
        try {
            this.helper.defineAttribute("allParents : Set(EClassifier) = if self.oclIsKindOf(EClass) then self.oclAsType(EClass)->closure(eSuperTypes) else Set{} endif");
            List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "self.");
            this.assertChoice(choices, ChoiceKind.PROPERTY, "allParents");
        }
        catch (Exception e) {
            DefExpressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_defAttributeOnPrimitiveType_172782() {
        this.helper.setContext((Object)EcorePackage.Literals.ESTRING);
        try {
            EStructuralFeature feature = (EStructuralFeature)this.helper.defineAttribute("reverse : String = Sequence{1..size()}->sortedBy(i | -i)->iterate(i; s : String = '' | s.concat(self.substring(i, i)))");
            this.helper.setContext((Object)((EClassifier)this.ocl.getEnvironment().getOCLStandardLibrary().getString()));
            List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "self.");
            this.assertChoice(choices, ChoiceKind.PROPERTY, "reverse");
            OCLExpression expr = this.helper.createQuery("self.reverse");
            DefExpressionTest.assertEquals((Object)"ablE was i ere I saw elbA", (Object)this.ocl.evaluate((Object)"Able was I ere i saw Elba", expr));
            DefExpressionTest.assertTrue((boolean)TypeUtil.getAttributes((Environment)this.ocl.getEnvironment(), (Object)((EClassifier)this.ocl.getEnvironment().getOCLStandardLibrary().getString())).contains(feature));
            DefExpressionTest.assertTrue((boolean)TypeUtil.getAttributes((Environment)this.ocl.getEnvironment(), (Object)EcorePackage.Literals.ESTRING).contains(feature));
        }
        catch (Exception e) {
            DefExpressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
        OCL localOCL = OCL.newInstance();
        OCL.Helper localHelper = localOCL.createOCLHelper();
        localHelper.setContext((Object)((EClassifier)this.ocl.getEnvironment().getOCLStandardLibrary().getString()));
        try {
            List choices = localHelper.getSyntaxHelp(ConstraintKind.INVARIANT, "self.");
            this.assertNotChoice(choices, ChoiceKind.PROPERTY, "reverse");
            localHelper.createQuery("self.reverse");
            DefExpressionTest.fail((String)"Should have failed to parse the undefined attribute");
        }
        catch (ParserException e) {
            System.out.println("Got the expected exception: " + e.getLocalizedMessage());
        }
    }

    public void test_defOperationOnPrimitiveType_172782() {
        this.helper.setContext((Object)EcorePackage.Literals.ESTRING);
        try {
            EOperation feature = (EOperation)this.helper.defineOperation("reversed() : String = Sequence{1..size()}->sortedBy(i | -i)->iterate(i; s : String = '' | s.concat(self.substring(i, i)))");
            this.helper.setContext((Object)((EClassifier)this.ocl.getEnvironment().getOCLStandardLibrary().getString()));
            List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "self.");
            this.assertChoice(choices, ChoiceKind.OPERATION, "reversed");
            OCLExpression expr = this.helper.createQuery("self.reversed()");
            DefExpressionTest.assertEquals((Object)"ablE was i ere I saw elbA", (Object)this.ocl.evaluate((Object)"Able was I ere i saw Elba", expr));
            DefExpressionTest.assertTrue((boolean)TypeUtil.getOperations((Environment)this.ocl.getEnvironment(), (Object)((EClassifier)this.ocl.getEnvironment().getOCLStandardLibrary().getString())).contains(feature));
            DefExpressionTest.assertTrue((boolean)TypeUtil.getOperations((Environment)this.ocl.getEnvironment(), (Object)EcorePackage.Literals.ESTRING).contains(feature));
        }
        catch (Exception e) {
            DefExpressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
        OCL localOCL = OCL.newInstance();
        OCL.Helper localHelper = localOCL.createOCLHelper();
        localHelper.setContext((Object)((EClassifier)this.ocl.getEnvironment().getOCLStandardLibrary().getString()));
        try {
            List choices = localHelper.getSyntaxHelp(ConstraintKind.INVARIANT, "self.");
            this.assertNotChoice(choices, ChoiceKind.OPERATION, "reversed");
            localHelper.createQuery("self.reversed()");
            DefExpressionTest.fail((String)"Should have failed to parse the undefined operation");
        }
        catch (ParserException e) {
            System.out.println("Got the expected exception: " + e.getLocalizedMessage());
        }
    }

    public void test_defAttributeOnPredefinedType_172782() {
        this.helper.setContext((Object)((EClassifier)this.ocl.getEnvironment().getOCLStandardLibrary().getString()));
        try {
            EStructuralFeature feature = (EStructuralFeature)this.helper.defineAttribute("reverse : String = Sequence{1..size()}->sortedBy(i | -i)->iterate(i; s : String = '' | s.concat(self.substring(i, i)))");
            this.helper.setContext((Object)EcorePackage.Literals.ESTRING);
            List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "self.");
            this.assertChoice(choices, ChoiceKind.PROPERTY, "reverse");
            OCLExpression expr = this.helper.createQuery("self.reverse");
            DefExpressionTest.assertEquals((Object)"ablE was i ere I saw elbA", (Object)this.ocl.evaluate((Object)"Able was I ere i saw Elba", expr));
            DefExpressionTest.assertTrue((boolean)TypeUtil.getAttributes((Environment)this.ocl.getEnvironment(), (Object)((EClassifier)this.ocl.getEnvironment().getOCLStandardLibrary().getString())).contains(feature));
            DefExpressionTest.assertTrue((boolean)TypeUtil.getAttributes((Environment)this.ocl.getEnvironment(), (Object)EcorePackage.Literals.ESTRING).contains(feature));
        }
        catch (Exception e) {
            DefExpressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
        OCL localOCL = OCL.newInstance();
        OCL.Helper localHelper = localOCL.createOCLHelper();
        localHelper.setContext((Object)((EClassifier)this.ocl.getEnvironment().getOCLStandardLibrary().getString()));
        try {
            List choices = localHelper.getSyntaxHelp(ConstraintKind.INVARIANT, "self.");
            this.assertNotChoice(choices, ChoiceKind.PROPERTY, "reverse");
            localHelper.createQuery("self.reverse");
            DefExpressionTest.fail((String)"Should have failed to parse the undefined attribute");
        }
        catch (ParserException e) {
            System.out.println("Got the expected exception: " + e.getLocalizedMessage());
        }
    }

    public void test_defOperationOnPredefinedType_172782() {
        this.helper.setContext((Object)((EClassifier)this.ocl.getEnvironment().getOCLStandardLibrary().getString()));
        try {
            EOperation feature = (EOperation)this.helper.defineOperation("reversed() : String = Sequence{1..size()}->sortedBy(i | -i)->iterate(i; s : String = '' | s.concat(self.substring(i, i)))");
            this.helper.setContext((Object)EcorePackage.Literals.ESTRING);
            List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "self.");
            this.assertChoice(choices, ChoiceKind.OPERATION, "reversed");
            OCLExpression expr = this.helper.createQuery("self.reversed()");
            DefExpressionTest.assertEquals((Object)"ablE was i ere I saw elbA", (Object)this.ocl.evaluate((Object)"Able was I ere i saw Elba", expr));
            DefExpressionTest.assertTrue((boolean)TypeUtil.getOperations((Environment)this.ocl.getEnvironment(), (Object)((EClassifier)this.ocl.getEnvironment().getOCLStandardLibrary().getString())).contains(feature));
            DefExpressionTest.assertTrue((boolean)TypeUtil.getOperations((Environment)this.ocl.getEnvironment(), (Object)EcorePackage.Literals.ESTRING).contains(feature));
        }
        catch (Exception e) {
            DefExpressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
        OCL localOCL = OCL.newInstance();
        OCL.Helper localHelper = localOCL.createOCLHelper();
        localHelper.setContext((Object)((EClassifier)this.ocl.getEnvironment().getOCLStandardLibrary().getString()));
        try {
            List choices = localHelper.getSyntaxHelp(ConstraintKind.INVARIANT, "self.");
            this.assertNotChoice(choices, ChoiceKind.OPERATION, "reversed");
            localHelper.createQuery("self.reversed()");
            DefExpressionTest.fail((String)"Should have failed to parse the undefined operation");
        }
        catch (ParserException e) {
            System.out.println("Got the expected exception: " + e.getLocalizedMessage());
        }
    }

    public void test_defExpression_operation_owner() {
        this.helper.setContext((Object)this.fruit);
        try {
            EOperation o = (EOperation)this.helper.defineOperation("bestColor(c : Color) : Color = if self.color = Color::black then c else self.color endif");
            UMLReflection uml = this.ocl.getEnvironment().getUMLReflection();
            DefExpressionTest.assertSame((Object)this.fruit, (Object)uml.getOwningClassifier((Object)this.fruit_ripen));
            DefExpressionTest.assertSame((Object)this.fruit, (Object)uml.getOwningClassifier((Object)o));
        }
        catch (Exception e) {
            DefExpressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_defExpression_attribute_owner() {
        this.helper.setContext((Object)this.fruit);
        try {
            EStructuralFeature p = (EStructuralFeature)this.helper.defineAttribute("isBlack : Boolean = color = Color::black");
            UMLReflection uml = this.ocl.getEnvironment().getUMLReflection();
            DefExpressionTest.assertSame((Object)this.fruit, (Object)uml.getOwningClassifier((Object)this.fruit_color));
            DefExpressionTest.assertSame((Object)this.fruit, (Object)uml.getOwningClassifier((Object)p));
        }
        catch (Exception e) {
            DefExpressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_def_operation_OclAny_192892() {
        this.helper.setContext((Object)((EClassifier)this.getOCLStandardLibrary().getOclAny()));
        try {
            this.helper.defineOperation("isBlack() : Boolean = true");
        }
        catch (Exception e) {
            DefExpressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
        this.helper.setContext((Object)this.fruit);
        try {
            EObject instance = this.fruitFactory.create(this.apple);
            DefExpressionTest.assertTrue((boolean)this.check(this.helper, instance, "self.isBlack()"));
        }
        catch (Exception e) {
            DefExpressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_def_attribute_OclAny_192892() {
        this.helper.setContext((Object)((EClassifier)this.getOCLStandardLibrary().getOclAny()));
        try {
            this.helper.defineAttribute("isBlack : Boolean = true");
        }
        catch (Exception e) {
            DefExpressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
        this.helper.setContext((Object)this.fruit);
        try {
            EObject instance = this.fruitFactory.create(this.apple);
            DefExpressionTest.assertTrue((boolean)this.check(this.helper, instance, "self.isBlack"));
        }
        catch (Exception e) {
            DefExpressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_defExpression_operation_similarParams_238050() {
        this.helper.setContext((Object)this.fruit);
        try {
            this.helper.defineOperation("displayName(first : String, last : String) : String = if self.color = Color::red then first else last endif");
            OCLExpression expr = this.helper.createQuery("self.displayName('Roger', 'Bacon')");
            EObject anApple = this.fruitFactory.create(this.apple);
            anApple.eSet((EStructuralFeature)this.fruit_color, (Object)this.color_black);
            DefExpressionTest.assertEquals((Object)"Bacon", (Object)this.ocl.evaluate((Object)anApple, expr));
            anApple.eSet((EStructuralFeature)this.fruit_color, (Object)this.color_red);
            DefExpressionTest.assertEquals((Object)"Roger", (Object)this.ocl.evaluate((Object)anApple, expr));
        }
        catch (Exception e) {
            DefExpressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }
}

