/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.ecore.tests;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.OCL;
import org.eclipse.ocl.ecore.SendSignalAction;
import org.eclipse.ocl.ecore.internal.UMLReflectionImpl;
import org.eclipse.ocl.ecore.opposites.EcoreEnvironmentFactoryWithHiddenOpposites;
import org.eclipse.ocl.expressions.ExpressionsPackage;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.tests.TestReflection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EcoreTestReflection
extends UMLReflectionImpl
implements TestReflection<EObject, EPackage, EClassifier, EClassifier, EClass, EDataType, EClassifier, EEnum, EOperation, EParameter, EStructuralFeature, EAttribute, EReference, EEnumLiteral, EObject, CallOperationAction, SendSignalAction, Constraint>,
TestReflection.Static<EObject, EPackage, EClassifier, EClassifier, EClass, EDataType, EClassifier, EEnum, EOperation, EParameter, EStructuralFeature, EAttribute, EReference, EEnumLiteral, EObject, CallOperationAction, SendSignalAction, Constraint> {
    public static final EcoreTestReflection INSTANCE = new EcoreTestReflection();
    public static final String PLUGIN_ID = "org.eclipse.ocl.ecore.tests";
    private Map<String, String> normalizers = null;

    public static OCL createOCL() {
        OCL newInstance = OCL.newInstance();
        String repairs = System.getProperty("org.eclipse.ocl.ecore.tests.repairs");
        if (repairs != null) {
            newInstance.setParserRepairCount(Integer.parseInt(repairs));
        }
        return newInstance;
    }

    public void addSupertype(EClass aClass, EClass superClass) {
        aClass.getESuperTypes().add((Object)superClass);
    }

    public EClass createClass() {
        return EcoreFactory.eINSTANCE.createEClass();
    }

    public EAnnotation createComment() {
        return EcoreFactory.eINSTANCE.createEAnnotation();
    }

    public void createGeneralization(EClassifier special, EClassifier general) {
        if (special instanceof EClass && general instanceof EClass) {
            ((EClass)special).getESuperTypes().add((Object)((EClass)general));
        }
    }

    public EPackage createNestedPackage(EPackage aPackage, String name) {
        EPackage nestedPackage = EcoreFactory.eINSTANCE.createEPackage();
        nestedPackage.setName(name);
        aPackage.getESubpackages().add((Object)nestedPackage);
        return nestedPackage;
    }

    public OCL createOCL(ResourceSet resourceSet) {
        return OCL.newInstance((EnvironmentFactory)new EcoreEnvironmentFactoryWithHiddenOpposites(resourceSet.getPackageRegistry()));
    }

    public EAttribute createOwnedAttribute(EClass aClass, String name, EClassifier type) {
        EAttribute eAttribute = EcoreFactory.eINSTANCE.createEAttribute();
        eAttribute.setName(name);
        eAttribute.setEType(type);
        aClass.getEStructuralFeatures().add((Object)eAttribute);
        return eAttribute;
    }

    public EClass createOwnedClass(EPackage aPackage, String name, boolean isAbstract) {
        EClass eClass = EcoreFactory.eINSTANCE.createEClass();
        eClass.setName(name);
        eClass.setAbstract(isAbstract);
        aPackage.getEClassifiers().add((Object)eClass);
        return eClass;
    }

    public EEnum createOwnedEnumeration(EPackage aPackage, String name) {
        EEnum eEnum = EcoreFactory.eINSTANCE.createEEnum();
        eEnum.setName(name);
        aPackage.getEClassifiers().add((Object)eEnum);
        return eEnum;
    }

    public EEnumLiteral createOwnedLiteral(EEnum anEnumeration, String name) {
        EEnumLiteral eLiteral = EcoreFactory.eINSTANCE.createEEnumLiteral();
        eLiteral.setName(name);
        anEnumeration.getELiterals().add((Object)eLiteral);
        return eLiteral;
    }

    public EOperation createOwnedOperation(EClass aClass, String name, EList<String> paramNames, EList<EClassifier> paramTypes, EClassifier type, boolean isQuery) {
        EOperation eOperation = EcoreFactory.eINSTANCE.createEOperation();
        eOperation.setName(name);
        eOperation.setEType(type);
        if (paramNames != null) {
            int i = 0;
            while (i < paramNames.size()) {
                this.createOwnedParameter(eOperation, (String)paramNames.get(i), (EClassifier)paramTypes.get(i));
                ++i;
            }
        }
        aClass.getEOperations().add((Object)eOperation);
        return eOperation;
    }

    public EParameter createOwnedParameter(EOperation eOperation, String name, EClassifier type) {
        EParameter eParameter = EcoreFactory.eINSTANCE.createEParameter();
        eParameter.setName(name);
        eParameter.setEType(type);
        eOperation.getEParameters().add((Object)eParameter);
        return eParameter;
    }

    public EOperation createOwnedPrimitiveOperation(EClassifier aPrimitiveType, String name, EList<String> paramNames, EList<EClassifier> paramTypes, EClassifier type, boolean isQuery) {
        return this.createOwnedOperation((EClass)aPrimitiveType, name, paramNames, paramTypes, type, isQuery);
    }

    public EClass createOwnedPrimitiveType(EPackage aPackage, String name) {
        EClass eClass = EcoreFactory.eINSTANCE.createEClass();
        eClass.setName(name);
        aPackage.getEClassifiers().add((Object)eClass);
        return eClass;
    }

    public EReference createOwnedReference(EClass aClass, String name, EClass type) {
        EReference eReference = EcoreFactory.eINSTANCE.createEReference();
        eReference.setName(name);
        eReference.setEType((EClassifier)type);
        aClass.getEStructuralFeatures().add((Object)eReference);
        return eReference;
    }

    public EPackage createPackage(String name) {
        EPackage ePackage = EcoreFactory.eINSTANCE.createEPackage();
        ePackage.setName(name);
        return ePackage;
    }

    public TestReflection<EObject, EPackage, EClassifier, EClassifier, EClass, EDataType, EClassifier, EEnum, EOperation, EParameter, EStructuralFeature, EAttribute, EReference, EEnumLiteral, EObject, CallOperationAction, SendSignalAction, Constraint> createReflection(Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> environment) {
        return this;
    }

    public String denormalize(String key) {
        if (this.normalizers == null) {
            this.normalizers = new HashMap<String, String>();
            this.normalizers.put("Date", "EDate");
            this.normalizers.put("Package", "EPackage");
            this.normalizers.put("Reference", "EReference");
            this.normalizers.put("String", "EString");
            this.normalizers.put("Type", "EClassifier");
            this.normalizers.put("container", "eContainer");
            this.normalizers.put("nestedPackage", "eSubpackages");
            this.normalizers.put("nestingPackage", "eSuperPackage");
            this.normalizers.put("opposite", "eOpposite");
            this.normalizers.put("ownedType", "eClassifiers");
            this.normalizers.put("uml", "ecore");
        }
        return this.normalizers.get(key);
    }

    public void disposeResourceSet(ResourceSet resourceSet) {
        if (resourceSet != null) {
            for (Resource res : resourceSet.getResources()) {
                res.unload();
                res.eAdapters().clear();
            }
        }
    }

    public EStructuralFeature getAttribute(EClassifier classifier, String name, EClassifier type) {
        if (!(classifier instanceof EClass)) {
            return null;
        }
        EStructuralFeature feature = ((EClass)classifier).getEStructuralFeature(name);
        if (feature == null) {
            return null;
        }
        return feature;
    }

    public EClassifier getBigDecimal() {
        return EcorePackage.Literals.EBIG_DECIMAL;
    }

    public EClassifier getBigInteger() {
        return EcorePackage.Literals.EBIG_INTEGER;
    }

    public OCLExpression<EClassifier> getBodyExpression(Constraint constraint) {
        return constraint.getSpecification().getBodyExpression();
    }

    public EClassifier getClassTypeContext() {
        return EcorePackage.Literals.ECLASS;
    }

    public EClassifier getClassifierTypeContext() {
        return EcorePackage.Literals.ECLASSIFIER;
    }

    public EClassifier getCollectionKindTypeContext() {
        return ExpressionsPackage.Literals.COLLECTION_KIND;
    }

    public EClassifier getCommentTypeContext() {
        return EcorePackage.Literals.EANNOTATION;
    }

    public Class<Constraint> getConstraintClass() {
        return Constraint.class;
    }

    public EClassifier getDefaultSetType(Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> environment) {
        return EcorePackage.Literals.ERESOURCE;
    }

    public EPackage getEPackage(EPackage pkg) {
        return pkg;
    }

    public EClassifier getEcoreBigDecimal() {
        return EcorePackage.Literals.EBIG_DECIMAL;
    }

    public EClassifier getEcoreBigInteger() {
        return EcorePackage.Literals.EBIG_INTEGER;
    }

    public EClassifier getEcoreLong() {
        return EcorePackage.Literals.ELONG;
    }

    public EPackage getEcorePrimitiveTypes() {
        throw new UnsupportedOperationException(String.valueOf(((Object)((Object)this)).getClass().getName()) + ".getEcorePrimitiveTypes");
    }

    public String getFruitModelPath() {
        return "/model/OCLTest.ecore";
    }

    public EClassifier getMetaclass(String name) {
        return EcorePackage.eINSTANCE.getEClassifier(name);
    }

    public EClassifier getMetametaclass(String name) {
        return EcorePackage.eINSTANCE.getEClassifier(name);
    }

    public String getNsURI(EPackage aPackage) {
        return aPackage.getNsURI();
    }

    public EPackage getOCLExpressionTypes() {
        throw new UnsupportedOperationException(String.valueOf(((Object)((Object)this)).getClass().getName()) + ".getOCLExpressionTypes");
    }

    public EClassifier getOwnedType(EPackage aPackage, String name) {
        return aPackage.getEClassifier(name);
    }

    public EClassifier getOwner(EOperation context) {
        return context.getEContainingClass();
    }

    public EPackage getResourcePackage(ResourceSet resourceSet, URI uri) {
        Resource res = resourceSet.getResource(uri, true);
        return (EPackage)res.getContents().get(0);
    }

    public EClassifier getStringTypeContext() {
        return EcorePackage.Literals.ESTRING;
    }

    public String getTestPlugInId() {
        return PLUGIN_ID;
    }

    public EDataType getUMLBoolean() {
        return EcorePackage.Literals.EBOOLEAN;
    }

    public EClassifier getUMLInteger() {
        return EcorePackage.Literals.EINT;
    }

    public EClassifier getUMLLong() {
        return EcorePackage.Literals.ELONG;
    }

    public EPackage getUMLMetamodel() {
        return EcorePackage.eINSTANCE;
    }

    public EPackage getUMLPrimitiveTypes() {
        throw new UnsupportedOperationException(String.valueOf(((Object)((Object)this)).getClass().getName()) + ".getUMLPrimitiveTypes");
    }

    public EDataType getUMLString() {
        return EcorePackage.Literals.ESTRING;
    }

    public EDataType getUMLUnlimitedNatural() {
        throw new UnsupportedOperationException(String.valueOf(((Object)((Object)this)).getClass().getName()) + ".getUnlimitedNatural");
    }

    public int getUnlimitedValue() {
        return -1;
    }

    public ResourceSet createResourceSet() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
        resourceSet.getPackageRegistry().put((Object)EcorePackage.eINSTANCE.getNsURI(), (Object)EcorePackage.eINSTANCE);
        return resourceSet;
    }

    public boolean isOrdered(String key) {
        return "nestedPackage".equals(key);
    }

    public boolean isUnique(String key) {
        return "nestedPackage".equals(key);
    }

    public void setAbstract(EClass aClass, boolean isAbstract) {
        aClass.setAbstract(isAbstract);
    }

    public void setIsOrdered(EStructuralFeature aProperty, boolean isOrdered) {
        aProperty.setOrdered(isOrdered);
    }

    public void setIsQuery(EOperation anOperation, boolean isQuery) {
    }

    public void setIsUnique(EStructuralFeature aProperty, boolean isUnique) {
        aProperty.setUnique(isUnique);
    }

    public void setName(EClass aClass, String name) {
        aClass.setName(name);
    }

    public void setNsPrefix(EPackage aPackage, String name) {
        aPackage.setNsPrefix(name);
    }

    public void setNsURI(EPackage aPackage, String name) {
        aPackage.setNsPrefix(name);
    }

    public void setOperationUpper(EOperation anOperation, int value) {
        anOperation.setUpperBound(value);
    }

    public void setUpper(EStructuralFeature aProperty, int value) {
        aProperty.setUpperBound(value);
    }

    public boolean usesCompareTo() {
        return true;
    }
}

