/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.ecore.tests;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import junit.framework.AssertionFailedError;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.SetType;
import org.eclipse.ocl.ecore.tests.AbstractTestSuite;
import org.eclipse.ocl.expressions.OCLExpression;

public class InitOrDerExpressionTest
extends AbstractTestSuite {
    EClass banana;
    Set<EObject> allApples;
    Map<EClass, Set<EObject>> extents;
    EObject aFruit;
    EObject anApple;
    EObject anotherApple;

    public void test_init_attribute_raw() {
        try {
            OCLExpression expr = this.parseDef("package ocltest context Fruit::name : String init: '' endpackage");
            Constraint constraint = (Constraint)expr.eContainer().eContainer();
            InitOrDerExpressionTest.assertNotNull((Object)constraint);
            InitOrDerExpressionTest.assertEquals((String)"initial", (String)constraint.getStereotype());
            InitOrDerExpressionTest.assertSame((Object)this.getOCLStandardLibrary().getString(), (Object)expr.getType());
        }
        catch (Exception e) {
            InitOrDerExpressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_derive_attribute_raw() {
        try {
            OCLExpression expr = this.parseDef("package ocltest context Fruit::name : String derive: if self.oclIsKindOf(Apple) then 'apple' else 'unknown fruit' endif endpackage");
            Constraint constraint = (Constraint)expr.eContainer().eContainer();
            InitOrDerExpressionTest.assertNotNull((Object)constraint);
            InitOrDerExpressionTest.assertEquals((String)"derivation", (String)constraint.getStereotype());
            InitOrDerExpressionTest.assertSame((Object)this.getOCLStandardLibrary().getString(), (Object)expr.getType());
            expr = this.parse("package ocltest context Fruit inv: name endpackage");
            InitOrDerExpressionTest.assertEquals((Object)"unknown fruit", (Object)this.ocl.evaluate((Object)this.aFruit, expr));
            InitOrDerExpressionTest.assertEquals((Object)"apple", (Object)this.ocl.evaluate((Object)this.anApple, expr));
        }
        catch (Exception e) {
            InitOrDerExpressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_init_reference_raw() {
        try {
            OCLExpression expr = this.parseDef("package ocltest context Fruit::relatedFruits : Set(Fruit) init: Set{self} endpackage");
            Constraint constraint = (Constraint)expr.eContainer().eContainer();
            InitOrDerExpressionTest.assertNotNull((Object)constraint);
            InitOrDerExpressionTest.assertEquals((String)"initial", (String)constraint.getStereotype());
            InitOrDerExpressionTest.assertTrue((boolean)(expr.getType() instanceof SetType));
            InitOrDerExpressionTest.assertSame((Object)this.fruit, (Object)((SetType)expr.getType()).getElementType());
        }
        catch (Exception e) {
            InitOrDerExpressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_derive_reference_raw() {
        try {
            OCLExpression expr = this.parseDef("package ocltest context Fruit::relatedFruits : Set(Fruit) derive: if self.oclIsKindOf(Apple) then Apple.allInstances()->excluding(self.oclAsType(Apple)) else Fruit.allInstances()->excluding(self) endif endpackage");
            Constraint constraint = (Constraint)expr.eContainer().eContainer();
            InitOrDerExpressionTest.assertNotNull((Object)constraint);
            InitOrDerExpressionTest.assertEquals((String)"derivation", (String)constraint.getStereotype());
            InitOrDerExpressionTest.assertTrue((boolean)(expr.getType() instanceof SetType));
            InitOrDerExpressionTest.assertSame((Object)this.fruit, (Object)((SetType)expr.getType()).getElementType());
            expr = this.parse("package ocltest context Fruit inv: relatedFruits endpackage");
            this.ocl.setExtentMap(this.extents);
            InitOrDerExpressionTest.assertEquals(this.allApples, (Object)this.ocl.evaluate((Object)this.aFruit, expr));
            InitOrDerExpressionTest.assertEquals(Collections.singleton(this.anotherApple), (Object)this.ocl.evaluate((Object)this.anApple, expr));
        }
        catch (Exception e) {
            InitOrDerExpressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_init_attribute_helper() {
        this.helper.setAttributeContext((Object)this.fruit, (Object)this.fruit.getEStructuralFeature("name"));
        try {
            Constraint constraint = (Constraint)this.helper.createInitialValueExpression("''");
            InitOrDerExpressionTest.assertNotNull((Object)constraint);
            InitOrDerExpressionTest.assertEquals((String)"initial", (String)constraint.getStereotype());
            InitOrDerExpressionTest.assertSame((Object)this.getOCLStandardLibrary().getString(), (Object)constraint.getSpecification().getBodyExpression().getType());
        }
        catch (Exception e) {
            InitOrDerExpressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_derive_attribute_helper() {
        this.helper.setAttributeContext((Object)this.fruit, (Object)this.fruit.getEStructuralFeature("name"));
        try {
            Constraint constraint = (Constraint)this.helper.createDerivedValueExpression("if self.oclIsKindOf(Apple) then 'apple' else 'unknown fruit' endif");
            InitOrDerExpressionTest.assertNotNull((Object)constraint);
            InitOrDerExpressionTest.assertEquals((String)"derivation", (String)constraint.getStereotype());
            InitOrDerExpressionTest.assertSame((Object)this.getOCLStandardLibrary().getString(), (Object)constraint.getSpecification().getBodyExpression().getType());
            OCLExpression expr = this.helper.createQuery("name");
            InitOrDerExpressionTest.assertEquals((Object)"unknown fruit", (Object)this.ocl.evaluate((Object)this.aFruit, expr));
            InitOrDerExpressionTest.assertEquals((Object)"apple", (Object)this.ocl.evaluate((Object)this.anApple, expr));
        }
        catch (Exception e) {
            InitOrDerExpressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_init_reference_helper() {
        this.helper.setAttributeContext((Object)this.fruit, (Object)this.fruit.getEStructuralFeature("relatedFruits"));
        try {
            Constraint constraint = (Constraint)this.helper.createInitialValueExpression("Set{self}");
            InitOrDerExpressionTest.assertNotNull((Object)constraint);
            OCLExpression expr = constraint.getSpecification().getBodyExpression();
            InitOrDerExpressionTest.assertEquals((String)"initial", (String)constraint.getStereotype());
            InitOrDerExpressionTest.assertTrue((boolean)(expr.getType() instanceof SetType));
            InitOrDerExpressionTest.assertSame((Object)this.fruit, (Object)((SetType)expr.getType()).getElementType());
        }
        catch (Exception e) {
            InitOrDerExpressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_derive_reference_helper() {
        this.helper.setAttributeContext((Object)this.fruit, (Object)this.fruit.getEStructuralFeature("relatedFruits"));
        try {
            Constraint constraint = (Constraint)this.helper.createDerivedValueExpression("if self.oclIsKindOf(Apple) then Apple.allInstances()->excluding(self.oclAsType(Apple)) else Fruit.allInstances()->excluding(self) endif");
            InitOrDerExpressionTest.assertNotNull((Object)constraint);
            OCLExpression expr = constraint.getSpecification().getBodyExpression();
            InitOrDerExpressionTest.assertEquals((String)"derivation", (String)constraint.getStereotype());
            InitOrDerExpressionTest.assertTrue((boolean)(expr.getType() instanceof SetType));
            InitOrDerExpressionTest.assertSame((Object)this.fruit, (Object)((SetType)expr.getType()).getElementType());
            expr = this.helper.createQuery("relatedFruits");
            InitOrDerExpressionTest.assertEquals(this.allApples, (Object)this.ocl.evaluate((Object)this.aFruit, expr));
            InitOrDerExpressionTest.assertEquals(Collections.singleton(this.anotherApple), (Object)this.ocl.evaluate((Object)this.anApple, expr));
        }
        catch (Exception e) {
            InitOrDerExpressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_malformedInitExpression() {
        this.helper.setAttributeContext((Object)this.fruit, (Object)this.fruit.getEStructuralFeature("relatedFruits"));
        try {
            this.helper.createInitialValueExpression("if self.oclIsKindOf(Apple) then 'apple' else 'fruit' endif");
            InitOrDerExpressionTest.fail((String)"Should not have parsed");
        }
        catch (Exception e) {
            System.out.println("Got expected error: " + e.getLocalizedMessage());
        }
    }

    public void test_malformedDeriveExpression() {
        this.helper.setAttributeContext((Object)this.fruit, (Object)this.fruit.getEStructuralFeature("relatedFruits"));
        try {
            this.helper.createDerivedValueExpression("if self.oclIsKindOf(Apple) then 'apple' else 'fruit' endif");
            InitOrDerExpressionTest.fail((String)"Should not have parsed");
        }
        catch (Exception e) {
            System.out.println("Got expected error: " + e.getLocalizedMessage());
        }
    }

    public void test_bothInitAndDeriveExpressions() {
        try {
            this.parseDef("package ocltest context Fruit::name : String init: 'not a fruit' derive: if self.oclIsKindOf(Apple) then 'apple' else 'unknown fruit' endif  endpackage");
            this.parseDef("package ocltest context Fruit::name : String derive: if self.oclIsKindOf(Apple) then 'apple' else 'unknown fruit' endif init: 'not a fruit'  endpackage");
        }
        catch (Exception e) {
            InitOrDerExpressionTest.fail((String)("Should not have failed to parse: " + e.getLocalizedMessage()));
        }
    }

    public void test_tooManyInitAndDeriveExpressions() {
        AssertionFailedError err = null;
        try {
            this.parseDef("package ocltest context Fruit::name : String init: 'not a fruit' init: 'not a fruit'  endpackage");
        }
        catch (AssertionFailedError e) {
            err = e;
            System.out.println("Got expected error: " + e.getLocalizedMessage());
        }
        InitOrDerExpressionTest.assertNotNull((String)"Should not have successfully parsed", (Object)((Object)err));
        err = null;
        try {
            this.parseDef("package ocltest context Fruit::name : String derive: if self.oclIsKindOf(Apple) then 'apple' else 'unknown fruit' endif derive: if self.oclIsKindOf(Apple) then 'apple' else 'unknown fruit' endif  endpackage");
        }
        catch (AssertionFailedError e) {
            err = e;
            System.out.println("Got expected error: " + e.getLocalizedMessage());
        }
        InitOrDerExpressionTest.assertNotNull((String)"Should not have successfully parsed", (Object)((Object)err));
        err = null;
        try {
            this.parseDef("package ocltest context Fruit::name : String init: 'not a fruit' derive: if self.oclIsKindOf(Apple) then 'apple' else 'unknown fruit' endif init: 'not a fruit'  endpackage");
        }
        catch (AssertionFailedError e) {
            err = e;
            System.out.println("Got expected error: " + e.getLocalizedMessage());
        }
        InitOrDerExpressionTest.assertNotNull((String)"Should not have successfully parsed", (Object)((Object)err));
        err = null;
        try {
            this.parseDef("package ocltest context Fruit::name : String derive: if self.oclIsKindOf(Apple) then 'apple' else 'unknown fruit' endif init: 'not a fruit' derive: if self.oclIsKindOf(Apple) then 'apple' else 'unknown fruit' endif  endpackage");
        }
        catch (AssertionFailedError e) {
            err = e;
            System.out.println("Got expected error: " + e.getLocalizedMessage());
        }
        InitOrDerExpressionTest.assertNotNull((String)"Should not have successfully parsed", (Object)((Object)err));
        err = null;
    }

    protected void setUp() {
        super.setUp();
        this.expectModified = true;
        this.banana = EcoreFactory.eINSTANCE.createEClass();
        this.banana.setName("Banana");
        this.banana.getESuperTypes().add((Object)this.fruit);
        ((EPackage)this.fruitPackage).getEClassifiers().add((Object)this.banana);
        this.aFruit = this.fruitFactory.create(this.banana);
        this.anApple = this.fruitFactory.create(this.apple);
        this.anotherApple = this.fruitFactory.create(this.apple);
        this.allApples = new HashSet<EObject>();
        this.allApples.add(this.anApple);
        this.allApples.add(this.anotherApple);
        this.extents = new HashMap<EClass, Set<EObject>>();
        this.extents.put(this.apple, this.allApples);
        this.extents.put(this.banana, Collections.singleton(this.aFruit));
        HashSet<EObject> allFruits = new HashSet<EObject>();
        allFruits.addAll(this.allApples);
        allFruits.add(this.aFruit);
        this.extents.put(this.fruit, allFruits);
        ResourceImpl res = new ResourceImpl();
        res.getContents().addAll(allFruits);
    }

    protected void tearDown() throws Exception {
        this.extents = null;
        this.allApples = null;
        ((EPackage)this.fruitPackage).getEClassifiers().remove((Object)this.banana);
        this.banana = null;
        super.tearDown();
    }
}

