/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.ecore.tests;

import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.common.preferences.PreferenceableOption;
import org.eclipse.ocl.ecore.tests.AbstractTestSuite;
import org.eclipse.ocl.lpg.BasicEnvironment;
import org.eclipse.ocl.lpg.ProblemHandler;
import org.eclipse.ocl.options.Option;
import org.eclipse.ocl.options.ProblemOption;
import org.eclipse.ocl.util.OCLUtil;

public class ProblemOptionTest
extends AbstractTestSuite {
    public void test_stringCaseConversion_option() {
        this.helper.setContext((Object)EcorePackage.Literals.ESTRING);
        BasicEnvironment benv = (BasicEnvironment)OCLUtil.getAdapter((Environment)this.ocl.getEnvironment(), BasicEnvironment.class);
        this.assertWarning("self.toUpper()");
        this.assertWarning("self.toLower()");
        benv.setOption((Option)ProblemOption.STRING_CASE_CONVERSION, (Object)ProblemHandler.Severity.OK);
        this.assertOK("self.toUpper()");
        this.assertOK("self.toLower()");
        benv.setOption((Option)ProblemOption.STRING_CASE_CONVERSION, (Object)ProblemHandler.Severity.ERROR);
        this.assertError("self.toUpper()");
        this.assertError("self.toLower()");
        if (EcorePlugin.IS_ECLIPSE_RUNNING) {
            benv.removeOption((Option)ProblemOption.STRING_CASE_CONVERSION);
            EclipseSupport.setPreference(ProblemOption.STRING_CASE_CONVERSION, ConfigurationScope.INSTANCE, ProblemHandler.Severity.WARNING);
            this.assertWarning("self.toUpper()");
            benv.removeOption((Option)ProblemOption.STRING_CASE_CONVERSION);
            EclipseSupport.setPreference(ProblemOption.STRING_CASE_CONVERSION, ConfigurationScope.INSTANCE, ProblemHandler.Severity.OK);
            this.assertOK("self.toUpper()");
            benv.removeOption((Option)ProblemOption.STRING_CASE_CONVERSION);
            EclipseSupport.setPreference(ProblemOption.STRING_CASE_CONVERSION, ConfigurationScope.INSTANCE, ProblemHandler.Severity.ERROR);
            this.assertError("self.toUpper()");
            EclipseSupport.removePreference(ProblemOption.STRING_CASE_CONVERSION, ConfigurationScope.INSTANCE);
        }
    }

    public void test_closure_option() {
        this.helper.setContext((Object)EcorePackage.Literals.EPACKAGE);
        BasicEnvironment benv = (BasicEnvironment)OCLUtil.getAdapter((Environment)this.ocl.getEnvironment(), BasicEnvironment.class);
        this.assertOK("self->closure(eSuperPackage)");
        benv.setOption((Option)ProblemOption.CLOSURE_ITERATOR, (Object)ProblemHandler.Severity.WARNING);
        this.assertWarning("self->closure(eSuperPackage)");
        benv.setOption((Option)ProblemOption.CLOSURE_ITERATOR, (Object)ProblemHandler.Severity.OK);
        this.assertOK("self->closure(eSuperPackage)");
        benv.setOption((Option)ProblemOption.CLOSURE_ITERATOR, (Object)ProblemHandler.Severity.ERROR);
        this.assertError("self->closure(eSuperPackage)");
    }

    public void test_singleQuoteEscape_option() {
        this.helper.setContext((Object)EcorePackage.Literals.ESTRING);
        BasicEnvironment benv = (BasicEnvironment)OCLUtil.getAdapter((Environment)this.ocl.getEnvironment(), BasicEnvironment.class);
        benv.setOption((Option)ProblemOption.STRING_SINGLE_QUOTE_ESCAPE, (Object)ProblemHandler.Severity.OK);
        this.assertOK("'this isn''t a nice string'");
        benv.setOption((Option)ProblemOption.STRING_SINGLE_QUOTE_ESCAPE, (Object)ProblemHandler.Severity.ERROR);
    }

    public void test_doubleQuoteElementName_option() {
        this.helper.setContext((Object)EcorePackage.Literals.EPACKAGE);
        BasicEnvironment benv = (BasicEnvironment)OCLUtil.getAdapter((Environment)this.ocl.getEnvironment(), BasicEnvironment.class);
        this.assertWarning("self.\"eClassifiers\"");
        benv.setOption((Option)ProblemOption.ELEMENT_NAME_QUOTE_ESCAPE, (Object)ProblemHandler.Severity.OK);
        this.assertOK("self.\"eClassifiers\"");
        benv.setOption((Option)ProblemOption.ELEMENT_NAME_QUOTE_ESCAPE, (Object)ProblemHandler.Severity.ERROR);
        this.assertError("self.\"eClassifiers\"");
    }

    void assertOK(String oclQuery) {
        try {
            this.helper.createQuery(oclQuery);
            Diagnostic problem = this.helper.getProblems();
            ProblemOptionTest.assertNull((Object)problem);
        }
        catch (Exception e) {
            ProblemOptionTest.fail((String)("Failed to parse: " + e.getLocalizedMessage()));
        }
    }

    void assertWarning(String oclQuery) {
        try {
            this.helper.createQuery(oclQuery);
            Diagnostic problem = this.helper.getProblems();
            ProblemOptionTest.assertNotNull((Object)problem);
            ProblemOptionTest.assertEquals((int)2, (int)problem.getSeverity());
        }
        catch (Exception e) {
            ProblemOptionTest.fail((String)("Failed to parse: " + e.getLocalizedMessage()));
        }
    }

    void assertError(String oclQuery) {
        try {
            this.helper.createQuery(oclQuery);
            ProblemOptionTest.fail((String)"Should have failed to parse");
        }
        catch (ParserException e) {
            System.out.println("Got expected exception: " + e.getLocalizedMessage());
        }
        catch (Exception e) {
            ProblemOptionTest.fail((String)("Failed to parse for unexpected reason: " + e.getLocalizedMessage()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EclipseSupport {
        private EclipseSupport() {
        }

        public static void removePreference(PreferenceableOption<?> option, IScopeContext context) {
            try {
                IEclipsePreferences preferences = context.getNode(option.getPluginId());
                preferences.remove(option.getKey());
                preferences.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public static <T> void setPreference(PreferenceableOption<T> option, IScopeContext context, T value) {
            try {
                IEclipsePreferences preferences = context.getNode(option.getPluginId());
                preferences.put(option.getKey(), value.toString());
                preferences.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

