/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.ecore.tests;

import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.EcoreEnvironment;
import org.eclipse.ocl.ecore.EcoreEnvironmentFactory;
import org.eclipse.ocl.ecore.OCL;
import org.eclipse.ocl.ecore.SendSignalAction;
import org.eclipse.ocl.ecore.internal.UMLReflectionImpl;
import org.eclipse.ocl.ecore.tests.AbstractTestSuite;
import org.eclipse.ocl.helper.ChoiceKind;
import org.eclipse.ocl.helper.ConstraintKind;
import org.eclipse.ocl.utilities.UMLReflection;

public class StatesTest
extends AbstractTestSuite {
    private static final List<String> FRUIT_BAD = Arrays.asList("Bad");

    public void test_isInState() {
        this.helper.setContext((Object)this.fruit);
        try {
            this.helper.createInvariant("oclIsInState(Ripe) implies not self.oclIsInState(Bad)");
            this.helper.createInvariant("Apple.allInstances()->forAll(not oclIsInState(Bad::Rotten))");
        }
        catch (Exception e) {
            StatesTest.fail((String)("Failed to parse: " + e.getLocalizedMessage()));
        }
        try {
            this.helper.createInvariant("Fruit.allInstances()->forAll(not oclIsInState(Bad::Rotten))");
            StatesTest.fail((String)"Should have failed to parse non-existent state");
        }
        catch (Exception e) {
            System.out.println("Got expected error: " + e.getLocalizedMessage());
        }
    }

    public void test_isInState_validation() {
        this.helper.setContext((Object)this.fruit);
        try {
            this.helper.createInvariant("self.oclIsInState()");
            StatesTest.fail((String)"Should have failed to parse empty arglist");
        }
        catch (Exception e) {
            System.out.println("Got expected error: " + e.getLocalizedMessage());
        }
        try {
            this.helper.createInvariant("Apple.allInstances()->forAll(oclIsInState(Bad, Rotten))");
            StatesTest.fail((String)"Should have failed to parse overabundant arglist");
        }
        catch (Exception e) {
            System.out.println("Got expected error: " + e.getLocalizedMessage());
        }
        try {
            this.helper.createInvariant("self.oclIsInState(color <> Color::black)");
            StatesTest.fail((String)"Should have failed to parse arg of wrong type");
        }
        catch (Exception e) {
            System.out.println("Got expected error: " + e.getLocalizedMessage());
        }
        try {
            this.helper.createInvariant("self.oclIsInState(OclTest::Fruit)");
            StatesTest.fail((String)"Should have failed to parse arg of wrong type");
        }
        catch (Exception e) {
            System.out.println("Got expected error: " + e.getLocalizedMessage());
        }
    }

    public void test_stateContentAssist() {
        this.helper.setContext((Object)this.fruit);
        try {
            List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "self.oclIsInState(");
            StatesTest.assertNotNull((Object)choices);
            this.assertChoice(choices, ChoiceKind.STATE, "Ripe");
            this.assertChoice(choices, ChoiceKind.STATE, "Bad");
            choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "self.oclIsInState(Ripe::");
            StatesTest.assertNotNull((Object)choices);
            StatesTest.assertTrue((boolean)choices.isEmpty());
            choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "Apple.allInstances()->forAll(a : Apple | a.oclIsInState(");
            StatesTest.assertNotNull((Object)choices);
            this.assertChoice(choices, ChoiceKind.STATE, "Ripe");
            this.assertChoice(choices, ChoiceKind.STATE, "Bad");
            choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "Apple.allInstances()->forAll(a : Apple | a.oclIsInState(Bad::");
            StatesTest.assertNotNull((Object)choices);
            this.assertChoice(choices, ChoiceKind.STATE, "Bruised");
            this.assertChoice(choices, ChoiceKind.STATE, "Rotten");
        }
        catch (Exception e) {
            StatesTest.fail((String)("Parse failed: " + e.getLocalizedMessage()));
        }
    }

    protected OCL createOCL() {
        return OCL.newInstance((EnvironmentFactory)new StatefulFruitEnvironmentFactory(this));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StatefulFruitEnvironment
    extends EcoreEnvironment {
        protected final AbstractTestSuite suite;
        private EObject fruitRipe;
        private EObject fruitBad;
        private EObject appleBruised;
        private EObject appleRotten;

        public StatefulFruitEnvironment(StatefulFruitEnvironmentFactory factory, AbstractTestSuite suite) {
            super((EcoreEnvironmentFactory)factory, null);
            this.suite = suite;
            this.setContextPackage((EPackage)suite.fruitPackage);
            this.initStates();
        }

        public StatefulFruitEnvironment(StatefulFruitEnvironmentFactory factory, Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> parent, AbstractTestSuite suite) {
            super(parent);
            this.suite = suite;
            this.initStates();
        }

        private void initStates() {
            this.fruitRipe = EcoreFactory.eINSTANCE.createEObject();
            ((InternalEObject)this.fruitRipe).eSetClass((EClass)this.getOCLStandardLibrary().getState());
            this.fruitBad = EcoreFactory.eINSTANCE.createEObject();
            ((InternalEObject)this.fruitBad).eSetClass((EClass)this.getOCLStandardLibrary().getState());
            this.appleBruised = EcoreFactory.eINSTANCE.createEObject();
            ((InternalEObject)this.appleBruised).eSetClass((EClass)this.getOCLStandardLibrary().getState());
            this.appleRotten = EcoreFactory.eINSTANCE.createEObject();
            ((InternalEObject)this.appleRotten).eSetClass((EClass)this.getOCLStandardLibrary().getState());
        }

        protected void collectStates(EClassifier owner, List<String> pathPrefix, List<EObject> states) {
            if (owner == this.suite.fruit) {
                if (pathPrefix.isEmpty()) {
                    states.add(this.fruitRipe);
                    states.add(this.fruitBad);
                }
            } else if (owner == this.suite.apple) {
                if (pathPrefix.isEmpty()) {
                    states.add(this.fruitBad);
                } else if (pathPrefix.equals(FRUIT_BAD)) {
                    states.add(this.appleBruised);
                    states.add(this.appleRotten);
                }
            }
        }

        public UMLReflection<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint> getUMLReflection() {
            return new UMLReflectionImpl(){

                public String getName(Object namedElement) {
                    if (namedElement == StatefulFruitEnvironment.this.fruitRipe) {
                        return "Ripe";
                    }
                    if (namedElement == StatefulFruitEnvironment.this.fruitBad) {
                        return "Bad";
                    }
                    if (namedElement == StatefulFruitEnvironment.this.appleBruised) {
                        return "Bruised";
                    }
                    if (namedElement == StatefulFruitEnvironment.this.appleRotten) {
                        return "Rotten";
                    }
                    return super.getName(namedElement);
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StatefulFruitEnvironmentFactory
    extends EcoreEnvironmentFactory {
        protected final AbstractTestSuite suite;

        public StatefulFruitEnvironmentFactory(AbstractTestSuite suite) {
            this.suite = suite;
        }

        public EcoreEnvironment createEnvironment() {
            return new StatefulFruitEnvironment(this, this.suite);
        }

        public EcoreEnvironment createEnvironment(Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> parent) {
            return new StatefulFruitEnvironment(this, parent, this.suite);
        }
    }
}

