/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.uml.tests;

import java.util.HashMap;
import java.util.HashSet;
import junit.framework.AssertionFailedError;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.uml.tests.AbstractTestSuite;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Reception;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.VisibilityKind;
import org.eclipse.uml2.uml.util.UMLUtil;

public class UMLTest
extends AbstractTestSuite {
    Resource instanceResource;
    Package instancePackage;

    public void test_importedElements() {
        this.expectModified = true;
        Package imported = UMLFactory.eINSTANCE.createPackage();
        imported.createOwnedClass("Foo", false).createOwnedAttribute("boo", (Type)this.getUMLBoolean());
        ((Package)this.fruitPackage).createPackageImport(imported);
        this.parseConstraint("package ocltest context Fruit inv: self.oclIsKindOf(Foo) implies self.oclAsType(Foo).boo endpackage");
    }

    public void test_redefinedProperties() {
        InstanceSpecification apple1 = this.instantiate(this.instancePackage, (Classifier)this.apple);
        InstanceSpecification apple2 = this.instantiate(this.instancePackage, (Classifier)this.apple);
        InstanceSpecification apple3 = this.instantiate(this.instancePackage, (Classifier)this.apple);
        HashSet<InstanceSpecification> apples = new HashSet<InstanceSpecification>();
        apples.add(apple1);
        apples.add(apple2);
        apples.add(apple3);
        InstanceSpecification anApple = this.instantiate(this.instancePackage, (Classifier)this.apple);
        this.addValue(anApple, this.apple_appleFriends, apple1);
        this.addValue(anApple, this.apple_appleFriends, apple2);
        this.addValue(anApple, this.apple_appleFriends, apple3);
        OCLExpression expr = this.parse("package ocltest context Fruit inv: self.friends endpackage");
        UMLTest.assertEquals(apples, (Object)this.evaluate(expr, anApple));
    }

    public void test_staticOperations_dot_bug164887() {
        this.expectModified = true;
        try {
            this.fruit_ripen.setIsStatic(true);
            this.parseConstraint("package ocltest context Apple inv: self.ripen(Color::black) endpackage");
            this.parseConstraint("package ocltest context Apple inv: Fruit.ripen(Color::black) endpackage");
            this.parseConstraint("package UML context Classifier inv: ocltest::Fruit.ripen(ocltest::Color::black) endpackage");
        }
        finally {
            this.fruit_ripen.setIsStatic(false);
        }
    }

    public void test_staticOperations_colonColon_bug164887() {
        this.expectModified = true;
        try {
            this.fruit_ripen.setIsStatic(true);
            this.parseConstraint("package ocltest context Apple inv: Fruit::ripen(Color::black) endpackage");
            this.parseConstraint("package UML context Classifier inv: ocltest::Fruit::ripen(ocltest::Color::black) endpackage");
        }
        finally {
            this.fruit_ripen.setIsStatic(false);
        }
    }

    public void test_staticAttributes_dot_bug164887() {
        this.expectModified = true;
        try {
            this.fruit_color.setIsStatic(true);
            this.parseConstraint("package ocltest context Apple inv: self.color = Color::black endpackage");
            this.parseConstraint("package ocltest context Apple inv: Fruit.color = Color::black endpackage");
            this.parseConstraint("package UML context Classifier inv: ocltest::Fruit.color = ocltest::Color::black endpackage");
        }
        finally {
            this.fruit_color.setIsStatic(false);
        }
    }

    public void test_staticAttributes_colonColon_bug164887() {
        this.expectModified = true;
        try {
            this.fruit_color.setIsStatic(true);
            this.parseConstraint("package ocltest context Apple inv: Fruit::color = Color::black endpackage");
            this.parseConstraint("package UML context Classifier inv: ocltest::Fruit::color = ocltest::Color::black endpackage");
        }
        finally {
            this.fruit_color.setIsStatic(false);
        }
    }

    public void test_staticOperations_dot_val_bug164887() {
        try {
            this.parseConstraint("package ocltest context Apple inv: Fruit.ripen(Color::black) endpackage");
            UMLTest.fail((String)"Should have failed to parse");
        }
        catch (AssertionFailedError e) {
            System.out.println("Got expected error: " + e.getLocalizedMessage());
        }
        try {
            this.parseConstraint("package UML context Classifier inv: ocltest::Fruit.ripen(ocltest::Color::black) endpackage");
            UMLTest.fail((String)"Should have failed to parse");
        }
        catch (AssertionFailedError e) {
            System.out.println("Got expected error: " + e.getLocalizedMessage());
        }
    }

    public void test_staticOperations_colonColon_val_bug164887() {
        try {
            this.parseConstraint("package ocltest context Apple inv: Fruit::ripen(Color::black) endpackage");
            UMLTest.fail((String)"Should have failed to parse");
        }
        catch (AssertionFailedError e) {
            System.out.println("Got expected error: " + e.getLocalizedMessage());
        }
        try {
            this.parseConstraint("package UML context Classifier inv: ocltest::Fruit::ripen(ocltest::Color::black) endpackage");
            UMLTest.fail((String)"Should have failed to parse");
        }
        catch (AssertionFailedError e) {
            System.out.println("Got expected error: " + e.getLocalizedMessage());
        }
    }

    public void test_staticAttributes_dot_val_bug164887() {
        try {
            this.parseConstraint("package ocltest context Apple inv: Fruit.color = Color::black endpackage");
            UMLTest.fail((String)"Should have failed to parse");
        }
        catch (AssertionFailedError e) {
            System.out.println("Got expected error: " + e.getLocalizedMessage());
        }
        try {
            this.parseConstraint("package UML context Classifier inv: ocltest::Fruit.color = ocltest::Color::black endpackage");
            UMLTest.fail((String)"Should have failed to parse");
        }
        catch (AssertionFailedError e) {
            System.out.println("Got expected error: " + e.getLocalizedMessage());
        }
    }

    public void test_staticAttributes_colonColon_val_bug164887() {
        try {
            this.parseConstraint("package ocltest context Apple inv: Fruit::color = Color::black endpackage");
            UMLTest.fail((String)"Should have failed to parse");
        }
        catch (AssertionFailedError e) {
            System.out.println("Got expected error: " + e.getLocalizedMessage());
        }
        try {
            this.parseConstraint("package UML context Classifier inv: ocltest::Fruit::color = ocltest::Color::black endpackage");
            UMLTest.fail((String)"Should have failed to parse");
        }
        catch (AssertionFailedError e) {
            System.out.println("Got expected error: " + e.getLocalizedMessage());
        }
    }

    public void test_aliasedOperation_bug184753() {
        OCLExpression expr = this.parseConstraint("package UML context Namespace inv:  self.importedMember()->isEmpty() endpackage");
        try {
            UMLTest.assertNotSame((Object)this.getInvalid(), (Object)this.evaluate(expr, this.getUMLMetamodel()));
        }
        catch (RuntimeException e) {
            UMLTest.fail((String)("Failed to evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_aliasedAttribute_bug184753() {
        OCLExpression expr = this.parseConstraint("package ocltest context Aliased inv:  self.isAliased endpackage");
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ECORE_TAGGED_VALUES", "PROCESS");
        EPackage epkg = (EPackage)UMLUtil.convertToEcore((Package)((Package)this.fruitPackage), options).iterator().next();
        try {
            try {
                resourceSet.getPackageRegistry().put((Object)epkg.getNsURI(), (Object)epkg);
                EObject instance = epkg.getEFactoryInstance().create((EClass)epkg.getEClassifier("HasAliases"));
                instance.eSet(instance.eClass().getEStructuralFeature("aliased"), (Object)Boolean.TRUE);
                UMLTest.assertEquals((Object)Boolean.TRUE, (Object)this.evaluate(expr, instance));
            }
            catch (RuntimeException e) {
                UMLTest.fail((String)("Failed to evaluate: " + e.getLocalizedMessage()));
                resourceSet.getPackageRegistry().remove((Object)epkg.getNsURI());
            }
        }
        finally {
            resourceSet.getPackageRegistry().remove((Object)epkg.getNsURI());
        }
    }

    public void test_privateAttributeInheritance_214224() {
        this.expectModified = true;
        this.fruit_color.setVisibility(VisibilityKind.PRIVATE_LITERAL);
        EPackage epkg = (EPackage)UMLUtil.convertToEcore((Package)((Package)this.fruitPackage), null).iterator().next();
        try {
            resourceSet.getPackageRegistry().put((Object)epkg.getNsURI(), (Object)epkg);
            OCLExpression expr = this.parseConstraint("package ocltest context Apple inv:  self.color <> Color::brown endpackage");
            EObject instance = epkg.getEFactoryInstance().create((EClass)epkg.getEClassifier("Apple"));
            UMLTest.assertEquals((Object)Boolean.TRUE, (Object)this.evaluate(expr, instance));
        }
        catch (Exception e) {
            UMLTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_privateOperationInheritance_214224() {
        this.expectModified = true;
        this.fruit_preferredColor.setVisibility(VisibilityKind.PRIVATE_LITERAL);
        EPackage epkg = (EPackage)UMLUtil.convertToEcore((Package)((Package)this.fruitPackage), null).iterator().next();
        try {
            resourceSet.getPackageRegistry().put((Object)epkg.getNsURI(), (Object)epkg);
            OCLExpression expr = this.parseConstraint("package ocltest context Apple inv:  self.preferredColor() <> Color::brown endpackage");
            this.parseConstraint("package ocltest context Fruit::preferredColor() : Color body: Color::red endpackage");
            EObject instance = epkg.getEFactoryInstance().create((EClass)epkg.getEClassifier("Apple"));
            UMLTest.assertEquals((Object)Boolean.TRUE, (Object)this.evaluate(expr, instance));
        }
        catch (Exception e) {
            UMLTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_privateReceptionInheritance_214224() {
        this.expectModified = true;
        ((Reception)this.fruit.getOwnedReceptions().get(0)).setVisibility(VisibilityKind.PRIVATE_LITERAL);
        try {
            this.parseConstraint("package ocltest context Apple inv:  not self^Drop(?, ?) endpackage");
        }
        catch (Exception e) {
            UMLTest.fail((String)("Failed to parse: " + e.getLocalizedMessage()));
        }
    }

    public void test_appliedStereotypes_381237() {
        Classifier metaclass = (Classifier)this.getMetaclass("Class");
        this.helper.setContext((Object)metaclass);
        this.assertQueryTrue(metaclass, "self.getAppliedStereotypes()->size() = 1");
        this.assertQueryTrue(metaclass, "self.getAppliedStereotype('StandardProfile::Metaclass') <> null");
        this.assertQueryTrue(metaclass, "self.getAppliedStereotype('MetaClass') = null");
    }

    protected void setUp() {
        super.setUp();
        this.instanceResource = resourceSet.createResource(URI.createFileURI((String)"/tmp/instances.uml"));
        this.instancePackage = umlf.createPackage();
        this.instancePackage.setName("instances");
        this.instanceResource.getContents().add((Object)this.instancePackage);
    }
}

