/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.tests;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.pivot.tests.PivotTestSuite;
import org.eclipse.ocl.examples.pivot.tests.TestOCL;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.ids.CollectionTypeId;
import org.eclipse.ocl.pivot.ids.ElementId;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.manager.MetamodelManagerInternal;
import org.eclipse.ocl.pivot.internal.messages.PivotMessagesInternal;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.xtext.base.services.BaseLinkingService;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class EvaluateClassifierOperationsTest4
extends PivotTestSuite {
    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{{false}, {true}};
        return Arrays.asList(data);
    }

    public EvaluateClassifierOperationsTest4(boolean useCodeGen) {
        super(useCodeGen);
    }

    protected @NonNull MyOCL createOCL(@NonNull ProjectManager classPath) {
        return new MyOCL(this.getTestPackageName(), this.getName(), classPath);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        BaseLinkingService.DEBUG_RETRY.setState(true);
        super.setUp();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void test_allInstances() {
        MyOCL ocl = this.createOCL(OCL.NO_PROJECTS);
        MetamodelManagerInternal metamodelManager = ocl.getMetamodelManager();
        try {
            Class classType = metamodelManager.getStandardLibrary().getClassType();
            ocl.assertQueryResults(null, "Set{CollectionKind::Bag,CollectionKind::Collection,CollectionKind::_'OrderedSet',CollectionKind::_'Sequence',CollectionKind::_'Set'}", "CollectionKind.allInstances()");
            ocl.assertQueryResults(null, "Set{true,false}", "Boolean.allInstances()");
            ocl.assertQueryResults(null, "Set{null}", "OclVoid.allInstances()");
            ocl.assertQueryResults(null, "Set{}", "ocl::Package.allInstances()");
            ocl.assertQueryEquals(ocl.pkg1, 8, "Package.allInstances()->size()");
            ocl.assertSemanticErrorQuery(classType, "Integer.allInstances()", PivotMessagesInternal.UnresolvedStaticOperationCall_ERROR_, "Integer", "allInstances", "");
            ocl.assertSemanticErrorQuery(classType, "String.allInstances()", PivotMessagesInternal.UnresolvedStaticOperationCall_ERROR_, "String", "allInstances", "");
            ocl.assertSemanticErrorQuery(classType, "Set(Integer).allInstances()", PivotMessagesInternal.UnresolvedStaticOperationCall_ERROR_, "Set(Integer)", "allInstances", "");
            ocl.assertSemanticErrorQuery(classType, "Tuple(a:Integer).allInstances()", PivotMessagesInternal.UnresolvedStaticOperationCall_ERROR_, "Tuple(a:Integer[1])", "allInstances", "");
            ocl.assertSemanticErrorQuery(classType, "OclAny.allInstances()", PivotMessagesInternal.UnresolvedStaticOperationCall_ERROR_, "OclAny", "allInstances", "");
            ocl.assertSemanticErrorQuery(classType, "4.allInstances()", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, "Integer", "allInstances", "");
            ocl.assertSemanticErrorQuery(classType, "true.allInstances()", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, "Boolean", "allInstances", "");
            ocl.assertSemanticErrorQuery(classType, "Set{1}.allInstances()", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, "Set(Integer)[*|1]", "allInstances", "");
            ocl.assertSemanticErrorQuery(classType, "Tuple{a:Integer=1}.allInstances()", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, "Tuple(a:Integer[1])", "allInstances", "");
            ocl.assertQueryInvalid(null, "OclInvalid.allInstances()");
        }
        finally {
            ocl.dispose();
        }
    }

    @Test
    public void test_conformsTo() {
        MyOCL ocl = this.createOCL(OCL.NO_PROJECTS);
        try {
            ocl.assertQueryTrue(null, "Boolean.conformsTo(Boolean)");
            ocl.assertQueryFalse(null, "String.conformsTo(Boolean)");
            ocl.assertQueryFalse(null, "Boolean.conformsTo(String)");
            ocl.assertQueryTrue(null, "Integer.conformsTo(Real)");
            ocl.assertQueryFalse(null, "UnlimitedNatural.conformsTo(Integer)");
            ocl.assertQueryFalse(null, "UnlimitedNatural.conformsTo(Real)");
            ocl.assertQueryFalse(null, "Real.conformsTo(Integer)");
            ocl.assertQueryFalse(null, "Real.conformsTo(UnlimitedNatural)");
            ocl.assertQueryFalse(null, "Integer.conformsTo(UnlimitedNatural)");
        }
        finally {
            ocl.dispose();
        }
    }

    @Test
    public void test_oclContainer() {
        MyOCL ocl = this.createOCL(OCL.CLASS_PATH);
        MetamodelManagerInternal metamodelManager = ocl.getMetamodelManager();
        try {
            Class classType = metamodelManager.getStandardLibrary().getClassType();
            ocl.assertSemanticErrorQuery(classType, "invalid.oclContainer()", PivotMessagesInternal.UnresolvedOperation_ERROR_, "OclInvalid", "oclContainer");
            ocl.assertQueryInvalid(ocl.pkg2, "let s : OclElement = invalid in s.oclContainer()");
            ocl.assertSemanticErrorQuery(classType, "null.oclContainer()", PivotMessagesInternal.UnresolvedOperation_ERROR_, "OclVoid", "oclContainer");
            ocl.assertQueryInvalid(ocl.pkg2, "let s : OclElement = null in s.oclContainer()");
            ocl.assertQueryResults(ocl.root, "null", "oclContainer()");
            ocl.assertQueryEquals(ocl.pkg2, ocl.pkg1, "oclContainer()");
            ocl.assertSemanticErrorQuery(classType, "1.oclContainer()", PivotMessagesInternal.UnresolvedOperation_ERROR_, "Integer", "oclContainer");
            ocl.assertSemanticErrorQuery(classType, "invalid.oclContainer", PivotMessagesInternal.UnresolvedProperty_ERROR_, "OclInvalid", "oclContainer");
            ocl.assertQueryInvalid(ocl.pkg2, "let s : OclElement = invalid in s.oclContainer");
            ocl.assertSemanticErrorQuery(classType, "null.oclContainer", PivotMessagesInternal.UnresolvedProperty_ERROR_, "OclVoid", "oclContainer");
            ocl.assertQueryInvalid(ocl.pkg2, "let s : OclElement = null in s.oclContainer");
            ocl.assertQueryResults(ocl.root, "null", "oclContainer");
            ocl.assertQueryEquals(ocl.pkg2, ocl.pkg1, "oclContainer");
            ocl.assertSemanticErrorQuery(classType, "1.oclContainer", PivotMessagesInternal.UnresolvedProperty_ERROR_, "Integer", "oclContainer");
        }
        finally {
            ocl.dispose();
        }
    }

    @Test
    public void test_oclContents() {
        MyOCL ocl = this.createOCL(OCL.NO_PROJECTS);
        MetamodelManagerInternal metamodelManager = ocl.getMetamodelManager();
        try {
            IdResolver idResolver = metamodelManager.getEnvironmentFactory().getIdResolver();
            Class classType = metamodelManager.getStandardLibrary().getClassType();
            @NonNull Class packageType = metamodelManager.getASClass("Package");
            CollectionTypeId typeId = TypeId.SET.getSpecializedId(new ElementId[]{packageType.getTypeId()});
            ocl.assertSemanticErrorQuery(classType, "invalid.oclContents()", PivotMessagesInternal.UnresolvedOperation_ERROR_, "OclInvalid", "oclContents");
            ocl.assertQueryInvalid(ocl.pkg2, "let s : OclElement = invalid in s.oclContents()");
            ocl.assertSemanticErrorQuery(classType, "null.oclContents()", PivotMessagesInternal.UnresolvedOperation_ERROR_, "OclVoid", "oclContents");
            ocl.assertQueryInvalid(ocl.pkg2, "let s : OclElement = null in s.oclContents()");
            ocl.assertQueryEquals(ocl.pkg1, idResolver.createSetOfEach(typeId, new Object[]{ocl.bob, ocl.pkg2, ocl.pkg3}), "oclContents()");
            ocl.assertQueryEquals(ocl.pkg2, idResolver.createSetOfEach(typeId, new Object[]{ocl.jim}), "oclContents()");
            ocl.assertQueryEquals(ocl.george, idResolver.createSetOfEach(typeId, new Object[0]), "oclContents()");
            ocl.assertSemanticErrorQuery(classType, "1.oclContents()", PivotMessagesInternal.UnresolvedOperation_ERROR_, "Integer", "oclContents");
            ocl.assertSemanticErrorQuery(classType, "invalid.oclContents", PivotMessagesInternal.UnresolvedProperty_ERROR_, "OclInvalid", "oclContents");
            ocl.assertQueryInvalid(ocl.pkg2, "let s : OclElement = invalid in s.oclContents");
            ocl.assertSemanticErrorQuery(classType, "null.oclContents", PivotMessagesInternal.UnresolvedProperty_ERROR_, "OclVoid", "oclContents");
            ocl.assertQueryInvalid(ocl.pkg2, "let s : OclElement = null in s.oclContents");
            ocl.assertQueryEquals(ocl.pkg1, idResolver.createSetOfEach(typeId, new Object[]{ocl.bob, ocl.pkg2, ocl.pkg3}), "oclContents");
            ocl.assertQueryEquals(ocl.pkg2, idResolver.createSetOfEach(typeId, new Object[]{ocl.jim}), "oclContents");
            ocl.assertQueryEquals(ocl.george, idResolver.createSetOfEach(typeId, new Object[0]), "oclContents");
            ocl.assertSemanticErrorQuery(classType, "1.oclContents", PivotMessagesInternal.UnresolvedProperty_ERROR_, "Integer", "oclContents");
        }
        finally {
            ocl.dispose();
        }
    }

    public static class MyOCL
    extends TestOCL {
        @NonNull Model root = PivotUtil.createModel(null);
        @NonNull Package pkg1 = PivotUtil.createOwnedPackage((Model)this.root, (String)"pkg1");
        @NonNull Package pkg2 = PivotUtil.createOwnedPackage((Package)this.pkg1, (String)"pkg2");
        @NonNull Package jim = PivotUtil.createOwnedPackage((Package)this.pkg2, (String)"jim");
        @NonNull Package bob = PivotUtil.createOwnedPackage((Package)this.pkg1, (String)"bob");
        @NonNull Package pkg3 = PivotUtil.createOwnedPackage((Package)this.pkg1, (String)"pkg3");
        @NonNull Package pkg4 = PivotUtil.createOwnedPackage((Package)this.pkg3, (String)"pkg4");
        @NonNull Package pkg5 = PivotUtil.createOwnedPackage((Package)this.pkg3, (String)"pkg5");
        @NonNull Package george = PivotUtil.createOwnedPackage((Package)this.pkg5, (String)"george");

        public MyOCL(@NonNull String testPackageName, @NonNull String name, @NonNull ProjectManager projectManager) {
            super(testPackageName, name, projectManager);
            MetamodelManagerInternal metamodelManager = this.getMetamodelManager();
            metamodelManager.installRoot((Model)ClassUtil.nonNullState((Object)this.root));
        }
    }
}

