/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.test.xtext;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ocl.examples.test.xtext.models.ParserModels;
import org.eclipse.ocl.examples.xtext.tests.TestUIUtil;
import org.eclipse.ocl.xtext.base.ui.messages.BaseUIMessages;
import org.eclipse.ocl.xtext.base.ui.wizards.AbstractFileNewWizardPage;
import org.eclipse.ocl.xtext.completeocl.ui.messages.CompleteOCLUIMessages;
import org.eclipse.ocl.xtext.completeocl.ui.wizards.CompleteOCLFileDialog;
import org.eclipse.ocl.xtext.completeocl.ui.wizards.CompleteOCLFileNewWizard;
import org.eclipse.ocl.xtext.oclinecore.ui.wizards.EcoreWithOCLFileNewWizard;
import org.eclipse.ocl.xtext.oclinecore.ui.wizards.OCLinEcoreFileNewWizard;
import org.eclipse.ocl.xtext.oclstdlib.ui.wizards.OCLstdlibFileNewWizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.junit.Test;

public class FileNewWizardTest
extends TestCase {
    private static final String PAGE_NAME = BaseUIMessages.NewWizardPage_pageName;
    private static final String TEST_ECORE_NAME = "Test.ecore";
    private static final String TEST_PROJECT_NAME = "test-project";
    private static final String TEST_ECORE_PATH = "/test-project/Test.ecore";
    private static final String EXPECTED_OCL_NAME = "Test.ocl";
    private static final String EXPECTED_OCLINECORE_NAME = "Test.oclinecore";
    private static final String EXPECTED_OCLSTDLIB_NAME = "Test.oclstdlib";
    private static final String EXPECTED_PACKAGE_NAME = "test_package";
    private static final String EXPECTED_CLASS_NAME = "TestClass";
    private static final String EXPECTED_FEATURE_NAME = "testFeature";
    private IProject project = null;
    private IFile modelFile = null;

    public static String getExpectedContents() {
        StringBuilder s = new StringBuilder();
        s.append("import 'Test.ecore'\n\n");
        s.append("package test_package\n\n");
        s.append("context TestClass\n");
        s.append("--\n");
        s.append("-- example invariant with a custom error message to verify that\n");
        s.append("-- the 'testFeature' property of all 'test_package::TestClass' instances is non-null\n");
        s.append("--\n");
        s.append("inv NonNull_testFeature('The \\'testFeature\\' property of \"' + self.toString() + '\" is null'):\n");
        s.append("\ttestFeature <> null\n\n");
        s.append("endpackage\n");
        return s.toString();
    }

    public FileNewWizardTest(String name) {
        super(name);
    }

    protected int createAndFinishWizardDialog(@NonNull IWorkbenchWizard wizard) {
        WizardDialog dialog = new WizardDialog(new Shell(), (IWizard)wizard){

            public int open() {
                Thread thread = new Thread("Press Finish"){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        this.getShell().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                this.finishPressed();
                            }
                        });
                    }
                };
                thread.start();
                return super.open();
            }
        };
        return dialog.open();
    }

    protected XtextEditor getActiveEditor() {
        IWorkbenchPage currentPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        return (XtextEditor)currentPage.getActiveEditor();
    }

    protected @NonNull String readNewFile(String fileName) throws CoreException, IOException {
        IFile oclFile = this.project.getFile(fileName);
        FileNewWizardTest.assertTrue((boolean)oclFile.exists());
        InputStream inputStream = oclFile.getContents();
        InputStreamReader reader = new InputStreamReader(inputStream);
        StringBuilder s = new StringBuilder();
        char[] cbuf = new char[4096];
        int len = 0;
        while ((len = reader.read(cbuf)) > 0) {
            s.append(cbuf, 0, len);
        }
        ((Reader)reader).close();
        return s.toString();
    }

    protected void setUp() throws Exception {
        super.setUp();
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.core.resources");
        prefs.putBoolean("refresh.lightweight.enabled", true);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IProjectDescription description = workspace.newProjectDescription(TEST_PROJECT_NAME);
        this.project = root.getProject(description.getName());
        NullProgressMonitor nullMonitor = new NullProgressMonitor();
        if (this.project.exists()) {
            this.project.delete(true, true, (IProgressMonitor)nullMonitor);
        }
        this.project.create(description, (IProgressMonitor)nullMonitor);
        FileNewWizardTest.assertTrue((boolean)this.project.exists());
        this.project.open((IProgressMonitor)nullMonitor);
        URL url = ParserModels.class.getResource(TEST_ECORE_NAME);
        FileNewWizardTest.assertNotNull((Object)url);
        this.project.getFile(TEST_ECORE_NAME).create(url.openStream(), true, (IProgressMonitor)nullMonitor);
        this.modelFile = this.project.getFile(TEST_ECORE_NAME);
        FileNewWizardTest.assertTrue((boolean)this.modelFile.exists());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.project.exists()) {
            this.project.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    @Test
    public void test_CompleteOCLFile_Dialog() {
        CompleteOCLFileNewWizard wizard = new CompleteOCLFileNewWizard();
        AbstractFileNewWizardPage wizardPage = wizard.createNewWizardPage((IResource)this.modelFile);
        CompleteOCLFileDialog dialog = new CompleteOCLFileDialog(wizard, wizardPage, (IResource)this.modelFile);
        dialog.createDialogArea((Composite)new Shell());
        FileNewWizardTest.assertEquals((String)"ocl", (String)wizard.getNewFileExtension());
        FileNewWizardTest.assertEquals((String)CompleteOCLUIMessages.NewWizardPage_fileNameLabel, (String)wizard.getNewFileLabel());
        FileNewWizardTest.assertEquals((String)"/test-project/Test.ocl", (String)dialog.getNewFilePath().toString());
        ArrayList<URI> uris = new ArrayList<URI>();
        uris.add(URI.createPlatformResourceURI((String)TEST_ECORE_PATH, (boolean)true));
        FileNewWizardTest.assertEquals(uris, (Object)dialog.getURIs());
        wizard.dispose();
    }

    @Test
    public void test_CompleteOCLFile_NewWizardPage() {
        CompleteOCLFileNewWizard wizard = new CompleteOCLFileNewWizard();
        AbstractFileNewWizardPage wizardPage = wizard.createNewWizardPage((IResource)this.modelFile);
        FileNewWizardTest.assertEquals((String)PAGE_NAME, (String)wizardPage.getName());
        FileNewWizardTest.assertEquals((String)CompleteOCLUIMessages.NewWizardPage_pageSummary, (String)wizardPage.getTitle());
        FileNewWizardTest.assertEquals((String)CompleteOCLUIMessages.NewWizardPage_pageDescription, (String)wizardPage.getDescription());
        FileNewWizardTest.assertNull((Object)wizardPage.getErrorMessage());
        wizard.dispose();
    }

    @Test
    public void test_CompleteOCL_NewFileCreation() throws Exception {
        CompleteOCLFileNewWizard wizard = new CompleteOCLFileNewWizard();
        wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection((Object)this.modelFile));
        this.createAndFinishWizardDialog((IWorkbenchWizard)wizard);
        String actualContents = this.readNewFile(EXPECTED_OCL_NAME);
        StringBuilder s = new StringBuilder();
        s.append("import 'Test.ecore'\n\n");
        s.append("package test_package\n\n");
        s.append("context TestClass\n");
        s.append("--\n");
        s.append("-- example invariant with a custom error message to verify that\n");
        s.append("-- the 'testFeature' property of all 'test_package::TestClass' instances is non-null\n");
        s.append("--\n");
        s.append("inv NonNull_testFeature('The \\'testFeature\\' property of \"' + self.toString() + '\" is null'):\n");
        s.append("\ttestFeature <> null\n\n");
        s.append("endpackage\n");
        String expectedContents = s.toString();
        FileNewWizardTest.assertEquals((String)expectedContents, (String)actualContents);
        XtextEditor activeEditor = this.getActiveEditor();
        FileNewWizardTest.assertEquals((String)"org.eclipse.ocl.xtext.completeocl.CompleteOCL", (String)activeEditor.getLanguageName());
        activeEditor.close(false);
    }

    @Test
    public void test_OCLinEcore_NewFileCreation() throws Exception {
        OCLinEcoreFileNewWizard wizard = new OCLinEcoreFileNewWizard();
        wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection((Object)this.modelFile));
        this.createAndFinishWizardDialog((IWorkbenchWizard)wizard);
        String actualContents = this.readNewFile(EXPECTED_OCLINECORE_NAME);
        StringBuilder s = new StringBuilder();
        s.append("import 'Test.ecore';\n");
        s.append("\n");
        s.append("package example : ex = 'http://www.example.org/examples/example.ecore'\n");
        s.append("{\n");
        s.append("\t-- Example Class with hierarchical properties and an invariant\n");
        s.append("\tclass Example\n");
        s.append("\t{\n");
        s.append("\t\tproperty name : String[?];\n");
        s.append("\t\tproperty children#parent : Example[*] { composes, ordered } ;\n");
        s.append("\t\tproperty parent#children : Example[?];\n");
        s.append("\t\toperation ucName() : String[?] {\n");
        s.append("\t\t\tbody: name?.toUpperCase();\n");
        s.append("\t\t}\n");
        s.append("\t\tinvariant NameIsLowerCase('Expected a lowercase name rather than '' + name + '''):\n");
        s.append("\t\t\tname = name?.toLowerCase();\n");
        s.append("\t}\n");
        s.append("}\n");
        String expectedContents = s.toString();
        FileNewWizardTest.assertEquals((String)expectedContents, (String)actualContents);
        XtextEditor activeEditor = this.getActiveEditor();
        FileNewWizardTest.assertEquals((String)"org.eclipse.ocl.xtext.oclinecore.OCLinEcore", (String)activeEditor.getLanguageName());
        activeEditor.close(false);
    }

    @Test
    public void test_EcoreWithOCL_NewFileCreation() throws Exception {
        IFile modelFile = this.project.getFile("Testing.xxx");
        EcoreWithOCLFileNewWizard wizard = new EcoreWithOCLFileNewWizard();
        wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection((Object)modelFile));
        this.createAndFinishWizardDialog((IWorkbenchWizard)wizard);
        TestUIUtil.wait(1000);
        XtextEditor activeEditor = this.getActiveEditor();
        FileNewWizardTest.assertEquals((String)"org.eclipse.ocl.xtext.oclinecore.OCLinEcore", (String)activeEditor.getLanguageName());
        IXtextDocument document = activeEditor.getDocument();
        String actualContents = document.get();
        StringBuilder s = new StringBuilder();
        s.append("package example : ex = 'http://www.example.org/examples/example.ecore'\n");
        s.append("{\n");
        s.append("\tclass Example\n");
        s.append("\t{\n");
        s.append("\t\toperation ucName() : String[?]\n");
        s.append("\t\t{\n");
        s.append("\t\t\tbody: name?.toUpperCase();\n");
        s.append("\t\t}\n");
        s.append("\t\tattribute name : String[?];\n");
        s.append("\t\tproperty children#parent : Example[*] { ordered composes };\n");
        s.append("\t\tproperty parent#children : Example[?];\n");
        s.append("\t\tinvariant NameIsLowerCase('Expected a lowercase name rather than '' + name + '''):\n");
        s.append("\t\t\tname = name?.toLowerCase();\n");
        s.append("\t}\n");
        s.append("}\n");
        String expectedContents = s.toString();
        FileNewWizardTest.assertEquals((String)expectedContents.trim().replaceAll("\\s+", " "), (String)actualContents.trim().replaceAll("\\s+", " "));
        activeEditor.close(false);
    }

    @Test
    public void test_OCLstdlib_NewFileCreation() throws Exception {
        OCLstdlibFileNewWizard wizard = new OCLstdlibFileNewWizard();
        wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection((Object)this.modelFile));
        this.createAndFinishWizardDialog((IWorkbenchWizard)wizard);
        String actualContents = this.readNewFile(EXPECTED_OCLSTDLIB_NAME);
        StringBuilder s = new StringBuilder();
        s.append("-- import an existing library to be extended\n");
        s.append("import 'http://www.eclipse.org/ocl/2015/Library';\n");
        s.append("\n");
        s.append("-- import an extension library re-using the imported library nsURI\n");
        s.append("library lib : lib = 'http://www.eclipse.org/ocl/2015/Library' {\n");
        s.append("    type String : PrimitiveType {\n");
        s.append("    \t-- define an additional operation accessed by my.strings.ExtraOperation.INSTANCE.evaluate\n");
        s.append("    \toperation extraOperation(elem : Boolean) : Boolean => 'my.strings.ExtraOperation';\n");
        s.append("    }\n");
        s.append("}\n");
        String expectedContents = s.toString();
        FileNewWizardTest.assertEquals((String)expectedContents, (String)actualContents);
        XtextEditor activeEditor = this.getActiveEditor();
        FileNewWizardTest.assertEquals((String)"org.eclipse.ocl.xtext.oclstdlib.OCLstdlib", (String)activeEditor.getLanguageName());
        activeEditor.close(false);
    }
}

