/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.test.xtext;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.xtext.tests.TestUtil;
import org.eclipse.ocl.examples.xtext.tests.XtextTestCase;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.LanguageExpression;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.internal.ecore.as2es.AS2Ecore;
import org.eclipse.ocl.pivot.internal.ecore.es2as.Ecore2AS;
import org.eclipse.ocl.pivot.internal.resource.ASSaver;
import org.eclipse.ocl.pivot.internal.resource.ProjectMap;
import org.eclipse.ocl.pivot.internal.resource.StandaloneProjectMap;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.OCLInternal;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.resource.CSResource;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.uml.UMLStandaloneSetup;
import org.eclipse.ocl.pivot.uml.internal.as2es.AS2UML;
import org.eclipse.ocl.pivot.uml.internal.es2as.UML2AS;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.xtext.base.cs2as.CS2AS;
import org.eclipse.ocl.xtext.base.utilities.BaseCSResource;
import org.eclipse.ocl.xtext.completeocl.as2cs.CompleteOCLSplitter;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.resource.UML402UMLExtendedMetaData;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.EmfFormatter;

public class RoundTripTests
extends XtextTestCase {
    public Resource createEcoreFromPivot(@NonNull EnvironmentFactoryInternal environmentFactory, ASResource asResource, URI ecoreURI) throws IOException {
        XMLResource ecoreResource = AS2Ecore.createResource((EnvironmentFactoryInternal)environmentFactory, (Resource)asResource, (URI)ecoreURI, null);
        RoundTripTests.assertNoResourceErrors("To Ecore errors", (Resource)ecoreResource);
        if (ecoreURI != null) {
            ecoreResource.save(null);
        }
        return ecoreResource;
    }

    public ASResource createPivotFromEcore(@NonNull EnvironmentFactoryInternal environmentFactory, Resource ecoreResource) throws IOException {
        Ecore2AS ecore2as = Ecore2AS.getAdapter((Resource)ecoreResource, (EnvironmentFactoryInternal)environmentFactory);
        Model pivotModel = ecore2as.getASModel();
        ASResource asResource = (ASResource)pivotModel.eResource();
        RoundTripTests.assertNoResourceErrors("Ecore2AS failed", (Resource)asResource);
        RoundTripTests.assertNoValidationErrors("Ecore2AS invalid", (Resource)asResource);
        return asResource;
    }

    public ASResource createPivotFromXtext(@NonNull EnvironmentFactoryInternal environmentFactory, BaseCSResource xtextResource, int expectedContentCount) throws IOException {
        try {
            ASResource asResource = xtextResource.getASResource();
            RoundTripTests.assertNoResourceErrors("To Pivot errors", (Resource)xtextResource);
            RoundTripTests.assertNoUnresolvedProxies("Unresolved proxies", (Resource)xtextResource);
            EList pivotContents = asResource.getContents();
            RoundTripTests.assertEquals((int)expectedContentCount, (int)pivotContents.size());
            RoundTripTests.assertNoValidationErrors("Pivot validation errors", (EObject)pivotContents.get(0));
            ASResource aSResource = asResource;
            return aSResource;
        }
        finally {
            xtextResource.dispose();
        }
    }

    public BaseCSResource createXtextFromPivot(@NonNull EnvironmentFactoryInternal environmentFactory, ASResource asResource, URI xtextURI) throws IOException {
        ResourceSet resourceSet = environmentFactory.getResourceSet();
        XtextResource xtextResource = (XtextResource)resourceSet.createResource(xtextURI, "org.eclipse.ocl.xtext.oclinecore");
        ((BaseCSResource)xtextResource).updateFrom(asResource, (EnvironmentFactory)environmentFactory);
        xtextResource.save(null);
        RoundTripTests.assertNoResourceErrors("Conversion failed", (Resource)xtextResource);
        RoundTripTests.assertNoDiagnosticErrors("Concrete Syntax validation failed", xtextResource);
        return (BaseCSResource)xtextResource;
    }

    public BaseCSResource createXtextFromURI(@NonNull EnvironmentFactoryInternal environmentFactory, URI xtextURI) throws IOException {
        ResourceSet resourceSet = environmentFactory.getResourceSet();
        ProjectMap.initializeURIResourceMap(null);
        BaseCSResource xtextResource = (BaseCSResource)resourceSet.getResource(xtextURI, true);
        RoundTripTests.assertNoResourceErrors("Load failed", (Resource)xtextResource);
        return xtextResource;
    }

    public CSResource createCompleteOCLXtextFromPivot(@NonNull EnvironmentFactoryInternal environmentFactory, ASResource asResource, URI xtextURI) throws IOException {
        ResourceSet resourceSet = environmentFactory.getResourceSet();
        CSResource xtextResource = (CSResource)resourceSet.createResource(xtextURI, "org.eclipse.ocl.xtext.oclinecore");
        xtextResource.updateFrom(asResource, (EnvironmentFactory)environmentFactory);
        xtextResource.save(null);
        RoundTripTests.assertNoResourceErrors("Conversion failed", (Resource)xtextResource);
        RoundTripTests.assertNoDiagnosticErrors("Concrete Syntax validation failed", (XtextResource)xtextResource);
        return xtextResource;
    }

    public void doRoundTripFromCompleteOCL(@NonNull OCL ocl, URI inputURI) throws IOException, InterruptedException {
        ResourceSet resourceSet = ocl.getResourceSet();
        CS2AS.MessageBinder savedMessageBinder = CS2AS.setMessageBinder((CS2AS.MessageBinder)CS2AS.MessageBinderWithLineContext.INSTANCE);
        StandaloneProjectMap projectMap = (StandaloneProjectMap)ocl.getEnvironmentFactory().getProjectManager();
        try {
            projectMap.initializeResourceSet(resourceSet);
            if (!resourceSet.getURIConverter().exists(inputURI, null)) {
                return;
            }
            if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
                ProjectManager.IProjectDescriptor projectDescriptor = projectMap.getProjectDescriptor("org.eclipse.uml2.uml");
                projectDescriptor.initializeURIMap(URIConverter.URI_MAP);
            }
            URI outputURI = inputURI.trimFileExtension().appendFileExtension("regenerated.ocl");
            OCLInternal ocl1 = OCLInternal.newInstance((ProjectManager)RoundTripTests.getProjectMap(), null);
            EnvironmentFactoryInternal environmentFactory1 = ocl1.getEnvironmentFactory();
            environmentFactory1.adapt((Notifier)resourceSet);
            BaseCSResource xtextResource1 = this.createXtextFromURI(environmentFactory1, inputURI);
            ASResource pivotResource1 = this.createPivotFromXtext(environmentFactory1, xtextResource1, 1);
            ASResource pivotResource2 = CompleteOCLSplitter.separate((EnvironmentFactoryInternal)environmentFactory1, (Resource)pivotResource1);
            CSResource xtextResource2 = this.createCompleteOCLXtextFromPivot(environmentFactory1, pivotResource2, outputURI);
            ocl1.dispose();
            ocl1 = null;
            OCLInternal ocl3 = OCLInternal.newInstance((ProjectManager)RoundTripTests.getProjectMap(), null);
            EnvironmentFactoryInternal environmentFactory3 = ocl3.getEnvironmentFactory();
            BaseCSResource xtextResource3 = this.createXtextFromURI(environmentFactory3, outputURI);
            ASResource pivotResource3 = this.createPivotFromXtext(environmentFactory3, xtextResource3, 1);
            ocl3.dispose();
        }
        finally {
            CS2AS.setMessageBinder((CS2AS.MessageBinder)savedMessageBinder);
        }
    }

    public void doRoundTripFromEcore(String stem) throws IOException, InterruptedException, ParserException {
        this.doRoundTripFromEcore(stem, stem, null);
    }

    public void doRoundTripFromEcore(String stem, String reference, Map<String, Object> saveOptions) throws IOException, InterruptedException, ParserException {
        String inputName = String.valueOf(stem) + ".ecore";
        URI inputURI = this.getProjectFileURI(inputName);
        String referenceName = String.valueOf(reference) + ".ecore";
        URI referenceURI = this.getProjectFileURI(referenceName);
        OCLInternal ocl = OCLInternal.newInstance((ProjectManager)RoundTripTests.getProjectMap(), null);
        this.doRoundTripFromEcore(ocl.getEnvironmentFactory(), inputURI, referenceURI, saveOptions);
        ocl.dispose();
    }

    public void doRoundTripFromEcore(URI inputURI, URI referenceURI, Map<String, Object> saveOptions) throws IOException, InterruptedException, ParserException {
        OCLInternal ocl = OCLInternal.newInstance((ProjectManager)RoundTripTests.getProjectMap(), null);
        this.doRoundTripFromEcore(ocl.getEnvironmentFactory(), inputURI, referenceURI, saveOptions);
        ocl.dispose();
    }

    protected void doRoundTripFromEcore(@NonNull EnvironmentFactoryInternal environmentFactory, URI inputURI, URI referenceURI, Map<String, Object> saveOptions) throws IOException, InterruptedException, ParserException {
        String stem = inputURI.trimFileExtension().lastSegment();
        String pivotName = String.valueOf(stem) + ".ecore.oclas";
        String outputName = String.valueOf(stem) + ".regenerated.ecore";
        URI pivotURI = this.getProjectFileURI(pivotName);
        URI outputURI = this.getProjectFileURI(outputName);
        ResourceSet resourceSet = environmentFactory.getResourceSet();
        Resource inputResource = resourceSet.getResource(inputURI, true);
        RoundTripTests.assertNoResourceErrors("Ecore load", inputResource);
        RoundTripTests.assertNoValidationErrors("Ecore load", inputResource);
        Ecore2AS ecore2as = Ecore2AS.getAdapter((Resource)inputResource, (EnvironmentFactoryInternal)environmentFactory);
        Model pivotModel = ecore2as.getASModel();
        Resource asResource = pivotModel.eResource();
        asResource.setURI(pivotURI);
        RoundTripTests.assertNoResourceErrors("Ecore2AS failed", asResource);
        asResource.save(null);
        RoundTripTests.assertNoValidationErrors("Ecore2AS invalid", asResource);
        TreeIterator tit = asResource.getAllContents();
        while (tit.hasNext()) {
            EObject eObject = (EObject)tit.next();
            if (!(eObject instanceof ExpressionInOCL)) continue;
            ExpressionInOCL specification = (ExpressionInOCL)eObject;
            if (specification.getOwnedBody() != null || specification.getBody() != null) {
                environmentFactory.getMetamodelManager().parseSpecification((LanguageExpression)specification);
            }
            tit.prune();
        }
        XMLResource outputResource = AS2Ecore.createResource((EnvironmentFactoryInternal)environmentFactory, (Resource)asResource, (URI)inputURI, saveOptions);
        RoundTripTests.assertNoResourceErrors("Ecore2AS failed", (Resource)outputResource);
        OutputStream outputStream = resourceSet.getURIConverter().createOutputStream(outputURI);
        outputResource.save(outputStream, null);
        outputStream.close();
        RoundTripTests.assertNoValidationErrors("Ecore2AS invalid", (Resource)outputResource);
        if (referenceURI != null) {
            ResourceSetImpl resourceSet2 = new ResourceSetImpl();
            StandaloneProjectMap.getAdapter((ResourceSet)resourceSet).initializeResourceSet((ResourceSet)resourceSet2);
            Resource referenceResource = resourceSet2.getResource(referenceURI, true);
            TestUtil.assertSameModel(referenceResource, (Resource)outputResource);
        }
    }

    public void doRoundTripFromOCLinEcore(@NonNull OCL ocl1, String stem) throws IOException, InterruptedException {
        String inputName = String.valueOf(stem) + ".oclinecore";
        String ecoreName = String.valueOf(stem) + ".ecore";
        String outputName = String.valueOf(stem) + ".regenerated.oclinecore";
        URI inputURI = this.getProjectFileURI(inputName);
        URI ecoreURI = this.getProjectFileURI(ecoreName);
        URI outputURI = this.getProjectFileURI(outputName);
        EnvironmentFactoryInternal environmentFactory1 = (EnvironmentFactoryInternal)ocl1.getEnvironmentFactory();
        BaseCSResource xtextResource1 = this.createXtextFromURI(environmentFactory1, inputURI);
        ASResource pivotResource1 = this.createPivotFromXtext(environmentFactory1, xtextResource1, 1);
        Resource ecoreResource = this.createEcoreFromPivot(environmentFactory1, pivotResource1, ecoreURI);
        OCLInternal ocl2 = OCLInternal.newInstance((ProjectManager)RoundTripTests.getProjectMap(), null);
        EnvironmentFactoryInternal environmentFactory2 = ocl2.getEnvironmentFactory();
        ASResource pivotResource2 = this.createPivotFromEcore(environmentFactory2, ecoreResource);
        BaseCSResource xtextResource2 = this.createXtextFromPivot(environmentFactory2, pivotResource2, outputURI);
        ocl2.dispose();
        OCLInternal ocl3 = OCLInternal.newInstance((ProjectManager)RoundTripTests.getProjectMap(), null);
        EnvironmentFactoryInternal environmentFactory3 = ocl3.getEnvironmentFactory();
        BaseCSResource xtextResource3 = this.createXtextFromURI(environmentFactory3, outputURI);
        ASResource pivotResource3 = this.createPivotFromXtext(environmentFactory3, xtextResource3, 1);
        ASSaver asSaver1 = new ASSaver((Resource)pivotResource1);
        asSaver1.localizeSpecializations();
        ASSaver asSaver3 = new ASSaver((Resource)pivotResource3);
        asSaver3.localizeSpecializations();
        String expected = EmfFormatter.listToStr((List)pivotResource1.getContents());
        String actual = EmfFormatter.listToStr((List)pivotResource3.getContents()).replace(".regenerated.oclinecore", ".oclinecore");
        RoundTripTests.assertEquals((String)expected, (String)actual);
        ocl3.dispose();
    }

    public void doRoundTripFromUml(String stem) throws IOException, InterruptedException, ParserException {
        EList outputObjects;
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getPackageRegistry().put((Object)"http://www.eclipse.org/uml2/5.0.0/UML", (Object)UMLPackage.eINSTANCE);
        String inputName = String.valueOf(stem) + ".uml";
        String pivotName = String.valueOf(stem) + ".oclas";
        String outputName = String.valueOf(stem) + ".regenerated.uml";
        URI inputURI = this.getProjectFileURI(inputName);
        URI pivotURI = this.getProjectFileURI(pivotName);
        URI outputURI = this.getProjectFileURI(outputName);
        Resource inputResource = resourceSet.getResource(inputURI, true);
        RoundTripTests.assertNoResourceErrors("UML load", inputResource);
        RoundTripTests.assertNoValidationErrors("UML load", inputResource);
        OCLInternal ocl = OCLInternal.newInstance((ProjectManager)RoundTripTests.getProjectMap(), null);
        EnvironmentFactoryInternal environmentFactory = ocl.getEnvironmentFactory();
        UML2AS uml2as = UML2AS.getAdapter((Resource)inputResource, (EnvironmentFactoryInternal)environmentFactory);
        Model pivotModel = uml2as.getASModel();
        Resource asResource = pivotModel.eResource();
        asResource.setURI(pivotURI);
        RoundTripTests.assertNoResourceErrors("UML2AS failed", asResource);
        asResource.save(null);
        RoundTripTests.assertNoValidationErrors("UML2AS invalid", asResource);
        EList castOutputObjects = outputObjects = new ArrayList(AS2UML.createResource((EnvironmentFactoryInternal)environmentFactory, (Resource)asResource));
        outputObjects.remove(RoundTripTests.getNamedElement(castOutputObjects, "orphanage"));
        if (outputObjects.size() == 1) {
            outputObjects = ((Package)outputObjects.get(0)).getNestedPackages();
        }
        Resource outputResource = resourceSet.createResource(outputURI);
        outputResource.getContents().addAll((Collection)outputObjects);
        RoundTripTests.assertNoResourceErrors("UML2AS failed", outputResource);
        outputResource.save(null);
        RoundTripTests.assertNoValidationErrors("UML2AS invalid", outputResource);
        TestUtil.assertSameModel(inputResource, outputResource);
        ocl.dispose();
    }

    public static <T extends NamedElement> T getNamedElement(Collection<T> elements, String name) {
        if (elements == null) {
            return null;
        }
        for (NamedElement element : elements) {
            if (!ClassUtil.safeEquals((Object)name, (Object)element.getName())) continue;
            return (T)element;
        }
        return null;
    }

    public void testBug350894RoundTrip() throws IOException, InterruptedException {
        String testFileA = "package a : aa = 'aaa'\n{\nclass A;\n}\n";
        OCLInternal ocl1 = OCLInternal.newInstance((ProjectManager)RoundTripTests.getProjectMap(), null);
        this.createEcoreFile((OCL)ocl1, "Bug350894A", testFileA);
        ocl1.dispose();
        String testFileB = "import aa : 'Bug350894A.ecore#/';\npackage b : bb = 'bbb'\n{\nclass B\n{\ninvariant alias: not oclIsKindOf(aa::A);\ninvariant nsURI: not oclIsKindOf(aaa::A);\ninvariant file: not oclIsKindOf(_'Bug350894A.ecore#/'::A);\n}\n}\n";
        this.createOCLinEcoreFile("Bug350894B.oclinecore", testFileB);
        OCLInternal ocl2 = OCLInternal.newInstance((ProjectManager)RoundTripTests.getProjectMap(), null);
        this.doRoundTripFromOCLinEcore((OCL)ocl2, "Bug350894B");
        ocl2.dispose();
    }

    public void testBug356243_oclinecore() throws IOException, InterruptedException {
        String testFile = "package any : any = 'http:/any'\n{\n\tclass Bug356243\n\t{\n\t\tproperty is_always_typed : OclAny { ordered };\n\t}\n}\n";
        this.createOCLinEcoreFile("Bug356243.oclinecore", testFile);
        OCLInternal ocl = OCLInternal.newInstance((ProjectManager)RoundTripTests.getProjectMap(), null);
        this.doRoundTripFromOCLinEcore((OCL)ocl, "Bug356243");
        ocl.dispose();
    }

    public void testBug426927_oclinecore() throws IOException, InterruptedException {
        String testFile = "package any : any = 'http:/any'\n{\n\tenum Enums\n\t{\n\t\tliteral ONE = 1;\n\t\tliteral MINUS_ONE = -1;\n\t}\n\tclass Bug426927\n\t{\n\t\tannotation {\n\t\t\treference Enums::MINUS_ONE;\n\t\t}\n\t}\n}\n";
        this.createOCLinEcoreFile("Bug426927.oclinecore", testFile);
        OCLInternal ocl = OCLInternal.newInstance((ProjectManager)RoundTripTests.getProjectMap(), null);
        this.doRoundTripFromOCLinEcore((OCL)ocl, "Bug426927");
        ocl.dispose();
    }

    public void testAggregatesRoundTrip() throws IOException, InterruptedException {
        String testFile = "package b : bb = 'bbb'\n{\nclass B\n{\nproperty bag0 : B[3..5|1] {!unique};\nproperty bag1 : B[*] {!unique};\nproperty bag2 : Bag(B);\nproperty bag3 : B[3..5] {!unique};\nproperty bag4 : Bag(B/*[1..3]*/)[4..6];\nproperty bag5 : Bag(B)[4..6|1];\nproperty setCollection : Set(Collection(B));\nproperty collection2 : Collection(B);\nproperty orderedset1 : B[*] {ordered};\nproperty orderedset2 : OrderedSet(B);\nproperty sequence1 : B[*] {ordered, !unique};\nproperty sequence2 : Sequence(B);\nproperty set1 : B[*];\nproperty set2 : Set(B);\n}\n}\n";
        this.createOCLinEcoreFile("Aggregates.oclinecore", testFile);
        OCLInternal ocl = OCLInternal.newInstance((ProjectManager)RoundTripTests.getProjectMap(), null);
        this.doRoundTripFromOCLinEcore((OCL)ocl, "Aggregates");
        ocl.dispose();
    }

    public void testAnnotationsRoundTrip_480635() throws IOException, InterruptedException {
        String testFile = "package b : bb = 'bbb'\n{\nenum Parameter_kind { serializable }\n{\n   literal DB_BOOLEAN { annotation documentation\n   (doc = 'test');\n   } \n   literal ENUMERATED = 1;\n   literal INT8 = 2;\n   literal INT16 = 3;\n}\n}\n";
        this.createOCLinEcoreFile("Annotations.oclinecore", testFile);
        OCLInternal ocl = OCLInternal.newInstance((ProjectManager)RoundTripTests.getProjectMap(), null);
        this.doRoundTripFromOCLinEcore((OCL)ocl, "Annotations");
        ocl.dispose();
    }

    public void testCardinalityRoundTrip_402767() throws IOException, InterruptedException {
        String testFile = "package b : bb = 'bbb'\n{\nclass B\n{\nproperty vBlank : Real;\nproperty vQuery : Real[?];\nproperty vPlus : Real[+];\nproperty vStar : Real[*];\nproperty vOne : Real[1];\nproperty vThree : Real[3];\nproperty vOne2Three : Real[1..3];\nproperty vThree2Three : Real[3..3];\nproperty vThree2Star : Real[3..*];\n}\n}\n";
        this.createOCLinEcoreFile("Cardinality.oclinecore", testFile);
        OCLInternal ocl = OCLInternal.newInstance((ProjectManager)RoundTripTests.getProjectMap(), null);
        this.doRoundTripFromOCLinEcore((OCL)ocl, "Cardinality");
        ocl.dispose();
    }

    public void testCommentsRoundTrip_405145() throws IOException, InterruptedException {
        String testFile = "package b : bb = 'bbb'\n{\n/* a simple comment */\nclass B\n{\n/*\n * a multi line comment\n */\nproperty c1 : Real;\n/* another \n * multi line comment\n */\nproperty c2 : Real;\n/* an unformatted \n multi line comment\n */\nproperty c3 : Real;\n}\n}\n";
        this.createOCLinEcoreFile("Comments.oclinecore", testFile);
        OCLInternal ocl = OCLInternal.newInstance((ProjectManager)RoundTripTests.getProjectMap(), null);
        this.doRoundTripFromOCLinEcore((OCL)ocl, "Comments");
        ocl.dispose();
    }

    public void testGenericsRoundTrip_468846() throws IOException, InterruptedException {
        String testFile = "package basket : basket = 'http://www.example.org/basket'\n{\n\tabstract class Fruit;\n\tabstract class Basket(T extends Fruit)\n\t{\n\t\tproperty fruit : T[*] { ordered };\n\t}\n}";
        this.createOCLinEcoreFile("Bug468846.oclinecore", testFile);
        OCLInternal ocl = OCLInternal.newInstance((ProjectManager)RoundTripTests.getProjectMap(), null);
        this.doRoundTripFromOCLinEcore((OCL)ocl, "Bug468846");
        ocl.dispose();
    }

    public void testGenericsRoundTrip_492800() throws IOException, InterruptedException {
        String testFile = "package example : example = 'http://www.example.org/generics/opposite'\n{\n\tabstract class Interface(T extends Event)\n\t{\n\t\tproperty events#interface : T[*] { ordered composes };\n\t\tattribute name : String[1];\n\t}\n\tclass CallInterface extends Interface(CallEvent);\n\tclass ReplyInterface extends Interface(ReplyEvent);\n\tabstract class Event\n\t{\n\t\tproperty interface#events : Interface(Event)[?];\n\t\tattribute name : String[1];\n\t}\n\tabstract class CallEvent extends Event;\n\tclass ReplyEvent extends Event;\n}";
        this.createOCLinEcoreFile("Bug492800.oclinecore", testFile);
        OCLInternal ocl = OCLInternal.newInstance((ProjectManager)RoundTripTests.getProjectMap(), null);
        this.doRoundTripFromOCLinEcore((OCL)ocl, "Bug492800");
        ocl.dispose();
    }

    public void testInvariantCommentsRoundTrip_410682() throws IOException, InterruptedException {
        String testFile = "package b : bb = 'bbb'\n{\nclass B\n{\n/* an invariant comment */\ninvariant t : true;\n/* an operation comment */\noperation op(/* a parameter comment */p : Boolean, /* another parameter comment */q : Boolean) : Boolean\n{\n/* a precondition comment */\nprecondition: p;\n/* another precondition comment */\nprecondition too: p;\nbody: p or q;\n/* a postcondition comment */\npostcondition: result = p;\n/* another postcondition comment */\npostcondition too: result = q;\n}\n}\n}\n";
        this.createOCLinEcoreFile("InvariantComments.oclinecore", testFile);
        OCLInternal ocl = OCLInternal.newInstance((ProjectManager)RoundTripTests.getProjectMap(), null);
        this.doRoundTripFromOCLinEcore((OCL)ocl, "InvariantComments");
        ocl.dispose();
    }

    public void testCompanyRoundTrip() throws IOException, InterruptedException, ParserException {
        this.doRoundTripFromEcore("Company", "Company.reference", null);
    }

    public void testEcoreRoundTrip() throws IOException, InterruptedException, ParserException {
        this.doRoundTripFromEcore("Ecore");
    }

    public void testEmptyRoundTrip() throws IOException, InterruptedException, ParserException {
        this.doRoundTripFromEcore("Empty");
    }

    public void testImportsRoundTrip() throws IOException, InterruptedException, ParserException {
        this.doRoundTripFromEcore("Imports");
    }

    public void testKeysRoundTrip() throws IOException, InterruptedException, ParserException {
        this.doRoundTripFromEcore("Keys");
    }

    public void testBug492960RoundTrip() throws IOException, InterruptedException, ParserException {
        this.doRoundTripFromEcore("Bug492960");
    }

    public void testCompleteOCLRoundTrip_Fruit() throws IOException, InterruptedException {
        UMLStandaloneSetup.init();
        OCL ocl = OCL.newInstance((ProjectManager)RoundTripTests.getProjectMap());
        Map uriMap = ocl.getResourceSet().getURIConverter().getURIMap();
        uriMap.putAll(UML402UMLExtendedMetaData.getURIMap());
        this.doRoundTripFromCompleteOCL(ocl, this.getProjectFileURI("Fruit.ocl"));
        ocl.dispose();
    }

    public void testCompleteOCLRoundTrip_Names() throws IOException, InterruptedException {
        OCL ocl = OCL.newInstance((ProjectManager)RoundTripTests.getProjectMap());
        this.doRoundTripFromCompleteOCL(ocl, this.getProjectFileURI("Names.ocl"));
        ocl.dispose();
    }

    public void testCompleteOCLRoundTrip_UML() throws IOException, InterruptedException {
        OCL ocl = OCL.newInstance((ProjectManager)RoundTripTests.getProjectMap());
        URI uml_2_5 = URI.createPlatformResourceURI((String)"UML-2.5/XMI-5-Jan-2012/Semanticed UML.ocl", (boolean)false);
        this.doRoundTripFromCompleteOCL(ocl, uml_2_5);
        ocl.dispose();
    }

    public void testOCLinEcoreCSTRoundTrip() throws IOException, InterruptedException, ParserException {
        URI uri = URI.createPlatformResourceURI((String)"/org.eclipse.ocl.xtext.oclinecore/model/OCLinEcoreCS.ecore", (boolean)true);
        OCLInternal ocl = OCLInternal.newInstance((ProjectManager)RoundTripTests.getProjectMap(), null);
        EnvironmentFactoryInternal environmentFactory = ocl.getEnvironmentFactory();
        ProjectManager.IProjectDescriptor projectDescriptor = RoundTripTests.getProjectMap().getProjectDescriptor("org.eclipse.emf.ecore");
        ProjectManager.IPackageDescriptor packageDescriptor = projectDescriptor.getPackageDescriptor(URI.createURI((String)"http://www.eclipse.org/emf/2002/Ecore"));
        packageDescriptor.configure(environmentFactory.getResourceSet(), StandaloneProjectMap.LoadGeneratedPackageStrategy.INSTANCE, StandaloneProjectMap.MapToFirstConflictHandler.INSTANCE);
        this.doRoundTripFromEcore(environmentFactory, uri, uri, null);
        ocl.dispose();
    }

    public void testPivotRoundTrip() throws IOException, InterruptedException, ParserException {
        URI uri = URI.createPlatformResourceURI((String)"/org.eclipse.ocl.pivot/model/Pivot.ecore", (boolean)true);
        this.doRoundTripFromEcore(uri, uri, null);
    }

    public void testOCLstdlibRoundTrip() throws IOException, InterruptedException, ParserException {
        this.doRoundTripFromEcore("OCLstdlib");
    }

    public void testOCLRoundTrip() throws IOException, InterruptedException, ParserException {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("addInvariantComments", true);
        this.doRoundTripFromEcore("OCL", "OCL", options);
    }

    public void testOCLCSTRoundTrip() throws IOException, InterruptedException, ParserException {
        this.doRoundTripFromEcore("OCLCST");
    }

    public void testOCLEcoreRoundTrip() throws IOException, InterruptedException, ParserException {
        this.doRoundTripFromEcore("OCLEcore");
    }

    public void testUML25RoundTrip() throws IOException, InterruptedException, ParserException {
        UMLStandaloneSetup.init();
        URI uri = URI.createPlatformResourceURI((String)"/org.eclipse.ocl.examples.uml25/model/UML.ecore", (boolean)true);
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("addInvariantComments", true);
        options.put("booleanInvariants", true);
        options.put("http://www.eclipse.org/emf/2002/Ecore/OCL", "http://www.eclipse.org/emf/2002/Ecore/OCL");
        options.put("omitSettingDelegates", true);
        OCLInternal ocl = OCLInternal.newInstance((ProjectManager)RoundTripTests.getProjectMap(), null);
        this.doRoundTripFromEcore(ocl.getEnvironmentFactory(), uri, uri, options);
        ocl.dispose();
    }

    public void testSysMLRoundTrip() throws IOException, InterruptedException {
        String testFile = "package b : bb = 'bbb'\n{\nclass B\n{\nsysml { stereotype = 'SysML::Block'; }\n}\n}\n";
        this.createOCLinEcoreFile("SysML.oclinecore", testFile);
        OCLInternal ocl = OCLInternal.newInstance((ProjectManager)RoundTripTests.getProjectMap(), null);
        this.doRoundTripFromOCLinEcore((OCL)ocl, "SysML");
        ocl.dispose();
    }

    public void testTypes_ecore() throws IOException, InterruptedException, ParserException {
        this.doRoundTripFromEcore("Types");
    }

    public void testTypes_oclinecore() throws IOException, InterruptedException {
        OCLInternal ocl = OCLInternal.newInstance((ProjectManager)RoundTripTests.getProjectMap(), null);
        this.doRoundTripFromOCLinEcore((OCL)ocl, "Types");
        ocl.dispose();
    }

    public void testXMLNamespaceRoundTrip() throws IOException, InterruptedException, ParserException {
        this.doRoundTripFromEcore("XMLNamespace");
    }

    public void testXMLTypeRoundTrip() throws IOException, InterruptedException, ParserException {
        this.doRoundTripFromEcore("XMLType");
    }
}

