/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.dynamic;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.osgi.framework.Bundle;

public abstract class JavaFileUtil {
    private static @Nullable JavaCompiler compiler = JavaFileUtil.getJavaCompiler();

    public static @Nullable String compileClasses(@NonNull List<@NonNull JavaFileObject> compilationUnits, @NonNull String sourcePath, @NonNull String objectPath, @Nullable List<@NonNull String> classpathProjects) {
        JavaCompiler compiler2 = compiler;
        if (compiler2 == null) {
            throw new IllegalStateException("No JavaCompiler provided by the Java platform - you need to use a JDK rather than a JRE");
        }
        StandardJavaFileManager stdFileManager2 = compiler2.getStandardFileManager(null, Locale.getDefault(), null);
        if (stdFileManager2 == null) {
            throw new IllegalStateException("No StandardJavaFileManager provided by the Java platform");
        }
        try {
            JavaCompiler.CompilationTask compilerTask;
            DiagnosticCollector diagnostics = new DiagnosticCollector();
            ArrayList<@NonNull String> compilationOptions = new ArrayList<String>();
            compilationOptions.add("-d");
            compilationOptions.add(objectPath);
            compilationOptions.add("-g");
            compilationOptions.add("-source");
            compilationOptions.add("1.8");
            if (EcorePlugin.IS_ECLIPSE_RUNNING && classpathProjects != null) {
                compilationOptions.add("-cp");
                compilationOptions.add(JavaFileUtil.createClassPath(classpathProjects));
            }
            if ((compilerTask = compiler2.getTask(null, stdFileManager2, diagnostics, compilationOptions, null, compilationUnits)).call().booleanValue()) {
                return null;
            }
            StringBuilder s = new StringBuilder();
            for (Diagnostic diagnostic : diagnostics.getDiagnostics()) {
                s.append("\n" + diagnostic.getMessage(null));
            }
            String message = s.length() > 0 ? "Failed to compile " + sourcePath + s.toString() : "Compilation of " + sourcePath + " returned false but no diagnostics";
            System.out.println(message);
            String string = message;
            return string;
        }
        finally {
            try {
                stdFileManager2.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static @NonNull String createClassPath(@NonNull List<String> projectNames) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        String pathSeparator = null;
        StringBuilder s = new StringBuilder();
        for (String projectName : projectNames) {
            URI uri;
            Bundle bundle;
            IPath location;
            String projectPath = null;
            IProject project = root.getProject(projectName);
            if (project != null && (location = project.getLocation()) != null) {
                projectPath = String.valueOf(location.toString()) + "/";
            }
            if (projectPath == null && (bundle = Platform.getBundle((String)projectName)) != null) {
                projectPath = bundle.getLocation();
            }
            if (projectPath == null) continue;
            if (projectPath.startsWith("reference:")) {
                projectPath = projectPath.substring(10);
            }
            if ((uri = URI.createURI((String)projectPath)).isFile()) {
                projectPath = ((String)ClassUtil.nonNullState((Object)uri.toFileString())).replace("\\", "/");
            }
            assert (projectPath != null);
            if (projectPath.endsWith("/")) {
                projectPath = String.valueOf(projectPath) + "bin";
            }
            if (pathSeparator != null) {
                s.append(pathSeparator);
            } else {
                pathSeparator = System.getProperty("path.separator");
            }
            s.append(projectPath);
        }
        return s.toString();
    }

    public static void deleteJavaFiles(@NonNull String sourcePath) {
        JavaFileUtil.deleteJavaFiles(new File(sourcePath));
    }

    private static void deleteJavaFiles(@NonNull File folder) {
        File[] listFiles = folder.listFiles();
        if (listFiles != null) {
            File[] fileArray = listFiles;
            int n = listFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    JavaFileUtil.deleteJavaFiles(file);
                } else if (file.isFile() && file.getName().endsWith(".java")) {
                    file.delete();
                }
                ++n2;
            }
        }
    }

    private static @Nullable JavaCompiler getJavaCompiler() {
        return ToolProvider.getSystemJavaCompiler();
    }
}

