/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.oclinecore;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.emf.codegen.ecore.generator.GeneratorAdapterFactory;
import org.eclipse.emf.codegen.ecore.genmodel.GenAnnotation;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.ecore.genmodel.generator.GenBaseGeneratorAdapter;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.common.OCLCommon;
import org.eclipse.ocl.common.internal.options.CodeGenerationMode;
import org.eclipse.ocl.common.internal.options.CommonOptions;
import org.eclipse.ocl.examples.codegen.common.PivotQueries;
import org.eclipse.ocl.examples.codegen.java.ImportUtils;
import org.eclipse.ocl.examples.codegen.model.CGLibrary;
import org.eclipse.ocl.examples.codegen.oclinecore.OCLinEcoreCodeGenerator;
import org.eclipse.ocl.examples.codegen.oclinecore.OCLinEcoreGeneratorAdapterFactory;
import org.eclipse.ocl.examples.codegen.oclinecore.OCLinEcoreTables;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.internal.ecore.as2es.AS2Ecore;
import org.eclipse.ocl.pivot.internal.ecore.es2as.Ecore2AS;
import org.eclipse.ocl.pivot.internal.manager.MetamodelManagerInternal;
import org.eclipse.ocl.pivot.internal.utilities.AS2Moniker;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.OCLInternal;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.resource.BasicProjectManager;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.uml2.codegen.ecore.genmodel.util.UML2GenModelUtil;

public class OCLinEcoreGenModelGeneratorAdapter
extends GenBaseGeneratorAdapter {
    public static final @NonNull String OCL_GENMODEL_URI = "http://www.eclipse.org/OCL/GenModel";
    public static final @NonNull String TABLES_POSTAMBLE_KEY = "Tables Postamble";
    public static final @NonNull String USE_DELEGATES_KEY = "Use Delegates";
    public static final @NonNull String USE_NULL_ANNOTATIONS_KEY = "Use Null Annotations";
    public static final @NonNull String INVARIANT_PREFIX_KEY = "Invariant Prefix";

    public static @Nullable String getInvariantPrefix(@NonNull GenModel genModel) {
        EMap details;
        GenAnnotation genAnnotation = genModel.getGenAnnotation(OCL_GENMODEL_URI);
        if (genAnnotation != null && (details = genAnnotation.getDetails()).containsKey((Object)INVARIANT_PREFIX_KEY)) {
            return String.valueOf(details.get((Object)INVARIANT_PREFIX_KEY));
        }
        return null;
    }

    public static @Nullable String tablesPostamble(@NonNull GenModel genModel) {
        EMap details;
        GenAnnotation genAnnotation = genModel.getGenAnnotation(OCL_GENMODEL_URI);
        if (genAnnotation != null && (details = genAnnotation.getDetails()).containsKey((Object)TABLES_POSTAMBLE_KEY)) {
            return String.valueOf(details.get((Object)TABLES_POSTAMBLE_KEY));
        }
        return null;
    }

    public static boolean useDelegates(@NonNull GenModel genModel) {
        EMap details;
        GenAnnotation genAnnotation = genModel.getGenAnnotation(OCL_GENMODEL_URI);
        if (genAnnotation != null && (details = genAnnotation.getDetails()).containsKey((Object)USE_DELEGATES_KEY)) {
            return Boolean.valueOf((String)details.get((Object)USE_DELEGATES_KEY));
        }
        CodeGenerationMode preference = (CodeGenerationMode)CommonOptions.CODE_GENERATION_MODE.getPreferredValue();
        return preference == CodeGenerationMode.DELEGATED;
    }

    public static boolean useNullAnnotations(@NonNull GenModel genModel) {
        EMap details;
        GenAnnotation genAnnotation = genModel.getGenAnnotation(OCL_GENMODEL_URI);
        if (genAnnotation != null && (details = genAnnotation.getDetails()).containsKey((Object)USE_NULL_ANNOTATIONS_KEY)) {
            return Boolean.valueOf((String)details.get((Object)USE_NULL_ANNOTATIONS_KEY));
        }
        return false;
    }

    public OCLinEcoreGenModelGeneratorAdapter(@NonNull OCLinEcoreGeneratorAdapterFactory generatorAdapterFactory) {
        super((GeneratorAdapterFactory)generatorAdapterFactory);
    }

    protected void createDispatchTables(@NonNull GenModel genModel, @NonNull Monitor monitor) throws IOException {
        try {
            Map<@NonNull GenPackage, @NonNull String> constantTexts = this.getStateAdapter(genModel).getConstantTexts();
            String lineDelimiter = this.getLineDelimiter(genModel);
            genModel.setLineDelimiter(lineDelimiter);
            File projectFolder = this.getProjectFolder(genModel);
            List genPackages = genModel.getAllGenPackagesWithClassifiers();
            for (GenPackage genPackage : genPackages) {
                OCLinEcoreTables generateTables = new OCLinEcoreTables(genPackage);
                String tablesClass = generateTables.getTablesClassName();
                String dir = genPackage.getReflectionPackageName().replace(".", "/");
                String constants = constantTexts.get(genPackage);
                generateTables.generateTablesClass(constants);
                String str = generateTables.toString();
                File tablesFolder = new File(projectFolder, dir);
                tablesFolder.mkdirs();
                File file = new File(tablesFolder, String.valueOf(tablesClass) + ".java");
                FileWriter testFile = new FileWriter(file);
                testFile.append(str);
                testFile.close();
            }
        }
        finally {
            genModel.setLineDelimiter(null);
        }
    }

    protected Diagnostic doPostGenerate(Object object, Object projectType) {
        assert (object != null);
        GenModel genModel = (GenModel)object;
        OCLinEcoreStateAdapter stateAdapter = this.findStateAdapter(genModel);
        if (stateAdapter != null) {
            stateAdapter.dispose();
            stateAdapter = null;
        }
        return super.doPostGenerate(object, projectType);
    }

    protected Diagnostic doPreGenerate(Object object, Object projectType) {
        assert (object != null);
        GenModel genModel = (GenModel)object;
        try {
            if (projectType == "org.eclipse.emf.codegen.ecore.genmodel.generator.ModelProject" && !OCLinEcoreGenModelGeneratorAdapter.useDelegates(genModel) && this.hasDelegates(genModel)) {
                OCLinEcoreStateAdapter stateAdapter = this.getStateAdapter(genModel);
                EList modelPluginVariables = genModel.getModelPluginVariables();
                if (!modelPluginVariables.contains("org.eclipse.ocl.pivot")) {
                    stateAdapter.addModelPluginVariable("org.eclipse.ocl.pivot");
                }
                if (!modelPluginVariables.contains("org.eclipse.ocl.examples.codegen")) {
                    stateAdapter.addModelPluginVariable("org.eclipse.ocl.examples.codegen");
                }
                if (OCLinEcoreGenModelGeneratorAdapter.useNullAnnotations(genModel) && !modelPluginVariables.contains("org.eclipse.jdt.annotation")) {
                    stateAdapter.addModelPluginVariable("org.eclipse.jdt.annotation");
                }
                for (GenPackage genPackage : genModel.getAllGenPackagesWithClassifiers()) {
                    this.createImportManager(genPackage.getReflectionPackageName(), String.valueOf(genPackage.getFactoryInterfaceName()) + "Tables");
                }
                Resource genResource = genModel.eResource();
                ResourceSet resourceSet = genResource.getResourceSet();
                if (resourceSet == null) {
                    throw new NullPointerException("No ResourceSet for genmodel");
                }
                MetamodelManagerInternal metamodelManager = stateAdapter.getMetamodelManager();
                metamodelManager.getStandardLibrary().getOclAnyType();
                for (GenPackage genPackage : genModel.getGenPackages()) {
                    EPackage ecorePackage = genPackage.getEcorePackage();
                    Package asPackage = (Package)metamodelManager.getASOfEcore(Package.class, (EObject)ecorePackage);
                    assert (asPackage != null);
                }
                metamodelManager.installRoot(CGLibrary.getDefaultModel());
                stateAdapter.convertConstraintsToOperations(metamodelManager);
                Map<@NonNull String, @NonNull String> results = stateAdapter.createFeatureBodies(genModel);
                for (String key : results.keySet()) {
                    String oldBody = results.get(key);
                    assert (oldBody != null);
                    String newBody = ImportUtils.rewriteManagedImports(oldBody, null);
                    results.put(key, newBody);
                }
                stateAdapter.installJavaBodies(metamodelManager, genModel, results);
                stateAdapter.pruneDelegates(genModel);
            }
        }
        catch (Exception e) {
            Exception t = e instanceof WrappedException ? ((WrappedException)e).getCause() : e;
            BasicDiagnostic thisDiagnostic = new BasicDiagnostic(4, ((Object)((Object)this)).getClass().getPackage().getName(), 0, "Failed to pre-generate " + genModel.getModelPluginID() + " constraints", new Object[]{t});
            Diagnostic thatDiagnostic = super.doPreGenerate(object, projectType);
            if (thatDiagnostic.getSeverity() == 0) {
                return thisDiagnostic;
            }
            thatDiagnostic.getChildren().add(thisDiagnostic);
            return thatDiagnostic;
        }
        return super.doPreGenerate(object, projectType);
    }

    protected @Nullable OCLinEcoreStateAdapter findStateAdapter(@NonNull GenModel genModel) {
        for (Adapter adapter : genModel.eAdapters()) {
            if (!(adapter instanceof OCLinEcoreStateAdapter) || ((OCLinEcoreStateAdapter)adapter).getGenModelGeneratorAdapter() != this) continue;
            return (OCLinEcoreStateAdapter)adapter;
        }
        return null;
    }

    protected Diagnostic generateModel(Object object, Monitor monitor) {
        assert (object != null);
        GenModel genModel = (GenModel)object;
        OCLinEcoreStateAdapter stateAdapter = this.findStateAdapter(genModel);
        try {
            if (stateAdapter != null) {
                monitor.beginTask("", 4);
                monitor.subTask("Generating Dispatch Tables");
                this.ensureProjectExists(genModel.getModelDirectory(), genModel, "org.eclipse.emf.codegen.ecore.genmodel.generator.ModelProject", genModel.isUpdateClasspath(), this.createMonitor(monitor, 1));
                if (this.getImportManager() == null) {
                    for (GenPackage genPackage : genModel.getAllGenPackagesWithClassifiers()) {
                        this.createImportManager(genPackage.getReflectionPackageName(), String.valueOf(genPackage.getFactoryInterfaceName()) + "Tables");
                    }
                }
                this.createDispatchTables(genModel, monitor);
                monitor.worked(1);
                monitor.worked(1);
                if (EMFPlugin.IS_ECLIPSE_RUNNING) {
                    IWorkspace workspace = ResourcesPlugin.getWorkspace();
                    String modelProjectDirectory = genModel.getModelProjectDirectory();
                    IProject modelProject = workspace.getRoot().getProject(modelProjectDirectory);
                    modelProject.refreshLocal(2, BasicMonitor.toIProgressMonitor((Monitor)monitor));
                }
                monitor.worked(1);
            }
        }
        catch (Exception e) {
            BasicDiagnostic thisDiagnostic = new BasicDiagnostic(4, ((Object)((Object)this)).getClass().getPackage().getName(), 0, "Failed to generate " + genModel.getModelPluginID() + " tables and bodies", new Object[]{e});
            return thisDiagnostic;
        }
        return super.generateModel(object, monitor);
    }

    protected String getLineDelimiter(GenModel genModel) {
        String modelProjectDirectory = String.valueOf(genModel.getModelProjectDirectory()) + "/.project";
        URI workspacePath = URI.createURI((String)modelProjectDirectory);
        String targetFileEncoding = this.getEncoding(workspacePath);
        return this.getLineDelimiter(workspacePath, targetFileEncoding);
    }

    protected @NonNull File getProjectFolder(@NonNull GenModel genModel) {
        String modelProjectDirectory = genModel.getModelProjectDirectory();
        String modelDirectory = genModel.getModelDirectory();
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IProject modelProject = workspace.getRoot().getProject(modelProjectDirectory);
            Path javaSource = new Path(modelDirectory);
            IFolder folder = modelProject.getParent().getFolder((IPath)javaSource);
            java.net.URI locationURI = (java.net.URI)ClassUtil.nonNullState((Object)folder.getLocationURI());
            return (File)ClassUtil.nonNullState((Object)URIUtil.toFile((java.net.URI)locationURI));
        }
        URI locationURI = URI.createPlatformResourceURI((String)modelDirectory, (boolean)true);
        ResourceSet resourceSet = genModel.eResource().getResourceSet();
        URIConverter uriConverter = resourceSet != null ? resourceSet.getURIConverter() : URIConverter.INSTANCE;
        URI normalizedURI = uriConverter.normalize(locationURI);
        return new File(normalizedURI.toFileString());
    }

    protected @NonNull OCLinEcoreStateAdapter getStateAdapter(@NonNull GenModel genModel) {
        for (Adapter adapter : genModel.eAdapters()) {
            if (!(adapter instanceof OCLinEcoreStateAdapter) || ((OCLinEcoreStateAdapter)adapter).getGenModelGeneratorAdapter() != this) continue;
            return (OCLinEcoreStateAdapter)adapter;
        }
        return new OCLinEcoreStateAdapter(genModel);
    }

    protected boolean hasConstraints(Class pivotClass) {
        if (pivotClass.getOwnedInvariants().size() > 0) {
            return true;
        }
        for (Operation operation : PivotQueries.getOperations(pivotClass)) {
            if (operation.getOwnedPreconditions().size() > 0) {
                return true;
            }
            if (operation.getOwnedPostconditions().size() > 0) {
                return true;
            }
            if (operation.getBodyExpression() == null) continue;
            return true;
        }
        for (Property property : PivotQueries.getProperties(pivotClass)) {
            if (property.getOwnedExpression() == null) continue;
            return true;
        }
        return false;
    }

    protected boolean hasDelegates(@NonNull GenModel genModel) {
        for (GenPackage genPackage : genModel.getAllGenPackagesWithClassifiers()) {
            EPackage ePackage = genPackage.getEcorePackage();
            if (ePackage == null || !this.hasDelegates(ePackage)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasDelegates(@NonNull EPackage ePackage) {
        List validationDelegates = EcoreUtil.getValidationDelegates((EPackage)ePackage);
        for (String validationDelegate : validationDelegates) {
            if (!OCLCommon.isDelegateURI((String)validationDelegate)) continue;
            return true;
        }
        List settingDelegates = EcoreUtil.getSettingDelegates((EPackage)ePackage);
        for (String settingDelegate : settingDelegates) {
            if (!OCLCommon.isDelegateURI((String)settingDelegate)) continue;
            return true;
        }
        List invocationDelegates = EcoreUtil.getInvocationDelegates((EPackage)ePackage);
        for (String invocationDelegate : invocationDelegates) {
            if (!OCLCommon.isDelegateURI((String)invocationDelegate)) continue;
            return true;
        }
        return false;
    }

    protected static interface Edit {
        public void undo();
    }

    protected class OCLinEcoreStateAdapter
    implements Adapter {
        protected final @NonNull OCLInternal ocl;
        protected final @NonNull GenModel genModel;
        private @NonNull Map<@NonNull GenPackage, @NonNull String> constantTexts = new HashMap<GenPackage, String>();
        private @NonNull List<Edit> edits = new ArrayList<Edit>();

        private OCLinEcoreStateAdapter(GenModel genModel) {
            EnvironmentFactoryInternal environmentFactory;
            Resource eResource = genModel.eResource();
            ResourceSet resourceSet = eResource != null ? eResource.getResourceSet() : null;
            EnvironmentFactoryInternal environmentFactoryInternal = environmentFactory = resourceSet != null ? PivotUtilInternal.findEnvironmentFactory((ResourceSet)resourceSet) : null;
            if (environmentFactory == null) {
                ProjectManager projectMap = BasicProjectManager.createDefaultProjectManager();
                projectMap.initializeResourceSet(resourceSet);
                this.ocl = OCLInternal.newInstance((ProjectManager)projectMap, (ResourceSet)resourceSet);
            } else {
                this.ocl = OCLInternal.newInstance((EnvironmentFactoryInternal)environmentFactory);
            }
            this.genModel = genModel;
            genModel.eAdapters().add((Object)this);
        }

        protected void addEAnnotationDetail(@NonNull EModelElement eModelElement, String sourceURI, @NonNull String detailName, @NonNull String value) {
            EAnnotation eAnnotation = eModelElement.getEAnnotation(sourceURI);
            if (eAnnotation == null) {
                eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
                eAnnotation.setSource(sourceURI);
                this.edits.add(new AddEAnnotation((List<EAnnotation>)eModelElement.getEAnnotations(), eAnnotation));
            }
            this.edits.add(new SetEAnnotationDetail(eAnnotation, detailName, value));
        }

        protected void addEOperation(@NonNull EClass eClass, @NonNull EOperation eOperation) {
            this.edits.add(new AddEOperation((List<EOperation>)eClass.getEOperations(), eOperation));
        }

        protected void addModelPluginVariable(@NonNull String modelPluginVariable) {
            this.edits.add(new AddModelPluginVariable(modelPluginVariable));
        }

        protected void convertConstraintToOperation(@NonNull Ecore2AS ecore2as, @NonNull GenModel genModel, @NonNull EClass eClass, @NonNull String key, @NonNull String body, @Nullable String message) {
            List ownedInvariants;
            Class pType = (Class)ecore2as.getCreated(Class.class, (EObject)eClass);
            if (pType != null && (ownedInvariants = pType.getOwnedInvariants()).size() > 0) {
                String prefix = UML2GenModelUtil.getInvariantPrefix((GenModel)genModel);
                if (prefix == null && (prefix = OCLinEcoreGenModelGeneratorAdapter.getInvariantPrefix(genModel)) == null) {
                    prefix = "";
                }
                String names = "";
                for (Constraint rule : ownedInvariants) {
                    String ruleName = rule.getName();
                    if (ruleName == null) {
                        ruleName = "";
                    }
                    if (!ruleName.equals(key)) continue;
                    String prefixedName = String.valueOf(prefix) + ruleName;
                    names = names.length() == 0 ? prefixedName : String.valueOf(names) + " " + prefixedName;
                    EOperation eOperation = AS2Ecore.createConstraintEOperation((Constraint)rule, (String)prefixedName, null);
                    this.addEOperation(eClass, eOperation);
                    ecore2as.addMapping((EObject)eOperation, (Element)rule);
                    if (message != null) {
                        body = PivotUtil.createTupleValuedConstraint((String)body, null, (String)message);
                    }
                    this.addEAnnotationDetail((EModelElement)eOperation, "http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot", "body", body);
                }
                this.addEAnnotationDetail((EModelElement)eClass, "http://www.eclipse.org/emf/2002/Ecore", "constraints", names);
            }
        }

        protected void convertConstraintsToOperations(@NonNull MetamodelManagerInternal metamodelManager) {
            List genPackages = this.genModel.getAllGenPackagesWithClassifiers();
            for (GenPackage genPackage : genPackages) {
                EPackage ecorePackage = genPackage.getEcorePackage();
                this.removeEAnnotation(ecorePackage.getEAnnotation("http://www.eclipse.org/OCL/Import"));
                Resource ecoreResource = ecorePackage.eResource();
                if (ecoreResource == null) continue;
                Ecore2AS ecore2as = Ecore2AS.getAdapter((Resource)ecoreResource, (EnvironmentFactoryInternal)metamodelManager.getEnvironmentFactory());
                for (GenClass genClass : genPackage.getGenClasses()) {
                    EClass eClass = genClass.getEcoreClass();
                    if (eClass == null) continue;
                    ArrayList<EAnnotation> obsoleteAnnotations = null;
                    for (EAnnotation eAnnotation : new ArrayList(eClass.getEAnnotations())) {
                        String source = eAnnotation.getSource();
                        if (OCLCommon.isDelegateURI((String)source)) {
                            String messageAnnotationDetailSuffix = "$message";
                            EMap details = eAnnotation.getDetails();
                            for (String key : details.keySet()) {
                                if (key == null || key.endsWith(messageAnnotationDetailSuffix)) continue;
                                String expression = (String)details.get((Object)key);
                                String messageExpression = (String)details.get((Object)(String.valueOf(key) + messageAnnotationDetailSuffix));
                                if (expression == null) continue;
                                this.convertConstraintToOperation(ecore2as, this.genModel, eClass, key, expression, messageExpression);
                            }
                            if (obsoleteAnnotations == null) {
                                obsoleteAnnotations = new ArrayList<EAnnotation>();
                            }
                            obsoleteAnnotations.add(eAnnotation);
                        }
                        if (!"http://www.eclipse.org/emf/2002/Ecore".equals(source)) continue;
                        this.removeEAnnotationDetail(eAnnotation, "constraints");
                    }
                    if (obsoleteAnnotations != null) {
                        for (EAnnotation eAnnotation : obsoleteAnnotations) {
                            this.removeEAnnotation(eAnnotation);
                        }
                    }
                    genClass.initialize(eClass);
                }
            }
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public @NonNull Map<@NonNull String, @NonNull String> createFeatureBodies(@NonNull GenModel genModel) throws IOException {
            HashMap<@NonNull String, @NonNull String> allResults = new HashMap<String, String>();
            @NonNull List allGenPackagesWithClassifiers = genModel.getAllGenPackagesWithClassifiers();
            @NonNull List genPackages = ClassUtil.nullFree((List)allGenPackagesWithClassifiers);
            for (GenPackage genPackage : genPackages) {
                OCLinEcoreCodeGenerator.generatePackage(genPackage, allResults, this.constantTexts);
            }
            ArrayList<@NonNull K> resultsKeys = new ArrayList(allResults.keySet());
            Collections.sort(resultsKeys);
            return allResults;
        }

        public void dispose() {
            this.genModel.eAdapters().remove((Object)this);
            int i = this.edits.size();
            while (--i >= 0) {
                Edit edit = this.edits.get(i);
                edit.undo();
            }
            this.ocl.dispose();
        }

        public @NonNull Map<@NonNull GenPackage, @NonNull String> getConstantTexts() {
            return this.constantTexts;
        }

        protected @NonNull OCLinEcoreGenModelGeneratorAdapter getGenModelGeneratorAdapter() {
            return OCLinEcoreGenModelGeneratorAdapter.this;
        }

        public @NonNull MetamodelManagerInternal getMetamodelManager() {
            return this.ocl.getMetamodelManager();
        }

        public @NonNull GenModel getTarget() {
            return this.genModel;
        }

        protected void installJavaBodies(@NonNull MetamodelManagerInternal metamodelManager, @NonNull GenModel genModel, @NonNull Map<String, String> results) {
            List genPackages = genModel.getAllGenPackagesWithClassifiers();
            for (GenPackage genPackage : genPackages) {
                EPackage ecorePackage = genPackage.getEcorePackage();
                Resource ecoreResource = ecorePackage.eResource();
                if (ecoreResource == null) continue;
                Ecore2AS ecore2as = Ecore2AS.getAdapter((Resource)ecoreResource, (EnvironmentFactoryInternal)metamodelManager.getEnvironmentFactory());
                for (GenClass genClass : genPackage.getGenClasses()) {
                    EClass eClass = genClass.getEcoreClass();
                    if (eClass == null) continue;
                    for (EOperation eOperation : eClass.getEOperations()) {
                        this.installOperation(ecore2as, eOperation, results);
                    }
                    for (EStructuralFeature eFeature : eClass.getEStructuralFeatures()) {
                        this.installProperty(ecore2as, eFeature, results);
                    }
                }
            }
        }

        protected void installOperation(@NonNull Ecore2AS ecore2as, @NonNull EOperation eOperation, @NonNull Map<String, String> results) {
            String body;
            Element pOperation = ecore2as.getCreated(Element.class, (EObject)eOperation);
            String fragmentURI = null;
            if (pOperation instanceof Operation) {
                fragmentURI = String.valueOf(EcoreUtil.getURI((EObject)pOperation).fragment());
            } else if (pOperation instanceof Constraint) {
                Constraint constraint = (Constraint)pOperation;
                fragmentURI = String.valueOf(String.valueOf(EcoreUtil.getURI((EObject)constraint.eContainer()).fragment())) + "==" + constraint.getName();
            }
            String string = body = fragmentURI != null ? results.get(fragmentURI) : null;
            if (body == null || (body = body.trim()).length() == 0) {
                String javaBody = EcoreUtil.getAnnotation((EModelElement)eOperation, (String)"http://www.eclipse.org/emf/2002/GenModel", (String)"body");
                if (javaBody != null) {
                    return;
                }
                body = "throw new UnsupportedOperationException();  // FIXME Unimplemented " + (pOperation != null ? AS2Moniker.toString((Element)pOperation) : "");
            }
            this.addEAnnotationDetail((EModelElement)eOperation, "http://www.eclipse.org/emf/2002/GenModel", "body", body);
            this.removeEAnnotation(eOperation.getEAnnotation("http://www.eclipse.org/emf/2002/Ecore/OCL"));
            this.removeEAnnotation(eOperation.getEAnnotation("http://www.eclipse.org/emf/2002/Ecore/OCL/LPG"));
            this.removeEAnnotation(eOperation.getEAnnotation("http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot"));
            this.removeEAnnotation(eOperation.getEAnnotation("http://www.eclipse.org/uml2/1.1.0/GenModel"));
        }

        protected void installProperty(@NonNull Ecore2AS ecore2as, @NonNull EStructuralFeature eFeature, @NonNull Map<String, String> results) {
            Property pProperty = (Property)ecore2as.getCreated(Property.class, (EObject)eFeature);
            String fragmentURI = String.valueOf(EcoreUtil.getURI((EObject)pProperty).fragment());
            String body = results.get(fragmentURI);
            if (body == null) {
                String javaBody = EcoreUtil.getAnnotation((EModelElement)eFeature, (String)"http://www.eclipse.org/emf/2002/GenModel", (String)"get");
                if (javaBody != null) {
                    return;
                }
                body = "throw new UnsupportedOperationException();  // FIXME Unimplemented " + (pProperty != null ? AS2Moniker.toString((Element)pProperty) : "");
            }
            this.addEAnnotationDetail((EModelElement)eFeature, "http://www.eclipse.org/emf/2002/GenModel", "get", body);
            this.removeEAnnotation(eFeature.getEAnnotation("http://www.eclipse.org/emf/2002/Ecore/OCL"));
            this.removeEAnnotation(eFeature.getEAnnotation("http://www.eclipse.org/emf/2002/Ecore/OCL/LPG"));
            this.removeEAnnotation(eFeature.getEAnnotation("http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot"));
            this.removeEAnnotation(eFeature.getEAnnotation("http://www.eclipse.org/uml2/1.1.0/GenModel"));
        }

        protected void pruneDelegates(@NonNull GenModel genModel) {
            for (GenPackage genPackage : genModel.getAllGenPackagesWithClassifiers()) {
                EPackage ePackage = genPackage.getEcorePackage();
                if (ePackage == null || !OCLinEcoreGenModelGeneratorAdapter.this.hasDelegates(ePackage)) continue;
                this.edits.add(new SetValidationDelegates(ePackage));
                this.edits.add(new SetSettingDelegates(ePackage));
                this.edits.add(new SetInvocationDelegates(ePackage));
            }
        }

        protected @NonNull List<String> pruneDelegates(@Nullable List<String> oldDelegates) {
            ArrayList<String> newDelegates = new ArrayList<String>();
            if (oldDelegates != null) {
                for (String aDelegate : oldDelegates) {
                    if (OCLCommon.isDelegateURI((String)aDelegate)) continue;
                    newDelegates.add(aDelegate);
                }
            }
            return newDelegates;
        }

        protected void removeEAnnotation(@Nullable EAnnotation oclAnnotation) {
            if (oclAnnotation != null) {
                this.edits.add(new RemoveEAnnotation(oclAnnotation));
            }
        }

        protected void removeEAnnotationDetail(@NonNull EAnnotation eAnnotation, @NonNull String detailName) {
            this.edits.add(new SetEAnnotationDetail(eAnnotation, detailName));
        }

        public boolean isAdapterForType(Object type) {
            return false;
        }

        public void notifyChanged(Notification notification) {
        }

        public void setTarget(Notifier newTarget) {
            assert (newTarget == null || newTarget == this.genModel);
        }

        protected class AddEAnnotation
        implements Edit {
            private final @NonNull List<EAnnotation> eAnnotations;
            private final @NonNull EAnnotation eAnnotation;

            public AddEAnnotation(@NonNull List<EAnnotation> eAnnotations, EAnnotation eAnnotation) {
                this.eAnnotations = eAnnotations;
                this.eAnnotation = eAnnotation;
                eAnnotations.add(eAnnotation);
            }

            @Override
            public void undo() {
                this.eAnnotations.remove(this.eAnnotation);
            }
        }

        protected class AddEOperation
        implements Edit {
            private final @NonNull List<EOperation> eOperations;
            private final @NonNull EOperation eOperation;

            public AddEOperation(@NonNull List<EOperation> eOperations, EOperation eOperation) {
                this.eOperations = eOperations;
                this.eOperation = eOperation;
                eOperations.add(eOperation);
            }

            @Override
            public void undo() {
                this.eOperations.remove(this.eOperation);
            }
        }

        protected class AddModelPluginVariable
        implements Edit {
            private final @NonNull String modelPluginVariable;

            public AddModelPluginVariable(String modelPluginVariable) {
                this.modelPluginVariable = modelPluginVariable;
                OCLinEcoreStateAdapter.this.genModel.getModelPluginVariables().add((Object)modelPluginVariable);
            }

            @Override
            public void undo() {
                OCLinEcoreStateAdapter.this.genModel.getModelPluginVariables().remove((Object)this.modelPluginVariable);
            }
        }

        protected class RemoveEAnnotation
        implements Edit {
            private final @NonNull EAnnotation eAnnotation;
            private final @NonNull List<EAnnotation> eAnnotations;
            private final int index;

            public RemoveEAnnotation(EAnnotation eAnnotation) {
                this.eAnnotation = eAnnotation;
                this.eAnnotations = ((EModelElement)eAnnotation.eContainer()).getEAnnotations();
                this.index = this.eAnnotations.indexOf(eAnnotation);
                this.eAnnotations.remove(eAnnotation);
            }

            @Override
            public void undo() {
                this.eAnnotations.add(this.index, this.eAnnotation);
            }
        }

        protected class SetEAnnotationDetail
        implements Edit {
            private final @NonNull EAnnotation eAnnotation;
            private final @NonNull String detailName;
            private final int index;
            private final @Nullable String value;

            public SetEAnnotationDetail(@NonNull EAnnotation eAnnotation, String detailName) {
                this.eAnnotation = eAnnotation;
                this.detailName = detailName;
                EMap details = eAnnotation.getDetails();
                this.index = details.indexOf((Object)detailName);
                this.value = (String)details.get((Object)detailName);
                if (this.index >= 0) {
                    details.remove(this.index);
                }
            }

            public SetEAnnotationDetail(@NonNull EAnnotation eAnnotation, @Nullable String detailName, String value) {
                this.eAnnotation = eAnnotation;
                this.detailName = detailName;
                EMap details = eAnnotation.getDetails();
                this.index = details.indexOf((Object)detailName);
                this.value = (String)details.put((Object)detailName, (Object)value);
            }

            @Override
            public void undo() {
                EMap details = this.eAnnotation.getDetails();
                if (this.index < 0) {
                    details.remove((Object)this.detailName);
                } else {
                    details.put((Object)this.detailName, (Object)this.value);
                    int newIndex = details.indexOf((Object)this.detailName);
                    if (newIndex != this.index) {
                        details.move(this.index, newIndex);
                    }
                }
            }
        }

        protected class SetInvocationDelegates
        implements Edit {
            private final @NonNull EPackage ePackage;
            private final @NonNull List<String> invocationDelegates;

            public SetInvocationDelegates(EPackage ePackage) {
                this.ePackage = ePackage;
                this.invocationDelegates = EcoreUtil.getInvocationDelegates((EPackage)ePackage);
                EcoreUtil.setInvocationDelegates((EPackage)ePackage, OCLinEcoreStateAdapter.this.pruneDelegates(this.invocationDelegates));
            }

            @Override
            public void undo() {
                EcoreUtil.setInvocationDelegates((EPackage)this.ePackage, this.invocationDelegates);
            }
        }

        protected class SetSettingDelegates
        implements Edit {
            private final @NonNull EPackage ePackage;
            private final @NonNull List<String> settingDelegates;

            public SetSettingDelegates(EPackage ePackage) {
                this.ePackage = ePackage;
                this.settingDelegates = EcoreUtil.getSettingDelegates((EPackage)ePackage);
                EcoreUtil.setSettingDelegates((EPackage)ePackage, OCLinEcoreStateAdapter.this.pruneDelegates(this.settingDelegates));
            }

            @Override
            public void undo() {
                EcoreUtil.setSettingDelegates((EPackage)this.ePackage, this.settingDelegates);
            }
        }

        protected class SetValidationDelegates
        implements Edit {
            private final @NonNull EPackage ePackage;
            private final @NonNull List<String> validationDelegates;

            public SetValidationDelegates(EPackage ePackage) {
                this.ePackage = ePackage;
                this.validationDelegates = EcoreUtil.getValidationDelegates((EPackage)ePackage);
                EcoreUtil.setValidationDelegates((EPackage)ePackage, OCLinEcoreStateAdapter.this.pruneDelegates(this.validationDelegates));
            }

            @Override
            public void undo() {
                EcoreUtil.setValidationDelegates((EPackage)this.ePackage, this.validationDelegates);
            }
        }
    }
}

