/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.ecore.tests;

import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ocl.OCLInput;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.EcoreEnvironment;
import org.eclipse.ocl.ecore.ExpressionInOCL;
import org.eclipse.ocl.ecore.tests.AbstractTestSuite;
import org.eclipse.ocl.expressions.Variable;

public class OCLDocumentTest
extends AbstractTestSuite {
    Map<String, Constraint> constraints;

    public void test_multipleInvariants() {
        Constraint notBlack = this.getConstraint("not_black");
        Constraint notFoo = this.getConstraint("not_foo");
        this.assertMatchingContextVariables((EClassifier)this.fruit, notBlack);
        this.assertMatchingContextVariables((EClassifier)this.fruit, notFoo);
        EObject anApple = this.fruitFactory.create(this.apple);
        anApple.eSet((EStructuralFeature)this.fruit_color, (Object)this.color_black);
        anApple.eSet((EStructuralFeature)this.apple_label, (Object)"Foo");
        OCLDocumentTest.assertFalse((boolean)this.ocl.check((Object)anApple, (Object)notFoo));
        OCLDocumentTest.assertFalse((boolean)this.ocl.check((Object)anApple, (Object)notBlack));
        anApple.eSet((EStructuralFeature)this.fruit_color, (Object)this.color_red);
        anApple.eSet((EStructuralFeature)this.apple_label, (Object)"Bar");
        OCLDocumentTest.assertTrue((boolean)this.ocl.check((Object)anApple, (Object)notFoo));
        OCLDocumentTest.assertTrue((boolean)this.ocl.check((Object)anApple, (Object)notBlack));
    }

    public void test_multipleDefExpressions() {
        this.assertMatchingContextVariables((EClassifier)this.fruit, this.getConstraint("property_helper"));
        this.assertMatchingContextVariables((EClassifier)this.fruit, this.getConstraint("operation_helper"));
        EObject anApple = this.fruitFactory.create(this.apple);
        anApple.eSet((EStructuralFeature)this.fruit_color, (Object)this.color_black);
        anApple.eSet((EStructuralFeature)this.apple_label, (Object)"Foo");
        EObject anotherApple = this.fruitFactory.create(this.apple);
        anotherApple.eSet((EStructuralFeature)this.fruit_color, (Object)this.color_red);
        anotherApple.eSet((EStructuralFeature)this.apple_label, (Object)"Bar");
        HashSet<EObject> apples = new HashSet<EObject>();
        apples.add(anApple);
        apples.add(anotherApple);
        HashMap<EClass, HashSet<EObject>> extentMap = new HashMap<EClass, HashSet<EObject>>();
        extentMap.put(this.apple, apples);
        extentMap.put(this.fruit, apples);
        this.ocl.setExtentMap(extentMap);
        this.helper = this.ocl.createOCLHelper();
        this.helper.setContext((Object)this.apple);
        try {
            Object value = this.evaluate(this.helper, anApple, "self.otherFruits");
            OCLDocumentTest.assertEquals(Collections.singleton(anotherApple), (Object)value);
            value = this.evaluate(this.helper, anotherApple, "self.getOtherFruits(false)");
            OCLDocumentTest.assertEquals(Collections.singleton(anApple), (Object)value);
        }
        catch (ParserException e) {
            OCLDocumentTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_multipleInvariantsAndDefExpressions() {
        Constraint notBlack = this.getConstraint("not_black1");
        Constraint notFoo = this.getConstraint("not_foo1");
        this.assertMatchingContextVariables((EClassifier)this.fruit, notBlack);
        this.assertMatchingContextVariables((EClassifier)this.fruit, notFoo);
        this.assertMatchingContextVariables((EClassifier)this.fruit, this.getConstraint("property_helper"));
        this.assertMatchingContextVariables((EClassifier)this.fruit, this.getConstraint("operation_helper"));
        EObject anApple = this.fruitFactory.create(this.apple);
        anApple.eSet((EStructuralFeature)this.fruit_color, (Object)this.color_black);
        anApple.eSet((EStructuralFeature)this.apple_label, (Object)"Foo");
        OCLDocumentTest.assertFalse((boolean)this.ocl.check((Object)anApple, (Object)notFoo));
        OCLDocumentTest.assertFalse((boolean)this.ocl.check((Object)anApple, (Object)notBlack));
        anApple.eSet((EStructuralFeature)this.fruit_color, (Object)this.color_red);
        anApple.eSet((EStructuralFeature)this.apple_label, (Object)"Bar");
        OCLDocumentTest.assertTrue((boolean)this.ocl.check((Object)anApple, (Object)notFoo));
        OCLDocumentTest.assertTrue((boolean)this.ocl.check((Object)anApple, (Object)notBlack));
        anApple.eSet((EStructuralFeature)this.fruit_color, (Object)this.color_black);
        anApple.eSet((EStructuralFeature)this.apple_label, (Object)"Foo");
        EObject anotherApple = this.fruitFactory.create(this.apple);
        anotherApple.eSet((EStructuralFeature)this.fruit_color, (Object)this.color_red);
        anotherApple.eSet((EStructuralFeature)this.apple_label, (Object)"Bar");
        HashSet<EObject> apples = new HashSet<EObject>();
        apples.add(anApple);
        apples.add(anotherApple);
        HashMap<EClass, HashSet<EObject>> extentMap = new HashMap<EClass, HashSet<EObject>>();
        extentMap.put(this.apple, apples);
        extentMap.put(this.fruit, apples);
        this.ocl.setExtentMap(extentMap);
        this.helper = this.ocl.createOCLHelper();
        this.helper.setContext((Object)this.apple);
        try {
            Object value = this.evaluate(this.helper, anApple, "self.otherFruits1");
            OCLDocumentTest.assertEquals(Collections.singleton(anotherApple), (Object)value);
            value = this.evaluate(this.helper, anotherApple, "self.getOtherFruits1(false)");
            OCLDocumentTest.assertEquals(Collections.singleton(anApple), (Object)value);
        }
        catch (ParserException e) {
            OCLDocumentTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_multipleMixedOperationConstraints() {
        Constraint textNotNull = this.getConstraint("text_not_null");
        Constraint textNotLabel = this.getConstraint("text_not_label");
        Constraint computeLabel = this.getConstraint("compute_label");
        Constraint labelIsChanged = this.getConstraint("label_is_changed");
        Constraint labelIsSet = this.getConstraint("label_is_set");
        OCLDocumentTest.assertEquals((int)1, (int)textNotNull.getConstrainedElements().size());
        EOperation oper = (EOperation)textNotNull.getConstrainedElements().get(0);
        OCLDocumentTest.assertNotNull((Object)oper);
        OCLDocumentTest.assertEquals((String)"precondition", (String)textNotNull.getStereotype());
        OCLDocumentTest.assertNotNull((Object)textNotNull.getSpecification().getBodyExpression());
        this.assertMatchingContextVariables(oper, textNotNull);
        OCLDocumentTest.assertEquals((int)1, (int)textNotLabel.getConstrainedElements().size());
        OCLDocumentTest.assertSame((Object)oper, (Object)textNotLabel.getConstrainedElements().get(0));
        OCLDocumentTest.assertEquals((String)"precondition", (String)textNotLabel.getStereotype());
        OCLDocumentTest.assertNotNull((Object)textNotLabel.getSpecification().getBodyExpression());
        this.assertMatchingContextVariables(oper, textNotLabel);
        OCLDocumentTest.assertEquals((int)1, (int)computeLabel.getConstrainedElements().size());
        OCLDocumentTest.assertSame((Object)oper, (Object)computeLabel.getConstrainedElements().get(0));
        OCLDocumentTest.assertEquals((String)"body", (String)computeLabel.getStereotype());
        OCLDocumentTest.assertNotNull((Object)computeLabel.getSpecification().getBodyExpression());
        this.assertMatchingContextVariables(oper, computeLabel);
        OCLDocumentTest.assertEquals((int)1, (int)labelIsChanged.getConstrainedElements().size());
        OCLDocumentTest.assertSame((Object)oper, (Object)labelIsChanged.getConstrainedElements().get(0));
        OCLDocumentTest.assertEquals((String)"postcondition", (String)labelIsChanged.getStereotype());
        OCLDocumentTest.assertNotNull((Object)labelIsChanged.getSpecification().getBodyExpression());
        this.assertMatchingContextVariables(oper, labelIsChanged);
        OCLDocumentTest.assertEquals((int)1, (int)labelIsSet.getConstrainedElements().size());
        OCLDocumentTest.assertSame((Object)oper, (Object)labelIsSet.getConstrainedElements().get(0));
        OCLDocumentTest.assertEquals((String)"postcondition", (String)labelIsSet.getStereotype());
        OCLDocumentTest.assertNotNull((Object)labelIsSet.getSpecification().getBodyExpression());
        this.assertMatchingContextVariables(oper, labelIsSet);
    }

    public void test_initAndDerConstraints() {
        this.helper.setContext((Object)this.apple);
        try {
            EObject anApple = this.fruitFactory.create(this.apple);
            anApple.eSet((EStructuralFeature)this.apple_label, (Object)"Foo");
            OCLDocumentTest.assertEquals((Object)"Foo", (Object)this.evaluate(this.helper, anApple, "self.name"));
            anApple.eUnset((EStructuralFeature)this.apple_label);
            OCLDocumentTest.assertEquals((Object)"", (Object)this.evaluate(this.helper, anApple, "self.name"));
        }
        catch (ParserException e) {
            OCLDocumentTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_operationContextWithoutClassifierName_182286() {
        try {
            this.ocl.parse(new OCLInput("context label(s : String) : \n  pre: true"));
        }
        catch (ParserException e) {
            System.out.println("Got expected exception: " + e.getLocalizedMessage());
        }
        catch (RuntimeException e) {
            OCLDocumentTest.fail((String)("Got runtime exception: " + e.getLocalizedMessage()));
        }
    }

    public void test_dependenciesOnDefExpressions_packageContext_176109() {
        try {
            this.ocl.parse(new OCLInput("package ecore context EClassifier \ndef: isHappy() : Boolean = true \nendpackage \npackage ecore context ETypedElement \ninv: eType <> null implies eType.isHappy() \nendpackage \n"));
        }
        catch (ParserException e) {
            OCLDocumentTest.fail((String)("Should not have failed to parse: " + e.getLocalizedMessage()));
        }
    }

    public void test_dependenciesOnDefExpressions_classifierContext_176109() {
        try {
            this.ocl.parse(new OCLInput("package ecore \ncontext EClassifier \ndef: isHappy() : Boolean = true \ncontext ETypedElement \ninv: eType <> null implies eType.isHappy() \nendpackage \n"));
        }
        catch (ParserException e) {
            OCLDocumentTest.fail((String)("Should not have failed to parse: " + e.getLocalizedMessage()));
        }
    }

    public void test_dependenciesOnDefExpressions_withinClassifierContext_176109() {
        try {
            this.ocl.parse(new OCLInput("package ecore \ncontext EClassifier \ndef: isHappy() : Boolean = true \ninv: self.isHappy() \nendpackage \n"));
        }
        catch (ParserException e) {
            OCLDocumentTest.fail((String)("Should not have failed to parse: " + e.getLocalizedMessage()));
        }
    }

    protected void setUp() {
        super.setUp();
        this.constraints = new HashMap<String, Constraint>();
        URI uri = this.getTestModelURI("/model/test_constraints.ocl");
        try {
            URL url = new URL(uri.toString());
            InputStream is = url.openStream();
            List parsed = this.ocl.parse(new OCLInput(is));
            is.close();
            for (Constraint ct : parsed) {
                this.validate(ct);
                this.constraints.put(ct.getName(), ct);
            }
        }
        catch (Exception e) {
            OCLDocumentTest.fail((String)("Failed to parse " + uri + " : " + e.getMessage()));
        }
    }

    Constraint getConstraint(String name) {
        Constraint result = this.constraints.get(name);
        OCLDocumentTest.assertNotNull((String)("Did not find constraint " + name), (Object)result);
        return result;
    }

    void assertMatchingContextVariables(EClassifier context, Constraint constraint) {
        ExpressionInOCL spec = (ExpressionInOCL)constraint.getSpecification();
        EcoreEnvironment env = (EcoreEnvironment)this.ocl.getEnvironment();
        Variable selfVar = spec.getContextVariable();
        OCLDocumentTest.assertNotNull((Object)selfVar);
        OCLDocumentTest.assertEquals((String)"self", (String)selfVar.getName());
        OCLDocumentTest.assertEquals((Object)selfVar.getType(), (Object)env.getUMLReflection().getOCLType((Object)context));
    }

    void assertMatchingContextVariables(EOperation operation, Constraint constraint) {
        ExpressionInOCL spec = (ExpressionInOCL)constraint.getSpecification();
        EcoreEnvironment env = (EcoreEnvironment)this.ocl.getEnvironment();
        if (operation.getEContainingClass() != null) {
            Variable selfVar = spec.getContextVariable();
            OCLDocumentTest.assertNotNull((Object)selfVar);
            OCLDocumentTest.assertEquals((String)"self", (String)selfVar.getName());
            OCLDocumentTest.assertEquals((Object)selfVar.getType(), (Object)env.getUMLReflection().getOCLType((Object)operation.getEContainingClass()));
        }
        if (operation.getEType() != null && !"precondition".equals(constraint.getStereotype())) {
            Variable resultVar = spec.getResultVariable();
            OCLDocumentTest.assertNotNull((Object)resultVar);
            OCLDocumentTest.assertEquals((String)"result", (String)resultVar.getName());
            OCLDocumentTest.assertEquals((Object)resultVar.getType(), (Object)env.getUMLReflection().getOCLType((Object)operation));
        }
        EList parms = operation.getEParameters();
        EList vars = spec.getParameterVariable();
        OCLDocumentTest.assertEquals((int)parms.size(), (int)vars.size());
        int i = 0;
        while (i < parms.size()) {
            Variable var = (Variable)vars.get(i);
            EParameter parm = (EParameter)parms.get(i);
            OCLDocumentTest.assertEquals((Object)var.getType(), (Object)env.getUMLReflection().getOCLType((Object)parm));
            ++i;
        }
    }
}

