/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.ecore.tests;

import java.util.Collections;
import java.util.HashMap;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.ecore.BagType;
import org.eclipse.ocl.ecore.CollectionType;
import org.eclipse.ocl.ecore.EcoreFactory;
import org.eclipse.ocl.ecore.OrderedSetType;
import org.eclipse.ocl.ecore.SequenceType;
import org.eclipse.ocl.ecore.SetType;
import org.eclipse.ocl.ecore.tests.AbstractTestSuite;
import org.eclipse.ocl.expressions.Variable;

public class TypesValidatorTest
extends AbstractTestSuite {
    private final EcoreFactory factory = EcoreFactory.eINSTANCE;

    public void test_CollectionType_checkCollectionTypeName() {
        CollectionType type = this.factory.createCollectionType();
        type.setElementType((Object)this.fruit);
        this.assertOK((EObject)type, 2);
        type.setName("Collection(Integer)");
        this.assertProblem((EObject)type, 2);
        type.setName("Sequence(Fruit)");
        this.assertProblem((EObject)type, 2);
        this.assertOK((EObject)this.getOCLStandardLibrary().getCollection(), 2);
    }

    public void test_BagType_checkCollectionTypeName() {
        BagType type = this.factory.createBagType();
        type.setElementType((Object)this.fruit);
        this.assertOK((EObject)type, 1);
        type.setName("Bag(Integer)");
        this.assertProblem((EObject)type, 1);
        type.setName("Collection(Fruit)");
        this.assertProblem((EObject)type, 1);
        this.assertOK((EObject)this.getOCLStandardLibrary().getBag(), 1);
    }

    public void test_SetType_checkCollectionTypeName() {
        SetType type = this.factory.createSetType();
        type.setElementType((Object)this.fruit);
        this.assertOK((EObject)type, 9);
        type.setName("Set(Integer)");
        this.assertProblem((EObject)type, 9);
        type.setName("Collection(Fruit)");
        this.assertProblem((EObject)type, 9);
        this.assertOK((EObject)this.getOCLStandardLibrary().getSet(), 9);
    }

    public void test_SequenceType_checkCollectionTypeName() {
        SequenceType type = this.factory.createSequenceType();
        type.setElementType((Object)this.fruit);
        this.assertOK((EObject)type, 8);
        type.setName("Sequence(Integer)");
        this.assertProblem((EObject)type, 8);
        type.setName("Collection(Fruit)");
        this.assertProblem((EObject)type, 8);
        this.assertOK((EObject)this.getOCLStandardLibrary().getSequence(), 8);
    }

    public void test_OrderedSetType_checkCollectionTypeName() {
        OrderedSetType type = this.factory.createOrderedSetType();
        type.setElementType((Object)this.fruit);
        this.assertOK((EObject)type, 7);
        type.setName("OrderedSet(Integer)");
        this.assertProblem((EObject)type, 7);
        type.setName("Collection(Fruit)");
        this.assertProblem((EObject)type, 7);
        this.assertOK((EObject)this.getOCLStandardLibrary().getOrderedSet(), 7);
    }

    public void test_emptyCollectionType_196972() {
        URI uri = this.getTestModelURI("/model/VoidCollectionTypes.ecore");
        Resource res = resourceSet.getResource(uri, true);
        EPackage epackage = (EPackage)res.getContents().get(0);
        CollectionType setType = (CollectionType)epackage.getEClassifier("Set(T)");
        TypesValidatorTest.assertSame((Object)this.getOCLStandardLibrary().getOclVoid(), (Object)setType.getElementType());
        this.assertProblem((EObject)setType, 9);
        CollectionType bagType = (CollectionType)epackage.getEClassifier("Bag(OclVoid)");
        TypesValidatorTest.assertSame((Object)this.getOCLStandardLibrary().getOclVoid(), (Object)bagType.getElementType());
        this.assertOK((EObject)setType, 1);
        CollectionType collectionType = this.factory.createCollectionType();
        collectionType.setElementType((Object)((EClassifier)this.getOCLStandardLibrary().getOclVoid()));
        this.assertOK((EObject)collectionType, 2);
        setType = this.factory.createSetType();
        setType.setElementType((Object)((EClassifier)this.getOCLStandardLibrary().getOclVoid()));
        this.assertOK((EObject)setType, 9);
        OrderedSetType orderedSetType = this.factory.createOrderedSetType();
        orderedSetType.setElementType((Object)((EClassifier)this.getOCLStandardLibrary().getOclVoid()));
        this.assertOK((EObject)orderedSetType, 7);
        bagType = this.factory.createBagType();
        bagType.setElementType((Object)((EClassifier)this.getOCLStandardLibrary().getOclVoid()));
        this.assertOK((EObject)bagType, 1);
        SequenceType sequenceType = this.factory.createSequenceType();
        sequenceType.setElementType((Object)((EClassifier)this.getOCLStandardLibrary().getOclVoid()));
        this.assertOK((EObject)sequenceType, 8);
    }

    public void test_wellFormedName() {
        this.assertWellFormedName((EObject)this.oclFactory.createCollectionType((Object)this.fruit));
        this.assertWellFormedName((EObject)this.oclFactory.createSetType((Object)this.fruit));
        this.assertWellFormedName((EObject)this.oclFactory.createOrderedSetType((Object)this.fruit));
        this.assertWellFormedName((EObject)this.oclFactory.createBagType((Object)this.fruit));
        this.assertWellFormedName((EObject)this.oclFactory.createSequenceType((Object)this.fruit));
        Variable v = this.oclFactory.createVariable();
        v.setName("a");
        v.setType((Object)this.fruit);
        this.assertWellFormedName((EObject)this.oclFactory.createTupleType(Collections.singletonList(v)));
        this.assertWellFormedName((EObject)this.oclFactory.createOperationMessageType((Object)this.fruit_ripen));
        this.assertWellFormedName((EObject)this.oclFactory.createTypeType((Object)this.fruit));
    }

    private void assertWellFormedName(EObject type) {
        this.assertOK(type, 44, "org.eclipse.emf.ecore.model");
    }

    public void test_wellFormedInstanceTypeName_241426() {
        this.assertWellFormedInstanceTypeName((EObject)this.oclFactory.createCollectionType((Object)this.fruit));
        this.assertWellFormedInstanceTypeName((EObject)this.oclFactory.createSetType((Object)this.fruit));
        this.assertWellFormedInstanceTypeName((EObject)this.oclFactory.createOrderedSetType((Object)this.fruit));
        this.assertWellFormedInstanceTypeName((EObject)this.oclFactory.createBagType((Object)this.fruit));
        this.assertWellFormedInstanceTypeName((EObject)this.oclFactory.createSequenceType((Object)this.fruit));
        Variable v = this.oclFactory.createVariable();
        v.setName("a");
        v.setType((Object)this.fruit);
        this.assertWellFormedInstanceTypeName((EObject)this.oclFactory.createTupleType(Collections.singletonList(v)));
        this.assertWellFormedInstanceTypeName((EObject)this.oclFactory.createOperationMessageType((Object)this.fruit_ripen));
        this.assertWellFormedInstanceTypeName((EObject)this.oclFactory.createTypeType((Object)this.fruit));
    }

    private void assertWellFormedInstanceTypeName(EObject type) {
        this.assertOK(type, 42, "org.eclipse.emf.ecore.model");
    }

    protected Diagnostic validate(EObject target) {
        HashMap<Class<Environment>, Environment> ctx = new HashMap<Class<Environment>, Environment>();
        ctx.put(Environment.class, this.ocl.getEnvironment());
        return Diagnostician.INSTANCE.validate(target, ctx);
    }

    protected void assertProblem(EObject target, int code) {
        this.assertProblem(this.validate(target), target, code);
    }

    protected void assertProblem(Diagnostic diagnostic, EObject target, int code) {
        Diagnostic problem = this.findProblem(diagnostic, target, code);
        TypesValidatorTest.assertNotNull((String)"Problem not found", (Object)problem);
        System.out.println("Found expected problem: " + problem.getMessage());
    }

    protected Diagnostic findProblem(Diagnostic diagnostic, EObject target, int code, String source) {
        if (source.equals(diagnostic.getSource()) && diagnostic.getSeverity() != 0 && diagnostic.getData().contains(target) && diagnostic.getCode() == code) {
            return diagnostic;
        }
        for (Diagnostic child : diagnostic.getChildren()) {
            Diagnostic result = this.findProblem(child, target, code, source);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    protected Diagnostic findProblem(Diagnostic diagnostic, EObject target, int code) {
        return this.findProblem(diagnostic, target, code, "org.eclipse.ocl.types");
    }

    protected Diagnostic findProblem(Diagnostic diagnostic, EObject target) {
        if ("org.eclipse.ocl.types".equals(diagnostic.getSource()) && diagnostic.getSeverity() != 0 && diagnostic.getData().contains(target)) {
            return diagnostic;
        }
        for (Diagnostic child : diagnostic.getChildren()) {
            Diagnostic result = this.findProblem(child, target);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    protected void assertOK(EObject target, int code) {
        this.assertOK(this.validate(target), target, code);
    }

    protected void assertOK(EObject target, int code, String source) {
        this.assertOK(this.validate(target), target, code, source);
    }

    protected void assertOK(Diagnostic diagnostic, EObject target, int code) {
        TypesValidatorTest.assertNull((String)"Problem found", (Object)this.findProblem(diagnostic, target, code));
    }

    protected void assertOK(Diagnostic diagnostic, EObject target, int code, String source) {
        TypesValidatorTest.assertNull((String)"Problem found", (Object)this.findProblem(diagnostic, target, code, source));
    }

    protected void assertOK(EObject target) {
        this.assertOK(this.validate(target), target);
    }

    protected void assertOK(Diagnostic diagnostic, EObject target) {
        TypesValidatorTest.assertNull((String)"Problem found", (Object)this.findProblem(diagnostic, target));
    }
}

