/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.emf.validation.validity.manager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.emf.validation.validity.AbstractNode;
import org.eclipse.ocl.examples.emf.validation.validity.ConstrainingNode;
import org.eclipse.ocl.examples.emf.validation.validity.Result;
import org.eclipse.ocl.examples.emf.validation.validity.ResultConstrainingNode;
import org.eclipse.ocl.examples.emf.validation.validity.ResultSet;
import org.eclipse.ocl.examples.emf.validation.validity.ResultValidatableNode;
import org.eclipse.ocl.examples.emf.validation.validity.RootNode;
import org.eclipse.ocl.examples.emf.validation.validity.Severity;
import org.eclipse.ocl.examples.emf.validation.validity.ValidatableNode;
import org.eclipse.ocl.examples.emf.validation.validity.locator.ConstraintLocator;
import org.eclipse.ocl.examples.emf.validation.validity.manager.ConstrainingURI;
import org.eclipse.ocl.examples.emf.validation.validity.manager.TypeURI;
import org.eclipse.ocl.examples.emf.validation.validity.manager.ValidatableURI;
import org.eclipse.ocl.examples.emf.validation.validity.manager.ValidityModel;
import org.eclipse.ocl.examples.emf.validation.validity.utilities.IVisibilityFilter;
import org.eclipse.ocl.pivot.labels.ILabelGenerator;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.LabelUtil;
import org.eclipse.ocl.pivot.utilities.TracingOption;

public class ValidityManager {
    private static final @NonNull Map<@Nullable String, @NonNull List<@NonNull ConstraintLocator.Descriptor>> constraintLocatorDescriptors = new HashMap<String, List<ConstraintLocator.Descriptor>>();
    private static final @NonNull Map<@NonNull String, @NonNull List<@NonNull ConstraintLocator>> constraintLocators = new HashMap<String, List<ConstraintLocator>>();
    public static final @NonNull TracingOption ANALYZE_RESOURCE = new TracingOption("org.eclipse.ocl.examples.emf.validation.validity", "analyze/resource");
    public static final @NonNull TracingOption BUILD_TYPE = new TracingOption("org.eclipse.ocl.examples.emf.validation.validity", "build/type");
    public static final @NonNull TracingOption CREATE_CONSTRAINING = new TracingOption("org.eclipse.ocl.examples.emf.validation.validity", "create/constraining");
    public static final @NonNull TracingOption CREATE_RESULT = new TracingOption("org.eclipse.ocl.examples.emf.validation.validity", "create/result");
    public static final @NonNull TracingOption CREATE_VALIDATABLE = new TracingOption("org.eclipse.ocl.examples.emf.validation.validity", "create/validatable");
    public static final @NonNull TracingOption LOCATE_RESOURCE = new TracingOption("org.eclipse.ocl.examples.emf.validation.validity", "locate/resource");
    public static final @NonNull Map<// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull ILabelGenerator.Option<?>, @Nullable Object> LABEL_OPTIONS = new HashMap();
    private final @NonNull LinkedHashSet<@NonNull Resource> newResources = new LinkedHashSet();
    private final @NonNull Set<@NonNull Resource> oldResources = new HashSet<Resource>();
    protected final @NonNull ComposedAdapterFactory adapterFactory;
    protected final @NonNull Map<@NonNull ResultValidatableNode, @NonNull Result> resultsMap = new HashMap<ResultValidatableNode, Result>();
    protected final @NonNull Map<Object, Object> context = Diagnostician.INSTANCE.createDefaultContext();
    private @Nullable ValidityModel model = null;
    protected @Nullable ResultSet lastResultSet = null;
    private boolean forceRefresh = false;
    private @Nullable Object lastInput = null;

    static {
        LABEL_OPTIONS.put(ILabelGenerator.Builder.SHOW_QUALIFIER, null);
    }

    public static synchronized void addConstraintLocator(String nsURI, @NonNull ConstraintLocator.Descriptor constraintLocator) {
        List<@NonNull ConstraintLocator.Descriptor> list = constraintLocatorDescriptors.get(nsURI);
        if (list == null) {
            list = new ArrayList<ConstraintLocator.Descriptor>();
            constraintLocatorDescriptors.put(nsURI, list);
        }
        if (!list.contains(constraintLocator)) {
            list.add(constraintLocator);
            constraintLocators.remove(nsURI);
        }
    }

    public static synchronized @Nullable ConstraintLocator getConstraintLocator(@NonNull EObject validatableObject) {
        return ValidityManager.getConstraintLocator(validatableObject.eResource());
    }

    public static synchronized @Nullable ConstraintLocator getConstraintLocator(@Nullable Resource validatableResource) {
        if (validatableResource != null) {
            for (EObject validatableObject : ClassUtil.nullFree((EList)validatableResource.getContents())) {
                List<ConstraintLocator> list;
                String nsURI;
                EPackage ePackage;
                EClass eClass = validatableObject.eClass();
                if (eClass == null || (ePackage = eClass.getEPackage()) == null || (nsURI = ePackage.getNsURI()) == null || (list = ValidityManager.getConstraintLocators(nsURI)) == null || list.size() <= 0) continue;
                return list.get(0);
            }
        }
        return null;
    }

    public static synchronized @NonNull List<@NonNull ConstraintLocator> getConstraintLocators(@NonNull String nsURI) {
        List<@NonNull ConstraintLocator> list = constraintLocators.get(nsURI);
        if (list == null) {
            list = new ArrayList<ConstraintLocator>();
            constraintLocators.put(nsURI, list);
            List<@NonNull ConstraintLocator.Descriptor> descriptors = constraintLocatorDescriptors.get(nsURI);
            if (descriptors == null) {
                descriptors = constraintLocatorDescriptors.get(null);
            }
            if (descriptors != null) {
                for (ConstraintLocator.Descriptor descriptor : descriptors) {
                    ConstraintLocator constraintLocator = descriptor.getConstraintLocator();
                    ConstraintLocator constraintLocatorInstance = constraintLocator.getInstance();
                    if (list.contains(constraintLocatorInstance)) continue;
                    list.add(constraintLocatorInstance);
                }
            }
        }
        return list;
    }

    public ValidityManager() {
        this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new EcoreItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
    }

    public void addConstrainingFilter(@NonNull IVisibilityFilter filter) {
        ValidityModel model2 = this.model;
        if (model2 != null) {
            model2.addConstrainingFilter(filter);
        }
    }

    public void addFilteredSeverity(@NonNull Severity severity) {
        ValidityModel model2 = this.model;
        if (model2 != null) {
            model2.addFilteredSeverity(severity);
        }
    }

    public void addValidatableFilter(@NonNull IVisibilityFilter filter) {
        ValidityModel model2 = this.model;
        if (model2 != null) {
            model2.addValidatableFilter(filter);
        }
    }

    protected void appendResourceURI(StringBuilder s, EObject eObject) {
        URI uri;
        Resource eResource;
        EObject eContainer = eObject.eContainer();
        if (eContainer == null && (eResource = eObject.eResource()) != null && (uri = eResource.getURI()) != null) {
            ResourceSet resourceSet = eResource.getResourceSet();
            if (resourceSet == null) {
                s.append(" in " + uri);
            } else {
                Resource firstResource = (Resource)resourceSet.getResources().get(0);
                URI firstURI = firstResource.getURI();
                URI resolvedURI = uri.deresolve(firstURI);
                if (resolvedURI.segmentCount() <= 0) {
                    s.append(" in " + uri.lastSegment());
                } else if (!resolvedURI.toString().equals(s.toString())) {
                    s.append(" in " + resolvedURI);
                }
            }
        }
    }

    public @NonNull Map<Object, Object> createDefaultContext() {
        return this.context;
    }

    public @NonNull BasicDiagnostic createDefaultDiagnostic(@NonNull EObject eObject) {
        return Diagnostician.INSTANCE.createDefaultDiagnostic(eObject);
    }

    protected @NonNull ValidityModel createModel(@NonNull Collection<@NonNull Resource> newResources) {
        return new ValidityModel(this, newResources);
    }

    public @Nullable ResultSet createResultSet(@Nullable IProgressMonitor monitor) {
        ValidityModel model2 = this.model;
        return model2 != null ? model2.createResultSet(monitor) : null;
    }

    public void dispose() {
        this.model = null;
        this.lastResultSet = null;
        this.resultsMap.clear();
    }

    protected @Nullable Set<@NonNull ConstraintLocator> gatherConstraintLocators(@Nullable Set<@NonNull ConstraintLocator> set, @NonNull List<@NonNull ConstraintLocator> list) {
        if (set == null) {
            set = new HashSet<ConstraintLocator>();
        }
        set.addAll(list);
        return set;
    }

    public @NonNull Iterable<@NonNull ConstraintLocator> getActiveConstraintLocators(@NonNull String nsURI) {
        return ValidityManager.getConstraintLocators(nsURI);
    }

    public @NonNull AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public @NonNull ConstrainingNode getConstrainingNode(@NonNull EObject eObject) {
        ValidityModel model2 = this.model;
        if (model2 == null) {
            throw new IllegalStateException();
        }
        return model2.getConstrainingNode(eObject);
    }

    public @NonNull List<@NonNull Result> getConstrainingNodeResults(@NonNull ConstrainingNode element) {
        ArrayList<@NonNull Result> results = new ArrayList<Result>();
        if (element.getLabel().startsWith("EOperation")) {
            this.getAllConstrainingNodeResults(results, element);
        } else {
            this.getAllConstrainingNodeResults(results, element);
        }
        return results;
    }

    public @NonNull ConstrainingURI getConstrainingURI(@NonNull EObject eObject) {
        Object uri;
        ConstraintLocator constraintLocator = ValidityManager.getConstraintLocator(eObject);
        if (constraintLocator != null && (uri = constraintLocator.getConstrainingURI(eObject)) != null) {
            return uri;
        }
        uri = EcoreUtil.getURI((EObject)eObject);
        return new ConstrainingURI((URI)uri);
    }

    private void getAllConstrainingNodeResults(@NonNull List<@NonNull Result> results, @NonNull ConstrainingNode element) {
        if (element instanceof ResultConstrainingNode) {
            ResultValidatableNode resultValidatableNode = ((ResultConstrainingNode)element).getResultValidatableNode();
            Result result = this.resultsMap.get(resultValidatableNode);
            if (result != null) {
                results.add(result);
            }
        } else {
            for (ConstrainingNode child : ClassUtil.nullFree(element.getChildren())) {
                this.getAllConstrainingNodeResults(results, child);
            }
        }
    }

    private void getAllValidatableNodeResults(@NonNull List<@NonNull Result> results, @NonNull ValidatableNode element) {
        if (element instanceof ResultValidatableNode) {
            ResultValidatableNode resultValidatableNode = (ResultValidatableNode)element;
            Result result = this.resultsMap.get(resultValidatableNode);
            if (result != null) {
                results.add(result);
            }
        } else {
            for (ValidatableNode child : ClassUtil.nullFree(element.getChildren())) {
                this.getAllValidatableNodeResults(results, child);
            }
        }
    }

    public @NonNull String getConstrainingLabel(@NonNull EObject eObject) {
        StringBuilder s = new StringBuilder();
        s.append(ILabelGenerator.Registry.INSTANCE.labelFor((Object)eObject, LABEL_OPTIONS));
        this.appendResourceURI(s, eObject);
        return s.toString();
    }

    public @Nullable ValidityModel getModel() {
        return this.model;
    }

    public @Nullable RootNode getRootNode() {
        ValidityModel model2 = this.model;
        return model2 != null ? model2.getRootNode() : null;
    }

    public @NonNull TypeURI getTypeURI(@NonNull EObject constrainingObject) {
        List<ConstraintLocator> constraintLocators;
        EPackage ePackage;
        String nsURI;
        EObject eContainer = constrainingObject;
        while (eContainer != null) {
            Resource eResource;
            EPackage constrainingEPackage;
            if (eContainer instanceof EPackage && (nsURI = (constrainingEPackage = (EPackage)eContainer).getNsURI()) != null && !"".equals(nsURI) && (eResource = constrainingEPackage.eResource()) != null) {
                String fragment = eResource.getURIFragment(constrainingObject);
                URI uri = URI.createURI((String)nsURI).appendFragment(fragment);
                return new TypeURI(uri);
            }
            eContainer = eContainer.eContainer();
        }
        EClass eClass = constrainingObject.eClass();
        if (eClass != null && (ePackage = eClass.getEPackage()) != null && (nsURI = ePackage.getNsURI()) != null && (constraintLocators = ValidityManager.getConstraintLocators(nsURI)) != null) {
            for (ConstraintLocator constraintLocator : constraintLocators) {
                TypeURI uri = constraintLocator.getTypeURI(constrainingObject);
                if (uri == null) continue;
                return uri;
            }
        }
        @NonNull URI uri = EcoreUtil.getURI((EObject)constrainingObject);
        return new TypeURI(uri);
    }

    public @NonNull String getValidatableLabel(@NonNull EObject eObject, boolean withContext) {
        StringBuilder s = new StringBuilder();
        s.append(LabelUtil.SIMPLE_NAME_REGISTRY.labelFor((Object)eObject, LABEL_OPTIONS));
        if (withContext) {
            this.appendResourceURI(s, eObject);
        }
        return s.toString();
    }

    public @NonNull List<@NonNull Result> getValidatableNodeResults(@NonNull ValidatableNode element) {
        ArrayList<@NonNull Result> results = new ArrayList<Result>();
        this.getAllValidatableNodeResults(results, element);
        return results;
    }

    public @NonNull ValidatableURI getValidatableURI(@NonNull EObject eObject) {
        @NonNull URI uri = EcoreUtil.getURI((EObject)eObject);
        return new ValidatableURI(uri);
    }

    public void forceRefresh() {
        this.forceRefresh = true;
        this.setInput(this.lastInput, (Monitor)new BasicMonitor());
        this.forceRefresh = false;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @Nullable List<@NonNull Result> installResultSet(@NonNull ResultSet resultSet, @NonNull IProgressMonitor monitor) {
        this.lastResultSet = resultSet;
        this.resultsMap.clear();
        RootNode rootNode = this.getRootNode();
        if (rootNode == null) {
            return null;
        }
        this.resetResults((List<? extends AbstractNode>)ClassUtil.nullFree(rootNode.getValidatableNodes()));
        this.resetResults((List<? extends AbstractNode>)ClassUtil.nullFree(rootNode.getConstrainingNodes()));
        @NonNull EList results = ClassUtil.nullFree(resultSet.getResults());
        for (Result result : results) {
            ResultValidatableNode resultValidatableNode = result.getResultValidatableNode();
            assert (resultValidatableNode != null);
            this.resultsMap.put(resultValidatableNode, result);
            if (!monitor.isCanceled()) continue;
            return null;
        }
        return results;
    }

    public void removeConstrainingFilter(@NonNull IVisibilityFilter filter) {
        ValidityModel model2 = this.model;
        if (model2 != null) {
            model2.removeConstrainingFilter(filter);
        }
    }

    public void removeFilteredSeverity(@NonNull Severity severity) {
        ValidityModel model2 = this.model;
        if (model2 != null) {
            model2.removeFilteredSeverity(severity);
        }
    }

    public void removeValidatableFilter(@NonNull IVisibilityFilter filter) {
        ValidityModel model2 = this.model;
        if (model2 != null) {
            model2.removeValidatableFilter(filter);
        }
    }

    private void resetResults(@NonNull List<@NonNull ? extends AbstractNode> nodes) {
        for (AbstractNode abstractNode : nodes) {
            this.resetResults((List<? extends AbstractNode>)ClassUtil.nullFree(abstractNode.getChildren()));
            abstractNode.setWorstResult(null);
        }
    }

    public void setInput(Object newInput) {
        this.setInput(newInput, (Monitor)new BasicMonitor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Issues handling annotations - annotations may be inaccurate
     */
    public void setInput(Object newInput, @NonNull Monitor monitor) {
        ResourceSet eContents;
        monitor.beginTask("Selective Validation", 1100);
        monitor.setTaskName("Clean Up");
        ResourceSet selectedResourceSet = null;
        Resource selectedResource = null;
        EObject selectedObject = null;
        this.newResources.clear();
        this.lastInput = newInput;
        if (newInput == null) {
            this.oldResources.clear();
            this.model = null;
            return;
        }
        if (newInput instanceof ResourceSet) {
            selectedResourceSet = (ResourceSet)newInput;
        } else if (newInput instanceof Resource) {
            selectedResource = (Resource)newInput;
            selectedResourceSet = selectedResource.getResourceSet();
            if (selectedResourceSet == null) {
                eContents = ClassUtil.nullFree((EList)selectedResource.getContents());
                int j = 0;
                while (j < eContents.size()) {
                    EObject eObject = (EObject)ClassUtil.nonNull((Object)((EObject)eContents.get(j)));
                    EcoreUtil.resolveAll((EObject)eObject);
                    ++j;
                }
                this.newResources.add(selectedResource);
            }
        } else if (newInput instanceof EObject && (selectedResource = (selectedObject = (EObject)newInput).eResource()) != null) {
            selectedResourceSet = selectedResource.getResourceSet();
        }
        if (selectedResourceSet != null) {
            eContents = selectedResourceSet;
            synchronized (eContents) {
                @NonNull EList selectedResources = ClassUtil.nullFree((EList)selectedResourceSet.getResources());
                int i = 0;
                while (i < selectedResources.size()) {
                    Resource eResource = (Resource)ClassUtil.nonNull((Object)((Resource)selectedResources.get(i)));
                    EList eContents2 = eResource.getContents();
                    int j = 0;
                    while (j < eContents2.size()) {
                        EObject eObject = (EObject)eContents2.get(j);
                        EcoreUtil.resolveAll((EObject)eObject);
                        ++j;
                    }
                    ++i;
                }
                this.newResources.addAll((Collection<Resource>)ClassUtil.nullFree((EList)selectedResourceSet.getResources()));
            }
        }
        if (this.newResources.isEmpty()) {
            return;
        }
        if (!this.forceRefresh && !this.oldResources.isEmpty() && this.oldResources.equals(this.newResources)) {
            return;
        }
        monitor.worked(50);
        monitor.setTaskName("Creating model");
        ValidityModel model2 = this.model = this.createModel(this.newResources);
        monitor.worked(50);
        model2.init(monitor);
        this.oldResources.clear();
        if (!monitor.isCanceled()) {
            this.oldResources.addAll(this.newResources);
        }
    }
}

