/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.tests;

import codegen.company.CodegencompanyFactory;
import codegen.company.CodegencompanyPackage;
import codegen.company.util.CodegencompanyValidator;
import company.Bug418716;
import company.CompanyFactory;
import company.CompanyPackage;
import company.util.CompanyValidator;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import noreflectioncompany.NoreflectioncompanyFactory;
import noreflectioncompany.NoreflectioncompanyPackage;
import noreflectioncompany.util.NoreflectioncompanyValidator;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.ecore.util.QueryDelegate;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.examples.extlibrary.EXTLibraryFactory;
import org.eclipse.emf.examples.extlibrary.EXTLibraryPackage;
import org.eclipse.emf.examples.extlibrary.Library;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.common.internal.options.CommonOptions;
import org.eclipse.ocl.examples.pivot.tests.PivotTestCaseWithAutoTearDown;
import org.eclipse.ocl.examples.xtext.tests.TestCaseAppender;
import org.eclipse.ocl.examples.xtext.tests.TestUtil;
import org.eclipse.ocl.examples.xtext.tests.XtextVersionUtil;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.PivotTables;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.evaluation.EvaluationException;
import org.eclipse.ocl.pivot.internal.delegate.DelegateDomain;
import org.eclipse.ocl.pivot.internal.delegate.DelegateEPackageAdapter;
import org.eclipse.ocl.pivot.internal.delegate.DelegateInstaller;
import org.eclipse.ocl.pivot.internal.delegate.InvocationBehavior;
import org.eclipse.ocl.pivot.internal.delegate.OCLDelegateDomain;
import org.eclipse.ocl.pivot.internal.delegate.OCLDelegateException;
import org.eclipse.ocl.pivot.internal.delegate.OCLInvocationDelegate;
import org.eclipse.ocl.pivot.internal.delegate.OCLInvocationDelegateFactory;
import org.eclipse.ocl.pivot.internal.delegate.OCLQueryDelegateFactory;
import org.eclipse.ocl.pivot.internal.delegate.OCLSettingDelegate;
import org.eclipse.ocl.pivot.internal.delegate.OCLSettingDelegateFactory;
import org.eclipse.ocl.pivot.internal.delegate.OCLValidationDelegateFactory;
import org.eclipse.ocl.pivot.internal.delegate.ValidationDelegate;
import org.eclipse.ocl.pivot.internal.ecore.es2as.Ecore2AS;
import org.eclipse.ocl.pivot.internal.manager.MetamodelManagerInternal;
import org.eclipse.ocl.pivot.internal.messages.PivotMessagesInternal;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.GlobalEnvironmentFactory;
import org.eclipse.ocl.pivot.internal.utilities.OCLInternal;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.messages.PivotMessages;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.resource.CSResource;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.LabelUtil;
import org.eclipse.ocl.pivot.utilities.MetamodelManager;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.SemanticException;
import org.eclipse.ocl.pivot.utilities.StringUtil;
import org.eclipse.ocl.xtext.oclinecore.validation.OCLinEcoreEObjectValidator;
import org.junit.AfterClass;

public class DelegatesTest
extends PivotTestCaseWithAutoTearDown {
    protected static final @NonNull String COMPANY_XMI = "/model/Company.xmi";
    protected static final @NonNull String NO_REFLECTION_COMPANY_XMI = "/model/NoReflectionCompany.xmi";
    protected static final @NonNull String MODEL_WITH_ERRORS_XMI = "/model/ModelWithErrors.xmi";
    protected static final @NonNull String MODEL_WITH_ERRORS_OCL = "/model/ModelWithErrors.ocl";
    public Resource testResource;
    public EPackage companyPackage;
    public EFactory companyFactory;
    public EClass companyClass;
    public EAttribute companyName;
    public EReference companyEmployees;
    public EAttribute companySize;
    public EClass employeeClass;
    public EAttribute employeeName;
    public EReference employeeManager;
    public EReference employeeDirectReports;
    public EReference employeeAllReports;
    public EOperation employeeReportsTo;
    public EEnum sizeKind;
    public Enumerator sizeSmall;
    public Enumerator sizeMedium;
    public Enumerator sizeLarge;
    public EObject acme;
    public Map<String, EObject> employees;
    public EClass badClassClass;
    public EReference companyDetritus;
    public boolean usedLocalRegistry;

    protected @NonNull OCLInternal configureMetamodelManagerForDelegate(@NonNull EPackage ePackage) {
        DelegateEPackageAdapter adapter = DelegateEPackageAdapter.getAdapter((EPackage)ePackage);
        DelegateDomain delegateDomain = adapter.getDelegateDomain("http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot");
        if (delegateDomain == null) {
            delegateDomain = adapter.loadDelegateDomain("http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot");
        }
        EnvironmentFactory environmentFactory = ((OCLDelegateDomain)delegateDomain).getOCL().getEnvironmentFactory();
        return OCLInternal.newInstance((EnvironmentFactoryInternal)((EnvironmentFactoryInternal)environmentFactory));
    }

    protected @NonNull ResourceSet createResourceSet() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Map extensionToFactoryMap = resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap();
        extensionToFactoryMap.put("xmi", new EcoreResourceFactoryImpl());
        extensionToFactoryMap.put("ecore", new EcoreResourceFactoryImpl());
        OCLDelegateDomain.lazyInitializeLocals((ResourceSet)resourceSet, (String)"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot", (boolean)true, (OCLDelegateDomain.FactoryFactory)new OCLDelegateDomain.FactoryFactory(){

            public @NonNull OCLInvocationDelegateFactory createInvocationDelegateFactory(@NonNull String oclDelegateURI) {
                return new OCLInvocationDelegateFactory(oclDelegateURI){

                    public EOperation.Internal.InvocationDelegate createInvocationDelegate(EOperation operation) {
                        (this).DelegatesTest.this.usedLocalRegistry = true;
                        return super.createInvocationDelegate(operation);
                    }
                };
            }

            public @NonNull OCLQueryDelegateFactory createQueryDelegateFactory(@NonNull String oclDelegateURI) {
                return new OCLQueryDelegateFactory(oclDelegateURI){

                    public QueryDelegate createQueryDelegate(EClassifier context, Map<String, EClassifier> parameters, String expression) {
                        (this).DelegatesTest.this.usedLocalRegistry = true;
                        return super.createQueryDelegate(context, parameters, expression);
                    }
                };
            }

            public @NonNull OCLSettingDelegateFactory createSettingDelegateFactory(@NonNull String oclDelegateURI) {
                return new OCLSettingDelegateFactory(oclDelegateURI){

                    public EStructuralFeature.Internal.SettingDelegate createSettingDelegate(EStructuralFeature structuralFeature) {
                        (this).DelegatesTest.this.usedLocalRegistry = true;
                        return super.createSettingDelegate(structuralFeature);
                    }
                };
            }

            public @NonNull OCLValidationDelegateFactory createValidationDelegateFactory(@NonNull String oclDelegateURI) {
                return new OCLValidationDelegateFactory(oclDelegateURI){

                    public ValidationDelegate createValidationDelegate(@NonNull EClassifier classifier) {
                        (this).DelegatesTest.this.usedLocalRegistry = true;
                        return super.createValidationDelegate(classifier);
                    }
                };
            }
        });
        return resourceSet;
    }

    protected void initModel(@NonNull ResourceSet resourceSet, @NonNull String testModelName) {
        URI uri = this.getTestModelURI(testModelName);
        this.testResource = resourceSet.getResource(uri, true);
        this.acme = (EObject)this.testResource.getContents().get(0);
        this.companyClass = this.acme.eClass();
        this.companyPackage = this.companyClass.getEPackage();
        this.companyFactory = this.companyPackage.getEFactoryInstance();
        this.companyName = (EAttribute)this.companyClass.getEStructuralFeature("name");
        this.companyEmployees = (EReference)this.companyClass.getEStructuralFeature("employees");
        this.companySize = (EAttribute)this.companyClass.getEStructuralFeature("size");
        this.employeeClass = this.companyEmployees.getEReferenceType();
        this.employeeName = (EAttribute)this.employeeClass.getEStructuralFeature("name");
        this.employeeManager = (EReference)this.employeeClass.getEStructuralFeature("manager");
        this.employeeDirectReports = (EReference)this.employeeClass.getEStructuralFeature("directReports");
        this.employeeAllReports = (EReference)this.employeeClass.getEStructuralFeature("allReports");
        this.employeeReportsTo = this.getOperation(this.employeeClass, "reportsTo");
        this.sizeKind = (EEnum)this.companySize.getEAttributeType();
        this.sizeSmall = this.sizeKind.getEEnumLiteral("small").getInstance();
        this.sizeMedium = this.sizeKind.getEEnumLiteral("medium").getInstance();
        this.sizeLarge = this.sizeKind.getEEnumLiteral("large").getInstance();
        this.employees = new HashMap<String, EObject>();
    }

    protected Resource initModelWithErrors(@NonNull ResourceSet resourceSet) {
        URI uri = this.getTestModelURI(MODEL_WITH_ERRORS_XMI);
        this.testResource = resourceSet.getResource(uri, true);
        this.acme = (EObject)this.testResource.getContents().get(0);
        this.companyClass = this.acme.eClass();
        this.companyPackage = this.companyClass.getEPackage();
        this.companyFactory = this.companyPackage.getEFactoryInstance();
        this.badClassClass = (EClass)this.companyPackage.getEClassifier("BadClass");
        this.companyDetritus = (EReference)this.companyClass.getEStructuralFeature("detritus");
        return this.companyPackage.eResource();
    }

    protected void initModelWithErrorsAndOcl(@NonNull ResourceSet resourceSet) {
        ASResource asResource;
        URI oclURI;
        CSResource xtextResource;
        Ecore2AS ecore2as;
        Model pivotModel;
        TestUtil.doCompleteOCLSetup();
        Resource ecoreResource = this.initModelWithErrors(resourceSet);
        OCLInternal ocl = this.configureMetamodelManagerForDelegate(this.companyPackage);
        MetamodelManagerInternal metamodelManager = ocl.getMetamodelManager();
        EnvironmentFactoryInternal environmentFactory = ocl.getEnvironmentFactory();
        environmentFactory.adapt((Notifier)resourceSet);
        String message = PivotUtil.formatResourceDiagnostics((List)ecoreResource.getErrors(), (String)"Model load", (String)"\n\t");
        if (message != null) {
            DelegatesTest.fail((String)message);
        }
        if ((message = PivotUtil.formatResourceDiagnostics((List)(pivotModel = (ecore2as = Ecore2AS.getAdapter((Resource)ecoreResource, (EnvironmentFactoryInternal)environmentFactory)).getASModel()).eResource().getErrors(), (String)"Pivot load", (String)"\n\t")) != null) {
            DelegatesTest.fail((String)message);
        }
        if ((message = PivotUtil.formatResourceDiagnostics((List)(xtextResource = (CSResource)resourceSet.getResource(oclURI = this.getTestModelURI(MODEL_WITH_ERRORS_OCL), true)).getErrors(), (String)"OCL load", (String)"\n\t")) != null) {
            DelegatesTest.fail((String)message);
        }
        if ((message = PivotUtil.formatResourceDiagnostics((List)(asResource = xtextResource.getASResource()).getErrors(), (String)"Pivot OCL load", (String)"\n\t")) != null) {
            DelegatesTest.fail((String)message);
        }
        DelegateInstaller pivotInstaller = new DelegateInstaller(environmentFactory, null);
        for (Package nestedPackage : pivotModel.getOwnedPackages()) {
            pivotInstaller.installDelegates(metamodelManager.getCompletePackage(nestedPackage));
        }
        ocl.dispose();
    }

    protected void initPackageRegistrations(@NonNull ResourceSet resourceSet) {
        EPackage.Registry packageRegistry = resourceSet.getPackageRegistry();
        packageRegistry.put((Object)"http://www.eclipse.org/ocl/test/Pivot/Company.ecore", (Object)CompanyPackage.eINSTANCE);
        packageRegistry.put((Object)"http://www.eclipse.org/ocl/test/2010/NoReflectionCompany.ecore", (Object)NoreflectioncompanyPackage.eINSTANCE);
        EValidator.Registry.INSTANCE.put((Object)CompanyPackage.eINSTANCE, (Object)CompanyValidator.INSTANCE);
        EValidator.Registry.INSTANCE.put((Object)NoreflectioncompanyPackage.eINSTANCE, (Object)NoreflectioncompanyValidator.INSTANCE);
    }

    protected void initCodeGeneratedPackageRegistrations(@NonNull ResourceSet resourceSet) {
        resourceSet.getPackageRegistry().put((Object)"http://www.eclipse.org/ocl/test/Pivot/Company.ecore", (Object)CodegencompanyPackage.eINSTANCE);
        EValidator.Registry.INSTANCE.put((Object)CodegencompanyPackage.eINSTANCE, (Object)CodegencompanyValidator.INSTANCE);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        TestCaseAppender.INSTANCE.install();
        TestUtil.doEssentialOCLSetup();
        this.usedLocalRegistry = false;
        EValidator.Registry.INSTANCE.put(null, (Object)new OCLinEcoreEObjectValidator());
        EPackage.Registry.INSTANCE.remove((Object)"http://www.eclipse.org/ocl/test/Pivot/Company.ecore");
        EPackage.Registry.INSTANCE.remove((Object)"http://www.eclipse.org/ocl/test/2010/NoReflectionCompany.ecore");
    }

    @Override
    protected void tearDown() throws Exception {
        DelegateEPackageAdapter adapter;
        if (this.testResource != null) {
            this.testResource.unload();
        }
        EValidator.Registry.INSTANCE.remove(null);
        if (EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/ocl/test/Pivot/Company.ecore") instanceof CompanyFactory && (adapter = DelegateEPackageAdapter.findAdapter((EPackage)CompanyPackage.eINSTANCE)) != null) {
            adapter.unloadDelegates();
        }
        if (EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/ocl/test/2010/NoReflectionCompany.ecore") instanceof NoreflectioncompanyFactory && (adapter = DelegateEPackageAdapter.findAdapter((EPackage)NoreflectioncompanyPackage.eINSTANCE)) != null) {
            adapter.unloadDelegates();
        }
        if (EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/ocl/test/Pivot/Company.ecore") instanceof CodegencompanyFactory && (adapter = DelegateEPackageAdapter.findAdapter((EPackage)CodegencompanyPackage.eINSTANCE)) != null) {
            adapter.unloadDelegates();
        }
        this.autoTearDown();
        super.tearDown();
    }

    @AfterClass
    protected void tearDownClass() throws Exception {
        GlobalEnvironmentFactory.disposeInstance();
    }

    public void doTest_allInstances(@NonNull ResourceSet resourceSet, @NonNull String modelName) {
        this.initModel(resourceSet, modelName);
        Collection<EObject> amyAllReports = this.allReports(this.employee("Amy"));
        DelegatesTest.assertEquals((int)5, (int)amyAllReports.size());
        DelegatesTest.assertTrue((boolean)amyAllReports.contains(this.employee("Bob")));
        DelegatesTest.assertTrue((boolean)amyAllReports.contains(this.employee("Jane")));
        DelegatesTest.assertTrue((boolean)amyAllReports.contains(this.employee("Fred")));
        DelegatesTest.assertTrue((boolean)amyAllReports.contains(this.employee("Norbert")));
        DelegatesTest.assertTrue((boolean)amyAllReports.contains(this.employee("Sally")));
        this.set(this.create(this.acme, this.companyEmployees, this.employeeClass, "Manuel"), (EStructuralFeature)this.employeeManager, this.employee("Bob"));
        amyAllReports = this.allReports(this.employee("Amy"));
        DelegatesTest.assertEquals((int)6, (int)amyAllReports.size());
        DelegatesTest.assertTrue((boolean)amyAllReports.contains(this.employee("Manuel")));
    }

    public void test_changeableNonVolatileAttribute_418716() {
        Bug418716 m = CompanyFactory.eINSTANCE.createBug418716();
        DelegatesTest.assertEquals((int)0, (int)m.getAttributeWithoutInitital());
        DelegatesTest.assertEquals((int)100, (int)m.getAttributeWithInitital());
        m.setAttributeWithInitital(200);
        DelegatesTest.assertEquals((int)0, (int)m.getAttributeWithoutInitital());
        DelegatesTest.assertEquals((int)200, (int)m.getAttributeWithInitital());
    }

    public void doTest_constraintValidation(@NonNull ResourceSet resourceSet, @NonNull String modelName) {
        this.initModel(resourceSet, modelName);
        EObject employee = this.create(this.acme, this.companyEmployees, this.employeeClass, null);
        this.set(employee, (EStructuralFeature)this.employeeManager, this.employee("Bob"));
        this.validateConstraintWithSeverity("mustHaveName", 2, employee, "Employee must have a name");
        this.set(employee, (EStructuralFeature)this.employeeName, "Joe");
        this.validateWithoutError(employee);
        this.validateWithoutError(this.acme);
    }

    public void doTest_crossReferences(@NonNull ResourceSet resourceSet, @NonNull String modelName) {
        this.initModel(resourceSet, modelName);
        EcoreUtil.CrossReferencer.find((Collection)this.testResource.getContents());
    }

    public void doTest_eAttributeDerivation(@NonNull ResourceSet resourceSet, @NonNull String modelName) {
        this.initModel(resourceSet, modelName);
        DelegatesTest.assertSame((Object)this.sizeSmall, (Object)this.size(this.acme));
        EList<EObject> emps = this.employees(this.acme);
        int i = 0;
        while (i < 60) {
            emps.add((Object)this.companyFactory.create(this.employeeClass));
            ++i;
        }
        DelegatesTest.assertSame((Object)this.sizeMedium, (Object)this.size(this.acme));
        i = 0;
        while (i < 1000) {
            emps.add((Object)this.companyFactory.create(this.employeeClass));
            ++i;
        }
        DelegatesTest.assertSame((Object)this.sizeLarge, (Object)this.size(this.acme));
    }

    public void doTest_eReferenceDerivation(@NonNull ResourceSet resourceSet, @NonNull String modelName) {
        this.initModel(resourceSet, modelName);
        EList<EObject> amyReports = this.directReports(this.employee("Amy"));
        DelegatesTest.assertEquals((int)3, (int)amyReports.size());
        DelegatesTest.assertTrue((boolean)amyReports.contains((Object)this.employee("Bob")));
        DelegatesTest.assertTrue((boolean)amyReports.contains((Object)this.employee("Jane")));
        DelegatesTest.assertTrue((boolean)amyReports.contains((Object)this.employee("Fred")));
        EList<EObject> bobReports = this.directReports(this.employee("Bob"));
        DelegatesTest.assertEquals((int)2, (int)bobReports.size());
        DelegatesTest.assertTrue((boolean)bobReports.contains((Object)this.employee("Norbert")));
        DelegatesTest.assertTrue((boolean)bobReports.contains((Object)this.employee("Sally")));
        EList<EObject> sallyReports = this.directReports(this.employee("Sally"));
        DelegatesTest.assertEquals((int)0, (int)sallyReports.size());
    }

    public void doTest_invariantValidation(@NonNull ResourceSet resourceSet, @NonNull String modelName, boolean hasInvariants, int severity) {
        this.initModel(resourceSet, modelName);
        EObject joe = this.create(this.acme, this.companyEmployees, this.employeeClass, "Joe");
        if (hasInvariants) {
            this.validateInvariantWithSeverity("noManagerImpliesDirectReports", severity, joe);
        } else {
            this.validateConstraintWithSeverity("noManagerImpliesDirectReports", severity, joe, null);
        }
        this.set(this.employee("Amy"), (EStructuralFeature)this.employeeManager, joe);
        this.validateWithoutError(joe);
    }

    public void doTest_operationInvocation(@NonNull ResourceSet resourceSet, @NonNull String modelName) throws InvocationTargetException {
        this.initModel(resourceSet, modelName);
        EObject amy = this.employee("Amy");
        Collection<EObject> amyAllReports = this.allReports(amy);
        DelegatesTest.assertEquals((int)5, (int)amyAllReports.size());
        for (EObject next : amyAllReports) {
            DelegatesTest.assertTrue((boolean)((Boolean)this.invoke(next, this.employeeReportsTo, amy)));
        }
    }

    public void doTest_queryExecution(@NonNull ResourceSet resourceSet, @NonNull String modelName) {
        this.initModel(resourceSet, modelName);
        OCLInternal ocl = this.configureMetamodelManagerForDelegate(this.companyPackage);
        MetamodelManagerInternal metamodelManager = ocl.getMetamodelManager();
        QueryDelegate.Factory factory = QueryDelegate.Factory.Registry.INSTANCE.getFactory("http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot");
        String n = "n";
        String expression = "self.employees->select(employee | employee.manager <> null and employee.manager.name = n)";
        EObject amy = this.employee("Amy");
        HashMap<String, EDataType> parameters = new HashMap<String, EDataType>();
        parameters.put(n, EcorePackage.Literals.ESTRING);
        QueryDelegate delegate = factory.createQueryDelegate((EClassifier)this.companyClass, parameters, expression);
        this.executeWithException(delegate, amy, null, PivotMessagesInternal.WrongContextClassifier_ERROR_, this.getType((OCL)ocl, amy), this.getType((OCL)ocl, this.acme));
        this.executeWithException(delegate, this.acme, null, PivotMessagesInternal.MismatchedArgumentCount_ERROR_, 0, 1);
        HashMap<String, Object> badArguments = new HashMap<String, Object>();
        badArguments.put(n, amy);
        this.executeWithException(delegate, this.acme, badArguments, PivotMessagesInternal.MismatchedArgumentType_ERROR_, n, this.getType((OCL)ocl, amy), PivotUtilInternal.findTypeOf((MetamodelManagerInternal)metamodelManager, (EClassifier)EcorePackage.Literals.ESTRING));
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        arguments.put(n, "Amy");
        Collection amyReports = (Collection)this.execute(delegate, this.acme, arguments);
        DelegatesTest.assertEquals((int)3, (int)amyReports.size());
        DelegatesTest.assertTrue((boolean)amyReports.contains(this.employee("Bob")));
        DelegatesTest.assertTrue((boolean)amyReports.contains(this.employee("Jane")));
        DelegatesTest.assertTrue((boolean)amyReports.contains(this.employee("Fred")));
        this.executeWithException(delegate, this.employee("Bob"), null, PivotMessagesInternal.WrongContextClassifier_ERROR_, this.getType((OCL)ocl, amy), this.getType((OCL)ocl, this.acme));
        arguments = new HashMap();
        arguments.put(n, "Bob");
        Collection bobReports = (Collection)this.execute(delegate, this.acme, arguments);
        DelegatesTest.assertEquals((int)2, (int)bobReports.size());
        DelegatesTest.assertTrue((boolean)bobReports.contains(this.employee("Norbert")));
        DelegatesTest.assertTrue((boolean)bobReports.contains(this.employee("Sally")));
        this.executeWithException(delegate, this.employee("Sally"), null, PivotMessagesInternal.WrongContextClassifier_ERROR_, this.getType((OCL)ocl, amy), this.getType((OCL)ocl, this.acme));
        arguments = new HashMap();
        arguments.put(n, "Sally");
        Collection sallyReports = (Collection)this.execute(delegate, this.acme, arguments);
        DelegatesTest.assertEquals((int)0, (int)sallyReports.size());
        ocl.dispose();
    }

    public void doTest_queryExecutionWithExceptions(@NonNull ResourceSet resourceSet, @NonNull String modelName) throws InvocationTargetException {
        this.initModel(resourceSet, modelName);
        OCLInternal ocl = this.configureMetamodelManagerForDelegate(this.companyPackage);
        QueryDelegate.Factory factory = QueryDelegate.Factory.Registry.INSTANCE.getFactory("http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot");
        String okName = "ok";
        String badName = "xyzzy";
        EObject amy = this.employee("Amy");
        HashMap<String, Object> okBindings = new HashMap<String, Object>();
        okBindings.put(okName, 123);
        HashMap<String, EDataType> variables = new HashMap<String, EDataType>();
        variables.put(okName, EcorePackage.Literals.ESTRING);
        QueryDelegate delegate = factory.createQueryDelegate((EClassifier)this.companyClass, null, "n=");
        this.executeWithException2(delegate, amy, null, String.valueOf(this.getErrorsInMessage("company", "Company", "n=")) + StringUtil.bind((String)"1: no viable alternative following input ''{0}''", (Object[])new Object[]{"="}));
        delegate = factory.createQueryDelegate((EClassifier)this.companyClass, variables, badName);
        this.executeWithException2(delegate, this.acme, null, String.valueOf(this.getErrorsInMessage("company", "Company", badName)) + StringUtil.bind((String)("1: " + PivotMessagesInternal.UnresolvedProperty_ERROR_), (Object[])new Object[]{"", badName}));
        delegate = factory.createQueryDelegate((EClassifier)this.companyClass, variables, "self");
        HashMap<String, Object> bindings = new HashMap<String, Object>();
        bindings.put(okName, "xx");
        bindings.put(badName, 123);
        this.executeWithException(delegate, this.acme, bindings, PivotMessagesInternal.MismatchedArgumentCount_ERROR_, 2, 1);
        delegate = factory.createQueryDelegate((EClassifier)this.companyClass, variables, "self");
        delegate.prepare();
        this.executeWithException(delegate, amy, okBindings, PivotMessagesInternal.WrongContextClassifier_ERROR_, this.getType((OCL)ocl, amy), this.getType((OCL)ocl, this.acme));
        delegate = factory.createQueryDelegate((EClassifier)this.companyClass, variables, "self");
        delegate.prepare();
        this.executeWithException(delegate, this.acme, okBindings, PivotMessagesInternal.MismatchedArgumentType_ERROR_, okName, "Integer", "String");
        ocl.dispose();
    }

    public void test_allInstances() {
        GlobalEnvironmentFactory.disposeInstance();
        ResourceSet resourceSet = this.createResourceSet();
        this.doTest_allInstances(resourceSet, COMPANY_XMI);
        DelegatesTest.assertTrue((boolean)this.usedLocalRegistry);
    }

    public void test_allInstances_registered() {
        GlobalEnvironmentFactory.disposeInstance();
        ResourceSet resourceSet = this.createResourceSet();
        this.initPackageRegistrations(resourceSet);
        this.doTest_allInstances(resourceSet, COMPANY_XMI);
        DelegatesTest.assertFalse((boolean)this.usedLocalRegistry);
    }

    public void test_allInstances_codeGenerated() {
        ResourceSet resourceSet = this.createResourceSet();
        this.initCodeGeneratedPackageRegistrations(resourceSet);
        this.doTest_allInstances(resourceSet, COMPANY_XMI);
        DelegatesTest.assertFalse((boolean)this.usedLocalRegistry);
    }

    public void test_cossReferences_codeGenerated() {
        PivotTables.PACKAGE.getClass();
        ResourceSet resourceSet = this.createResourceSet();
        this.initCodeGeneratedPackageRegistrations(resourceSet);
        this.doTest_crossReferences(resourceSet, COMPANY_XMI);
    }

    public void test_attributeDefinedWithDerivationAndInitial() {
        ResourceSet resourceSet = this.createResourceSet();
        this.initModelWithErrors(resourceSet);
        EObject badClassInstance = this.create(this.acme, this.companyDetritus, this.badClassClass, null);
        Object actual = this.get(badClassInstance, (EStructuralFeature)((EAttribute)this.badClassClass.getEStructuralFeature("attributeDefinedWithDerivationAndInitial")));
        DelegatesTest.assertEquals((Object)42, actual);
    }

    public void test_attributeDefinedWithInitial() {
        ResourceSet resourceSet = this.createResourceSet();
        this.initModelWithErrors(resourceSet);
        EObject badClassInstance = this.create(this.acme, this.companyDetritus, this.badClassClass, null);
        Object actual = this.get(badClassInstance, (EStructuralFeature)((EAttribute)this.badClassClass.getEStructuralFeature("attributeDefinedWithInitial")));
        DelegatesTest.assertEquals((Object)-42, actual);
    }

    public void test_attributeDefinedWithoutDerivation() {
        ResourceSet resourceSet = this.createResourceSet();
        this.initModelWithErrors(resourceSet);
        OCL ocl = OCL.newInstance((ProjectManager)DelegatesTest.getProjectMap(), (ResourceSet)resourceSet);
        MetamodelManager metamodelManager = ocl.getMetamodelManager();
        EObject badClassInstance = this.create(this.acme, this.companyDetritus, this.badClassClass, null);
        EStructuralFeature eStructuralFeature = this.getStructuralFeature(this.badClassClass, "attributeDefinedWithoutDerivation");
        Property property = (Property)metamodelManager.getASOfEcore(Property.class, (EObject)eStructuralFeature);
        this.getWithException(badClassInstance, eStructuralFeature.getName(), StringUtil.bind((String)PivotMessagesInternal.MissingDerivationForSettingDelegate_ERROR_, (Object[])new Object[]{property}));
        ocl.dispose();
    }

    public void test_attributeDefinedWithoutDerivationBody() {
        ResourceSet resourceSet = this.createResourceSet();
        this.initModelWithErrors(resourceSet);
        OCL ocl = OCL.newInstance((ProjectManager)DelegatesTest.getProjectMap(), (ResourceSet)resourceSet);
        MetamodelManager metamodelManager = ocl.getMetamodelManager();
        EObject badClassInstance = this.create(this.acme, this.companyDetritus, this.badClassClass, null);
        EStructuralFeature eStructuralFeature = this.getStructuralFeature(this.badClassClass, "attributeDefinedWithoutDerivationBody");
        Property property = (Property)metamodelManager.getASOfEcore(Property.class, (EObject)eStructuralFeature);
        this.getWithException(badClassInstance, eStructuralFeature.getName(), StringUtil.bind((String)PivotMessagesInternal.MissingSpecificationBody_ERROR_, (Object[])new Object[]{property, "initializer"}));
        ocl.dispose();
    }

    public void test_attributeEvaluatingToInvalid() {
        ResourceSet resourceSet = this.createResourceSet();
        this.initModelWithErrors(resourceSet);
        OCL ocl = OCL.newInstance((ProjectManager)DelegatesTest.getProjectMap(), (ResourceSet)resourceSet);
        MetamodelManager metamodelManager = ocl.getMetamodelManager();
        EObject badClassInstance = this.create(this.acme, this.companyDetritus, this.badClassClass, null);
        EStructuralFeature eStructuralFeature = this.getStructuralFeature(this.badClassClass, "attributeEvaluatingToInvalid");
        Property property = (Property)metamodelManager.getASOfEcore(Property.class, (EObject)eStructuralFeature);
        this.getWithException(badClassInstance, eStructuralFeature.getName(), StringUtil.bind((String)PivotMessagesInternal.EvaluationResultIsInvalid_ERROR_, (Object[])new Object[]{property}));
        ocl.dispose();
    }

    public void test_attributeEvaluatingToNull() {
        ResourceSet resourceSet = this.createResourceSet();
        this.initModelWithErrors(resourceSet);
        EObject badClassInstance = this.create(this.acme, this.companyDetritus, this.badClassClass, null);
        EStructuralFeature eStructuralFeature = badClassInstance.eClass().getEStructuralFeature("attributeEvaluatingToNull");
        DelegatesTest.assertEquals(null, (String)((String)this.get(badClassInstance, eStructuralFeature)));
    }

    public void test_attributeEvaluatingToWrongType() {
        ResourceSet resourceSet = this.createResourceSet();
        this.initModelWithErrors(resourceSet);
        EObject testEObject = this.create(this.acme, this.companyDetritus, this.badClassClass, null);
        EStructuralFeature structuralFeature = this.getStructuralFeature(this.badClassClass, "attributeEvaluatingToWrongType");
        EStructuralFeature.Internal.SettingDelegate settingDelegate = ((EStructuralFeature.Internal)structuralFeature).getSettingDelegate();
        Property property = ((OCLSettingDelegate)settingDelegate).getProperty();
        String objectLabel = LabelUtil.getLabel((Object)property);
        this.getWithException(testEObject, "attributeEvaluatingToWrongType", StringUtil.bind((String)PivotMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"Property::CompatibleDefaultExpression", objectLabel}));
    }

    public void test_attributeParsingToLexicalError() {
        ResourceSet resourceSet = this.createResourceSet();
        this.initModelWithErrors(resourceSet);
        EObject badClassInstance = this.create(this.acme, this.companyDetritus, this.badClassClass, null);
        this.getWithException(badClassInstance, "attributeParsingToLexicalError", String.valueOf(this.getErrorsInMessage(badClassInstance.eClass().getName(), "attributeParsingToLexicalError", "gh##jk")) + StringUtil.bind((String)"1: no viable alternative at ''{0}''", (Object[])new Object[]{"#"}));
    }

    public void test_attributeParsingToSemanticError() {
        ResourceSet resourceSet = this.createResourceSet();
        this.initModelWithErrors(resourceSet);
        EObject badClassInstance = this.create(this.acme, this.companyDetritus, this.badClassClass, null);
        this.getWithException(badClassInstance, "attributeParsingToSemanticError", String.valueOf(this.getErrorsInMessage(badClassInstance.eClass().getName(), "attributeParsingToSemanticError", "'5' and 6")) + StringUtil.bind((String)("1: " + PivotMessagesInternal.UnresolvedOperationCall_ERROR_), (Object[])new Object[]{"String", "and", "Integer"}));
    }

    public void test_attributeParsingToSyntacticError() {
        ResourceSet resourceSet = this.createResourceSet();
        this.initModelWithErrors(resourceSet);
        EObject badClassInstance = this.create(this.acme, this.companyDetritus, this.badClassClass, null);
        String location = XtextVersionUtil.hasXtextSyntaxDiagnosticColumn() ? "1:9" : "1";
        this.getWithException(badClassInstance, "attributeParsingToSyntacticError", String.valueOf(this.getErrorsInMessage(badClassInstance.eClass().getName(), "attributeParsingToSyntacticError", "invalid null")) + StringUtil.bind((String)(String.valueOf(location) + ": extraneous input ''{0}'' expecting EOF"), (Object[])new Object[]{"null"}));
    }

    public void test_constraintValidation() {
        ResourceSet resourceSet = this.createResourceSet();
        this.doTest_constraintValidation(resourceSet, COMPANY_XMI);
        DelegatesTest.assertTrue((boolean)this.usedLocalRegistry);
    }

    public void test_constraintValidation_withoutReflection() {
        ResourceSet resourceSet = this.createResourceSet();
        this.doTest_constraintValidation(resourceSet, NO_REFLECTION_COMPANY_XMI);
    }

    public void test_constraintValidation_registered() {
        GlobalEnvironmentFactory.disposeInstance();
        ResourceSet resourceSet = this.createResourceSet();
        this.initPackageRegistrations(resourceSet);
        this.doTest_constraintValidation(resourceSet, COMPANY_XMI);
        DelegatesTest.assertFalse((boolean)this.usedLocalRegistry);
    }

    public void test_constraintValidation_codeGenerated() {
        ResourceSet resourceSet = this.createResourceSet();
        this.initCodeGeneratedPackageRegistrations(resourceSet);
        this.doTest_constraintValidation(resourceSet, COMPANY_XMI);
        DelegatesTest.assertFalse((boolean)this.usedLocalRegistry);
    }

    public void test_defaultIsLPG() {
        DelegatesTest.assertEquals((String)"http://www.eclipse.org/emf/2002/Ecore/OCL/LPG", (String)((String)CommonOptions.DEFAULT_DELEGATION_MODE.getPreferredValue()));
    }

    public void test_eAttributeDerivation() {
        GlobalEnvironmentFactory.disposeInstance();
        ResourceSet resourceSet = this.createResourceSet();
        this.doTest_eAttributeDerivation(resourceSet, COMPANY_XMI);
    }

    public void test_eReferenceDerivation() {
        GlobalEnvironmentFactory.disposeInstance();
        ResourceSet resourceSet = this.createResourceSet();
        this.doTest_eReferenceDerivation(resourceSet, COMPANY_XMI);
    }

    public void test_eReferenceDerivation_registered() {
        GlobalEnvironmentFactory.disposeInstance();
        ResourceSet resourceSet = this.createResourceSet();
        this.initPackageRegistrations(resourceSet);
        this.doTest_eReferenceDerivation(resourceSet, COMPANY_XMI);
    }

    public void test_eReferenceDerivation_codeGenerated() {
        ResourceSet resourceSet = this.createResourceSet();
        this.initCodeGeneratedPackageRegistrations(resourceSet);
        this.doTest_eReferenceDerivation(resourceSet, COMPANY_XMI);
    }

    public void test_invariantValidation() {
        GlobalEnvironmentFactory.disposeInstance();
        ResourceSet resourceSet = this.createResourceSet();
        this.doTest_invariantValidation(resourceSet, COMPANY_XMI, false, 2);
        DelegatesTest.assertTrue((boolean)this.usedLocalRegistry);
    }

    public void test_invariantValidation_registered() {
        GlobalEnvironmentFactory.disposeInstance();
        ResourceSet resourceSet = this.createResourceSet();
        this.initPackageRegistrations(resourceSet);
        this.doTest_invariantValidation(resourceSet, COMPANY_XMI, true, 4);
        DelegatesTest.assertFalse((boolean)this.usedLocalRegistry);
    }

    public void test_invariantValidation_codeGenerated() {
        ResourceSet resourceSet = this.createResourceSet();
        this.initCodeGeneratedPackageRegistrations(resourceSet);
        this.doTest_invariantValidation(resourceSet, COMPANY_XMI, false, 2);
        DelegatesTest.assertFalse((boolean)this.usedLocalRegistry);
    }

    public void test_invariantValidation_withoutReflection() {
        ResourceSet resourceSet = this.createResourceSet();
        this.doTest_invariantValidation(resourceSet, NO_REFLECTION_COMPANY_XMI, false, 2);
    }

    public void test_operationDefinedWithoutBody() throws InvocationTargetException {
        ResourceSet resourceSet = this.createResourceSet();
        this.initModelWithErrors(resourceSet);
        OCL ocl = OCL.newInstance((ProjectManager)DelegatesTest.getProjectMap(), (ResourceSet)resourceSet);
        MetamodelManager metamodelManager = ocl.getMetamodelManager();
        EObject badClassInstance = this.create(this.acme, this.companyDetritus, this.badClassClass, null);
        EOperation eOperation = this.getOperation(this.badClassClass, "operationDefinedWithoutBody");
        Operation operation = (Operation)metamodelManager.getASOfEcore(Operation.class, (EObject)eOperation);
        this.invokeWithException(badClassInstance, eOperation.getName(), StringUtil.bind((String)PivotMessagesInternal.MissingSpecificationBody_ERROR_, (Object[])new Object[]{NameUtil.qualifiedNameFor((Object)operation), "body"}));
        ocl.dispose();
    }

    public void test_operationDefinedWithoutBodyBody() throws InvocationTargetException {
        ResourceSet resourceSet = this.createResourceSet();
        this.initModelWithErrors(resourceSet);
        OCL ocl = OCL.newInstance((ProjectManager)DelegatesTest.getProjectMap(), (ResourceSet)resourceSet);
        MetamodelManager metamodelManager = ocl.getMetamodelManager();
        EObject badClassInstance = this.create(this.acme, this.companyDetritus, this.badClassClass, null);
        EOperation eOperation = this.getOperation(this.badClassClass, "operationDefinedWithoutBodyBody");
        Operation operation = (Operation)metamodelManager.getASOfEcore(Operation.class, (EObject)eOperation);
        this.invokeWithException(badClassInstance, eOperation.getName(), StringUtil.bind((String)PivotMessagesInternal.MissingSpecificationBody_ERROR_, (Object[])new Object[]{NameUtil.qualifiedNameFor((Object)operation), "body"}));
        ocl.dispose();
    }

    public void test_operationEvaluatingToInvalid() throws InvocationTargetException {
        ResourceSet resourceSet = this.createResourceSet();
        this.initModelWithErrors(resourceSet);
        OCL ocl = OCL.newInstance((ProjectManager)DelegatesTest.getProjectMap(), (ResourceSet)resourceSet);
        MetamodelManager metamodelManager = ocl.getMetamodelManager();
        EObject badClassInstance = this.create(this.acme, this.companyDetritus, this.badClassClass, null);
        EOperation eOperation = this.getOperation(this.badClassClass, "operationEvaluatingToInvalid");
        Operation operation = (Operation)metamodelManager.getASOfEcore(Operation.class, (EObject)eOperation);
        this.invokeWithException(badClassInstance, eOperation.getName(), StringUtil.bind((String)PivotMessagesInternal.EvaluationResultIsInvalid_ERROR_, (Object[])new Object[]{operation}));
        ocl.dispose();
    }

    public void test_operationEvaluatingToNull() throws InvocationTargetException {
        ResourceSet resourceSet = this.createResourceSet();
        this.initModelWithErrors(resourceSet);
        EObject badClassInstance = this.create(this.acme, this.companyDetritus, this.badClassClass, null);
        EOperation operation = this.getOperation(badClassInstance.eClass(), "operationEvaluatingToNull");
        DelegatesTest.assertEquals(null, (String)((String)this.invoke(badClassInstance, operation, new Object[0])));
    }

    public void test_operationEvaluatingToWrongType() throws InvocationTargetException {
        ResourceSet resourceSet = this.createResourceSet();
        this.initModelWithErrors(resourceSet);
        EObject badClassInstance = this.create(this.acme, this.companyDetritus, this.badClassClass, null);
        EOperation eOperation = this.getOperation(this.badClassClass, "operationEvaluatingToWrongType");
        EOperation.Internal.InvocationDelegate invocationDelegate = ((EOperation.Internal)eOperation).getInvocationDelegate();
        Operation operation = ((OCLInvocationDelegate)invocationDelegate).getOperation();
        String objectLabel = LabelUtil.getLabel((Object)operation);
        this.invokeWithException(badClassInstance, "operationEvaluatingToWrongType", StringUtil.bind((String)PivotMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"Operation::CompatibleReturn", objectLabel}));
    }

    public void test_operationInvocation() throws InvocationTargetException {
        GlobalEnvironmentFactory.disposeInstance();
        ResourceSet resourceSet = this.createResourceSet();
        this.doTest_operationInvocation(resourceSet, COMPANY_XMI);
        DelegatesTest.assertTrue((boolean)this.usedLocalRegistry);
    }

    public void test_operationParsingToLexicalError() throws InvocationTargetException {
        ResourceSet resourceSet = this.createResourceSet();
        this.initModelWithErrors(resourceSet);
        EObject badClassInstance = this.create(this.acme, this.companyDetritus, this.badClassClass, null);
        String location = XtextVersionUtil.hasXtextSyntaxDiagnosticColumn() ? "1:1" : "1";
        this.invokeWithException(badClassInstance, "operationParsingToLexicalError", String.valueOf(this.getErrorsInMessage(badClassInstance.eClass().getName(), "operationParsingToLexicalError", "@@")) + StringUtil.bind((String)(String.valueOf(location) + ": no viable alternative at input ''{0}''"), (Object[])new Object[]{"@"}));
    }

    public void test_operationParsingToSemanticError() throws InvocationTargetException {
        ResourceSet resourceSet = this.createResourceSet();
        this.initModelWithErrors(resourceSet);
        EObject badClassInstance = this.create(this.acme, this.companyDetritus, this.badClassClass, null);
        this.invokeWithException(badClassInstance, "operationParsingToSemanticError", String.valueOf(this.getErrorsInMessage(badClassInstance.eClass().getName(), "operationParsingToSemanticError", "self->at(1)")) + StringUtil.bind((String)("1: " + PivotMessagesInternal.UnresolvedOperationCall_ERROR_), (Object[])new Object[]{"Set(modelWithErrors::BadClass)", "at", "1"}));
    }

    public void test_operationParsingToSyntacticError() throws InvocationTargetException {
        ResourceSet resourceSet = this.createResourceSet();
        this.initModelWithErrors(resourceSet);
        EObject badClassInstance = this.create(this.acme, this.companyDetritus, this.badClassClass, null);
        String location = XtextVersionUtil.hasXtextSyntaxDiagnosticColumn() ? "1:5" : "1";
        this.invokeWithException(badClassInstance, "operationParsingToSyntacticError", String.valueOf(this.getErrorsInMessage(badClassInstance.eClass().getName(), "operationParsingToSyntacticError", "let in")) + StringUtil.bind((String)(String.valueOf(location) + ": no viable alternative at input ''{0}''"), (Object[])new Object[]{"in"}));
    }

    public void test_operationDefinedInStdlibBodyRemainsNull() throws ParserException {
        ResourceSet resourceSet = this.createResourceSet();
        OCL ocl = OCL.newInstance((ProjectManager)DelegatesTest.getProjectMap(), (ResourceSet)resourceSet);
        MetamodelManager metamodelManager = ocl.getMetamodelManager();
        ExpressionInOCL expr = ocl.createQuery(null, "'abc'.oclAsType(String)");
        OperationCallExp oce = (OperationCallExp)expr.getOwnedBody();
        Operation o = oce.getReferredOperation();
        try {
            ExpressionInOCL body = InvocationBehavior.INSTANCE.getQueryOrThrow(metamodelManager, o);
            DelegatesTest.fail((String)"Expected to catch OCLDelegateException");
        }
        catch (OCLDelegateException body) {
            // empty catch block
        }
        try {
            ExpressionInOCL bodyStillNull = InvocationBehavior.INSTANCE.getQueryOrThrow(metamodelManager, o);
            DelegatesTest.fail((String)"Expected to catch OCLDelegateException");
        }
        catch (OCLDelegateException oCLDelegateException) {
            // empty catch block
        }
        ocl.dispose();
    }

    public void test_queryExecution() {
        GlobalEnvironmentFactory.disposeInstance();
        ResourceSet resourceSet = this.createResourceSet();
        this.doTest_queryExecution(resourceSet, COMPANY_XMI);
        DelegatesTest.assertTrue((boolean)this.usedLocalRegistry);
    }

    public void test_queryExecution_registered() {
        GlobalEnvironmentFactory.disposeInstance();
        ResourceSet resourceSet = this.createResourceSet();
        this.initPackageRegistrations(resourceSet);
        this.doTest_queryExecution(resourceSet, COMPANY_XMI);
        DelegatesTest.assertFalse((boolean)this.usedLocalRegistry);
    }

    public void test_queryExecution_codeGenerated() {
        GlobalEnvironmentFactory.disposeInstance();
        ResourceSet resourceSet = this.createResourceSet();
        this.initCodeGeneratedPackageRegistrations(resourceSet);
        this.doTest_queryExecution(resourceSet, COMPANY_XMI);
        DelegatesTest.assertFalse((boolean)this.usedLocalRegistry);
    }

    public void test_queryExecutionWithExceptions() throws InvocationTargetException {
        ResourceSet resourceSet = this.createResourceSet();
        this.doTest_queryExecutionWithExceptions(resourceSet, COMPANY_XMI);
        DelegatesTest.assertTrue((boolean)this.usedLocalRegistry);
    }

    public void test_queryExecutionWithExceptions_registered() throws InvocationTargetException {
        ResourceSet resourceSet = this.createResourceSet();
        this.initPackageRegistrations(resourceSet);
        this.doTest_queryExecutionWithExceptions(resourceSet, COMPANY_XMI);
        DelegatesTest.assertFalse((boolean)this.usedLocalRegistry);
    }

    public void test_queryExecutionWithExceptions_codeGenerated() throws InvocationTargetException {
        ResourceSet resourceSet = this.createResourceSet();
        this.initCodeGeneratedPackageRegistrations(resourceSet);
        this.doTest_queryExecutionWithExceptions(resourceSet, COMPANY_XMI);
        DelegatesTest.assertFalse((boolean)this.usedLocalRegistry);
    }

    public void test_queryExecution_Bug353171() {
        QueryDelegate.Factory factory = QueryDelegate.Factory.Registry.INSTANCE.getFactory("http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot");
        String n = "n";
        String expression = "self.name";
        Library library = EXTLibraryFactory.eINSTANCE.createLibrary();
        library.setName("test");
        HashMap<String, EDataType> parameters = new HashMap<String, EDataType>();
        parameters.put(n, EcorePackage.Literals.ESTRING);
        QueryDelegate delegate = factory.createQueryDelegate((EClassifier)EXTLibraryPackage.Literals.LIBRARY, parameters, expression);
        HashMap<String, Object> bindings = new HashMap<String, Object>();
        bindings.put(n, "test");
        Object result = this.execute(delegate, library, bindings);
        DelegatesTest.assertEquals((Object)result, (Object)"test");
    }

    public void test_validationEvaluatingToInvalid() {
        ResourceSet resourceSet = this.createResourceSet();
        this.initModelWithErrors(resourceSet);
        EObject badClassInstance = this.create(this.acme, this.companyDetritus, (EClass)this.companyPackage.getEClassifier("ValidationEvaluatingToInvalid"), null);
        this.validateWithDelegationSeverity("evaluatingToInvalid", 4, badClassInstance, null, EvaluationException.class, PivotMessagesInternal.ValidationResultIsInvalid_ERROR_, "ValidationEvaluatingToInvalid", "evaluatingToInvalid", LabelUtil.getLabel((Object)badClassInstance), "invalid");
    }

    public void test_validationEvaluatingToNull() {
        ResourceSet resourceSet = this.createResourceSet();
        this.initModelWithErrors(resourceSet);
        EObject badClassInstance = this.create(this.acme, this.companyDetritus, (EClass)this.companyPackage.getEClassifier("ValidationEvaluatingToNull"), null);
        this.validateWithDelegationSeverity("evaluatingToNull", 4, badClassInstance, null, EvaluationException.class, PivotMessagesInternal.ValidationResultIsNull_ERROR_, badClassInstance.eClass().getName(), "evaluatingToNull", LabelUtil.getLabel((Object)badClassInstance));
    }

    public void test_validationEvaluatingToWrongType() {
        ResourceSet resourceSet = this.createResourceSet();
        this.initModelWithErrors(resourceSet);
        EObject badClassInstance = this.create(this.acme, this.companyDetritus, (EClass)this.companyPackage.getEClassifier("ValidationEvaluatingToWrongType"), null);
        this.validateWithDelegationSeverity("evaluatingToWrongType", 4, badClassInstance, null, EvaluationException.class, PivotMessagesInternal.ValidationConstraintIsNotBooleanType_ERROR_, "ValidationEvaluatingToWrongType", "evaluatingToWrongType", "OclInvalid");
    }

    public void test_validationParsingToLexicalError() {
        ResourceSet resourceSet = this.createResourceSet();
        this.initModelWithErrors(resourceSet);
        String location = XtextVersionUtil.hasXtextSyntaxDiagnosticColumn() ? "1:1" : "1";
        EObject badClassInstance = this.create(this.acme, this.companyDetritus, (EClass)this.companyPackage.getEClassifier("ValidationParsingToLexicalError"), null);
        this.validateWithDelegationSeverity("parsingToLexicalError", 4, badClassInstance, "'part", SemanticException.class, String.valueOf(location) + ": Invalid token {0}", "'part");
    }

    public void test_validationParsingToSemanticError() {
        ResourceSet resourceSet = this.createResourceSet();
        this.initModelWithErrors(resourceSet);
        EObject badClassInstance = this.create(this.acme, this.companyDetritus, (EClass)this.companyPackage.getEClassifier("ValidationParsingToSemanticError"), null);
        this.validateWithDelegationSeverity("parsingToSemanticError", 4, badClassInstance, "not '5'", SemanticException.class, "1: " + PivotMessagesInternal.UnresolvedOperation_ERROR_, "String", "not");
    }

    public void test_validationParsingToSyntacticError() {
        ResourceSet resourceSet = this.createResourceSet();
        this.initModelWithErrors(resourceSet);
        EObject badClassInstance = this.create(this.acme, this.companyDetritus, (EClass)this.companyPackage.getEClassifier("ValidationParsingToSyntacticError"), null);
        String location = XtextVersionUtil.hasXtextSyntaxDiagnosticColumn() ? "1:1" : "1";
        this.validateWithDelegationSeverity("parsingToSyntacticError", 4, badClassInstance, "else", SemanticException.class, String.valueOf(location) + ": no viable alternative at input ''{0}''", "else");
    }

    public void test_validationWithMessage() {
        ResourceSet resourceSet = this.createResourceSet();
        this.initModelWithErrors(resourceSet);
        EObject badClassInstance = this.create(this.acme, this.companyDetritus, (EClass)this.companyPackage.getEClassifier("ValidationWithMessage"), null);
        this.validateWithSeverity("ValidationWithMessage", 2, badClassInstance, "custom message ", new Object[0]);
    }

    public void test_validationWithCompleteOCL() {
        ResourceSet resourceSet = this.createResourceSet();
        this.initModelWithErrorsAndOcl(resourceSet);
        EClass eClassifier = (EClass)this.companyPackage.getEClassifier("Detritus");
        EObject badClassInstance = this.create(this.acme, this.companyDetritus, eClassifier, null);
        this.validateWithSeverity("CompleteOCLInvariant", 2, badClassInstance, "Failure on " + eClassifier.getName(), new Object[0]);
    }

    public void test_tutorialValidationMessage() {
        GlobalEnvironmentFactory.disposeInstance();
        this.validateTutorial("model/Tutorial1.ecore", "There are 3 loans for the 2 copies of b2");
        GlobalEnvironmentFactory.disposeInstance();
        this.validateTutorial("model/Tutorial2.ecore", "There are 3 loans for the 2 copies of ''b2''");
        GlobalEnvironmentFactory.disposeInstance();
        this.validateTutorial("model/Tutorial1.ecore", "There are 3 loans for the 2 copies of b2");
        GlobalEnvironmentFactory.disposeInstance();
    }

    public void testDelegates_Import_476968() {
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            GlobalEnvironmentFactory environmentFactory = GlobalEnvironmentFactory.getInstance();
            OCLInternal ocl = environmentFactory.createOCL();
            URI uri1 = URI.createPlatformPluginURI((String)"org.eclipse.ocl.examples.project.royalandloyal/model/RoyalAndLoyal.ecore", (boolean)true);
            Resource resource1 = ocl.getResourceSet().getResource(uri1, true);
            DelegatesTest.assertNotNull((Object)resource1);
            URI uri2 = URI.createPlatformResourceURI((String)"org.eclipse.ocl.examples.project.royalandloyal/model/RoyalAndLoyal.ecore", (boolean)true);
            Resource resource2 = ocl.getResourceSet().getResource(uri2, true);
            DelegatesTest.assertNotNull((Object)resource2);
            try {
                URI uri8 = URI.createPlatformPluginURI((String)"org.eclipse.ocl.examples.project.oclinecoretutorial/model/Tutorial.ecore", (boolean)true);
                ocl.getResourceSet().getResource(uri8, true);
                TestCase.fail((String)"Should have thrown a MalformedURLException");
            }
            catch (WrappedException e) {
                DelegatesTest.assertTrue((boolean)(e.getCause() instanceof MalformedURLException));
            }
            try {
                URI uri9 = URI.createPlatformResourceURI((String)"org.eclipse.ocl.examples.project.oclinecoretutorial/model/Tutorial.ecore", (boolean)true);
                ocl.getResourceSet().getResource(uri9, true);
                TestCase.fail((String)"Should have thrown an IOException");
            }
            catch (WrappedException e) {
                DelegatesTest.assertTrue((boolean)(e.getCause() instanceof IOException));
            }
        }
    }

    public void validateTutorial(@NonNull String ecoreURI, @NonNull String message) {
        ResourceSet resourceSet = this.createResourceSet();
        OCL ocl = OCL.newInstance((ProjectManager)DelegatesTest.getProjectMap(), (ResourceSet)resourceSet);
        try {
            ocl.getEnvironmentFactory().adapt((Notifier)resourceSet);
            URI xmiURI = this.getTestModelURI("model/Tutorial.xmi");
            Resource ecoreResource = resourceSet.getResource(this.getTestModelURI(ecoreURI), true);
            EPackage ePackage = (EPackage)ecoreResource.getContents().get(0);
            resourceSet.getPackageRegistry().put((Object)ePackage.getNsURI(), (Object)ePackage);
            Resource xmiResource = resourceSet.getResource(xmiURI, true);
            EObject rootContent = (EObject)xmiResource.getContents().get(0);
            EObject book = null;
            block3: for (EObject eObject : rootContent.eContents()) {
                EClass eClass = eObject.eClass();
                if (!"Book".equals(eClass.getName())) continue;
                for (EStructuralFeature eFeature : eClass.getEAllStructuralFeatures()) {
                    String name;
                    if (!"name".equals(eFeature.getName()) || !"b2".equals(name = (String)eObject.eGet(eFeature))) continue;
                    book = eObject;
                    continue block3;
                }
            }
            this.validateWithSeverity("ValidationWithMessage", 2, book, message, new Object[0]);
            DelegatesTest.unloadResourceSet(resourceSet);
        }
        finally {
            ocl.dispose();
        }
    }

    void add(EObject owner, EStructuralFeature feature, Object value) {
        ((EList)this.get(owner, feature)).add(value);
    }

    Collection<EObject> allReports(EObject employee) {
        Collection collection = (Collection)this.get(employee, (EStructuralFeature)this.employeeAllReports);
        DelegatesTest.assertTrue((boolean)(collection instanceof InternalEList));
        DelegatesTest.assertTrue((boolean)(collection instanceof EStructuralFeature.Setting));
        return collection;
    }

    EObject create(EObject owner, EReference containment, EClass type, String name) {
        EObject result = this.companyFactory.create(type);
        if (containment.isMany()) {
            this.add(owner, (EStructuralFeature)containment, result);
        } else {
            this.set(owner, (EStructuralFeature)containment, result);
        }
        if (name != null) {
            this.set(result, type.getEStructuralFeature("name"), name);
        }
        return result;
    }

    EList<EObject> directReports(EObject employee) {
        return (EList)this.get(employee, (EStructuralFeature)this.employeeDirectReports);
    }

    EObject employee(String name) {
        EObject result = this.employees.get(name);
        if (result == null) {
            EList emps = (EList)this.get(this.acme, (EStructuralFeature)this.companyEmployees);
            for (EObject next : emps) {
                if (!name.equals(this.name(next))) continue;
                result = next;
                this.employees.put(name, result);
                break;
            }
        }
        return result;
    }

    EList<EObject> employees(EObject company) {
        return (EList)this.get(company, (EStructuralFeature)this.companyEmployees);
    }

    <T> T get(EObject owner, EStructuralFeature feature) {
        Object result = owner.eGet(feature);
        return (T)result;
    }

    public EOperation getOperation(EClass eClass, String name) {
        for (EOperation eOperation : eClass.getEOperations()) {
            if (!name.equals(eOperation.getName())) continue;
            return eOperation;
        }
        DelegatesTest.fail((String)("Expected to find operation: " + name));
        return null;
    }

    public EStructuralFeature getStructuralFeature(EClass eClass, String name) {
        for (EStructuralFeature eStructuralFeature : eClass.getEStructuralFeatures()) {
            if (!name.equals(eStructuralFeature.getName())) continue;
            return eStructuralFeature;
        }
        DelegatesTest.fail((String)("Expected to find structural feature: " + name));
        return null;
    }

    protected Class getType(@NonNull OCL ocl, EObject eObject) {
        return ocl.getIdResolver().getStaticTypeOf((Object)eObject);
    }

    public void getWithException(EObject eObject, String featureName, String expectedMessage) {
        EClass eClass = eObject.eClass();
        EAttribute eAttribute = (EAttribute)eClass.getEStructuralFeature(featureName);
        try {
            Object object = this.get(eObject, (EStructuralFeature)eAttribute);
            DelegatesTest.fail((String)("Expected to catch OCLDelegateException: " + expectedMessage));
        }
        catch (OCLDelegateException e) {
            DelegatesTest.assertEquals((String)"OCLDelegateException: ", (String)expectedMessage, (String)e.getCause().getLocalizedMessage());
        }
    }

    <T> T invoke(EObject target, EOperation operation, Object ... arguments) throws InvocationTargetException {
        return (T)target.eInvoke(operation, (EList)(arguments.length == 0 ? ECollections.emptyEList() : new BasicEList.UnmodifiableEList(arguments.length, arguments)));
    }

    public void invokeWithException(EObject eObject, String name, String expectedMessage) throws InvocationTargetException {
        EClass eClass = eObject.eClass();
        for (EOperation eOperation : eClass.getEOperations()) {
            if (!name.equals(eOperation.getName())) continue;
            try {
                Object object = this.invoke(eObject, eOperation, new Object[0]);
                DelegatesTest.fail((String)("Expected to catch InvocationTargetException: " + expectedMessage));
            }
            catch (OCLDelegateException e) {
                Throwable cause = e.getCause();
                DelegatesTest.assertEquals((String)"OCLDelegateException: ", (String)expectedMessage, (String)cause.getLocalizedMessage());
                return;
            }
        }
        DelegatesTest.fail((String)("Expected to find: " + name));
    }

    Object execute(QueryDelegate delegate, Object target, Map<String, Object> bindings) {
        try {
            return delegate.execute(target, bindings);
        }
        catch (InvocationTargetException ite) {
            DelegatesTest.fail((String)("Failed to execute query: " + ite.getCause().getLocalizedMessage()));
            return null;
        }
    }

    public void executeWithException(QueryDelegate delegate, Object target, Map<String, Object> bindings, String messageTemplate, Object ... messageBindings) {
        String expectedMessage = StringUtil.bind((String)messageTemplate, (Object[])messageBindings);
        try {
            Object object = delegate.execute(target, bindings);
            DelegatesTest.fail((String)("Expected to catch InvocationTargetException: " + expectedMessage));
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            DelegatesTest.assertEquals((String)(String.valueOf(cause.getClass().getSimpleName()) + ": "), (String)expectedMessage, (String)cause.getLocalizedMessage());
        }
    }

    public void executeWithException2(QueryDelegate delegate, Object target, Map<String, Object> bindings, String expectedMessage) {
        try {
            Object object = delegate.execute(target, bindings);
            DelegatesTest.fail((String)("Expected to catch InvocationTargetException: " + expectedMessage));
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            DelegatesTest.assertEquals((String)(String.valueOf(cause.getClass().getSimpleName()) + ": "), (String)expectedMessage, (String)cause.getLocalizedMessage());
        }
    }

    EObject manager(EObject employee) {
        return (EObject)this.get(employee, (EStructuralFeature)this.employeeManager);
    }

    String name(EObject employeeOrCompany) {
        EAttribute name = this.employeeClass.isInstance((Object)employeeOrCompany) ? this.employeeName : this.companyName;
        return (String)this.get(employeeOrCompany, (EStructuralFeature)name);
    }

    void set(EObject owner, EStructuralFeature feature, Object value) {
        owner.eSet(feature, value);
    }

    Enumerator size(EObject company) {
        return (Enumerator)this.get(company, (EStructuralFeature)this.companySize);
    }

    protected void validateWithoutError(EObject eObject) {
        List diagnostics;
        Map validationContext = LabelUtil.createDefaultContext((EValidator)Diagnostician.INSTANCE);
        Diagnostic validation = Diagnostician.INSTANCE.validate(eObject, validationContext);
        if (validation.getSeverity() != 0 && !(diagnostics = validation.getChildren()).isEmpty()) {
            StringBuilder s = null;
            for (Diagnostic diagnostic : diagnostics) {
                if (s == null) {
                    s = new StringBuilder();
                } else {
                    s.append("\n");
                }
                s.append(diagnostic.getMessage());
            }
            String string = s.toString();
            DelegatesTest.fail((String)string);
        }
        DelegatesTest.assertEquals((String)"Validation severity:", (int)0, (int)validation.getSeverity());
        diagnostics = validation.getChildren();
        DelegatesTest.assertEquals((String)"Validation child count:", (int)0, (int)diagnostics.size());
    }

    protected void validateConstraintWithSeverity(String constraintName, int severity, EObject eObject, String message) {
        Map validationContext = LabelUtil.createDefaultContext((EValidator)Diagnostician.INSTANCE);
        Diagnostic validation = Diagnostician.INSTANCE.validate(eObject, validationContext);
        List diagnostics = validation.getChildren();
        DelegatesTest.assertEquals((String)("Validation of '" + constraintName + "' child count:"), (int)1, (int)diagnostics.size());
        Diagnostic diagnostic = (Diagnostic)diagnostics.get(0);
        DelegatesTest.assertEquals((String)("Validation of '" + constraintName + "' data count:"), (int)1, (int)diagnostic.getData().size());
        DelegatesTest.assertEquals((String)("Validation of '" + constraintName + "' data object:"), (Object)eObject, diagnostic.getData().get(0));
        String objectLabel = NameUtil.qualifiedNameFor((Object)eObject);
        String message2 = message != null ? message : StringUtil.bind((String)PivotMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{String.valueOf(eObject.eClass().getName()) + "::" + constraintName, objectLabel});
        DelegatesTest.assertEquals((String)("Validation of '" + constraintName + "' message:"), (String)message2, (String)diagnostic.getMessage());
        DelegatesTest.assertEquals((String)("Validation of '" + constraintName + "' severity:"), (int)severity, (int)validation.getSeverity());
    }

    protected void validateInvariantWithSeverity(String constraintName, int severity, EObject eObject) {
        this.validateWithSeverity(constraintName, severity, eObject, EcorePlugin.INSTANCE.getString("_UI_GenericInvariant_diagnostic"), constraintName, LabelUtil.getLabel((Object)eObject));
    }

    protected void validateWithSeverity(String constraintName, int severity, EObject eObject, String messageTemplate, Object ... bindings) {
        Map validationContext = LabelUtil.createDefaultContext((EValidator)Diagnostician.INSTANCE);
        Diagnostic validation = Diagnostician.INSTANCE.validate(eObject, validationContext);
        List diagnostics = validation.getChildren();
        DelegatesTest.assertEquals((String)("Validation of '" + constraintName + "' child count:"), (int)1, (int)diagnostics.size());
        Diagnostic diagnostic = (Diagnostic)diagnostics.get(0);
        DelegatesTest.assertEquals((String)("Validation of '" + constraintName + "' data count:"), (int)1, (int)diagnostic.getData().size());
        DelegatesTest.assertEquals((String)("Validation of '" + constraintName + "' data object:"), (Object)eObject, diagnostic.getData().get(0));
        String message = StringUtil.bind((String)messageTemplate, (Object[])bindings);
        DelegatesTest.assertEquals((String)("Validation of '" + constraintName + "' message:"), (String)message, (String)diagnostic.getMessage());
        DelegatesTest.assertEquals((String)("Validation of '" + constraintName + "' severity:"), (int)severity, (int)validation.getSeverity());
    }

    protected void validateWithDelegationSeverity(String constraintName, int severity, EObject eObject, String source, java.lang.Class<? extends Exception> exceptionClass, String messageTemplate, Object ... bindings) {
        Map validationContext = LabelUtil.createDefaultContext((EValidator)Diagnostician.INSTANCE);
        Diagnostic validation = Diagnostician.INSTANCE.validate(eObject, validationContext);
        DelegatesTest.assertEquals((String)("Validation of '" + constraintName + "' severity:"), (int)severity, (int)validation.getSeverity());
        List diagnostics = validation.getChildren();
        DelegatesTest.assertEquals((String)("Validation of '" + constraintName + "' child count:"), (int)1, (int)diagnostics.size());
        Diagnostic diagnostic = (Diagnostic)diagnostics.get(0);
        List data = diagnostic.getData();
        int size = data.size();
        if (size == 2) {
            Object data1 = data.get(1);
            assert (data1 != null);
            DelegatesTest.assertEquals((String)("Validation of '" + constraintName + "' exception:"), exceptionClass, data1.getClass());
        } else if (size != 1) {
            DelegatesTest.fail((String)("Validation of '" + constraintName + "' child count: " + size));
        }
        String message = this.getErrorsInMessage(eObject.eClass().getName(), constraintName, source);
        message = String.valueOf(message) + StringUtil.bind((String)messageTemplate, (Object[])bindings);
        DelegatesTest.assertEquals((String)("Validation of '" + constraintName + "' data object:"), (Object)eObject, data.get(0));
        DelegatesTest.assertEquals((String)("Validation of '" + constraintName + "' message:"), (String)message, (String)diagnostic.getMessage());
    }

    protected String getErrorsInMessage(String packageName, String typeName, String source) {
        return source != null ? String.valueOf(StringUtil.bind((String)PivotMessagesInternal.ValidationConstraintIsInvalid_ERROR_, (Object[])new Object[]{packageName, typeName, source})) + "\n" : "";
    }
}

