/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.tests;

import company.CompanyPackage;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.pivot.tests.PivotTestSuite;
import org.eclipse.ocl.examples.pivot.tests.TestOCL;
import org.eclipse.ocl.examples.xtext.tests.TestUtil;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.ids.ElementId;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.messages.PivotMessagesInternal;
import org.eclipse.ocl.pivot.internal.values.BagImpl;
import org.eclipse.ocl.pivot.messages.PivotMessages;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.values.OrderedSetValue;
import org.eclipse.ocl.pivot.values.SequenceValue;
import org.eclipse.ocl.util.CollectionUtil;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class EvaluateModelOperationsTest4
extends PivotTestSuite {
    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{{false}, {true}};
        return Arrays.asList(data);
    }

    public EvaluateModelOperationsTest4(boolean useCodeGen) {
        super(useCodeGen);
    }

    @Override
    protected @NonNull TestOCL createOCL() {
        return new TestOCL(this.getTestPackageName(), this.getName(), (ProjectManager)(useCodeGen ? EvaluateModelOperationsTest4.getProjectMap() : OCL.NO_PROJECTS));
    }

    @Override
    protected @NonNull String getTestPackageName() {
        return "EvaluateModelOperations";
    }

    @BeforeClass
    public static void resetCounter() throws Exception {
        PivotTestSuite.resetCounter();
    }

    @Override
    @Before
    public void setUp() throws Exception {
        TestUtil.doOCLinEcoreSetup();
        super.setUp();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void eAdd(@NonNull EObject eObject, @NonNull String featureName, @Nullable Object value) {
        EStructuralFeature eStructuralFeature = eObject.eClass().getEStructuralFeature(featureName);
        assert (eStructuralFeature.isMany());
        if (eStructuralFeature instanceof EReference ? !$assertionsDisabled && !(value instanceof EObject) : !$assertionsDisabled && value instanceof EObject) {
            throw new AssertionError();
        }
        ((List)eObject.eGet(eStructuralFeature)).add(value);
    }

    public @NonNull EObject eCreate(EClass cClass) {
        return (EObject)ClassUtil.nonNullEMF((Object)cClass.getEPackage().getEFactoryInstance().create(cClass));
    }

    public void eSet(@NonNull EObject eObject, @NonNull String featureName, @Nullable Object value) {
        EStructuralFeature eStructuralFeature = eObject.eClass().getEStructuralFeature(featureName);
        assert (!eStructuralFeature.isMany());
        if (eStructuralFeature instanceof EReference ? !$assertionsDisabled && !(value instanceof EObject) : !$assertionsDisabled && value instanceof EObject) {
            throw new AssertionError();
        }
        eObject.eSet(eStructuralFeature, value);
    }

    @Test
    public void test_ecoreDataTypes() throws IOException {
        TestOCL ocl = this.createOCL();
        String metamodelText = "import ecore : 'http://www.eclipse.org/emf/2002/Ecore#/';\npackage pkg : pkg = 'pkg' {\n  class A {\n    property anEBigDecimal : ecore::EBigDecimal;\n    property anEBigInteger : ecore::EBigInteger;\n    property anEBoolean : ecore::EBoolean;\n    property anEBooleanObject : ecore::EBooleanObject;\n    property anEByte : ecore::EByte;\n    property anEByteObject : ecore::EByteObject;\n    property anEChar : ecore::EChar;\n    property anECharacterObject : ecore::ECharacterObject;\n    property anEDouble : ecore::EDouble;\n    property anEDoubleObject : ecore::EDoubleObject;\n    property anEFloat : ecore::EFloat;\n    property anEFloatObject : ecore::EFloatObject;\n    property anEInt : ecore::EInt;\n    property anEIntegerObject : ecore::EIntegerObject;\n    property anELong : ecore::ELong;\n    property anELongObject : ecore::ELongObject;\n    property anEShort : ecore::EShort;\n    property anEShortObject : ecore::EShortObject;\n    property anEString : ecore::EString;\n    property anEDate : ecore::EDate;\n  }\n}\n";
        Resource metamodel = EvaluateModelOperationsTest4.cs2ecore((OCL)ocl, metamodelText, null);
        EPackage ePackage = (EPackage)metamodel.getContents().get(0);
        EClass eClass = (EClass)ClassUtil.nonNullState((Object)((EClass)ePackage.getEClassifiers().get(0)));
        EObject eObject = this.eCreate(eClass);
        Date nowDate = new Date();
        this.eSet(eObject, "anEDate", nowDate);
        ocl.assertQueryTrue(eObject, "anEDate = anEDate");
        ocl.assertQueryFalse(eObject, "anEDate = ecore::EDate{value='2345-12-23'}");
        this.eSet(eObject, "anEBigDecimal", BigDecimal.valueOf(0L));
        ocl.assertQueryEquals(eObject, 0, "anEBigDecimal");
        ocl.assertQueryEquals(eObject, 1, "anEBigDecimal + 1");
        ocl.assertQueryEquals(eObject, 0, "self.anEBigDecimal");
        ocl.assertQueryEquals(eObject, 1, "self.anEBigDecimal + 1");
        this.eSet(eObject, "anEBigInteger", BigInteger.valueOf(0L));
        ocl.assertQueryEquals(eObject, 0, "anEBigInteger");
        ocl.assertQueryEquals(eObject, 1, "anEBigInteger + 1");
        ocl.assertQueryEquals(eObject, 0, "self.anEBigInteger");
        ocl.assertQueryEquals(eObject, 1, "self.anEBigInteger + 1");
        ocl.assertQueryEquals(eObject, false, "anEBoolean");
        ocl.assertQueryEquals(eObject, true, "anEBoolean or true");
        ocl.assertQueryEquals(eObject, false, "self.anEBoolean");
        ocl.assertQueryEquals(eObject, true, "self.anEBoolean or true");
        this.eSet(eObject, "anEBooleanObject", false);
        ocl.assertQueryEquals(eObject, false, "anEBooleanObject");
        ocl.assertQueryEquals(eObject, true, "anEBooleanObject or true");
        ocl.assertQueryEquals(eObject, false, "self.anEBooleanObject");
        ocl.assertQueryEquals(eObject, true, "self.anEBooleanObject or true");
        ocl.assertQueryEquals(eObject, 0, "anEByte");
        ocl.assertQueryEquals(eObject, 1, "anEByte + 1");
        ocl.assertQueryEquals(eObject, 0, "self.anEByte");
        ocl.assertQueryEquals(eObject, 1, "self.anEByte + 1");
        this.eSet(eObject, "anEByteObject", (byte)0);
        ocl.assertQueryEquals(eObject, 0, "anEByteObject");
        ocl.assertQueryEquals(eObject, 1, "anEByteObject + 1");
        ocl.assertQueryEquals(eObject, 0, "self.anEByteObject");
        ocl.assertQueryEquals(eObject, 1, "self.anEByteObject + 1");
        ocl.assertQueryEquals(eObject, 0, "anEChar");
        ocl.assertQueryEquals(eObject, 1, "anEChar + 1");
        ocl.assertQueryEquals(eObject, 0, "self.anEChar");
        ocl.assertQueryEquals(eObject, 1, "self.anEChar + 1");
        this.eSet(eObject, "anECharacterObject", Character.valueOf('\u0000'));
        ocl.assertQueryEquals(eObject, 0, "anECharacterObject");
        ocl.assertQueryEquals(eObject, 1, "anECharacterObject + 1");
        ocl.assertQueryEquals(eObject, 0, "self.anECharacterObject");
        ocl.assertQueryEquals(eObject, 1, "self.anECharacterObject + 1");
        ocl.assertQueryEquals(eObject, 0, "anEDouble");
        ocl.assertQueryEquals(eObject, 1, "anEDouble + 1");
        ocl.assertQueryEquals(eObject, 0, "self.anEDouble");
        ocl.assertQueryEquals(eObject, 1, "self.anEDouble + 1");
        this.eSet(eObject, "anEDoubleObject", 0.0);
        ocl.assertQueryEquals(eObject, 0, "anEDoubleObject");
        ocl.assertQueryEquals(eObject, 1, "anEDoubleObject + 1");
        ocl.assertQueryEquals(eObject, 0, "self.anEDoubleObject");
        ocl.assertQueryEquals(eObject, 1, "self.anEDoubleObject + 1");
        ocl.assertQueryEquals(eObject, 0, "anEFloat");
        ocl.assertQueryEquals(eObject, 1, "anEFloat + 1");
        ocl.assertQueryEquals(eObject, 0, "self.anEFloat");
        ocl.assertQueryEquals(eObject, 1, "self.anEFloat + 1");
        this.eSet(eObject, "anEFloatObject", Float.valueOf(0.0f));
        ocl.assertQueryEquals(eObject, 0, "anEFloatObject");
        ocl.assertQueryEquals(eObject, 1, "anEFloatObject + 1");
        ocl.assertQueryEquals(eObject, 0, "self.anEFloatObject");
        ocl.assertQueryEquals(eObject, 1, "self.anEFloatObject + 1");
        ocl.assertQueryEquals(eObject, 0, "anEInt");
        ocl.assertQueryEquals(eObject, 1, "anEInt + 1");
        ocl.assertQueryEquals(eObject, 0, "self.anEInt");
        ocl.assertQueryEquals(eObject, 1, "self.anEInt + 1");
        this.eSet(eObject, "anEIntegerObject", 0);
        ocl.assertQueryEquals(eObject, 0, "anEIntegerObject");
        ocl.assertQueryEquals(eObject, 1, "anEIntegerObject + 1");
        ocl.assertQueryEquals(eObject, 0, "self.anEIntegerObject");
        ocl.assertQueryEquals(eObject, 1, "self.anEIntegerObject + 1");
        ocl.assertQueryEquals(eObject, 0, "anELong");
        ocl.assertQueryEquals(eObject, 1, "anELong + 1");
        ocl.assertQueryEquals(eObject, 0, "self.anELong");
        ocl.assertQueryEquals(eObject, 1, "self.anELong + 1");
        this.eSet(eObject, "anELongObject", 0L);
        ocl.assertQueryEquals(eObject, 0, "anELongObject");
        ocl.assertQueryEquals(eObject, 1, "anELongObject + 1");
        ocl.assertQueryEquals(eObject, 0, "self.anELongObject");
        ocl.assertQueryEquals(eObject, 1, "self.anELongObject + 1");
        ocl.assertQueryEquals(eObject, 0, "anEShort");
        ocl.assertQueryEquals(eObject, 1, "anEShort + 1");
        ocl.assertQueryEquals(eObject, 0, "self.anEShort");
        ocl.assertQueryEquals(eObject, 1, "self.anEShort + 1");
        this.eSet(eObject, "anEShortObject", (short)0);
        ocl.assertQueryEquals(eObject, 0, "anEShortObject");
        ocl.assertQueryEquals(eObject, 1, "anEShortObject + 1");
        ocl.assertQueryEquals(eObject, 0, "self.anEShortObject");
        ocl.assertQueryEquals(eObject, 1, "self.anEShortObject + 1");
        this.eSet(eObject, "anEString", "");
        ocl.assertQueryEquals(eObject, "", "anEString");
        ocl.assertQueryEquals(eObject, "1", "anEString + '1'");
        ocl.assertQueryEquals(eObject, "", "self.anEString");
        ocl.assertQueryEquals(eObject, "1", "self.anEString + '1'");
        ocl.dispose();
    }

    @Test
    public void test_oclAsSet_351512() throws IOException {
        TestOCL ocl = this.createOCL();
        IdResolver idResolver = ocl.getIdResolver();
        String metamodelText = "import ecore : 'http://www.eclipse.org/emf/2002/Ecore#/';\npackage pkg : pkg = 'pkg' {\n  class A {\n    property bs : B[*] {ordered,unique};\n    attribute name : String;\n  }\n  class B {\n    property c : C;\n  }\n  class C {\n    attribute name : String;\n  }\n}\n";
        Resource metamodel = EvaluateModelOperationsTest4.cs2ecore((OCL)ocl, metamodelText, null);
        EPackage ePackage = (EPackage)metamodel.getContents().get(0);
        EClass aClass = (EClass)ClassUtil.nonNullState((Object)((EClass)ePackage.getEClassifier("A")));
        EClass bClass = (EClass)ePackage.getEClassifier("B");
        EClass cClass = (EClass)ePackage.getEClassifier("C");
        EObject c1 = this.eCreate(cClass);
        this.eSet(c1, "name", "c1");
        EObject c2 = this.eCreate(cClass);
        this.eSet(c2, "name", "c2");
        EObject b1 = this.eCreate(bClass);
        this.eSet(b1, "c", c1);
        EObject b2 = this.eCreate(bClass);
        this.eSet(b2, "c", c2);
        EObject a = this.eCreate(aClass);
        this.eAdd(a, "bs", b1);
        this.eAdd(a, "bs", b2);
        Object b1_value = idResolver.boxedValueOf((Object)b1);
        Object b2_value = idResolver.boxedValueOf((Object)b2);
        Object c1_value = idResolver.boxedValueOf((Object)c1);
        Object c2_value = idResolver.boxedValueOf((Object)c2);
        OrderedSetValue orderedSet_b1_b2 = idResolver.createOrderedSetOfEach(TypeId.ORDERED_SET.getSpecializedId(new ElementId[]{TypeId.OCL_ANY}), new Object[]{b1_value, b2_value});
        SequenceValue sequence_c1_c2 = idResolver.createSequenceOfEach(TypeId.SEQUENCE.getSpecializedId(new ElementId[]{TypeId.OCL_ANY}), new Object[]{c1_value, c2_value});
        ocl.assertQueryEquals(a, orderedSet_b1_b2, "bs");
        ocl.assertQueryEquals(a, sequence_c1_c2, "bs?.c");
        ocl.assertQueryEquals(a, sequence_c1_c2, "bs?.c.oclAsSet()");
        ocl.assertQueryResults(a, "Sequence{'c1','c2'}", "bs?.c?.name");
        ocl.assertQueryResults(a, "Sequence{'c1','c2'}", "self.bs?.c?.name");
        ocl.assertQueryResults(a, "Sequence{'c1','c2'}", "bs?.c?.oclAsSet().name");
        ocl.assertQueryResults(a, "Sequence{'c1','c2'}", "bs?.c?.oclAsSet()->collect(name)");
        ocl.assertQueryResults(a, "Sequence{'c1','c2'}", "bs?.c?->collect(oclAsSet()).name");
        ocl.assertQueryResults(a, "Sequence{'c1','c2'}", "bs?.c?->collect(j : C | j.oclAsSet()).name");
        ocl.assertQueryResults(a, "Sequence{'c1','c2'}", "bs?->collect(i : B | i.c)?->collect(j : C | j.oclAsSet())->collect(k : C | k.name)");
        ocl.dispose();
    }

    @Test
    public void test_containment_navigation() throws IOException {
        TestOCL ocl = this.createOCL();
        IdResolver idResolver = ocl.getIdResolver();
        String metamodelText = "package containment : pfx = 'http://containment'\n{\n\tclass Parent\n\t{\n\t\tproperty child1 : Child1[?] { ordered composes };\n\t\tproperty child2#parent : Child2[?] { ordered composes };\n\t\tproperty children1 : Children1[*] { ordered composes };\n\t\tproperty children2#parent : Children2[*] { ordered composes };\n\t}\n\tclass Child1\n\t{\n\t}\n\tclass Child2\n\t{\n\t\tproperty parent#child2 : Parent[?] { ordered };\n\t}\n\tclass Children1\n\t{\n\t}\n\tclass Children2\n\t{\n\t\tproperty parent#children2 : Parent[?] { ordered };\n\t}\n}\n";
        TestOCL ocl1 = this.createOCL();
        Resource metamodel = EvaluateModelOperationsTest4.cs2ecore((OCL)ocl1, metamodelText, null);
        EPackage ePackage = (EPackage)metamodel.getContents().get(0);
        EClass parentClass = (EClass)ClassUtil.nonNullState((Object)((EClass)ePackage.getEClassifier("Parent")));
        EClass child1Class = (EClass)ClassUtil.nonNullState((Object)((EClass)ePackage.getEClassifier("Child1")));
        EClass child2Class = (EClass)ClassUtil.nonNullState((Object)((EClass)ePackage.getEClassifier("Child2")));
        EClass children1Class = (EClass)ClassUtil.nonNullState((Object)((EClass)ePackage.getEClassifier("Children1")));
        EClass children2Class = (EClass)ClassUtil.nonNullState((Object)((EClass)ePackage.getEClassifier("Children2")));
        EObject parent = this.eCreate(parentClass);
        EObject child1 = this.eCreate(child1Class);
        EObject child2 = this.eCreate(child2Class);
        EObject children1 = this.eCreate(children1Class);
        EObject children2 = this.eCreate(children2Class);
        this.eSet(parent, "child1", child1);
        this.eSet(parent, "child2", child2);
        this.eAdd(parent, "children1", children1);
        this.eAdd(parent, "children2", children2);
        Class parentType = idResolver.getType((EClassifier)parentClass);
        Class child1Type = idResolver.getType((EClassifier)child1Class);
        Class child2Type = idResolver.getType((EClassifier)child2Class);
        Class children1Type = idResolver.getType((EClassifier)children1Class);
        Class children2Type = idResolver.getType((EClassifier)children2Class);
        OrderedSetValue kids1 = idResolver.createOrderedSetOfEach(TypeId.ORDERED_SET.getSpecializedId(new ElementId[]{children1Type.getTypeId()}), new Object[]{children1});
        OrderedSetValue kids2 = idResolver.createOrderedSetOfEach(TypeId.ORDERED_SET.getSpecializedId(new ElementId[]{children2Type.getTypeId()}), new Object[]{children2});
        ocl.assertSemanticErrorQuery(parentType, "parent", PivotMessagesInternal.UnresolvedProperty_ERROR_, "", "parent");
        ocl.assertSemanticErrorQuery(parentType, "self.parent", PivotMessagesInternal.UnresolvedProperty_ERROR_, parentType, "parent");
        ocl.assertQueryEquals(parent, parentType, "Parent");
        ocl.assertSemanticErrorQuery(parentType, "self.Parent", PivotMessagesInternal.UnresolvedProperty_ERROR_, parentType, "Parent");
        ocl.assertQueryEquals(parent, child1, "child1");
        ocl.assertQueryEquals(parent, child1, "self.child1");
        ocl.assertQueryEquals(parent, child1Type, "Child1");
        ocl.assertSemanticErrorQuery(parentType, "self.Child1", PivotMessagesInternal.UnresolvedProperty_ERROR_, parentType, "Child1");
        ocl.assertQueryEquals(parent, child2, "child2");
        ocl.assertQueryEquals(parent, child2, "self.child2");
        ocl.assertQueryEquals(parent, child2Type, "Child2");
        ocl.assertSemanticErrorQuery(parentType, "self.Child2", PivotMessagesInternal.UnresolvedProperty_ERROR_, parentType, "Child2");
        ocl.assertQueryEquals(parent, kids1, "children1");
        ocl.assertQueryEquals(parent, kids1, "self.children1");
        ocl.assertQueryEquals(parent, children1Type, "Children1");
        ocl.assertSemanticErrorQuery(parentType, "self.Children1", PivotMessagesInternal.UnresolvedProperty_ERROR_, parentType, "Children1");
        ocl.assertQueryEquals(parent, kids2, "children2");
        ocl.assertQueryEquals(parent, kids2, "self.children2");
        ocl.assertQueryEquals(parent, children2Type, "Children2");
        ocl.assertSemanticErrorQuery(parentType, "self.Children2", PivotMessagesInternal.UnresolvedProperty_ERROR_, parentType, "Children2");
        ocl.assertSemanticErrorQuery(child1Type, "parent", PivotMessagesInternal.UnresolvedProperty_ERROR_, "", "parent");
        ocl.assertQueryEquals(child2, parentType, "Parent");
        ocl.assertSemanticErrorQuery(child1Type, "self.parent", PivotMessagesInternal.UnresolvedProperty_ERROR_, child1Type, "parent");
        ocl.assertQueryEquals(child1, parent, "self.Parent");
        ocl.assertQueryEquals(child2, parent, "parent");
        ocl.assertQueryEquals(child2, parentType, "Parent");
        ocl.assertQueryEquals(child2, parent, "self.parent");
        ocl.assertSemanticErrorQuery(child2Type, "self.Parent", PivotMessagesInternal.UnresolvedProperty_ERROR_, child2Type, "Parent");
        ocl.assertSemanticErrorQuery(children1Type, "parent", PivotMessagesInternal.UnresolvedProperty_ERROR_, "", "parent");
        ocl.assertQueryEquals(children1, parentType, "Parent");
        ocl.assertSemanticErrorQuery(children1Type, "self.parent", PivotMessagesInternal.UnresolvedProperty_ERROR_, children1Type, "parent");
        ocl.assertQueryEquals(children1, parent, "self.Parent");
        ocl.assertQueryEquals(children2, parent, "parent");
        ocl.assertQueryEquals(children2, parentType, "Parent");
        ocl.assertQueryEquals(children2, parent, "self.parent");
        ocl.assertSemanticErrorQuery(children2Type, "self.Parent", PivotMessagesInternal.UnresolvedProperty_ERROR_, children2Type, "Parent");
        ocl.assertQueryTrue(parent, "child1 = child1");
        ocl1.dispose();
        ocl.dispose();
    }

    @Test
    public void test_enumeration_navigation() throws InvocationTargetException {
        TestOCL ocl = this.createOCL();
        if (!useCodeGen) {
            ocl.assertQueryResults(CompanyPackage.Literals.COMPANY_SIZE_KIND, "Sequence{'small','medium','large'}", "self.eLiterals.name");
        }
        ocl.dispose();
    }

    @Test
    public void test_multi_container_394152() throws IOException {
        TestOCL ocl = this.createOCL();
        String metamodelText = "package bug394152 : pfx = 'http://bug394152'\n{\n\tclass Parent\n\t{\n\t\tproperty left#left : Child[+] { ordered composes };\n\t\tproperty right#right : Child[+] { ordered composes };\n\t}\n\tclass Child\n\t{\n\t\tproperty left#left : Parent[?] { ordered };\n\t\tproperty right#right : Parent[?] { ordered };\n\t}\n}\n";
        Resource metamodel = EvaluateModelOperationsTest4.cs2ecore((OCL)ocl, metamodelText, null);
        EPackage ePackage = (EPackage)metamodel.getContents().get(0);
        EClass parentClass = (EClass)ePackage.getEClassifier("Parent");
        EClass childClass = (EClass)ClassUtil.nonNullState((Object)((EClass)ePackage.getEClassifier("Child")));
        EObject parent = this.eCreate(parentClass);
        EObject leftChild = this.eCreate(childClass);
        EObject rightChild = this.eCreate(childClass);
        this.eAdd(parent, "left", leftChild);
        this.eAdd(parent, "right", rightChild);
        ocl.assertQueryEquals(leftChild, parent, "left");
        ocl.assertQueryEquals(leftChild, null, "right");
        ocl.assertQueryEquals(rightChild, null, "left");
        ocl.assertQueryEquals(rightChild, parent, "right");
        ocl.dispose();
    }

    @Test
    public void test_unified_types_411441() {
        TestOCL ocl = this.createOCL();
        ocl.assertQueryTrue(null, "let x : Collection(Type) = Set{Integer,Real} in x?->forAll(x : Type | x.name.indexOf('e') > 0)");
        ocl.assertQueryTrue(null, "let x : Type[*] = Bag{Integer,Real} in x?->forAll(x : Type | x.name.indexOf('e') > 0)");
        ocl.assertValidationErrorQuery(null, "let x : Type[*] = Set{Integer,Real} in x?->forAll(x : Type | x.name.indexOf('e') > 0)", PivotMessages.ValidationConstraintIsNotSatisfied_ERROR_, "LetVariable::CompatibleTypeForInitializer", "x : Bag(Type[*|?]) = Set{Integer, Real}");
        ocl.assertQueryTrue(null, "let x : Collection(Collection(Type[*])) = Set{Bag{Integer,Real},Bag{Boolean}} in x?->forAll(x : Collection(Type[*]) | x->size() > 0)");
        ocl.assertValidationErrorQuery(null, "let x : Collection(Collection(Type[*])) = Set{Bag{Integer,Real},Bag{Boolean}} in x?->forAll(x : Type | x->size() > 0)", PivotMessages.ValidationConstraintIsNotSatisfied_ERROR_, "IteratorExp::IteratorTypeIsSourceElementType", "x?->forAll(x : Type[1] | x.oclAsSet()->size().>(0))");
        ocl.assertValidationErrorQuery(null, "let x : Collection(Type) = Set{Integer,Real} in x?->forAll(x : Type[*] | x->size() > 0)", PivotMessages.ValidationConstraintIsNotSatisfied_ERROR_, "IteratorExp::IteratorTypeIsSourceElementType", "x?->forAll(x : Bag(Type[*|?]) | x->size().>(0))");
        ocl.dispose();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void test_ecore_collection_equality() {
        TestOCL ocl = this.createOCL();
        EList eStructuralFeatures = EcorePackage.Literals.ECLASS.getEStructuralFeatures();
        ocl.assertQueryOCLEquals(EcorePackage.Literals.ECLASS, eStructuralFeatures, "self.eStructuralFeatures");
        ocl.assertQueryOCLNotEquals(EcorePackage.Literals.ECLASS, eStructuralFeatures, "self.eStructuralFeatures->asBag()");
        ocl.assertQueryOCLEquals(EcorePackage.Literals.ECLASS, eStructuralFeatures, "self.eStructuralFeatures->asOrderedSet()");
        ocl.assertQueryOCLNotEquals(EcorePackage.Literals.ECLASS, eStructuralFeatures, "self.eStructuralFeatures->asSequence()");
        ocl.assertQueryOCLNotEquals(EcorePackage.Literals.ECLASS, eStructuralFeatures, "self.eStructuralFeatures->asSet()");
        ocl.assertQueryOCLNotEquals(EcorePackage.Literals.ECLASS, new HashSet(eStructuralFeatures), "self.eStructuralFeatures->asBag()");
        ocl.assertQueryOCLNotEquals(EcorePackage.Literals.ECLASS, new HashSet(eStructuralFeatures), "self.eStructuralFeatures->asOrderedSet()");
        ocl.assertQueryOCLNotEquals(EcorePackage.Literals.ECLASS, new HashSet(eStructuralFeatures), "self.eStructuralFeatures->asSequence()");
        ocl.assertQueryOCLEquals(EcorePackage.Literals.ECLASS, new HashSet(eStructuralFeatures), "self.eStructuralFeatures->asSet()");
        ocl.assertQueryOCLNotEquals(EcorePackage.Literals.ECLASS, new ArrayList(eStructuralFeatures), "self.eStructuralFeatures->asBag()");
        ocl.assertQueryOCLNotEquals(EcorePackage.Literals.ECLASS, new ArrayList(eStructuralFeatures), "self.eStructuralFeatures->asOrderedSet()");
        ocl.assertQueryOCLEquals(EcorePackage.Literals.ECLASS, new ArrayList(eStructuralFeatures), "self.eStructuralFeatures->asSequence()");
        ocl.assertQueryOCLNotEquals(EcorePackage.Literals.ECLASS, new ArrayList(eStructuralFeatures), "self.eStructuralFeatures->asSequence()->reverse()");
        ocl.assertQueryOCLNotEquals(EcorePackage.Literals.ECLASS, new ArrayList(eStructuralFeatures), "self.eStructuralFeatures->asSet()");
        ocl.assertQueryOCLNotEquals(EcorePackage.Literals.ECLASS, new LinkedHashSet(eStructuralFeatures), "self.eStructuralFeatures->asBag()");
        ocl.assertQueryOCLEquals(EcorePackage.Literals.ECLASS, new LinkedHashSet(eStructuralFeatures), "self.eStructuralFeatures->asOrderedSet()");
        ocl.assertQueryOCLNotEquals(EcorePackage.Literals.ECLASS, new LinkedHashSet(eStructuralFeatures), "self.eStructuralFeatures->asOrderedSet()->reverse()");
        ocl.assertQueryOCLNotEquals(EcorePackage.Literals.ECLASS, new LinkedHashSet(eStructuralFeatures), "self.eStructuralFeatures->asSequence()");
        ocl.assertQueryOCLNotEquals(EcorePackage.Literals.ECLASS, new LinkedHashSet(eStructuralFeatures), "self.eStructuralFeatures->asSet()");
        @NonNull EList eStructuralFeatures2 = ClassUtil.nullFree((EList)eStructuralFeatures);
        ocl.assertQueryOCLEquals(EcorePackage.Literals.ECLASS, new BagImpl((Iterable)eStructuralFeatures2), "self.eStructuralFeatures->asBag()");
        ocl.assertQueryOCLNotEquals(EcorePackage.Literals.ECLASS, new BagImpl((Iterable)eStructuralFeatures2), "self.eStructuralFeatures->asOrderedSet()");
        ocl.assertQueryOCLNotEquals(EcorePackage.Literals.ECLASS, new BagImpl((Iterable)eStructuralFeatures2), "self.eStructuralFeatures->asSequence()");
        ocl.assertQueryOCLNotEquals(EcorePackage.Literals.ECLASS, new BagImpl((Iterable)eStructuralFeatures2), "self.eStructuralFeatures->asSet()");
        ocl.assertQueryOCLEquals(EcorePackage.Literals.ECLASS, CollectionUtil.createNewBag((Collection)eStructuralFeatures), "self.eStructuralFeatures->asBag()");
        ocl.assertQueryOCLNotEquals(EcorePackage.Literals.ECLASS, CollectionUtil.createNewBag((Collection)eStructuralFeatures), "self.eStructuralFeatures->asOrderedSet()");
        ocl.assertQueryOCLNotEquals(EcorePackage.Literals.ECLASS, CollectionUtil.createNewBag((Collection)eStructuralFeatures), "self.eStructuralFeatures->asSequence()");
        ocl.assertQueryOCLNotEquals(EcorePackage.Literals.ECLASS, CollectionUtil.createNewBag((Collection)eStructuralFeatures), "self.eStructuralFeatures->asSet()");
        ocl.dispose();
    }

    @Test
    public void test_ecore_number_equality() {
        TestOCL ocl = this.createOCL();
        ocl.assertQueryOCLEquals(null, (byte)-1, "-1");
        ocl.assertQueryOCLEquals(null, Character.valueOf('\u00ff'), "255");
        ocl.assertQueryOCLEquals(null, (short)255, "255");
        ocl.assertQueryOCLEquals(null, 255, "255");
        ocl.assertQueryOCLEquals(null, 255L, "255");
        ocl.assertQueryOCLEquals(null, BigInteger.valueOf(255L), "255");
        ocl.assertQueryOCLEquals(null, Float.valueOf(255.0f), "255");
        ocl.assertQueryOCLEquals(null, 255.0, "255");
        ocl.assertQueryOCLEquals(null, BigDecimal.valueOf(255L), "255");
        ocl.assertQueryOCLNotEquals(null, (byte)-1, "254");
        ocl.assertQueryOCLNotEquals(null, Character.valueOf('\u00ff'), "254");
        ocl.assertQueryOCLNotEquals(null, (short)255, "254");
        ocl.assertQueryOCLNotEquals(null, 255, "254");
        ocl.assertQueryOCLNotEquals(null, 255L, "254");
        ocl.assertQueryOCLNotEquals(null, BigInteger.valueOf(255L), "254");
        ocl.assertQueryOCLNotEquals(null, Float.valueOf(255.0f), "255.1");
        ocl.assertQueryOCLNotEquals(null, 255.0, "255.1");
        ocl.assertQueryOCLNotEquals(null, BigDecimal.valueOf(255L), "255.1");
        ocl.dispose();
    }
}

