/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.test.xtext;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import junit.framework.TestCase;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.codegen.ecore.generator.Generator;
import org.eclipse.emf.codegen.ecore.generator.GeneratorAdapterFactory;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.generator.GenModelGeneratorAdapterFactory;
import org.eclipse.emf.codegen.ecore.genmodel.util.GenModelUtil;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.presentation.EcoreEditor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.mwe.core.ConfigurationException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.dynamic.JavaFileUtil;
import org.eclipse.ocl.examples.codegen.oclinecore.OCLinEcoreGeneratorAdapterFactory;
import org.eclipse.ocl.examples.pivot.tests.PivotTestSuite;
import org.eclipse.ocl.examples.pivot.tests.TestOCL;
import org.eclipse.ocl.examples.xtext.tests.TestCaseAppender;
import org.eclipse.ocl.examples.xtext.tests.TestUIUtil;
import org.eclipse.ocl.examples.xtext.tests.TestUtil;
import org.eclipse.ocl.pivot.internal.resource.StandaloneProjectMap;
import org.eclipse.ocl.pivot.oclstdlib.OCLstdlibPackage;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.LabelUtil;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.intro.IIntroManager;
import org.eclipse.uml2.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.editor.presentation.UMLEditor;
import org.eclipse.xtext.diagnostics.ExceptionDiagnostic;
import org.eclipse.xtext.util.EmfFormatter;
import org.osgi.framework.Bundle;

public class UsageTests
extends PivotTestSuite {
    public Logger log;

    public void checkResourceSet(ResourceSet resourceSet) throws ConfigurationException {
        int errorCount = 0;
        for (Resource aResource : resourceSet.getResources()) {
            EList warnings;
            EList errors = aResource.getErrors();
            if (errors.size() > 0) {
                for (Resource.Diagnostic error : errors) {
                    if (error instanceof ExceptionDiagnostic) {
                        this.log.error((Object)("Error for '" + aResource.getURI() + "'"), (Throwable)((ExceptionDiagnostic)error).getException());
                    } else {
                        this.log.error((Object)(error + " for '" + aResource.getURI() + "'"));
                    }
                    ++errorCount;
                }
            }
            if ((warnings = aResource.getWarnings()).size() <= 0) continue;
            for (Resource.Diagnostic warning : warnings) {
                if (warning instanceof ExceptionDiagnostic) {
                    this.log.warn((Object)("Warning for '" + aResource.getURI() + "'"), (Throwable)((ExceptionDiagnostic)warning).getException());
                    continue;
                }
                this.log.warn((Object)(warning + " for '" + aResource.getURI() + "'"));
            }
        }
        if (errorCount > 0) {
            throw new RuntimeException("Errors in ResourceSet");
        }
    }

    @Override
    protected @NonNull TestOCL createOCL() {
        return new TestOCL(this.getTestPackageName(), this.getName(), (ProjectManager)UsageTests.getProjectMap());
    }

    protected void getCompilationUnits(@NonNull List<JavaFileObject> compilationUnits, @NonNull File directory) throws Exception {
        File[] files = directory.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    this.getCompilationUnits(compilationUnits, file);
                } else if (file.isFile()) {
                    compilationUnits.add(new JavaSourceFileObject(file.toURI()));
                }
                ++n2;
            }
        }
    }

    protected void getCompilationUnits(@NonNull List<JavaFileObject> compilationUnits, @NonNull IContainer container) throws CoreException {
        IResource[] iResourceArray = container.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource member = iResourceArray[n2];
            if (member instanceof IContainer) {
                this.getCompilationUnits(compilationUnits, (IContainer)member);
            } else if (member instanceof IFile && member.getFileExtension().equals("java")) {
                java.net.URI locationURI = member.getLocationURI();
                compilationUnits.add(new JavaSourceFileObject(locationURI));
            }
            ++n2;
        }
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.log = Logger.getLogger(UsageTests.class);
        TestUtil.doOCLinEcoreSetup();
        UsageTests.configurePlatformResources();
    }

    @Override
    protected void tearDown() throws Exception {
        this.log = null;
        this.uninstall();
        super.tearDown();
    }

    public static @NonNull String createClassPath(@NonNull List<String> projectNames) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        String pathSeparator = null;
        StringBuilder s = new StringBuilder();
        for (String projectName : projectNames) {
            URI uri;
            Bundle bundle;
            IPath location;
            String projectPath = null;
            IProject project = root.getProject(projectName);
            if (project != null && (location = project.getLocation()) != null) {
                projectPath = String.valueOf(location.toString()) + "/";
            }
            if (projectPath == null && (bundle = Platform.getBundle((String)projectName)) != null) {
                projectPath = bundle.getLocation();
            }
            if (projectPath == null) continue;
            if (projectPath.startsWith("reference:")) {
                projectPath = projectPath.substring(10);
            }
            if ((uri = URI.createURI((String)projectPath)).isFile()) {
                String fileString = uri.toFileString();
                assert (fileString != null);
                projectPath = fileString.replace("\\", "/");
            }
            assert (projectPath != null);
            if (projectPath.endsWith("/")) {
                projectPath = String.valueOf(projectPath) + "bin";
            }
            if (pathSeparator != null) {
                s.append(pathSeparator);
            } else {
                pathSeparator = System.getProperty("path.separator");
            }
            s.append(projectPath);
        }
        return s.toString();
    }

    public @NonNull String createGenModelContent(@NonNull String testProjectPath, @NonNull String fileName, @Nullable Map<@NonNull String, @Nullable String> genOptions) {
        String interfacePackageSuffix = genOptions != null ? genOptions.get("interfacePackageSuffix") : null;
        String metaDataPackageSuffix = genOptions != null ? genOptions.get("metaDataPackageSuffix") : null;
        String usedGenPackages = genOptions != null ? genOptions.get("usedGenPackages") : null;
        StringBuilder s = new StringBuilder();
        s.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        s.append("<genmodel:GenModel xmi:version=\"2.0\"\n");
        s.append("    xmlns:xmi=\"http://www.omg.org/XMI\"\n");
        s.append("    xmlns:ecore=\"http://www.eclipse.org/emf/2002/Ecore\"\n");
        s.append("    xmlns:genmodel=\"http://www.eclipse.org/emf/2002/GenModel\"\n");
        s.append("    modelDirectory=\"/" + testProjectPath + "/src-gen\"\n");
        s.append("    modelPluginID=\"" + fileName + "." + fileName + "\"\n");
        s.append("    modelName=\"" + fileName + "\"\n");
        s.append("    importerID=\"org.eclipse.emf.importer.ecore\"\n");
        s.append("    complianceLevel=\"8.0\"\n");
        s.append("    operationReflection=\"true\"\n");
        s.append("    copyrightFields=\"false\"\n");
        s.append("    bundleManifest=\"false\"\n");
        s.append("    pluginKey=\"\"\n");
        s.append("    usedGenPackages=\"");
        if (usedGenPackages != null) {
            s.append(String.valueOf(usedGenPackages) + " ");
        }
        s.append("platform:/resource/org.eclipse.ocl.pivot/model/oclstdlib.genmodel#//oclstdlib\"\n");
        s.append("    updateClasspath=\"false\">\n");
        s.append("  <genAnnotations source=\"http://www.eclipse.org/OCL/GenModel\">\n");
        s.append("    <details key=\"Use Delegates\" value=\"false\"/>\n");
        s.append("    <details key=\"Use Null Annotations\" value=\"true\"/>\n");
        s.append("  </genAnnotations>\n");
        s.append("  <foreignModel>" + fileName + ".ecore</foreignModel>\n");
        s.append("  <genPackages prefix=\"" + fileName + "\"\n");
        s.append("    disposableProviderFactory=\"true\"\n");
        s.append("    ecorePackage=\"" + fileName + ".ecore#/\"\n");
        if (interfacePackageSuffix != null) {
            s.append("    interfacePackageSuffix=\"" + interfacePackageSuffix + "\"\n");
        }
        if (metaDataPackageSuffix != null) {
            s.append("    metaDataPackageSuffix=\"" + metaDataPackageSuffix + "\"\n");
        }
        s.append("  />\n");
        s.append("</genmodel:GenModel>\n");
        s.append("\n");
        return s.toString();
    }

    public @NonNull URI createGenModelFile(String fileName, String fileContent) throws IOException {
        File file = new File(this.getProjectFile(), fileName);
        FileWriter writer = new FileWriter(file);
        ((Writer)writer).append(fileContent);
        ((Writer)writer).close();
        return this.getProjectFileURI(fileName);
    }

    protected @NonNull URI createModels(@NonNull String testProjectName, @NonNull String testFileStem, @Nullable String oclinecoreFile, @NonNull String genmodelFile) throws CoreException, IOException {
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            IProject project = TestUtil.createJavaProject(testProjectName);
            TestUtil.createManifest(project, testProjectName, null, null, null);
        }
        OCL ocl2 = OCL.newInstance((ProjectManager)UsageTests.getProjectMap());
        if (oclinecoreFile != null) {
            this.createEcoreFile(ocl2, testFileStem, oclinecoreFile);
        }
        URI genModelURI = this.createGenModelFile(String.valueOf(testFileStem) + ".genmodel", genmodelFile);
        ocl2.dispose();
        return genModelURI;
    }

    protected boolean doCompile(@NonNull String testProjectName, String ... extraClasspathProjects) throws Exception {
        ArrayList<@NonNull String> classpathProjects = new ArrayList<String>();
        classpathProjects.add("org.eclipse.emf.common");
        classpathProjects.add("org.eclipse.emf.ecore");
        classpathProjects.add("org.eclipse.jdt.annotation");
        classpathProjects.add("org.eclipse.ocl.pivot");
        classpathProjects.add("org.eclipse.osgi");
        String[] stringArray = extraClasspathProjects;
        int n = extraClasspathProjects.length;
        int n2 = 0;
        while (n2 < n) {
            String extraClasspathProject = stringArray[n2];
            classpathProjects.add(extraClasspathProject);
            ++n2;
        }
        ArrayList<@NonNull JavaFileObject> compilationUnits = new ArrayList<JavaFileObject>();
        Object context = null;
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IProject project = workspace.getRoot().getProject(testProjectName);
            if (project != null) {
                this.getCompilationUnits(compilationUnits, (IContainer)project);
            }
            context = project;
        } else {
            File dir = new File("src-gen/" + testProjectName);
            this.getCompilationUnits(compilationUnits, dir);
            context = dir;
        }
        JavaFileUtil.compileClasses(compilationUnits, (String)String.valueOf(context), (String)"bin", classpathProjects);
        return true;
    }

    public static void doDelete(@NonNull String testProjectName) throws Exception {
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            TestUIUtil.deleteIProject(testProjectName);
        } else {
            File dir = new File("src-gen/" + testProjectName);
            if (dir.exists()) {
                TestUtil.deleteDirectory(dir);
            }
        }
    }

    protected void doGenModel(@NonNull String testProjectName, @NonNull URI genmodelURI) throws Exception {
        BasicMonitor monitor;
        ResourceSetImpl resourceSetImpl;
        Map uriResourceMap;
        TestOCL ocl = this.createOCL();
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            TestUIUtil.suppressGitPrefixPopUp();
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IProject project = workspace.getRoot().getProject(testProjectName);
            if (!project.exists()) {
                project.create(null);
                project.open(null);
            }
        }
        URI fileURI = genmodelURI;
        ResourceSet resourceSet = ocl.getResourceSet();
        ProjectManager projectMap = ocl.getProjectManager();
        projectMap.configure(resourceSet, StandaloneProjectMap.LoadFirstStrategy.INSTANCE, StandaloneProjectMap.MapToFirstConflictHandler.INSTANCE);
        resourceSet.getPackageRegistry().put((Object)"http://www.eclipse.org/emf/2002/GenModel", (Object)org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage.eINSTANCE);
        resourceSet.getPackageRegistry().put((Object)"http://www.eclipse.org/uml2/2.2.0/GenModel", (Object)GenModelPackage.eINSTANCE);
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("genmodel", new EcoreResourceFactoryImpl());
        GeneratorAdapterFactory.Descriptor.Registry.INSTANCE.addDescriptor("http://www.eclipse.org/emf/2002/GenModel", GenModelGeneratorAdapterFactory.DESCRIPTOR);
        GeneratorAdapterFactory.Descriptor.Registry.INSTANCE.addDescriptor("http://www.eclipse.org/emf/2002/GenModel", OCLinEcoreGeneratorAdapterFactory.DESCRIPTOR);
        if (resourceSet instanceof ResourceSetImpl && (uriResourceMap = (resourceSetImpl = (ResourceSetImpl)resourceSet).getURIResourceMap()) != null) {
            uriResourceMap.clear();
        }
        resourceSet.getResources().clear();
        Resource resource = resourceSet.getResource(fileURI, true);
        this.checkResourceSet(resourceSet);
        EObject eObject = (EObject)resource.getContents().get(0);
        if (!(eObject instanceof GenModel)) {
            throw new ConfigurationException("No GenModel found in '" + resource.getURI() + "'");
        }
        GenModel genModel = (GenModel)eObject;
        genModel.reconcile();
        this.checkResourceSet(resourceSet);
        genModel.setValidateModel(true);
        genModel.setForceOverwrite(false);
        genModel.setCanGenerate(true);
        genModel.setBundleManifest(false);
        genModel.setUpdateClasspath(false);
        Diagnostic diagnostic = genModel.diagnose();
        if (diagnostic.getSeverity() != 0) {
            UsageTests.fail((String)diagnostic.toString());
        }
        String oldGenModelStr = EmfFormatter.objToStr((Object)genModel, (EStructuralFeature[])new EStructuralFeature[0]);
        Generator generator = GenModelUtil.createGenerator((GenModel)genModel);
        diagnostic = generator.generate((Object)genModel, (Object)"org.eclipse.emf.codegen.ecore.genmodel.generator.ModelProject", (Monitor)(monitor = new BasicMonitor()));
        if (diagnostic.getSeverity() != 0) {
            String s = PivotUtil.formatDiagnostics((Diagnostic)diagnostic, (String)"\n");
            UsageTests.fail((String)("Generation failure" + s));
        }
        genModel.reconcile();
        String newGenModelStr = EmfFormatter.objToStr((Object)genModel, (EStructuralFeature[])new EStructuralFeature[0]);
        TestCase.assertEquals((String)oldGenModelStr, (String)newGenModelStr);
    }

    public void testBug370824() throws Exception {
        TestOCL ocl = this.createOCL();
        String testFileStem = "Bug370824";
        String testProjectName = "bug370824";
        String testProjectPath = EMFPlugin.IS_ECLIPSE_RUNNING ? testProjectName : "org.eclipse.ocl.examples.xtext.tests";
        String oclinecoreFile = "package bug370824 : bug370824 = 'http://bug370824'\n{\n    class Clase1\n    {\n        invariant : self.name.size() > 0;\n        attribute name : String[?] { ordered };\n    }\n}\n";
        String genmodelFile = this.createGenModelContent(testProjectPath, "Bug370824", null);
        URI genModelURI = this.createModels(testProjectName, testFileStem, oclinecoreFile, genmodelFile);
        this.doGenModel(testProjectPath, genModelURI);
        ocl.dispose();
    }

    public void testBug409650() throws Exception {
        TestOCL ocl = this.createOCL();
        String testFileStem = "Bug409650";
        String testProjectName = "bug409650";
        String testProjectPath = EMFPlugin.IS_ECLIPSE_RUNNING ? testProjectName : "org.eclipse.ocl.examples.xtext.tests";
        String oclinecoreFile = "package bug409650 : bug409650 = 'http://bug409650'\n{\n    class Clase1\n    {\n        invariant : self.name.size() > 0;\n        attribute name : String[?] { ordered };\n        operation copy(b : Boolean) : Boolean { body: b; }\n        operation complement(b : Boolean) : Boolean { body: not b; }\n        operation myPrefixedName(s1 : String, s2 : String) : String { body: s1 + name + s2; }\n        operation me() : Clase1 { body: self.oclAsType(Clase1); }\n    }\n}\n";
        String genmodelFile = this.createGenModelContent(testProjectPath, "Bug409650", null);
        UsageTests.doDelete(testProjectName);
        URI genModelURI = this.createModels(testProjectPath, testFileStem, oclinecoreFile, genmodelFile);
        this.doGenModel(testProjectPath, genModelURI);
        this.doCompile(testProjectName, new String[0]);
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            String qualifiedPackageName = String.valueOf(testProjectName) + "." + testFileStem + "Package";
            EPackage ePackage = this.doLoadPackage(qualifiedPackageName);
            EClass eClass = (EClass)ePackage.getEClassifier("Clase1");
            EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature("name");
            EFactory eFactory = ePackage.getEFactoryInstance();
            EObject eObject = eFactory.create(eClass);
            ocl.assertQueryTrue(eObject, "name = null");
            ocl.assertQueryTrue(eObject, "complement(true) = false");
            eObject.eSet(eStructuralFeature, (Object)"testing");
            ocl.assertQueryFalse(eObject, "name = null");
            ocl.assertQueryTrue(eObject, "name = 'testing'");
            ocl.assertQueryEquals(eObject, "XtestingY", "self.myPrefixedName('X', 'Y')");
            ocl.assertQueryEquals(eObject, eObject, "self.me()");
        }
        ocl.dispose();
    }

    public void testEcoreTypes412736() throws Exception {
        TestOCL ocl = this.createOCL();
        String testFileStem = "Bug412736";
        String testProjectName = "bug412736";
        String testProjectPath = EMFPlugin.IS_ECLIPSE_RUNNING ? testProjectName : "org.eclipse.ocl.examples.xtext.tests";
        String oclinecoreFile = "import ecore : 'http://www.eclipse.org/emf/2002/Ecore#/';\npackage bug412736 : bug412736 = 'http://bug412736'\n{\n    datatype ENumber : 'java.lang.Number' { serializable };\n    class EcoreDataTypes\n    {\n        attribute eBigDecimal : ecore::EBigDecimal { derived readonly volatile } { derivation: negEBigDecimal(1); }\n        attribute eBigInteger : ecore::EBigInteger { derived readonly volatile } { derivation: negEBigInteger(1); }\n        attribute eBooleanObject : ecore::EBooleanObject { derived readonly volatile } { derivation: notEBooleanObject(true); }\n        attribute eBoolean : ecore::EBoolean { derived readonly volatile } { derivation: notEBoolean(true); }\n        attribute eCharacterObject : ecore::ECharacterObject { derived readonly volatile } { derivation: negECharacterObject(1); }\n        attribute eChar : ecore::EChar { derived readonly volatile } { derivation: negEChar(1); }\n        attribute eDoubleObject : ecore::EDoubleObject { derived readonly volatile } { derivation: negEDoubleObject(1); }\n        attribute eDouble : ecore::EDouble { derived readonly volatile } { derivation: negEDouble(1); }\n        attribute eFloatObject : ecore::EFloatObject { derived readonly volatile } { derivation: negEFloatObject(1); }\n        attribute eFloat : ecore::EFloat { derived readonly volatile } { derivation: negEFloat(1); }\n        attribute eIntegerObject : ecore::EIntegerObject { derived readonly volatile } { derivation: negEIntegerObject(1); }\n        attribute eInt : ecore::EInt { derived readonly volatile } { derivation: negEInt(1); }\n        attribute eLongObject : ecore::ELongObject { derived readonly volatile } { derivation: negELongObject(1); }\n        attribute eLong : ecore::ELong { derived readonly volatile } { derivation: negELong(1); }\n        attribute eShortObject : ecore::EShortObject { derived readonly volatile } { derivation: negEShortObject(1); }\n        attribute eShort : ecore::EShort { derived readonly volatile } { derivation: negEShort(1); }\n        attribute eString : ecore::EString { derived readonly volatile } { derivation: upCase('abc'); }\n        operation negEBigDecimal(b : ecore::EBigDecimal) : ecore::EBigDecimal { body: -b; }\n        operation negEBigInteger(b : ecore::EBigInteger) : ecore::EBigInteger { body: -b; }\n        operation negEChar(b : ecore::EChar) : ecore::EChar { body: -b; }\n        operation negECharacterObject(b : ecore::ECharacterObject) : ecore::ECharacterObject { body: -b; }\n        operation negEDouble(b : ecore::EDouble) : ecore::EDouble { body: -b; }\n        operation negEDoubleObject(b : ecore::EDoubleObject) : ecore::EDoubleObject { body: -b; }\n        operation negEFloat(b : ecore::EFloat) : ecore::EFloat { body: -b; }\n        operation negEFloatObject(b : ecore::EFloatObject) : ecore::EFloatObject { body: -b; }\n        operation negEInt(b : ecore::EInt) : ecore::EInt { body: -b; }\n        operation negEIntegerObject(b : ecore::EIntegerObject) : ecore::EIntegerObject { body: -b; }\n        operation negELong(b : ecore::ELong) : ecore::ELong { body: -b; }\n        operation negELongObject(b : ecore::ELongObject) : ecore::ELongObject { body: -b; }\n        operation negEShort(b : ecore::EShort) : ecore::EShort { body: -b; }\n        operation negEShortObject(b : ecore::EShortObject) : ecore::EShortObject { body: -b; }\n        operation notEBoolean(b : ecore::EBoolean) : ecore::EBoolean { body: not b; }\n        operation notEBooleanObject(b : ecore::EBooleanObject) : ecore::EBooleanObject { body: not b; }\n        operation upCase(b : ecore::EString) : ecore::EString { body: b.toUpper(); }\n    }\n}\n";
        String genmodelFile = this.createGenModelContent(testProjectPath, "Bug412736", null);
        UsageTests.doDelete(testProjectName);
        URI genModelURI = this.createModels(testProjectPath, testFileStem, oclinecoreFile, genmodelFile);
        this.doGenModel(testProjectPath, genModelURI);
        this.doCompile(testProjectName, new String[0]);
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            String qualifiedPackageName = String.valueOf(testProjectName) + "." + testFileStem + "Package";
            EPackage ePackage = this.doLoadPackage(qualifiedPackageName);
            EClass eClass = (EClass)ePackage.getEClassifier("EcoreDataTypes");
            EFactory eFactory = ePackage.getEFactoryInstance();
            EObject eObject = eFactory.create(eClass);
            ocl.assertQueryTrue(eObject, "eBigInteger = eBigDecimal");
            ocl.assertQueryTrue(eObject, "eChar = eCharacterObject");
            ocl.assertQueryTrue(eObject, "eBoolean = eBooleanObject");
            ocl.assertQueryTrue(eObject, "eDouble = eDoubleObject");
            ocl.assertQueryTrue(eObject, "eFloat = eFloatObject");
            ocl.assertQueryTrue(eObject, "eInt = eIntegerObject");
            ocl.assertQueryTrue(eObject, "eLong = eLongObject");
            ocl.assertQueryTrue(eObject, "eShort = eShortObject");
            ocl.assertQueryTrue(eObject, "eString = 'ABC'");
        }
        ocl.dispose();
    }

    public void testEnumTypes412685() throws Exception {
        TestOCL ocl = this.createOCL();
        EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/ocl/2015/Library", (Object)OCLstdlibPackage.eINSTANCE);
        String testFileStem = "Bug412685";
        String testProjectName = "bug412685";
        String testProjectPath = EMFPlugin.IS_ECLIPSE_RUNNING ? testProjectName : "org.eclipse.ocl.examples.xtext.tests";
        String oclinecoreFile = "import ecore : 'http://www.eclipse.org/emf/2002/Ecore#/';\npackage bug412685 : bug412685 = 'http://bug412685'\n{\n    enum Color { serializable } {\n    \tliteral BLACK;\n    \tliteral WHITE;\n    }\n    class EnumTypes\n    {\n        attribute eBlack : Color = 'BLACK' { readonly };\n        attribute eWhite : Color = 'WHITE' { readonly };\n        attribute eColor : Color { derived readonly volatile } { derivation: otherColor(Color::BLACK); }\n        operation opaqueColor(eColor : Color) : OclAny { body: eColor; }\n        operation otherColor(eColor : Color) : Color { body: if eColor = Color::BLACK then Color::WHITE else Color::BLACK endif; }\n    }\n}\n";
        String genmodelFile = this.createGenModelContent(testProjectPath, testFileStem, null);
        UsageTests.doDelete(testProjectName);
        URI genModelURI = this.createModels(testProjectName, testFileStem, oclinecoreFile, genmodelFile);
        this.doGenModel(testProjectPath, genModelURI);
        this.doCompile(testProjectName, new String[0]);
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            String qualifiedPackageName = String.valueOf(testProjectName) + "." + testFileStem + "Package";
            EPackage ePackage = this.doLoadPackage(qualifiedPackageName);
            EClass eClass = (EClass)ePackage.getEClassifier("EnumTypes");
            EFactory eFactory = ePackage.getEFactoryInstance();
            EObject eObject = eFactory.create(eClass);
            ocl.assertQueryTrue(eObject, "let aWhite : OclAny = opaqueColor(eWhite) in eColor = aWhite");
            ocl.assertQueryTrue(eObject, "let aWhite : OclAny = eWhite.oclAsType(OclAny) in eColor = aWhite");
            ocl.assertQueryTrue(eObject, "eColor = eWhite");
            ocl.assertQueryTrue(eObject, "eColor = Color::WHITE");
        }
        ocl.dispose();
    }

    public void testTemplateTypes471201() throws Exception {
        TestOCL ocl = this.createOCL();
        EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/ocl/2015/Library", (Object)OCLstdlibPackage.eINSTANCE);
        String testFileStem = "Bug471201";
        String testProjectName = "bug471201";
        String testProjectPath = EMFPlugin.IS_ECLIPSE_RUNNING ? testProjectName : "org.eclipse.ocl.examples.xtext.tests";
        String oclinecoreFile = "import ecore : 'http://www.eclipse.org/emf/2002/Ecore#/';\npackage bug471201 : bug471201 = 'http://bug471201'\n{\n    class NamedElement {}\n    class LookupEnvironment\n    {\n\t\toperation(NE extends NamedElement) addElements(elements : NE[*] { ordered }) : LookupEnvironment[1]\n\t\t{\n\t\t\tbody: if elements->notEmpty() then addElements(OrderedSet(NamedElement){}) else self endif;\n\t\t}\n    }\n}\n";
        String genmodelFile = this.createGenModelContent(testProjectPath, testFileStem, null);
        UsageTests.doDelete(testProjectName);
        URI genModelURI = this.createModels(testProjectName, testFileStem, oclinecoreFile, genmodelFile);
        this.doGenModel(testProjectPath, genModelURI);
        this.doCompile(testProjectName, new String[0]);
        ocl.dispose();
    }

    public void testCSE() throws Exception {
        TestOCL ocl = this.createOCL();
        String testFileStem = "CSEs";
        String testProjectName = "cses";
        String testProjectPath = EMFPlugin.IS_ECLIPSE_RUNNING ? testProjectName : "org.eclipse.ocl.examples.xtext.tests";
        String oclinecoreFile = "import ecore : 'http://www.eclipse.org/emf/2002/Ecore#/';\npackage cses : cses = 'http://cses'\n{\n    class CSEs\n    {\n        operation test(a : ecore::EInt, b : ecore::EInt, c : ecore::EInt) : ecore::EInt { body: if a + b + c > 0 then a + b + c else a + b endif; }\n    }\n}\n";
        HashMap<@NonNull String, @Nullable String> genOptions = new HashMap<String, String>();
        genOptions.put("interfacePackageSuffix", "coreI");
        genOptions.put("metaDataPackageSuffix", "coreM");
        String genmodelFile = this.createGenModelContent(testProjectPath, testFileStem, genOptions);
        UsageTests.doDelete(testProjectName);
        URI genModelURI = this.createModels(testProjectPath, testFileStem, oclinecoreFile, genmodelFile);
        this.doGenModel(testProjectPath, genModelURI);
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            this.doCompile(testProjectName, new String[0]);
            String qualifiedPackageName = String.valueOf(testProjectName) + ".coreM." + testFileStem + "Package";
            EPackage ePackage = this.doLoadPackage(qualifiedPackageName);
            EClass eClass = (EClass)ePackage.getEClassifier("CSEs");
            EFactory eFactory = ePackage.getEFactoryInstance();
            EObject eObject = eFactory.create(eClass);
            ocl.assertQueryEquals(eObject, 6, "test(3, 2, 1)");
            ocl.assertQueryEquals(eObject, -5, "test(3, -8, 1)");
        }
        ocl.dispose();
    }

    public void testEvaluators() throws Exception {
        TestOCL ocl = this.createOCL();
        String testFileStem = "Evaluators";
        String testProjectName = "evaluators";
        String testProjectPath = EMFPlugin.IS_ECLIPSE_RUNNING ? testProjectName : "org.eclipse.ocl.examples.xtext.tests";
        String oclinecoreFile = "import ecore : 'http://www.eclipse.org/emf/2002/Ecore#/';\npackage evaluators : evaluators = 'http://evaluators'\n{\n    class Evaluators\n    {\n        attribute name : String[?];\n        operation test() : String { body: \n        let severity : String[1] = 'testString'.replaceFirst('xx', 'yy') \n        in if severity = '' \n        then '' \n        else \n        'testString'.replaceAll('z1','z2') \n        endif; }\n    }\n}\n";
        String genmodelFile = this.createGenModelContent(testProjectPath, testFileStem, null);
        UsageTests.doDelete(testProjectName);
        URI genModelURI = this.createModels(testProjectPath, testFileStem, oclinecoreFile, genmodelFile);
        this.doGenModel(testProjectPath, genModelURI);
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            this.doCompile(testProjectName, new String[0]);
            String qualifiedPackageName = String.valueOf(testProjectName) + "." + testFileStem + "Package";
            EPackage ePackage = this.doLoadPackage(qualifiedPackageName);
            EClass eClass = (EClass)ePackage.getEClassifier("Evaluators");
            EFactory eFactory = ePackage.getEFactoryInstance();
            EObject eObject = eFactory.create(eClass);
            ocl.assertQueryEquals(eObject, "testString", "test()");
        }
        ocl.dispose();
    }

    public void testSysML_QUDV() throws Exception {
        TestOCL ocl = this.createOCL();
        try {
            EObject eObject;
            EFactory eFactory;
            EClass eClass;
            EPackage ePackage;
            String qualifiedPackageName;
            String testProjectName = "SysML_ValueTypes_QUDV";
            String testProjectPath = "org.eclipse.ocl.examples.xtext.tests";
            if (EMFPlugin.IS_ECLIPSE_RUNNING) {
                UsageTests.doDelete("org.eclipse.ocl.examples.xtext.tests");
                @NonNull URI ecoreURI = URI.createPlatformPluginURI((String)"/org.eclipse.ocl.examples.xtext.tests/model/SysML_ValueTypes_QUDV.ecore", (boolean)true);
                @NonNull URI genModelURI = URI.createPlatformPluginURI((String)"/org.eclipse.ocl.examples.xtext.tests/model/SysML_ValueTypes_QUDV.genmodel", (boolean)true);
                IProject project = TestUtil.createJavaProject("org.eclipse.ocl.examples.xtext.tests");
                TestUtil.createClassPath(project, new String[]{"src-gen"});
                TestUtil.createManifest(project, testProjectPath, new String[]{"org.eclipse.osgi", "org.eclipse.emf.ecore", "org.eclipse.jdt.annotation", "org.eclipse.ocl.pivot"}, null, new String[]{"SysML_ValueTypes_QUDV", "SysML_ValueTypes_QUDV.PrimitiveValueTypes", "SysML_ValueTypes_QUDV.QUDV", "SysML_ValueTypes_QUDV.UnitAndQuantityKind"});
                TestUtil.copyIFile((OCL)ocl, genModelURI, project, "model/SysML_ValueTypes_QUDV.genmodel");
                TestUtil.copyIFile((OCL)ocl, ecoreURI, project, "model/SysML_ValueTypes_QUDV.ecore");
            } else {
                UsageTests.doDelete(testProjectName);
            }
            @NonNull URI genModelURI = URI.createPlatformResourceURI((String)"/org.eclipse.ocl.examples.xtext.tests/model/SysML_ValueTypes_QUDV.genmodel", (boolean)true);
            if (!ocl.getResourceSet().getURIConverter().exists(genModelURI, null)) {
                return;
            }
            this.doGenModel(testProjectPath, genModelURI);
            if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
                this.doCompile(testProjectName, new String[0]);
                qualifiedPackageName = String.valueOf(testProjectName) + ".QUDV.QUDVPackage";
                ePackage = this.doLoadPackage(qualifiedPackageName);
                eClass = (EClass)ePackage.getEClassifier("DerivedQuantityKind");
                eFactory = ePackage.getEFactoryInstance();
                eObject = eFactory.create(eClass);
                ocl.assertQueryTrue(eObject, "dependsOnQuantityKinds() <> null");
            }
            if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
                qualifiedPackageName = String.valueOf(testProjectName) + ".PrimitiveValueTypes.PrimitiveValueTypesPackage";
                ePackage = this.doLoadPackage(qualifiedPackageName);
                eClass = (EClass)ePackage.getEClassifier("Complex");
                eFactory = ePackage.getEFactoryInstance();
                eObject = eFactory.create(eClass);
                ocl.assertQueryTrue(eObject, "imaginaryPart = realPart");
                ocl.assertQueryTrue(eObject, "oclType() <> null");
                ocl.assertQueryTrue(eObject, "oclType().oclIsKindOf(OclAny)");
            }
        }
        finally {
            ocl.dispose();
        }
    }

    public void testCodegenCompany() throws Exception {
        TestOCL ocl = this.createOCL();
        try {
            String testProjectName = "codegen/company";
            String testProjectPath = "org.eclipse.ocl.examples.xtext.tests";
            if (EMFPlugin.IS_ECLIPSE_RUNNING) {
                UsageTests.doDelete("org.eclipse.ocl.examples.xtext.tests");
                @NonNull URI ecoreURI = URI.createPlatformPluginURI((String)"/org.eclipse.ocl.examples.xtext.tests/model/Company.ecore", (boolean)true);
                @NonNull URI genModelURI = URI.createPlatformPluginURI((String)"/org.eclipse.ocl.examples.xtext.tests/model/CodeGenCompany.genmodel", (boolean)true);
                IProject project = TestUtil.createJavaProject("org.eclipse.ocl.examples.xtext.tests");
                TestUtil.createClassPath(project, new String[]{"src-gen"});
                TestUtil.createManifest(project, testProjectPath, new String[]{"org.eclipse.osgi", "org.eclipse.emf.ecore", "org.eclipse.jdt.annotation", "org.eclipse.ocl.pivot"}, null, new String[]{"company"});
                TestUtil.copyIFile((OCL)ocl, genModelURI, project, "model/CodeGenCompany.genmodel");
                TestUtil.copyIFile((OCL)ocl, ecoreURI, project, "model/Company.ecore");
            } else {
                UsageTests.doDelete(testProjectName);
            }
            @NonNull URI genModelURI = URI.createPlatformResourceURI((String)"/org.eclipse.ocl.examples.xtext.tests/model/CodeGenCompany.genmodel", (boolean)true);
            if (!ocl.getResourceSet().getURIConverter().exists(genModelURI, null)) {
                return;
            }
            this.doGenModel(testProjectPath, genModelURI);
            if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
                this.doCompile(testProjectName, new String[0]);
            }
        }
        finally {
            ocl.dispose();
        }
    }

    protected EPackage doLoadPackage(@NonNull String qualifiedModelPackageName) throws Exception {
        Class<?> testClass = Class.forName(qualifiedModelPackageName);
        Object eInstance = testClass.getDeclaredField("eINSTANCE").get(null);
        return (EPackage)eInstance;
    }

    public void testInitStatics() {
        UsageTests.assertTrue((boolean)ValueUtil.initAllStatics());
        UsageTests.assertFalse((boolean)ValueUtil.initAllStatics());
    }

    public void testOpen_Pivot_oclas() throws Exception {
        TestOCL ocl = this.createOCL();
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            TestCaseAppender.INSTANCE.uninstall();
            TestUIUtil.suppressGitPrefixPopUp();
            IWorkbench workbench = PlatformUI.getWorkbench();
            IIntroManager introManager = workbench.getIntroManager();
            introManager.closeIntro(introManager.getIntro());
            TestUIUtil.flushEvents();
            String testProjectName = "Open_Pivot";
            ResourceSetImpl resourceSet1 = new ResourceSetImpl();
            Resource resource = resourceSet1.getResource(URI.createURI((String)"http://www.eclipse.org/ocl/2015/Pivot", (boolean)true), true);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            resource.setURI(URI.createPlatformResourceURI((String)(String.valueOf(testProjectName) + "/" + "Pivot.oclas"), (boolean)true));
            resource.save((OutputStream)outputStream, null);
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IProject project = workspace.getRoot().getProject(testProjectName);
            if (!project.exists()) {
                project.create(null);
            }
            project.open(null);
            IFile file = project.getFile("Pivot.oclas");
            file.create((InputStream)new ByteArrayInputStream(outputStream.toByteArray()), true, null);
            IWorkbenchPage activePage = workbench.getActiveWorkbenchWindow().getActivePage();
            EcoreEditor openEditor = (EcoreEditor)IDE.openEditor((IWorkbenchPage)activePage, (IFile)file, (String)"org.eclipse.emf.ecore.presentation.ReflectiveEditorID", (boolean)true);
            TestUIUtil.flushEvents();
            ResourceSet resourceSet = openEditor.getEditingDomain().getResourceSet();
            EList resources = resourceSet.getResources();
            UsageTests.assertEquals((int)1, (int)resources.size());
            Resource resource2 = (Resource)ClassUtil.nonNullState((Object)((Resource)resources.get(0)));
            UsageTests.assertNoResourceErrors("Load", resource2);
            UsageTests.assertNoValidationErrors("Validate", resource2);
            openEditor.dispose();
        }
        ocl.dispose();
    }

    public void testOpen_Bug469251_uml() throws Exception {
        TestOCL ocl = this.createOCL();
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            TestCaseAppender.INSTANCE.uninstall();
            TestUIUtil.suppressGitPrefixPopUp();
            IWorkbench workbench = PlatformUI.getWorkbench();
            IIntroManager introManager = workbench.getIntroManager();
            introManager.closeIntro(introManager.getIntro());
            TestUIUtil.flushEvents();
            String testProjectName = "Open_Bug469251_uml";
            IProject iProject = TestUIUtil.createIProject(testProjectName);
            IFile profileFile = TestUIUtil.copyIFile(iProject.getFile("Bug469251.profile.uml"), this.getProjectFileURI("Bug469251.profile.uml"), null);
            IFile modelFile = TestUIUtil.copyIFile(iProject.getFile("Bug469251.uml"), this.getProjectFileURI("Bug469251.uml"), null);
            IWorkbenchPage activePage = workbench.getActiveWorkbenchWindow().getActivePage();
            UMLEditor umlEditor = (UMLEditor)IDE.openEditor((IWorkbenchPage)activePage, (IFile)modelFile, (String)"org.eclipse.uml2.uml.editor.presentation.UMLEditorID", (boolean)true);
            TestUIUtil.flushEvents();
            ResourceSet resourceSet = umlEditor.getEditingDomain().getResourceSet();
            EList resources = resourceSet.getResources();
            UsageTests.assertEquals((int)2, (int)resources.size());
            Resource umlResource = (Resource)ClassUtil.nonNullState((Object)((Resource)resources.get(0)));
            Model model = (Model)umlResource.getContents().get(0);
            Type xx = model.getOwnedType("Class1");
            UsageTests.assertNoResourceErrors("Load", umlResource);
            UsageTests.assertValidationDiagnostics("Validate", umlResource, EcorePlugin.INSTANCE.getString("_UI_GenericInvariant_diagnostic", new Object[]{"Constraint1", "\u00abStereotype1\u00bb" + LabelUtil.getLabel((Object)xx)}));
            umlEditor.dispose();
        }
        ocl.dispose();
    }

    public void testPivotMetamodelImport414855() throws Exception {
        TestOCL ocl = this.createOCL();
        String testFileStem = "Bug414855";
        String testProjectName = "bug414855";
        String testProjectPath = EMFPlugin.IS_ECLIPSE_RUNNING ? testProjectName : "org.eclipse.ocl.examples.xtext.tests";
        String oclinecoreFile = "import pivot : 'http://www.eclipse.org/ocl/2015/Pivot#/';\npackage bug414855 : bug414855 = 'http://bug414855'\n{\n    datatype MyString : 'java.lang.String' { serializable };\n    class ClassExtension extends pivot::Class {}\n}\n";
        HashMap<@NonNull String, @Nullable String> genOptions = new HashMap<String, String>();
        genOptions.put("usedGenPackages", "platform:/plugin/org.eclipse.ocl.pivot/model/Pivot.genmodel#//pivot");
        String genmodelFile = this.createGenModelContent(testProjectPath, testFileStem, genOptions);
        UsageTests.doDelete(testProjectName);
        URI genModelURI = this.createModels(testProjectPath, testFileStem, oclinecoreFile, genmodelFile);
        this.doGenModel(testProjectPath, genModelURI);
        this.doCompile(testProjectName, new String[0]);
        ocl.dispose();
    }

    public void testBug415782() throws Exception {
        TestOCL ocl = this.createOCL();
        String testFileStem = "Bug415782";
        String testProjectName = "bug415782";
        String testProjectPath = EMFPlugin.IS_ECLIPSE_RUNNING ? testProjectName : "org.eclipse.ocl.examples.xtext.tests";
        String oclinecoreFile = "import ecore : 'http://www.eclipse.org/emf/2002/Ecore#/';\npackage bug415782 : bug415782 = 'http://bug415782'\n{\n    class MyClass\n    {\n    \t   attribute manyDates : ecore::EDate[*] { ordered };\n        attribute aBool : Boolean;\n        operation anOp() : MyClass {             body : MyClass {               manyDates = OrderedSet{},\n               aBool = manyDates->isEmpty()\n             };        }\n    }\n}\n";
        String genmodelFile = this.createGenModelContent(testProjectPath, testFileStem, null);
        UsageTests.doDelete(testProjectName);
        URI genModelURI = this.createModels(testProjectPath, testFileStem, oclinecoreFile, genmodelFile);
        this.doGenModel(testProjectPath, genModelURI);
        this.doCompile(testProjectName, new String[0]);
        ocl.dispose();
    }

    public void testBug416421() throws Exception {
        TestOCL ocl = this.createOCL();
        String testFileStemA = "Bug416421A";
        String testProjectNameA = "bug416421A";
        String testProjectPathA = EMFPlugin.IS_ECLIPSE_RUNNING ? testProjectNameA : "org.eclipse.ocl.examples.xtext.tests";
        String oclinecoreFileA = "package bug416421A : bug416421A = 'example.org/bug416421A'\n{\n\tclass ClassA\n\t{\n\t\toperation getFalse() : Boolean\n\t\t{\n\t\t\tbody: false;\n\t\t}\n\t}\n}\n";
        String genmodelFileA = this.createGenModelContent(testProjectPathA, testFileStemA, null);
        String testFileStemB = "Bug416421B";
        String testProjectNameB = "bug416421B";
        String testProjectPathB = EMFPlugin.IS_ECLIPSE_RUNNING ? testProjectNameB : "org.eclipse.ocl.examples.xtext.tests";
        String oclinecoreFileB = "import bug416421A : 'Bug416421A.ecore#/';\npackage bug416421B : bug416421B = 'example.org/bug416421B'\n{\n\tclass ClassB extends bug416421A::ClassA\n\t{\n\t\toperation getTrue() : Boolean\n\t\t{\n\t\t\tbody: true;\n\t\t}\n\t}\n}\n";
        HashMap<@NonNull String, @Nullable String> genOptions = new HashMap<String, String>();
        genOptions.put("usedGenPackages", "Bug416421A.genmodel#//bug416421A");
        String genmodelFileB = this.createGenModelContent(testProjectPathB, testFileStemB, genOptions);
        UsageTests.doDelete(testProjectNameA);
        UsageTests.doDelete(testProjectNameB);
        URI genModelURIA = this.createModels(testProjectPathA, testFileStemA, oclinecoreFileA, genmodelFileA);
        URI genModelURIB = this.createModels(testProjectPathB, testFileStemB, oclinecoreFileB, genmodelFileB);
        this.doGenModel(testProjectPathB, genModelURIB);
        this.doGenModel(testProjectPathA, genModelURIA);
        this.doCompile(testProjectNameA, new String[0]);
        this.doCompile(testProjectNameB, testProjectNameA);
        ocl.dispose();
    }

    public void testBug458722() throws Exception {
        TestOCL ocl = this.createOCL();
        String testFileStem = "Bug458722";
        String testProjectName = "bug458722";
        String testProjectPath = EMFPlugin.IS_ECLIPSE_RUNNING ? testProjectName : "org.eclipse.ocl.examples.xtext.tests";
        String oclinecoreFile = "import ecore : 'http://www.eclipse.org/emf/2002/Ecore';\n\npackage bug458722 : bug458722 = 'http://www.example.com/bug458722/rootPackage/2.0'\n{\n\tpackage subPackage : subPackage = 'http://www.example.com/bug458722/subPackage/2.0'\n\t{\n\t\tclass SubElement\n\t\t{\n\t\t\toperation op(tokens : String[*] { ordered !unique }) : Boolean\n\t\t\t{\n\t\t\t\tbody: \n\t\t\t\t\n\t\t\t\tif tokens->at(1) = '1'\n\t\t\t\tthen\n\t\t\t\t\top2(tokens)\n\t\t\t    else\n\t\t\t    \ttrue\n\t\t\t    endif;\n\t\t\t}\n\t\t\toperation op2(tokens : String[*] { ordered !unique }) : Boolean\n\t\t\t{\n\t\t\t\tbody: \n\t\t\t\ttrue;\n\t\t\t}\n\t\t}\n\t}\n\tabstract class Element\n\t{\n\t\tattribute name : String = '';\n\t}\n}\n";
        String genmodelFile = this.createGenModelContent(testProjectPath, testFileStem, null);
        UsageTests.doDelete(testProjectName);
        URI genModelURI = this.createModels(testProjectPath, testFileStem, oclinecoreFile, genmodelFile);
        this.doGenModel(testProjectPath, genModelURI);
        this.doCompile(testProjectName, new String[0]);
        ocl.dispose();
    }

    public void testBug458723() throws Exception {
        TestOCL ocl = this.createOCL();
        String testFileStem = "Bug458723";
        String testProjectName = "bug458723";
        String testProjectPath = EMFPlugin.IS_ECLIPSE_RUNNING ? testProjectName : "org.eclipse.ocl.examples.xtext.tests";
        String oclinecoreFile = "import ecore : 'http://www.eclipse.org/emf/2002/Ecore';\n\npackage bug458723 : bug458723 = 'http://www.example.com/bug458723/rootPackage/1.0'\n{\n    package subPackage : subPackage = 'http://www.example.com/bug458723/subPackage/1.0'\n    {\n        class Element extends bug458723::Element\n        {\n\n            /*\n             * Error also occurs with Bag(OclAny) in signature without\n{!unique}\n             */\n            operation op() : ocl::OclAny[*] { !unique }\n            {\n                body: \n                Bag{};\n            }\n        }\n    }\n    abstract class Element\n    {\n        attribute name : String = '';\n    }\n}\n";
        String genmodelFile = this.createGenModelContent(testProjectPath, testFileStem, null);
        UsageTests.doDelete(testProjectName);
        URI genModelURI = this.createModels(testProjectPath, testFileStem, oclinecoreFile, genmodelFile);
        this.doGenModel(testProjectPath, genModelURI);
        this.doCompile(testProjectName, new String[0]);
        ocl.dispose();
    }

    public void testBug458724() throws Exception {
        TestOCL ocl = this.createOCL();
        String testFileStem = "Bug458724";
        String testProjectName = "bug458724";
        String testProjectPath = EMFPlugin.IS_ECLIPSE_RUNNING ? testProjectName : "org.eclipse.ocl.examples.xtext.tests";
        String oclinecoreFile = "import ecore : 'http://www.eclipse.org/emf/2002/Ecore';\n\npackage bug458724 : bug458724 = 'http://www.example.com/bug458724/rootPackage/2.0'\n{\n    class Element\n    {\n        attribute name : String = '';\n        invariant\n        elementNameNotReservedWord: \n            let name: String = self.name.toLower() in\n            name <> 'reserved_1' and\n            name <> 'reserved_2' and\n            name <> 'reserved_3' and\n            name <> 'reserved_4' and\n            name <> 'reserved_5' and\n            name <> 'reserved_6' and\n            name <> 'reserved_7' and\n            name <> 'reserved_8' and\n            name <> 'reserved_9' and\n            name <> 'reserved_10' and\n            name <> 'reserved_11' and\n            name <> 'reserved_12' and\n            name <> 'reserved_13' and\n            name <> 'reserved_14' and\n            name <> 'reserved_15' and\n            name <> 'reserved_16' and\n            name <> 'reserved_17' and\n            name <> 'reserved_18' and\n            name <> 'reserved_19';\n    }\n}\n";
        String genmodelFile = this.createGenModelContent(testProjectPath, testFileStem, null);
        UsageTests.doDelete(testProjectName);
        URI genModelURI = this.createModels(testProjectPath, testFileStem, oclinecoreFile, genmodelFile);
        this.doGenModel(testProjectPath, genModelURI);
        this.doCompile(testProjectName, new String[0]);
        ocl.dispose();
    }

    private static final class JavaSourceFileObject
    extends SimpleJavaFileObject {
        private JavaSourceFileObject(java.net.URI uri) {
            super(uri, JavaFileObject.Kind.SOURCE);
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
            char[] buf = new char[4096];
            StringBuffer s = new StringBuffer();
            try (FileReader reader = new FileReader(new File(this.uri));){
                int len;
                while ((len = reader.read(buf)) > 0) {
                    s.append(buf, 0, len);
                }
            }
            return s.toString();
        }
    }
}

