/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.manager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.BooleanLiteralExp;
import org.eclipse.ocl.pivot.CallExp;
import org.eclipse.ocl.pivot.CollectionItem;
import org.eclipse.ocl.pivot.CollectionLiteralExp;
import org.eclipse.ocl.pivot.CollectionLiteralPart;
import org.eclipse.ocl.pivot.CollectionRange;
import org.eclipse.ocl.pivot.IfExp;
import org.eclipse.ocl.pivot.IntegerLiteralExp;
import org.eclipse.ocl.pivot.IterateExp;
import org.eclipse.ocl.pivot.IteratorExp;
import org.eclipse.ocl.pivot.LetExp;
import org.eclipse.ocl.pivot.MapLiteralExp;
import org.eclipse.ocl.pivot.MapLiteralPart;
import org.eclipse.ocl.pivot.NavigationCallExp;
import org.eclipse.ocl.pivot.NullLiteralExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.RealLiteralExp;
import org.eclipse.ocl.pivot.ShadowExp;
import org.eclipse.ocl.pivot.ShadowPart;
import org.eclipse.ocl.pivot.StringLiteralExp;
import org.eclipse.ocl.pivot.TypeExp;
import org.eclipse.ocl.pivot.UnlimitedNaturalLiteralExp;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.ids.OperationId;
import org.eclipse.ocl.pivot.internal.manager.MetamodelManagerInternal;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.util.AbstractExtendingVisitor;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.MetamodelManager;
import org.eclipse.ocl.pivot.utilities.PivotUtil;

public class FlowAnalysis {
    protected final @NonNull EnvironmentFactory environmentFactory;
    protected final @NonNull OCLExpression contextExpression;
    private @Nullable AbstractDeducer deducerFromFalse = null;
    private @Nullable AbstractDeducer deducerFromNonNull = null;
    private @Nullable AbstractDeducer deducerFromNull = null;
    private final @NonNull AbstractDeducer deducerFromTrue = new DeducerFromTrue(this);
    private @Nullable Map<@NonNull Integer, @NonNull List<@NonNull CallPath>> callPathHash2callPaths = null;
    private @Nullable Map<@NonNull Object, @Nullable Boolean> variable2nullOrNonNull = null;

    public static @NonNull FlowAnalysis getFlowAnalysis(@NonNull EnvironmentFactory environmentFactory, @NonNull OCLExpression contextExpression) {
        contextExpression = FlowAnalysis.getControlExpression(contextExpression);
        MetamodelManager metamodelManager = environmentFactory.getMetamodelManager();
        if (metamodelManager instanceof MetamodelManagerInternal.MetamodelManagerInternalExtension2) {
            return ((MetamodelManagerInternal.MetamodelManagerInternalExtension2)metamodelManager).getFlowAnalysis(contextExpression);
        }
        return new FlowAnalysis(environmentFactory, contextExpression);
    }

    public static @NonNull OCLExpression getControlExpression(@NonNull OCLExpression contextExpression) {
        EObject eContainer;
        OCLExpression eObject = contextExpression;
        while ((eContainer = eObject.eContainer()) instanceof OCLExpression) {
            OperationCallExp operationCallExp;
            OperationId operationId;
            LetExp letExp;
            IfExp ifExp;
            if (eContainer instanceof IfExp ? eObject == PivotUtil.getOwnedThen(ifExp = (IfExp)eContainer) || eObject == PivotUtil.getOwnedElse(ifExp) : (eContainer instanceof LetExp ? eObject == PivotUtil.getOwnedIn(letExp = (LetExp)eContainer) : eContainer instanceof OperationCallExp && (PivotUtil.isSameOperation(operationId = PivotUtil.getReferredOperation(operationCallExp = (OperationCallExp)eContainer).getOperationId(), OperationId.BOOLEAN_AND) ? eObject == PivotUtil.getOwnedSource(operationCallExp) || eObject == PivotUtil.getOwnedArgument(operationCallExp, 0) : PivotUtil.isSameOperation(operationId, OperationId.BOOLEAN_IMPLIES) && (eObject == PivotUtil.getOwnedSource(operationCallExp) || eObject == PivotUtil.getOwnedArgument(operationCallExp, 0))))) break;
            eObject = (OCLExpression)eContainer;
        }
        return eObject;
    }

    protected FlowAnalysis(@NonNull EnvironmentFactory environmentFactory, @NonNull OCLExpression contextExpression) {
        boolean gotOne;
        this.environmentFactory = environmentFactory;
        this.contextExpression = contextExpression;
        OCLExpression eObject = contextExpression;
        EObject eContainer = eObject.eContainer();
        while (eContainer instanceof OCLExpression) {
            if (eContainer instanceof IfExp) {
                IfExp ifExp = (IfExp)eContainer;
                if (eObject == PivotUtil.getOwnedThen(ifExp)) {
                    this.addTrueExpression(PivotUtil.getOwnedCondition(ifExp));
                } else if (eObject == PivotUtil.getOwnedElse(ifExp)) {
                    this.addFalseExpression(PivotUtil.getOwnedCondition(ifExp));
                }
            } else if (eContainer instanceof LetExp) {
                LetExp letExp = (LetExp)eContainer;
                Variable letVariable = PivotUtil.getOwnedVariable(letExp);
                OCLExpression initExpression = PivotUtil.getOwnedInit(letVariable);
                FlowAnalysis variableAnalysis = ((MetamodelManagerInternal.MetamodelManagerInternalExtension2)environmentFactory.getMetamodelManager()).getFlowAnalysis(initExpression);
                if (variableAnalysis.isNull(initExpression)) {
                    this.setVariable(letVariable, true);
                } else if (variableAnalysis.isNonNull(initExpression)) {
                    this.setVariable(letVariable, false);
                }
            } else if (eContainer instanceof OperationCallExp) {
                OperationCallExp operationCallExp = (OperationCallExp)eContainer;
                OperationId operationId = PivotUtil.getReferredOperation(operationCallExp).getOperationId();
                if (PivotUtil.isSameOperation(operationId, OperationId.BOOLEAN_AND)) {
                    if (eObject == PivotUtil.getOwnedSource(operationCallExp)) {
                        this.addTrueExpression(PivotUtil.getOwnedArgument(operationCallExp, 0));
                    } else if (eObject == PivotUtil.getOwnedArgument(operationCallExp, 0)) {
                        this.addTrueExpression(PivotUtil.getOwnedSource(operationCallExp));
                    }
                } else if (PivotUtil.isSameOperation(operationId, OperationId.BOOLEAN_IMPLIES)) {
                    if (eObject == PivotUtil.getOwnedSource(operationCallExp)) {
                        this.addFalseExpression(PivotUtil.getOwnedArgument(operationCallExp, 0));
                    } else if (eObject == PivotUtil.getOwnedArgument(operationCallExp, 0)) {
                        this.addTrueExpression(PivotUtil.getOwnedSource(operationCallExp));
                    }
                }
            }
            eObject = eContainer;
            eContainer = eContainer.eContainer();
        }
        do {
            AbstractDeducer deducerFromNonNull2;
            AbstractDeducer deducerFromNull2;
            gotOne = false;
            while (this.deducerFromTrue.deduceNext()) {
                gotOne = true;
            }
            AbstractDeducer deducerFromFalse2 = this.deducerFromFalse;
            if (deducerFromFalse2 != null) {
                while (deducerFromFalse2.deduceNext()) {
                    gotOne = true;
                }
            }
            if ((deducerFromNull2 = this.deducerFromNull) != null) {
                while (deducerFromNull2.deduceNext()) {
                    gotOne = true;
                }
            }
            if ((deducerFromNonNull2 = this.deducerFromNonNull) == null) continue;
            while (deducerFromNonNull2.deduceNext()) {
                gotOne = true;
            }
        } while (gotOne);
    }

    protected void addFalseExpression(@NonNull OCLExpression object) {
        AbstractDeducer deducerFromFalse2 = this.deducerFromFalse;
        if (deducerFromFalse2 == null) {
            deducerFromFalse2 = this.deducerFromFalse = new DeducerFromFalse(this);
        }
        deducerFromFalse2.addToBeDeduced(object);
    }

    protected void addNonNullExpression(@NonNull OCLExpression object) {
        AbstractDeducer deducerFromNonNull2 = this.deducerFromNonNull;
        if (deducerFromNonNull2 == null) {
            deducerFromNonNull2 = this.deducerFromNonNull = new DeducerFromNull(this, false);
        }
        deducerFromNonNull2.addToBeDeduced(object);
    }

    protected void addNullExpression(@NonNull OCLExpression object) {
        AbstractDeducer deducerFromNull2 = this.deducerFromNull;
        if (deducerFromNull2 == null) {
            deducerFromNull2 = this.deducerFromNull = new DeducerFromNull(this, true);
        }
        deducerFromNull2.addToBeDeduced(object);
    }

    protected void addTrueExpression(@NonNull OCLExpression object) {
        this.deducerFromTrue.addToBeDeduced(object);
    }

    protected @Nullable Boolean getCallPath(@NonNull OCLExpression object) {
        Integer hashCode = CallPath.computeHashCode(object);
        if (hashCode == null) {
            return null;
        }
        Map<@NonNull Integer, @NonNull List<@NonNull CallPath>> callPathHash2callPaths2 = this.callPathHash2callPaths;
        if (callPathHash2callPaths2 == null) {
            return null;
        }
        List<@NonNull CallPath> callPaths = callPathHash2callPaths2.get(hashCode);
        if (callPaths == null) {
            return null;
        }
        for (CallPath callPath : callPaths) {
            if (!callPath.isSamePathAs(object)) continue;
            return callPath.getNullOrNonNull();
        }
        return null;
    }

    protected @Nullable Boolean getVariable(@NonNull VariableDeclaration variable) {
        Map<@NonNull Object, @Nullable Boolean> variable2nullOrNonNull2 = this.variable2nullOrNonNull;
        return variable2nullOrNonNull2 != null ? variable2nullOrNonNull2.get(variable) : null;
    }

    public boolean isNonNull(@NonNull OCLExpression asExpression) {
        try {
            return this.deducerFromTrue.isAlreadyNonNull(asExpression);
        }
        catch (Throwable e) {
            return false;
        }
    }

    public boolean isNull(@NonNull OCLExpression asExpression) {
        try {
            return this.deducerFromTrue.isAlreadyNull(asExpression);
        }
        catch (Throwable e) {
            return false;
        }
    }

    protected @Nullable Boolean setCallPath(@NonNull CallExp object, boolean isNull) {
        List<CallPath> callPaths;
        Map<Integer, List<CallPath>> callPathHash2callPaths2;
        Integer hashCode = CallPath.computeHashCode(object);
        if (hashCode == null) {
            return null;
        }
        ArrayList<@NonNull OCLExpression> path = new ArrayList<OCLExpression>();
        CallExp pathExp = object;
        while (pathExp != null) {
            path.add(pathExp);
            if (pathExp instanceof VariableExp) break;
            OCLExpression oCLExpression = pathExp = pathExp instanceof CallExp ? pathExp.getOwnedSource() : null;
        }
        if ((callPathHash2callPaths2 = this.callPathHash2callPaths) == null) {
            callPathHash2callPaths2 = this.callPathHash2callPaths = new HashMap<Integer, List<CallPath>>();
        }
        if ((callPaths = callPathHash2callPaths2.get(hashCode)) == null) {
            callPaths = new ArrayList<CallPath>();
            callPathHash2callPaths2.put(hashCode, callPaths);
        }
        callPaths.add(new CallPath(path, isNull));
        return true;
    }

    protected boolean setVariable(@NonNull VariableDeclaration variable, boolean isNullOrNonNull) {
        Boolean oldNullOrNonNull;
        Map<@NonNull Object, @Nullable Boolean> variable2nullOrNonNull2 = this.variable2nullOrNonNull;
        if (variable2nullOrNonNull2 == null) {
            variable2nullOrNonNull2 = this.variable2nullOrNonNull = new HashMap<Object, Boolean>();
        }
        if ((oldNullOrNonNull = variable2nullOrNonNull2.put(variable, isNullOrNonNull)) == null) {
            return true;
        }
        return oldNullOrNonNull == isNullOrNonNull;
    }

    protected static abstract class AbstractDeducer
    extends AbstractExtendingVisitor<Boolean, FlowAnalysis> {
        private @NonNull List<@NonNull OCLExpression> toBeDeduced = new ArrayList<OCLExpression>();
        private int alreadyDeducedIndex = 0;

        public AbstractDeducer(@NonNull FlowAnalysis flowAnalysis) {
            super(flowAnalysis);
        }

        public void addToBeDeduced(@NonNull OCLExpression object) {
            if (!this.toBeDeduced.contains(object)) {
                this.toBeDeduced.add(object);
            }
        }

        public boolean deduceNext() {
            if (this.alreadyDeducedIndex >= this.toBeDeduced.size()) {
                return false;
            }
            OCLExpression asExpression = this.toBeDeduced.get(this.alreadyDeducedIndex++);
            asExpression.accept(this);
            return true;
        }

        protected boolean isAlreadyNonNull(@NonNull OCLExpression asExpression) {
            if (asExpression.isIsRequired()) {
                return true;
            }
            if (asExpression instanceof VariableExp) {
                VariableDeclaration referredVariable = PivotUtil.getReferredVariable((VariableExp)asExpression);
                Boolean nullOrNonNull = ((FlowAnalysis)this.context).getVariable(referredVariable);
                return nullOrNonNull == Boolean.FALSE;
            }
            if (asExpression instanceof CallExp) {
                Boolean nullOrNonNull = ((FlowAnalysis)this.context).getCallPath(asExpression);
                return nullOrNonNull == Boolean.FALSE;
            }
            return false;
        }

        protected boolean isAlreadyNull(@NonNull OCLExpression asExpression) {
            if (asExpression instanceof NullLiteralExp) {
                return true;
            }
            if (asExpression instanceof VariableExp) {
                VariableDeclaration referredVariable = PivotUtil.getReferredVariable((VariableExp)asExpression);
                Boolean nullOrNonNull = ((FlowAnalysis)this.context).getVariable(referredVariable);
                return nullOrNonNull == Boolean.TRUE;
            }
            if (asExpression instanceof CallExp) {
                Boolean nullOrNonNull = ((FlowAnalysis)this.context).getCallPath(asExpression);
                return nullOrNonNull == Boolean.TRUE;
            }
            return false;
        }

        @Override
        public @Nullable Boolean visiting(@NonNull Visitable visitable) {
            throw new IllegalArgumentException("Unsupported " + visitable.eClass().getName() + " for " + this.getClass().getSimpleName());
        }

        @Override
        public @Nullable Boolean visitBooleanLiteralExp(@NonNull BooleanLiteralExp object) {
            return null;
        }

        @Override
        public @Nullable Boolean visitNullLiteralExp(@NonNull NullLiteralExp object) {
            return null;
        }

        @Override
        public @Nullable Boolean visitOCLExpression(@NonNull OCLExpression object) {
            return null;
        }
    }

    protected static class CallPath {
        private final @NonNull List<@NonNull OCLExpression> callPath;
        private final boolean nullOrNonNull;

        public static Integer computeHashCode(@NonNull OCLExpression object) {
            int hashCode = 1;
            OCLExpression pathExp = object;
            while (pathExp != null) {
                if (pathExp instanceof VariableExp) {
                    VariableDeclaration variable = PivotUtil.getReferredVariable((VariableExp)pathExp);
                    hashCode = 3 * hashCode + variable.hashCode();
                    return hashCode;
                }
                if (pathExp instanceof NavigationCallExp) {
                    Property property = PivotUtil.getReferredProperty((NavigationCallExp)pathExp);
                    hashCode = 3 * hashCode + property.hashCode();
                } else {
                    if (!(pathExp instanceof OperationCallExp)) break;
                    Operation operation = PivotUtil.getReferredOperation((OperationCallExp)pathExp);
                    hashCode = 3 * hashCode + operation.hashCode();
                }
                OCLExpression oCLExpression = pathExp = pathExp instanceof CallExp ? ((CallExp)pathExp).getOwnedSource() : null;
            }
            return null;
        }

        protected CallPath(@NonNull List<@NonNull OCLExpression> callPath, boolean nullOrNonNull) {
            this.callPath = callPath;
            this.nullOrNonNull = nullOrNonNull;
        }

        protected boolean getNullOrNonNull() {
            return this.nullOrNonNull;
        }

        protected boolean isSamePathAs(@NonNull OCLExpression candidateObject) {
            int pathIndex = 0;
            HashMap<@NonNull VariableDeclaration, @NonNull VariableDeclaration> firstVariable2secondVariable = new HashMap<VariableDeclaration, VariableDeclaration>();
            OCLExpression candidateElement = candidateObject;
            while (candidateElement != null) {
                OCLExpression pathElement;
                if (pathIndex >= this.callPath.size()) {
                    return false;
                }
                if (!this.isSameTerm(candidateElement, pathElement = this.callPath.get(pathIndex++), firstVariable2secondVariable)) {
                    return false;
                }
                OCLExpression oCLExpression = candidateElement = candidateElement instanceof CallExp ? ((CallExp)candidateElement).getOwnedSource() : null;
            }
            return true;
        }

        protected boolean isSameTerm(@NonNull OCLExpression firstExpression, @NonNull OCLExpression secondExpression, @NonNull Map<@NonNull VariableDeclaration, @NonNull VariableDeclaration> firstVariable2secondVariable) {
            if (firstExpression instanceof BooleanLiteralExp) {
                if (!(secondExpression instanceof BooleanLiteralExp)) {
                    return false;
                }
                if (((BooleanLiteralExp)firstExpression).isBooleanSymbol() != ((BooleanLiteralExp)secondExpression).isBooleanSymbol()) {
                    return false;
                }
            } else if (firstExpression instanceof CollectionLiteralExp) {
                if (!(secondExpression instanceof CollectionLiteralExp)) {
                    return false;
                }
                CollectionLiteralExp firstCollectionLiteralExp = (CollectionLiteralExp)firstExpression;
                CollectionLiteralExp secondCollectionLiteralExp = (CollectionLiteralExp)secondExpression;
                if (firstCollectionLiteralExp.getKind() != secondCollectionLiteralExp.getKind()) {
                    return false;
                }
                List<@NonNull CollectionLiteralPart> firstParts = PivotUtilInternal.getOwnedPartsList(firstCollectionLiteralExp);
                List<@NonNull CollectionLiteralPart> secondParts = PivotUtilInternal.getOwnedPartsList(secondCollectionLiteralExp);
                int iSize = firstParts.size();
                if (iSize != secondParts.size()) {
                    return false;
                }
                int i = 0;
                while (i < iSize) {
                    CollectionLiteralPart firstCollectionLiteralPart = firstParts.get(i);
                    CollectionLiteralPart secondCollectionLiteralPart = secondParts.get(i);
                    if (firstCollectionLiteralPart instanceof CollectionItem) {
                        if (!(secondCollectionLiteralPart instanceof CollectionItem)) {
                            return false;
                        }
                        if (!this.isSameTerm(PivotUtil.getOwnedItem((CollectionItem)firstCollectionLiteralPart), PivotUtil.getOwnedItem((CollectionItem)secondCollectionLiteralPart), firstVariable2secondVariable)) {
                            return false;
                        }
                    } else if (firstCollectionLiteralPart instanceof CollectionRange) {
                        if (!(secondCollectionLiteralPart instanceof CollectionRange)) {
                            return false;
                        }
                        if (!this.isSameTerm(PivotUtil.getOwnedFirst((CollectionRange)firstCollectionLiteralPart), PivotUtil.getOwnedFirst((CollectionRange)secondCollectionLiteralPart), firstVariable2secondVariable)) {
                            return false;
                        }
                        if (!this.isSameTerm(PivotUtil.getOwnedLast((CollectionRange)firstCollectionLiteralPart), PivotUtil.getOwnedLast((CollectionRange)secondCollectionLiteralPart), firstVariable2secondVariable)) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                    ++i;
                }
            } else if (firstExpression instanceof IfExp) {
                if (!(secondExpression instanceof IfExp)) {
                    return false;
                }
                IfExp firstIfExp = (IfExp)firstExpression;
                IfExp secondIfExp = (IfExp)secondExpression;
                if (!this.isSameTerm(PivotUtil.getOwnedCondition(firstIfExp), PivotUtil.getOwnedCondition(secondIfExp), firstVariable2secondVariable)) {
                    return false;
                }
                if (!this.isSameTerm(PivotUtil.getOwnedThen(firstIfExp), PivotUtil.getOwnedThen(secondIfExp), firstVariable2secondVariable)) {
                    return false;
                }
                if (!this.isSameTerm(PivotUtil.getOwnedElse(firstIfExp), PivotUtil.getOwnedElse(secondIfExp), firstVariable2secondVariable)) {
                    return false;
                }
            } else if (firstExpression instanceof IntegerLiteralExp) {
                if (!(secondExpression instanceof IntegerLiteralExp)) {
                    return false;
                }
                if (((IntegerLiteralExp)firstExpression).getIntegerSymbol() != ((IntegerLiteralExp)secondExpression).getIntegerSymbol()) {
                    return false;
                }
            } else if (firstExpression instanceof IterateExp) {
                if (!(secondExpression instanceof IterateExp)) {
                    return false;
                }
                IterateExp firstIterateExp = (IterateExp)firstExpression;
                IterateExp secondIterateExp = (IterateExp)secondExpression;
                if (firstIterateExp.getReferredIteration() != secondIterateExp.getReferredIteration()) {
                    return false;
                }
                if (!this.isSameTerm(PivotUtil.getOwnedSource(firstIterateExp), PivotUtil.getOwnedSource(secondIterateExp), firstVariable2secondVariable)) {
                    return false;
                }
                if (!this.isSameTerm(PivotUtil.getOwnedBody(firstIterateExp), PivotUtil.getOwnedBody(secondIterateExp), firstVariable2secondVariable)) {
                    return false;
                }
                List<@NonNull Variable> firstIterators = PivotUtilInternal.getOwnedIteratorsList(firstIterateExp);
                List<@NonNull Variable> secondIterators = PivotUtilInternal.getOwnedIteratorsList(secondIterateExp);
                int iSize = firstIterators.size();
                if (iSize != secondIterators.size()) {
                    return false;
                }
                int i = 0;
                while (i < iSize) {
                    if (!this.isSameVariable(firstIterators.get(i), secondIterators.get(i), firstVariable2secondVariable)) {
                        return false;
                    }
                    ++i;
                }
                if (!this.isSameVariable(PivotUtil.getOwnedResult(firstIterateExp), PivotUtil.getOwnedResult(secondIterateExp), firstVariable2secondVariable)) {
                    return false;
                }
            } else if (firstExpression instanceof IterateExp) {
                if (!(secondExpression instanceof IterateExp)) {
                    return false;
                }
                IterateExp firstIterateExp = (IterateExp)firstExpression;
                IterateExp secondIterateExp = (IterateExp)secondExpression;
                if (firstIterateExp.getReferredIteration() != secondIterateExp.getReferredIteration()) {
                    return false;
                }
                if (!this.isSameTerm(PivotUtil.getOwnedSource(firstIterateExp), PivotUtil.getOwnedSource(secondIterateExp), firstVariable2secondVariable)) {
                    return false;
                }
                List<@NonNull Variable> firstIterators = PivotUtilInternal.getOwnedIteratorsList(firstIterateExp);
                List<@NonNull Variable> secondIterators = PivotUtilInternal.getOwnedIteratorsList(secondIterateExp);
                int iSize = firstIterators.size();
                if (iSize != secondIterators.size()) {
                    return false;
                }
                int i = 0;
                while (i < iSize) {
                    if (!this.isSameVariable(firstIterators.get(i), secondIterators.get(i), firstVariable2secondVariable)) {
                        return false;
                    }
                    ++i;
                }
                if (!this.isSameVariable(PivotUtil.getOwnedResult(firstIterateExp), PivotUtil.getOwnedResult(secondIterateExp), firstVariable2secondVariable)) {
                    return false;
                }
                if (!this.isSameTerm(PivotUtil.getOwnedBody(firstIterateExp), PivotUtil.getOwnedBody(secondIterateExp), firstVariable2secondVariable)) {
                    return false;
                }
            } else if (firstExpression instanceof IteratorExp) {
                if (!(secondExpression instanceof IteratorExp)) {
                    return false;
                }
                IteratorExp firstIteratorExp = (IteratorExp)firstExpression;
                IteratorExp secondIteratorExp = (IteratorExp)secondExpression;
                if (firstIteratorExp.getReferredIteration() != secondIteratorExp.getReferredIteration()) {
                    return false;
                }
                if (!this.isSameTerm(PivotUtil.getOwnedSource(firstIteratorExp), PivotUtil.getOwnedSource(secondIteratorExp), firstVariable2secondVariable)) {
                    return false;
                }
                List<@NonNull Variable> firstIterators = PivotUtilInternal.getOwnedIteratorsList(firstIteratorExp);
                List<@NonNull Variable> secondIterators = PivotUtilInternal.getOwnedIteratorsList(secondIteratorExp);
                int iSize = firstIterators.size();
                if (iSize != secondIterators.size()) {
                    return false;
                }
                int i = 0;
                while (i < iSize) {
                    if (!this.isSameVariable(firstIterators.get(i), secondIterators.get(i), firstVariable2secondVariable)) {
                        return false;
                    }
                    ++i;
                }
                if (!this.isSameTerm(PivotUtil.getOwnedBody(firstIteratorExp), PivotUtil.getOwnedBody(secondIteratorExp), firstVariable2secondVariable)) {
                    return false;
                }
            } else if (firstExpression instanceof LetExp) {
                if (!(secondExpression instanceof LetExp)) {
                    return false;
                }
                LetExp firstLetExp = (LetExp)firstExpression;
                LetExp secondLetExp = (LetExp)secondExpression;
                if (!this.isSameVariable(PivotUtil.getOwnedVariable(firstLetExp), PivotUtil.getOwnedVariable(secondLetExp), firstVariable2secondVariable)) {
                    return false;
                }
                if (!this.isSameTerm(PivotUtil.getOwnedIn(firstLetExp), PivotUtil.getOwnedIn(secondLetExp), firstVariable2secondVariable)) {
                    return false;
                }
            } else if (firstExpression instanceof MapLiteralExp) {
                if (!(secondExpression instanceof MapLiteralExp)) {
                    return false;
                }
                MapLiteralExp firstMapLiteralExp = (MapLiteralExp)firstExpression;
                MapLiteralExp secondMapLiteralExp = (MapLiteralExp)secondExpression;
                List<@NonNull MapLiteralPart> firstParts = PivotUtilInternal.getOwnedPartsList(firstMapLiteralExp);
                List<@NonNull MapLiteralPart> secondParts = PivotUtilInternal.getOwnedPartsList(secondMapLiteralExp);
                int iSize = firstParts.size();
                if (iSize != secondParts.size()) {
                    return false;
                }
                int i = 0;
                while (i < iSize) {
                    MapLiteralPart firstPart = firstParts.get(i);
                    MapLiteralPart secondPart = secondParts.get(i);
                    if (firstPart.getOwnedKey() != ((IntegerLiteralExp)secondExpression).getIntegerSymbol()) {
                        return false;
                    }
                    if (!this.isSameTerm(PivotUtil.getOwnedKey(firstPart), PivotUtil.getOwnedKey(secondPart), firstVariable2secondVariable)) {
                        return false;
                    }
                    if (!this.isSameTerm(PivotUtil.getOwnedValue(firstPart), PivotUtil.getOwnedValue(secondPart), firstVariable2secondVariable)) {
                        return false;
                    }
                    ++i;
                }
            } else if (firstExpression instanceof NavigationCallExp) {
                if (!(secondExpression instanceof NavigationCallExp)) {
                    return false;
                }
                if (PivotUtil.getReferredProperty((NavigationCallExp)firstExpression) != PivotUtil.getReferredProperty((NavigationCallExp)secondExpression)) {
                    return false;
                }
            } else if (firstExpression instanceof NullLiteralExp) {
                if (!(secondExpression instanceof NullLiteralExp)) {
                    return false;
                }
            } else if (firstExpression instanceof OperationCallExp) {
                if (!(secondExpression instanceof OperationCallExp)) {
                    return false;
                }
                OperationCallExp firstOperationCallExp = (OperationCallExp)firstExpression;
                OperationCallExp secondOperationCallExp = (OperationCallExp)secondExpression;
                if (firstOperationCallExp.getReferredOperation() != secondOperationCallExp.getReferredOperation()) {
                    return false;
                }
                List<@NonNull OCLExpression> firstArguments = PivotUtilInternal.getOwnedArgumentsList(firstOperationCallExp);
                List<@NonNull OCLExpression> secondArguments = PivotUtilInternal.getOwnedArgumentsList(secondOperationCallExp);
                int iSize = firstArguments.size();
                if (iSize != secondArguments.size()) {
                    return false;
                }
                int i = 0;
                while (i < iSize) {
                    if (!this.isSameTerm(firstArguments.get(i), secondArguments.get(i), firstVariable2secondVariable)) {
                        return false;
                    }
                    ++i;
                }
            } else if (firstExpression instanceof RealLiteralExp) {
                if (!(secondExpression instanceof RealLiteralExp)) {
                    return false;
                }
                if (((RealLiteralExp)firstExpression).getRealSymbol() != ((RealLiteralExp)secondExpression).getRealSymbol()) {
                    return false;
                }
            } else if (firstExpression instanceof ShadowExp) {
                if (!(secondExpression instanceof ShadowExp)) {
                    return false;
                }
                ShadowExp firstShadowExp = (ShadowExp)firstExpression;
                ShadowExp secondShadowExp = (ShadowExp)secondExpression;
                if (firstShadowExp.getType() != secondShadowExp.getType()) {
                    return false;
                }
                List<@NonNull ShadowPart> firstParts = PivotUtilInternal.getOwnedPartsList(firstShadowExp);
                List<@NonNull ShadowPart> secondParts = PivotUtilInternal.getOwnedPartsList(secondShadowExp);
                int iSize = firstParts.size();
                if (iSize != secondParts.size()) {
                    return false;
                }
                int i = 0;
                while (i < iSize) {
                    ShadowPart firstPart = firstParts.get(i);
                    ShadowPart secondPart = secondParts.get(i);
                    if (firstPart.getReferredProperty() != secondPart.getReferredProperty()) {
                        return false;
                    }
                    if (!this.isSameTerm(PivotUtil.getOwnedInit(firstPart), PivotUtil.getOwnedInit(secondPart), firstVariable2secondVariable)) {
                        return false;
                    }
                    ++i;
                }
            } else if (firstExpression instanceof StringLiteralExp) {
                if (!(secondExpression instanceof StringLiteralExp)) {
                    return false;
                }
                if (!((StringLiteralExp)firstExpression).getStringSymbol().equals(((StringLiteralExp)secondExpression).getStringSymbol())) {
                    return false;
                }
            } else if (firstExpression instanceof TypeExp) {
                if (!(secondExpression instanceof TypeExp)) {
                    return false;
                }
                if (((TypeExp)firstExpression).getReferredType() != ((TypeExp)secondExpression).getReferredType()) {
                    return false;
                }
            } else if (firstExpression instanceof UnlimitedNaturalLiteralExp) {
                if (!(secondExpression instanceof UnlimitedNaturalLiteralExp)) {
                    return false;
                }
                if (((UnlimitedNaturalLiteralExp)firstExpression).getUnlimitedNaturalSymbol() != ((UnlimitedNaturalLiteralExp)secondExpression).getUnlimitedNaturalSymbol()) {
                    return false;
                }
            } else if (firstExpression instanceof VariableExp) {
                if (!(secondExpression instanceof VariableExp)) {
                    return false;
                }
                VariableDeclaration firstVariable = ((VariableExp)firstExpression).getReferredVariable();
                VariableDeclaration knownSecondVariable = firstVariable2secondVariable.get(firstVariable);
                if (knownSecondVariable != null) {
                    VariableDeclaration secondVariable = ((VariableExp)secondExpression).getReferredVariable();
                    return knownSecondVariable == secondVariable;
                }
            } else {
                return false;
            }
            return true;
        }

        protected boolean isSameVariable(@NonNull Variable firstVariable, @NonNull Variable secondVariable, @NonNull Map<@NonNull VariableDeclaration, @NonNull VariableDeclaration> firstVariable2secondVariable) {
            VariableDeclaration knownSecondVariable = firstVariable2secondVariable.get(firstVariable);
            if (knownSecondVariable != null) {
                return knownSecondVariable == secondVariable;
            }
            if (!this.isSameTerm(PivotUtil.getOwnedInit(firstVariable), PivotUtil.getOwnedInit(secondVariable), firstVariable2secondVariable)) {
                return false;
            }
            firstVariable2secondVariable.put(firstVariable, secondVariable);
            return true;
        }

        public @NonNull String toString() {
            return this.callPath + " = " + this.nullOrNonNull;
        }
    }

    protected static class DeducerFromFalse
    extends AbstractDeducer {
        public DeducerFromFalse(@NonNull FlowAnalysis flowAnalysis) {
            super(flowAnalysis);
        }

        @Override
        public @Nullable Boolean visitBooleanLiteralExp(@NonNull BooleanLiteralExp object) {
            return !object.isBooleanSymbol();
        }

        @Override
        public @Nullable Boolean visitOperationCallExp(@NonNull OperationCallExp object) {
            OperationId operationId = PivotUtil.getReferredOperation(object).getOperationId();
            if (PivotUtil.isSameOperation(operationId, OperationId.BOOLEAN_NOT)) {
                ((FlowAnalysis)this.context).addFalseExpression(object);
                return Boolean.TRUE;
            }
            if (PivotUtil.isSameOperation(operationId, OperationId.BOOLEAN_OR)) {
                ((FlowAnalysis)this.context).addFalseExpression(PivotUtil.getOwnedSource(object));
                ((FlowAnalysis)this.context).addFalseExpression(PivotUtil.getOwnedArgument(object, 0));
                return Boolean.TRUE;
            }
            if (PivotUtil.isSameOperation(operationId, OperationId.OCLANY_EQUALS)) {
                OCLExpression ownedSource = PivotUtil.getOwnedSource(object);
                OCLExpression ownedArgument = PivotUtil.getOwnedArgument(object, 0);
                if (this.isAlreadyNull(ownedSource)) {
                    ((FlowAnalysis)this.context).addNonNullExpression(ownedArgument);
                    return Boolean.TRUE;
                }
                if (this.isAlreadyNull(ownedArgument)) {
                    ((FlowAnalysis)this.context).addNonNullExpression(ownedSource);
                    return Boolean.TRUE;
                }
            } else if (PivotUtil.isSameOperation(operationId, OperationId.OCLANY_NOT_EQUALS)) {
                OCLExpression ownedSource = PivotUtil.getOwnedSource(object);
                OCLExpression ownedArgument = PivotUtil.getOwnedArgument(object, 0);
                if (this.isAlreadyNull(ownedSource)) {
                    ((FlowAnalysis)this.context).addNullExpression(ownedArgument);
                    return Boolean.TRUE;
                }
                if (this.isAlreadyNull(ownedArgument)) {
                    ((FlowAnalysis)this.context).addNullExpression(ownedSource);
                    return Boolean.TRUE;
                }
            }
            return (Boolean)super.visitOperationCallExp(object);
        }
    }

    protected static class DeducerFromNull
    extends AbstractDeducer {
        protected final boolean isNull;

        public DeducerFromNull(@NonNull FlowAnalysis flowAnalysis, boolean isNull) {
            super(flowAnalysis);
            this.isNull = isNull;
        }

        @Override
        public @Nullable Boolean visitCallExp(@NonNull CallExp object) {
            return ((FlowAnalysis)this.context).setCallPath(object, this.isNull);
        }

        @Override
        public @Nullable Boolean visitNullLiteralExp(@NonNull NullLiteralExp object) {
            return this.isNull;
        }

        @Override
        public @Nullable Boolean visitVariableExp(@NonNull VariableExp object) {
            VariableDeclaration variable = PivotUtil.getReferredVariable(object);
            return ((FlowAnalysis)this.context).setVariable(variable, this.isNull);
        }
    }

    protected static class DeducerFromTrue
    extends AbstractDeducer {
        public DeducerFromTrue(@NonNull FlowAnalysis flowAnalysis) {
            super(flowAnalysis);
        }

        @Override
        public @Nullable Boolean visitBooleanLiteralExp(@NonNull BooleanLiteralExp object) {
            return object.isBooleanSymbol();
        }

        @Override
        public @Nullable Boolean visitOperationCallExp(@NonNull OperationCallExp object) {
            OperationId operationId = PivotUtil.getReferredOperation(object).getOperationId();
            if (PivotUtil.isSameOperation(operationId, OperationId.BOOLEAN_AND)) {
                ((FlowAnalysis)this.context).addTrueExpression(PivotUtil.getOwnedSource(object));
                ((FlowAnalysis)this.context).addTrueExpression(PivotUtil.getOwnedArgument(object, 0));
                return Boolean.TRUE;
            }
            if (PivotUtil.isSameOperation(operationId, OperationId.BOOLEAN_IMPLIES)) {
                ((FlowAnalysis)this.context).addTrueExpression(PivotUtil.getOwnedSource(object));
                ((FlowAnalysis)this.context).addFalseExpression(PivotUtil.getOwnedArgument(object, 0));
                return Boolean.TRUE;
            }
            if (PivotUtil.isSameOperation(operationId, OperationId.BOOLEAN_NOT)) {
                ((FlowAnalysis)this.context).addFalseExpression(PivotUtil.getOwnedSource(object));
                return Boolean.TRUE;
            }
            if (PivotUtil.isSameOperation(operationId, OperationId.OCLANY_EQUALS)) {
                OCLExpression ownedSource = PivotUtil.getOwnedSource(object);
                OCLExpression ownedArgument = PivotUtil.getOwnedArgument(object, 0);
                if (this.isAlreadyNull(ownedSource)) {
                    ((FlowAnalysis)this.context).addNullExpression(ownedArgument);
                    return Boolean.TRUE;
                }
                if (this.isAlreadyNonNull(ownedSource)) {
                    ((FlowAnalysis)this.context).addNonNullExpression(ownedArgument);
                    return Boolean.TRUE;
                }
                if (this.isAlreadyNull(ownedArgument)) {
                    ((FlowAnalysis)this.context).addNullExpression(ownedSource);
                    return Boolean.TRUE;
                }
                if (this.isAlreadyNonNull(ownedArgument)) {
                    ((FlowAnalysis)this.context).addNonNullExpression(ownedSource);
                    return Boolean.TRUE;
                }
            } else if (PivotUtil.isSameOperation(operationId, OperationId.OCLANY_NOT_EQUALS)) {
                OCLExpression ownedSource = PivotUtil.getOwnedSource(object);
                OCLExpression ownedArgument = PivotUtil.getOwnedArgument(object, 0);
                if (this.isAlreadyNull(ownedSource)) {
                    ((FlowAnalysis)this.context).addNonNullExpression(ownedArgument);
                    return Boolean.TRUE;
                }
                if (this.isAlreadyNull(ownedArgument)) {
                    ((FlowAnalysis)this.context).addNonNullExpression(ownedSource);
                    return Boolean.TRUE;
                }
            }
            return (Boolean)super.visitOperationCallExp(object);
        }
    }
}

