/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.standalone;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.standalone.StandaloneApplication;
import org.eclipse.ocl.examples.standalone.StandaloneCommand;
import org.eclipse.ocl.examples.standalone.StandaloneResponse;
import org.eclipse.ocl.examples.standalone.messages.StandaloneMessages;

public class HelpCommand
extends StandaloneCommand {
    private static final Logger logger = Logger.getLogger(HelpCommand.class);

    public HelpCommand(@NonNull StandaloneApplication standaloneApplication) {
        super(standaloneApplication, "help", StandaloneMessages.HelpCommand_Help);
    }

    @Override
    public @NonNull StandaloneResponse execute(@NonNull Map<StandaloneCommand.CommandToken, List<String>> token2strings) {
        ArrayList<StandaloneCommand> commands = new ArrayList<StandaloneCommand>(this.standaloneApplication.getCommands());
        Collections.sort(commands, CommandComparator.INSTANCE);
        StringBuilder s = new StringBuilder();
        s.append(StandaloneMessages.Standalone_Help);
        s.append("\n");
        for (StandaloneCommand command : commands) {
            s.append("\nocl ");
            s.append(command.getName());
            ArrayList<StandaloneCommand.CommandToken> tokens = new ArrayList<StandaloneCommand.CommandToken>(command.getTokens());
            Collections.sort(tokens, TokenComparator.INSTANCE);
            for (StandaloneCommand.CommandToken token : tokens) {
                s.append(" ");
                if (!token.isSingleton()) {
                    s.append("(");
                }
                if (!token.isRequired()) {
                    s.append("[");
                }
                s.append(token.getName());
                String argsHelp = token.getArgsHelp();
                if (argsHelp != null) {
                    s.append(" ");
                    s.append(argsHelp);
                }
                if (!token.isRequired()) {
                    s.append("]");
                }
                if (token.isSingleton()) continue;
                s.append(")*");
            }
            s.append("\n  ");
            s.append(command.getHelp());
            for (StandaloneCommand.CommandToken token : tokens) {
                s.append("\n    ");
                s.append(token.getName());
                s.append(": ");
                s.append(token.isRequired() ? StandaloneMessages.HelpText_Required : StandaloneMessages.HelpText_Optional);
                if (!token.isSingleton()) {
                    s.append(" " + StandaloneMessages.HelpText_repeatable);
                }
                s.append(" " + StandaloneMessages.HelpText_token);
                s.append(". ");
                s.append(token.getHelp().replace("\n", "\n        "));
            }
            s.append("\n");
        }
        System.out.println(s.toString());
        return StandaloneResponse.OK;
    }

    @Override
    public @Nullable Map<StandaloneCommand.CommandToken, List<String>> parse(@NonNull String @NonNull [] arguments) {
        Map<StandaloneCommand.CommandToken, List<String>> tokens = super.parse(arguments);
        if (tokens.size() > 0) {
            logger.error((Object)StandaloneMessages.HelpCommand_Bad);
            return null;
        }
        return tokens;
    }

    protected static final class CommandComparator
    implements Comparator<StandaloneCommand> {
        public static final @NonNull CommandComparator INSTANCE = new CommandComparator();

        protected CommandComparator() {
        }

        @Override
        public int compare(StandaloneCommand o1, StandaloneCommand o2) {
            String n1 = o1.getName();
            String n2 = o2.getName();
            return n1.compareTo(n2);
        }
    }

    protected static final class TokenComparator
    implements Comparator<StandaloneCommand.CommandToken> {
        public static final @NonNull TokenComparator INSTANCE = new TokenComparator();

        protected TokenComparator() {
        }

        @Override
        public int compare(StandaloneCommand.CommandToken o1, StandaloneCommand.CommandToken o2) {
            String n1 = o1.getName();
            String n2 = o2.getName();
            return n1.compareTo(n2);
        }
    }
}

