/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.uml.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.uml.BooleanLiteralExp;
import org.eclipse.ocl.uml.CollectionItem;
import org.eclipse.ocl.uml.CollectionLiteralExp;
import org.eclipse.ocl.uml.CollectionRange;
import org.eclipse.ocl.uml.CollectionType;
import org.eclipse.ocl.uml.EnumLiteralExp;
import org.eclipse.ocl.uml.IfExp;
import org.eclipse.ocl.uml.IntegerLiteralExp;
import org.eclipse.ocl.uml.IterateExp;
import org.eclipse.ocl.uml.IteratorExp;
import org.eclipse.ocl.uml.LetExp;
import org.eclipse.ocl.uml.MessageExp;
import org.eclipse.ocl.uml.OperationCallExp;
import org.eclipse.ocl.uml.OrderedSetType;
import org.eclipse.ocl.uml.PropertyCallExp;
import org.eclipse.ocl.uml.RealLiteralExp;
import org.eclipse.ocl.uml.SetType;
import org.eclipse.ocl.uml.StringLiteralExp;
import org.eclipse.ocl.uml.TupleLiteralExp;
import org.eclipse.ocl.uml.TupleLiteralPart;
import org.eclipse.ocl.uml.TupleType;
import org.eclipse.ocl.uml.UMLFactory;
import org.eclipse.ocl.uml.UnlimitedNaturalLiteralExp;
import org.eclipse.ocl.uml.UnspecifiedValueExp;
import org.eclipse.ocl.uml.Variable;
import org.eclipse.ocl.uml.VariableExp;
import org.eclipse.ocl.uml.tests.AbstractTestSuite;
import org.eclipse.uml2.uml.CallOperationAction;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.SendSignalAction;
import org.eclipse.uml2.uml.Signal;

public class ExpressionsValidatorTest
extends AbstractTestSuite {
    UMLFactory factory = UMLFactory.eINSTANCE;
    org.eclipse.uml2.uml.UMLFactory umlFactory = org.eclipse.uml2.uml.UMLFactory.eINSTANCE;

    public void test_BooleanLiteralExp_checkBooleanType() {
        BooleanLiteralExp bl = this.factory.createBooleanLiteralExp();
        bl.setBooleanSymbol(Boolean.valueOf(true));
        bl.setType((Object)this.apple);
        this.assertProblem((EObject)bl, 1);
        bl.setType((Object)((Classifier)this.getOCLStandardLibrary().getInteger()));
        this.assertProblem((EObject)bl, 1);
        bl.setType((Object)((Classifier)this.getOCLStandardLibrary().getBoolean()));
        this.assertOK((EObject)bl, 1);
    }

    public void test_CollectionItem_checkItemType() {
        CollectionItem i = this.factory.createCollectionItem();
        CollectionType ctype = this.factory.createCollectionType();
        ctype.setElementType((Object)this.fruit);
        i.setType((Object)ctype);
        CollectionLiteralExp item = this.factory.createCollectionLiteralExp();
        CollectionType itemType = this.factory.createCollectionType();
        itemType.setElementType((Object)this.apple);
        item.setType((Object)itemType);
        i.setItem((OCLExpression)item);
        this.assertProblem((EObject)i, 2);
        item.setType((Object)ctype);
        this.assertOK((EObject)i, 2);
    }

    public void test_CollectionLiteralExp_checkNoCollectionInstances() {
        CollectionLiteralExp cl = this.factory.createCollectionLiteralExp();
        cl.setKind(CollectionKind.COLLECTION_LITERAL);
        this.assertProblem((EObject)cl, 3);
        cl.setKind(CollectionKind.BAG_LITERAL);
        this.assertOK((EObject)cl, 3);
    }

    public void test_CollectionLiteralExp_checkSetKind() {
        CollectionLiteralExp cl = this.factory.createCollectionLiteralExp();
        cl.setKind(CollectionKind.COLLECTION_LITERAL);
        cl.setType((Object)this.factory.createBagType());
        this.assertOK((EObject)cl, 4);
        cl.setKind(CollectionKind.SET_LITERAL);
        this.assertProblem((EObject)cl, 4);
        cl.setType((Object)this.factory.createSetType());
        this.assertOK((EObject)cl, 4);
    }

    public void test_CollectionLiteralExp_checkSequenceKind() {
        CollectionLiteralExp cl = this.factory.createCollectionLiteralExp();
        cl.setKind(CollectionKind.COLLECTION_LITERAL);
        cl.setType((Object)this.factory.createBagType());
        this.assertOK((EObject)cl, 5);
        cl.setKind(CollectionKind.SEQUENCE_LITERAL);
        this.assertProblem((EObject)cl, 5);
        cl.setType((Object)this.factory.createSequenceType());
        this.assertOK((EObject)cl, 5);
    }

    public void test_CollectionLiteralExp_checkBagKind() {
        CollectionLiteralExp cl = this.factory.createCollectionLiteralExp();
        cl.setKind(CollectionKind.COLLECTION_LITERAL);
        cl.setType((Object)this.factory.createSetType());
        this.assertOK((EObject)cl, 6);
        cl.setKind(CollectionKind.BAG_LITERAL);
        this.assertProblem((EObject)cl, 6);
        cl.setType((Object)this.factory.createBagType());
        this.assertOK((EObject)cl, 6);
    }

    public void test_CollectionLiteralExp_checkElementType() {
        CollectionLiteralExp cl = this.factory.createCollectionLiteralExp();
        cl.setKind(CollectionKind.SET_LITERAL);
        SetType ctype = this.factory.createSetType();
        ctype.setElementType((Object)this.fruit);
        cl.setType((Object)ctype);
        CollectionItem item1 = this.factory.createCollectionItem();
        item1.setType((Object)this.apple);
        CollectionItem item2 = this.factory.createCollectionItem();
        item2.setType((Object)this.color);
        cl.getPart().add((Object)item1);
        cl.getPart().add((Object)item2);
        this.assertProblem((EObject)cl, 7);
        item2.setType((Object)this.fruit);
        this.assertOK((EObject)cl, 7);
    }

    public void test_CollectionLiteralExp_checkElementType_emptySet() {
        CollectionLiteralExp cl = this.factory.createCollectionLiteralExp();
        cl.setKind(CollectionKind.SET_LITERAL);
        SetType ctype = this.factory.createSetType();
        ctype.setElementType((Object)this.fruit);
        cl.setType((Object)ctype);
        this.assertProblem((EObject)cl, 7);
        ctype.setElementType((Object)((Classifier)this.getOCLStandardLibrary().getOclVoid()));
        this.assertOK((EObject)cl, 7);
    }

    public void test_CollectionRange_checkRangeType() {
        CollectionRange r = this.factory.createCollectionRange();
        r.setType((Object)this.fruit);
        IntegerLiteralExp first = this.factory.createIntegerLiteralExp();
        first.setType((Object)this.apple);
        TupleLiteralExp last = this.factory.createTupleLiteralExp();
        last.setType((Object)this.color);
        r.setFirst((OCLExpression)first);
        r.setLast((OCLExpression)last);
        this.assertProblem((EObject)r, 8);
        last.setType((Object)this.fruit);
        this.assertOK((EObject)r, 8);
    }

    public void test_EnumLiteralExp_checkEnumType() {
        EnumLiteralExp el = this.factory.createEnumLiteralExp();
        el.setType((Object)this.fruit);
        el.setReferredEnumLiteral((Object)this.color_red);
        this.assertProblem((EObject)el, 9);
        el.setType((Object)this.color);
        this.assertOK((EObject)el, 9);
    }

    public void test_IfExp_checkBooleanCondition() {
        IfExp ie = this.factory.createIfExp();
        BooleanLiteralExp cond = this.factory.createBooleanLiteralExp();
        cond.setType((Object)((Classifier)this.getOCLStandardLibrary().getInteger()));
        ie.setCondition((OCLExpression)cond);
        this.assertProblem((EObject)ie, 10);
        cond.setType((Object)((Classifier)this.getOCLStandardLibrary().getBoolean()));
        this.assertOK((EObject)ie, 10);
    }

    public void test_IfExp_checkIfType() {
        IfExp ie = this.factory.createIfExp();
        ie.setType((Object)this.fruit);
        BooleanLiteralExp thenPart = this.factory.createBooleanLiteralExp();
        thenPart.setType((Object)this.apple);
        TupleLiteralExp elsePart = this.factory.createTupleLiteralExp();
        elsePart.setType((Object)this.color);
        ie.setThenExpression((OCLExpression)thenPart);
        ie.setElseExpression((OCLExpression)elsePart);
        this.assertProblem((EObject)ie, 11);
        elsePart.setType((Object)this.fruit);
        this.assertOK((EObject)ie, 11);
    }

    public void test_IntegerLiteralExp_checkIntegerType() {
        IntegerLiteralExp il = this.factory.createIntegerLiteralExp();
        il.setIntegerSymbol(Integer.valueOf(42));
        il.setType((Object)this.apple);
        this.assertProblem((EObject)il, 12);
        il.setType((Object)((Classifier)this.getOCLStandardLibrary().getBoolean()));
        this.assertProblem((EObject)il, 12);
        il.setType((Object)((Classifier)this.getOCLStandardLibrary().getInteger()));
        this.assertOK((EObject)il, 12);
    }

    public void test_IterateExp_checkIterateType() {
        IterateExp i = this.factory.createIterateExp();
        i.setType((Object)this.fruit);
        Variable resultVar = this.factory.createVariable();
        resultVar.setType((Object)this.color);
        i.setResult((org.eclipse.ocl.expressions.Variable)resultVar);
        this.assertProblem((EObject)i, 14);
        resultVar.setType((Object)this.apple);
        this.assertProblem((EObject)i, 14);
        i.setType((Object)this.apple);
        this.assertOK((EObject)i, 14);
    }

    public void test_IterateExp_checkBodyType() {
        IterateExp i = this.factory.createIterateExp();
        i.setType((Object)this.fruit);
        Variable resultVar = this.factory.createVariable();
        resultVar.setType((Object)this.fruit);
        i.setResult((org.eclipse.ocl.expressions.Variable)resultVar);
        BooleanLiteralExp body = this.factory.createBooleanLiteralExp();
        body.setType((Object)this.color);
        i.setBody((OCLExpression)body);
        this.assertProblem((EObject)i, 15);
        body.setType((Object)this.apple);
        this.assertOK((EObject)i, 15);
    }

    public void test_IterateExp_checkResultInit() {
        IterateExp i = this.factory.createIterateExp();
        i.setType((Object)this.fruit);
        Variable resultVar = this.factory.createVariable();
        resultVar.setType((Object)this.fruit);
        i.setResult((org.eclipse.ocl.expressions.Variable)resultVar);
        this.assertProblem((EObject)i, 16);
        resultVar.setInitExpression((OCLExpression)this.factory.createUnspecifiedValueExp());
        this.assertOK((EObject)i, 16);
    }

    public void test_IteratorExp_checkBooleanType() {
        IteratorExp i = this.factory.createIteratorExp();
        i.setType((Object)this.apple);
        i.setName("select");
        this.assertOK((EObject)i, 21);
        for (String name : Arrays.asList("forAll", "exists", "isUnique")) {
            i.setName(name);
            this.assertProblem((EObject)i, 21);
        }
        i.setType((Object)((Classifier)this.getOCLStandardLibrary().getBoolean()));
        for (String name : Arrays.asList("forAll", "exists", "isUnique")) {
            i.setName(name);
            this.assertOK((EObject)i, 21);
        }
    }

    public void test_IteratorExp_checkCollectType() {
        Classifier set = (Classifier)this.getOCLStandardLibrary().getSet();
        Classifier orderedSet = (Classifier)this.getOCLStandardLibrary().getOrderedSet();
        Classifier sequence = (Classifier)this.getOCLStandardLibrary().getSequence();
        Classifier bag = (Classifier)this.getOCLStandardLibrary().getBag();
        ArrayList<Classifier[]> badPairs = new ArrayList<Classifier[]>();
        badPairs.add(new Classifier[]{set, sequence});
        badPairs.add(new Classifier[]{bag, sequence});
        badPairs.add(new Classifier[]{sequence, bag});
        badPairs.add(new Classifier[]{sequence, set});
        badPairs.add(new Classifier[]{orderedSet, bag});
        ArrayList<Classifier[]> goodPairs = new ArrayList<Classifier[]>();
        goodPairs.add(new Classifier[]{set, bag});
        goodPairs.add(new Classifier[]{bag, bag});
        goodPairs.add(new Classifier[]{sequence, sequence});
        goodPairs.add(new Classifier[]{orderedSet, sequence});
        IteratorExp i = this.factory.createIteratorExp();
        i.setName("collect");
        BooleanLiteralExp source = this.factory.createBooleanLiteralExp();
        i.setSource((OCLExpression)source);
        for (Classifier[] pair : badPairs) {
            source.setType((Object)pair[0]);
            i.setType((Object)pair[1]);
            this.assertProblem((EObject)i, 22);
        }
        for (Classifier[] pair : goodPairs) {
            source.setType((Object)pair[0]);
            i.setType((Object)pair[1]);
            this.assertOK((EObject)i, 22);
        }
    }

    public void test_IteratorExp_checkSelectRejectType() {
        IteratorExp i = this.factory.createIteratorExp();
        i.setType((Object)((Classifier)this.getOCLStandardLibrary().getSet()));
        BooleanLiteralExp source = this.factory.createBooleanLiteralExp();
        source.setType((Object)((Classifier)this.getOCLStandardLibrary().getBag()));
        i.setSource((OCLExpression)source);
        for (String name : Arrays.asList("select", "reject")) {
            i.setName(name);
            this.assertProblem((EObject)i, 23);
        }
        i.setType((Object)((Classifier)this.getOCLStandardLibrary().getBag()));
        for (String name : Arrays.asList("select", "reject")) {
            i.setName(name);
            this.assertOK((EObject)i, 23);
        }
    }

    public void test_IteratorExp_checkBooleanBodyType() {
        List<String> names = Arrays.asList("select", "reject", "forAll", "exists", "any", "one");
        IteratorExp i = this.factory.createIteratorExp();
        i.setType((Object)((Classifier)this.getOCLStandardLibrary().getSet()));
        BooleanLiteralExp body = this.factory.createBooleanLiteralExp();
        body.setType((Object)((Classifier)this.getOCLStandardLibrary().getBag()));
        i.setBody((OCLExpression)body);
        i.setName("collect");
        this.assertOK((EObject)i, 24);
        for (String name : names) {
            i.setName(name);
            this.assertProblem((EObject)i, 24);
        }
        body.setType((Object)((Classifier)this.getOCLStandardLibrary().getBoolean()));
        for (String name : names) {
            i.setName(name);
            this.assertOK((EObject)i, 24);
        }
    }

    public void test_LetExp_checkLetType() {
        LetExp l = this.factory.createLetExp();
        l.setType((Object)((Classifier)this.getOCLStandardLibrary().getBag()));
        BooleanLiteralExp in = this.factory.createBooleanLiteralExp();
        in.setType((Object)((Classifier)this.getOCLStandardLibrary().getBoolean()));
        l.setIn((OCLExpression)in);
        this.assertProblem((EObject)l, 25);
        l.setType((Object)((Classifier)in.getType()));
        this.assertOK((EObject)l, 25);
    }

    public void test_LoopExp_checkSourceCollection() {
        IterateExp l = this.factory.createIterateExp();
        BooleanLiteralExp source = this.factory.createBooleanLiteralExp();
        l.setSource((OCLExpression)source);
        source.setType((Object)((Classifier)this.getOCLStandardLibrary().getBoolean()));
        this.assertProblem((EObject)l, 17);
        source.setType((Object)((Classifier)this.getOCLStandardLibrary().getSet()));
        this.assertOK((EObject)l, 17);
    }

    public void test_LoopExp_checkLoopVariableInit() {
        IterateExp l = this.factory.createIterateExp();
        Variable iter = this.factory.createVariable();
        l.getIterator().add((Object)iter);
        iter = this.factory.createVariable();
        l.getIterator().add((Object)iter);
        this.assertOK((EObject)l, 18);
        iter.setInitExpression((OCLExpression)this.factory.createBooleanLiteralExp());
        this.assertProblem((EObject)l, 18);
    }

    public void test_LoopExp_checkLoopVariableType() {
        IterateExp l = this.factory.createIterateExp();
        CollectionType ctype = this.factory.createCollectionType();
        ctype.setElementType((Object)this.fruit);
        CollectionLiteralExp source = this.factory.createCollectionLiteralExp();
        source.setType((Object)ctype);
        l.setSource((OCLExpression)source);
        Variable iter = this.factory.createVariable();
        iter.setType((Object)this.fruit);
        l.getIterator().add((Object)iter);
        iter = this.factory.createVariable();
        iter.setType((Object)this.apple);
        l.getIterator().add((Object)iter);
        this.assertProblem((EObject)l, 19);
        iter.setType((Object)this.fruit);
        this.assertOK((EObject)l, 19);
    }

    public void test_MessageExp_checkOperationArguments() {
        MessageExp m = this.factory.createMessageExp();
        CallOperationAction action = this.umlFactory.createCallOperationAction();
        m.setCalledOperation((Object)action);
        action.setOperation(this.fruit_ripen);
        UnspecifiedValueExp arg = this.factory.createUnspecifiedValueExp();
        arg.setType((Object)((Classifier)this.getOCLStandardLibrary().getBoolean()));
        m.getArgument().add((Object)arg);
        this.assertProblem((EObject)m, 26);
        arg.setType((Object)this.color);
        this.assertOK((EObject)m, 26);
        action.setOperation(this.fruit_newFruit);
        this.assertProblem((EObject)m, 26);
        m.getArgument().clear();
        this.assertOK((EObject)m, 26);
    }

    public void test_MessageExp_checkSignalArguments() {
        MessageExp m = this.factory.createMessageExp();
        SendSignalAction action = this.umlFactory.createSendSignalAction();
        m.setSentSignal((Object)action);
        Signal drop = (Signal)((Package)this.fruitPackage).getOwnedType("Drop");
        ExpressionsValidatorTest.assertNotNull((Object)drop);
        action.setSignal(drop);
        UnspecifiedValueExp arg = this.factory.createUnspecifiedValueExp();
        arg.setType((Object)((Classifier)this.getOCLStandardLibrary().getInteger()));
        m.getArgument().add((Object)arg);
        arg = this.factory.createUnspecifiedValueExp();
        arg.setType((Object)((Classifier)this.getOCLStandardLibrary().getBoolean()));
        m.getArgument().add((Object)arg);
        this.assertProblem((EObject)m, 27);
        arg.setType((Object)this.stem);
        this.assertOK((EObject)m, 27);
        m.getArgument().remove((Object)arg);
        this.assertProblem((EObject)m, 27);
    }

    public void test_MessageExp_checkTargetDefinesOperation() {
        MessageExp m = this.factory.createMessageExp();
        CallOperationAction action = this.umlFactory.createCallOperationAction();
        m.setCalledOperation((Object)action);
        action.setOperation(this.fruit_ripen);
        UnspecifiedValueExp arg = this.factory.createUnspecifiedValueExp();
        arg.setType((Object)this.color);
        m.getArgument().add((Object)arg);
        BooleanLiteralExp target = this.factory.createBooleanLiteralExp();
        m.setTarget((OCLExpression)target);
        target.setType((Object)this.color);
        this.assertProblem((EObject)m, 28);
        target.setType((Object)this.fruit);
        this.assertOK((EObject)m, 28);
    }

    public void test_MessageExp_checkHasOperationOrSignal() {
        MessageExp m = this.factory.createMessageExp();
        CallOperationAction coa = this.umlFactory.createCallOperationAction();
        coa.setOperation(this.fruit_ripen);
        SendSignalAction ssa = this.umlFactory.createSendSignalAction();
        Signal drop = (Signal)((Package)this.fruitPackage).getOwnedType("Drop");
        ExpressionsValidatorTest.assertNotNull((Object)drop);
        ssa.setSignal(drop);
        m.setCalledOperation((Object)coa);
        this.assertOK((EObject)m, 29);
        m.setSentSignal((Object)ssa);
        this.assertProblem((EObject)m, 29);
        m.setCalledOperation(null);
        this.assertOK((EObject)m, 29);
        m.setSentSignal(null);
        this.assertProblem((EObject)m, 29);
    }

    public void test_MessageExp_checkTargetNotCollection() {
        MessageExp m = this.factory.createMessageExp();
        CallOperationAction action = this.umlFactory.createCallOperationAction();
        m.setCalledOperation((Object)action);
        action.setOperation(this.fruit_ripen);
        UnspecifiedValueExp arg = this.factory.createUnspecifiedValueExp();
        arg.setType((Object)this.color);
        m.getArgument().add((Object)arg);
        BooleanLiteralExp target = this.factory.createBooleanLiteralExp();
        m.setTarget((OCLExpression)target);
        target.setType((Object)this.factory.createSequenceType());
        this.assertProblem((EObject)m, 30);
        target.setType((Object)this.fruit);
        this.assertOK((EObject)m, 30);
    }

    public void test_OperationCallExp_checkArgumentsConform() {
        OperationCallExp o = this.factory.createOperationCallExp();
        Class fruitUtil = (Class)((Package)this.fruitPackage).getOwnedType("FruitUtil");
        Operation oper = fruitUtil.getOwnedOperation("processOrderedSet", null, null);
        o.setReferredOperation((Object)oper);
        UnspecifiedValueExp arg = this.factory.createUnspecifiedValueExp();
        o.getArgument().add((Object)arg);
        OrderedSetType ctype = this.factory.createOrderedSetType();
        ctype.setElementType((Object)this.color);
        arg.setType((Object)ctype);
        UnspecifiedValueExp source = this.factory.createUnspecifiedValueExp();
        source.setType((Object)fruitUtil);
        o.setSource((OCLExpression)source);
        this.assertProblem((EObject)o, 31);
        ctype.setElementType((Object)this.fruit);
        this.assertOK((EObject)o, 31);
    }

    public void test_OperationCallExp_checkArgumentsConform_generic_232028() {
        OperationCallExp o = (OperationCallExp)this.parseUnvalidated("context UML::String inv: Set{}->including('foo')");
        UnspecifiedValueExp arg = this.factory.createUnspecifiedValueExp();
        arg.setType((Object)((Classifier)this.getOCLStandardLibrary().getInteger()));
        o.getArgument().add((Object)arg);
        this.assertOK((EObject)o, 31);
        o.getArgument().remove((Object)arg);
        this.assertOK((EObject)o, 31);
        o.getArgument().set(0, (Object)arg);
        this.assertOK((EObject)o, 31);
    }

    public void test_OperationCallExp_checkArgumentsConform_generic_collections_232028() {
        OperationCallExp o = (OperationCallExp)this.parseUnvalidated("context UML::String inv: Set{'foo'}->includesAll(Set{'bar'})");
        this.assertOK((EObject)o);
    }

    public void test_OperationCallExp_checkArgumentCount() {
        OperationCallExp o = this.factory.createOperationCallExp();
        Class fruitUtil = (Class)((Package)this.fruitPackage).getOwnedType("FruitUtil");
        Operation oper = fruitUtil.getOwnedOperation("processOrderedSet", null, null);
        o.setReferredOperation((Object)oper);
        UnspecifiedValueExp arg = this.factory.createUnspecifiedValueExp();
        o.getArgument().add((Object)arg);
        OrderedSetType ctype = this.factory.createOrderedSetType();
        ctype.setElementType((Object)this.color);
        arg.setType((Object)ctype);
        this.assertOK((EObject)o, 32);
        o.getArgument().add((Object)this.factory.createCollectionLiteralExp());
        this.assertProblem((EObject)o, 32);
        o.getArgument().clear();
        this.assertProblem((EObject)o, 32);
    }

    public void test_PropertyCallExp_checkPropertyType() {
        PropertyCallExp p = this.factory.createPropertyCallExp();
        p.setReferredProperty((Object)this.apple_label);
        p.setType((Object)((Classifier)this.getOCLStandardLibrary().getBoolean()));
        UnspecifiedValueExp source = this.factory.createUnspecifiedValueExp();
        source.setType((Object)this.apple);
        p.setSource((OCLExpression)source);
        this.assertProblem((EObject)p, 33);
        p.setType((Object)((Classifier)this.getOCLStandardLibrary().getString()));
        this.assertOK((EObject)p, 33);
    }

    public void test_RealLiteralExp_checkRealType() {
        RealLiteralExp rl = this.factory.createRealLiteralExp();
        rl.setRealSymbol(Double.valueOf(42.0));
        rl.setType((Object)this.apple);
        this.assertProblem((EObject)rl, 34);
        rl.setType((Object)((Classifier)this.getOCLStandardLibrary().getInteger()));
        this.assertProblem((EObject)rl, 34);
        rl.setType((Object)((Classifier)this.getOCLStandardLibrary().getReal()));
        this.assertOK((EObject)rl, 34);
    }

    public void test_StringLiteralExp_checkStringType() {
        StringLiteralExp sl = this.factory.createStringLiteralExp();
        sl.setStringSymbol("42");
        sl.setType((Object)this.apple);
        this.assertProblem((EObject)sl, 35);
        sl.setType((Object)((Classifier)this.getOCLStandardLibrary().getInteger()));
        this.assertProblem((EObject)sl, 35);
        sl.setType((Object)((Classifier)this.getOCLStandardLibrary().getString()));
        this.assertOK((EObject)sl, 35);
    }

    public void test_TupleLiteralExp_checkTupleType() {
        TupleLiteralExp t = this.factory.createTupleLiteralExp();
        TupleLiteralPart part1 = this.factory.createTupleLiteralPart();
        part1.setName("a");
        part1.setType((Object)((Classifier)this.getOCLStandardLibrary().getString()));
        t.getPart().add((Object)part1);
        TupleLiteralPart part2 = this.factory.createTupleLiteralPart();
        part2.setName("b");
        part2.setType((Object)((Classifier)this.getOCLStandardLibrary().getInteger()));
        t.getPart().add((Object)part2);
        t.setType((Object)((Classifier)this.getOCLStandardLibrary().getBag()));
        this.assertProblem((EObject)t, 36);
        TupleType tt = this.factory.createTupleType();
        t.setType((Object)tt);
        this.assertProblem((EObject)t, 36);
        Property a = (Property)this.ocl.getEnvironment().getUMLReflection().createProperty("a", (Object)((Classifier)this.getOCLStandardLibrary().getString()));
        tt.getOwnedAttributes().add((Object)a);
        part1.setAttribute((Object)a);
        this.assertProblem((EObject)t, 36);
        Property b = (Property)this.ocl.getEnvironment().getUMLReflection().createProperty("b", (Object)((Classifier)this.getOCLStandardLibrary().getInteger()));
        tt.getOwnedAttributes().add((Object)b);
        part2.setAttribute((Object)b);
        this.assertOK((EObject)t, 36);
    }

    public void test_TupleLiteralExp_checkPartsUnique() {
        TupleLiteralExp t = this.factory.createTupleLiteralExp();
        TupleLiteralPart part1 = this.factory.createTupleLiteralPart();
        part1.setName("a");
        part1.setType((Object)((Classifier)this.getOCLStandardLibrary().getString()));
        t.getPart().add((Object)part1);
        TupleLiteralPart part2 = this.factory.createTupleLiteralPart();
        part2.setName("a");
        part2.setType((Object)((Classifier)this.getOCLStandardLibrary().getInteger()));
        t.getPart().add((Object)part2);
        this.assertProblem((EObject)t, 37);
        part2.setName("b");
        this.assertOK((EObject)t, 37);
    }

    public void test_TupleLiteralExp_checkValueType() {
        TupleLiteralPart p = this.factory.createTupleLiteralPart();
        p.setName("a");
        p.setType((Object)this.fruit);
        UnspecifiedValueExp value = this.factory.createUnspecifiedValueExp();
        value.setType((Object)this.apple);
        p.setValue((OCLExpression)value);
        Property a = (Property)this.ocl.getEnvironment().getUMLReflection().createProperty("a", (Object)this.fruit);
        p.setAttribute((Object)a);
        this.assertProblem((EObject)p, 38);
        value.setType((Object)this.fruit);
        this.assertOK((EObject)p, 38);
    }

    public void test_UnlimitedNaturalLiteralExp_checkNaturalType() {
        UnlimitedNaturalLiteralExp ul = this.factory.createUnlimitedNaturalLiteralExp();
        ul.setIntegerSymbol(Integer.valueOf(42));
        ul.setType((Object)this.apple);
        this.assertProblem((EObject)ul, 13);
        ul.setType((Object)((Classifier)this.getOCLStandardLibrary().getString()));
        this.assertProblem((EObject)ul, 13);
        ul.setType((Object)((Classifier)this.getOCLStandardLibrary().getUnlimitedNatural()));
        this.assertOK((EObject)ul, 13);
    }

    public void test_VariableExp_checkVarType() {
        VariableExp v = this.factory.createVariableExp();
        v.setType((Object)this.fruit);
        Variable var = this.factory.createVariable();
        var.setName("a");
        var.setType((Object)this.apple);
        v.setReferredVariable((org.eclipse.ocl.expressions.Variable)var);
        this.assertProblem((EObject)v, 39);
        var.setType((Object)this.fruit);
        this.assertOK((EObject)v, 39);
    }

    public void test_Variable_checknitType() {
        Variable v = this.factory.createVariable();
        v.setName("a");
        v.setType((Object)this.fruit);
        this.assertOK((EObject)v, 20);
        UnspecifiedValueExp init = this.factory.createUnspecifiedValueExp();
        init.setType((Object)this.color);
        v.setInitExpression((OCLExpression)init);
        this.assertProblem((EObject)v, 20);
        init.setType((Object)this.apple);
        this.assertOK((EObject)v, 20);
    }

    protected Diagnostic validate(EObject target) {
        HashMap<java.lang.Class<Environment>, Environment> ctx = new HashMap<java.lang.Class<Environment>, Environment>();
        ctx.put(Environment.class, this.ocl.getEnvironment());
        return Diagnostician.INSTANCE.validate(target, ctx);
    }

    protected void assertProblem(EObject target, int code) {
        this.assertProblem(this.validate(target), target, code);
    }

    protected void assertProblem(Diagnostic diagnostic, EObject target, int code) {
        Diagnostic problem = this.findProblem(diagnostic, target, code);
        ExpressionsValidatorTest.assertNotNull((String)"Problem not found", (Object)problem);
        System.out.println("Found expected problem: " + problem.getMessage());
    }

    protected Diagnostic findProblem(Diagnostic diagnostic, EObject target, int code) {
        if ("org.eclipse.ocl.expressions".equals(diagnostic.getSource()) && diagnostic.getSeverity() != 0 && diagnostic.getData().contains(target) && diagnostic.getCode() == code) {
            return diagnostic;
        }
        for (Diagnostic child : diagnostic.getChildren()) {
            Diagnostic result = this.findProblem(child, target, code);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    protected Diagnostic findProblem(Diagnostic diagnostic, EObject target) {
        if ("org.eclipse.ocl.expressions".equals(diagnostic.getSource()) && diagnostic.getSeverity() != 0 && diagnostic.getData().contains(target)) {
            return diagnostic;
        }
        for (Diagnostic child : diagnostic.getChildren()) {
            Diagnostic result = this.findProblem(child, target);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    protected void assertOK(EObject target, int code) {
        this.assertOK(this.validate(target), target, code);
    }

    protected void assertOK(Diagnostic diagnostic, EObject target, int code) {
        ExpressionsValidatorTest.assertNull((String)"Problem found", (Object)this.findProblem(diagnostic, target, code));
    }

    protected void assertOK(EObject target) {
        this.assertOK(this.validate(target), target);
    }

    protected void assertOK(Diagnostic diagnostic, EObject target) {
        ExpressionsValidatorTest.assertNull((String)"Problem found", (Object)this.findProblem(diagnostic, target));
    }
}

