/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.uml.tests;

import java.util.List;
import org.eclipse.ocl.helper.ChoiceKind;
import org.eclipse.ocl.helper.ConstraintKind;
import org.eclipse.ocl.uml.tests.AbstractTestSuite;
import org.eclipse.uml2.uml.StateMachine;

public class StatesTest
extends AbstractTestSuite {
    public void test_isInState() {
        this.helper.setContext((Object)this.fruit);
        try {
            this.helper.createInvariant("oclIsInState(Ripe) implies not self.oclIsInState(Bad)");
            this.helper.createInvariant("Apple.allInstances()->forAll(not oclIsInState(Bad::Rotten))");
        }
        catch (Exception e) {
            StatesTest.fail((String)("Failed to parse: " + e.getLocalizedMessage()));
        }
        try {
            this.helper.createInvariant("Fruit.allInstances()->forAll(not oclIsInState(Bad::Rotten))");
            StatesTest.fail((String)"Should have failed to parse non-existent state");
        }
        catch (Exception e) {
            System.out.println("Got expected error: " + e.getLocalizedMessage());
        }
    }

    public void test_isInState_validation() {
        this.helper.setContext((Object)this.fruit);
        try {
            this.helper.createInvariant("self.oclIsInState()");
            StatesTest.fail((String)"Should have failed to parse empty arglist");
        }
        catch (Exception e) {
            System.out.println("Got expected error: " + e.getLocalizedMessage());
        }
        try {
            this.helper.createInvariant("Apple.allInstances()->forAll(oclIsInState(Bad, Rotten))");
            StatesTest.fail((String)"Should have failed to parse overabundant arglist");
        }
        catch (Exception e) {
            System.out.println("Got expected error: " + e.getLocalizedMessage());
        }
        try {
            this.helper.createInvariant("self.oclIsInState(color <> Color::black)");
            StatesTest.fail((String)"Should have failed to parse arg of wrong type");
        }
        catch (Exception e) {
            System.out.println("Got expected error: " + e.getLocalizedMessage());
        }
        try {
            this.helper.createInvariant("self.oclIsInState(OclTest::Fruit)");
            StatesTest.fail((String)"Should have failed to parse arg of wrong type");
        }
        catch (Exception e) {
            System.out.println("Got expected error: " + e.getLocalizedMessage());
        }
    }

    public void test_stateContentAssist() {
        this.helper.setContext((Object)this.fruit);
        try {
            List choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "self.oclIsInState(");
            StatesTest.assertNotNull((Object)choices);
            this.assertChoice(choices, ChoiceKind.STATE, "Ripe");
            this.assertChoice(choices, ChoiceKind.STATE, "Bad");
            choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "self.oclIsInState(Ripe::");
            StatesTest.assertNotNull((Object)choices);
            StatesTest.assertTrue((boolean)choices.isEmpty());
            choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "Apple.allInstances()->forAll(a : Apple | a.oclIsInState(");
            StatesTest.assertNotNull((Object)choices);
            this.assertChoice(choices, ChoiceKind.STATE, "Ripe");
            this.assertChoice(choices, ChoiceKind.STATE, "Bad");
            choices = this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, "Apple.allInstances()->forAll(a : Apple | a.oclIsInState(Bad::");
            StatesTest.assertNotNull((Object)choices);
            this.assertChoice(choices, ChoiceKind.STATE, "Bruised");
            this.assertChoice(choices, ChoiceKind.STATE, "Rotten");
        }
        catch (Exception e) {
            StatesTest.fail((String)("Parse failed: " + e.getLocalizedMessage()));
        }
    }

    public void test_multipleStateMachines() {
        this.expectModified = true;
        this.helper.setContext((Object)this.fruit);
        StateMachine machine2 = (StateMachine)this.fruit.createOwnedBehavior("Machine2", uml.getStateMachine());
        machine2.createRegion("Region1").createSubvertex("Ripe", uml.getState());
        try {
            try {
                this.helper.createInvariant("oclIsInState(Lifecycle::Ripe) implies not self.oclIsInState(Bad)");
                this.helper.createInvariant("oclIsInState(Machine2::Ripe) implies not self.oclIsInState(Bad)");
            }
            catch (Exception e) {
                StatesTest.fail((String)("Failed to parse: " + e.getLocalizedMessage()));
            }
            try {
                this.helper.createInvariant("oclIsInState(Ripe) implies not self.oclIsInState(Bad)");
                StatesTest.fail((String)"Should have failed to parse ambiguous state");
            }
            catch (Exception e) {
                System.out.println("Got expected error: " + e.getLocalizedMessage());
            }
        }
        finally {
            machine2.destroy();
        }
    }
}

