/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.tests;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.pivot.tests.PivotTestSuite;
import org.eclipse.ocl.examples.pivot.tests.TestOCL;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CompleteEnvironment;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.TupleType;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.ids.CollectionTypeId;
import org.eclipse.ocl.pivot.ids.ElementId;
import org.eclipse.ocl.pivot.ids.IdManager;
import org.eclipse.ocl.pivot.ids.TuplePartId;
import org.eclipse.ocl.pivot.ids.TupleTypeId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.complete.StandardLibraryInternal;
import org.eclipse.ocl.pivot.internal.manager.MetamodelManagerInternal;
import org.eclipse.ocl.pivot.internal.messages.PivotMessagesInternal;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.xtext.base.services.BaseLinkingService;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class EvaluateOclAnyOperationsTest4
extends PivotTestSuite {
    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{{false}, {true}};
        return Arrays.asList(data);
    }

    public EvaluateOclAnyOperationsTest4(boolean useCodeGen) {
        super(useCodeGen);
    }

    @Override
    protected @NonNull MyOCL createOCL() {
        return new MyOCL(this.getTestPackageName(), this.getName());
    }

    @Override
    protected @NonNull String getTestPackageName() {
        return "EvaluateOclAnyOperations";
    }

    @BeforeClass
    public static void resetCounter() throws Exception {
        PivotTestSuite.resetCounter();
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testEqual() {
        MyOCL ocl = this.createOCL();
        ocl.assertQueryTrue(null, "Boolean = Boolean");
        ocl.assertQueryFalse(null, "Boolean = Integer");
        ocl.assertQueryTrue(null, "OclVoid = OclVoid");
        ocl.assertQueryTrue(null, "OclInvalid = OclInvalid");
        ocl.assertQueryFalse(null, "OclInvalid = OclVoid");
        ocl.assertQueryTrue(null, "Set(String) = Set(String)");
        ocl.assertQueryFalse(null, "Set(String) = Set(Integer)");
        ocl.assertQueryFalse(null, "Set(String) = Sequence(String)");
        ocl.assertQueryTrue(null, "ocl::CollectionKind::_'Collection' = ocl::CollectionKind::_'Collection'");
        ocl.assertQueryFalse(null, "ocl::CollectionKind::_'Collection' = ocl::CollectionKind::_'Set'");
        ocl.loadEPackage("ecore", (EPackage)EcorePackage.eINSTANCE);
        ocl.assertQueryFalse(null, "ecore::EDate{value='2000-01-25'} = ecore::EDate{value='2000-01-24'}");
        ocl.assertQueryTrue(null, "ecore::EDate{value='2000-01-24'} = ecore::EDate{value='2000-01-24'}");
        ocl.assertQueryFalse(null, "ecore::EDate{value='2000-01-23'} = ecore::EDate{value='2000-01-24'}");
        ocl.assertQueryInvalid(null, "invalid = 3");
        ocl.assertQueryInvalid(null, "3 = invalid");
        ocl.assertQueryInvalid(null, "invalid = 3.0");
        ocl.assertQueryInvalid(null, "3.0 = invalid");
        ocl.assertQueryInvalid(null, "invalid = 'test'");
        ocl.assertQueryInvalid(null, "'test' = invalid");
        ocl.assertQueryInvalid(null, "invalid = true");
        ocl.assertQueryInvalid(null, "false = invalid");
        ocl.assertQueryInvalid(null, "invalid = Sequence{}");
        ocl.assertQueryInvalid(null, "Sequence{} = invalid");
        ocl.assertQueryInvalid(null, "invalid = invalid");
        ocl.assertQueryFalse(null, "null = 3");
        ocl.assertQueryFalse(null, "3 = null");
        ocl.assertQueryFalse(null, "null = 3.0");
        ocl.assertQueryFalse(null, "3.0 = null");
        ocl.assertQueryFalse(null, "null = 'test'");
        ocl.assertQueryFalse(null, "'test' = null");
        ocl.assertQueryFalse(null, "null = true");
        ocl.assertQueryFalse(null, "false = null");
        ocl.assertQueryFalse(null, "null = Sequence{}");
        ocl.assertQueryFalse(null, "Sequence{} = null");
        ocl.assertQueryTrue(null, "null = null");
        ocl.dispose();
    }

    @Test
    public void testGreaterThan() {
        MyOCL ocl = this.createOCL();
        StandardLibraryInternal standardLibrary = ocl.getStandardLibrary();
        ocl.loadEPackage("ecore", (EPackage)EcorePackage.eINSTANCE);
        ocl.assertQueryTrue(null, "ecore::EDate{value='2000-01-25'} > ecore::EDate{value='2000-01-24'}");
        ocl.assertQueryFalse(null, "ecore::EDate{value='2000-01-24'} > ecore::EDate{value='2000-01-24'}");
        ocl.assertQueryFalse(null, "ecore::EDate{value='2000-01-23'} > ecore::EDate{value='2000-01-24'}");
        ocl.assertSemanticErrorQuery(null, "invalid > 0", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, standardLibrary.getOclInvalidType(), ">", standardLibrary.getIntegerType());
        ocl.assertQueryInvalid(null, "0 > invalid");
        ocl.assertSemanticErrorQuery(null, "invalid > invalid", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, standardLibrary.getOclInvalidType(), ">", standardLibrary.getOclInvalidType());
        ocl.assertSemanticErrorQuery(null, "null > 0", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, standardLibrary.getOclVoidType(), ">", standardLibrary.getIntegerType());
        ocl.assertQueryInvalid(null, "0 > null");
        ocl.assertSemanticErrorQuery(null, "null > null", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, standardLibrary.getOclVoidType(), ">", standardLibrary.getOclVoidType());
        ocl.dispose();
    }

    @Test
    public void testGreaterThanOrEqual() {
        MyOCL ocl = this.createOCL();
        StandardLibraryInternal standardLibrary = ocl.getStandardLibrary();
        ocl.loadEPackage("ecore", (EPackage)EcorePackage.eINSTANCE);
        ocl.assertQueryTrue(null, "ecore::EDate{value='2000-01-25'} >= ecore::EDate{value='2000-01-24'}");
        ocl.assertQueryTrue(null, "ecore::EDate{value='2000-01-24'} >= ecore::EDate{value='2000-01-24'}");
        ocl.assertQueryFalse(null, "ecore::EDate{value='2000-01-23'} >= ecore::EDate{value='2000-01-24'}");
        ocl.assertSemanticErrorQuery(null, "invalid >= 0", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, standardLibrary.getOclInvalidType(), ">=", standardLibrary.getIntegerType());
        ocl.assertQueryInvalid(null, "0 >= invalid");
        ocl.assertSemanticErrorQuery(null, "invalid >= invalid", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, standardLibrary.getOclInvalidType(), ">=", standardLibrary.getOclInvalidType());
        ocl.assertSemanticErrorQuery(null, "null >= 0", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, standardLibrary.getOclVoidType(), ">=", standardLibrary.getIntegerType());
        ocl.assertQueryInvalid(null, "0 >= null");
        ocl.assertSemanticErrorQuery(null, "null >= null", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, standardLibrary.getOclVoidType(), ">=", standardLibrary.getOclVoidType());
        ocl.dispose();
    }

    @Test
    public void testLessThan() {
        MyOCL ocl = this.createOCL();
        StandardLibraryInternal standardLibrary = ocl.getStandardLibrary();
        ocl.loadEPackage("ecore", (EPackage)EcorePackage.eINSTANCE);
        ocl.assertQueryFalse(null, "ecore::EDate{value='2000-01-25'} < ecore::EDate{value='2000-01-24'}");
        ocl.assertQueryFalse(null, "ecore::EDate{value='2000-01-24'} < ecore::EDate{value='2000-01-24'}");
        ocl.assertQueryTrue(null, "ecore::EDate{value='2000-01-23'} < ecore::EDate{value='2000-01-24'}");
        ocl.assertSemanticErrorQuery(null, "invalid < 0", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, standardLibrary.getOclInvalidType(), "<", standardLibrary.getIntegerType());
        ocl.assertQueryInvalid(null, "0 < invalid");
        ocl.assertSemanticErrorQuery(null, "invalid < invalid", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, standardLibrary.getOclInvalidType(), "<", standardLibrary.getOclInvalidType());
        ocl.assertSemanticErrorQuery(null, "null < 0", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, standardLibrary.getOclVoidType(), "<", standardLibrary.getIntegerType());
        ocl.assertQueryInvalid(null, "0 < null");
        ocl.assertSemanticErrorQuery(null, "null < null", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, standardLibrary.getOclVoidType(), "<", standardLibrary.getOclVoidType());
        ocl.dispose();
    }

    @Test
    public void testLessThanOrEqual() {
        MyOCL ocl = this.createOCL();
        StandardLibraryInternal standardLibrary = ocl.getStandardLibrary();
        ocl.loadEPackage("ecore", (EPackage)EcorePackage.eINSTANCE);
        ocl.assertQueryFalse(null, "ecore::EDate{'2000-01-25'} <= ecore::EDate{'2000-01-24'}");
        ocl.assertQueryTrue(null, "ecore::EDate{'2000-01-24'} <= ecore::EDate{value='2000-01-24'}");
        ocl.assertQueryTrue(null, "ecore::EDate{value='2000-01-23'} <= ecore::EDate{value='2000-01-24'}");
        ocl.assertSemanticErrorQuery(null, "invalid <= 0", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, standardLibrary.getOclInvalidType(), "<=", standardLibrary.getIntegerType());
        ocl.assertQueryInvalid(null, "0 <= invalid");
        ocl.assertSemanticErrorQuery(null, "invalid <= invalid", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, standardLibrary.getOclInvalidType(), "<=", standardLibrary.getOclInvalidType());
        ocl.assertSemanticErrorQuery(null, "null <= 0", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, standardLibrary.getOclVoidType(), "<=", standardLibrary.getIntegerType());
        ocl.assertQueryInvalid(null, "0 <= null");
        ocl.assertSemanticErrorQuery(null, "null <= null", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, standardLibrary.getOclVoidType(), "<=", standardLibrary.getOclVoidType());
        ocl.dispose();
    }

    @Test
    public void testNotEqual() {
        BaseLinkingService.DEBUG_RETRY.setState(true);
        MyOCL ocl = this.createOCL();
        ocl.assertQueryFalse(null, "Boolean <> Boolean");
        ocl.assertQueryTrue(null, "Boolean <> Integer");
        ocl.assertQueryFalse(null, "OclVoid <> OclVoid");
        ocl.assertQueryFalse(null, "OclInvalid <> OclInvalid");
        ocl.assertQueryTrue(null, "OclInvalid <> OclVoid");
        ocl.assertQueryFalse(null, "Set(String) <> Set(String)");
        ocl.assertQueryTrue(null, "Set(String) <> Set(Integer)");
        ocl.assertQueryTrue(null, "Set(String) <> Sequence(String)");
        ocl.assertQueryFalse(null, "ocl::CollectionKind::_'Collection' <> ocl::CollectionKind::_'Collection'");
        ocl.assertQueryTrue(null, "ocl::CollectionKind::_'Collection' <> ocl::CollectionKind::_'Set'");
        ocl.loadEPackage("ecore", (EPackage)EcorePackage.eINSTANCE);
        ocl.assertQueryTrue(null, "ecore::EDate{value='2000-01-25'} <> ecore::EDate{value='2000-01-24'}");
        ocl.assertQueryFalse(null, "ecore::EDate{value='2000-01-24'} <> ecore::EDate{'2000-01-24'}");
        ocl.assertQueryTrue(null, "ecore::EDate{'2000-01-23'} <> ecore::EDate{'2000-01-24'}");
        ocl.assertQueryInvalid(null, "invalid <> 3");
        ocl.assertQueryInvalid(null, "3 <> invalid");
        ocl.assertQueryInvalid(null, "invalid <> 3.0");
        ocl.assertQueryInvalid(null, "3.0 <> invalid");
        ocl.assertQueryInvalid(null, "invalid <> 'test'");
        ocl.assertQueryInvalid(null, "'test' <> invalid");
        ocl.assertQueryInvalid(null, "invalid <> true");
        ocl.assertQueryInvalid(null, "false <> invalid");
        ocl.assertQueryInvalid(null, "invalid <> Sequence{}");
        ocl.assertQueryInvalid(null, "Sequence{} <> invalid");
        ocl.assertQueryInvalid(null, "invalid <> invalid");
        ocl.assertQueryTrue(null, "null <> 3");
        ocl.assertQueryTrue(null, "3 <> null");
        ocl.assertQueryTrue(null, "null <> 3.0");
        ocl.assertQueryTrue(null, "3.0 <> null");
        ocl.assertQueryTrue(null, "null <> 'test'");
        ocl.assertQueryTrue(null, "'test' <> null");
        ocl.assertQueryTrue(null, "null <> true");
        ocl.assertQueryTrue(null, "false <> null");
        ocl.assertQueryTrue(null, "null <> Sequence{}");
        ocl.assertQueryTrue(null, "Sequence{} <> null");
        ocl.assertQueryFalse(null, "null <> null");
        ocl.dispose();
    }

    @Test
    public void test_oclAsModelType() {
        MyOCL ocl = this.createOCL();
        ocl.assertSemanticErrorQuery(null, "invalid.oclAsModelType(OclAny)", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, "OclInvalid", "oclAsModelType", "OclAny");
        ocl.assertQueryInvalid(ocl.pkg1, "self.oclAsModelType(OclAny)");
        ocl.dispose();
    }

    @Test
    public void test_oclAsSet_explicit() {
        MyOCL ocl = this.createOCL();
        ocl.assertQueryResults(null, "Set{true}", "true.oclAsSet()");
        ocl.assertQueryResults(null, "Set{}", "null.oclAsSet()");
        ocl.assertQueryInvalid(null, "invalid.oclAsSet()");
        ocl.assertQueryResults(null, "Set{Set{1..4}}", "Set{1..4}->oclAsSet()");
        ocl.dispose();
    }

    @Test
    public void test_oclAsSet_implicit() {
        MyOCL ocl = this.createOCL();
        StandardLibraryInternal standardLibrary = ocl.getStandardLibrary();
        ocl.assertQueryResults(null, "Set{true}", "true->select(true)");
        ocl.assertQueryResults(null, "Set{true}", "Set{true}->select(true)");
        ocl.assertQueryResults(null, "Set{}", "null->select(true)");
        ocl.assertQueryResults(null, "Set{}", "Set{}->select(true)");
        ocl.assertQueryResults(null, "Set{null}", "Set{null}->select(true)");
        ocl.assertQueryInvalid(null, "invalid->select(true)");
        ocl.assertQueryResults(null, "false", "true.oclIsUndefined()");
        ocl.assertQueryResults(null, "false", "true->oclIsUndefined()");
        ocl.assertQueryResults(null, "true", "null.oclIsUndefined()");
        ocl.assertQueryResults(null, "false", "null->oclIsUndefined()");
        ocl.assertQueryResults(null, "true", "invalid.oclIsUndefined()");
        ocl.assertQueryResults(null, "true", "invalid->oclIsUndefined()");
        ocl.assertQueryEquals(null, 4, "'1234'.size()");
        ocl.assertQueryEquals(null, 1, "'1234'->size()");
        Class booleanType = standardLibrary.getBooleanType();
        ocl.assertQueryEquals(null, booleanType, "true.oclType()");
        Type collectionType = ocl.getCollectionType("Set", (Type)booleanType, false);
        ocl.assertQueryEquals(null, collectionType, "true->oclType()");
        ocl.dispose();
    }

    @Test
    public void test_oclAsType() {
        MyOCL ocl = this.createOCL();
        ocl.assertQueryInvalid(null, "invalid.oclAsType(String)");
        ocl.assertQueryInvalid(null, "invalid.oclAsType(Integer)");
        ocl.assertQueryInvalid(null, "invalid.oclAsType(Class)");
        ocl.assertQueryInvalid(null, "invalid.oclAsType(OclVoid)");
        ocl.assertQueryInvalid(null, "invalid.oclAsType(OclInvalid)");
        ocl.assertQueryInvalid(null, "invalid.oclAsType(Set(String))");
        ocl.assertQueryInvalid(null, "invalid.oclAsType(Tuple(a:String))");
        ocl.assertQueryInvalid(null, "invalid.oclAsType(ocl::Package)");
        ocl.assertQueryInvalid(null, "let s : String = null.oclAsType(String) in s");
        ocl.assertQueryInvalid(null, "null.oclAsType(Integer)");
        ocl.assertQueryInvalid(null, "null.oclAsType(Class)");
        ocl.assertQueryInvalid(null, "null.oclAsType(OclVoid)");
        ocl.assertQueryInvalid(null, "null.oclAsType(OclInvalid)");
        ocl.assertQueryInvalid(null, "null.oclAsType(Set(String))");
        ocl.assertQueryInvalid(null, "null.oclAsType(Tuple(a:String))");
        ocl.assertQueryInvalid(null, "null.oclAsType(ocl::Package)");
        ocl.assertQueryInvalid(null, "true.oclAsType(Integer)");
        ocl.assertQueryInvalid(null, "true.oclAsType(String)");
        ocl.assertQueryTrue(null, "true.oclAsType(Boolean)");
        ocl.assertQueryTrue(null, "true.oclAsType(OclAny)");
        ocl.assertQueryInvalid(null, "true.oclAsType(OclVoid)");
        ocl.assertQueryInvalid(null, "true.oclAsType(OclInvalid)");
        ocl.assertQueryEquals(null, 3, "3.oclAsType(Integer)");
        ocl.assertQueryEquals(null, 3.0, "3.oclAsType(Real)");
        ocl.assertQueryInvalid(null, "3.0.oclAsType(Integer)");
        ocl.assertQueryEquals(null, 3.0, "3.0.oclAsType(Real)");
        ocl.assertQueryInvalid(null, "3.oclAsType(String)");
        ocl.assertQueryEquals(null, 3, "3.oclAsType(OclAny)");
        ocl.assertQueryInvalid(null, "3.oclAsType(OclVoid)");
        ocl.assertQueryInvalid(null, "3.oclAsType(OclInvalid)");
        ocl.assertQueryInvalid(null, "3.14.oclAsType(Integer)");
        ocl.assertQueryEquals(null, 3.14, "3.14.oclAsType(Real)");
        ocl.assertQueryInvalid(null, "3.14.oclAsType(String)");
        ocl.assertQueryEquals(null, 3.14, "3.14.oclAsType(OclAny)");
        ocl.assertQueryInvalid(null, "3.14.oclAsType(OclVoid)");
        ocl.assertQueryInvalid(null, "3.14.oclAsType(OclInvalid)");
        ocl.assertQueryInvalid(null, "*.oclAsType(Integer)");
        ocl.assertQueryInvalid(null, "*.oclAsType(Real)");
        ocl.assertQueryUnlimited(null, "*.oclAsType(UnlimitedNatural)");
        ocl.assertQueryInvalid(null, "*.oclAsType(String)");
        ocl.assertQueryUnlimited(null, "*.oclAsType(OclAny)");
        ocl.assertQueryInvalid(null, "*.oclAsType(OclVoid)");
        ocl.assertQueryInvalid(null, "*.oclAsType(OclInvalid)");
        ocl.assertQueryInvalid(null, "Set{1,2}->oclAsType(Set(UnlimitedNatural))");
        ocl.assertQueryResults(null, "Set{1,2}", "Set{1,2}->oclAsType(Set(Integer))");
        ocl.assertQueryResults(null, "Set{1,2}", "Set{1,2}->oclAsType(Collection(Real))");
        ocl.assertQueryInvalid(null, "Set{1,2}->oclAsType(Collection(UnlimitedNatural))");
        ocl.assertQueryInvalid(null, "Set{1.0,2}->oclAsType(Collection(UnlimitedNatural))");
        ocl.assertQueryInvalid(null, "Set{1,2}->oclAsType(Sequence(UnlimitedNatural))");
        if (!useCodeGen) {
            ocl.assertQueryInvalid(null, "Set{1,2}.oclAsType(Set(UnlimitedNatural))");
        }
        ocl.assertQueryResults(null, "Bag{1,2}", "Set{1,2}.oclAsType(Integer)");
        if (!useCodeGen) {
            ocl.assertQueryInvalid(null, "Set{1,2}.oclAsType(Set(Integer))");
        }
        ocl.assertQueryResults(null, "Bag{1,2}", "Set{1,2}.oclAsType(Integer)");
        ocl.assertQueryResults(null, "Set{Set{1,2},Set{3,4}}", "Set{Set{1,2},Set{3,4}}->oclAsType(Set(Set(Integer)))");
        ocl.assertQueryResults(null, "Set{Set{1,2},Set{3,4}}", "Set{Set{1,2},Set{3,4}}->oclAsType(Set(Collection(Integer)))");
        ocl.assertQueryResults(null, "Set{Set{1,2},Set{3,4}}", "Set{Set{1,2},Set{3,4}}->oclAsType(Collection(Set(Integer)))");
        ocl.assertQueryResults(null, "Set{Set{1,2},Set{3,4}}", "Set{Set{1,2},Set{3,4}}->oclAsType(Set(Set(Real)))");
        ocl.assertQueryInvalid(null, "Set{Set{1,2},Set{3,4}}->oclAsType(Set(Sequence(Integer)))");
        ocl.assertQueryInvalid(null, "Set{Set{1,2},Set{3,4}}->oclAsType(Sequence(Set(Integer)))");
        ocl.assertSemanticErrorQuery(null, "3.oclAsType(OclAny).abs()", PivotMessagesInternal.UnresolvedOperation_ERROR_, "OclAny", "abs");
        ocl.assertSemanticErrorQuery(null, "let v : OclAny = 3 in v.abs()", PivotMessagesInternal.UnresolvedOperation_ERROR_, "OclAny", "abs");
        ocl.assertQueryEquals(null, 3, "let v : OclAny = 3 in v.oclAsType(Integer).abs()");
        ocl.assertQueryInvalid(null, "Integer.oclAsType(Real)");
        ocl.dispose();
    }

    @Test
    public void test_oclIsInvalid() {
        MyOCL ocl = this.createOCL();
        ocl.assertQueryTrue(null, "invalid.oclIsInvalid()");
        ocl.assertQueryFalse(null, "null.oclIsInvalid()");
        ocl.assertQueryFalse(null, "true.oclIsInvalid()");
        ocl.assertQueryFalse(null, "false.oclIsInvalid()");
        ocl.assertQueryFalse(null, "3.14.oclIsInvalid()");
        ocl.assertQueryFalse(null, "1.oclIsInvalid()");
        ocl.assertQueryFalse(null, "*.oclIsInvalid()");
        ocl.assertQueryFalse(null, "'invalid'.oclIsInvalid()");
        ocl.assertQueryFalse(ocl.pkg1, "self.oclIsInvalid()");
        ocl.assertQueryTrue(null, "('123a'.toInteger()).oclIsInvalid()");
        ocl.assertQueryTrue(null, "let a:Integer='123a'.toInteger() in a.oclIsInvalid()");
        ocl.dispose();
    }

    @Test
    public void test_oclIsKindOf() {
        MyOCL ocl = this.createOCL();
        ocl.assertQueryInvalid(null, "invalid.oclIsKindOf(OclInvalid)");
        ocl.assertQueryInvalid(null, "invalid.oclIsKindOf(OclVoid)");
        ocl.assertQueryInvalid(null, "invalid.oclIsKindOf(OclAny)");
        ocl.assertQueryInvalid(null, "invalid.oclIsKindOf(String)");
        ocl.assertQueryInvalid(null, "invalid.oclIsKindOf(Integer)");
        ocl.assertQueryInvalid(null, "invalid.oclIsKindOf(Class)");
        ocl.assertQueryInvalid(null, "invalid.oclIsKindOf(Bag(Boolean))");
        ocl.assertQueryInvalid(null, "invalid.oclIsKindOf(Tuple(a:Integer))");
        ocl.assertQueryInvalid(null, "invalid.oclIsKindOf(ocl::Package)");
        ocl.assertQueryFalse(null, "null.oclIsKindOf(OclInvalid)");
        ocl.assertQueryTrue(null, "null.oclIsKindOf(OclVoid)");
        ocl.assertQueryTrue(null, "null.oclIsKindOf(OclAny)");
        ocl.assertQueryTrue(null, "null.oclIsKindOf(String)");
        ocl.assertQueryTrue(null, "null.oclIsKindOf(Integer)");
        ocl.assertQueryTrue(null, "null.oclIsKindOf(Class)");
        ocl.assertQueryTrue(null, "null.oclIsKindOf(Bag(Boolean))");
        ocl.assertQueryTrue(null, "null.oclIsKindOf(Tuple(a:Integer))");
        ocl.assertQueryTrue(null, "null.oclIsKindOf(ocl::Package)");
        ocl.assertQueryFalse(null, "true.oclIsKindOf(OclInvalid)");
        ocl.assertQueryFalse(null, "true.oclIsKindOf(OclVoid)");
        ocl.assertQueryTrue(null, "true.oclIsKindOf(Boolean)");
        ocl.assertQueryFalse(null, "true.oclIsKindOf(Integer)");
        ocl.assertQueryFalse(null, "true.oclIsKindOf(String)");
        ocl.assertQueryTrue(null, "true.oclIsKindOf(OclAny)");
        ocl.assertQueryFalse(null, "true.oclIsKindOf(ocl::Package)");
        ocl.assertQueryFalse(null, "3.14.oclIsKindOf(OclInvalid)");
        ocl.assertQueryFalse(null, "3.14.oclIsKindOf(OclVoid)");
        ocl.assertQueryFalse(null, "3.14.oclIsKindOf(Boolean)");
        ocl.assertQueryTrue(null, "3.14.oclIsKindOf(Real)");
        ocl.assertQueryFalse(null, "3.14.oclIsKindOf(Integer)");
        ocl.assertQueryFalse(null, "3.14.oclIsKindOf(String)");
        ocl.assertQueryTrue(null, "3.14.oclIsKindOf(OclAny)");
        ocl.assertQueryFalse(null, "3.14.oclIsKindOf(ocl::Package)");
        ocl.assertQueryFalse(null, "1.oclIsKindOf(OclInvalid)");
        ocl.assertQueryFalse(null, "1.oclIsKindOf(OclVoid)");
        ocl.assertQueryFalse(null, "1.oclIsKindOf(Boolean)");
        ocl.assertQueryTrue(null, "1.oclIsKindOf(Real)");
        ocl.assertQueryTrue(null, "1.oclIsKindOf(Integer)");
        ocl.assertQueryTrue(null, "(-1).oclIsKindOf(Integer)");
        ocl.assertQueryTrue(null, "1.oclIsKindOf(Integer)");
        ocl.assertQueryFalse(null, "1.oclIsKindOf(String)");
        ocl.assertQueryTrue(null, "1.oclIsKindOf(OclAny)");
        ocl.assertQueryFalse(null, "1.oclIsKindOf(ocl::Package)");
        ocl.assertQueryFalse(null, "*.oclIsKindOf(OclInvalid)");
        ocl.assertQueryFalse(null, "*.oclIsKindOf(OclVoid)");
        ocl.assertQueryFalse(null, "*.oclIsKindOf(Boolean)");
        ocl.assertQueryFalse(null, "*.oclIsKindOf(Real)");
        ocl.assertQueryFalse(null, "*.oclIsKindOf(Integer)");
        ocl.assertQueryTrue(null, "*.oclIsKindOf(UnlimitedNatural)");
        ocl.assertQueryFalse(null, "*.oclIsKindOf(String)");
        ocl.assertQueryTrue(null, "*.oclIsKindOf(OclAny)");
        ocl.assertQueryFalse(null, "*.oclIsKindOf(ocl::Package)");
        ocl.assertQueryFalse(null, "'invalid'.oclIsKindOf(OclInvalid)");
        ocl.assertQueryFalse(null, "'null'.oclIsKindOf(OclVoid)");
        ocl.assertQueryFalse(null, "'true'.oclIsKindOf(Boolean)");
        ocl.assertQueryFalse(null, "'3.14'.oclIsKindOf(Real)");
        ocl.assertQueryFalse(null, "'1'.oclIsKindOf(Integer)");
        ocl.assertQueryFalse(null, "'*'.oclIsKindOf(UnlimitedNatural)");
        ocl.assertQueryTrue(null, "'string'.oclIsKindOf(String)");
        ocl.assertQueryTrue(null, "'any'.oclIsKindOf(OclAny)");
        ocl.assertQueryFalse(ocl.pkg1, "'self'.oclIsKindOf(ocl::Package)");
        ocl.assertQueryFalse(ocl.pkg1, "self.oclIsKindOf(OclInvalid)");
        ocl.assertQueryFalse(ocl.pkg1, "self.oclIsKindOf(OclVoid)");
        ocl.assertQueryFalse(ocl.pkg1, "self.oclIsKindOf(Boolean)");
        ocl.assertQueryFalse(ocl.pkg1, "self.oclIsKindOf(Real)");
        ocl.assertQueryFalse(ocl.pkg1, "self.oclIsKindOf(Integer)");
        ocl.assertQueryFalse(ocl.pkg1, "self.oclIsKindOf(UnlimitedNatural)");
        ocl.assertQueryFalse(ocl.pkg1, "self.oclIsKindOf(String)");
        ocl.assertQueryTrue(ocl.pkg1, "self.oclIsKindOf(OclAny)");
        ocl.assertQueryTrue(ocl.pkg1, "self.oclIsKindOf(ocl::Package)");
        ocl.dispose();
    }

    @Test
    public void test_oclIsModelKindOf() {
        MyOCL ocl = this.createOCL();
        ocl.assertSemanticErrorQuery(null, "invalid.oclIsModelKindOf(OclAny)", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, "OclInvalid", "oclIsModelKindOf", "OclAny");
        ocl.assertQueryInvalid(ocl.pkg1, "self.oclIsModelKindOf(OclAny)");
        ocl.dispose();
    }

    @Test
    public void test_oclIsTypeOf() {
        MyOCL ocl = this.createOCL();
        ocl.assertQueryInvalid(null, "invalid.oclIsTypeOf(OclInvalid)");
        ocl.assertQueryInvalid(null, "invalid.oclIsTypeOf(OclVoid)");
        ocl.assertQueryInvalid(null, "invalid.oclIsTypeOf(OclAny)");
        ocl.assertQueryInvalid(null, "invalid.oclIsTypeOf(Integer)");
        ocl.assertQueryInvalid(null, "invalid.oclIsTypeOf(String)");
        ocl.assertQueryInvalid(null, "invalid.oclIsTypeOf(Class)");
        ocl.assertQueryInvalid(null, "invalid.oclIsTypeOf(Set(String))");
        ocl.assertQueryInvalid(null, "invalid.oclIsTypeOf(ocl::Package)");
        ocl.assertQueryFalse(null, "null.oclIsTypeOf(OclInvalid)");
        ocl.assertQueryTrue(null, "null.oclIsTypeOf(OclVoid)");
        ocl.assertQueryFalse(null, "null.oclIsTypeOf(OclAny)");
        ocl.assertQueryFalse(null, "null.oclIsTypeOf(Integer)");
        ocl.assertQueryFalse(null, "null.oclIsTypeOf(String)");
        ocl.assertQueryFalse(null, "null.oclIsTypeOf(Class)");
        ocl.assertQueryFalse(null, "null.oclIsTypeOf(Set(String))");
        ocl.assertQueryFalse(null, "null.oclIsTypeOf(ocl::Package)");
        ocl.assertQueryFalse(null, "true.oclIsTypeOf(OclInvalid)");
        ocl.assertQueryFalse(null, "true.oclIsTypeOf(OclVoid)");
        ocl.assertQueryTrue(null, "true.oclIsTypeOf(Boolean)");
        ocl.assertQueryFalse(null, "true.oclIsTypeOf(String)");
        ocl.assertQueryFalse(null, "true.oclIsTypeOf(OclAny)");
        ocl.assertQueryFalse(null, "true.oclIsTypeOf(ocl::Package)");
        ocl.assertQueryFalse(null, "3.14.oclIsTypeOf(OclInvalid)");
        ocl.assertQueryFalse(null, "3.14.oclIsTypeOf(OclVoid)");
        ocl.assertQueryFalse(null, "3.14.oclIsTypeOf(Boolean)");
        ocl.assertQueryTrue(null, "3.14.oclIsTypeOf(Real)");
        ocl.assertQueryFalse(null, "3.14.oclIsTypeOf(Integer)");
        ocl.assertQueryFalse(null, "3.14.oclIsTypeOf(String)");
        ocl.assertQueryFalse(null, "3.14.oclIsTypeOf(OclAny)");
        ocl.assertQueryFalse(null, "3.14.oclIsTypeOf(ocl::Package)");
        ocl.assertQueryFalse(null, "1.oclIsTypeOf(OclInvalid)");
        ocl.assertQueryFalse(null, "1.oclIsTypeOf(OclVoid)");
        ocl.assertQueryFalse(null, "1.oclIsTypeOf(Boolean)");
        ocl.assertQueryFalse(null, "1.oclIsTypeOf(Real)");
        ocl.assertQueryTrue(null, "1.oclIsTypeOf(Integer)");
        ocl.assertQueryTrue(null, "(-1).oclIsTypeOf(Integer)");
        ocl.assertQueryFalse(null, "1.oclIsTypeOf(UnlimitedNatural)");
        ocl.assertQueryFalse(null, "1.oclIsTypeOf(String)");
        ocl.assertQueryFalse(null, "1.oclIsTypeOf(OclAny)");
        ocl.assertQueryFalse(null, "1.oclIsTypeOf(ocl::Package)");
        ocl.assertQueryFalse(null, "*.oclIsTypeOf(OclInvalid)");
        ocl.assertQueryFalse(null, "*.oclIsTypeOf(OclVoid)");
        ocl.assertQueryFalse(null, "*.oclIsTypeOf(Boolean)");
        ocl.assertQueryFalse(null, "*.oclIsTypeOf(Real)");
        ocl.assertQueryFalse(null, "*.oclIsTypeOf(Integer)");
        ocl.assertQueryTrue(null, "*.oclIsTypeOf(UnlimitedNatural)");
        ocl.assertQueryFalse(null, "*.oclIsTypeOf(String)");
        ocl.assertQueryFalse(null, "*.oclIsTypeOf(OclAny)");
        ocl.assertQueryFalse(null, "*.oclIsTypeOf(ocl::Package)");
        ocl.assertQueryFalse(null, "'invalid'.oclIsTypeOf(OclInvalid)");
        ocl.assertQueryFalse(null, "'null'.oclIsTypeOf(OclVoid)");
        ocl.assertQueryFalse(null, "'true'.oclIsTypeOf(Boolean)");
        ocl.assertQueryFalse(null, "'3.14'.oclIsTypeOf(Real)");
        ocl.assertQueryFalse(null, "'1'.oclIsTypeOf(Integer)");
        ocl.assertQueryFalse(null, "'*'.oclIsTypeOf(UnlimitedNatural)");
        ocl.assertQueryTrue(null, "'string'.oclIsTypeOf(String)");
        ocl.assertQueryFalse(null, "'any'.oclIsTypeOf(OclAny)");
        ocl.assertQueryFalse(ocl.pkg1, "'self'.oclIsTypeOf(ocl::Package)");
        ocl.assertQueryFalse(ocl.pkg1, "self.oclIsTypeOf(OclInvalid)");
        ocl.assertQueryFalse(ocl.pkg1, "self.oclIsTypeOf(OclVoid)");
        ocl.assertQueryFalse(ocl.pkg1, "self.oclIsTypeOf(Boolean)");
        ocl.assertQueryFalse(ocl.pkg1, "self.oclIsTypeOf(Real)");
        ocl.assertQueryFalse(ocl.pkg1, "self.oclIsTypeOf(Integer)");
        ocl.assertQueryFalse(ocl.pkg1, "self.oclIsTypeOf(UnlimitedNatural)");
        ocl.assertQueryFalse(ocl.pkg1, "self.oclIsTypeOf(String)");
        ocl.assertQueryFalse(ocl.pkg1, "self.oclIsTypeOf(OclAny)");
        ocl.assertQueryTrue(ocl.pkg1, "self.oclIsTypeOf(ocl::Package)");
        ocl.dispose();
    }

    @Test
    public void test_oclIsUndefined() {
        MyOCL ocl = this.createOCL();
        ocl.assertQueryTrue(null, "invalid.oclIsUndefined()");
        ocl.assertQueryTrue(null, "null.oclIsUndefined()");
        ocl.assertQueryFalse(null, "true.oclIsUndefined()");
        ocl.assertQueryFalse(null, "false.oclIsUndefined()");
        ocl.assertQueryFalse(null, "3.14.oclIsUndefined()");
        ocl.assertQueryFalse(null, "1.oclIsUndefined()");
        ocl.assertQueryFalse(null, "*.oclIsUndefined()");
        ocl.assertQueryFalse(null, "'null'.oclIsUndefined()");
        ocl.assertQueryFalse(ocl.pkg1, "self.oclIsUndefined()");
        ocl.dispose();
    }

    @Test
    public void test_oclModelType() {
        MyOCL ocl = this.createOCL();
        ocl.assertSemanticErrorQuery(null, "invalid.oclModelType()", PivotMessagesInternal.UnresolvedOperation_ERROR_, "OclInvalid", "oclModelType");
        ocl.assertQueryInvalid(ocl.pkg1, "self.oclModelType()");
        ocl.dispose();
    }

    @Test
    public void test_oclModelTypes() {
        MyOCL ocl = this.createOCL();
        ocl.assertSemanticErrorQuery(null, "invalid.oclModelTypes()", PivotMessagesInternal.UnresolvedOperation_ERROR_, "OclInvalid", "oclModelTypes");
        ocl.assertQueryInvalid(ocl.pkg1, "self.oclModelTypes()");
        ocl.dispose();
    }

    @Test
    public void test_oclType_Boolean() {
        Class primitiveType;
        MyOCL ocl = this.createOCL();
        StandardLibraryInternal standardLibrary = ocl.getStandardLibrary();
        Class booleanType = standardLibrary.getBooleanType();
        Class classType = standardLibrary.getClassType();
        Class clazz = primitiveType = useCodeGen ? classType : ocl.getMetamodelManager().getASClass("PrimitiveType");
        assert (primitiveType != null);
        ocl.assertQueryEquals(null, booleanType, "true.oclType()");
        ocl.assertQueryEquals(null, "Boolean", "true.oclType().name");
        ocl.assertQueryEquals(null, booleanType, "Boolean");
        ocl.assertQueryEquals(null, "Boolean", "Boolean.name");
        ocl.assertQueryEquals(null, primitiveType, "true.oclType().oclType()");
        ocl.assertQueryEquals(null, primitiveType.getName(), "true.oclType().oclType().name");
        ocl.assertQueryEquals(null, primitiveType, "Boolean.oclType()");
        ocl.assertQueryEquals(null, primitiveType.getName(), "Boolean.oclType().name");
        ocl.assertQueryEquals(null, classType, "true.oclType().oclType().oclType()");
        ocl.assertQueryEquals(null, "Class", "true.oclType().oclType().oclType().name");
        ocl.assertQueryResults(null, "Set{false,true}", "Boolean.allInstances()");
        ocl.assertQueryResults(null, "Set{false,true}", "true.oclType().allInstances()");
        ocl.assertQueryResults(null, "Set{}", "Boolean.oclType().allInstances()");
        ocl.assertQueryEquals(null, 1, "true.oclType().ownedOperations?->select(name = 'xor')->any(true)?.ownedParameters->size()");
        ocl.dispose();
    }

    @Test
    public void test_oclType_Classifier() {
        MyOCL ocl = this.createOCL();
        MetamodelManagerInternal metamodelManager = ocl.getMetamodelManager();
        StandardLibrary standardLibrary = metamodelManager.getStandardLibrary();
        @NonNull Class packageType = metamodelManager.getASClass("Package");
        ocl.assertQueryEquals(ocl.pkg1, packageType, "self.oclType()");
        ocl.assertQueryEquals(ocl.pkg1, "Package", "self.oclType().name");
        ocl.assertQueryEquals(null, packageType, "Package");
        ocl.assertQueryEquals(null, "Package", "Package.name");
        ocl.assertQueryEquals(null, standardLibrary.getClassType(), "Package.oclType()");
        ocl.assertQueryResults(null, "Set{}", "Package.allInstances()");
        ocl.assertQueryEquals(ocl.pkg1, 8, "Package.allInstances()->size()");
        ocl.assertQueryResults(ocl.pkg1, "self.oclAsType(Package)->closure(ownedPackages)->including(self)", "Package.allInstances()");
        ocl.assertQueryEquals(ocl.pkg1, 8, "self.oclType().allInstances()->size()");
        ocl.assertQueryEquals(ocl.pkg1, 0, "Package.oclType().allInstances()->size()");
        ocl.dispose();
    }

    @Test
    public void test_oclType_Collection() {
        MyOCL ocl = this.createOCL();
        CompleteEnvironment completeEnvironment = ocl.getCompleteEnvironment();
        StandardLibraryInternal standardLibrary = ocl.getStandardLibrary();
        ocl.assertQueryEquals(null, 1, "Set{1}->oclType().ownedOperations?->select(name = 'flatten')->size()");
        ocl.assertQueryEquals(null, completeEnvironment.getSetType((Type)standardLibrary.getOclVoidType(), false, null, null), "Set{}->oclType()");
        ocl.assertQueryEquals(null, completeEnvironment.getSetType((Type)standardLibrary.getIntegerType(), false, null, null), "Set{1}->oclType()");
        ocl.assertQueryResults(null, "Bag{'Integer'}", "Set{1}.oclType().name");
        ocl.assertQueryEquals(null, "Set", "Set{1}->oclType().name");
        ocl.assertSemanticErrorQuery(null, "Set{1}.allInstances()", PivotMessagesInternal.UnresolvedOperation_ERROR_, "Set(Integer)", "allInstances");
        ocl.assertSemanticErrorQuery(null, "Set{1}->allInstances()", PivotMessagesInternal.UnresolvedOperation_ERROR_, "Set(Integer)", "allInstances");
        ocl.assertSemanticErrorQuery(null, "Set{1}.oclType().allInstances()", PivotMessagesInternal.UnresolvedOperation_ERROR_, "Bag(Class)", "allInstances");
        ocl.assertSemanticErrorQuery(null, "Set{1}->oclType().allInstances()", PivotMessagesInternal.UnresolvedStaticOperationCall_ERROR_, "Set(Integer)", "allInstances", "");
        ocl.assertQueryResults(null, "Set{}", "Set.oclType().allInstances()");
        ocl.assertQueryEquals(null, standardLibrary.getIntegerType(), "Set{1}->oclType().elementType");
        ocl.dispose();
    }

    @Test
    public void test_oclType_Enumeration() {
        MyOCL ocl = this.createOCL();
        MetamodelManagerInternal metamodelManager = ocl.getMetamodelManager();
        StandardLibraryInternal standardLibrary = ocl.getStandardLibrary();
        @NonNull Class collectionKindType = metamodelManager.getASClass("CollectionKind");
        Class enumerationType = useCodeGen ? standardLibrary.getClassType() : standardLibrary.getEnumerationType();
        ocl.assertQueryEquals(null, metamodelManager.getASClass("CollectionKind"), "CollectionKind::Set.oclType()");
        ocl.assertQueryEquals(null, "CollectionKind", "CollectionKind::Set.oclType().name");
        ocl.assertQueryEquals(null, collectionKindType, "CollectionKind");
        ocl.assertQueryEquals(null, "CollectionKind", "CollectionKind.name");
        ocl.assertQueryEquals(null, enumerationType, "CollectionKind.oclType()");
        ocl.assertQueryEquals(null, 5, "CollectionKind.allLiterals->size()");
        ocl.assertSemanticErrorQuery(null, "CollectionKind.oclType().ownedLiteral", PivotMessagesInternal.UnresolvedStaticProperty_ERROR_, "Class", "ownedLiteral");
        ocl.assertQueryResults(null, "Set{CollectionKind::Bag,CollectionKind::Collection,CollectionKind::_'OrderedSet',CollectionKind::_'Sequence',CollectionKind::_'Set'}", "CollectionKind.allInstances()");
        ocl.assertQueryResults(null, "Set{CollectionKind::Bag,CollectionKind::Collection,CollectionKind::OrderedSet,CollectionKind::Sequence,CollectionKind::Set}", "CollectionKind::Set.oclType().allInstances()");
        ocl.assertQueryResults(null, "Set{}", "CollectionKind.oclType().allInstances()");
        ocl.dispose();
    }

    @Test
    public void test_oclType_Numeric() {
        MyOCL ocl = this.createOCL();
        StandardLibraryInternal standardLibrary = ocl.getStandardLibrary();
        Class primitiveType = useCodeGen ? standardLibrary.getClassType() : ocl.getMetamodelManager().getASClass("PrimitiveType");
        Class integerType = standardLibrary.getIntegerType();
        ocl.assertQueryEquals(null, standardLibrary.getIntegerType(), "3.oclType()");
        ocl.assertQueryEquals(null, standardLibrary.getRealType(), "3.0.oclType()");
        ocl.assertQueryEquals(null, standardLibrary.getUnlimitedNaturalType(), "*.oclType()");
        ocl.assertQueryEquals(null, primitiveType, "Integer.oclType()");
        ocl.assertQueryEquals(null, integerType, "Integer");
        ocl.assertSemanticErrorQuery(null, "Integer.allInstances()", PivotMessagesInternal.UnresolvedStaticOperationCall_ERROR_, "Integer", "allInstances", "");
        ocl.assertSemanticErrorQuery(null, "3.oclType().allInstances()", PivotMessagesInternal.UnresolvedStaticOperationCall_ERROR_, "Integer", "allInstances", "");
        ocl.assertQueryResults(null, "Set{}", "Integer.oclType().allInstances()");
        ocl.assertQueryEquals(null, "Integer", "4.oclType().name");
        ocl.dispose();
    }

    @Test
    public void test_oclType_OclAny() {
        MyOCL ocl = this.createOCL();
        StandardLibraryInternal standardLibrary = ocl.getStandardLibrary();
        Class anyType = standardLibrary.getOclAnyType();
        Class anyTypeClass = useCodeGen ? standardLibrary.getClassType() : ocl.getMetamodelManager().getASClass("AnyType");
        ocl.assertQueryEquals(null, standardLibrary.getOclVoidType(), "null.oclType()");
        ocl.assertQueryEquals(null, anyType, "OclAny");
        ocl.assertQueryEquals(null, "OclAny", "OclAny.name");
        ocl.assertQueryEquals(null, anyTypeClass, "OclAny.oclType()");
        ocl.assertSemanticErrorQuery(null, "OclAny.allInstances()", PivotMessagesInternal.UnresolvedStaticOperationCall_ERROR_, "OclAny", "allInstances", "");
        ocl.assertSemanticErrorQuery(null, "null.oclAsType(OclAny).oclType().allInstances()", PivotMessagesInternal.UnresolvedStaticOperationCall_ERROR_, "OclAny", "allInstances", "");
        ocl.assertQueryResults(null, "Set{}", "OclAny.oclType().allInstances()");
        ocl.dispose();
    }

    @Test
    public void test_oclType_OclInvalid() {
        MyOCL ocl = this.createOCL();
        StandardLibraryInternal standardLibrary = ocl.getStandardLibrary();
        Class invalidType = standardLibrary.getOclInvalidType();
        Class invalidTypeClass = useCodeGen ? standardLibrary.getClassType() : ocl.getMetamodelManager().getASClass("InvalidType");
        ocl.assertQueryInvalid(null, "invalid.oclType()");
        ocl.assertQueryInvalid(null, "invalid.oclType().name");
        ocl.assertQueryEquals(null, invalidType, "OclInvalid");
        ocl.assertQueryEquals(null, "OclInvalid", "OclInvalid.name");
        ocl.assertQueryEquals(null, invalidTypeClass, "OclInvalid.oclType()");
        ocl.assertQueryInvalid(null, "OclInvalid.allInstances()");
        ocl.assertQueryInvalid(null, "invalid.oclType().allInstances()");
        ocl.assertQueryResults(null, "Set{}", "OclInvalid.oclType().allInstances()");
        ocl.assertQueryInvalid(null, "invalid.oclType().ownedOperations->select(name = '=')->any(true).ownedParameters->size()");
        ocl.dispose();
    }

    @Test
    public void test_oclType_OclVoid() {
        MyOCL ocl = this.createOCL();
        StandardLibraryInternal standardLibrary = ocl.getStandardLibrary();
        Class voidTypeClass = useCodeGen ? standardLibrary.getClassType() : ocl.getMetamodelManager().getASClass("VoidType");
        Class nullType = standardLibrary.getOclVoidType();
        ocl.assertQueryEquals(null, nullType, "null.oclType()");
        ocl.assertQueryEquals(null, "OclVoid", "null.oclType().name");
        ocl.assertQueryEquals(null, nullType, "OclVoid");
        ocl.assertQueryEquals(null, "OclVoid", "OclVoid.name");
        ocl.assertQueryEquals(null, voidTypeClass, "OclVoid.oclType()");
        ocl.assertQueryResults(null, "Set{null}", "OclVoid.allInstances()");
        ocl.assertQueryResults(null, "Set{null}", "null.oclType().allInstances()");
        ocl.assertQueryResults(null, "Set{}", "OclVoid.oclType().allInstances()");
        ocl.assertQueryEquals(null, 1, "null.oclType().ownedOperations?->select(name = '=')->any(true)?.ownedParameters->size()");
        ocl.dispose();
    }

    @Test
    public void test_oclType_Tuple() {
        MyOCL ocl = this.createOCL();
        StandardLibraryInternal standardLibrary = ocl.getStandardLibrary();
        Class tupleTypeClass = useCodeGen ? standardLibrary.getClassType() : ocl.getMetamodelManager().getASClass("TupleType");
        TuplePartId partId = IdManager.getTuplePartId((int)0, (String)"a", (TypeId)TypeId.INTEGER);
        TupleTypeId tupleId = IdManager.getTupleTypeId((String)"Tuple", (TuplePartId[])new TuplePartId[]{partId});
        TupleType tupleType = ocl.getIdResolver().getTupleType(tupleId);
        ocl.assertQueryEquals(null, tupleType, "Tuple{a:Integer=3}.oclType()");
        ocl.assertQueryEquals(null, tupleType, "Tuple(a:Integer)");
        ocl.assertQueryEquals(null, tupleTypeClass, "Tuple(a:Integer).oclType()");
        ocl.assertSemanticErrorQuery(null, "Tuple(a:Integer).allInstances()", PivotMessagesInternal.UnresolvedStaticOperationCall_ERROR_, "Tuple(a:Integer[1])", "allInstances", "");
        ocl.assertSemanticErrorQuery(null, "Tuple{a:Integer=3}.oclType().allInstances()", PivotMessagesInternal.UnresolvedStaticOperationCall_ERROR_, "Tuple(a:Integer[1])", "allInstances", "");
        ocl.assertQueryResults(null, "Set{}", "Tuple(a:Integer).oclType().allInstances()");
        ocl.assertQueryEquals(null, "Tuple", "Tuple{a:Integer=3}.oclType().name");
        ocl.dispose();
    }

    @Test
    public void test_oclType() {
        Class primitiveType;
        MyOCL ocl = this.createOCL();
        StandardLibraryInternal standardLibrary = ocl.getStandardLibrary();
        Class clazz = primitiveType = useCodeGen ? standardLibrary.getClassType() : ocl.getMetamodelManager().getASClass("PrimitiveType");
        assert (primitiveType != null);
        ocl.assertQueryEquals(null, standardLibrary.getStringType(), "'string'.oclType()");
        ocl.assertQueryEquals(null, standardLibrary.getOclVoidType(), "self.oclType()");
        ocl.assertQueryEquals(null, primitiveType, "3.oclType().oclType()");
        ocl.assertQueryEquals(null, standardLibrary.getClassType(), "3.oclType().oclType().oclType()");
        ocl.assertQueryEquals(null, primitiveType, "Boolean.oclType()");
        ocl.assertQueryEquals(null, primitiveType.getName(), "Boolean.oclType().name");
        ocl.assertSemanticErrorQuery(null, "3.oclType(OclAny)", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, "Integer", "oclType", "OclAny");
        ocl.dispose();
    }

    @Test
    public void test_oclTypes() {
        Class classType;
        MyOCL ocl = this.createOCL();
        StandardLibraryInternal standardLibrary = ocl.getStandardLibrary();
        Class primitiveType = useCodeGen ? standardLibrary.getClassType() : ocl.getMetamodelManager().getASClass("PrimitiveType");
        Class clazz = classType = useCodeGen ? standardLibrary.getClassType() : ocl.getMetamodelManager().getASClass("Class");
        assert (primitiveType != null);
        CollectionTypeId bagTypeId = TypeId.BAG.getSpecializedId(new ElementId[]{TypeId.OCL_ANY});
        CollectionTypeId setTypeId = TypeId.SET.getSpecializedId(new ElementId[]{TypeId.OCL_ANY});
        if (!useCodeGen) {
            ocl.assertQueryEquals(null, ValueUtil.createSetOfEach((CollectionTypeId)setTypeId, (Object[])new Object[]{standardLibrary.getStringType()}), "'string'.oclTypes()");
            ocl.assertQueryEquals(null, ValueUtil.createSetOfEach((CollectionTypeId)setTypeId, (Object[])new Object[]{standardLibrary.getOclVoidType()}), "self.oclTypes()");
            ocl.assertQueryEquals(null, ValueUtil.createBagOfEach((CollectionTypeId)bagTypeId, (Object[])new Object[]{primitiveType}), "3.oclTypes().oclType()");
            ocl.assertQueryEquals(null, ValueUtil.createBagOfEach((CollectionTypeId)bagTypeId, (Object[])new Object[]{classType}), "3.oclTypes().oclType().oclType()");
            ocl.assertQueryEquals(null, ValueUtil.createSetOfEach((CollectionTypeId)setTypeId, (Object[])new Object[]{primitiveType}), "Boolean.oclTypes()");
        }
        ocl.assertSemanticErrorQuery(null, "3.oclTypes(OclAny)", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, "Integer", "oclTypes", "OclAny");
        ocl.dispose();
    }

    @Test
    public void testToString() {
        MyOCL ocl = this.createOCL();
        ocl.loadEPackage("ecore", (EPackage)EcorePackage.eINSTANCE);
        @NonNull String emfString = EcoreFactory.eINSTANCE.createFromString(EcorePackage.Literals.EDATE, "2000-01-24").toString();
        ocl.assertQueryEquals(null, emfString, "ecore::EDate{value='2000-01-24'}.toString()");
        ocl.dispose();
    }

    public static class MyOCL
    extends TestOCL {
        @NonNull Model root = PivotUtil.createModel(null);
        @NonNull Package pkg1 = PivotUtil.createOwnedPackage((Model)this.root, (String)"pkg1");
        @NonNull Package pkg2 = PivotUtil.createOwnedPackage((Package)this.pkg1, (String)"pkg2");
        @NonNull Package jim = PivotUtil.createOwnedPackage((Package)this.pkg2, (String)"jim");
        @NonNull Package bob = PivotUtil.createOwnedPackage((Package)this.pkg1, (String)"bob");
        @NonNull Package pkg3 = PivotUtil.createOwnedPackage((Package)this.pkg1, (String)"pkg3");
        @NonNull Package pkg4 = PivotUtil.createOwnedPackage((Package)this.pkg3, (String)"pkg4");
        @NonNull Package pkg5 = PivotUtil.createOwnedPackage((Package)this.pkg3, (String)"pkg5");
        @NonNull Package george = PivotUtil.createOwnedPackage((Package)this.pkg5, (String)"george");

        public MyOCL(@NonNull String testPackageName, @NonNull String name) {
            super(testPackageName, name, (ProjectManager)(useCodeGen ? EvaluateOclAnyOperationsTest4.getProjectMap() : OCL.NO_PROJECTS));
            MetamodelManagerInternal metamodelManager = this.getMetamodelManager();
            metamodelManager.installRoot((Model)ClassUtil.nonNullState((Object)this.root));
        }
    }
}

