/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.test.standalone;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.emf.validation.validity.export.HTMLExporter;
import org.eclipse.ocl.examples.emf.validation.validity.export.TextExporter;
import org.eclipse.ocl.examples.standalone.HelpCommand;
import org.eclipse.ocl.examples.standalone.StandaloneApplication;
import org.eclipse.ocl.examples.standalone.StandaloneCommand;
import org.eclipse.ocl.examples.standalone.StandaloneCommandAnalyzer;
import org.eclipse.ocl.examples.standalone.validity.ValidateCommand;
import org.eclipse.ocl.examples.test.standalone.StandaloneTestCase;
import org.junit.Test;

public class StandaloneParserTests
extends StandaloneTestCase {
    private StandaloneCommandAnalyzer commandAnalyzer = new StandaloneCommandAnalyzer(new StandaloneApplication());

    protected static void assertCommandInvalid(@NonNull StandaloneCommand command, @NonNull Map<// Could not load outer class - annotation placement on inner may be incorrect
    StandaloneCommand.CommandToken, List<String>> token2strings) {
        boolean status = command.check(token2strings);
        StandaloneParserTests.assertFalse((boolean)status);
    }

    protected static void assertCommandValid(@NonNull StandaloneCommand command, @NonNull Map<// Could not load outer class - annotation placement on inner may be incorrect
    StandaloneCommand.CommandToken, List<String>> token2strings) {
        boolean status = command.check(token2strings);
        StandaloneParserTests.assertTrue((boolean)status);
    }

    protected List<String> normalize(List<String> strings) {
        ArrayList<String> normalized = new ArrayList<String>(strings.size());
        for (String string : strings) {
            normalized.add(string.replace("\\", "/"));
        }
        return normalized;
    }

    protected String normalize(String string) {
        return string.replace("\\", "/");
    }

    protected <T extends StandaloneCommand> @NonNull T parseCommand(@NonNull Class<T> commandClass, @NonNull String @NonNull [] arguments) {
        StandaloneCommand command = this.commandAnalyzer.parse(arguments);
        assert (command != null);
        StandaloneParserTests.assertEquals(commandClass, command.getClass());
        return (T)command;
    }

    protected void parseInvalidArguments(@NonNull StandaloneCommand command, @NonNull String @NonNull [] arguments) {
        Map token2strings = command.parse(arguments);
        StandaloneParserTests.assertNull((Object)token2strings);
    }

    protected @NonNull Map<// Could not load outer class - annotation placement on inner may be incorrect
    StandaloneCommand.CommandToken, List<String>> parseValidArguments(@NonNull StandaloneCommand command, @NonNull String @NonNull [] arguments) {
        Map token2strings = command.parse(arguments);
        StandaloneParserTests.assertNotNull((Object)token2strings);
        assert (token2strings != null);
        return token2strings;
    }

    @Test
    public void test_help() throws CoreException {
        @NonNull String @NonNull [] arguments = new String[]{"help"};
        HelpCommand command = this.parseCommand(HelpCommand.class, arguments);
        Map<StandaloneCommand.CommandToken, List<String>> token2strings = this.parseValidArguments((StandaloneCommand)command, arguments);
        StandaloneParserTests.assertEquals((int)0, (int)token2strings.size());
    }

    @Test
    public void test_help_extraText() throws CoreException {
        @NonNull String @NonNull [] arguments = new String[]{"help", "yy"};
        HelpCommand command = this.parseCommand(HelpCommand.class, arguments);
        this.parseInvalidArguments((StandaloneCommand)command, arguments);
    }

    @Test
    public void test_mandatoryArguments() throws CoreException {
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", this.inputModelName, "-rules", this.inputOCLFileName};
        ValidateCommand command = this.parseCommand(ValidateCommand.class, arguments);
        Map<StandaloneCommand.CommandToken, List<String>> token2strings = this.parseValidArguments((StandaloneCommand)command, arguments);
        StandaloneParserTests.assertCommandValid((StandaloneCommand)command, token2strings);
        StandaloneParserTests.assertEquals(null, (Object)command.exporterToken.getExporter(token2strings));
        StandaloneParserTests.assertEquals((String)this.inputModelName, (String)command.modelToken.getModelFileName(token2strings));
        StandaloneParserTests.assertEquals(null, (Object)command.outputToken.getOutputFile(token2strings));
        StandaloneParserTests.assertEquals((Object)Lists.newArrayList((Object[])new String[]{this.inputOCLFileName}), this.normalize(command.rulesToken.getOCLFileNames(token2strings)));
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunJavaConstraints(token2strings));
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunOCLConstraints(token2strings));
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunUMLConstraints(token2strings));
    }

    @Test
    public void test_missingOutputArgument() throws CoreException {
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", this.inputModelName, "-rules", this.inputOCLFileName, "-output"};
        ValidateCommand command = this.parseCommand(ValidateCommand.class, arguments);
        this.parseInvalidArguments((StandaloneCommand)command, arguments);
    }

    @Test
    public void test_missingExporterArgument() throws CoreException {
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", this.inputModelName, "-rules", this.inputOCLFileName, "-exporter"};
        ValidateCommand command = this.parseCommand(ValidateCommand.class, arguments);
        this.parseInvalidArguments((StandaloneCommand)command, arguments);
    }

    @Test
    public void test_missingUsingArgument() throws CoreException {
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", this.inputModelName, "-rules", this.inputOCLFileName, "-using"};
        ValidateCommand command = this.parseCommand(ValidateCommand.class, arguments);
        this.parseInvalidArguments((StandaloneCommand)command, arguments);
    }

    @Test
    public void test_textExportedFile() throws CoreException {
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", this.inputModelName, "-rules", this.inputOCLFileName, "-output", this.getTextLogFileName(), "-exporter", "text"};
        ValidateCommand command = this.parseCommand(ValidateCommand.class, arguments);
        Map<StandaloneCommand.CommandToken, List<String>> token2strings = this.parseValidArguments((StandaloneCommand)command, arguments);
        StandaloneParserTests.assertCommandValid((StandaloneCommand)command, token2strings);
        StandaloneParserTests.assertTrue((boolean)(command.exporterToken.getExporter(token2strings) instanceof TextExporter));
        StandaloneParserTests.assertEquals((String)this.inputModelName, (String)command.modelToken.getModelFileName(token2strings));
        StandaloneParserTests.assertEquals((String)this.getTextLogFileName(), (String)this.normalize(command.outputToken.getOutputFile(token2strings).toString()));
        StandaloneParserTests.assertEquals((Object)Lists.newArrayList((Object[])new String[]{this.inputOCLFileName}), (Object)Lists.newArrayList((Object[])new String[]{this.normalize((String)command.rulesToken.getOCLFileNames(token2strings).get(0))}));
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunJavaConstraints(token2strings));
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunOCLConstraints(token2strings));
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunUMLConstraints(token2strings));
    }

    @Test
    public void test_htmlExportedFile() throws CoreException {
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", this.inputModelName, "-rules", this.inputOCLFileName, "-output", this.getHTMLLogFileName(), "-exporter", "html"};
        ValidateCommand command = this.parseCommand(ValidateCommand.class, arguments);
        Map<StandaloneCommand.CommandToken, List<String>> token2strings = this.parseValidArguments((StandaloneCommand)command, arguments);
        StandaloneParserTests.assertCommandValid((StandaloneCommand)command, token2strings);
        StandaloneParserTests.assertTrue((boolean)(command.exporterToken.getExporter(token2strings) instanceof HTMLExporter));
        StandaloneParserTests.assertEquals((String)this.inputModelName, (String)command.modelToken.getModelFileName(token2strings));
        StandaloneParserTests.assertEquals((String)this.getHTMLLogFileName(), (String)this.normalize(command.outputToken.getOutputFile(token2strings).toString()));
        StandaloneParserTests.assertEquals((Object)Lists.newArrayList((Object[])new String[]{this.inputOCLFileName}), this.normalize(command.rulesToken.getOCLFileNames(token2strings)));
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunJavaConstraints(token2strings));
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunOCLConstraints(token2strings));
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunUMLConstraints(token2strings));
    }

    @Test
    public void test_unknownExporter() throws CoreException {
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", this.inputModelName, "-rules", this.inputOCLFileName, "-output", this.getTextLogFileName(), "-exporter", "anotherExporterAttribute"};
        ValidateCommand command = this.parseCommand(ValidateCommand.class, arguments);
        Map<StandaloneCommand.CommandToken, List<String>> token2strings = this.parseValidArguments((StandaloneCommand)command, arguments);
        StandaloneParserTests.assertCommandInvalid((StandaloneCommand)command, token2strings);
    }

    @Test
    public void test_nonExistentModel() throws CoreException {
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", String.valueOf(this.getProjectFileURI("models/nonExistent.ecore")), "-rules", this.inputOCLFileName, "-output", this.getTextLogFileName(), "-exporter", "text"};
        ValidateCommand command = this.parseCommand(ValidateCommand.class, arguments);
        Map<StandaloneCommand.CommandToken, List<String>> token2strings = this.parseValidArguments((StandaloneCommand)command, arguments);
        StandaloneParserTests.assertCommandInvalid((StandaloneCommand)command, token2strings);
    }

    @Test
    public void test_nonExistentOclFile() throws CoreException {
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", this.inputModelName, "-rules", String.valueOf(this.getProjectFileURI("models/nonExistent.ocl")), "-output", this.getTextLogFileName(), "-exporter", "text"};
        ValidateCommand command = this.parseCommand(ValidateCommand.class, arguments);
        Map<StandaloneCommand.CommandToken, List<String>> token2strings = this.parseValidArguments((StandaloneCommand)command, arguments);
        StandaloneParserTests.assertCommandValid((StandaloneCommand)command, token2strings);
    }

    @Test
    public void test_nonExistentOutputFolder() throws CoreException {
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", this.inputModelName, "-rules", this.inputOCLFileName, "-output", "nonExistentFolder/log.file", "-exporter", "text"};
        ValidateCommand command = this.parseCommand(ValidateCommand.class, arguments);
        Map<StandaloneCommand.CommandToken, List<String>> token2strings = this.parseValidArguments((StandaloneCommand)command, arguments);
        StandaloneParserTests.assertCommandInvalid((StandaloneCommand)command, token2strings);
    }

    @Test
    public void test_textOCLFiles() throws CoreException {
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", this.inputModelName, "-rules", this.textInputOCLFileName, "-output", this.getTextLogFileName(), "-exporter", "text"};
        ValidateCommand command = this.parseCommand(ValidateCommand.class, arguments);
        Map<StandaloneCommand.CommandToken, List<String>> token2strings = this.parseValidArguments((StandaloneCommand)command, arguments);
        StandaloneParserTests.assertCommandValid((StandaloneCommand)command, token2strings);
        StandaloneParserTests.assertTrue((boolean)(command.exporterToken.getExporter(token2strings) instanceof TextExporter));
        StandaloneParserTests.assertEquals((String)this.inputModelName, (String)command.modelToken.getModelFileName(token2strings));
        StandaloneParserTests.assertEquals((String)this.getTextLogFileName(), (String)this.normalize(command.outputToken.getOutputFile(token2strings).toString()));
        StandaloneParserTests.assertEquals((Object)Lists.newArrayList((Object[])new String[]{this.inputOCLFileName, this.inputOCLFileName2}), this.normalize(command.rulesToken.getOCLFileNames(token2strings)));
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunJavaConstraints(token2strings));
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunOCLConstraints(token2strings));
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunUMLConstraints(token2strings));
    }

    @Test
    public void test_usingAllLocators() throws CoreException {
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", this.inputModelName, "-rules", this.inputOCLFileName, "-output", this.getTextLogFileName(), "-exporter", "text", "-using", "all"};
        ValidateCommand command = this.parseCommand(ValidateCommand.class, arguments);
        Map<StandaloneCommand.CommandToken, List<String>> token2strings = this.parseValidArguments((StandaloneCommand)command, arguments);
        StandaloneParserTests.assertCommandValid((StandaloneCommand)command, token2strings);
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunJavaConstraints(token2strings));
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunOCLConstraints(token2strings));
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunUMLConstraints(token2strings));
    }

    @Test
    public void test_usingOCLLocator() throws CoreException {
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", this.inputModelName, "-rules", this.inputOCLFileName, "-output", this.getTextLogFileName(), "-exporter", "text", "-using", "ocl"};
        ValidateCommand command = this.parseCommand(ValidateCommand.class, arguments);
        Map<StandaloneCommand.CommandToken, List<String>> token2strings = this.parseValidArguments((StandaloneCommand)command, arguments);
        StandaloneParserTests.assertCommandValid((StandaloneCommand)command, token2strings);
        StandaloneParserTests.assertEquals((boolean)false, (boolean)command.usingToken.doRunJavaConstraints(token2strings));
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunOCLConstraints(token2strings));
        StandaloneParserTests.assertEquals((boolean)false, (boolean)command.usingToken.doRunUMLConstraints(token2strings));
    }

    @Test
    public void test_usingJavaLocator() throws CoreException {
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", this.inputModelName, "-rules", this.inputOCLFileName, "-output", this.getTextLogFileName(), "-exporter", "text", "-using", "java"};
        ValidateCommand command = this.parseCommand(ValidateCommand.class, arguments);
        Map<StandaloneCommand.CommandToken, List<String>> token2strings = this.parseValidArguments((StandaloneCommand)command, arguments);
        StandaloneParserTests.assertCommandValid((StandaloneCommand)command, token2strings);
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunJavaConstraints(token2strings));
        StandaloneParserTests.assertEquals((boolean)false, (boolean)command.usingToken.doRunOCLConstraints(token2strings));
        StandaloneParserTests.assertEquals((boolean)false, (boolean)command.usingToken.doRunUMLConstraints(token2strings));
    }

    @Test
    public void test_usingUMLLocator() throws CoreException {
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", this.inputModelName, "-rules", this.inputOCLFileName, "-output", this.getTextLogFileName(), "-exporter", "text", "-using", "uml"};
        ValidateCommand command = this.parseCommand(ValidateCommand.class, arguments);
        Map<StandaloneCommand.CommandToken, List<String>> token2strings = this.parseValidArguments((StandaloneCommand)command, arguments);
        StandaloneParserTests.assertCommandValid((StandaloneCommand)command, token2strings);
        StandaloneParserTests.assertEquals((boolean)false, (boolean)command.usingToken.doRunJavaConstraints(token2strings));
        StandaloneParserTests.assertEquals((boolean)false, (boolean)command.usingToken.doRunOCLConstraints(token2strings));
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunUMLConstraints(token2strings));
    }

    @Test
    public void test_usingOCLUMLLocators() throws CoreException {
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", this.inputModelName, "-rules", this.inputOCLFileName, "-output", this.getTextLogFileName(), "-exporter", "text", "-using", "ocl,uml"};
        ValidateCommand command = this.parseCommand(ValidateCommand.class, arguments);
        Map<StandaloneCommand.CommandToken, List<String>> token2strings = this.parseValidArguments((StandaloneCommand)command, arguments);
        StandaloneParserTests.assertCommandValid((StandaloneCommand)command, token2strings);
        StandaloneParserTests.assertEquals((boolean)false, (boolean)command.usingToken.doRunJavaConstraints(token2strings));
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunOCLConstraints(token2strings));
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunUMLConstraints(token2strings));
    }

    @Test
    public void test_usingOCLJavaLocators() throws CoreException {
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", this.inputModelName, "-rules", this.inputOCLFileName, "-output", this.getTextLogFileName(), "-exporter", "text", "-using", "ocl,java"};
        ValidateCommand command = this.parseCommand(ValidateCommand.class, arguments);
        Map<StandaloneCommand.CommandToken, List<String>> token2strings = this.parseValidArguments((StandaloneCommand)command, arguments);
        StandaloneParserTests.assertCommandValid((StandaloneCommand)command, token2strings);
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunJavaConstraints(token2strings));
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunOCLConstraints(token2strings));
        StandaloneParserTests.assertEquals((boolean)false, (boolean)command.usingToken.doRunUMLConstraints(token2strings));
    }

    @Test
    public void test_usingJavaUmlLocators() throws CoreException {
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", this.inputModelName, "-rules", this.inputOCLFileName, "-output", this.getTextLogFileName(), "-exporter", "text", "-using", "uml,java"};
        ValidateCommand command = this.parseCommand(ValidateCommand.class, arguments);
        Map<StandaloneCommand.CommandToken, List<String>> token2strings = this.parseValidArguments((StandaloneCommand)command, arguments);
        StandaloneParserTests.assertCommandValid((StandaloneCommand)command, token2strings);
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunJavaConstraints(token2strings));
        StandaloneParserTests.assertEquals((boolean)false, (boolean)command.usingToken.doRunOCLConstraints(token2strings));
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunUMLConstraints(token2strings));
    }

    @Test
    public void test_usingOCLJavaUmlLocators() throws CoreException {
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", this.inputModelName, "-rules", this.inputOCLFileName, "-output", this.getTextLogFileName(), "-exporter", "text", "-using", "ocl,uml,java"};
        ValidateCommand command = this.parseCommand(ValidateCommand.class, arguments);
        Map<StandaloneCommand.CommandToken, List<String>> token2strings = this.parseValidArguments((StandaloneCommand)command, arguments);
        StandaloneParserTests.assertCommandValid((StandaloneCommand)command, token2strings);
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunJavaConstraints(token2strings));
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunOCLConstraints(token2strings));
        StandaloneParserTests.assertEquals((boolean)true, (boolean)command.usingToken.doRunUMLConstraints(token2strings));
    }
}

