/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.ecore.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.TypeResolver;
import org.eclipse.ocl.ecore.TupleType;
import org.eclipse.ocl.ecore.tests.AbstractTestSuite;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.ocl.expressions.ExpressionsFactory;
import org.eclipse.ocl.expressions.ExpressionsPackage;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.options.Option;
import org.eclipse.ocl.options.ParsingOptions;
import org.eclipse.ocl.types.CollectionType;
import org.eclipse.ocl.types.OCLStandardLibrary;
import org.eclipse.ocl.util.Tuple;
import org.eclipse.ocl.util.TypeUtil;

public class CollectionsTest
extends AbstractTestSuite {
    public void test_insertAt_sequence_126722() {
        this.helper.setContext((Object)EcorePackage.Literals.ESTRING);
        try {
            OCLExpression expr = this.helper.createQuery("Sequence{'a', 'b', 'd', 'e'}->insertAt(3, 'c')");
            List result = (List)this.ocl.evaluate((Object)"", expr);
            List<Object> expected = Arrays.asList("a", "b", "c", "d", "e");
            CollectionsTest.assertEquals(expected, (Object)result);
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_insertAt_orderedSet_126722() {
        this.helper.setContext((Object)EcorePackage.Literals.ESTRING);
        try {
            OCLExpression expr = this.helper.createQuery("OrderedSet{'a', 'b', 'd', 'e'}->insertAt(3, 'c')");
            Set result = (Set)this.ocl.evaluate((Object)"", expr);
            List<Object> expected = Arrays.asList("a", "b", "c", "d", "e");
            CollectionsTest.assertEquals(expected, new ArrayList(result));
            expr = this.helper.createQuery("OrderedSet{'a', 'b', 'c', 'd', 'e'}->insertAt(5, 'c')");
            result = (Set)this.ocl.evaluate((Object)"", expr);
            expected = Arrays.asList("a", "b", "c", "d", "e");
            CollectionsTest.assertEquals(expected, new ArrayList(result));
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_prepend_sequence_126722() {
        this.helper.setContext((Object)EcorePackage.Literals.ESTRING);
        try {
            OCLExpression expr = this.helper.createQuery("Sequence{'a', 'b', 'd', 'e'}->prepend('c')");
            List result = (List)this.ocl.evaluate((Object)"", expr);
            List<Object> expected = Arrays.asList("c", "a", "b", "d", "e");
            CollectionsTest.assertEquals(expected, (Object)result);
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_prepend_orderedSet_126722() {
        this.helper.setContext((Object)EcorePackage.Literals.ESTRING);
        try {
            OCLExpression expr = this.helper.createQuery("OrderedSet{'a', 'b', 'd', 'e'}->prepend('c')");
            Set result = (Set)this.ocl.evaluate((Object)"", expr);
            List<Object> expected = Arrays.asList("c", "a", "b", "d", "e");
            CollectionsTest.assertEquals(expected, new ArrayList(result));
            expr = this.helper.createQuery("OrderedSet{'a', 'b', 'c', 'd', 'e'}->prepend('c')");
            result = (Set)this.ocl.evaluate((Object)"", expr);
            expected = Arrays.asList("c", "a", "b", "d", "e");
            CollectionsTest.assertEquals(expected, new ArrayList(result));
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_append_sequence_126722() {
        this.helper.setContext((Object)EcorePackage.Literals.ESTRING);
        try {
            OCLExpression expr = this.helper.createQuery("Sequence{'a', 'b', 'd', 'e'}->append('c')");
            List result = (List)this.ocl.evaluate((Object)"", expr);
            List<Object> expected = Arrays.asList("a", "b", "d", "e", "c");
            CollectionsTest.assertEquals(expected, (Object)result);
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_append_orderedSet_126722() {
        this.helper.setContext((Object)EcorePackage.Literals.ESTRING);
        try {
            OCLExpression expr = this.helper.createQuery("OrderedSet{'a', 'b', 'd', 'e'}->append('c')");
            Set result = (Set)this.ocl.evaluate((Object)"", expr);
            List<Object> expected = Arrays.asList("a", "b", "d", "e", "c");
            CollectionsTest.assertEquals(expected, new ArrayList(result));
            expr = this.helper.createQuery("OrderedSet{'a', 'b', 'c', 'd', 'e'}->append('c')");
            result = (Set)this.ocl.evaluate((Object)"", expr);
            expected = Arrays.asList("a", "b", "d", "e", "c");
            CollectionsTest.assertEquals(expected, new ArrayList(result));
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_including_sequence_126722() {
        this.helper.setContext((Object)EcorePackage.Literals.ESTRING);
        try {
            OCLExpression expr = this.helper.createQuery("Sequence{'a', 'b', 'd', 'e'}->including('c')");
            List result = (List)this.ocl.evaluate((Object)"", expr);
            List<Object> expected = Arrays.asList("a", "b", "d", "e", "c");
            CollectionsTest.assertEquals(expected, (Object)result);
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_including_orderedSet_126722() {
        this.helper.setContext((Object)EcorePackage.Literals.ESTRING);
        try {
            OCLExpression expr = this.helper.createQuery("OrderedSet{'a', 'b', 'd', 'e'}->including('c')");
            Set result = (Set)this.ocl.evaluate((Object)"", expr);
            HashSet<Object> expected = new HashSet<Object>(Arrays.asList("a", "b", "d", "e", "c"));
            CollectionsTest.assertEquals(expected, (Object)result);
            expr = this.helper.createQuery("OrderedSet{'a', 'b', 'c', 'd', 'e'}->including('c')");
            result = (Set)this.ocl.evaluate((Object)"", expr);
            expected = new HashSet<Object>(Arrays.asList("a", "b", "c", "d", "e"));
            CollectionsTest.assertEquals(expected, (Object)result);
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_excluding_sequence_126722() {
        this.helper.setContext((Object)EcorePackage.Literals.ESTRING);
        try {
            OCLExpression expr = this.helper.createQuery("Sequence{'a', 'b', 'c', 'd', 'e'}->excluding('c')");
            List result = (List)this.ocl.evaluate((Object)"", expr);
            List<Object> expected = Arrays.asList("a", "b", "d", "e");
            CollectionsTest.assertEquals(expected, (Object)result);
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_excluding_orderedSet_126722() {
        this.helper.setContext((Object)EcorePackage.Literals.ESTRING);
        try {
            OCLExpression expr = this.helper.createQuery("OrderedSet{'a', 'b', 'c', 'd', 'e'}->excluding('c')");
            Set result = (Set)this.ocl.evaluate((Object)"", expr);
            HashSet<Object> expected = new HashSet<Object>(Arrays.asList("a", "b", "d", "e"));
            CollectionsTest.assertEquals(expected, (Object)result);
            expr = this.helper.createQuery("OrderedSet{'a', 'b', 'd', 'e'}->excluding('c')");
            result = (Set)this.ocl.evaluate((Object)"", expr);
            expected = new HashSet<Object>(Arrays.asList("a", "b", "d", "e"));
            CollectionsTest.assertEquals(expected, (Object)result);
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_first() {
        this.helper.setContext((Object)EcorePackage.Literals.ESTRING);
        try {
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Sequence{'a', 'b', 'c', 'd', 'e'}->first() = 'a'"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "OrderedSet{'a', 'b', 'c', 'd', 'e'}->first() = 'a'"));
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_last() {
        this.helper.setContext((Object)EcorePackage.Literals.ESTRING);
        try {
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Sequence{'a', 'b', 'c', 'd', 'e'}->last() = 'e'"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "OrderedSet{'a', 'b', 'c', 'd', 'e'}->last() = 'e'"));
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_at() {
        this.helper.setContext((Object)EcorePackage.Literals.ESTRING);
        try {
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Sequence{'a', 'b', 'c', 'd', 'e'}->at(3) = 'c'"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "OrderedSet{'a', 'b', 'c', 'd', 'e'}->at(3)= 'c'"));
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_indexOf() {
        this.helper.setContext((Object)EcorePackage.Literals.ESTRING);
        try {
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Sequence{'a', 'b', 'c', 'd', 'e'}->indexOf('c') = 3"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "OrderedSet{'a', 'b', 'c', 'd', 'e'}->indexOf('c')= 3"));
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_subsequence_suborderedset() {
        this.helper.setContext((Object)EcorePackage.Literals.ESTRING);
        try {
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Sequence{'a', 'b', 'c', 'd', 'e'}->subSequence(2, 4) = Sequence{'b', 'c', 'd'}"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "OrderedSet{'a', 'b', 'c', 'd', 'e'}->subOrderedSet(2, 4) = OrderedSet{'b', 'c', 'd'}"));
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_flatten() {
        this.helper.setContext((Object)EcorePackage.Literals.ESTRING);
        try {
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Set{Sequence{'a', 'b'}, Sequence{'b', 'c', 'd'}}->flatten() = Set{'b', 'c', 'a', 'd'}"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "OrderedSet{Sequence{'a', 'b'}, Sequence{'b', 'c', 'd'}}->flatten() = Set{'b', 'c', 'a', 'd'}"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Sequence{OrderedSet{'a', 'b', 'd'}, OrderedSet{'b', 'c', 'd'}}->flatten() = Sequence{'a', 'b', 'd', 'b', 'c', 'd'}"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Bag{Bag{'b', 'a', 'b'}, Bag{'b', 'a', 'c', 'd'}}->flatten() = Bag{'a', 'a', 'b', 'b', 'b', 'c', 'd'}"));
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_flatten_notNested() {
        this.helper.setContext((Object)EcorePackage.Literals.ESTRING);
        try {
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Set{'a', 'b', 'c', 'd'}->flatten() = Set{'b', 'c', 'a', 'd'}"));
            CollectionsTest.assertFalse((boolean)this.check(this.helper, "", "OrderedSet{'a', 'b', 'b', 'c', 'd'}->flatten() = Set{'b', 'c', 'a', 'd'}"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "OrderedSet{'a', 'b', 'b', 'c', 'd'}->flatten() = OrderedSet{'a', 'b', 'c', 'd'}"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Sequence{'a', 'b', 'd', 'b', 'c', 'd'}->flatten() = Sequence{'a', 'b', 'd', 'b', 'c', 'd'}"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Bag{'b', 'a', 'b', 'b', 'a', 'c', 'd'}->flatten() = Bag{'a', 'a', 'b', 'b', 'b', 'c', 'd'}"));
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_flatten_emptySource_195252() {
        this.helper.setContext((Object)EcorePackage.Literals.ESTRING);
        try {
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Set{}->flatten() = Set{}"));
            CollectionsTest.assertFalse((boolean)this.check(this.helper, "", "OrderedSet{}->flatten() = Set{}"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "OrderedSet{}->flatten() = OrderedSet{}"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Sequence{}->flatten() = Sequence{}"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Bag{}->flatten() = Bag{}"));
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_flatten_emptyChildren() {
        this.helper.setContext((Object)EcorePackage.Literals.ESTRING);
        try {
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Set{Set{}, Set{}}->flatten() = Set{}"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "OrderedSet{OrderedSet{}, OrderedSet{}}->flatten() = Set{}"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Sequence{Sequence{}, Sequence{}}->flatten() = Sequence{}"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Bag{Bag{}, Bag{}}->flatten() = Bag{}"));
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_flatten_recursive_217461() {
        this.helper.setContext((Object)EcorePackage.Literals.ESTRING);
        try {
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Set{Sequence{Set{'a'}, Set{'b'}}, Sequence{Set{'b', 'c'}, Set{'d'}}}->flatten() = Set{'b', 'c', 'a', 'd'}"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "OrderedSet{Sequence{Set{'a'}, Set{'b'}}, Sequence{Set{'b', 'c'}, Set{'d'}}}->flatten() = Set{'b', 'c', 'a', 'd'}"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Sequence{OrderedSet{Sequence{'a', 'b'}, Sequence{'d'}}, OrderedSet{Sequence{'b', 'c'}, Sequence{'d'}}}->flatten() = Sequence{'a', 'b', 'd', 'b', 'c', 'd'}"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Bag{Bag{Set{'b', 'a'}, Set{'b'}}, Bag{Set{'b', 'a'}, Set{'c', 'd'}}}->flatten() = Bag{'a', 'a', 'b', 'b', 'b', 'c', 'd'}"));
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_flatten_emptyChildrenRecursive_217461() {
        this.helper.setContext((Object)EcorePackage.Literals.ESTRING);
        try {
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Set{Set{Sequence{}}, Set{Sequence{}, Sequence{}}}->flatten() = Set{}"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "OrderedSet{OrderedSet{Sequence{}, Sequence{}}, OrderedSet{Sequence{}, Sequence{}}}->flatten() = Set{}"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Sequence{Sequence{Sequence{}, Sequence{}}, Sequence{Sequence{}, Sequence{}}}->flatten() = Sequence{}"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Bag{Bag{Sequence{}, Sequence{}}, Bag{Sequence{}, Sequence{}}}->flatten() = Bag{}"));
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_count() {
        this.helper.setContext((Object)EcorePackage.Literals.EINT);
        try {
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Sequence{1, 2, 3, 3, 4, 5}->count(3) = 2"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Sequence{1, 2, 3, 3, 4, 5}->count(6) = 0"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "OrderedSet{1, 2, 3, 3, 4, 5}->count(3) = 1"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "OrderedSet{1, 2, 3, 3, 4, 5}->count(6) = 0"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Set{1, 2, 3, 3, 4, 5}->count(3) = 1"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Set{1, 2, 3, 3, 4, 5}->count(6) = 0"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Bag{1, 2, 3, 3, 4, 5}->count(3) = 2"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Bag{1, 2, 3, 3, 4, 5}->count(6) = 0"));
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_sum() {
        this.helper.setContext((Object)EcorePackage.Literals.EINT);
        try {
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Sequence{1, 2, 3, 3, 4, 5}->sum() = 18"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "OrderedSet{1, 2, 3, 3, 4, 5}->sum() = 15"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Set{1, 2, 3, 3, 4, 5}->sum() = 15"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Bag{1, 2, 3, 3, 4, 5}->sum() = 18"));
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_sum_emptyIntegerCollection_204753() {
        this.helper.setContext((Object)EcorePackage.Literals.EINT);
        Integer zero = new Integer(0);
        try {
            CollectionsTest.assertEquals((Object)zero, (Object)this.evaluate(this.helper, "", "let s : Sequence(Integer) = Sequence{} in s->sum()"));
            CollectionsTest.assertEquals((Object)zero, (Object)this.evaluate(this.helper, "", "let s : OrderedSet(Integer) = OrderedSet{} in s->sum()"));
            CollectionsTest.assertEquals((Object)zero, (Object)this.evaluate(this.helper, "", "let s : Set(Integer) = Set{} in s->sum()"));
            CollectionsTest.assertEquals((Object)zero, (Object)this.evaluate(this.helper, "", "let s : Bag(Integer) = Bag{} in s->sum()"));
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_sum_emptyRealCollection_204753() {
        this.helper.setContext((Object)EcorePackage.Literals.EINT);
        Double zero = new Double(0.0);
        try {
            CollectionsTest.assertEquals((Object)zero, (Object)this.evaluate(this.helper, "", "let s : Sequence(Real) = Sequence{} in s->sum()"));
            CollectionsTest.assertEquals((Object)zero, (Object)this.evaluate(this.helper, "", "let s : OrderedSet(Real) = OrderedSet{} in s->sum()"));
            CollectionsTest.assertEquals((Object)zero, (Object)this.evaluate(this.helper, "", "let s : Set(Real) = Set{} in s->sum()"));
            CollectionsTest.assertEquals((Object)zero, (Object)this.evaluate(this.helper, "", "let s : Bag(Real) = Bag{} in s->sum()"));
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_includes() {
        this.helper.setContext((Object)EcorePackage.Literals.EINT);
        try {
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Sequence{1, 2, 3, 3, 4, 5}->includes(3)"));
            CollectionsTest.assertFalse((boolean)this.check(this.helper, "", "Sequence{1, 2, 3, 3, 4, 5}->includes(6)"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Set{1, 2, 3, 3, 4, 5}->includes(3)"));
            CollectionsTest.assertFalse((boolean)this.check(this.helper, "", "Set{1, 2, 3, 3, 4, 5}->includes(6)"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "OrderedSet{1, 2, 3, 3, 4, 5}->includes(3)"));
            CollectionsTest.assertFalse((boolean)this.check(this.helper, "", "OrderedSet{1, 2, 3, 3, 4, 5}->includes(6)"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Bag{1, 2, 3, 3, 4, 5}->includes(3)"));
            CollectionsTest.assertFalse((boolean)this.check(this.helper, "", "Bag{1, 2, 3, 3, 4, 5}->includes(6)"));
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_includesAll() {
        this.helper.setContext((Object)EcorePackage.Literals.EINT);
        try {
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Sequence{1, 2, 3, 3, 4, 5}->includesAll(Sequence{1, 3})"));
            CollectionsTest.assertFalse((boolean)this.check(this.helper, "", "Sequence{1, 2, 3, 3, 4, 5}->includesAll(Sequence{1, 6})"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Set{1, 2, 3, 3, 4, 5}->includesAll(Set{1, 3})"));
            CollectionsTest.assertFalse((boolean)this.check(this.helper, "", "Set{1, 2, 3, 3, 4, 5}->includesAll(Set{1, 6})"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "OrderedSet{1, 2, 3, 3, 4, 5}->includesAll(OrderedSet{1, 3})"));
            CollectionsTest.assertFalse((boolean)this.check(this.helper, "", "OrderedSet{1, 2, 3, 3, 4, 5}->includesAll(OrderedSet{1, 6})"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Bag{1, 2, 3, 3, 4, 5}->includesAll(Bag{1, 3})"));
            CollectionsTest.assertFalse((boolean)this.check(this.helper, "", "Bag{1, 2, 3, 3, 4, 5}->includesAll(Bag{1, 6})"));
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_union() {
        this.helper.setContext((Object)EcorePackage.Literals.EINT);
        try {
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Set{1, 2, 3}->union(Set{3, 4, 5}) = Set{1, 2, 3, 4, 5}"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "OrderedSet{1, 2, 3}->union(Set{3, 4, 5}) = Set{1, 2, 3, 4, 5}"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Bag{1, 2, 2, 3}->union(Set{3, 4, 5}) = Bag{1, 2, 2, 3, 3, 4, 5}"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Bag{1, 2, 3}->union(Bag{3, 3, 4, 5}) = Bag{1, 2, 3, 3, 3, 4, 5}"));
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_intersection() {
        this.helper.setContext((Object)EcorePackage.Literals.EINT);
        try {
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Set{1, 2, 3}->intersection(Set{3, 4, 5}) = Set{3}"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "OrderedSet{1, 2, 3}->intersection(Set{3, 4, 5}) = Set{3}"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Bag{1, 2, 2, 3, 3, 3}->intersection(Bag{3, 3, 4, 5}) = Bag{3, 3}"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Bag{1, 2, 2, 3, 3, 3}->intersection(Set{3, 4, 5}) = Set{3}"));
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_difference() {
        this.helper.setContext((Object)EcorePackage.Literals.EINT);
        try {
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Set{1, 2, 3} - Set{3, 4, 5} = Set{1, 2}"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "OrderedSet{1, 2, 3} - Set{3, 4, 5} = Set{1, 2}"));
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_symmetricDifference() {
        this.helper.setContext((Object)EcorePackage.Literals.EINT);
        try {
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Set{1, 2, 3}->symmetricDifference(Set{3, 4, 5}) = Set{1, 2, 4, 5}"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "OrderedSet{1, 2, 3}->symmetricDifference(Set{3, 4, 5}) = Set{1, 2, 4, 5}"));
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_dotNavigationOfReferenceCollections_130239() {
        this.helper.setContext((Object)EcorePackage.Literals.EPACKAGE);
        try {
            OCLExpression expr = this.helper.createQuery("self.eClassifiers->union(self.eSubpackages.eClassifiers->asSet())->asSet()");
            CollectionsTest.assertEquals(new HashSet(ExpressionsPackage.eINSTANCE.getEClassifiers()), (Object)this.ocl.evaluate((Object)ExpressionsPackage.eINSTANCE, expr));
        }
        catch (Exception exc) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + exc.getLocalizedMessage()));
        }
    }

    public void test_dotNavigationOfOperationCollections_130239() {
        EPackage fakePkg = EcoreFactory.eINSTANCE.createEPackage();
        fakePkg.setName("fake");
        EClass fake = EcoreFactory.eINSTANCE.createEClass();
        fake.setName("Fake");
        fakePkg.getEClassifiers().add((Object)fake);
        EOperation getFakes = EcoreFactory.eINSTANCE.createEOperation();
        getFakes.setName("getFakes");
        getFakes.setEType((EClassifier)fake);
        getFakes.setUpperBound(-1);
        fake.getEOperations().add((Object)getFakes);
        this.helper.setContext((Object)fake);
        try {
            this.helper.createQuery("self.getFakes()->union(self.getFakes().getFakes()->asSet())");
        }
        catch (Exception exc) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + exc.getLocalizedMessage()));
        }
    }

    public void test_collectionRange_152208() {
        this.helper.setContext((Object)EcorePackage.Literals.EINT);
        try {
            Collection result = (Collection)this.evaluate(this.helper, new Integer(1), "Sequence{1 .. 10}");
            int i = 1;
            while (i <= 10) {
                CollectionsTest.assertTrue((boolean)result.contains(new Integer(i)));
                ++i;
            }
            result = (Collection)this.evaluate(this.helper, new Integer(1), "Sequence{1, (2+1)..(3+4), 10}");
            CollectionsTest.assertTrue((boolean)result.contains(new Integer(1)));
            i = 3;
            while (i <= 7) {
                CollectionsTest.assertTrue((boolean)result.contains(new Integer(i)));
                ++i;
            }
            CollectionsTest.assertTrue((boolean)result.contains(new Integer(10)));
            result = (Collection)this.evaluate(this.helper, new Integer(1), "Sequence{1..10}");
            i = 1;
            while (i <= 10) {
                CollectionsTest.assertTrue((boolean)result.contains(new Integer(i)));
                ++i;
            }
            result = (Collection)this.evaluate(this.helper, new Integer(1), "Sequence{-20, -10..-1, 1}");
            CollectionsTest.assertTrue((boolean)result.contains(new Integer(-20)));
            i = -10;
            while (i <= -1) {
                CollectionsTest.assertTrue((boolean)result.contains(new Integer(i)));
                ++i;
            }
            CollectionsTest.assertTrue((boolean)result.contains(new Integer(1)));
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_collectionRange_330489() {
        this.helper.setContext((Object)EcorePackage.Literals.EINT);
        try {
            Collection result = (Collection)this.evaluate(this.helper, new Integer(1), "Sequence{1 .. 1}");
            CollectionsTest.assertEquals((int)1, (int)result.size());
            CollectionsTest.assertTrue((boolean)result.contains(new Integer(1)));
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_tupleWithCollectionPart_175490() {
        this.helper.setContext((Object)EcorePackage.Literals.EPACKAGE);
        try {
            OCLExpression expr = this.helper.createQuery("Tuple{a = self.eClassifiers}");
            CollectionsTest.assertTrue((boolean)(expr.getType() instanceof TupleType));
            TupleType tt = (TupleType)expr.getType();
            CollectionsTest.assertEquals((int)1, (int)tt.getEStructuralFeatures().size());
            EStructuralFeature part = tt.getEStructuralFeature("a");
            CollectionsTest.assertNotNull((Object)part);
            CollectionsTest.assertTrue((boolean)(part.getEType() instanceof CollectionType));
            CollectionType collType = (CollectionType)part.getEType();
            CollectionsTest.assertSame((Object)EcorePackage.Literals.ECLASSIFIER, (Object)collType.getElementType());
            Object result = this.ocl.evaluate((Object)EcorePackage.eINSTANCE, expr);
            CollectionsTest.assertTrue((boolean)(result instanceof Tuple));
            Tuple tuple = (Tuple)result;
            CollectionsTest.assertTrue((boolean)(tuple.getValue("a") instanceof Collection));
            CollectionsTest.assertTrue((boolean)((Collection)tuple.getValue("a")).contains(EcorePackage.Literals.ECLASSIFIER));
        }
        catch (Exception exc) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + exc.getLocalizedMessage()));
        }
    }

    public void test_tupleWithCollectionLiteralPart_175490() {
        this.helper.setContext((Object)EcorePackage.Literals.EPACKAGE);
        try {
            OCLExpression expr = this.helper.createQuery("Tuple{a = Sequence{'a', 'b', 'c'}}");
            CollectionsTest.assertTrue((boolean)(expr.getType() instanceof TupleType));
            TupleType tt = (TupleType)expr.getType();
            CollectionsTest.assertEquals((int)1, (int)tt.getEStructuralFeatures().size());
            EStructuralFeature part = tt.getEStructuralFeature("a");
            CollectionsTest.assertNotNull((Object)part);
            CollectionsTest.assertTrue((boolean)(part.getEType() instanceof CollectionType));
            CollectionType collType = (CollectionType)part.getEType();
            CollectionsTest.assertSame((Object)this.getOCLStandardLibrary().getString(), (Object)collType.getElementType());
            Object result = this.ocl.evaluate((Object)EcorePackage.eINSTANCE, expr);
            CollectionsTest.assertTrue((boolean)(result instanceof Tuple));
            Tuple tuple = (Tuple)result;
            CollectionsTest.assertTrue((boolean)(tuple.getValue("a") instanceof Collection));
            CollectionsTest.assertTrue((boolean)((Collection)tuple.getValue("a")).contains("b"));
        }
        catch (Exception exc) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + exc.getLocalizedMessage()));
        }
    }

    public void test_passOclInvalidToCollectionOperation_183144() {
        this.helper.setContext((Object)EcorePackage.Literals.EPACKAGE);
        Variable var = ExpressionsFactory.eINSTANCE.createVariable();
        var.setName("var");
        var.setType((Object)((EClassifier)TypeUtil.resolveSetType((Environment)this.ocl.getEnvironment(), (Object)((EClassifier)this.getOCLStandardLibrary().getString()))));
        this.ocl.getEnvironment().addElement(var.getName(), var, true);
        try {
            OCLExpression expr = this.helper.createQuery("Set{'a', 'b', 'c'}->union(var)");
            this.ocl.getEvaluationEnvironment().add("var", this.getInvalid());
            Object result = this.ocl.evaluate((Object)EcorePackage.eINSTANCE, expr);
            this.assertInvalid(result);
        }
        catch (Exception exc) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + exc.getLocalizedMessage()));
        }
    }

    public void test_passNullToCollectionOperation_183144() {
        this.helper.setContext((Object)EcorePackage.Literals.EPACKAGE);
        Variable var = ExpressionsFactory.eINSTANCE.createVariable();
        var.setName("var");
        var.setType((Object)((EClassifier)TypeUtil.resolveSetType((Environment)this.ocl.getEnvironment(), (Object)((EClassifier)this.getOCLStandardLibrary().getString()))));
        this.ocl.getEnvironment().addElement(var.getName(), var, true);
        try {
            OCLExpression expr = this.helper.createQuery("Set{'a', 'b', 'c'}->union(var)");
            this.ocl.getEvaluationEnvironment().add("var", null);
            Object result = this.ocl.evaluate((Object)EcorePackage.eINSTANCE, expr);
            this.assertInvalid(result);
            expr = this.helper.createQuery("Set{'a', 'b', 'c'}->includes(null)");
            result = this.ocl.evaluate((Object)EcorePackage.eINSTANCE, expr);
            CollectionsTest.assertEquals((Object)Boolean.FALSE, (Object)result);
        }
        catch (Exception exc) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + exc.getLocalizedMessage()));
        }
    }

    public void test_sequenceNotEqualSignature_184327() {
        this.helper.setContext((Object)EcorePackage.Literals.ESTRING);
        try {
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Sequence{1, 2, 3} <> Sequence{3, 2, 1}"));
            CollectionsTest.assertFalse((boolean)this.check(this.helper, "", "Sequence{1, 2, 3} <> Sequence{1, 2, 3}"));
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_sortedByOverUnlimitedNatural() {
        this.helper.setContext((Object)EcorePackage.Literals.ECLASS);
        try {
            CollectionsTest.assertTrue((boolean)this.check(this.helper, EcorePackage.Literals.ECLASS, "self.eAllStructuralFeatures->sortedBy(upperBound)->first().upperBound = 1 and self.eAllStructuralFeatures->sortedBy(upperBound)->last().upperBound = *"));
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_valueOfOperationTypedByEEList_202611() {
        ParsingOptions.setOption((Environment)this.ocl.getEnvironment(), (Option)ParsingOptions.implicitRootClass((Environment)this.ocl.getEnvironment()), (Object)EcorePackage.Literals.EOBJECT);
        this.helper.setContext((Object)EcorePackage.Literals.EPACKAGE);
        try {
            OCLExpression expr = this.helper.createQuery("self.eContents()");
            CollectionsTest.assertTrue((boolean)(expr.getType() instanceof CollectionType));
            CollectionType actualType = (CollectionType)expr.getType();
            CollectionsTest.assertSame((Object)CollectionKind.SEQUENCE_LITERAL, (Object)actualType.getKind());
            Object value = this.ocl.evaluate((Object)EcorePackage.eINSTANCE, expr);
            CollectionsTest.assertEquals((Object)EcorePackage.eINSTANCE.eContents(), (Object)value);
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_resolutionOfGenericCollectionTypes_222581() {
        TypeResolver resolver = this.ocl.getEnvironment().getTypeResolver();
        Resource resource = resolver.getResource();
        OCLStandardLibrary stdlib = this.ocl.getEnvironment().getOCLStandardLibrary();
        EClassifier t = (EClassifier)stdlib.getT();
        CollectionType collectionType = resolver.resolveCollectionType(CollectionKind.SET_LITERAL, (Object)t);
        CollectionsTest.assertNotSame((Object)resource, (Object)collectionType.eResource());
        CollectionsTest.assertSame((Object)stdlib.getSet(), (Object)collectionType);
        collectionType = resolver.resolveCollectionType(CollectionKind.ORDERED_SET_LITERAL, (Object)t);
        CollectionsTest.assertNotSame((Object)resource, (Object)collectionType.eResource());
        CollectionsTest.assertSame((Object)stdlib.getOrderedSet(), (Object)collectionType);
        collectionType = resolver.resolveCollectionType(CollectionKind.SEQUENCE_LITERAL, (Object)t);
        CollectionsTest.assertNotSame((Object)resource, (Object)collectionType.eResource());
        CollectionsTest.assertSame((Object)stdlib.getSequence(), (Object)collectionType);
        collectionType = resolver.resolveCollectionType(CollectionKind.BAG_LITERAL, (Object)t);
        CollectionsTest.assertNotSame((Object)resource, (Object)collectionType.eResource());
        CollectionsTest.assertSame((Object)stdlib.getBag(), (Object)collectionType);
        collectionType = resolver.resolveCollectionType(CollectionKind.COLLECTION_LITERAL, (Object)t);
        CollectionsTest.assertNotSame((Object)resource, (Object)collectionType.eResource());
        CollectionsTest.assertSame((Object)stdlib.getCollection(), (Object)collectionType);
    }

    public void test_invalidAtIndex_orderedSet_244946() {
        this.helper.setContext((Object)EcorePackage.Literals.ESTRING);
        try {
            this.assertInvalid(this.evaluate(this.helper, "", "OrderedSet{1, 2, 3}->at(0)"));
            this.assertInvalid(this.evaluate(this.helper, "", "OrderedSet{1, 2, 3}->at(4)"));
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_invalidAtIndex_sequence_244946() {
        this.helper.setContext((Object)EcorePackage.Literals.ESTRING);
        try {
            this.assertInvalid(this.evaluate(this.helper, "", "Sequence{1, 2, 3}->at(0)"));
            this.assertInvalid(this.evaluate(this.helper, "", "Sequence{1, 2, 3}->at(4)"));
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_invalidInsertAtIndex_orderedSet_244946() {
        this.helper.setContext((Object)EcorePackage.Literals.ESTRING);
        try {
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "OrderedSet{1, 2, 3}->insertAt(4, 4) = OrderedSet{1, 2, 3, 4}"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "OrderedSet{1, 2, 3}->insertAt(1, 0) = OrderedSet{0, 1, 2, 3}"));
            this.assertInvalid(this.evaluate(this.helper, "", "OrderedSet{1, 2, 3}->insertAt(5, 5)"));
            this.assertInvalid(this.evaluate(this.helper, "", "OrderedSet{1, 2, 3}->insertAt(0, 0)"));
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_invalidInsertAtIndex_sequence_244946() {
        this.helper.setContext((Object)EcorePackage.Literals.ESTRING);
        try {
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Sequence{1, 2, 3}->insertAt(4, 4) = Sequence{1, 2, 3, 4}"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Sequence{1, 2, 3}->insertAt(1, 0) = Sequence{0, 1, 2, 3}"));
            this.assertInvalid(this.evaluate(this.helper, "", "Sequence{1, 2, 3}->insertAt(5, 5)"));
            this.assertInvalid(this.evaluate(this.helper, "", "Sequence{1, 2, 3}->insertAt(0, 0)"));
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_invalidSubOrderedSetRange_244946() {
        this.helper.setContext((Object)EcorePackage.Literals.ESTRING);
        try {
            this.assertInvalid(this.evaluate(this.helper, "", "OrderedSet{1, 2, 3}->subOrderedSet(0, 2)"));
            this.assertInvalid(this.evaluate(this.helper, "", "OrderedSet{1, 2, 3}->subOrderedSet(2, 4)"));
            this.assertInvalid(this.evaluate(this.helper, "", "OrderedSet{1, 2, 3}->subOrderedSet(2, 1)"));
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_invalidSubSequenceRange_244946() {
        this.helper.setContext((Object)EcorePackage.Literals.ESTRING);
        try {
            this.assertInvalid(this.evaluate(this.helper, "", "Sequence{1, 2, 3}->subSequence(0, 2)"));
            this.assertInvalid(this.evaluate(this.helper, "", "Sequence{1, 2, 3}->subSequence(2, 4)"));
            this.assertInvalid(this.evaluate(this.helper, "", "Sequence{1, 2, 3}->subSequence(2, 1)"));
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_oclAnyCollections_260403() {
        try {
            CollectionsTest.assertTrue((boolean)this.check("let aSeq : Sequence(OclAny) = Sequence {'aString'} in aSeq->including(10) = Sequence {'aString',10}"));
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }
}

