/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.ecore.tests;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.tests.AbstractTestSuite;
import org.eclipse.ocl.options.Option;
import org.eclipse.ocl.options.ParsingOptions;
import org.eclipse.ocl.util.TypeUtil;

public class ParsingOptionsTest
extends AbstractTestSuite {
    public void test_implicitRootClass_option_operations() {
        this.helper.setContext((Object)this.apple);
        String text = "not self.eIsProxy()";
        try {
            this.helper.createInvariant("not self.eIsProxy()");
            ParsingOptionsTest.fail((String)"Should not have successfully parsed.");
        }
        catch (ParserException e) {
            System.out.println("Got expected exception: " + e.getLocalizedMessage());
        }
        ParsingOptions.setOption((Environment)this.ocl.getEnvironment(), (Option)ParsingOptions.implicitRootClass((Environment)this.ocl.getEnvironment()), (Object)EcorePackage.Literals.EOBJECT);
        try {
            Constraint constraint = (Constraint)this.helper.createInvariant("not self.eIsProxy()");
            EObject anApple = ((EPackage)this.fruitPackage).getEFactoryInstance().create(this.apple);
            ParsingOptionsTest.assertTrue((boolean)this.ocl.check((Object)anApple, (Object)constraint));
            ((InternalEObject)anApple).eSetProxyURI(URI.createURI((String)"http://foo#proxy"));
            ParsingOptionsTest.assertFalse((boolean)this.ocl.check((Object)anApple, (Object)constraint));
        }
        catch (ParserException e) {
            ParsingOptionsTest.fail((String)("Should not have failed to parse:" + e.getLocalizedMessage()));
        }
    }

    public void test_implicitRootClass_option_attributes() {
        this.helper.setContext((Object)EcorePackage.Literals.EPACKAGE);
        String text = "self.relatedFruits->isEmpty()";
        try {
            this.helper.createInvariant("self.relatedFruits->isEmpty()");
            ParsingOptionsTest.fail((String)"Should not have successfully parsed.");
        }
        catch (ParserException e) {
            System.out.println("Got expected exception: " + e.getLocalizedMessage());
        }
        ParsingOptions.setOption((Environment)this.ocl.getEnvironment(), (Option)ParsingOptions.implicitRootClass((Environment)this.ocl.getEnvironment()), (Object)this.apple);
        try {
            this.helper.createInvariant("self.relatedFruits->isEmpty()");
        }
        catch (ParserException e) {
            ParsingOptionsTest.fail((String)("Should not have failed to parse:" + e.getLocalizedMessage()));
        }
    }

    public void test_implicitRootClass_option_commonSupertype() {
        ParsingOptionsTest.assertSame((Object)this.ocl.getEnvironment().getOCLStandardLibrary().getOclAny(), (Object)TypeUtil.commonSuperType(null, (Environment)this.ocl.getEnvironment(), (Object)this.apple, (Object)this.stem));
    }

    public void test_implicitRootClass_option_commonSupertype2() {
        ParsingOptions.setOption((Environment)this.ocl.getEnvironment(), (Option)ParsingOptions.implicitRootClass((Environment)this.ocl.getEnvironment()), (Object)EcorePackage.Literals.EOBJECT);
        ParsingOptionsTest.assertSame((Object)EcorePackage.Literals.EOBJECT, (Object)TypeUtil.commonSuperType(null, (Environment)this.ocl.getEnvironment(), (Object)this.apple, (Object)this.stem));
    }

    public void test_implicitRootClass_option_getRelationship() {
        ParsingOptionsTest.assertEquals((int)8, (int)TypeUtil.getRelationship((Environment)this.ocl.getEnvironment(), (Object)EcorePackage.Literals.EOBJECT, (Object)this.apple));
        ParsingOptionsTest.assertEquals((int)8, (int)TypeUtil.getRelationship((Environment)this.ocl.getEnvironment(), (Object)this.apple, (Object)EcorePackage.Literals.EOBJECT));
    }

    public void test_implicitRootClass_option_getRelationship2() {
        ParsingOptions.setOption((Environment)this.ocl.getEnvironment(), (Option)ParsingOptions.implicitRootClass((Environment)this.ocl.getEnvironment()), (Object)EcorePackage.Literals.EOBJECT);
        ParsingOptionsTest.assertEquals((int)4, (int)TypeUtil.getRelationship((Environment)this.ocl.getEnvironment(), (Object)EcorePackage.Literals.EOBJECT, (Object)this.apple));
        ParsingOptionsTest.assertEquals((int)2, (int)TypeUtil.getRelationship((Environment)this.ocl.getEnvironment(), (Object)this.apple, (Object)EcorePackage.Literals.EOBJECT));
    }

    public void test_implicitRootClass_option_get_380755() {
        Environment env = this.ocl.getEnvironment();
        Option implicitRootClass = ParsingOptions.implicitRootClass((Environment)env);
        ParsingOptions.setOption((Environment)env, (Option)implicitRootClass, (Object)EcorePackage.Literals.EOBJECT);
        EClassifier value = (EClassifier)ParsingOptions.getValue((Environment)env, (Option)implicitRootClass);
        ParsingOptionsTest.assertSame((Object)EcorePackage.Literals.EOBJECT, (Object)value);
        ParsingOptions.setOption((Environment)env, (Option)implicitRootClass, null);
        value = (EClassifier)ParsingOptions.getValue((Environment)env, (Option)implicitRootClass);
        ParsingOptionsTest.assertSame(null, (Object)value);
        ParsingOptions.setOption((Environment)env, (Option)implicitRootClass, (Object)EcorePackage.Literals.ECLASS);
        value = (EClassifier)ParsingOptions.getValue((Environment)env, (Option)implicitRootClass);
        ParsingOptionsTest.assertSame((Object)EcorePackage.Literals.ECLASS, (Object)value);
    }
}

