/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.tests;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.OCL;
import org.eclipse.ocl.OCLInput;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.SemanticException;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.helper.Choice;
import org.eclipse.ocl.helper.ChoiceKind;
import org.eclipse.ocl.helper.OCLHelper;
import org.eclipse.ocl.internal.helper.PluginFinder;
import org.eclipse.ocl.lpg.ProblemHandler;
import org.eclipse.ocl.parser.OCLProblemHandler;
import org.eclipse.ocl.tests.TestReflection;
import org.eclipse.ocl.types.OCLStandardLibrary;
import org.eclipse.ocl.util.Bag;
import org.eclipse.ocl.util.CollectionUtil;
import org.eclipse.ocl.util.OCLUtil;
import org.eclipse.ocl.utilities.Visitable;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericTestSuite<E extends EObject, PK extends E, T extends E, C extends T, CLS extends C, DT extends C, PT extends C, ET extends DT, O extends E, PM extends E, P extends E, PA extends P, PR extends P, EL, S, COA, SSA, CT>
extends TestCase {
    private static boolean DISPOSE_RESOURCE_SET = false;
    protected static boolean noDebug = false;
    protected static ResourceSet resourceSet;
    private static ArrayList<Resource> standardResources;
    private static boolean initialized;
    protected TestReflection.Static<E, PK, T, C, CLS, DT, PT, ET, O, PM, P, PA, PR, EL, S, COA, SSA, CT> staticReflection;
    protected OCL<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> ocl;
    protected Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> environment;
    protected TestReflection<E, PK, T, C, CLS, DT, PT, ET, O, PM, P, PA, PR, EL, S, COA, SSA, CT> reflection;
    protected OCLHelper<C, O, P, CT> helper;

    static {
        initialized = false;
    }

    public static <T> Collection<T> createBag(T ... elements) {
        Bag collection = CollectionUtil.createNewBag();
        if (elements != null) {
            T[] TArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                T element = TArray[n2];
                collection.add(element);
                ++n2;
            }
        }
        return collection;
    }

    public static <T> Set<T> createOrderedSet(T ... elements) {
        LinkedHashSet collection = CollectionUtil.createNewOrderedSet();
        if (elements != null) {
            T[] TArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                T element = TArray[n2];
                collection.add(element);
                ++n2;
            }
        }
        return collection;
    }

    public static <T> List<T> createSequence(T ... elements) {
        List collection = CollectionUtil.createNewSequence();
        if (elements != null) {
            T[] TArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                T element = TArray[n2];
                collection.add(element);
                ++n2;
            }
        }
        return collection;
    }

    public static <T> Set<T> createSet(T ... elements) {
        Set collection = CollectionUtil.createNewSet();
        if (elements != null) {
            T[] TArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                T element = TArray[n2];
                collection.add(element);
                ++n2;
            }
        }
        return collection;
    }

    public static void debugPrintln(String string) {
        if (!noDebug) {
            System.out.println(string);
        }
    }

    @Deprecated
    public static boolean eclipseIsRunning() {
        return EMFPlugin.IS_ECLIPSE_RUNNING;
    }

    public static void initializeStandalone() {
        if (initialized) {
            return;
        }
        initialized = true;
    }

    protected void assertBadInvariant(Class<?> exception, int severity, String expression, String messageTemplate, String ... bindings) {
        String denormalized = this.denormalize(expression);
        try {
            this.helper.createInvariant(denormalized);
            GenericTestSuite.fail((String)("Should not have parsed \"" + denormalized + "\""));
        }
        catch (ParserException e) {
            GenericTestSuite.assertEquals((String)("Exception for \"" + denormalized + "\""), exception, ((Object)((Object)e)).getClass());
            Diagnostic diagnostic = this.getDiagnostic();
            this.assertNoException(diagnostic, ClassCastException.class);
            this.assertNoException(diagnostic, NullPointerException.class);
            GenericTestSuite.assertEquals((String)("Severity for \"" + denormalized + "\""), (int)severity, (int)diagnostic.getSeverity());
            String expectedMessage = NLS.bind((String)messageTemplate, (Object[])bindings);
            GenericTestSuite.assertEquals((String)("Message for \"" + denormalized + "\""), (String)expectedMessage, (String)diagnostic.getMessage());
        }
    }

    protected void assertBadQuery(Class<?> exception, int severity, String expression, String messageTemplate, String ... bindings) {
        String denormalized = this.denormalize(expression);
        try {
            this.helper.createQuery(denormalized);
            GenericTestSuite.fail((String)("Should not have parsed \"" + denormalized + "\""));
        }
        catch (ParserException e) {
            GenericTestSuite.assertEquals((String)("Exception for \"" + denormalized + "\""), exception, ((Object)((Object)e)).getClass());
            Diagnostic diagnostic = this.getDiagnostic();
            this.assertNoException(diagnostic, ClassCastException.class);
            this.assertNoException(diagnostic, NullPointerException.class);
            GenericTestSuite.assertEquals((String)("Severity for \"" + denormalized + "\""), (int)severity, (int)diagnostic.getSeverity());
            String expectedMessage = NLS.bind((String)messageTemplate, (Object[])bindings);
            GenericTestSuite.assertEquals((String)("Message for \"" + denormalized + "\""), (String)expectedMessage, (String)diagnostic.getMessage());
        }
    }

    protected void assertChoice(Collection<Choice> choices, ChoiceKind kind, String name) {
        GenericTestSuite.assertNotNull((String)("Choice not found: " + name + ", " + kind), (Object)this.findChoice(choices, kind, name));
    }

    protected void assertInvalid(Object value) {
        GenericTestSuite.assertTrue((String)"Expected invalid", (boolean)this.ocl.isInvalid(value));
    }

    protected OCLExpression<C> assertInvariant(C context, String expression) {
        this.helper.setContext(context);
        String denormalized = this.denormalize(expression);
        try {
            OCLExpression<C> result = this.getBodyExpression(this.helper.createInvariant(denormalized));
            return result;
        }
        catch (Exception e) {
            GenericTestSuite.fail((String)("Parse failed: " + e.getLocalizedMessage()));
            return null;
        }
    }

    protected Object assertInvariantFalse(Object context, String expression) {
        String denormalized = this.denormalize(expression);
        try {
            Boolean value = this.check(this.helper, context, denormalized);
            GenericTestSuite.assertEquals((String)denormalized, (Object)false, (Object)value);
            return value;
        }
        catch (ParserException e) {
            GenericTestSuite.fail((String)("Failed to parse or evaluate \"" + denormalized + "\": " + e.getLocalizedMessage()));
            return null;
        }
    }

    protected Object assertInvariantTrue(Object context, String expression) {
        String denormalized = this.denormalize(expression);
        try {
            Boolean value = this.check(this.helper, context, denormalized);
            GenericTestSuite.assertEquals((String)denormalized, (Object)true, (Object)value);
            return value;
        }
        catch (ParserException e) {
            GenericTestSuite.fail((String)("Failed to parse or evaluate \"" + denormalized + "\": " + e.getLocalizedMessage()));
            return null;
        }
    }

    protected void assertNoException(Diagnostic diagnostic, Class<? extends Throwable> excType) {
        if (excType.isInstance(diagnostic.getException())) {
            GenericTestSuite.fail((String)("Diagnostic signals a(n) " + excType.getSimpleName()));
        }
        for (Diagnostic nested : diagnostic.getChildren()) {
            this.assertNoException(nested, excType);
        }
    }

    protected void assertNotChoice(Collection<Choice> choices, ChoiceKind kind, String name) {
        GenericTestSuite.assertNull((String)("Choice found: " + name + ", " + kind), (Object)this.findChoice(choices, kind, name));
    }

    protected void assertParserError(String expression, String messageTemplate, Object ... bindings) {
        String denormalized = this.denormalize(expression);
        try {
            this.helper.createQuery(denormalized);
            GenericTestSuite.fail((String)("Should not have parsed \"" + denormalized + "\""));
        }
        catch (ParserException e) {
            GenericTestSuite.assertEquals((String)("Exception for \"" + denormalized + "\""), ParserException.class, ((Object)((Object)e)).getClass());
            String expectedMessage = NLS.bind((String)messageTemplate, (Object[])bindings);
            GenericTestSuite.assertEquals((String)("Message for \"" + denormalized + "\""), (String)expectedMessage, (String)e.getMessage());
        }
    }

    protected OCLExpression<C> assertQuery(C context, String expression) {
        this.helper.setContext(context);
        String denormalized = this.denormalize(expression);
        try {
            OCLExpression result = this.helper.createQuery(denormalized);
            return result;
        }
        catch (Exception e) {
            GenericTestSuite.fail((String)("Parse failed: " + e.getLocalizedMessage()));
            return null;
        }
    }

    protected Object assertQueryEquals(Object context, Object expected, String expression) {
        String denormalized = this.denormalize(expression);
        try {
            Object value = this.evaluate(this.helper, context, denormalized);
            GenericTestSuite.assertEquals((String)denormalized, (Object)expected, (Object)value);
            if (expected instanceof LinkedHashSet) {
                GenericTestSuite.assertTrue((String)denormalized, (boolean)(value instanceof LinkedHashSet));
                Iterator es = ((LinkedHashSet)expected).iterator();
                Iterator vs = ((LinkedHashSet)value).iterator();
                while (es.hasNext()) {
                    Object e = es.next();
                    Object v = vs.next();
                    GenericTestSuite.assertEquals((String)denormalized, e, v);
                }
            }
            return value;
        }
        catch (ParserException e) {
            GenericTestSuite.fail((String)("Failed to parse or evaluate \"" + denormalized + "\": " + e.getLocalizedMessage()));
            return null;
        }
    }

    protected Object assertQueryEvaluate(Object context, String expression) {
        String denormalized = this.denormalize(expression);
        try {
            Object value = this.evaluate(this.helper, context, denormalized);
            return value;
        }
        catch (ParserException e) {
            GenericTestSuite.fail((String)("Failed to parse or evaluate \"" + denormalized + "\": " + e.getLocalizedMessage()));
            return null;
        }
    }

    protected Object assertQueryFalse(Object context, String expression) {
        String denormalized = this.denormalize(expression);
        try {
            Object value = this.evaluate(this.helper, context, denormalized);
            GenericTestSuite.assertEquals((String)denormalized, (Object)false, (Object)value);
            return value;
        }
        catch (ParserException e) {
            GenericTestSuite.fail((String)("Failed to parse or evaluate \"" + denormalized + "\": " + e.getLocalizedMessage()));
            return null;
        }
    }

    protected Object assertQueryInvalid(Object context, String expression) {
        String denormalized = this.denormalize(expression);
        try {
            Object value = this.evaluate(this.helper, context, denormalized);
            this.assertInvalid(value);
            return value;
        }
        catch (ParserException e) {
            GenericTestSuite.fail((String)("Failed to parse or evaluate \"" + denormalized + "\": " + e.getLocalizedMessage()));
            return null;
        }
    }

    protected Object assertQueryNotNull(Object context, String expression) {
        String denormalized = this.denormalize(expression);
        try {
            Object value = this.evaluate(this.helper, context, denormalized);
            GenericTestSuite.assertNotNull((String)denormalized, (Object)value);
            return value;
        }
        catch (ParserException e) {
            GenericTestSuite.fail((String)("Failed to parse or evaluate \"" + denormalized + "\": " + e.getLocalizedMessage()));
            return null;
        }
    }

    protected Object assertQueryNull(Object context, String expression) {
        String denormalized = this.denormalize(expression);
        try {
            Object value = this.evaluate(this.helper, context, denormalized);
            GenericTestSuite.assertEquals((String)denormalized, null, (Object)value);
            return value;
        }
        catch (ParserException e) {
            GenericTestSuite.fail((String)("Failed to parse or evaluate \"" + denormalized + "\": " + e.getLocalizedMessage()));
            return null;
        }
    }

    protected Object assertQueryNotSame(Object context, Object expected, String expression) {
        String denormalized = this.denormalize(expression);
        try {
            Object value = this.evaluate(this.helper, context, denormalized);
            GenericTestSuite.assertNotSame((String)denormalized, (Object)expected, (Object)value);
            return value;
        }
        catch (ParserException e) {
            GenericTestSuite.fail((String)("Failed to parse or evaluate \"" + denormalized + "\": " + e.getLocalizedMessage()));
            return null;
        }
    }

    protected Object assertQuerySame(Object context, Object expected, String expression) {
        String denormalized = this.denormalize(expression);
        try {
            Object value = this.evaluate(this.helper, context, denormalized);
            GenericTestSuite.assertSame((String)denormalized, (Object)expected, (Object)value);
            return value;
        }
        catch (ParserException e) {
            GenericTestSuite.fail((String)("Failed to parse or evaluate \"" + denormalized + "\": " + e.getLocalizedMessage()));
            return null;
        }
    }

    protected Object assertQueryTrue(Object context, String expression) {
        String denormalized = this.denormalize(expression);
        try {
            Object value = this.evaluate(this.helper, context, denormalized);
            GenericTestSuite.assertEquals((String)denormalized, (Object)true, (Object)value);
            return value;
        }
        catch (ParserException e) {
            GenericTestSuite.fail((String)("Failed to parse or evaluate \"" + denormalized + "\": " + e.getLocalizedMessage()));
            return null;
        }
    }

    protected void assertSemanticError(String expression, String messageTemplate, String ... bindings) {
        this.assertBadQuery(SemanticException.class, 4, expression, messageTemplate, bindings);
    }

    protected void assertValidToString(Visitable node) {
        try {
            String toString = node.toString();
            GenericTestSuite.assertNotNull((String)"ToStringVisitorImpl returned null", (Object)toString);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            GenericTestSuite.fail((String)("ToStringVisitorImpl threw an exception: " + e.getLocalizedMessage()));
        }
    }

    protected boolean check(String contextFreeExpression) {
        boolean result = false;
        try {
            String document = this.denormalize("package %uml context %String inv: " + contextFreeExpression + " endpackage");
            OCLExpression<C> expr = this.parse(document);
            result = this.check(expr, "");
        }
        catch (Exception e) {
            GenericTestSuite.fail((String)("Check failed: " + e.getLocalizedMessage()));
        }
        return result;
    }

    protected boolean check(OCLHelper<C, O, P, CT> aHelper, Object context, String expression) throws ParserException {
        Object constraint = aHelper.createInvariant(expression);
        return this.ocl.check(context, constraint);
    }

    protected boolean check(OCLExpression<C> expr, Object self) {
        boolean result = false;
        try {
            result = this.ocl.check(self, expr);
        }
        catch (RuntimeException e) {
            GenericTestSuite.fail((String)("Check failed: " + e.getLocalizedMessage()));
        }
        return result;
    }

    protected void checkForUTF8Encoding() {
        String testCharacter = "\u00b4";
        int length = testCharacter.length();
        if (length != 1 || testCharacter.charAt(0) != '\u00b4') {
            StringBuilder s = new StringBuilder();
            s.append("The Resource text file encoding should be set to UTF-8: test character was");
            int i = 0;
            while (i < length) {
                s.append(" ");
                s.append(Integer.toHexString(testCharacter.charAt(i)));
                ++i;
            }
            s.append(" rather than B4");
            GenericTestSuite.fail((String)s.toString());
        }
    }

    protected OCLExpression<C> createBodyCondition(O context, String text) {
        OCLHelper helper = this.ocl.createOCLHelper();
        helper.setOperationContext((Object)((EObject)this.reflection.getOwner(context)), context);
        OCLExpression<C> result = null;
        try {
            result = this.getBodyExpression(helper.createBodyCondition(text));
        }
        catch (Exception e) {
            e.printStackTrace();
            GenericTestSuite.fail((String)("Parse failed: " + e.getLocalizedMessage()));
        }
        return result;
    }

    protected <Z> Collection<Z> createCollection(boolean isOrdered, boolean isUnique, Z ... args) {
        if (isOrdered) {
            return isUnique ? GenericTestSuite.createOrderedSet(args) : GenericTestSuite.createSequence(args);
        }
        return isUnique ? GenericTestSuite.createSet(args) : GenericTestSuite.createBag(args);
    }

    protected void createDocument(String text) {
        try {
            this.ocl.parse(new OCLInput(text));
        }
        catch (Exception e) {
            GenericTestSuite.fail((String)("Failed to parse: " + e.getLocalizedMessage()));
        }
    }

    protected OCLHelper<C, O, P, CT> createHelper() {
        return this.ocl.createOCLHelper();
    }

    protected OCLExpression<C> createInvariant(C context, String expression) {
        return this.assertInvariant(context, expression);
    }

    protected OCL<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> createOCL() {
        return this.staticReflection.createOCL(resourceSet);
    }

    protected OCLExpression<C> createPostcondition(O context, String text) {
        OCLHelper helper = this.ocl.createOCLHelper();
        helper.setOperationContext((Object)((EObject)this.reflection.getOwner(context)), context);
        OCLExpression<C> result = null;
        try {
            result = this.getBodyExpression(helper.createPostcondition(text));
        }
        catch (Exception e) {
            e.printStackTrace();
            GenericTestSuite.fail((String)("Parse failed: " + e.getLocalizedMessage()));
        }
        return result;
    }

    protected OCLExpression<C> createPrecondition(O context, String text) {
        OCLHelper helper = this.ocl.createOCLHelper();
        helper.setOperationContext((Object)((EObject)this.reflection.getOwner(context)), context);
        OCLExpression<C> result = null;
        try {
            result = this.getBodyExpression(helper.createPrecondition(text));
        }
        catch (Exception e) {
            e.printStackTrace();
            GenericTestSuite.fail((String)("Parse failed: " + e.getLocalizedMessage()));
        }
        return result;
    }

    protected OCLExpression<C> createQuery(CLS context, String expression) {
        return this.assertQuery(context, expression);
    }

    protected OCLExpression<C> createQuery(EnvironmentFactory<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> envFactory, C context, String text) {
        OCL localOcl = OCL.newInstance(envFactory);
        OCLHelper helper = localOcl.createOCLHelper();
        helper.setContext(context);
        OCLExpression result = null;
        try {
            result = helper.createQuery(text);
        }
        catch (Exception e) {
            e.printStackTrace();
            GenericTestSuite.fail((String)("Parse failed: " + e.getLocalizedMessage()));
        }
        return result;
    }

    protected void createVariableInEnvironment(String name, C type) {
        Variable var = this.environment.getOCLFactory().createVariable();
        var.setName(name);
        var.setType(type);
        this.environment.addElement(var.getName(), var, true);
    }

    public String denormalize(String expression) {
        StringBuilder s = new StringBuilder();
        int iMax = expression.length();
        int i = 0;
        while (i < iMax) {
            char c = expression.charAt(i);
            if (c == '%') {
                int iStart = ++i;
                while (i < iMax) {
                    c = expression.charAt(i);
                    if (!Character.isLetterOrDigit(c)) break;
                    ++i;
                }
                String key = expression.substring(iStart, i);
                String mapped = this.reflection.denormalize(key);
                s.append(mapped != null ? mapped : key);
            }
            if (i < iMax) {
                s.append(c);
            }
            ++i;
        }
        return s.toString();
    }

    protected void disposeResourceSet() {
        for (Resource res : resourceSet.getResources()) {
            res.unload();
            res.eAdapters().clear();
        }
        resourceSet.getResources().clear();
        resourceSet.eAdapters().clear();
        resourceSet = null;
        standardResources = null;
    }

    protected Object evaluate(String contextFreeExpression) {
        Object result = null;
        try {
            String document = this.denormalize("package %uml context %String inv: " + contextFreeExpression + " endpackage");
            OCLExpression<C> expr = this.parse(document);
            result = this.evaluate(expr, "");
        }
        catch (Exception e) {
            GenericTestSuite.fail((String)("Evaluation failed: " + e.getLocalizedMessage()));
        }
        return result;
    }

    protected Object evaluate(OCLHelper<C, O, P, CT> aHelper, Object context, String expression) throws ParserException {
        OCLExpression query = aHelper.createQuery(expression);
        return this.ocl.evaluate(context, query);
    }

    protected Object evaluate(OCLExpression<C> expr) {
        Object result = null;
        try {
            result = this.ocl.evaluate(null, expr);
        }
        catch (RuntimeException e) {
            GenericTestSuite.fail((String)("Evaluation failed: " + e.getLocalizedMessage()));
        }
        return result;
    }

    protected Object evaluate(OCLExpression<C> expr, Object self) {
        Object result = null;
        try {
            result = this.ocl.evaluate(self, expr);
        }
        catch (RuntimeException e) {
            GenericTestSuite.fail((String)("Evaluation failed: " + e.getLocalizedMessage()));
        }
        return result;
    }

    protected Choice findChoice(Collection<Choice> choices, ChoiceKind kind, String name) {
        Choice result = null;
        for (Choice c : choices) {
            if (c.getKind() != kind || !name.equals(c.getName())) continue;
            result = c;
            break;
        }
        return result;
    }

    protected OCLExpression<C> getBodyExpression(CT constraint) {
        return this.reflection.getBodyExpression(constraint);
    }

    protected Diagnostic getDiagnostic() {
        OCLProblemHandler handler = (OCLProblemHandler)OCLUtil.getAdapter((Environment)this.ocl.getEnvironment(), ProblemHandler.class);
        Diagnostic result = handler.getDiagnostic();
        if (result == null) {
            result = this.helper.getProblems();
        }
        GenericTestSuite.assertNotNull((String)"No diagnostic", (Object)result);
        return result;
    }

    protected PT getEcoreBigDecimal() {
        return (PT)((EObject)this.reflection.getEcoreBigDecimal());
    }

    protected PT getEcoreBigInteger() {
        return (PT)((EObject)this.reflection.getEcoreBigInteger());
    }

    protected PT getEcoreLong() {
        return (PT)((EObject)this.reflection.getEcoreLong());
    }

    protected Object getInvalid() {
        return this.getOCLStandardLibrary().getInvalid();
    }

    protected C getMetaclass(String name) {
        return (C)((EObject)this.reflection.getMetaclass(name));
    }

    protected C getMetametaclass(String name) {
        return (C)((EObject)this.reflection.getMetametaclass(name));
    }

    public String getName() {
        String testNameSuffix = System.getProperty("testNameSuffix", "");
        return String.valueOf(super.getName()) + " <" + testNameSuffix + ">";
    }

    protected OCLStandardLibrary<C> getOCLStandardLibrary() {
        return this.ocl.getEnvironment().getOCLStandardLibrary();
    }

    protected abstract TestReflection.Static<E, PK, T, C, CLS, DT, PT, ET, O, PM, P, PA, PR, EL, S, COA, SSA, CT> getStaticReflection();

    public URI getTestModelURI(String localFileName) {
        String testPlugInId = this.staticReflection.getTestPlugInId();
        try {
            Class<?> platformClass = Class.forName("org.eclipse.core.runtime.Platform");
            Method getBundle = platformClass.getDeclaredMethod("getBundle", String.class);
            Object bundle = getBundle.invoke(null, testPlugInId);
            if (bundle != null) {
                Method getEntry = bundle.getClass().getMethod("getEntry", String.class);
                URL url = (URL)getEntry.invoke(bundle, localFileName);
                return URI.createURI((String)url.toString());
            }
        }
        catch (Throwable platformClass) {
            // empty catch block
        }
        PluginFinder pluginFinder = new PluginFinder(new String[]{testPlugInId});
        pluginFinder.resolve();
        String urlString = pluginFinder.get(testPlugInId);
        if (urlString == null) {
            TestCase.fail((String)("'" + testPlugInId + "' property not defined; use the launch configuration to define it"));
        }
        return URI.createFileURI((String)(String.valueOf(urlString) + "/" + localFileName));
    }

    protected PT getUMLBoolean() {
        return (PT)((EObject)this.reflection.getUMLBoolean());
    }

    protected PT getUMLInteger() {
        return (PT)((EObject)this.reflection.getUMLInteger());
    }

    protected PK getUMLMetamodel() {
        return (PK)((EObject)this.reflection.getUMLMetamodel());
    }

    protected PT getUMLString() {
        return (PT)((EObject)this.reflection.getUMLString());
    }

    protected PT getUMLUnlimitedNatural() {
        return (PT)((EObject)this.reflection.getUMLUnlimitedNatural());
    }

    protected void initializeResourceSet() {
        resourceSet = this.staticReflection.createResourceSet();
        standardResources = new ArrayList(resourceSet.getResources());
    }

    protected OCLExpression<C> parse(String text) {
        OCLExpression<C> result = this.parseUnvalidated(text);
        this.validate(result);
        this.assertValidToString((Visitable)result);
        return result;
    }

    protected OCLExpression<C> parseConstraint(String text) {
        OCLExpression<C> result = this.parseConstraintUnvalidated(text);
        this.validate(result);
        this.assertValidToString((Visitable)result);
        return result;
    }

    protected OCLExpression<C> parseConstraintUnvalidated(String text) {
        CT constraint = null;
        try {
            List constraints = this.ocl.parse(new OCLInput(text));
            constraint = (CT)constraints.get(0);
        }
        catch (ParserException e) {
            GenericTestSuite.fail((String)("Parse failed: " + e.getLocalizedMessage()));
        }
        catch (IllegalArgumentException e) {
            GenericTestSuite.fail((String)("Parse failed (illegal argument): " + e.getLocalizedMessage()));
        }
        OCLExpression<C> result = null;
        result = this.getBodyExpression(constraint);
        GenericTestSuite.assertNotNull(result);
        this.assertValidToString((Visitable)result);
        return result;
    }

    protected OCLExpression<C> parseDef(String text) {
        CT constraint = null;
        try {
            List constraints = this.ocl.parse(new OCLInput(text));
            constraint = (CT)constraints.get(0);
        }
        catch (ParserException e) {
            GenericTestSuite.fail((String)("Parse failed: " + e.getLocalizedMessage()));
        }
        catch (IllegalArgumentException e) {
            GenericTestSuite.fail((String)("Parse failed (illegal argument): " + e.getLocalizedMessage()));
        }
        OCLExpression<C> result = null;
        result = this.getBodyExpression(constraint);
        this.validate(result);
        GenericTestSuite.assertNotNull(result);
        this.assertValidToString((Visitable)result);
        return result;
    }

    protected OCLExpression<C> parseUnvalidated(String text) {
        OCLExpression<C> result = this.parseConstraintUnvalidated(text);
        EcoreUtil.remove(result);
        this.assertValidToString((Visitable)result);
        return result;
    }

    protected PK registerPackage(PK pkg, String nsPrefix, String nsUri) {
        this.reflection.setNsPrefix(pkg, nsPrefix);
        this.reflection.setNsURI(pkg, nsUri);
        ResourceImpl resource = new ResourceImpl(URI.createURI((String)nsUri));
        resource.getContents().add(pkg);
        resourceSet.getResources().add((Object)resource);
        resourceSet.getPackageRegistry().put((Object)nsUri, pkg);
        return pkg;
    }

    protected void setUp() {
        this.staticReflection = this.getStaticReflection();
        if (resourceSet != null && DISPOSE_RESOURCE_SET) {
            this.disposeResourceSet();
        }
        if (!initialized) {
            String property = System.getProperty(String.valueOf(this.staticReflection.getTestPlugInId()) + ".nodebug");
            boolean bl = noDebug = !"false".equals(property);
            if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
                GenericTestSuite.initializeStandalone();
            }
        }
        if (resourceSet == null) {
            this.initializeResourceSet();
        }
        GenericTestSuite.debugPrintln("==> Start  " + this.getName());
        this.ocl = this.createOCL();
        this.environment = this.ocl.getEnvironment();
        this.reflection = this.staticReflection.createReflection(this.environment);
        String repairs = System.getProperty(String.valueOf(this.staticReflection.getTestPlugInId()) + ".repairs");
        if (repairs != null) {
            this.ocl.setParserRepairCount(Integer.parseInt(repairs));
        }
        this.helper = this.createHelper();
    }

    protected void tearDown() throws Exception {
        ListIterator i = resourceSet.getResources().listIterator();
        while (i.hasNext()) {
            Resource res = (Resource)i.next();
            if (standardResources.contains(res)) continue;
            i.remove();
            res.unload();
            res.eAdapters().clear();
        }
        Class<?> aClass = ((Object)((Object)this)).getClass();
        while (GenericTestSuite.class.isAssignableFrom(aClass)) {
            Field[] fieldArray = aClass.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                int modifiers = field.getModifiers();
                if (!Modifier.isFinal(modifiers)) {
                    if (!Modifier.isStatic(modifiers)) {
                        Class<?> fieldType = field.getType();
                        if (Object.class.isAssignableFrom(fieldType)) {
                            String fieldName = field.getName();
                            try {
                                String tearDownName = "tearDown_" + fieldName;
                                Method method = aClass.getDeclaredMethod(tearDownName, new Class[0]);
                                try {
                                    this.tearDownUsing(method);
                                }
                                catch (Exception e) {
                                    GenericTestSuite.fail((String)("Failed to invoke " + ((Object)((Object)this)).getClass().getSimpleName() + "." + tearDownName + " : " + e));
                                }
                            }
                            catch (NoSuchMethodException e) {
                                try {
                                    this.tearDownField(field);
                                }
                                catch (Exception e1) {
                                    GenericTestSuite.fail((String)("Failed to set " + ((Object)((Object)this)).getClass().getSimpleName() + "." + fieldName + " to null : " + e1));
                                }
                            }
                        }
                    } else {
                        this.tearDownStatic(aClass, field);
                    }
                }
                ++n2;
            }
            aClass = aClass.getSuperclass();
        }
        GenericTestSuite.debugPrintln("==> Finish " + this.getName());
    }

    protected void tearDownField(Field field) throws IllegalAccessException {
        field.set((Object)this, null);
    }

    protected void tearDownStatic(Class<?> aClass, Field field) {
        if (aClass != GenericTestSuite.class) {
            GenericTestSuite.fail((String)("static test variable:" + field));
        }
    }

    protected void tearDownUsing(Method method) throws IllegalAccessException, InvocationTargetException {
        method.invoke((Object)this, new Object[0]);
    }

    protected void tearDown_ocl() {
        this.ocl.dispose();
        this.ocl = null;
    }

    protected void validate(CT constraint) {
        try {
            this.ocl.validate(constraint);
        }
        catch (SemanticException e) {
            GenericTestSuite.fail((String)("Validation failed: " + e.getLocalizedMessage()));
        }
    }

    protected void validate(OCLExpression<C> expr) {
        try {
            EObject eContainer = expr.eContainer();
            if (eContainer != null && this.reflection.getConstraintClass().isAssignableFrom(eContainer.eContainer().getClass())) {
                EObject eContainerContainer = eContainer.eContainer();
                this.validate(eContainerContainer);
            } else {
                this.ocl.validate(expr);
            }
        }
        catch (SemanticException e) {
            GenericTestSuite.fail((String)("Validation failed: " + e.getLocalizedMessage()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CheckedTestSuite
    extends TestSuite {
        public CheckedTestSuite(String name) {
            super(name);
        }

        public void createTestSuite(Class<? extends GenericTestSuite> testClass, String testName) {
            this.addTest((Test)new TestSuite(testClass, testName));
        }

        public void addTestSuite(CheckedTestSuite suite) {
            this.addTest((Test)suite);
        }
    }
}

