/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.ecore.tests;

import company.Bug418716;
import company.CompanyFactory;
import company.CompanyPackage;
import company.Employee;
import company.util.CompanyValidator;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import noreflectioncompany.NoreflectioncompanyPackage;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.util.QueryDelegate;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.examples.extlibrary.EXTLibraryFactory;
import org.eclipse.emf.examples.extlibrary.EXTLibraryPackage;
import org.eclipse.emf.examples.extlibrary.Library;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.common.OCLCommon;
import org.eclipse.ocl.common.delegate.DelegateResourceSetAdapter;
import org.eclipse.ocl.common.internal.delegate.OCLDelegateException;
import org.eclipse.ocl.common.internal.options.CommonOptions;
import org.eclipse.ocl.ecore.BooleanLiteralExp;
import org.eclipse.ocl.ecore.EcoreFactory;
import org.eclipse.ocl.ecore.NullLiteralExp;
import org.eclipse.ocl.ecore.OCL;
import org.eclipse.ocl.ecore.OCLExpression;
import org.eclipse.ocl.ecore.OperationCallExp;
import org.eclipse.ocl.ecore.PropertyCallExp;
import org.eclipse.ocl.ecore.delegate.DelegateDomain;
import org.eclipse.ocl.ecore.delegate.InvocationBehavior;
import org.eclipse.ocl.ecore.delegate.OCLDelegateDomain;
import org.eclipse.ocl.ecore.delegate.OCLDelegateDomainFactory;
import org.eclipse.ocl.ecore.delegate.OCLInvocationDelegateFactory;
import org.eclipse.ocl.ecore.delegate.OCLQueryDelegateFactory;
import org.eclipse.ocl.ecore.delegate.OCLSettingDelegateFactory;
import org.eclipse.ocl.ecore.delegate.OCLValidationDelegateFactory;
import org.eclipse.ocl.ecore.delegate.SettingBehavior;
import org.eclipse.ocl.ecore.delegate.ValidationBehavior;
import org.eclipse.ocl.ecore.delegate.ValidationDelegate;
import org.eclipse.ocl.ecore.opposites.DefaultOppositeEndFinder;
import org.eclipse.ocl.ecore.opposites.EcoreEnvironmentFactoryWithHiddenOpposites;
import org.eclipse.ocl.ecore.opposites.OppositeEndFinder;
import org.eclipse.ocl.ecore.tests.AbstractTestSuite;
import org.eclipse.ocl.internal.l10n.OCLMessages;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatesTest
extends AbstractTestSuite {
    protected static final String COMPANY_XMI = "/model/Company.xmi";
    protected static final String NO_REFLECTION_COMPANY_XMI = "/model/NoReflectionCompany.xmi";
    protected static final String MODEL_WITH_ERRORS_XMI = "/model/ModelWithErrors.xmi";
    public Resource testResource;
    public EPackage companyPackage;
    public EFactory companyFactory;
    public EClass companyClass;
    public EAttribute companyName;
    public EReference companyEmployees;
    public EAttribute companySize;
    public EClass employeeClass;
    public EAttribute employeeName;
    public EReference employeeManager;
    public EReference employeeDirectReports;
    public EReference employeeAllReports;
    public EOperation employeeReportsTo;
    public EEnum sizeKind;
    public Enumerator sizeSmall;
    public Enumerator sizeMedium;
    public Enumerator sizeLarge;
    public EObject acme;
    public Map<String, EObject> employees;
    public EClass badClassClass;
    public EReference companyDetritus;
    public Map<Object, Object> context = new HashMap<Object, Object>();
    public boolean eclipseIsRunning;
    public boolean usedLocalRegistry;

    protected void setUp() {
        super.setUp();
        this.eclipseIsRunning = EMFPlugin.IS_ECLIPSE_RUNNING;
        this.usedLocalRegistry = false;
        this.initializeResourceSet("http://www.eclipse.org/emf/2002/Ecore/OCL/LPG");
        OCLDelegateDomain.initializeMappingFrom(null, (String)"http://www.eclipse.org/emf/2002/Ecore/OCL");
    }

    protected void initializeResourceSet(String oclDelegateURI) {
        if (!this.eclipseIsRunning) {
            EOperation.Internal.InvocationDelegate.Factory.Registry.INSTANCE.put((Object)oclDelegateURI, (Object)new OCLInvocationDelegateFactory.Global());
            EStructuralFeature.Internal.SettingDelegate.Factory.Registry.INSTANCE.put((Object)oclDelegateURI, (Object)new OCLSettingDelegateFactory.Global());
            EValidator.ValidationDelegate.Registry.INSTANCE.put((Object)oclDelegateURI, (Object)new OCLValidationDelegateFactory.Global());
            QueryDelegate.Factory.Registry.INSTANCE.put((Object)oclDelegateURI, (Object)new OCLQueryDelegateFactory.Global());
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xmi", new EcoreResourceFactoryImpl());
            EPackage.Registry.INSTANCE.remove((Object)"http://www.eclipse.org/ocl/test/2010/Company.ecore");
            resourceSet.getPackageRegistry().remove((Object)"http://www.eclipse.org/ocl/test/2010/Company.ecore");
            EPackage.Registry.INSTANCE.remove((Object)"http://www.eclipse.org/ocl/test/2010/NoReflectionCompany.ecore");
            resourceSet.getPackageRegistry().remove((Object)"http://www.eclipse.org/ocl/test/2010/NoReflectionCompany.ecore");
        }
        DelegateResourceSetAdapter adapter = DelegateResourceSetAdapter.getAdapter((ResourceSet)resourceSet);
        DelegateDomain.Factory.Registry.Impl delegateDomainFactory = new DelegateDomain.Factory.Registry.Impl();
        delegateDomainFactory.put((Object)oclDelegateURI, (Object)new OCLDelegateDomainFactory());
        adapter.putRegistry(DelegateDomain.Factory.Registry.class, (Object)delegateDomainFactory);
        ValidationDelegate.Factory.Registry.Impl validationDelegateFactoryRegistry = new ValidationDelegate.Factory.Registry.Impl();
        validationDelegateFactoryRegistry.put((Object)oclDelegateURI, (Object)new OCLValidationDelegateFactory(oclDelegateURI){

            public ValidationDelegate createValidationDelegate(EClassifier classifier) {
                DelegatesTest.this.usedLocalRegistry = true;
                return super.createValidationDelegate(classifier);
            }
        });
        adapter.putRegistry(ValidationDelegate.Factory.Registry.class, (Object)validationDelegateFactoryRegistry);
        EStructuralFeature.Internal.SettingDelegate.Factory.Registry.Impl settingDelegateFactoryRegistry = new EStructuralFeature.Internal.SettingDelegate.Factory.Registry.Impl();
        settingDelegateFactoryRegistry.put((Object)oclDelegateURI, (Object)new OCLSettingDelegateFactory(oclDelegateURI){

            public EStructuralFeature.Internal.SettingDelegate createSettingDelegate(EStructuralFeature structuralFeature) {
                DelegatesTest.this.usedLocalRegistry = true;
                return super.createSettingDelegate(structuralFeature);
            }
        });
        adapter.putRegistry(EStructuralFeature.Internal.SettingDelegate.Factory.Registry.class, (Object)settingDelegateFactoryRegistry);
        EOperation.Internal.InvocationDelegate.Factory.Registry.Impl invocationDelegateFactoryRegistry = new EOperation.Internal.InvocationDelegate.Factory.Registry.Impl();
        invocationDelegateFactoryRegistry.put((Object)oclDelegateURI, (Object)new OCLInvocationDelegateFactory(oclDelegateURI){

            public EOperation.Internal.InvocationDelegate createInvocationDelegate(EOperation operation) {
                DelegatesTest.this.usedLocalRegistry = true;
                return super.createInvocationDelegate(operation);
            }
        });
        adapter.putRegistry(EOperation.Internal.InvocationDelegate.Factory.Registry.class, (Object)invocationDelegateFactoryRegistry);
        QueryDelegate.Factory.Registry.Impl queryDelegateFactoryRegistry = new QueryDelegate.Factory.Registry.Impl();
        queryDelegateFactoryRegistry.put((Object)oclDelegateURI, (Object)new OCLQueryDelegateFactory(oclDelegateURI){

            public QueryDelegate createQueryDelegate(EClassifier context, Map<String, EClassifier> parameters, String expression) {
                DelegatesTest.this.usedLocalRegistry = true;
                return super.createQueryDelegate(context, parameters, expression);
            }
        });
        adapter.putRegistry(QueryDelegate.Factory.Registry.class, (Object)queryDelegateFactoryRegistry);
    }

    protected void initModel(String testModelName) {
        URI uri = this.getTestModelURI(testModelName);
        this.testResource = resourceSet.getResource(uri, true);
        this.acme = (EObject)this.testResource.getContents().get(0);
        this.companyClass = this.acme.eClass();
        this.companyPackage = this.companyClass.getEPackage();
        this.companyFactory = this.companyPackage.getEFactoryInstance();
        this.companyName = (EAttribute)this.companyClass.getEStructuralFeature("name");
        this.companyEmployees = (EReference)this.companyClass.getEStructuralFeature("employees");
        this.companySize = (EAttribute)this.companyClass.getEStructuralFeature("size");
        this.employeeClass = this.companyEmployees.getEReferenceType();
        this.employeeName = (EAttribute)this.employeeClass.getEStructuralFeature("name");
        this.employeeManager = (EReference)this.employeeClass.getEStructuralFeature("manager");
        this.employeeDirectReports = (EReference)this.employeeClass.getEStructuralFeature("directReports");
        this.employeeAllReports = (EReference)this.employeeClass.getEStructuralFeature("allReports");
        this.employeeReportsTo = this.getOperation(this.employeeClass, "reportsTo");
        this.sizeKind = (EEnum)this.companySize.getEAttributeType();
        this.sizeSmall = this.sizeKind.getEEnumLiteral("small").getInstance();
        this.sizeMedium = this.sizeKind.getEEnumLiteral("medium").getInstance();
        this.sizeLarge = this.sizeKind.getEEnumLiteral("large").getInstance();
        this.employees = new HashMap<String, EObject>();
    }

    protected void initModelWithErrors() {
        URI uri = this.getTestModelURI(MODEL_WITH_ERRORS_XMI);
        this.testResource = resourceSet.getResource(uri, true);
        this.acme = (EObject)this.testResource.getContents().get(0);
        this.companyClass = this.acme.eClass();
        this.companyPackage = this.companyClass.getEPackage();
        this.companyFactory = this.companyPackage.getEFactoryInstance();
        this.badClassClass = (EClass)this.companyPackage.getEClassifier("BadClass");
        this.companyDetritus = (EReference)this.companyClass.getEStructuralFeature("detritus");
    }

    protected void initPackageRegistrations() {
        if (!this.eclipseIsRunning) {
            resourceSet.getPackageRegistry().put((Object)"http://www.eclipse.org/ocl/test/2010/Company.ecore", (Object)CompanyPackage.eINSTANCE);
            resourceSet.getPackageRegistry().put((Object)"http://www.eclipse.org/ocl/test/2010/NoReflectionCompany.ecore", (Object)NoreflectioncompanyPackage.eINSTANCE);
        }
    }

    public void doTest_allInstances(String modelName) {
        this.initModel(modelName);
        EList<EObject> amyAllReports = this.allReports(this.employee("Amy"));
        DelegatesTest.assertEquals((int)5, (int)amyAllReports.size());
        DelegatesTest.assertTrue((boolean)amyAllReports.contains((Object)this.employee("Bob")));
        DelegatesTest.assertTrue((boolean)amyAllReports.contains((Object)this.employee("Jane")));
        DelegatesTest.assertTrue((boolean)amyAllReports.contains((Object)this.employee("Fred")));
        DelegatesTest.assertTrue((boolean)amyAllReports.contains((Object)this.employee("Norbert")));
        DelegatesTest.assertTrue((boolean)amyAllReports.contains((Object)this.employee("Sally")));
        this.set(this.create(this.acme, this.companyEmployees, this.employeeClass, "Manuel"), (EStructuralFeature)this.employeeManager, this.employee("Bob"));
        amyAllReports = this.allReports(this.employee("Amy"));
        DelegatesTest.assertEquals((int)6, (int)amyAllReports.size());
        DelegatesTest.assertTrue((boolean)amyAllReports.contains((Object)this.employee("Manuel")));
    }

    public void doTest_constraintValidation(String modelName) {
        this.initModel(modelName);
        EObject employee = this.create(this.acme, this.companyEmployees, this.employeeClass, null);
        this.set(employee, (EStructuralFeature)this.employeeManager, this.employee("Bob"));
        this.validateConstraintWithError("mustHaveName", employee);
        this.set(employee, (EStructuralFeature)this.employeeName, "Joe");
        this.validateWithoutError(employee);
        this.validateWithoutError(this.acme);
    }

    public void doTest_eAttributeDerivation(String modelName) {
        this.initModel(modelName);
        DelegatesTest.assertSame((Object)this.sizeSmall, (Object)this.size(this.acme));
        EList<EObject> emps = this.employees(this.acme);
        int i = 0;
        while (i < 60) {
            emps.add((Object)this.companyFactory.create(this.employeeClass));
            ++i;
        }
        DelegatesTest.assertSame((Object)this.sizeMedium, (Object)this.size(this.acme));
        i = 0;
        while (i < 1000) {
            emps.add((Object)this.companyFactory.create(this.employeeClass));
            ++i;
        }
        DelegatesTest.assertSame((Object)this.sizeLarge, (Object)this.size(this.acme));
    }

    public void doTest_eReferenceDerivation(String modelName) {
        this.initModel(modelName);
        EList<EObject> amyReports = this.directReports(this.employee("Amy"));
        DelegatesTest.assertEquals((int)3, (int)amyReports.size());
        DelegatesTest.assertTrue((boolean)amyReports.contains((Object)this.employee("Bob")));
        DelegatesTest.assertTrue((boolean)amyReports.contains((Object)this.employee("Jane")));
        DelegatesTest.assertTrue((boolean)amyReports.contains((Object)this.employee("Fred")));
        EList<EObject> bobReports = this.directReports(this.employee("Bob"));
        DelegatesTest.assertEquals((int)2, (int)bobReports.size());
        DelegatesTest.assertTrue((boolean)bobReports.contains((Object)this.employee("Norbert")));
        DelegatesTest.assertTrue((boolean)bobReports.contains((Object)this.employee("Sally")));
        EList<EObject> sallyReports = this.directReports(this.employee("Sally"));
        DelegatesTest.assertEquals((int)0, (int)sallyReports.size());
    }

    public void doTest_invariantValidation(String modelName, boolean hasInvariants) {
        this.initModel(modelName);
        EObject joe = this.create(this.acme, this.companyEmployees, this.employeeClass, "Joe");
        if (hasInvariants) {
            this.validateInvariantWithError("noManagerImpliesDirectReports", joe);
        } else {
            this.validateConstraintWithError("noManagerImpliesDirectReports", joe);
        }
        this.set(this.employee("Amy"), (EStructuralFeature)this.employeeManager, joe);
        this.validateWithoutError(joe);
    }

    public void doTest_operationInvocation(String modelName) {
        this.initModel(modelName);
        EObject amy = this.employee("Amy");
        EList<EObject> amyAllReports = this.allReports(amy);
        DelegatesTest.assertEquals((int)5, (int)amyAllReports.size());
        for (EObject next : amyAllReports) {
            DelegatesTest.assertTrue((boolean)((Boolean)this.invoke(next, this.employeeReportsTo, amy)));
        }
    }

    public void doTest_queryExecution(String modelName) {
        this.initModel(modelName);
        QueryDelegate.Factory factory = QueryDelegate.Factory.Registry.INSTANCE.getFactory("http://www.eclipse.org/emf/2002/Ecore/OCL/LPG");
        String n = "n";
        String expression = "self.employees->select(employee | employee.manager <> null and employee.manager.name = n)";
        EObject amy = this.employee("Amy");
        HashMap<String, EDataType> parameters = new HashMap<String, EDataType>();
        parameters.put(n, EcorePackage.Literals.ESTRING);
        QueryDelegate delegate = factory.createQueryDelegate((EClassifier)this.companyClass, parameters, expression);
        this.executeWithException(delegate, amy, null, OCLMessages.WrongContextClassifier_ERROR_, amy.eClass().getName(), this.acme.eClass().getName());
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        arguments.put(n, "Amy");
        Collection amyReports = (Collection)this.execute(delegate, this.acme, arguments);
        DelegatesTest.assertEquals((int)3, (int)amyReports.size());
        DelegatesTest.assertTrue((boolean)amyReports.contains(this.employee("Bob")));
        DelegatesTest.assertTrue((boolean)amyReports.contains(this.employee("Jane")));
        DelegatesTest.assertTrue((boolean)amyReports.contains(this.employee("Fred")));
        this.executeWithException(delegate, this.employee("Bob"), null, OCLMessages.WrongContextClassifier_ERROR_, amy.eClass().getName(), this.acme.eClass().getName());
        arguments = new HashMap();
        arguments.put(n, "Bob");
        Collection bobReports = (Collection)this.execute(delegate, this.acme, arguments);
        DelegatesTest.assertEquals((int)2, (int)bobReports.size());
        DelegatesTest.assertTrue((boolean)bobReports.contains(this.employee("Norbert")));
        DelegatesTest.assertTrue((boolean)bobReports.contains(this.employee("Sally")));
        this.executeWithException(delegate, this.employee("Sally"), null, OCLMessages.WrongContextClassifier_ERROR_, amy.eClass().getName(), this.acme.eClass().getName());
        arguments = new HashMap();
        arguments.put(n, "Sally");
        Collection sallyReports = (Collection)this.execute(delegate, this.acme, arguments);
        DelegatesTest.assertEquals((int)0, (int)sallyReports.size());
    }

    public void doTest_queryExecutionWithExceptions(String modelName) throws InvocationTargetException {
        this.initModel(modelName);
        QueryDelegate.Factory factory = QueryDelegate.Factory.Registry.INSTANCE.getFactory("http://www.eclipse.org/emf/2002/Ecore/OCL/LPG");
        String okName = "ok";
        String badName = "xyzzy";
        EObject amy = this.employee("Amy");
        HashMap<String, Object> okBindings = new HashMap<String, Object>();
        okBindings.put(okName, 123);
        HashMap<String, EDataType> variables = new HashMap<String, EDataType>();
        variables.put(okName, EcorePackage.Literals.ESTRING);
        QueryDelegate delegate = factory.createQueryDelegate((EClassifier)this.companyClass, null, "n=");
        this.executeWithException(delegate, amy, null, "2:2:2:2 \"relationalNotLetCS\" expected after \"=\"", new Object[0]);
        delegate = factory.createQueryDelegate((EClassifier)this.companyClass, variables, badName);
        this.executeWithException(delegate, this.acme, null, OCLMessages.UnrecognizedVar_ERROR_, badName);
        delegate = factory.createQueryDelegate((EClassifier)this.companyClass, variables, "self");
        HashMap<String, Object> bindings = new HashMap<String, Object>();
        bindings.put(okName, "xx");
        bindings.put(badName, 123);
        this.executeWithException(delegate, this.acme, bindings, OCLMessages.ExtraArg_ERROR_, badName);
        delegate = factory.createQueryDelegate((EClassifier)this.companyClass, variables, "self");
        delegate.prepare();
        this.executeWithException(delegate, amy, okBindings, OCLMessages.WrongContextClassifier_ERROR_, amy.eClass().getName(), this.acme.eClass().getName());
        delegate = factory.createQueryDelegate((EClassifier)this.companyClass, variables, "self");
        delegate.prepare();
        this.executeWithException(delegate, this.acme, okBindings, OCLMessages.TypeConformanceInit_ERROR_, okName);
    }

    public void test_allInstances() {
        this.doTest_allInstances(COMPANY_XMI);
        DelegatesTest.assertEquals((!this.eclipseIsRunning ? 1 : 0) != 0, (boolean)this.usedLocalRegistry);
    }

    public void test_allInstances_registered() {
        this.initPackageRegistrations();
        this.doTest_allInstances(COMPANY_XMI);
        DelegatesTest.assertFalse((boolean)this.usedLocalRegistry);
    }

    public void test_attributeDefinedWithDerivationAndInitial() {
        this.initModelWithErrors();
        EObject badClassInstance = this.create(this.acme, this.companyDetritus, this.badClassClass, null);
        Object actual = this.get(badClassInstance, (EStructuralFeature)((EAttribute)this.badClassClass.getEStructuralFeature("attributeDefinedWithDerivationAndInitial")));
        DelegatesTest.assertEquals((Object)42, actual);
    }

    public void test_attributeDefinedWithInitial() {
        this.initModelWithErrors();
        EObject badClassInstance = this.create(this.acme, this.companyDetritus, this.badClassClass, null);
        Object actual = this.get(badClassInstance, (EStructuralFeature)((EAttribute)this.badClassClass.getEStructuralFeature("attributeDefinedWithInitial")));
        DelegatesTest.assertEquals((Object)-42, actual);
    }

    public void test_attributeDefinedWithoutDerivation() {
        this.initModelWithErrors();
        EObject badClassInstance = this.create(this.acme, this.companyDetritus, this.badClassClass, null);
        this.getWithException(badClassInstance, "attributeDefinedWithoutDerivation", OCLMessages.MissingDerivationForSettingDelegate_ERROR_, "modelWithErrors::BadClass.attributeDefinedWithoutDerivation");
    }

    public void test_attributeDefinedWithoutDerivationBody() {
        this.initModelWithErrors();
        EObject badClassInstance = this.create(this.acme, this.companyDetritus, this.badClassClass, null);
        this.getWithException(badClassInstance, "attributeDefinedWithoutDerivationBody", OCLMessages.MissingDerivationForSettingDelegate_ERROR_, "modelWithErrors::BadClass.attributeDefinedWithoutDerivationBody");
    }

    public void test_attributeEvaluatingToInvalid() {
        this.initModelWithErrors();
        EObject badClassInstance = this.create(this.acme, this.companyDetritus, this.badClassClass, null);
        this.getWithException(badClassInstance, "attributeEvaluatingToInvalid", OCLMessages.EvaluationResultIsInvalid_ERROR_, "modelWithErrors::BadClass.attributeEvaluatingToInvalid");
    }

    public void test_attributeEvaluatingToNull() {
        this.initModelWithErrors();
        EObject badClassInstance = this.create(this.acme, this.companyDetritus, this.badClassClass, null);
        EStructuralFeature eStructuralFeature = badClassInstance.eClass().getEStructuralFeature("attributeEvaluatingToNull");
        DelegatesTest.assertEquals(null, this.get(badClassInstance, eStructuralFeature));
    }

    public void test_attributeEvaluatingToWrongType() {
        this.initModelWithErrors();
        EObject badClassInstance = this.create(this.acme, this.companyDetritus, this.badClassClass, null);
        this.getWithException(badClassInstance, "attributeEvaluatingToWrongType", OCLMessages.InitOrDerConstraintConformance_ERROR_, "String", "attributeEvaluatingToWrongType", "Boolean");
    }

    public void test_attributeParsingToLexicalError() {
        this.initModelWithErrors();
        EObject badClassInstance = this.create(this.acme, this.companyDetritus, this.badClassClass, null);
        this.getWithException(badClassInstance, "attributeParsingToLexicalError", OCLMessages.OCLParseErrorCodes_LEX_ERROR, "2:2", "\"#\"");
    }

    public void test_attributeParsingToSemanticError() {
        this.initModelWithErrors();
        EObject badClassInstance = this.create(this.acme, this.companyDetritus, this.badClassClass, null);
        this.getWithException(badClassInstance, "attributeParsingToSemanticError", OCLMessages.OperationNotFound_ERROR_, "and(Integer)", "String");
    }

    public void test_attributeParsingToSyntacticError() {
        this.initModelWithErrors();
        EObject badClassInstance = this.create(this.acme, this.companyDetritus, this.badClassClass, null);
        this.getWithException(badClassInstance, "attributeParsingToSyntacticError", OCLMessages.OCLParseErrorCodes_DELETION, "2:9:2:12", "\"null\"");
    }

    public void test_attributeNotDefinedInOCLRemainsNull() throws ParserException {
        this.helper.setContext((Object)EcorePackage.eINSTANCE.getEClassifier());
        OCLExpression expr = (OCLExpression)this.helper.createQuery("self.name");
        DelegatesTest.assertTrue((boolean)(expr instanceof PropertyCallExp));
        PropertyCallExp pce = (PropertyCallExp)expr;
        EStructuralFeature p = (EStructuralFeature)pce.getReferredProperty();
        OCLExpression body = SettingBehavior.INSTANCE.getFeatureBody((OCL)this.ocl, p);
        DelegatesTest.assertNull((Object)body);
        OCLExpression bodyStillNull = SettingBehavior.INSTANCE.getFeatureBody((OCL)this.ocl, p);
        DelegatesTest.assertNull((Object)bodyStillNull);
    }

    public void test_changeableNonVolatileAttribute_418716() {
        Bug418716 m = CompanyFactory.eINSTANCE.createBug418716();
        DelegatesTest.assertEquals((int)0, (int)m.getAttributeWithoutInitital());
        DelegatesTest.assertEquals((int)100, (int)m.getAttributeWithInitital());
        m.setAttributeWithInitital(200);
        DelegatesTest.assertEquals((int)0, (int)m.getAttributeWithoutInitital());
        DelegatesTest.assertEquals((int)200, (int)m.getAttributeWithInitital());
    }

    public void test_constraintValidation() {
        this.doTest_constraintValidation(COMPANY_XMI);
        DelegatesTest.assertEquals((!this.eclipseIsRunning ? 1 : 0) != 0, (boolean)this.usedLocalRegistry);
    }

    public void test_constraintValidation_withoutReflection() {
        this.doTest_constraintValidation(NO_REFLECTION_COMPANY_XMI);
    }

    public void test_constraintValidation_registered() {
        this.initPackageRegistrations();
        this.doTest_constraintValidation(COMPANY_XMI);
        DelegatesTest.assertFalse((boolean)this.usedLocalRegistry);
    }

    public void test_defaultIsLPG() {
        DelegatesTest.assertEquals((String)"http://www.eclipse.org/emf/2002/Ecore/OCL/LPG", (String)((String)CommonOptions.DEFAULT_DELEGATION_MODE.getPreferredValue()));
    }

    public void test_eAttributeDerivation() {
        this.doTest_eAttributeDerivation(COMPANY_XMI);
    }

    public void test_eAttributeDerivation_registered() {
        this.initPackageRegistrations();
        this.doTest_eAttributeDerivation(COMPANY_XMI);
    }

    public void test_eReferenceDerivation() {
        this.doTest_eReferenceDerivation(COMPANY_XMI);
    }

    public void test_eReferenceDerivation_registered() {
        this.initPackageRegistrations();
        this.doTest_eReferenceDerivation(COMPANY_XMI);
    }

    public void test_eReferenceDerivationUsedFromCache() throws ParserException, InvocationTargetException {
        this.initModel(COMPANY_XMI);
        EObject company = this.companyFactory.create(this.companyClass);
        EObject manager = this.companyFactory.create(this.employeeClass);
        manager.eSet(this.employeeClass.getEStructuralFeature("company"), (Object)company);
        EObject employee = this.companyFactory.create(this.employeeClass);
        employee.eSet(this.employeeClass.getEStructuralFeature("company"), (Object)company);
        employee.eSet(this.employeeClass.getEStructuralFeature("manager"), (Object)manager);
        OCL ocl = OCL.newInstance();
        OCL.Helper helper = ocl.createOCLHelper();
        helper.setContext((Object)this.employeeClass);
        OCLExpression expr = helper.createQuery("self.directReports");
        DelegatesTest.assertTrue((boolean)((Collection)ocl.evaluate((Object)manager, (org.eclipse.ocl.expressions.OCLExpression)expr)).contains(employee));
        EStructuralFeature directReportsRef = this.employeeClass.getEStructuralFeature("directReports");
        NullLiteralExp nullLiteralExp = EcoreFactory.eINSTANCE.createNullLiteralExp();
        EAnnotation directReportsAnn = OCLCommon.getDelegateAnnotation((EModelElement)directReportsRef);
        DelegatesTest.assertTrue((boolean)directReportsAnn.getDetails().containsKey((Object)"derivation"));
        String derivationExpression = (String)directReportsAnn.getDetails().get((Object)"derivation");
        try {
            directReportsAnn.getDetails().removeKey((Object)"derivation");
            SettingBehavior.INSTANCE.cacheOCLExpression(directReportsRef, (OCLExpression)nullLiteralExp);
            DelegatesTest.assertNull((Object)ocl.evaluate((Object)manager, (org.eclipse.ocl.expressions.OCLExpression)expr));
        }
        finally {
            directReportsAnn.getDetails().put((Object)"derivation", (Object)derivationExpression);
            SettingBehavior.INSTANCE.cacheOCLExpression(directReportsRef, null);
        }
    }

    public void test_hiddenOppositeInOperationDefault() throws InvocationTargetException {
        URI uri = this.getTestModelURI("/model/HiddenOpposites.ecore");
        Resource res = resourceSet.getResource(uri, true);
        res.eAdapters().add((Object)new ECrossReferenceAdapter());
        EPackage hiddenOppositesPackage = (EPackage)res.getContents().get(0);
        resourceSet.getPackageRegistry().put((Object)hiddenOppositesPackage.getNsURI(), (Object)hiddenOppositesPackage);
        EFactory hiddenOppositesFactory = hiddenOppositesPackage.getEFactoryInstance();
        EClass sup2 = (EClass)hiddenOppositesPackage.getEClassifier("Sup2");
        EClass unrelated = (EClass)hiddenOppositesPackage.getEClassifier("Unrelated");
        EObject unrelatedObj = hiddenOppositesFactory.create(unrelated);
        EObject sup2Obj = hiddenOppositesFactory.create(sup2);
        res.getContents().add((Object)unrelatedObj);
        res.getContents().add((Object)sup2Obj);
        unrelatedObj.eSet(unrelated.getEStructuralFeature("forward"), (Object)sup2Obj);
        EOperation getUnrelated = null;
        for (EOperation eo : sup2.getEOperations()) {
            if (!eo.getName().equals("getUnrelated")) continue;
            getUnrelated = eo;
            break;
        }
        DelegatesTest.assertNotNull(getUnrelated);
        Object o = sup2Obj.eInvoke(getUnrelated, null);
        DelegatesTest.assertEquals((Object)unrelatedObj, (Object)o);
    }

    public void test_hiddenOppositeInOperationDefinedToLocalEnvironmentFactory() throws InvocationTargetException {
        URI uri = this.getTestModelURI("/model/HiddenOpposites.ecore");
        Resource res = resourceSet.getResource(uri, true);
        res.eAdapters().add((Object)new ECrossReferenceAdapter());
        EPackage hiddenOppositesPackage = (EPackage)res.getContents().get(0);
        EAnnotation anno = OCLCommon.getDelegateAnnotation((EModelElement)hiddenOppositesPackage);
        anno.getDetails().put((Object)"environmentFactoryClass", (Object)(String.valueOf(((Object)((Object)this)).getClass().getName()) + "$LocalEnvironmentFactory"));
        resourceSet.getPackageRegistry().put((Object)hiddenOppositesPackage.getNsURI(), (Object)hiddenOppositesPackage);
        EFactory hiddenOppositesFactory = hiddenOppositesPackage.getEFactoryInstance();
        EClass sup2 = (EClass)hiddenOppositesPackage.getEClassifier("Sup2");
        EClass unrelated = (EClass)hiddenOppositesPackage.getEClassifier("Unrelated");
        EObject unrelatedObj = hiddenOppositesFactory.create(unrelated);
        EObject sup2Obj = hiddenOppositesFactory.create(sup2);
        res.getContents().add((Object)unrelatedObj);
        res.getContents().add((Object)sup2Obj);
        unrelatedObj.eSet(unrelated.getEStructuralFeature("forward"), (Object)sup2Obj);
        EOperation getUnrelated = null;
        for (EOperation eo : sup2.getEOperations()) {
            if (!eo.getName().equals("getUnrelated")) continue;
            getUnrelated = eo;
            break;
        }
        DelegatesTest.assertNotNull(getUnrelated);
        Object o = sup2Obj.eInvoke(getUnrelated, null);
        DelegatesTest.assertEquals((Object)unrelatedObj, (Object)o);
        DelegatesTest.assertTrue((String)"The configured local environment factory was not used", (boolean)LocalEnvironmentFactory.localEnvironmentFactoryUsed);
        DelegatesTest.assertTrue((String)"The configured local opposite end finder was not used", (boolean)LocalOppositeEndFinder.localOppositeEndFinderUsed);
    }

    public void test_invariantCacheBeingUsed() throws ParserException {
        this.initPackageRegistrations();
        this.initModel(COMPANY_XMI);
        EAnnotation annotation = OCLCommon.getDelegateAnnotation((EModelElement)this.employeeClass);
        BasicDiagnostic diagnostics = new BasicDiagnostic();
        DelegatesTest.assertTrue((String)"Expecting \"Amy\" to be a valid name", (boolean)CompanyValidator.INSTANCE.validateEmployee_mustHaveName((Employee)this.employee("Amy"), (DiagnosticChain)diagnostics, this.context));
        String constraintName = "mustHaveName";
        String mustHaveNameConstraint = (String)annotation.getDetails().get((Object)"mustHaveName");
        OCL.Helper helper = OCL.newInstance().createOCLHelper();
        helper.setContext((Object)this.employeeClass);
        OCLExpression query = helper.createQuery("false");
        try {
            annotation.getDetails().removeKey((Object)"mustHaveName");
            ValidationBehavior.INSTANCE.cacheOCLExpression((EClassifier)this.employeeClass, "mustHaveName", query);
            DelegatesTest.assertFalse((String)"Expected the always-false cached constraint to be used", (boolean)CompanyValidator.INSTANCE.validateEmployee_mustHaveName((Employee)this.employee("Amy"), (DiagnosticChain)diagnostics, this.context));
        }
        finally {
            annotation.getDetails().put((Object)"mustHaveName", (Object)mustHaveNameConstraint);
            ValidationBehavior.INSTANCE.cacheOCLExpression((EClassifier)this.employeeClass, "mustHaveName", null);
        }
    }

    public void test_invariantCachingForFirst() {
        this.initPackageRegistrations();
        this.initModel(COMPANY_XMI);
        BasicDiagnostic diagnostics = new BasicDiagnostic();
        ValidationBehavior.INSTANCE.cacheOCLExpression((EClassifier)this.employeeClass, "mustHaveName", null);
        CompanyValidator.INSTANCE.validateEmployee_mustHaveName((Employee)this.employee("Amy"), (DiagnosticChain)diagnostics, this.context);
        OCLExpression cached = ValidationBehavior.INSTANCE.getCachedOCLExpression((EClassifier)this.employeeClass, "mustHaveName");
        DelegatesTest.assertTrue((String)"Expected to find compiled expression in cache", (cached != null && !ValidationBehavior.isNoOCLDefinition((OCLExpression)cached) ? 1 : 0) != 0);
    }

    public void test_invariantCachingForSecond() {
        this.initPackageRegistrations();
        this.initModel(COMPANY_XMI);
        BasicDiagnostic diagnostics = new BasicDiagnostic();
        ValidationBehavior.INSTANCE.cacheOCLExpression((EClassifier)this.employeeClass, "mustHaveNonEmptyName", null);
        CompanyValidator.INSTANCE.validateEmployee_mustHaveNonEmptyName((Employee)this.employee("Amy"), (DiagnosticChain)diagnostics, this.context);
        OCLExpression cached = ValidationBehavior.INSTANCE.getCachedOCLExpression((EClassifier)this.employeeClass, "mustHaveNonEmptyName");
        DelegatesTest.assertTrue((String)"Expected to find compiled expression in cache", (cached != null && !ValidationBehavior.isNoOCLDefinition((OCLExpression)cached) ? 1 : 0) != 0);
    }

    public void test_invariantValidation() {
        this.doTest_invariantValidation(COMPANY_XMI, true);
        DelegatesTest.assertEquals((!this.eclipseIsRunning ? 1 : 0) != 0, (boolean)this.usedLocalRegistry);
    }

    public void test_invariantValidation_registered() {
        this.initPackageRegistrations();
        this.doTest_invariantValidation(COMPANY_XMI, true);
        DelegatesTest.assertFalse((boolean)this.usedLocalRegistry);
    }

    public void test_invariantValidation_withoutReflection() {
        this.doTest_invariantValidation(NO_REFLECTION_COMPANY_XMI, true);
    }

    public void test_invariantValidation_withoutReflection_registered() {
        this.initPackageRegistrations();
        this.doTest_invariantValidation(NO_REFLECTION_COMPANY_XMI, true);
    }

    public void test_operationDefinedWithoutBody() {
        this.initModelWithErrors();
        EObject badClassInstance = this.create(this.acme, this.companyDetritus, this.badClassClass, null);
        this.invokeWithException(badClassInstance, "operationDefinedWithoutBody", OCLMessages.MissingBodyForInvocationDelegate_ERROR_, "modelWithErrors::BadClass.operationDefinedWithoutBody");
    }

    public void test_operationDefinedWithoutBodyBody() {
        this.initModelWithErrors();
        EObject badClassInstance = this.create(this.acme, this.companyDetritus, this.badClassClass, null);
        this.invokeWithException(badClassInstance, "operationDefinedWithoutBodyBody", OCLMessages.MissingBodyForInvocationDelegate_ERROR_, "modelWithErrors::BadClass.operationDefinedWithoutBodyBody");
    }

    public void test_operationEvaluatingToInvalid() {
        this.initModelWithErrors();
        EObject badClassInstance = this.create(this.acme, this.companyDetritus, this.badClassClass, null);
        this.invokeWithException(badClassInstance, "operationEvaluatingToInvalid", OCLMessages.EvaluationResultIsInvalid_ERROR_, "modelWithErrors::BadClass.operationEvaluatingToInvalid");
    }

    public void test_operationEvaluatingToNull() {
        this.initModelWithErrors();
        EObject badClassInstance = this.create(this.acme, this.companyDetritus, this.badClassClass, null);
        EOperation operation = this.getOperation(badClassInstance.eClass(), "operationEvaluatingToNull");
        DelegatesTest.assertEquals(null, this.invoke(badClassInstance, operation, new Object[0]));
    }

    public void test_operationEvaluatingToWrongType() {
        this.initModelWithErrors();
        EObject badClassInstance = this.create(this.acme, this.companyDetritus, this.badClassClass, null);
        this.invokeWithException(badClassInstance, "operationEvaluatingToWrongType", OCLMessages.BodyConditionConformance_ERROR_, "operationEvaluatingToWrongType", "Integer", "Boolean");
    }

    public void test_operationInvocation() {
        this.doTest_operationInvocation(COMPANY_XMI);
        DelegatesTest.assertEquals((!this.eclipseIsRunning ? 1 : 0) != 0, (boolean)this.usedLocalRegistry);
    }

    public void test_operationInvocation_registered() {
        this.initPackageRegistrations();
        this.doTest_operationInvocation(COMPANY_XMI);
        DelegatesTest.assertFalse((boolean)this.usedLocalRegistry);
    }

    public void test_operationParsingToLexicalError() {
        this.initModelWithErrors();
        EObject badClassInstance = this.create(this.acme, this.companyDetritus, this.badClassClass, null);
        this.invokeWithException(badClassInstance, "operationParsingToLexicalError", OCLMessages.OCLParseErrorCodes_DELETION, "2:1:2:2", "\"@@\"");
    }

    public void test_operationParsingToSemanticError() {
        this.initModelWithErrors();
        EObject badClassInstance = this.create(this.acme, this.companyDetritus, this.badClassClass, null);
        this.invokeWithException(badClassInstance, "operationParsingToSemanticError", OCLMessages.OperationNotFound_ERROR_, "oclIsInvalid(Integer)", "Set(BadClass)");
    }

    public void test_operationParsingToSyntacticError() {
        this.initModelWithErrors();
        EObject badClassInstance = this.create(this.acme, this.companyDetritus, this.badClassClass, null);
        this.invokeWithException(badClassInstance, "operationParsingToSyntacticError", OCLMessages.OCLParseErrorCodes_DELETION, "2:5:2:6", "\"in\"");
    }

    public void test_operationDefinedInStdlibBodyRemainsNull() throws ParserException {
        this.helper.setContext((Object)EcorePackage.eINSTANCE.getEClassifier());
        OCLExpression expr = (OCLExpression)this.helper.createQuery("'abc'.oclAsType(String)");
        DelegatesTest.assertTrue((boolean)(expr instanceof OperationCallExp));
        OperationCallExp oce = (OperationCallExp)expr;
        EOperation o = (EOperation)oce.getReferredOperation();
        OCLExpression body = InvocationBehavior.INSTANCE.getOperationBody((OCL)this.ocl, o);
        DelegatesTest.assertNull((Object)body);
        OCLExpression bodyStillNull = InvocationBehavior.INSTANCE.getOperationBody((OCL)this.ocl, o);
        DelegatesTest.assertTrue((bodyStillNull == null || InvocationBehavior.isNoOCLDefinition((OCLExpression)bodyStillNull) ? 1 : 0) != 0);
    }

    public void test_operationUsedFromCache() throws ParserException, InvocationTargetException {
        this.initModel(COMPANY_XMI);
        EObject manager = this.companyFactory.create(this.employeeClass);
        EObject employee = this.companyFactory.create(this.employeeClass);
        employee.eSet(this.employeeClass.getEStructuralFeature("manager"), (Object)manager);
        this.helper.setContext((Object)this.employeeClass);
        OCLExpression expr = (OCLExpression)this.helper.createQuery("self.reportsTo(self.manager)");
        DelegatesTest.assertTrue((boolean)((Boolean)this.ocl.evaluate((Object)employee, (org.eclipse.ocl.expressions.OCLExpression)expr)));
        EOperation reportsToOp = this.employeeClass.getEOperation(0);
        BooleanLiteralExp falseLiteralExp = EcoreFactory.eINSTANCE.createBooleanLiteralExp();
        falseLiteralExp.setBooleanSymbol(Boolean.valueOf(false));
        EAnnotation reportsToAnn = OCLCommon.getDelegateAnnotation((EModelElement)reportsToOp);
        DelegatesTest.assertTrue((boolean)reportsToAnn.getDetails().containsKey((Object)"body"));
        String body = (String)reportsToAnn.getDetails().get((Object)"body");
        try {
            reportsToAnn.getDetails().removeKey((Object)"body");
            InvocationBehavior.INSTANCE.cacheOCLExpression(reportsToOp, (OCLExpression)falseLiteralExp);
            DelegatesTest.assertFalse((boolean)((Boolean)this.ocl.evaluate((Object)employee, (org.eclipse.ocl.expressions.OCLExpression)expr)));
        }
        finally {
            reportsToAnn.getDetails().put((Object)"body", (Object)body);
            InvocationBehavior.INSTANCE.cacheOCLExpression(reportsToOp, null);
        }
    }

    public void test_performanceOfCacheRetrieval() throws ParserException {
        this.initModel(COMPANY_XMI);
        EObject manager = this.companyFactory.create(this.employeeClass);
        EObject employee = this.companyFactory.create(this.employeeClass);
        employee.eSet(this.employeeClass.getEStructuralFeature("manager"), (Object)manager);
        OCL ocl = OCL.newInstance();
        OCL.Helper helper = ocl.createOCLHelper();
        helper.setContext((Object)this.employeeClass);
        String expression = "self.reportsTo(self.manager)";
        OCLExpression expr = helper.createQuery(expression);
        boolean TIMES = true;
        boolean REPEAT = true;
        int r = 0;
        while (r < 1) {
            long start = System.currentTimeMillis();
            int i = 0;
            while (i < 1) {
                ocl.evaluate((Object)employee, (org.eclipse.ocl.expressions.OCLExpression)expr);
                ++i;
            }
            long end = System.currentTimeMillis();
            DelegatesTest.debugPrintln((String)("Executing " + expression + " " + 1 + " times took " + (end - start) + "ms"));
            ++r;
        }
    }

    public void test_queryExecution() {
        this.doTest_queryExecution(COMPANY_XMI);
        DelegatesTest.assertEquals((!this.eclipseIsRunning ? 1 : 0) != 0, (boolean)this.usedLocalRegistry);
    }

    public void test_queryExecution_registered() {
        this.initPackageRegistrations();
        this.doTest_queryExecution(COMPANY_XMI);
        DelegatesTest.assertFalse((boolean)this.usedLocalRegistry);
    }

    public void test_queryExecutionWithExceptions() throws InvocationTargetException {
        this.doTest_queryExecutionWithExceptions(COMPANY_XMI);
        DelegatesTest.assertEquals((!this.eclipseIsRunning ? 1 : 0) != 0, (boolean)this.usedLocalRegistry);
    }

    public void test_queryExecutionWithExceptions_registered() throws InvocationTargetException {
        this.initPackageRegistrations();
        this.doTest_queryExecutionWithExceptions(COMPANY_XMI);
        DelegatesTest.assertFalse((boolean)this.usedLocalRegistry);
    }

    public void test_queryExecution_Bug353171() {
        QueryDelegate.Factory factory = QueryDelegate.Factory.Registry.INSTANCE.getFactory("http://www.eclipse.org/emf/2002/Ecore/OCL/LPG");
        String n = "n";
        String expression = "self.name";
        Library library = EXTLibraryFactory.eINSTANCE.createLibrary();
        library.setName("test");
        HashMap<String, EDataType> parameters = new HashMap<String, EDataType>();
        parameters.put(n, EcorePackage.Literals.ESTRING);
        QueryDelegate delegate = factory.createQueryDelegate((EClassifier)EXTLibraryPackage.Literals.LIBRARY, parameters, expression);
        HashMap<String, Object> bindings = new HashMap<String, Object>();
        bindings.put(n, "test");
        Object result = this.execute(delegate, library, bindings);
        DelegatesTest.assertEquals((Object)result, (Object)"test");
    }

    public void test_validationEvaluatingToInvalid() {
        this.initModelWithErrors();
        EObject badClassInstance = this.create(this.acme, this.companyDetritus, (EClass)this.companyPackage.getEClassifier("ValidationEvaluatingToInvalid"), null);
        String message = NLS.bind((String)OCLMessages.ValidationResultIsInvalid_ERROR_, (Object)"evaluatingToInvalid");
        this.validateWithError("evaluatingToInvalid", "_UI_ConstraintDelegateException_diagnostic", badClassInstance, "evaluatingToInvalid", EObjectValidator.getObjectLabel((EObject)badClassInstance, this.context), message, org.eclipse.ocl.ecore.delegate.OCLDelegateException.class.getName());
    }

    public void test_validationEvaluatingToNull() {
        this.initModelWithErrors();
        EObject badClassInstance = this.create(this.acme, this.companyDetritus, (EClass)this.companyPackage.getEClassifier("ValidationEvaluatingToNull"), null);
        String message = NLS.bind((String)OCLMessages.ValidationResultIsNull_ERROR_, (Object)"evaluatingToNull");
        this.validateWithError("evaluatingToNull", "_UI_ConstraintDelegateException_diagnostic", badClassInstance, "evaluatingToNull", EObjectValidator.getObjectLabel((EObject)badClassInstance, this.context), message, org.eclipse.ocl.ecore.delegate.OCLDelegateException.class.getName());
    }

    public void test_validationEvaluatingToWrongType() {
        this.initModelWithErrors();
        EObject badClassInstance = this.create(this.acme, this.companyDetritus, (EClass)this.companyPackage.getEClassifier("ValidationEvaluatingToWrongType"), null);
        String message = NLS.bind((String)OCLMessages.InvariantConstraintBoolean_ERROR_, (Object)"ValidationEvaluatingToWrongType");
        this.validateWithError("evaluatingToWrongType", "_UI_ConstraintDelegateException_diagnostic", badClassInstance, "evaluatingToWrongType", EObjectValidator.getObjectLabel((EObject)badClassInstance, this.context), message, org.eclipse.ocl.ecore.delegate.OCLDelegateException.class.getName());
    }

    public void test_validationParsingToLexicalError() {
        this.initModelWithErrors();
        EObject badClassInstance = this.create(this.acme, this.companyDetritus, (EClass)this.companyPackage.getEClassifier("ValidationParsingToLexicalError"), null);
        String message = NLS.bind((String)OCLMessages.OCLParseErrorCodes_INVALID_TOKEN, (Object)"1:4", (Object)"\"'part\"");
        this.validateWithError("parsingToLexicalError", "_UI_ConstraintDelegateException_diagnostic", badClassInstance, "parsingToLexicalError", EObjectValidator.getObjectLabel((EObject)badClassInstance, this.context), message, org.eclipse.ocl.ecore.delegate.OCLDelegateException.class.getName());
    }

    public void test_validationParsingToSemanticError() {
        this.initModelWithErrors();
        EObject badClassInstance = this.create(this.acme, this.companyDetritus, (EClass)this.companyPackage.getEClassifier("ValidationParsingToSemanticError"), null);
        String message = NLS.bind((String)OCLMessages.OperationNotFound_ERROR_, (Object)"not()", (Object)"String");
        this.validateWithError("parsingToSemanticError", "_UI_ConstraintDelegateException_diagnostic", badClassInstance, "parsingToSemanticError", EObjectValidator.getObjectLabel((EObject)badClassInstance, this.context), message, org.eclipse.ocl.ecore.delegate.OCLDelegateException.class.getName());
    }

    public void test_validationParsingToSyntacticError() {
        this.initModelWithErrors();
        EObject badClassInstance = this.create(this.acme, this.companyDetritus, (EClass)this.companyPackage.getEClassifier("ValidationParsingToSyntacticError"), null);
        String message = NLS.bind((String)OCLMessages.OCLParseErrorCodes_INVALID_TOKEN, (Object)"2:1:2:4", (Object)"\"else\"");
        this.validateWithError("parsingToSyntacticError", "_UI_ConstraintDelegateException_diagnostic", badClassInstance, "parsingToSyntacticError", EObjectValidator.getObjectLabel((EObject)badClassInstance, this.context), message, org.eclipse.ocl.ecore.delegate.OCLDelegateException.class.getName());
    }

    void add(EObject owner, EStructuralFeature feature, Object value) {
        ((EList)this.get(owner, feature)).add(value);
    }

    EList<EObject> allReports(EObject employee) {
        return (EList)this.get(employee, (EStructuralFeature)this.employeeAllReports);
    }

    EObject create(EObject owner, EReference containment, EClass type, String name) {
        EObject result = this.companyFactory.create(type);
        if (containment.isMany()) {
            this.add(owner, (EStructuralFeature)containment, result);
        } else {
            this.set(owner, (EStructuralFeature)containment, result);
        }
        if (name != null) {
            this.set(result, type.getEStructuralFeature("name"), name);
        }
        return result;
    }

    EList<EObject> directReports(EObject employee) {
        return (EList)this.get(employee, (EStructuralFeature)this.employeeDirectReports);
    }

    EObject employee(String name) {
        EObject result = this.employees.get(name);
        if (result == null) {
            EList emps = (EList)this.get(this.acme, (EStructuralFeature)this.companyEmployees);
            for (EObject next : emps) {
                if (!name.equals(this.name(next))) continue;
                result = next;
                this.employees.put(name, result);
                break;
            }
        }
        return result;
    }

    EList<EObject> employees(EObject company) {
        return (EList)this.get(company, (EStructuralFeature)this.companyEmployees);
    }

    <T> T get(EObject owner, EStructuralFeature feature) {
        return (T)owner.eGet(feature);
    }

    public EOperation getOperation(EClass eClass, String name) {
        for (EOperation eOperation : eClass.getEOperations()) {
            if (!name.equals(eOperation.getName())) continue;
            return eOperation;
        }
        DelegatesTest.fail((String)("Expected to find operation: " + name));
        return null;
    }

    public void getWithException(EObject eObject, String featureName, String messageTemplate, Object ... bindings) {
        EClass eClass = eObject.eClass();
        EAttribute eAttribute = (EAttribute)eClass.getEStructuralFeature(featureName);
        String expectedMessage = NLS.bind((String)messageTemplate, (Object[])bindings);
        try {
            Object object = this.get(eObject, (EStructuralFeature)eAttribute);
            DelegatesTest.fail((String)("Expected to catch OCLDelegateException: " + expectedMessage));
        }
        catch (OCLDelegateException e) {
            DelegatesTest.assertEquals((String)"OCLDelegateException: ", (String)expectedMessage, (String)e.getLocalizedMessage());
        }
    }

    <T> T invoke(EObject target, EOperation operation, Object ... arguments) {
        try {
            return (T)target.eInvoke(operation, (EList)(arguments.length == 0 ? ECollections.emptyEList() : new BasicEList.UnmodifiableEList(arguments.length, arguments)));
        }
        catch (InvocationTargetException ite) {
            DelegatesTest.fail((String)("Failed to invoke operation: " + ite.getLocalizedMessage()));
            return null;
        }
    }

    public void invokeWithException(EObject eObject, String name, String messageTemplate, Object ... bindings) {
        EClass eClass = eObject.eClass();
        String expectedMessage = NLS.bind((String)messageTemplate, (Object[])bindings);
        for (EOperation eOperation : eClass.getEOperations()) {
            if (!name.equals(eOperation.getName())) continue;
            try {
                Object object = this.invoke(eObject, eOperation, new Object[0]);
                DelegatesTest.fail((String)("Expected to catch OCLDelegateException: " + expectedMessage));
            }
            catch (OCLDelegateException e) {
                DelegatesTest.assertEquals((String)"OCLDelegateException: ", (String)expectedMessage, (String)e.getLocalizedMessage());
                return;
            }
        }
        DelegatesTest.fail((String)("Expected to find: " + name));
    }

    Object execute(QueryDelegate delegate, Object target, Map<String, Object> bindings) {
        try {
            return delegate.execute(target, bindings);
        }
        catch (InvocationTargetException ite) {
            DelegatesTest.fail((String)("Failed to execute query: " + ite.getCause().getLocalizedMessage()));
            return null;
        }
    }

    public void executeWithException(QueryDelegate delegate, Object target, Map<String, Object> bindings, String messageTemplate, Object ... messageBindings) {
        String expectedMessage = NLS.bind((String)messageTemplate, (Object[])messageBindings);
        try {
            Object object = delegate.execute(target, bindings);
            DelegatesTest.fail((String)("Expected to catch InvocationTargetException: " + expectedMessage));
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            DelegatesTest.assertEquals((String)(cause + ": "), (String)expectedMessage, (String)cause.getLocalizedMessage());
        }
    }

    <T> EList<T> list(T ... element) {
        return new BasicEList(Arrays.asList(element));
    }

    EObject manager(EObject employee) {
        return (EObject)this.get(employee, (EStructuralFeature)this.employeeManager);
    }

    String name(EObject employeeOrCompany) {
        EAttribute name = this.employeeClass.isInstance((Object)employeeOrCompany) ? this.employeeName : this.companyName;
        return (String)this.get(employeeOrCompany, (EStructuralFeature)name);
    }

    void set(EObject owner, EStructuralFeature feature, Object value) {
        owner.eSet(feature, value);
    }

    Enumerator size(EObject company) {
        return (Enumerator)this.get(company, (EStructuralFeature)this.companySize);
    }

    protected void validateWithoutError(EObject eObject) {
        List diagnostics;
        Diagnostic validation = Diagnostician.INSTANCE.validate(eObject, this.context);
        if (validation.getSeverity() != 0 && !(diagnostics = validation.getChildren()).isEmpty()) {
            StringBuilder s = new StringBuilder();
            for (Diagnostic diagnostic : diagnostics) {
                s.append(diagnostic.getMessage());
                s.append("\n");
            }
            DelegatesTest.fail((String)s.toString());
        }
        DelegatesTest.assertEquals((String)"Validation severity:", (int)0, (int)validation.getSeverity());
        diagnostics = validation.getChildren();
        DelegatesTest.assertEquals((String)"Validation child count:", (int)0, (int)diagnostics.size());
    }

    protected void validateConstraintWithError(String constraintName, EObject eObject) {
        Diagnostic validation = Diagnostician.INSTANCE.validate(eObject, this.context);
        DelegatesTest.assertEquals((String)("Validation of '" + constraintName + "' severity:"), (int)4, (int)validation.getSeverity());
        List diagnostics = validation.getChildren();
        DelegatesTest.assertEquals((String)("Validation of '" + constraintName + "' child count:"), (int)1, (int)diagnostics.size());
        Diagnostic diagnostic = (Diagnostic)diagnostics.get(0);
        DelegatesTest.assertEquals((String)("Validation of '" + constraintName + "' data count:"), (int)1, (int)diagnostic.getData().size());
        DelegatesTest.assertEquals((String)("Validation of '" + constraintName + "' data object:"), (Object)eObject, diagnostic.getData().get(0));
        String objectLabel = EObjectValidator.getObjectLabel((EObject)eObject, this.context);
        String messageTemplate = EcorePlugin.INSTANCE.getString("_UI_GenericConstraint_diagnostic");
        String message = NLS.bind((String)messageTemplate, (Object)constraintName, (Object)objectLabel);
        DelegatesTest.assertEquals((String)("Validation of '" + constraintName + "' message:"), (String)message, (String)diagnostic.getMessage());
    }

    protected void validateInvariantWithError(String constraintName, EObject eObject) {
        this.validateWithError(constraintName, "_UI_GenericInvariant_diagnostic", eObject, constraintName, EObjectValidator.getObjectLabel((EObject)eObject, this.context));
    }

    protected void validateWithError(String constraintName, String errorKey, EObject eObject, Object ... bindings) {
        Diagnostic validation = Diagnostician.INSTANCE.validate(eObject, this.context);
        DelegatesTest.assertEquals((String)("Validation of '" + constraintName + "' severity:"), (int)4, (int)validation.getSeverity());
        List diagnostics = validation.getChildren();
        DelegatesTest.assertEquals((String)("Validation of '" + constraintName + "' child count:"), (int)1, (int)diagnostics.size());
        Diagnostic diagnostic = (Diagnostic)diagnostics.get(0);
        List data = diagnostic.getData();
        int size = data.size();
        if (size == 2) {
            DelegatesTest.assertEquals((String)("Validation of '" + constraintName + "' exception:"), org.eclipse.ocl.ecore.delegate.OCLDelegateException.class, data.get(1).getClass());
        } else if (size != 1) {
            DelegatesTest.fail((String)("Validation of '" + constraintName + "' child count: " + size));
        }
        DelegatesTest.assertEquals((String)("Validation of '" + constraintName + "' data object:"), (Object)eObject, diagnostic.getData().get(0));
        String messageTemplate = EcorePlugin.INSTANCE.getString(errorKey);
        if (((Diagnostic)diagnostics.get(0)).getData().size() >= 2) {
            messageTemplate = messageTemplate.replaceAll("\\{2\\}", "{3}: {2}");
        }
        String message = NLS.bind((String)messageTemplate, (Object[])bindings);
        DelegatesTest.assertEquals((String)("Validation of '" + constraintName + "' message:"), (String)message, (String)diagnostic.getMessage());
    }

    public static class LocalEnvironmentFactory
    extends EcoreEnvironmentFactoryWithHiddenOpposites {
        public static boolean localEnvironmentFactoryUsed = false;

        public LocalEnvironmentFactory(EPackage.Registry registry) {
            super(registry, (OppositeEndFinder)new LocalOppositeEndFinder(registry));
            localEnvironmentFactoryUsed = true;
        }
    }

    public static class LocalOppositeEndFinder
    extends DefaultOppositeEndFinder {
        public static boolean localOppositeEndFinderUsed = false;

        public LocalOppositeEndFinder(EPackage.Registry registry) {
            super(registry);
            localOppositeEndFinderUsed = true;
        }
    }
}

