/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.ecore.tests;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import junit.framework.AssertionFailedError;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EClassImpl;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.OCLInput;
import org.eclipse.ocl.ecore.BagType;
import org.eclipse.ocl.ecore.CollectionType;
import org.eclipse.ocl.ecore.EcoreEnvironment;
import org.eclipse.ocl.ecore.EcoreEnvironmentFactory;
import org.eclipse.ocl.ecore.OCL;
import org.eclipse.ocl.ecore.OrderedSetType;
import org.eclipse.ocl.ecore.SequenceType;
import org.eclipse.ocl.ecore.SetType;
import org.eclipse.ocl.ecore.TupleType;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.ecore.tests.AbstractTestSuite;
import org.eclipse.ocl.expressions.BooleanLiteralExp;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.ocl.expressions.LetExp;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.OperationCallExp;
import org.eclipse.ocl.expressions.VariableExp;
import org.eclipse.ocl.util.Bag;
import org.eclipse.ocl.util.CollectionUtil;
import org.eclipse.ocl.util.Tuple;
import org.eclipse.ocl.util.TypeUtil;

public class RegressionTest
extends AbstractTestSuite {
    public void test_quoteReservedWords_RATLC00527506() {
        EPackage epackage = EcoreFactory.eINSTANCE.createEPackage();
        epackage.setName("MyPackage");
        epackage.setNsPrefix("mypkg");
        epackage.setNsURI("http:///mypkg.ecore");
        resourceSet.getPackageRegistry().put((Object)epackage.getNsURI(), (Object)epackage);
        EClass eclass = EcoreFactory.eINSTANCE.createEClass();
        eclass.setName("MyType");
        epackage.getEClassifiers().add((Object)eclass);
        EAttribute eattr = EcoreFactory.eINSTANCE.createEAttribute();
        eattr.setName("context");
        eattr.setEType((EClassifier)EcorePackage.eINSTANCE.getEString());
        eclass.getEStructuralFeatures().add((Object)eattr);
        this.parseConstraint("package mypkg context MyType inv: self.\"context\"->notEmpty() endpackage");
    }

    public void test_quoteWhitespace_RATLC00527509() {
        EPackage epackage = EcoreFactory.eINSTANCE.createEPackage();
        epackage.setName("MyPackage");
        epackage.setNsPrefix("mypkg");
        epackage.setNsURI("http:///mypkg.ecore");
        resourceSet.getPackageRegistry().put((Object)epackage.getNsURI(), (Object)epackage);
        EClass eclass = EcoreFactory.eINSTANCE.createEClass();
        eclass.setName("MyType");
        epackage.getEClassifiers().add((Object)eclass);
        EAttribute eattr = EcoreFactory.eINSTANCE.createEAttribute();
        eattr.setName("an attribute");
        eattr.setEType((EClassifier)EcorePackage.eINSTANCE.getEString());
        eclass.getEStructuralFeatures().add((Object)eattr);
        this.parseConstraint("package mypkg context MyType inv: self.\"an attribute\"->notEmpty() endpackage");
    }

    public void test_quoteQuote_RATLC00527509() {
        EPackage epackage = EcoreFactory.eINSTANCE.createEPackage();
        epackage.setName("MyPackage");
        epackage.setNsPrefix("mypkg");
        epackage.setNsURI("http:///mypkg.ecore");
        resourceSet.getPackageRegistry().put((Object)epackage.getNsURI(), (Object)epackage);
        EClass eclass = EcoreFactory.eINSTANCE.createEClass();
        eclass.setName("MyType");
        epackage.getEClassifiers().add((Object)eclass);
        EAttribute eattr = EcoreFactory.eINSTANCE.createEAttribute();
        eattr.setName("an\"attribute");
        eattr.setEType((EClassifier)EcorePackage.eINSTANCE.getEString());
        eclass.getEStructuralFeatures().add((Object)eattr);
        this.parseConstraint("package mypkg context MyType inv: self.\"an\\\"attribute\"->notEmpty() endpackage");
        AssertionFailedError err = null;
        try {
            this.parseConstraint("package ecore context EClass inv: self.an\\\"attribute->notEmpty() endpackage");
        }
        catch (AssertionFailedError e) {
            err = e;
            RegressionTest.debugPrintln((String)("Got expected error: " + e.getLocalizedMessage()));
        }
        RegressionTest.assertNotNull((String)"Should not have parsed.", (Object)((Object)err));
    }

    public void test_internationalCharacters_RATLC01080816() {
        EPackage epackage = EcoreFactory.eINSTANCE.createEPackage();
        epackage.setName("MyPackage");
        epackage.setNsPrefix("mypkg");
        epackage.setNsURI("http:///mypkg.ecore");
        resourceSet.getPackageRegistry().put((Object)epackage.getNsURI(), (Object)epackage);
        EClass eclass = EcoreFactory.eINSTANCE.createEClass();
        eclass.setName("MyType");
        epackage.getEClassifiers().add((Object)eclass);
        EAttribute eattr = EcoreFactory.eINSTANCE.createEAttribute();
        eattr.setName("\u0160\u01d6\u0429\u0639");
        eattr.setEType((EClassifier)EcorePackage.eINSTANCE.getEString());
        eclass.getEStructuralFeatures().add((Object)eattr);
        this.parseConstraint("package mypkg context MyType inv: self.\u0160\u01d6\u0429\u0639 <> '\u0160\u01d6\u0429\u0639' endpackage");
    }

    public void test_oclIsKindOf_RATLC01087664() {
        EPackage epackage = EcoreFactory.eINSTANCE.createEPackage();
        epackage.setName("MyPackage");
        epackage.setNsPrefix("mypkg");
        epackage.setNsURI("http:///mypkg.ecore");
        resourceSet.getPackageRegistry().put((Object)epackage.getNsURI(), (Object)epackage);
        EClass a = EcoreFactory.eINSTANCE.createEClass();
        a.setName("A");
        epackage.getEClassifiers().add((Object)a);
        EClass b = EcoreFactory.eINSTANCE.createEClass();
        b.setName("B");
        epackage.getEClassifiers().add((Object)b);
        EClass c = EcoreFactory.eINSTANCE.createEClass();
        c.setName("C");
        epackage.getEClassifiers().add((Object)c);
        c.getESuperTypes().add((Object)a);
        c.getESuperTypes().add((Object)b);
        EAttribute attrA = EcoreFactory.eINSTANCE.createEAttribute();
        attrA.setName("a");
        attrA.setEType((EClassifier)EcorePackage.eINSTANCE.getEBoolean());
        a.getEStructuralFeatures().add((Object)attrA);
        EAttribute attrB = EcoreFactory.eINSTANCE.createEAttribute();
        attrB.setName("b");
        attrB.setEType((EClassifier)EcorePackage.eINSTANCE.getEBoolean());
        b.getEStructuralFeatures().add((Object)attrB);
        OCLExpression constraint = this.parseConstraint("package mypkg context A inv: self.oclIsKindOf(B) implies (self.oclAsType(B).b <> self.a) endpackage");
        EObject eobj = epackage.getEFactoryInstance().create(c);
        eobj.eSet((EStructuralFeature)attrA, (Object)Boolean.TRUE);
        eobj.eSet((EStructuralFeature)attrB, (Object)Boolean.TRUE);
        RegressionTest.assertFalse((String)"Should have failed the check", (boolean)this.check(constraint, eobj));
        eobj.eSet((EStructuralFeature)attrB, (Object)Boolean.FALSE);
        RegressionTest.assertTrue((String)"Should not have failed the check", (boolean)this.check(constraint, eobj));
    }

    public void test_shortcircuitAnd_RATLC00536528() {
        EPackage epackage = EcoreFactory.eINSTANCE.createEPackage();
        epackage.setName("MyPackage");
        epackage.setNsPrefix("mypkg");
        epackage.setNsURI("http:///mypkg.ecore");
        resourceSet.getPackageRegistry().put((Object)epackage.getNsURI(), (Object)epackage);
        EClass a = EcoreFactory.eINSTANCE.createEClass();
        a.setName("A");
        epackage.getEClassifiers().add((Object)a);
        EClass b = EcoreFactory.eINSTANCE.createEClass();
        b.setName("B");
        epackage.getEClassifiers().add((Object)b);
        b.getESuperTypes().add((Object)a);
        EAttribute attrA = EcoreFactory.eINSTANCE.createEAttribute();
        attrA.setName("a");
        attrA.setEType((EClassifier)EcorePackage.eINSTANCE.getEBoolean());
        a.getEStructuralFeatures().add((Object)attrA);
        EAttribute attrB = EcoreFactory.eINSTANCE.createEAttribute();
        attrB.setName("b");
        attrB.setEType((EClassifier)EcorePackage.eINSTANCE.getEBoolean());
        b.getEStructuralFeatures().add((Object)attrB);
        try {
            OCLExpression constraint = this.parseConstraint("package mypkg context A inv: self.oclIsKindOf(B) and self.oclAsType(B).b endpackage");
            EObject eobj = epackage.getEFactoryInstance().create(a);
            eobj.eSet((EStructuralFeature)attrA, (Object)Boolean.TRUE);
            RegressionTest.assertFalse((String)"Should have failed the check", (boolean)this.check(constraint, eobj));
            eobj = epackage.getEFactoryInstance().create(b);
            eobj.eSet((EStructuralFeature)attrA, (Object)Boolean.TRUE);
            eobj.eSet((EStructuralFeature)attrB, (Object)Boolean.TRUE);
            RegressionTest.assertTrue((String)"Should not have failed the check", (boolean)this.check(constraint, eobj));
        }
        catch (Exception e) {
            RegressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_shortcircuitOr_RATLC00536528() {
        EPackage epackage = EcoreFactory.eINSTANCE.createEPackage();
        epackage.setName("MyPackage");
        epackage.setNsPrefix("mypkg");
        epackage.setNsURI("http:///mypkg.ecore");
        resourceSet.getPackageRegistry().put((Object)epackage.getNsURI(), (Object)epackage);
        EClass a = EcoreFactory.eINSTANCE.createEClass();
        a.setName("A");
        epackage.getEClassifiers().add((Object)a);
        EClass b = EcoreFactory.eINSTANCE.createEClass();
        b.setName("B");
        epackage.getEClassifiers().add((Object)b);
        b.getESuperTypes().add((Object)a);
        EAttribute attrA = EcoreFactory.eINSTANCE.createEAttribute();
        attrA.setName("a");
        attrA.setEType((EClassifier)EcorePackage.eINSTANCE.getEBoolean());
        a.getEStructuralFeatures().add((Object)attrA);
        EAttribute attrB = EcoreFactory.eINSTANCE.createEAttribute();
        attrB.setName("b");
        attrB.setEType((EClassifier)EcorePackage.eINSTANCE.getEBoolean());
        b.getEStructuralFeatures().add((Object)attrB);
        try {
            OCLExpression constraint = this.parseConstraint("package mypkg context A inv: (not self.oclIsKindOf(B)) or self.oclAsType(B).b endpackage");
            EObject eobj = epackage.getEFactoryInstance().create(a);
            eobj.eSet((EStructuralFeature)attrA, (Object)Boolean.TRUE);
            RegressionTest.assertTrue((String)"Should not have failed the check", (boolean)this.check(constraint, eobj));
            eobj = epackage.getEFactoryInstance().create(b);
            eobj.eSet((EStructuralFeature)attrA, (Object)Boolean.TRUE);
            eobj.eSet((EStructuralFeature)attrB, (Object)Boolean.TRUE);
            RegressionTest.assertTrue((String)"Should not have failed the check", (boolean)this.check(constraint, eobj));
        }
        catch (Exception e) {
            RegressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_shortcircuitImplies_RATLC00536528() {
        EPackage epackage = EcoreFactory.eINSTANCE.createEPackage();
        epackage.setName("MyPackage");
        epackage.setNsPrefix("mypkg");
        epackage.setNsURI("http:///mypkg.ecore");
        resourceSet.getPackageRegistry().put((Object)epackage.getNsURI(), (Object)epackage);
        EClass a = EcoreFactory.eINSTANCE.createEClass();
        a.setName("A");
        epackage.getEClassifiers().add((Object)a);
        EClass b = EcoreFactory.eINSTANCE.createEClass();
        b.setName("B");
        epackage.getEClassifiers().add((Object)b);
        b.getESuperTypes().add((Object)a);
        EAttribute attrA = EcoreFactory.eINSTANCE.createEAttribute();
        attrA.setName("a");
        attrA.setEType((EClassifier)EcorePackage.eINSTANCE.getEBoolean());
        a.getEStructuralFeatures().add((Object)attrA);
        EAttribute attrB = EcoreFactory.eINSTANCE.createEAttribute();
        attrB.setName("b");
        attrB.setEType((EClassifier)EcorePackage.eINSTANCE.getEBoolean());
        b.getEStructuralFeatures().add((Object)attrB);
        try {
            OCLExpression constraint = this.parseConstraint("package mypkg context A inv: self.oclIsKindOf(B) implies self.oclAsType(B).b endpackage ");
            EObject eobj = epackage.getEFactoryInstance().create(a);
            eobj.eSet((EStructuralFeature)attrA, (Object)Boolean.TRUE);
            RegressionTest.assertTrue((String)"Should not have failed the check", (boolean)this.check(constraint, eobj));
            eobj = epackage.getEFactoryInstance().create(b);
            eobj.eSet((EStructuralFeature)attrA, (Object)Boolean.TRUE);
            eobj.eSet((EStructuralFeature)attrB, (Object)Boolean.FALSE);
            RegressionTest.assertFalse((String)"Should have failed the check", (boolean)this.check(constraint, eobj));
        }
        catch (Exception e) {
            RegressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_oclIsNew_invariant_RATLC00529981() {
        OCLExpression constraint = this.parseConstraintUnvalidated("package ocltest context Fruit inv: color.oclIsNew() endpackage");
        AssertionFailedError err = null;
        try {
            this.validate(constraint);
        }
        catch (AssertionFailedError e) {
            err = e;
            RegressionTest.debugPrintln((String)("Got expected error: " + e.getLocalizedMessage()));
        }
        RegressionTest.assertNotNull((String)"Should not have succeeded in validating illegal oclIsNew", (Object)((Object)err));
    }

    public void test_oclIsNew_precondition_RATLC00529981() {
        OCLExpression constraint = this.parseConstraintUnvalidated("package ocltest context Fruit::ripen(c : Color) : Boolean pre: c.oclIsNew() implies c <> Color::black endpackage");
        AssertionFailedError err = null;
        try {
            this.validate(constraint);
        }
        catch (AssertionFailedError e) {
            err = e;
            RegressionTest.debugPrintln((String)("Got expected error: " + e.getLocalizedMessage()));
        }
        RegressionTest.assertNotNull((String)"Should not have succeeded in validating illegal oclIsNew", (Object)((Object)err));
    }

    public void test_oclIsNew_postcondition_RATLC00529981() {
        this.parseConstraint("package ocltest context Fruit::ripen(c : Color) : Boolean post: color.oclIsNew() implies color <> Color::black endpackage");
    }

    public void test_toLower_RATLC00529981() {
        OCLExpression expr = this.parse("package ocltest context Fruit inv: 'AlPHaBet'.toLower() endpackage");
        Object value = this.evaluate(expr);
        RegressionTest.assertEquals((Object)"alphabet", (Object)value);
    }

    public void test_toUpper_RATLC00529981() {
        OCLExpression expr = this.parse("package ocltest context Fruit inv: 'AlPHaBet'.toUpper() endpackage");
        Object value = this.evaluate(expr);
        RegressionTest.assertEquals((Object)"ALPHABET", (Object)value);
    }

    public void test_referenceMultiplicity_orderedSet_RATLC00538035() {
        OCLExpression expr = this.parse("package ocltest context FruitUtil inv: self.orderedSet endpackage");
        RegressionTest.assertTrue((String)"Not an ordered set type", (boolean)(expr.getType() instanceof OrderedSetType));
    }

    public void test_referenceMultiplicity_set_RATLC00538035() {
        OCLExpression expr = this.parse("package ocltest context FruitUtil inv: self.set endpackage");
        RegressionTest.assertTrue((String)"Not a set type", (expr.getType() instanceof SetType && !(expr.getType() instanceof OrderedSetType) ? 1 : 0) != 0);
    }

    public void test_referenceMultiplicity_sequence_RATLC00538035() {
        OCLExpression expr = this.parse("package ocltest context FruitUtil inv: self.sequence endpackage");
        RegressionTest.assertTrue((String)"Not a sequence type", (boolean)(expr.getType() instanceof SequenceType));
    }

    public void test_referenceMultiplicity_bag_RATLC00538035() {
        OCLExpression expr = this.parse("package ocltest context FruitUtil inv: self.bag endpackage");
        RegressionTest.assertTrue((String)"Not a bag type", (boolean)(expr.getType() instanceof BagType));
    }

    public void test_parameterMultiplicity_orderedSet_RATLC00538035() {
        OCLExpression expr = this.parse("package ocltest context FruitUtil inv: self.processOrderedSet(self.orderedSet) endpackage");
        RegressionTest.assertTrue((String)"Not an ordered set type", (boolean)(expr.getType() instanceof OrderedSetType));
    }

    public void test_parameterMultiplicity_set_RATLC00538035() {
        OCLExpression expr = this.parse("package ocltest context FruitUtil inv: self.processSet(self.set) endpackage");
        RegressionTest.assertTrue((String)"Not a set type", (expr.getType() instanceof SetType && !(expr.getType() instanceof OrderedSetType) ? 1 : 0) != 0);
    }

    public void test_parameterMultiplicity_sequence_RATLC00538035() {
        OCLExpression expr = this.parse("package ocltest context FruitUtil inv: self.processSequence(self.sequence) endpackage");
        RegressionTest.assertTrue((String)"Not a sequence type", (boolean)(expr.getType() instanceof SequenceType));
    }

    public void test_parameterMultiplicity_bag_RATLC00538035() {
        OCLExpression expr = this.parse("package ocltest context FruitUtil inv: self.processBag(self.bag) endpackage");
        RegressionTest.assertTrue((String)"Not a bag type", (boolean)(expr.getType() instanceof BagType));
    }

    public void test_operationMultiplicity_orderedSet_RATLC00538035() {
        OCLExpression expr = this.parse("package ocltest context FruitUtil inv: self.processOrderedSet(self.processOrderedSet(self.orderedSet)) endpackage");
        RegressionTest.assertTrue((String)"Not an ordered set type", (boolean)(expr.getType() instanceof OrderedSetType));
    }

    public void test_operationMultiplicity_set_RATLC00538035() {
        OCLExpression expr = this.parse("package ocltest context FruitUtil inv: self.processSet(self.processSet(self.set)) endpackage");
        RegressionTest.assertTrue((String)"Not a set type", (expr.getType() instanceof SetType && !(expr.getType() instanceof OrderedSetType) ? 1 : 0) != 0);
    }

    public void test_operationMultiplicity_sequence_RATLC00538035() {
        OCLExpression expr = this.parse("package ocltest context FruitUtil inv: self.processSequence(self.processSequence(self.sequence)) endpackage");
        RegressionTest.assertTrue((String)"Not a sequence type", (boolean)(expr.getType() instanceof SequenceType));
    }

    public void test_operationMultiplicity_bag_RATLC00538035() {
        OCLExpression expr = this.parse("package ocltest context FruitUtil inv: self.processBag(self.processBag(self.bag)) endpackage");
        RegressionTest.assertTrue((String)"Not a bag type", (boolean)(expr.getType() instanceof BagType));
    }

    public void test_operationContext_orderedSet_RATLC00538035() {
        AssertionFailedError err = null;
        try {
            this.parse("package ocltest context FruitUtil::processOrderedSet(x : Fruit) : Fruit body: result = x endpackage");
        }
        catch (AssertionFailedError e) {
            err = e;
            RegressionTest.debugPrintln((String)("Got expected error: " + e.getLocalizedMessage()));
        }
        RegressionTest.assertNotNull((String)"Parse should have failed", (Object)((Object)err));
        this.parse("package ocltest context FruitUtil::processOrderedSet(x : OrderedSet(Fruit)) : OrderedSet(Fruit) body: result = x endpackage");
    }

    public void test_operationContext_set_RATLC00538035() {
        AssertionFailedError err = null;
        try {
            this.parse("package ocltest context FruitUtil::processSet(x : Fruit) : Fruit body: result = x endpackage");
        }
        catch (AssertionFailedError e) {
            err = e;
            RegressionTest.debugPrintln((String)("Got expected error: " + e.getLocalizedMessage()));
        }
        RegressionTest.assertNotNull((String)"Parse should have failed", (Object)((Object)err));
        this.parse("package ocltest context FruitUtil::processSet(x : Set(Fruit)) : Set(Fruit) body: result = x endpackage");
    }

    public void test_operationContext_sequence_RATLC00538035() {
        AssertionFailedError err = null;
        try {
            this.parse("package ocltest context FruitUtil::processSequence(x : Fruit) : Fruit body: result = x endpackage");
        }
        catch (AssertionFailedError e) {
            err = e;
            RegressionTest.debugPrintln((String)("Got expected error: " + e.getLocalizedMessage()));
        }
        RegressionTest.assertNotNull((String)"Parse should have failed", (Object)((Object)err));
        this.parse("package ocltest context FruitUtil::processSequence(x : Sequence(Fruit)) : Sequence(Fruit) body: result = x endpackage");
    }

    public void test_operationContext_bag_RATLC00538035() {
        AssertionFailedError err = null;
        try {
            this.parse("package ocltest context FruitUtil::processBag(x : Fruit) : Fruit body: result = x endpackage");
        }
        catch (AssertionFailedError e) {
            err = e;
            RegressionTest.debugPrintln((String)("Got expected error: " + e.getLocalizedMessage()));
        }
        RegressionTest.assertNotNull((String)"Parse should have failed", (Object)((Object)err));
        this.parse("package ocltest context FruitUtil::processBag(x : Bag(Fruit)) : Bag(Fruit) body: result = x endpackage");
    }

    public void test_allInstances_enumeration_RATLC00538079() {
        Object result = this.evaluate(this.parse("package ocltest context Fruit inv: Color.allInstances()  endpackage"));
        HashSet expected = new HashSet(this.color.getELiterals());
        RegressionTest.assertEquals(expected, (Object)result);
    }

    public void test_allInstances_voidType_RATLC00538079() {
        Object result = this.evaluate(this.parse("package ocltest context Fruit inv: OclVoid.allInstances()  endpackage"));
        HashSet<Object> expected = new HashSet<Object>();
        expected.add(null);
        RegressionTest.assertEquals(expected, (Object)result);
    }

    public void test_bagIterationWithNullOccurrences() {
        Bag bag = CollectionUtil.createNewBag();
        bag.add((Object)3);
        bag.add(null);
        bag.add((Object)4);
        bag.add(null);
        bag.add((Object)"test");
        RegressionTest.assertEquals((int)2, (int)bag.count(null));
        Iterator i = bag.iterator();
        int nullCount = 0;
        while (i.hasNext()) {
            if (i.next() != null) continue;
            ++nullCount;
        }
        RegressionTest.assertEquals((int)2, (int)nullCount);
        Bag bagWithSingleNull = CollectionUtil.createNewBag();
        bagWithSingleNull.add(null);
        RegressionTest.assertEquals((int)1, (int)bagWithSingleNull.count(null));
        RegressionTest.assertTrue((boolean)bagWithSingleNull.iterator().hasNext());
        RegressionTest.assertNull(bagWithSingleNull.iterator().next());
        i = bagWithSingleNull.iterator();
        i.next();
        RegressionTest.assertFalse((boolean)i.hasNext());
    }

    public void test_allInstances_primitive_RATLC00538079() {
        Object result = this.evaluate(this.parse("package ocltest context Fruit inv: ecore::EMap.allInstances()  endpackage"));
        RegressionTest.assertEquals((Object)Collections.EMPTY_SET, (Object)result);
    }

    public void test_closingParentheses_core() {
        AssertionFailedError err = null;
        try {
            this.parse("package ocltest context Fruit inv: self)garbage  endpackage");
        }
        catch (AssertionFailedError e) {
            err = e;
            RegressionTest.debugPrintln((String)("Got expected error: " + e.getLocalizedMessage()));
        }
        RegressionTest.assertNotNull((String)"Parse should have failed", (Object)((Object)err));
    }

    public void test_closingParentheses_helper() {
        this.helper.setContext((Object)this.fruit);
        try {
            this.helper.createInvariant("self)garbage");
            RegressionTest.fail((String)"Parse should have failed");
        }
        catch (Exception e) {
            RegressionTest.debugPrintln((String)("Got expected error: " + e.getLocalizedMessage()));
        }
    }

    public void test_closingParentheses_helper_precondition() {
        this.helper.setOperationContext((Object)this.fruit, (Object)this.fruit_ripen);
        try {
            this.helper.createPrecondition("self)garbage");
            RegressionTest.fail((String)"Parse should have failed");
        }
        catch (Exception e) {
            RegressionTest.debugPrintln((String)("Got expected error: " + e.getLocalizedMessage()));
        }
    }

    public void test_operationBodyBoolean_116251() {
        AssertionFailedError err = null;
        this.parseConstraint("package ocltest context FruitUtil::processBag(x : Bag(Fruit)) : Bag(Fruit) body: result = x->asSet()->asBag() endpackage");
        this.parseConstraint("package ocltest context FruitUtil::processBag(x : Bag(Fruit)) : Bag(Fruit) body: x->asSet()->asBag() = result endpackage");
        this.parseConstraint("package ocltest context FruitUtil::processBag(x : Bag(Fruit)) : Bag(Fruit) body: let set : Set(Fruit) = x->asSet() in let bag : Bag(Fruit) = set->asBag() in result = bag endpackage");
        err = null;
        try {
            this.parseConstraint("package ocltest context FruitUtil::processBag(x : Bag(Fruit)) : Bag(Fruit) body: result = result->asSet()->union(x)->asBag() endpackage");
        }
        catch (AssertionFailedError e) {
            err = e;
            RegressionTest.debugPrintln((String)("Got expected error: " + e.getLocalizedMessage()));
        }
        RegressionTest.assertNotNull((String)"Parse should have failed", (Object)((Object)err));
    }

    public void test_ifWithNullConditionMustBeInvalid_342644() {
        EObject apple = this.fruitFactory.create(this.apple);
        Object result = this.evaluate(this.parse("package ocltest context Fruit inv: let b:Boolean=null in (if b then 1 else 2 endif).oclIsInvalid() endpackage"), apple);
        RegressionTest.assertEquals((Object)Boolean.TRUE, (Object)result);
    }

    public void test_innerScopeFeatureResolution_bugzilla113355() {
        EPackage epackage = EcoreFactory.eINSTANCE.createEPackage();
        epackage.setName("MyPackage");
        epackage.setNsPrefix("mypkg");
        epackage.setNsURI("http:///mypkg.ecore");
        resourceSet.getPackageRegistry().put((Object)epackage.getNsURI(), (Object)epackage);
        EClass libraryClass = EcoreFactory.eINSTANCE.createEClass();
        libraryClass.setName("Library");
        epackage.getEClassifiers().add((Object)libraryClass);
        EClass writerClass = EcoreFactory.eINSTANCE.createEClass();
        writerClass.setName("Writer");
        epackage.getEClassifiers().add((Object)writerClass);
        EReference branchesRef = EcoreFactory.eINSTANCE.createEReference();
        branchesRef.setUpperBound(-1);
        branchesRef.setName("branches");
        branchesRef.setEType((EClassifier)libraryClass);
        EReference writersRef = EcoreFactory.eINSTANCE.createEReference();
        writersRef.setUpperBound(-1);
        writersRef.setName("writers");
        writersRef.setEType((EClassifier)writerClass);
        EAttribute writerName = EcoreFactory.eINSTANCE.createEAttribute();
        writerName.setName("name");
        writerName.setEType((EClassifier)EcorePackage.eINSTANCE.getEString());
        libraryClass.getEStructuralFeatures().add((Object)branchesRef);
        libraryClass.getEStructuralFeatures().add((Object)writersRef);
        writerClass.getEStructuralFeatures().add((Object)writerName);
        EFactory efactory = epackage.getEFactoryInstance();
        EObject library1 = efactory.create(libraryClass);
        EObject library2 = efactory.create(libraryClass);
        EObject writer1 = efactory.create(writerClass);
        EObject writer2 = efactory.create(writerClass);
        writer1.eSet((EStructuralFeature)writerName, (Object)"Joe");
        writer2.eSet((EStructuralFeature)writerName, (Object)"Jane");
        BasicEList branches = new BasicEList();
        branches.add((Object)library2);
        BasicEList writers = new BasicEList();
        writers.add((Object)writer1);
        writers.add((Object)writer2);
        library1.eSet((EStructuralFeature)branchesRef, (Object)branches);
        library2.eSet((EStructuralFeature)writersRef, (Object)writers);
        try {
            OCLExpression expr = this.parse("package mypkg context Library inv: branches->collect(writers->collect(w : Writer | w))->flatten()endpackage");
            List result = (List)this.evaluate(expr, library1);
            RegressionTest.assertTrue((result.size() == 2 ? 1 : 0) != 0);
            RegressionTest.assertTrue((boolean)((EObject)result.get(0)).eGet((EStructuralFeature)writerName).equals("Joe"));
            RegressionTest.assertTrue((boolean)((EObject)result.get(1)).eGet((EStructuralFeature)writerName).equals("Jane"));
        }
        catch (Exception e) {
            RegressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_product_126336() {
        this.helper.setContext((Object)EcorePackage.Literals.ESTRING);
        Set product = null;
        try {
            Set evalResult;
            OCLExpression expr = this.helper.createQuery("Set{'foo', 'bar'}->product(Sequence{1, 2, 3})");
            EClassifier resultType = (EClassifier)expr.getType();
            RegressionTest.assertTrue((boolean)(resultType instanceof CollectionType));
            EClassifier elementType = (EClassifier)((CollectionType)resultType).getElementType();
            RegressionTest.assertTrue((boolean)(elementType instanceof TupleType));
            TupleType tupleType = (TupleType)elementType;
            RegressionTest.assertEquals((int)2, (int)tupleType.getEAttributes().size());
            product = evalResult = (Set)this.ocl.evaluate((Object)"", expr);
        }
        catch (Exception e) {
            RegressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
        RegressionTest.assertNotNull(product);
        RegressionTest.assertEquals((int)6, (int)product.size());
        HashMap expectedTuples = new HashMap();
        Set values = new HashSet<Integer>();
        values.add(1);
        values.add(2);
        values.add(3);
        expectedTuples.put("foo", new HashSet(values));
        expectedTuples.put("bar", new HashSet(values));
        for (Tuple tuple : product) {
            values = (Set)expectedTuples.get(tuple.getValue("first"));
            RegressionTest.assertNotNull(values);
            RegressionTest.assertTrue((boolean)values.remove(tuple.getValue("second")));
        }
    }

    public void test_iterationToString_126454() {
        EPackage fakePkg = EcoreFactory.eINSTANCE.createEPackage();
        fakePkg.setName("fake");
        EClass fake = EcoreFactory.eINSTANCE.createEClass();
        fake.setName("Fake");
        fakePkg.getEClassifiers().add((Object)fake);
        EAttribute eattr = EcoreFactory.eINSTANCE.createEAttribute();
        eattr.setName("e");
        eattr.setEType((EClassifier)EcorePackage.Literals.EINT);
        eattr.setUpperBound(1);
        fake.getEStructuralFeatures().add((Object)eattr);
        EObject aFake = fakePkg.getEFactoryInstance().create(fake);
        aFake.eSet((EStructuralFeature)eattr, (Object)new Integer(7));
        this.helper.setContext((Object)fake);
        try {
            OCLExpression expr = this.helper.createQuery("self.e->sum()");
            String toStringResult = expr.toString();
            expr = this.helper.createQuery(toStringResult);
            RegressionTest.assertEquals((Object)aFake.eGet((EStructuralFeature)eattr), (Object)this.ocl.evaluate((Object)aFake, expr));
        }
        catch (Exception exc) {
            RegressionTest.fail((String)("Failed to parse or evaluate: " + exc.getLocalizedMessage()));
        }
    }

    public void test_null() {
        Object result = this.evaluate(this.parse("package ocltest context Fruit inv: null.oclIsTypeOf(OclVoid)  endpackage"));
        RegressionTest.assertEquals((Object)Boolean.TRUE, (Object)result);
        result = this.evaluate(this.parse("package ocltest context Fruit inv: null.oclIsUndefined()  endpackage"));
        RegressionTest.assertEquals((Object)Boolean.TRUE, (Object)result);
        result = this.evaluate(this.parse("package ocltest context Fruit inv: null.oclIsInvalid()  endpackage"));
        RegressionTest.assertEquals((Object)Boolean.FALSE, (Object)result);
        result = this.evaluate(this.parse("package ocltest context Fruit inv: null.oclAsType(Integer)  endpackage"));
        RegressionTest.assertNull((Object)result);
    }

    public void test_oclInvalid() {
        Object result = this.evaluate(this.parse("package ocltest context Fruit inv: invalid.oclIsTypeOf(OclInvalid)  endpackage"));
        RegressionTest.assertEquals((Object)Boolean.TRUE, (Object)result);
        result = this.evaluate(this.parse("package ocltest context Fruit inv: invalid.oclIsUndefined()  endpackage"));
        RegressionTest.assertEquals((Object)Boolean.TRUE, (Object)result);
        result = this.evaluate(this.parse("package ocltest context Fruit inv: invalid.oclIsInvalid()  endpackage"));
        RegressionTest.assertEquals((Object)Boolean.TRUE, (Object)result);
        result = this.evaluate(this.parse("package ocltest context Fruit inv: invalid.oclAsType(Integer)  endpackage"));
        this.assertInvalid(result);
        result = this.evaluate(this.parse("package ocltest context Fruit inv: null.oclAsType(Apple).color  endpackage"));
        this.assertInvalid(result);
        result = this.evaluate(this.parse("package ocltest context Fruit inv: null.oclAsType(Apple).stem  endpackage"));
        this.assertInvalid(result);
        result = this.evaluate(this.parse("package ocltest context Fruit inv: null.oclAsType(Apple).preferredLabel('foo')  endpackage"));
        this.assertInvalid(result);
    }

    public void test_oclInvalidInIterateAccumulator_342644() {
        EObject apple = this.fruitFactory.create(this.apple);
        Object result = this.evaluate(this.parse("package ocltest context Fruit inv: self->iterate(i; acc:Integer='123a'.toInteger() | if acc.oclIsInvalid() then 0 else acc+1 endif) endpackage"), apple);
        RegressionTest.assertEquals((Object)0, (Object)result);
    }

    public void test_oclIsInvalidOnInvalidLetVariable_342644() {
        Object result = this.evaluate(this.parse("package ocltest context Fruit inv: let a:Integer = '123a'.toInteger() in a.oclIsInvalid()  endpackage"));
        RegressionTest.assertEquals((Object)Boolean.TRUE, (Object)result);
    }

    public void test_oclIsInvalidOnInvalidOperationResult_342561() {
        Object result = this.evaluate(this.parse("package ocltest context Fruit inv: '123a'.toInteger().oclIsInvalid()  endpackage"));
        RegressionTest.assertEquals((Object)Boolean.TRUE, (Object)result);
    }

    public void test_operationNotFound() {
        AssertionFailedError err = null;
        try {
            this.parseUnvalidated("package ocltest context FruitUtil inv: self.processOrderedSet(1) = 0  endpackage");
        }
        catch (AssertionFailedError e) {
            err = e;
            RegressionTest.debugPrintln((String)("Got expected error: " + e.getLocalizedMessage()));
        }
        RegressionTest.assertNotNull((String)"Parse should have failed", (Object)((Object)err));
    }

    public void test_operationSignatureMatching() {
        EPackage pkg = EcoreFactory.eINSTANCE.createEPackage();
        EClass a = EcoreFactory.eINSTANCE.createEClass();
        a.setName("A");
        pkg.getEClassifiers().add((Object)a);
        EClass b = EcoreFactory.eINSTANCE.createEClass();
        b.setName("B");
        pkg.getEClassifiers().add((Object)b);
        EClass c = EcoreFactory.eINSTANCE.createEClass();
        c.setName("C");
        c.getESuperTypes().add((Object)b);
        pkg.getEClassifiers().add((Object)c);
        EReference ref = EcoreFactory.eINSTANCE.createEReference();
        ref.setEType((EClassifier)b);
        ref.setName("b");
        a.getEStructuralFeatures().add((Object)ref);
        ref = EcoreFactory.eINSTANCE.createEReference();
        ref.setEType((EClassifier)c);
        ref.setName("c");
        a.getEStructuralFeatures().add((Object)ref);
        EOperation foo1 = EcoreFactory.eINSTANCE.createEOperation();
        foo1.setName("foo");
        foo1.setEType((EClassifier)EcorePackage.Literals.EBOOLEAN);
        EParameter param = EcoreFactory.eINSTANCE.createEParameter();
        param.setEType((EClassifier)c);
        foo1.getEParameters().add((Object)param);
        a.getEOperations().add((Object)foo1);
        EOperation foo2 = EcoreFactory.eINSTANCE.createEOperation();
        foo2.setName("foo");
        foo2.setEType((EClassifier)EcorePackage.Literals.EBOOLEAN);
        param = EcoreFactory.eINSTANCE.createEParameter();
        param.setEType((EClassifier)b);
        foo2.getEParameters().add((Object)param);
        a.getEOperations().add((Object)foo2);
        this.helper.setContext((Object)a);
        try {
            OCLExpression expr = this.helper.createQuery("self.foo(c)");
            RegressionTest.assertTrue((boolean)(expr instanceof OperationCallExp));
            OperationCallExp oc = (OperationCallExp)expr;
            RegressionTest.assertSame((Object)foo1, (Object)oc.getReferredOperation());
            expr = this.helper.createQuery("self.foo(b)");
            RegressionTest.assertTrue((boolean)(expr instanceof OperationCallExp));
            oc = (OperationCallExp)expr;
            RegressionTest.assertSame((Object)foo2, (Object)oc.getReferredOperation());
            expr = this.helper.createQuery("self.foo(b.oclAsType(C))");
            RegressionTest.assertTrue((boolean)(expr instanceof OperationCallExp));
            oc = (OperationCallExp)expr;
            RegressionTest.assertSame((Object)foo1, (Object)oc.getReferredOperation());
        }
        catch (Exception e) {
            RegressionTest.fail((String)("Failed to parse: " + e.getLocalizedMessage()));
        }
    }

    public void test_operationImplicitSource() {
        AssertionFailedError err = null;
        try {
            this.parse("package ocltest context Fruit inv: Apple.allInstances()->collect(preferredLabel()) endpackage");
        }
        catch (AssertionFailedError e) {
            err = e;
            RegressionTest.debugPrintln((String)("Got expected error: " + e.getLocalizedMessage()));
        }
        RegressionTest.assertNotNull((String)"Parse should have failed", (Object)((Object)err));
        this.parse("package ocltest context Fruit inv: Apple.allInstances()->collect(preferredLabel('foo')) endpackage");
        this.parse("package ocltest context Apple inv: preferredLabel('foo') endpackage");
    }

    public void test_nestedPackages_129769() {
        EPackage rootPackage = EcoreFactory.eINSTANCE.createEPackage();
        rootPackage.setName("foo");
        rootPackage.setNsPrefix("a.b.c.foo");
        rootPackage.setNsURI("http:///foo.ecore");
        EClass a = EcoreFactory.eINSTANCE.createEClass();
        a.setName("A");
        rootPackage.getEClassifiers().add((Object)a);
        EPackage nestedPackage = EcoreFactory.eINSTANCE.createEPackage();
        nestedPackage.setName("bar");
        nestedPackage.setNsPrefix("a.b.c.foo.bar");
        nestedPackage.setNsURI("http:///foo/bar.ecore");
        rootPackage.getESubpackages().add((Object)nestedPackage);
        EClass b = EcoreFactory.eINSTANCE.createEClass();
        b.setName("B");
        nestedPackage.getEClassifiers().add((Object)b);
        EPackageRegistryImpl reg = new EPackageRegistryImpl(resourceSet.getPackageRegistry());
        reg.put((Object)rootPackage.getNsURI(), (Object)rootPackage);
        reg.put((Object)nestedPackage.getNsURI(), (Object)nestedPackage);
        EcoreEnvironmentFactory ef = new EcoreEnvironmentFactory((EPackage.Registry)reg);
        this.ocl.dispose();
        this.ocl = OCL.newInstance((EnvironmentFactory)ef);
        this.helper = this.ocl.createOCLHelper();
        this.helper.setContext((Object)b);
        try {
            this.helper.createInvariant("not self.oclIsKindOf(foo::A)");
            this.helper.createInvariant("not self.oclIsKindOf(a::b::c::foo::A)");
            this.helper.setContext((Object)a);
            this.helper.createInvariant("not self.oclIsKindOf(bar::B)");
            this.helper.createInvariant("not self.oclIsKindOf(foo::bar::B)");
            this.helper.createInvariant("not self.oclIsKindOf(a::b::c::foo::bar::B)");
        }
        catch (Exception e) {
            RegressionTest.fail((String)("Parse failed: " + e.getLocalizedMessage()));
        }
    }

    public void test_typeEquality_126145() {
        EPackage epackage = EcoreFactory.eINSTANCE.createEPackage();
        epackage.setName("foo");
        class EqualsEClass
        extends EClassImpl {
            private int key;

            EqualsEClass(int key) {
                this.key = key;
            }

            public boolean equals(Object o) {
                return o instanceof EqualsEClass && this.key == ((EqualsEClass)((Object)o)).key;
            }
        }
        EqualsEClass a = new EqualsEClass(1);
        a.setName("A");
        epackage.getEClassifiers().add((Object)a);
        EqualsEClass b = new EqualsEClass(1);
        b.setName("B");
        epackage.getEClassifiers().add((Object)b);
        EqualsEClass c = new EqualsEClass(2);
        c.setName("C");
        epackage.getEClassifiers().add((Object)b);
        EReference ref = EcoreFactory.eINSTANCE.createEReference();
        ref.setName("a");
        ref.setUpperBound(-1);
        ref.setOrdered(false);
        ref.setUnique(true);
        ref.setEType((EClassifier)a);
        c.getEStructuralFeatures().add((Object)ref);
        ref = EcoreFactory.eINSTANCE.createEReference();
        ref.setName("b");
        ref.setUpperBound(-1);
        ref.setOrdered(false);
        ref.setUnique(true);
        ref.setEType((EClassifier)b);
        c.getEStructuralFeatures().add((Object)ref);
        this.helper.setContext((Object)c);
        OCLExpression expr = null;
        try {
            expr = this.helper.createQuery("a->union(b)");
        }
        catch (Exception e) {
            RegressionTest.fail((String)("Parse failed: " + e.getLocalizedMessage()));
        }
        RegressionTest.assertNotNull((Object)expr);
        EClassifier type = (EClassifier)expr.getType();
        RegressionTest.assertTrue((boolean)(type instanceof CollectionType));
        type = (EClassifier)((CollectionType)type).getElementType();
        RegressionTest.assertEquals((Object)((Object)a), (Object)type);
        RegressionTest.assertEquals((Object)((Object)b), (Object)type);
        EcoreEnvironment env = (EcoreEnvironment)this.ocl.getEnvironment();
        RegressionTest.assertEquals((int)1, (int)TypeUtil.getRelationship((Environment)env, (Object)((Object)a), (Object)((Object)b)));
        RegressionTest.assertEquals((int)1, (int)TypeUtil.getRelationship((Environment)env, (Object)((Object)b), (Object)((Object)a)));
        try {
            RegressionTest.assertEquals((Object)((Object)a), (Object)TypeUtil.commonSuperType((Environment)env, (Object)((Object)a), (Object)((Object)b)));
            RegressionTest.assertEquals((Object)((Object)b), (Object)TypeUtil.commonSuperType((Environment)env, (Object)((Object)a), (Object)((Object)b)));
            RegressionTest.assertEquals((Object)((Object)a), (Object)TypeUtil.commonSuperType((Environment)env, (Object)((Object)b), (Object)((Object)a)));
            RegressionTest.assertEquals((Object)((Object)b), (Object)TypeUtil.commonSuperType((Environment)env, (Object)((Object)b), (Object)((Object)a)));
        }
        catch (Exception e) {
            RegressionTest.fail((String)("No common super type: " + e.getLocalizedMessage()));
        }
    }

    public void test_enclosingPackage_unqualifiedName() {
        EPackage level1 = EcoreFactory.eINSTANCE.createEPackage();
        level1.setName("level1");
        EPackage level2 = EcoreFactory.eINSTANCE.createEPackage();
        level2.setName("level2");
        level1.getESubpackages().add((Object)level2);
        EEnum enum1 = EcoreFactory.eINSTANCE.createEEnum();
        enum1.setName("Enum1");
        EEnumLiteral enum1Literal1 = EcoreFactory.eINSTANCE.createEEnumLiteral();
        enum1Literal1.setName("Enum1Literal1");
        enum1.getELiterals().add((Object)enum1Literal1);
        EClass class1 = EcoreFactory.eINSTANCE.createEClass();
        class1.setName("Class1");
        EAttribute attr1 = EcoreFactory.eINSTANCE.createEAttribute();
        attr1.setName("attr1");
        attr1.setEType((EClassifier)enum1);
        class1.getEStructuralFeatures().add((Object)attr1);
        level1.getEClassifiers().add((Object)enum1);
        level2.getEClassifiers().add((Object)class1);
        this.helper.setContext((Object)class1);
        try {
            this.helper.createInvariant("attr1 = Enum1::Enum1Literal1");
        }
        catch (Exception e) {
            RegressionTest.fail((String)("Failed to parse: " + e.getLocalizedMessage()));
        }
    }

    public void test_hebrew_singleQuote_135321() {
        this.parse("package ocltest context Apple inv: preferredLabel('foo') endpackage");
    }

    public void test_nullVariableName_143386() {
        Variable var = (Variable)this.oclFactory.createVariable();
        RegressionTest.assertEquals((String)"\"<null>\"", (String)var.toString());
        VariableExp exp = this.oclFactory.createVariableExp();
        exp.setReferredVariable((org.eclipse.ocl.expressions.Variable)var);
        RegressionTest.assertEquals((String)"\"<null>\"", (String)exp.toString());
        var.setName("foo");
        RegressionTest.assertEquals((String)"foo", (String)var.toString());
        RegressionTest.assertEquals((String)"foo", (String)exp.toString());
        var.setEType((EClassifier)this.getOCLStandardLibrary().getString());
        RegressionTest.assertEquals((String)"foo : String", (String)var.toString());
        RegressionTest.assertEquals((String)"foo", (String)exp.toString());
    }

    public void test_letWithMultipleVariables_bug164503() {
        OCLExpression expr = this.parse("package ocltest context Fruit  inv: let s : String = '', i : Set(Integer) = Set{1}, n : UnlimitedNatural = * in true endpackage");
        RegressionTest.assertTrue((boolean)(expr instanceof LetExp));
        LetExp letExp = (LetExp)expr;
        org.eclipse.ocl.expressions.Variable var = letExp.getVariable();
        RegressionTest.assertEquals((String)"s", (String)var.getName());
        RegressionTest.assertSame((Object)this.getOCLStandardLibrary().getString(), (Object)var.getType());
        RegressionTest.assertTrue((boolean)(letExp.getIn() instanceof LetExp));
        letExp = (LetExp)letExp.getIn();
        var = letExp.getVariable();
        RegressionTest.assertEquals((String)"i", (String)var.getName());
        RegressionTest.assertTrue((boolean)(var.getType() instanceof SetType));
        RegressionTest.assertTrue((boolean)(letExp.getIn() instanceof LetExp));
        letExp = (LetExp)letExp.getIn();
        var = letExp.getVariable();
        RegressionTest.assertEquals((String)"n", (String)var.getName());
        RegressionTest.assertSame((Object)this.getOCLStandardLibrary().getUnlimitedNatural(), (Object)var.getType());
        RegressionTest.assertTrue((boolean)(letExp.getIn() instanceof BooleanLiteralExp));
    }

    public void test_letWithMultipleVariables_illFormed_bug164503() {
        try {
            this.parse("package ocltest context Fruit  inv: let s : String = '', i : Set(Integer) in true endpackage");
            RegressionTest.fail((String)"Should have failed to parse or validate");
        }
        catch (AssertionFailedError e) {
            RegressionTest.debugPrintln((String)("Got the expected exception: " + e.getLocalizedMessage()));
        }
        catch (Exception e) {
            RegressionTest.fail((String)("Parse failed with run-time exception: " + e.getLocalizedMessage()));
        }
    }

    public void test_repeatedNamesInPath_176308() {
        EPackage rootpkg = EcoreFactory.eINSTANCE.createEPackage();
        rootpkg.setName("rootpkg");
        EPackage first = EcoreFactory.eINSTANCE.createEPackage();
        first.setName("repeated");
        EPackage second = EcoreFactory.eINSTANCE.createEPackage();
        second.setName("repeated");
        rootpkg.getESubpackages().add((Object)first);
        first.getESubpackages().add((Object)second);
        EEnum enum1 = EcoreFactory.eINSTANCE.createEEnum();
        enum1.setName("Enum1");
        EEnumLiteral enum1Literal1 = EcoreFactory.eINSTANCE.createEEnumLiteral();
        enum1Literal1.setName("Enum1Literal1");
        enum1.getELiterals().add((Object)enum1Literal1);
        second.getEClassifiers().add((Object)enum1);
        EClass dummy = EcoreFactory.eINSTANCE.createEClass();
        dummy.setName("Dummy");
        rootpkg.getEClassifiers().add((Object)dummy);
        EAttribute attr1 = EcoreFactory.eINSTANCE.createEAttribute();
        attr1.setName("attr1");
        attr1.setEType((EClassifier)enum1);
        dummy.getEStructuralFeatures().add((Object)attr1);
        this.helper.setContext((Object)dummy);
        try {
            this.helper.createInvariant("attr1 = repeated::repeated::Enum1::Enum1Literal1");
        }
        catch (Exception e) {
            RegressionTest.fail((String)("Failed to parse: " + e.getLocalizedMessage()));
        }
    }

    public void test_dollarSignInStrings_163542() {
        EPackage rootpkg = EcoreFactory.eINSTANCE.createEPackage();
        rootpkg.setName("rootpkg");
        rootpkg.setNsURI("http:///rootpkg.ecore");
        EClass superclass = EcoreFactory.eINSTANCE.createEClass();
        superclass.setName("Superclass");
        EClass subclass = EcoreFactory.eINSTANCE.createEClass();
        subclass.setName("Sub$Class");
        subclass.getESuperTypes().add((Object)superclass);
        rootpkg.getEClassifiers().add((Object)superclass);
        rootpkg.getEClassifiers().add((Object)subclass);
        EAttribute attr1 = EcoreFactory.eINSTANCE.createEAttribute();
        attr1.setName("attr$1");
        attr1.setEType((EClassifier)EcorePackage.Literals.ESTRING);
        superclass.getEStructuralFeatures().add((Object)attr1);
        resourceSet.getPackageRegistry().put((Object)rootpkg.getNsURI(), (Object)rootpkg);
        try {
            this.ocl.parse(new OCLInput("package rootpkg context Superclass\n-- this comment has a $ in it\ninv: attr$1 = 'dollar$sign' implies self.oclIsKindOf(Sub$Class)\nendpackage"));
        }
        catch (Exception e) {
            RegressionTest.fail((String)("Failed to parse: " + e.getLocalizedMessage()));
        }
    }

    public void test_nameOfCollectionTypeWithoutElementType() {
        org.eclipse.ocl.types.CollectionType collType = this.oclFactory.createCollectionType(CollectionKind.BAG_LITERAL, null);
        collType.getName();
    }

    public void test_variableExpName_243526() {
        OCLExpression constraint = this.parseConstraintUnvalidated("package ocltest context Fruit::ripen(c : Color) : Boolean pre: c.oclIsUndefined() implies Fruit.allInstances()->forAll(color <> self.color) endpackage");
        TreeIterator iter = constraint.eAllContents();
        while (iter.hasNext()) {
            EObject next = (EObject)iter.next();
            if (!(next instanceof VariableExp)) continue;
            VariableExp ve = (VariableExp)next;
            RegressionTest.assertNotNull((Object)ve.getReferredVariable());
            RegressionTest.assertEquals((String)ve.getReferredVariable().getName(), (String)ve.getName());
        }
    }

    public void test_refToUnlimitedNaturalType_259740() {
        this.parse("package ocltest context Apple inv: let u : UnlimitedNatural = * in u.abs() endpackage");
        this.parse("package ocltest context Apple inv: let i : Integer = -1 in not i.oclIsKindOf(UnlimitedNatural) endpackage");
    }

    public void test_nullPackageEnvironment_259818() {
        try {
            this.parse("package NOSUCHPACKAGE context ocltest::Fruit  inv: true endpackage");
            RegressionTest.fail((String)"Should have failed to parse or validate");
        }
        catch (AssertionFailedError e) {
            RegressionTest.debugPrintln((String)("Got the expected exception: " + e.getLocalizedMessage()));
        }
        catch (Exception e) {
            RegressionTest.fail((String)("Parse failed with run-time exception: " + e.getLocalizedMessage()));
        }
    }

    public void test_voidCollections_463441() {
        EPackage epackage = EcoreFactory.eINSTANCE.createEPackage();
        epackage.setName("MyPackage");
        epackage.setNsPrefix("mypkg");
        epackage.setNsURI("http:///mypkg.ecore");
        resourceSet.getPackageRegistry().put((Object)epackage.getNsURI(), (Object)epackage);
        EClass a = EcoreFactory.eINSTANCE.createEClass();
        a.setName("A");
        epackage.getEClassifiers().add((Object)a);
        EClassifier voidType = (EClassifier)this.ocl.getEnvironment().getOCLStandardLibrary().getOclVoid();
        EAttribute attrA = EcoreFactory.eINSTANCE.createEAttribute();
        attrA.setName("void");
        attrA.setEType(voidType);
        a.getEStructuralFeatures().add((Object)attrA);
        EAttribute attrB = EcoreFactory.eINSTANCE.createEAttribute();
        attrB.setName("voids");
        attrB.setEType(voidType);
        attrB.setUpperBound(-1);
        a.getEStructuralFeatures().add((Object)attrB);
        try {
            OCLExpression constraint = this.parseConstraint("package mypkg context A inv: self.voids = OrderedSet{} endpackage");
            EObject eobj = epackage.getEFactoryInstance().create(a);
            RegressionTest.assertTrue((String)"Should not have failed the check", (boolean)this.check(constraint, eobj));
            constraint = this.parseConstraint("package mypkg context A inv: self.voids = Set{} endpackage");
            RegressionTest.assertFalse((String)"Should have failed the check", (boolean)this.check(constraint, eobj));
            constraint = this.parseConstraint("package mypkg context A inv: self.void = null endpackage");
            RegressionTest.assertTrue((String)"Should have failed the check", (boolean)this.check(constraint, eobj));
            List voids = (List)eobj.eGet((EStructuralFeature)attrB);
            voids.add(null);
            constraint = this.parseConstraint("package mypkg context A inv: self.voids = OrderedSet{null} endpackage");
            RegressionTest.assertTrue((String)"Should have failed the check", (boolean)this.check(constraint, eobj));
        }
        catch (Exception e) {
            RegressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }
}

