/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.uml.tests;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.AssertionFailedError;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.OperationCallExp;
import org.eclipse.ocl.uml.BagType;
import org.eclipse.ocl.uml.CollectionType;
import org.eclipse.ocl.uml.OCL;
import org.eclipse.ocl.uml.OrderedSetType;
import org.eclipse.ocl.uml.SequenceType;
import org.eclipse.ocl.uml.SetType;
import org.eclipse.ocl.uml.TupleType;
import org.eclipse.ocl.uml.UMLEnvironmentFactory;
import org.eclipse.ocl.uml.UMLFactory;
import org.eclipse.ocl.uml.Variable;
import org.eclipse.ocl.uml.VariableExp;
import org.eclipse.ocl.uml.tests.AbstractTestSuite;
import org.eclipse.ocl.util.Tuple;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.resource.UMLResource;

public class RegressionTest
extends AbstractTestSuite {
    public void test_quoteReservedWords_RATLC00527506() {
        this.expectModified = true;
        Package epackage = umlf.createPackage();
        epackage.setName("MyPackage");
        ((Package)this.fruitPackage).eResource().getContents().add((Object)epackage);
        Class eclass = epackage.createOwnedClass("MyType", false);
        eclass.createOwnedAttribute("context", (Type)this.getUMLString());
        try {
            this.parseConstraint("package MyPackage context MyType inv: self.\"context\"->notEmpty() endpackage");
        }
        finally {
            EcoreUtil.remove((EObject)epackage);
        }
    }

    public void test_quoteWhitespace_RATLC00527509() {
        this.expectModified = true;
        Package epackage = umlf.createPackage();
        epackage.setName("MyPackage");
        ((Package)this.fruitPackage).eResource().getContents().add((Object)epackage);
        Class eclass = epackage.createOwnedClass("MyType", false);
        eclass.createOwnedAttribute("an attribute", (Type)this.getUMLString());
        try {
            this.parseConstraint("package MyPackage context MyType inv: self.\"an attribute\"->notEmpty() endpackage");
        }
        finally {
            EcoreUtil.remove((EObject)epackage);
        }
    }

    public void test_quoteQuote_RATLC00527509() {
        this.expectModified = true;
        Package epackage = umlf.createPackage();
        epackage.setName("MyPackage");
        ((Package)this.fruitPackage).eResource().getContents().add((Object)epackage);
        Class eclass = epackage.createOwnedClass("MyType", false);
        eclass.createOwnedAttribute("an\"attribute", (Type)this.getUMLString());
        try {
            this.parseConstraint("package MyPackage context MyType inv: self.\"an\\\"attribute\"->notEmpty() endpackage");
            AssertionFailedError err = null;
            try {
                this.parseConstraint("package MyPackage context MyType inv: self.an\\\"attribute->notEmpty() endpackage");
            }
            catch (AssertionFailedError e) {
                err = e;
                RegressionTest.debugPrintln((String)("Got expected error: " + e.getLocalizedMessage()));
            }
            RegressionTest.assertNotNull((String)"Should not have parsed.", (Object)((Object)err));
        }
        finally {
            EcoreUtil.remove((EObject)epackage);
        }
    }

    public void test_internationalCharacters_RATLC01080816() {
        this.expectModified = true;
        Package epackage = umlf.createPackage();
        epackage.setName("MyPackage");
        ((Package)this.fruitPackage).eResource().getContents().add((Object)epackage);
        Class eclass = epackage.createOwnedClass("MyType", false);
        eclass.createOwnedAttribute("\u0160\u01d6\u0429\u0639", (Type)this.getUMLString());
        try {
            this.parseConstraint("package MyPackage context MyType inv: self.\u0160\u01d6\u0429\u0639 <> '\u0160\u01d6\u0429\u0639' endpackage");
        }
        finally {
            EcoreUtil.remove((EObject)epackage);
        }
    }

    public void test_oclIsKindOf_RATLC01087664() {
        this.expectModified = true;
        Package epackage = umlf.createPackage();
        epackage.setName("MyPackage");
        ((Package)this.fruitPackage).eResource().getContents().add((Object)epackage);
        Class a = epackage.createOwnedClass("A", false);
        Class b = epackage.createOwnedClass("B", false);
        Class c = epackage.createOwnedClass("C", false);
        c.createGeneralization((Classifier)a);
        c.createGeneralization((Classifier)b);
        Property attrA = a.createOwnedAttribute("a", (Type)this.getUMLBoolean());
        Property attrB = b.createOwnedAttribute("b", (Type)this.getUMLBoolean());
        try {
            OCLExpression constraint = this.parseConstraint("package MyPackage context A inv: self.oclIsKindOf(B) implies (self.oclAsType(B).b <> self.a) endpackage");
            InstanceSpecification eobj = this.instantiate(epackage, (Classifier)c);
            this.setValue(eobj, attrA, Boolean.TRUE);
            this.setValue(eobj, attrB, Boolean.TRUE);
            RegressionTest.assertFalse((String)"Should have failed the check", (boolean)this.check(constraint, eobj));
            this.setValue(eobj, attrB, Boolean.FALSE);
            RegressionTest.assertTrue((String)"Should not have failed the check", (boolean)this.check(constraint, eobj));
        }
        finally {
            EcoreUtil.remove((EObject)epackage);
        }
    }

    public void test_shortcircuitAnd_RATLC00536528() {
        this.expectModified = true;
        Package epackage = umlf.createPackage();
        epackage.setName("MyPackage");
        ((Package)this.fruitPackage).eResource().getContents().add((Object)epackage);
        Class a = epackage.createOwnedClass("A", false);
        Class b = epackage.createOwnedClass("B", false);
        b.createGeneralization((Classifier)a);
        Property attrA = a.createOwnedAttribute("a", (Type)this.getUMLBoolean());
        Property attrB = b.createOwnedAttribute("b", (Type)this.getUMLBoolean());
        try {
            try {
                OCLExpression constraint = this.parseConstraint("package MyPackage context A inv: self.oclIsKindOf(B) and self.oclAsType(B).b endpackage");
                InstanceSpecification eobj = this.instantiate(epackage, (Classifier)a);
                this.setValue(eobj, attrA, Boolean.TRUE);
                RegressionTest.assertFalse((String)"Should have failed the check", (boolean)this.check(constraint, eobj));
                eobj = this.instantiate(epackage, (Classifier)b);
                this.setValue(eobj, attrA, Boolean.TRUE);
                this.setValue(eobj, attrB, Boolean.TRUE);
                RegressionTest.assertTrue((String)"Should not have failed the check", (boolean)this.check(constraint, eobj));
            }
            catch (Exception e) {
                RegressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
                EcoreUtil.remove((EObject)epackage);
            }
        }
        finally {
            EcoreUtil.remove((EObject)epackage);
        }
    }

    public void test_shortcircuitOr_RATLC00536528() {
        this.expectModified = true;
        Package epackage = umlf.createPackage();
        epackage.setName("MyPackage");
        ((Package)this.fruitPackage).eResource().getContents().add((Object)epackage);
        Class a = epackage.createOwnedClass("A", false);
        Class b = epackage.createOwnedClass("B", false);
        b.createGeneralization((Classifier)a);
        Property attrA = a.createOwnedAttribute("a", (Type)this.getUMLBoolean());
        Property attrB = b.createOwnedAttribute("b", (Type)this.getUMLBoolean());
        try {
            try {
                OCLExpression constraint = this.parseConstraint("package MyPackage context A inv: (not self.oclIsKindOf(B)) or self.oclAsType(B).b endpackage");
                InstanceSpecification eobj = this.instantiate(epackage, (Classifier)a);
                this.setValue(eobj, attrA, Boolean.TRUE);
                RegressionTest.assertTrue((String)"Should not have failed the check", (boolean)this.check(constraint, eobj));
                eobj = this.instantiate(epackage, (Classifier)b);
                this.setValue(eobj, attrA, Boolean.TRUE);
                this.setValue(eobj, attrB, Boolean.TRUE);
                RegressionTest.assertTrue((String)"Should not have failed the check", (boolean)this.check(constraint, eobj));
            }
            catch (Exception e) {
                RegressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
                EcoreUtil.remove((EObject)epackage);
            }
        }
        finally {
            EcoreUtil.remove((EObject)epackage);
        }
    }

    public void test_shortcircuitImplies_RATLC00536528() {
        this.expectModified = true;
        Package epackage = umlf.createPackage();
        epackage.setName("MyPackage");
        ((Package)this.fruitPackage).eResource().getContents().add((Object)epackage);
        Class a = epackage.createOwnedClass("A", false);
        Class b = epackage.createOwnedClass("B", false);
        b.createGeneralization((Classifier)a);
        Property attrA = a.createOwnedAttribute("a", (Type)this.getUMLBoolean());
        Property attrB = b.createOwnedAttribute("b", (Type)this.getUMLBoolean());
        try {
            try {
                OCLExpression constraint = this.parseConstraint("package MyPackage context A inv: self.oclIsKindOf(B) implies self.oclAsType(B).b endpackage ");
                InstanceSpecification eobj = this.instantiate(epackage, (Classifier)a);
                this.setValue(eobj, attrA, Boolean.TRUE);
                RegressionTest.assertTrue((String)"Should not have failed the check", (boolean)this.check(constraint, eobj));
                eobj = this.instantiate(epackage, (Classifier)b);
                this.setValue(eobj, attrA, Boolean.TRUE);
                this.setValue(eobj, attrB, Boolean.FALSE);
                RegressionTest.assertFalse((String)"Should have failed the check", (boolean)this.check(constraint, eobj));
            }
            catch (Exception e) {
                RegressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
                EcoreUtil.remove((EObject)epackage);
            }
        }
        finally {
            EcoreUtil.remove((EObject)epackage);
        }
    }

    public void test_oclIsNew_invariant_RATLC00529981() {
        OCLExpression constraint = this.parseConstraintUnvalidated("package ocltest context Fruit inv: color.oclIsNew() endpackage");
        AssertionFailedError err = null;
        try {
            this.validate(constraint);
        }
        catch (AssertionFailedError e) {
            err = e;
            RegressionTest.debugPrintln((String)("Got expected error: " + e.getLocalizedMessage()));
        }
        RegressionTest.assertNotNull((String)"Should not have succeeded in validating illegal oclIsNew", (Object)((Object)err));
    }

    public void test_oclIsNew_precondition_RATLC00529981() {
        OCLExpression constraint = this.parseConstraintUnvalidated("package ocltest context Fruit::ripen(c : Color) : Boolean pre: c.oclIsNew() implies c <> Color::black endpackage");
        AssertionFailedError err = null;
        try {
            this.validate(constraint);
        }
        catch (AssertionFailedError e) {
            err = e;
            RegressionTest.debugPrintln((String)("Got expected error: " + e.getLocalizedMessage()));
        }
        RegressionTest.assertNotNull((String)"Should not have succeeded in validating illegal oclIsNew", (Object)((Object)err));
    }

    public void test_oclIsNew_postcondition_RATLC00529981() {
        this.parseConstraint("package ocltest context Fruit::ripen(c : Color) : Boolean post: color.oclIsNew() implies color <> Color::black endpackage");
    }

    public void test_toLower_RATLC00529981() {
        OCLExpression expr = this.parse("package ocltest context Fruit inv: 'AlPHaBet'.toLower() endpackage");
        Object value = this.evaluate(expr);
        RegressionTest.assertEquals((Object)"alphabet", (Object)value);
    }

    public void test_toUpper_RATLC00529981() {
        OCLExpression expr = this.parse("package ocltest context Fruit inv: 'AlPHaBet'.toUpper() endpackage");
        Object value = this.evaluate(expr);
        RegressionTest.assertEquals((Object)"ALPHABET", (Object)value);
    }

    public void test_referenceMultiplicity_orderedSet_RATLC00538035() {
        OCLExpression expr = this.parse("package ocltest context Fruit inv: FruitUtil.orderedSet endpackage");
        RegressionTest.assertTrue((String)"Not an ordered set type", (boolean)(expr.getType() instanceof OrderedSetType));
    }

    public void test_referenceMultiplicity_set_RATLC00538035() {
        OCLExpression expr = this.parse("package ocltest context Fruit inv: FruitUtil.set endpackage");
        RegressionTest.assertTrue((String)"Not a set type", (expr.getType() instanceof SetType && !(expr.getType() instanceof OrderedSetType) ? 1 : 0) != 0);
    }

    public void test_referenceMultiplicity_sequence_RATLC00538035() {
        OCLExpression expr = this.parse("package ocltest context Fruit inv: FruitUtil.sequence endpackage");
        RegressionTest.assertTrue((String)"Not a sequence type", (boolean)(expr.getType() instanceof SequenceType));
    }

    public void test_referenceMultiplicity_bag_RATLC00538035() {
        OCLExpression expr = this.parse("package ocltest context Fruit inv: FruitUtil.bag endpackage");
        RegressionTest.assertTrue((String)"Not a bag type", (boolean)(expr.getType() instanceof BagType));
    }

    public void test_parameterMultiplicity_orderedSet_RATLC00538035() {
        OCLExpression expr = this.parse("package ocltest context Fruit inv: FruitUtil.processOrderedSet(FruitUtil.orderedSet) endpackage");
        RegressionTest.assertTrue((String)"Not an ordered set type", (boolean)(expr.getType() instanceof OrderedSetType));
    }

    public void test_parameterMultiplicity_set_RATLC00538035() {
        OCLExpression expr = this.parse("package ocltest context Fruit inv: FruitUtil.processSet(FruitUtil.set) endpackage");
        RegressionTest.assertTrue((String)"Not a set type", (expr.getType() instanceof SetType && !(expr.getType() instanceof OrderedSetType) ? 1 : 0) != 0);
    }

    public void test_parameterMultiplicity_sequence_RATLC00538035() {
        OCLExpression expr = this.parse("package ocltest context Fruit inv: FruitUtil.processSequence(FruitUtil.sequence) endpackage");
        RegressionTest.assertTrue((String)"Not a sequence type", (boolean)(expr.getType() instanceof SequenceType));
    }

    public void test_parameterMultiplicity_bag_RATLC00538035() {
        OCLExpression expr = this.parse("package ocltest context Fruit inv: FruitUtil.processBag(FruitUtil.bag) endpackage");
        RegressionTest.assertTrue((String)"Not a bag type", (boolean)(expr.getType() instanceof BagType));
    }

    public void test_operationMultiplicity_orderedSet_RATLC00538035() {
        OCLExpression expr = this.parse("package ocltest context Fruit inv: FruitUtil.processOrderedSet(FruitUtil.processOrderedSet(FruitUtil.orderedSet)) endpackage");
        RegressionTest.assertTrue((String)"Not an ordered set type", (boolean)(expr.getType() instanceof OrderedSetType));
    }

    public void test_operationMultiplicity_set_RATLC00538035() {
        OCLExpression expr = this.parse("package ocltest context Fruit inv: FruitUtil.processSet(FruitUtil.processSet(FruitUtil.set)) endpackage");
        RegressionTest.assertTrue((String)"Not a set type", (expr.getType() instanceof SetType && !(expr.getType() instanceof OrderedSetType) ? 1 : 0) != 0);
    }

    public void test_operationMultiplicity_sequence_RATLC00538035() {
        OCLExpression expr = this.parse("package ocltest context Fruit inv: FruitUtil.processSequence(FruitUtil.processSequence(FruitUtil.sequence)) endpackage");
        RegressionTest.assertTrue((String)"Not a sequence type", (boolean)(expr.getType() instanceof SequenceType));
    }

    public void test_operationMultiplicity_bag_RATLC00538035() {
        OCLExpression expr = this.parse("package ocltest context Fruit inv: FruitUtil.processBag(FruitUtil.processBag(FruitUtil.bag)) endpackage");
        RegressionTest.assertTrue((String)"Not a bag type", (boolean)(expr.getType() instanceof BagType));
    }

    public void test_operationContext_orderedSet_RATLC00538035() {
        AssertionFailedError err = null;
        try {
            this.parse("package ocltest context FruitUtil::processOrderedSet(x : Fruit) : Fruit body: result = x endpackage");
        }
        catch (AssertionFailedError e) {
            err = e;
            RegressionTest.debugPrintln((String)("Got expected error: " + e.getLocalizedMessage()));
        }
        RegressionTest.assertNotNull((String)"Parse should have failed", (Object)((Object)err));
        this.parse("package ocltest context FruitUtil::processOrderedSet(x : OrderedSet(Fruit)) : OrderedSet(Fruit) body: result = x endpackage");
    }

    public void test_operationContext_set_RATLC00538035() {
        AssertionFailedError err = null;
        try {
            this.parse("package ocltest context FruitUtil::processSet(x : Fruit) : Fruit body: result = x endpackage");
        }
        catch (AssertionFailedError e) {
            err = e;
            RegressionTest.debugPrintln((String)("Got expected error: " + e.getLocalizedMessage()));
        }
        RegressionTest.assertNotNull((String)"Parse should have failed", (Object)((Object)err));
        this.parse("package ocltest context FruitUtil::processSet(x : Set(Fruit)) : Set(Fruit) body: result = x endpackage");
    }

    public void test_operationContext_sequence_RATLC00538035() {
        AssertionFailedError err = null;
        try {
            this.parse("package ocltest context FruitUtil::processSequence(x : Fruit) : Fruit body: result = x endpackage");
        }
        catch (AssertionFailedError e) {
            err = e;
            RegressionTest.debugPrintln((String)("Got expected error: " + e.getLocalizedMessage()));
        }
        RegressionTest.assertNotNull((String)"Parse should have failed", (Object)((Object)err));
        this.parse("package ocltest context FruitUtil::processSequence(x : Sequence(Fruit)) : Sequence(Fruit) body: result = x endpackage");
    }

    public void test_operationContext_bag_RATLC00538035() {
        AssertionFailedError err = null;
        try {
            this.parse("package ocltest context FruitUtil::processBag(x : Fruit) : Fruit body: result = x endpackage");
        }
        catch (AssertionFailedError e) {
            err = e;
            RegressionTest.debugPrintln((String)("Got expected error: " + e.getLocalizedMessage()));
        }
        RegressionTest.assertNotNull((String)"Parse should have failed", (Object)((Object)err));
        this.parse("package ocltest context FruitUtil::processBag(x : Bag(Fruit)) : Bag(Fruit) body: result = x endpackage");
    }

    public void test_allInstances_enumeration_RATLC00538079() {
        Object result = this.evaluate(this.parse("package ocltest context Fruit inv: Color.allInstances()  endpackage"));
        HashSet expected = new HashSet(this.color.getOwnedLiterals());
        RegressionTest.assertEquals(expected, (Object)result);
    }

    public void test_allInstances_voidType_RATLC00538079() {
        Object result = this.evaluate(this.parse("package ocltest context Fruit inv: OclVoid.allInstances()  endpackage"));
        HashSet<Object> expected = new HashSet<Object>();
        expected.add(null);
        RegressionTest.assertEquals(expected, (Object)result);
    }

    public void test_allInstances_primitive_RATLC00538079() {
        Object result = this.evaluate(this.parse("package ocltest context Fruit inv: PrimitiveTypes::\"String\".allInstances()  endpackage"));
        RegressionTest.assertEquals((Object)Collections.EMPTY_SET, (Object)result);
    }

    public void test_closingParentheses_core() {
        AssertionFailedError err = null;
        try {
            this.parse("package ocltest context Fruit inv: self)garbage  endpackage");
        }
        catch (AssertionFailedError e) {
            err = e;
            RegressionTest.debugPrintln((String)("Got expected error: " + e.getLocalizedMessage()));
        }
        RegressionTest.assertNotNull((String)"Parse should have failed", (Object)((Object)err));
    }

    public void test_closingParentheses_helper() {
        this.helper.setContext((Object)this.fruit);
        try {
            this.helper.createInvariant("self)garbage");
            RegressionTest.fail((String)"Parse should have failed");
        }
        catch (Exception e) {
            RegressionTest.debugPrintln((String)("Got expected error: " + e.getLocalizedMessage()));
        }
    }

    public void test_closingParentheses_helper_precondition() {
        this.helper.setOperationContext((Object)this.fruit, (Object)this.fruit_ripen);
        try {
            this.helper.createPrecondition("self)garbage");
            RegressionTest.fail((String)"Parse should have failed");
        }
        catch (Exception e) {
            RegressionTest.debugPrintln((String)("Got expected error: " + e.getLocalizedMessage()));
        }
    }

    public void test_operationBodyBoolean_116251() {
        AssertionFailedError err = null;
        this.parseConstraint("package ocltest context FruitUtil::processBag(x : Bag(Fruit)) : Bag(Fruit) body: result = x->asSet()->asBag() endpackage");
        this.parseConstraint("package ocltest context FruitUtil::processBag(x : Bag(Fruit)) : Bag(Fruit) body: x->asSet()->asBag() = result endpackage");
        this.parseConstraint("package ocltest context FruitUtil::processBag(x : Bag(Fruit)) : Bag(Fruit) body: let set : Set(Fruit) = x->asSet() in let bag : Bag(Fruit) = set->asBag() in result = bag endpackage");
        err = null;
        try {
            this.parseConstraint("package ocltest context FruitUtil::processBag(x : Bag(Fruit)) : Bag(Fruit) body: result = result->asSet()->union(x)->asBag() endpackage");
        }
        catch (AssertionFailedError e) {
            err = e;
            RegressionTest.debugPrintln((String)("Got expected error: " + e.getLocalizedMessage()));
        }
        RegressionTest.assertNotNull((String)"Parse should have failed", (Object)((Object)err));
    }

    public void test_innerScopeFeatureResolution_bugzilla113355() {
        this.expectModified = true;
        Package epackage = umlf.createPackage();
        epackage.setName("MyPackage");
        ((Package)this.fruitPackage).eResource().getContents().add((Object)epackage);
        Class libraryClass = epackage.createOwnedClass("Library", false);
        Class writerClass = epackage.createOwnedClass("Writer", false);
        Property branchesRef = libraryClass.createOwnedAttribute("branches", (Type)libraryClass);
        branchesRef.setUpper(-1);
        branchesRef.setIsOrdered(true);
        Property writersRef = libraryClass.createOwnedAttribute("writers", (Type)writerClass);
        writersRef.setUpper(-1);
        writersRef.setIsOrdered(true);
        Property writerName = writerClass.createOwnedAttribute("name", (Type)this.getUMLString());
        InstanceSpecification library1 = this.instantiate(epackage, (Classifier)libraryClass);
        InstanceSpecification library2 = this.instantiate(epackage, (Classifier)libraryClass);
        InstanceSpecification writer1 = this.instantiate(epackage, (Classifier)writerClass);
        InstanceSpecification writer2 = this.instantiate(epackage, (Classifier)writerClass);
        this.setValue(writer1, writerName, "Joe");
        this.setValue(writer2, writerName, "Jane");
        this.addValue(library1, branchesRef, library2);
        this.addValue(library2, writersRef, writer1);
        this.addValue(library2, writersRef, writer2);
        try {
            try {
                OCLExpression expr = this.parse("package MyPackage context Library inv: branches->collect(writers->collect(w : Writer | w))->flatten()endpackage");
                List result = (List)this.evaluate(expr, library1);
                RegressionTest.assertTrue((result.size() == 2 ? 1 : 0) != 0);
                RegressionTest.assertTrue((boolean)this.getValue((InstanceSpecification)result.get(0), writerName).equals("Joe"));
                RegressionTest.assertTrue((boolean)this.getValue((InstanceSpecification)result.get(1), writerName).equals("Jane"));
            }
            catch (Exception e) {
                RegressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
                EcoreUtil.remove((EObject)epackage);
            }
        }
        finally {
            EcoreUtil.remove((EObject)epackage);
        }
    }

    public void test_product_126336() {
        this.helper.setContext((Object)((Classifier)this.getUMLString()));
        Set product = null;
        try {
            Set resultValue;
            OCLExpression expr = this.helper.createQuery("Set{'foo', 'bar'}->product(Sequence{1, 2, 3})");
            Classifier resultType = (Classifier)expr.getType();
            RegressionTest.assertTrue((boolean)(resultType instanceof CollectionType));
            Classifier elementType = (Classifier)((CollectionType)resultType).getElementType();
            RegressionTest.assertTrue((boolean)(elementType instanceof TupleType));
            TupleType tupleType = (TupleType)elementType;
            RegressionTest.assertEquals((int)2, (int)tupleType.oclProperties().size());
            product = resultValue = (Set)this.ocl.evaluate((Object)"", expr);
        }
        catch (Exception e) {
            RegressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
        RegressionTest.assertNotNull(product);
        RegressionTest.assertEquals((int)6, (int)product.size());
        HashMap expectedTuples = new HashMap();
        Set values = new HashSet<Integer>();
        values.add(1);
        values.add(2);
        values.add(3);
        expectedTuples.put("foo", new HashSet(values));
        expectedTuples.put("bar", new HashSet(values));
        for (Tuple tuple : product) {
            values = (Set)expectedTuples.get(tuple.getValue("first"));
            RegressionTest.assertNotNull(values);
            RegressionTest.assertTrue((boolean)values.remove(tuple.getValue("second")));
        }
    }

    public void test_iterationToString_126454() {
        Package fakePkg = umlf.createPackage();
        fakePkg.setName("fake");
        Class fake = fakePkg.createOwnedClass("Fake", false);
        Property eattr = fake.createOwnedAttribute("e", (Type)this.getUMLInteger());
        eattr.setUpper(1);
        InstanceSpecification aFake = this.instantiate(fakePkg, (Classifier)fake);
        this.setValue(aFake, eattr, new Integer(7));
        this.helper.setContext((Object)fake);
        try {
            OCLExpression expr = this.helper.createQuery("self.e->sum()");
            String toStringResult = expr.toString();
            expr = this.helper.createQuery(toStringResult);
            RegressionTest.assertEquals((Object)this.getValue(aFake, eattr), (Object)this.ocl.evaluate((Object)aFake, expr));
        }
        catch (Exception exc) {
            RegressionTest.fail((String)("Failed to parse or evaluate: " + exc.getLocalizedMessage()));
        }
    }

    public void test_null() {
        Object result = this.evaluate(this.parse("package ocltest context Fruit inv: null.oclIsTypeOf(OclVoid)  endpackage"));
        RegressionTest.assertEquals((Object)Boolean.TRUE, (Object)result);
        result = this.evaluate(this.parse("package ocltest context Fruit inv: null.oclIsUndefined()  endpackage"));
        RegressionTest.assertEquals((Object)Boolean.TRUE, (Object)result);
        result = this.evaluate(this.parse("package ocltest context Fruit inv: null.oclIsInvalid()  endpackage"));
        RegressionTest.assertEquals((Object)Boolean.FALSE, (Object)result);
        result = this.evaluate(this.parse("package ocltest context Fruit inv: null.oclAsType(Integer)  endpackage"));
        RegressionTest.assertNull((Object)result);
    }

    public void test_oclInvalid() {
        Object result = this.evaluate(this.parse("package ocltest context Fruit inv: invalid.oclIsTypeOf(OclInvalid)  endpackage"));
        RegressionTest.assertEquals((Object)Boolean.TRUE, (Object)result);
        result = this.evaluate(this.parse("package ocltest context Fruit inv: invalid.oclIsUndefined()  endpackage"));
        RegressionTest.assertEquals((Object)Boolean.TRUE, (Object)result);
        result = this.evaluate(this.parse("package ocltest context Fruit inv: invalid.oclIsInvalid()  endpackage"));
        RegressionTest.assertEquals((Object)Boolean.TRUE, (Object)result);
        result = this.evaluate(this.parse("package ocltest context Fruit inv: invalid.oclAsType(Integer)  endpackage"));
        this.assertInvalid(result);
        result = this.evaluate(this.parse("package ocltest context Fruit inv: null.oclAsType(Apple).color  endpackage"));
        this.assertInvalid(result);
        result = this.evaluate(this.parse("package ocltest context Fruit inv: null.oclAsType(Apple).tree  endpackage"));
        this.assertInvalid(result);
        result = this.evaluate(this.parse("package ocltest context Fruit inv: null.oclAsType(Apple).preferredLabel('foo')  endpackage"));
        this.assertInvalid(result);
    }

    public void test_operationNotFound() {
        AssertionFailedError err = null;
        try {
            this.parseUnvalidated("package ocltest context Fruit inv: FruitUtil.processOrderedSet(1) = 0  endpackage");
        }
        catch (AssertionFailedError e) {
            err = e;
            RegressionTest.debugPrintln((String)("Got expected error: " + e.getLocalizedMessage()));
        }
        RegressionTest.assertNotNull((String)"Parse should have failed", (Object)((Object)err));
    }

    public void test_operationSignatureMatching() {
        Package pkg = umlf.createPackage();
        Class a = pkg.createOwnedClass("A", false);
        Class b = pkg.createOwnedClass("B", false);
        Class c = pkg.createOwnedClass("C", false);
        c.createGeneralization((Classifier)b);
        a.createOwnedAttribute("b", (Type)b);
        a.createOwnedAttribute("c", (Type)c);
        Operation foo1 = a.createOwnedOperation("foo", (EList)new BasicEList(Collections.singleton("c")), (EList)new BasicEList(Collections.singleton(c)), (Type)this.getUMLBoolean());
        foo1.setIsQuery(true);
        Operation foo2 = a.createOwnedOperation("foo", (EList)new BasicEList(Collections.singleton("b")), (EList)new BasicEList(Collections.singleton(b)), (Type)this.getUMLBoolean());
        foo2.setIsQuery(true);
        this.helper.setContext((Object)a);
        try {
            OCLExpression expr = this.helper.createQuery("self.foo(c)");
            RegressionTest.assertTrue((boolean)(expr instanceof OperationCallExp));
            OperationCallExp oc = (OperationCallExp)expr;
            RegressionTest.assertSame((Object)foo1, (Object)oc.getReferredOperation());
            expr = this.helper.createQuery("self.foo(b)");
            RegressionTest.assertTrue((boolean)(expr instanceof OperationCallExp));
            oc = (OperationCallExp)expr;
            RegressionTest.assertSame((Object)foo2, (Object)oc.getReferredOperation());
            expr = this.helper.createQuery("self.foo(b.oclAsType(C))");
            RegressionTest.assertTrue((boolean)(expr instanceof OperationCallExp));
            oc = (OperationCallExp)expr;
            RegressionTest.assertSame((Object)foo1, (Object)oc.getReferredOperation());
        }
        catch (Exception e) {
            RegressionTest.fail((String)("Failed to parse: " + e.getLocalizedMessage()));
        }
    }

    public void test_operationImplicitSource() {
        AssertionFailedError err = null;
        try {
            this.parse("package ocltest context Fruit inv: Apple.allInstances()->collect(preferredLabel()) endpackage");
        }
        catch (AssertionFailedError e) {
            err = e;
            RegressionTest.debugPrintln((String)("Got expected error: " + e.getLocalizedMessage()));
        }
        RegressionTest.assertNotNull((String)"Parse should have failed", (Object)((Object)err));
        this.parse("package ocltest context Fruit inv: Apple.allInstances()->collect(preferredLabel('foo')) endpackage");
        this.parse("package ocltest context Apple inv: preferredLabel('foo') endpackage");
    }

    public void test_enclosingPackage_unqualifiedName() {
        Package level1 = umlf.createPackage();
        level1.setName("level1");
        Package level2 = level1.createNestedPackage("level2");
        Enumeration enum1 = level1.createOwnedEnumeration("Enum1");
        enum1.createOwnedLiteral("Enum1Literal1");
        Class class1 = level2.createOwnedClass("Class1", false);
        class1.createOwnedAttribute("attr1", (Type)enum1);
        this.helper.setContext((Object)class1);
        try {
            this.helper.createInvariant("attr1 = Enum1::Enum1Literal1");
        }
        catch (Exception e) {
            RegressionTest.fail((String)("Failed to parse: " + e.getLocalizedMessage()));
        }
    }

    public void test_hebrew_singleQuote_135321() {
        this.parse("package ocltest context Apple inv: preferredLabel('foo') endpackage");
    }

    public void test_nullVariableName_143386() {
        Variable var = UMLFactory.eINSTANCE.createVariable();
        RegressionTest.assertEquals((String)"\"<null>\"", (String)var.toString());
        VariableExp exp = UMLFactory.eINSTANCE.createVariableExp();
        exp.setReferredVariable((org.eclipse.ocl.expressions.Variable)var);
        RegressionTest.assertEquals((String)"\"<null>\"", (String)exp.toString());
        var.setName("foo");
        RegressionTest.assertEquals((String)"foo", (String)var.toString());
        RegressionTest.assertEquals((String)"foo", (String)exp.toString());
        var = UMLFactory.eINSTANCE.createVariable();
        var.setName("foo");
        var.setType((Object)((Classifier)this.getUMLString()));
        exp = UMLFactory.eINSTANCE.createVariableExp();
        exp.setReferredVariable((org.eclipse.ocl.expressions.Variable)var);
        RegressionTest.assertEquals((String)"foo : String", (String)var.toString());
        RegressionTest.assertEquals((String)"foo", (String)exp.toString());
    }

    public void test_nameOfCollectionTypeWithoutElementType() {
        org.eclipse.ocl.types.CollectionType collType = this.ocl.getEnvironment().getOCLFactory().createCollectionType(CollectionKind.BAG_LITERAL, null);
        collType.getName();
    }

    public void test_dispose_resourceOwnedByOCL_213045() {
        this.helper.setContext((Object)((Classifier)this.getMetaclass("Action")));
        try {
            Constraint constraint = (Constraint)this.helper.createInvariant("self.owner <> null");
            Resource res = constraint.eResource();
            RegressionTest.assertSame((Object)this.ocl.getEnvironment().getTypeResolver().getResource(), (Object)res);
            AdapterImpl adapter = new AdapterImpl();
            constraint.getSpecification().eAdapters().add((Object)adapter);
            RegressionTest.assertSame((Object)constraint.getSpecification(), (Object)adapter.getTarget());
            this.ocl.dispose();
            RegressionTest.assertFalse((boolean)res.isLoaded());
            RegressionTest.assertNull((Object)constraint.eResource());
            RegressionTest.assertNull((Object)adapter.getTarget());
        }
        catch (ParserException e) {
            RegressionTest.fail((String)("Should not have failed to parse: " + e.getLocalizedMessage()));
        }
    }

    public void test_dispose_resourceOwnedByClient_213045() {
        UMLEnvironmentFactory factory = (UMLEnvironmentFactory)this.ocl.getEnvironment().getFactory();
        this.ocl.dispose();
        Resource res = UMLResource.Factory.INSTANCE.createResource(URI.createURI((String)"foo://foo"));
        this.ocl = OCL.newInstance((Environment)factory.loadEnvironment(res));
        this.helper = this.ocl.createOCLHelper();
        this.helper.setContext((Object)((Classifier)this.getMetaclass("Action")));
        try {
            Constraint constraint = (Constraint)this.helper.createInvariant("self.owner <> null");
            RegressionTest.assertSame((Object)res, (Object)constraint.eResource());
            AdapterImpl adapter = new AdapterImpl();
            constraint.getSpecification().eAdapters().add((Object)adapter);
            RegressionTest.assertSame((Object)constraint.getSpecification(), (Object)adapter.getTarget());
            this.ocl.dispose();
            RegressionTest.assertTrue((boolean)res.isLoaded());
            RegressionTest.assertSame((Object)res, (Object)constraint.eResource());
            RegressionTest.assertSame((Object)constraint.getSpecification(), (Object)adapter.getTarget());
        }
        catch (ParserException e) {
            RegressionTest.fail((String)("Should not have failed to parse: " + e.getLocalizedMessage()));
        }
    }
}

