/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.tests;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.pivot.tests.PivotTestCase;
import org.eclipse.ocl.examples.pivot.tests.PivotTestSuite;
import org.eclipse.ocl.examples.xtext.tests.TestFile;
import org.eclipse.ocl.examples.xtext.tests.TestFileSystem;
import org.eclipse.ocl.examples.xtext.tests.TestFileSystemHelper;
import org.eclipse.ocl.examples.xtext.tests.TestProject;
import org.eclipse.ocl.examples.xtext.tests.TestProjectManager;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.ClassUtil;

public abstract class PivotTestCaseWithAutoTearDown
extends PivotTestCase {
    public @Nullable TestFileSystem testFileSystem = null;
    public @Nullable TestProject testProject = null;
    public @Nullable ProjectManager testProjectManager = null;

    protected void autoTearDown() throws Exception {
        Class<?> aClass = ((Object)((Object)this)).getClass();
        while (PivotTestCaseWithAutoTearDown.class.isAssignableFrom(aClass)) {
            Field[] fieldArray = aClass.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                int modifiers = field.getModifiers();
                if (!Modifier.isFinal(modifiers)) {
                    if (!Modifier.isStatic(modifiers)) {
                        Class<?> fieldType = field.getType();
                        if (Object.class.isAssignableFrom(fieldType)) {
                            String fieldName = field.getName();
                            try {
                                String tearDownName = "tearDown_" + fieldName;
                                Method method = aClass.getDeclaredMethod(tearDownName, new Class[0]);
                                try {
                                    this.tearDownUsing(method);
                                }
                                catch (Exception e) {
                                    PivotTestCaseWithAutoTearDown.fail((String)("Failed to invoke " + ((Object)((Object)this)).getClass().getSimpleName() + "." + tearDownName + " : " + e));
                                }
                            }
                            catch (NoSuchMethodException e) {
                                try {
                                    this.tearDownField(field);
                                }
                                catch (Exception e1) {
                                    PivotTestCaseWithAutoTearDown.fail((String)("Failed to set " + ((Object)((Object)this)).getClass().getSimpleName() + "." + fieldName + " to null : " + e1));
                                }
                            }
                        }
                    } else {
                        this.tearDownStatic(aClass, field);
                    }
                }
                ++n2;
            }
            aClass = aClass.getSuperclass();
        }
    }

    protected @NonNull String getTestBundleName() {
        return (String)ClassUtil.nonNullState((Object)TestProjectManager.class.getPackage().getName());
    }

    protected @NonNull URI getTestBundleURI() {
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            return URI.createPlatformPluginURI((String)("/" + this.getTestBundleName()), (boolean)true);
        }
        return URI.createPlatformResourceURI((String)("/" + this.getTestBundleName()), (boolean)true);
    }

    protected @NonNull URI getTestFileURI(@NonNull String filePath) {
        TestProject testProject = this.getTestProject();
        TestFile outFile = testProject.getOutputFile(filePath);
        return URI.createFileURI((String)outFile.getFile().toString());
    }

    protected @NonNull TestFileSystem getTestFileSystem() {
        TestFileSystem testFileSystem2 = this.testFileSystem;
        if (testFileSystem2 == null) {
            if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
                File testBundleFile = new File(".project");
                assert (!testBundleFile.exists()) : "Default working directory should be the workspace rather than a project: " + testBundleFile.getAbsolutePath();
            }
            this.testFileSystem = testFileSystem2 = TestFileSystem.create(this.getTestFileSystemHelper());
        }
        return testFileSystem2;
    }

    protected @NonNull TestFileSystemHelper getTestFileSystemHelper() {
        return new TestFileSystemHelper();
    }

    protected @NonNull String getTestPackageName() {
        return "test_package";
    }

    protected @NonNull TestProject getTestProject() {
        TestProject testProject2 = this.testProject;
        if (testProject2 == null) {
            String testProjectName = "_OCL_" + ((Object)((Object)this)).getClass().getSimpleName() + "__" + this.getTestName();
            this.testProject = testProject2 = this.getTestFileSystem().getTestProject(testProjectName, true);
        }
        return testProject2;
    }

    protected @NonNull ProjectManager getTestProjectManager() {
        ProjectManager testProjectManager2 = this.testProjectManager;
        if (testProjectManager2 == null) {
            this.testProjectManager = testProjectManager2 = this.getTestProject().createTestProjectManager();
        }
        return testProjectManager2;
    }

    protected @NonNull URI getTestURI(@NonNull String filePath) throws Exception {
        TestProject testProject = this.getTestProject();
        TestFile outFile = testProject.getOutputFile(filePath);
        return outFile.getURI();
    }

    protected void tearDownField(@NonNull Field field) throws IllegalAccessException {
        field.set((Object)this, null);
    }

    protected void tearDownStatic(@NonNull Class<?> aClass, @NonNull Field field) {
        if (aClass != PivotTestSuite.class) {
            PivotTestCaseWithAutoTearDown.fail((String)("static test variable:" + field));
        }
    }

    protected void tearDownUsing(@NonNull Method method) throws IllegalAccessException, InvocationTargetException {
        method.invoke((Object)this, new Object[0]);
    }
}

