/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.tests;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.common.CodeGenHelper;
import org.eclipse.ocl.examples.codegen.dynamic.JavaGenModelCodeGenHelper;
import org.eclipse.ocl.examples.pivot.tests.PivotTestCase;
import org.eclipse.ocl.examples.pivot.tests.PivotTestSuite;
import org.eclipse.ocl.examples.xtext.tests.NoHttpURIHandlerImpl;
import org.eclipse.ocl.examples.xtext.tests.TestFileSystem;
import org.eclipse.ocl.examples.xtext.tests.TestProject;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.ElementExtension;
import org.eclipse.ocl.pivot.Enumeration;
import org.eclipse.ocl.pivot.EnumerationLiteral;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.Namespace;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.PivotTables;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.ids.ElementId;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.context.ClassContext;
import org.eclipse.ocl.pivot.internal.ecore.es2as.Ecore2AS;
import org.eclipse.ocl.pivot.internal.library.ecore.EcoreExecutorManager;
import org.eclipse.ocl.pivot.internal.manager.MetamodelManagerInternal;
import org.eclipse.ocl.pivot.internal.messages.PivotMessagesInternal;
import org.eclipse.ocl.pivot.internal.resource.ASResourceFactoryRegistry;
import org.eclipse.ocl.pivot.internal.resource.EnvironmentFactoryAdapter;
import org.eclipse.ocl.pivot.internal.resource.StandaloneProjectMap;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.OCLInternal;
import org.eclipse.ocl.pivot.library.LibraryUnaryOperation;
import org.eclipse.ocl.pivot.messages.PivotMessages;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.resource.CSResource;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.SemanticException;
import org.eclipse.ocl.pivot.utilities.StringUtil;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.CollectionValue;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.ocl.pivot.values.RealValue;
import org.eclipse.ocl.pivot.values.Value;
import org.eclipse.ocl.xtext.base.utilities.BaseCSResource;
import org.eclipse.xtext.diagnostics.ExceptionDiagnostic;

public class TestOCL
extends OCLInternal {
    protected final @NonNull TestFileSystem testFileSystem;
    private TestProject testProject = null;
    protected final @NonNull String testPackageName;
    protected final @NonNull String testName;
    private int testCounter = 0;

    public TestOCL(@NonNull TestFileSystem testFileSystem, @NonNull String testPackageName, @NonNull String testName, @NonNull ProjectManager projectManager) {
        super(ASResourceFactoryRegistry.INSTANCE.createEnvironmentFactory(projectManager, null));
        this.testFileSystem = testFileSystem;
        ResourceSet resourceSet = this.getResourceSet();
        NoHttpURIHandlerImpl.install(resourceSet);
        this.testPackageName = testPackageName;
        int index = testName.indexOf("[");
        this.testName = index > 0 ? testName.substring(0, index) : testName;
        projectManager.initializeResourceSet(resourceSet);
        EPackage.Registry packageRegistry = resourceSet.getPackageRegistry();
        packageRegistry.put((Object)"http://www.eclipse.org/emf/2002/GenModel", (Object)GenModelPackage.eINSTANCE);
        packageRegistry.put((Object)"http://www.eclipse.org/uml2/2.2.0/GenModel", (Object)org.eclipse.uml2.codegen.ecore.genmodel.GenModelPackage.eINSTANCE);
        URI ecoreURI = URI.createURI((String)"http://www.eclipse.org/emf/2002/Ecore");
        ProjectManager.IPackageDescriptor packageDescriptor = projectManager.getPackageDescriptor(ecoreURI);
        if (packageDescriptor != null) {
            packageDescriptor.configure(resourceSet, StandaloneProjectMap.LoadFirstStrategy.INSTANCE, null);
        }
    }

    public void addSupertype(@NonNull Class aClass, @NonNull Class superClass) {
        aClass.getSuperClasses().add(superClass);
    }

    public void assertBadInvariant(@NonNull java.lang.Class<?> exception, int severity, @Nullable Class contextType, @NonNull String expression, String messageTemplate, Object ... bindings) {
        block10: {
            CSResource resource = null;
            try {
                ClassContext semanticContext = new ClassContext((EnvironmentFactory)this.getEnvironmentFactory(), null, contextType, null);
                resource = semanticContext.createBaseResource(expression);
                PivotUtil.checkResourceErrors((String)StringUtil.bind((String)PivotMessagesInternal.ErrorsInResource, (Object[])new Object[]{expression}), (Resource)resource);
                TestCase.fail((String)("Should not have parsed \"" + expression + "\""));
            }
            catch (ParserException e) {
                TestCase.assertEquals((String)("Exception for \"" + expression + "\""), exception, ((Object)((Object)e)).getClass());
                if (resource != null) {
                    Resource.Diagnostic diagnostic = this.getError((Resource)resource);
                    this.assertNoException(diagnostic, ClassCastException.class);
                    this.assertNoException(diagnostic, NullPointerException.class);
                    String expectedMessage = StringUtil.bind((String)messageTemplate, (Object[])bindings);
                    TestCase.assertEquals((String)("Message for \"" + expression + "\""), (String)expectedMessage, (String)diagnostic.getMessage());
                }
                if (resource != null) {
                    EnvironmentFactoryAdapter.disposeAll((Resource)resource);
                }
                break block10;
            }
            catch (IOException e) {
                try {
                    TestCase.fail((String)e.getMessage());
                    break block10;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (resource != null) {
                        EnvironmentFactoryAdapter.disposeAll(resource);
                    }
                }
            }
            if (resource == null) break block10;
            EnvironmentFactoryAdapter.disposeAll((Resource)resource);
        }
    }

    public void assertBadQuery(@NonNull java.lang.Class<?> exception, int severity, @Nullable Class contextType, @NonNull String expression, String messageTemplate, Object ... bindings) {
        block10: {
            BaseCSResource csResource = null;
            try {
                ClassContext classContext = new ClassContext((EnvironmentFactory)this.getEnvironmentFactory(), null, contextType, null);
                if (PivotMessages.UnspecifiedSelfContext.equals(messageTemplate)) {
                    classContext.setSelfName("SELF");
                }
                csResource = (BaseCSResource)classContext.createBaseResource(expression);
                PivotUtil.checkResourceErrors((String)StringUtil.bind((String)PivotMessagesInternal.ErrorsInResource, (Object[])new Object[]{expression}), (Resource)csResource);
                ASResource asResource = csResource.getASResource();
                PivotTestSuite.assertNoValidationErrors("Validating", (Resource)asResource);
                TestCase.fail((String)("Should not have parsed \"" + expression + "\""));
            }
            catch (ParserException e) {
                TestCase.assertEquals((String)("Exception for \"" + expression + "\""), exception, ((Object)((Object)e)).getClass());
                Resource.Diagnostic diagnostic = this.getError((Resource)csResource);
                String expectedMessage = StringUtil.bind((String)messageTemplate, (Object[])bindings);
                TestCase.assertEquals((String)("Message for \"" + expression + "\""), (String)expectedMessage, (String)diagnostic.getMessage());
                PivotTestSuite.appendLog(this.testName, contextType, expression, expectedMessage, null, null);
                if (csResource != null) {
                    EnvironmentFactoryAdapter.disposeAll((Resource)csResource);
                }
                break block10;
            }
            catch (IOException e) {
                try {
                    TestCase.fail((String)e.getMessage());
                    break block10;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (csResource != null) {
                        EnvironmentFactoryAdapter.disposeAll(csResource);
                    }
                }
            }
            if (csResource == null) break block10;
            EnvironmentFactoryAdapter.disposeAll((Resource)csResource);
        }
    }

    public @Nullable ExpressionInOCL assertInvariant(@NonNull Class context, @NonNull String expression) {
        try {
            ExpressionInOCL result = this.createInvariant((EObject)context, expression);
            return result;
        }
        catch (Exception e) {
            PivotTestSuite.failOn(expression, e);
            return null;
        }
    }

    public @Nullable Object assertInvariantFalse(@Nullable Object context, @NonNull String expression) {
        try {
            Boolean value = this.check(context, expression);
            TestCase.assertEquals((String)expression, (Object)false, (Object)value);
            return value;
        }
        catch (Exception e) {
            PivotTestSuite.failOn(expression, e);
            return null;
        }
    }

    public @Nullable Object assertInvariantTrue(@Nullable Object context, @NonNull String expression) {
        try {
            Object value = this.evaluate(null, context, expression);
            TestCase.assertEquals((String)expression, (Object)true, (Object)value);
            return value;
        }
        catch (Exception e) {
            PivotTestSuite.failOn(expression, e);
            return null;
        }
    }

    public void assertNoException(Resource.Diagnostic diagnostic, java.lang.Class<? extends Throwable> excType) {
        if (diagnostic instanceof ExceptionDiagnostic && excType.isInstance(((ExceptionDiagnostic)diagnostic).getException())) {
            TestCase.fail((String)("Diagnostic signals a(n) " + excType.getSimpleName()));
        }
    }

    public void assertOCLEquals(String message, Object expected, Object actual) {
        IdResolver.IdResolverExtension idResolver = (IdResolver.IdResolverExtension)this.getIdResolver();
        if (idResolver.oclEquals(expected, actual)) {
            int actualHash;
            int expectedHash = idResolver.oclHashCode(expected);
            if (expectedHash == (actualHash = idResolver.oclHashCode(actual))) {
                return;
            }
            PivotTestSuite.failNotEquals((String)(String.valueOf(message) + " badHash"), (Object)expectedHash, (Object)actualHash);
        }
        PivotTestSuite.failNotEquals((String)message, (Object)expected, (Object)actual);
    }

    public void assertOCLNotEquals(String message, Object expected, Object actual) {
        IdResolver idResolver = this.getIdResolver();
        if (!idResolver.oclEquals(expected, actual)) {
            return;
        }
        PivotTestSuite.failSame((String)message);
    }

    public @NonNull ExpressionInOCL assertQuery(Class context, @NonNull String expression) {
        try {
            ExpressionInOCL result = this.createQuery((EObject)context, expression);
            return result;
        }
        catch (Exception e) {
            PivotTestSuite.failOn(expression, e);
            ExpressionInOCL nullReturn = null;
            return nullReturn;
        }
    }

    public Object assertQueryDefined(Object context, @NonNull String expression) {
        try {
            Object value = this.evaluate(null, context, expression);
            TestCase.assertFalse((String)(String.valueOf(expression) + " expected defined: "), (value == null ? 1 : 0) != 0);
            return value;
        }
        catch (Exception e) {
            PivotTestSuite.failOn(expression, e);
            return null;
        }
    }

    public @Nullable Object assertQueryEquals(@Nullable Object context, @Nullable Object expected, @NonNull String expression) {
        try {
            Object expectedValue = expected instanceof Value ? expected : this.getIdResolver().boxedValueOf(expected);
            Object value = this.evaluate(null, context, expression);
            this.assertOCLEquals(expression, expectedValue, value);
            PivotTestSuite.appendLog(this.testName, context, expression, null, expectedValue != null ? expectedValue.toString() : null, null);
            return value;
        }
        catch (Exception e) {
            PivotTestSuite.failOn(expression, e);
            return null;
        }
    }

    public @Nullable Object assertQueryEquals(@Nullable Object context, @NonNull BigDecimal expected, @NonNull BigDecimal delta, @NonNull String expression) {
        try {
            BigDecimal value = (BigDecimal)this.evaluate(null, context, expression);
            TestCase.assertTrue((String)expression, (value.compareTo(expected.add(delta)) >= 0 && value.compareTo(expected.subtract(delta)) >= 0 ? 1 : 0) != 0);
            PivotTestSuite.appendLog(this.testName, context, expression, null, expected.toString(), delta.toString());
            return value;
        }
        catch (Exception e) {
            PivotTestSuite.failOn(expression, e);
            return null;
        }
    }

    public Object assertQueryEquals(Object context, @NonNull Number expected, @NonNull String expression, double tolerance) {
        try {
            IdResolver idResolver = this.getIdResolver();
            Object expectedValue = idResolver.boxedValueOf((Object)expected);
            Object value = this.evaluate(null, context, expression);
            BigDecimal expectedVal = ((RealValue)expectedValue).bigDecimalValue();
            BigDecimal val = ((RealValue)value).bigDecimalValue();
            double delta = val.subtract(expectedVal).doubleValue();
            if (delta < -tolerance || tolerance < delta) {
                TestCase.assertEquals((String)expression, (Object)expected, (Object)value);
            }
            PivotTestSuite.appendLog(this.testName, context, expression, null, expected.toString(), Double.toString(tolerance));
            return value;
        }
        catch (Exception e) {
            PivotTestSuite.failOn(expression, e);
            return null;
        }
    }

    public Object assertQueryFalse(Object context, @NonNull String expression) {
        try {
            Object value = this.evaluate(null, context, expression);
            TestCase.assertEquals((String)expression, (Object)Boolean.FALSE, (Object)value);
            PivotTestSuite.appendLog(this.testName, context, expression, null, "false", null);
            return value;
        }
        catch (Exception e) {
            PivotTestSuite.failOn(expression, e);
            return null;
        }
    }

    public Value assertQueryInvalid(Object context, @NonNull String expression) {
        try {
            Object value = this.evaluateWithoutValidation(null, context, expression);
            TestCase.fail((String)(String.valueOf(expression) + " expected: invalid but was: " + value));
        }
        catch (InvalidValueException e) {
            PivotTestSuite.appendLog(this.testName, context, expression, null, "invalid", null);
        }
        catch (Exception e) {
            PivotTestSuite.failOn(expression, e);
        }
        return null;
    }

    public Object assertQueryInvalid(Object context, @NonNull String expression, String reason, java.lang.Class<?> exceptionClass) {
        block8: {
            try {
                Object value = this.evaluateWithoutValidation(null, context, expression);
                TestCase.fail((String)(String.valueOf(expression) + " expected: invalid but was: " + value));
            }
            catch (InvalidValueException e) {
                Throwable ex = e;
                Throwable cause = e.getCause();
                String message = e.getMessage();
                if (cause != null) {
                    String m;
                    ex = cause;
                    if (!(cause instanceof NumberFormatException) && (m = ex.getMessage()) != null) {
                        message = m;
                    }
                }
                if (reason != null) {
                    TestCase.assertEquals((String)"Invalid Value Reason", (String)reason, (String)message);
                }
                if (exceptionClass != null) {
                    TestCase.assertEquals((String)"Invalid Value Throwable", exceptionClass, ex.getClass());
                }
            }
            catch (Exception e) {
                if (exceptionClass != null && exceptionClass != e.getClass()) {
                    TestCase.assertEquals((String)"Invalid Value Throwable", exceptionClass, (Object)(e.getClass() + " : " + e.getMessage()));
                }
                if (reason == null) break block8;
                TestCase.assertEquals((String)"Invalid Value Reason", (String)reason, (String)e.getMessage());
            }
        }
        return null;
    }

    public @Nullable Object assertQueryNotEquals(@Nullable Object context, @Nullable Object expected, @NonNull String expression) {
        try {
            Object expectedValue = expected instanceof Value ? expected : this.getIdResolver().boxedValueOf(expected);
            Object value = this.evaluate(null, context, expression);
            this.assertOCLNotEquals(expression, expectedValue, value);
            PivotTestSuite.appendLog(this.testName, context, expression, null, expectedValue != null ? expectedValue.toString() : null, null);
            return value;
        }
        catch (Exception e) {
            PivotTestSuite.failOn(expression, e);
            return null;
        }
    }

    public Object assertQueryNotSame(Object context, Object expected, @NonNull String expression) {
        try {
            Object value = this.evaluate(null, context, expression);
            TestCase.assertNotSame((String)expression, (Object)expected, (Object)value);
            return value;
        }
        catch (Exception e) {
            PivotTestSuite.failOn(expression, e);
            return null;
        }
    }

    public Object assertQueryNull(Object context, @NonNull String expression) {
        try {
            Object value = this.evaluate(null, context, expression);
            TestCase.assertEquals((String)expression, null, (Object)value);
            PivotTestSuite.appendLog(this.testName, context, expression, null, "null", null);
            return value;
        }
        catch (Exception e) {
            PivotTestSuite.failOn(expression, e);
            return null;
        }
    }

    public @Nullable Object assertQueryOCLEquals(@Nullable Object context, @Nullable Object expected, @NonNull String expression) {
        try {
            Object value = this.evaluate(null, context, expression);
            this.assertOCLEquals(expression, expected, value);
            PivotTestSuite.appendLog(this.testName, context, expression, null, expected != null ? expected.toString() : null, null);
            return value;
        }
        catch (Exception e) {
            PivotTestSuite.failOn(expression, e);
            return null;
        }
    }

    public @Nullable Object assertQueryOCLNotEquals(@Nullable Object context, @Nullable Object expected, @NonNull String expression) {
        try {
            Object value = this.evaluate(null, context, expression);
            this.assertOCLNotEquals(expression, expected, value);
            PivotTestSuite.appendLog(this.testName, context, expression, null, expected != null ? expected.toString() : null, null);
            return value;
        }
        catch (Exception e) {
            PivotTestSuite.failOn(expression, e);
            return null;
        }
    }

    public Object assertQueryResults(Object context, @NonNull String expectedResultExpression, @NonNull String expression) {
        try {
            Object expectedResultQuery = this.evaluateLocal(context, expectedResultExpression);
            Object result = this.assertQueryEquals(context, expectedResultQuery, expression);
            PivotTestSuite.appendLog(this.testName, context, expression, null, expectedResultExpression, null);
            return result;
        }
        catch (Exception e) {
            PivotTestSuite.failOn(expectedResultExpression, e);
            return null;
        }
    }

    public Object assertQueryTrue(Object context, @NonNull String expression) {
        try {
            Object value = this.evaluate(null, context, expression);
            TestCase.assertEquals((String)expression, (Object)Boolean.TRUE, (Object)value);
            PivotTestSuite.appendLog(this.testName, context, expression, null, "true", null);
            return value;
        }
        catch (Exception e) {
            PivotTestSuite.failOn(expression, e);
            return null;
        }
    }

    public Object assertQueryUnlimited(Object context, @NonNull String expression) {
        try {
            Object value = this.evaluate(null, context, expression);
            if (!ValueUtil.isUnlimited((Object)value)) {
                TestCase.assertEquals((String)expression, (Object)ValueUtil.UNLIMITED_VALUE, (Object)value);
            }
            PivotTestSuite.appendLog(this.testName, context, expression, null, "*", null);
            return value;
        }
        catch (Exception e) {
            PivotTestSuite.failOn(expression, e);
            return null;
        }
    }

    public Object assertResultContainsAll(Object context, @NonNull CollectionValue expectedResult, @NonNull String expression) {
        try {
            Object result = this.evaluate(null, context, expression);
            TestCase.assertTrue((boolean)expectedResult.getClass().isInstance(result));
            TestCase.assertSame((Object)expectedResult.intSize(), (Object)((CollectionValue)result).intSize());
            Boolean actualResult = ((CollectionValue)result).includesAll(expectedResult);
            TestCase.assertTrue((String)("Expected " + result + " to contain " + expectedResult), (actualResult == ValueUtil.TRUE_VALUE ? 1 : 0) != 0);
            return result;
        }
        catch (Exception e) {
            PivotTestSuite.failOn(expression, e);
            return null;
        }
    }

    public Object assertResultContainsAll(Object context, @NonNull String expectedResultExpression, @NonNull String expression) {
        try {
            Object expectedResultQuery = this.evaluateLocal(null, expectedResultExpression);
            TestCase.assertTrue((boolean)(expectedResultQuery instanceof CollectionValue));
            Object result = this.assertResultContainsAll(context, (CollectionValue)expectedResultQuery, expression);
            return result;
        }
        catch (Exception e) {
            PivotTestSuite.failOn(expectedResultExpression, e);
            return null;
        }
    }

    public void assertSemanticErrorQuery(@Nullable Class contextType, @NonNull String expression, String messageTemplate, Object ... bindings) {
        this.assertBadQuery(SemanticException.class, 4, contextType, expression, messageTemplate, bindings);
    }

    public void assertSemanticWarningQuery(@Nullable Class contextType, @NonNull String expression, String messageTemplate, Object ... bindings) {
        block11: {
            BaseCSResource csResource = null;
            try {
                ClassContext classContext = new ClassContext((EnvironmentFactory)this.getEnvironmentFactory(), null, contextType, null);
                if (PivotMessages.UnspecifiedSelfContext.equals(messageTemplate)) {
                    classContext.setSelfName("SELF");
                }
                csResource = (BaseCSResource)classContext.createBaseResource(expression);
                PivotUtil.checkResourceErrors((String)StringUtil.bind((String)PivotMessagesInternal.ErrorsInResource, (Object[])new Object[]{expression}), (Resource)csResource);
                PivotUtil.checkResourceWarnings((String)StringUtil.bind((String)PivotMessagesInternal.ErrorsInResource, (Object[])new Object[]{expression}), (Resource)csResource);
                ASResource asResource = csResource.getASResource();
                PivotTestSuite.assertNoValidationErrors("Validating", (Resource)asResource);
                TestCase.fail((String)("Should not have parsed \"" + expression + "\""));
            }
            catch (ParserException e) {
                TestCase.assertEquals((String)("Exception for \"" + expression + "\""), SemanticException.class, ((Object)((Object)e)).getClass());
                assert (csResource != null);
                Resource.Diagnostic diagnostic = this.getWarning((Resource)csResource);
                String expectedMessage = StringUtil.bind((String)messageTemplate, (Object[])bindings);
                TestCase.assertEquals((String)("Message for \"" + expression + "\""), (String)expectedMessage, (String)diagnostic.getMessage());
                PivotTestSuite.appendLog(this.testName, contextType, expression, expectedMessage, null, null);
                if (csResource != null) {
                    EnvironmentFactoryAdapter.disposeAll((Resource)csResource);
                }
                break block11;
            }
            catch (IOException e) {
                try {
                    TestCase.fail((String)e.getMessage());
                    break block11;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (csResource != null) {
                        EnvironmentFactoryAdapter.disposeAll(csResource);
                    }
                }
            }
            if (csResource == null) break block11;
            EnvironmentFactoryAdapter.disposeAll((Resource)csResource);
        }
    }

    public void assertValidQuery(@NonNull Class contextType, @NonNull String expression) throws Exception {
        ExpressionInOCL query = this.createQuery((EObject)contextType, expression);
        PivotTestCase.assertNoValidationErrors(expression, (EObject)query);
    }

    public void assertValidationErrorQuery(@Nullable Class contextType, @NonNull String expression, String messageTemplate, Object ... bindings) {
        block8: {
            BaseCSResource csResource = null;
            try {
                try {
                    ClassContext classContext = new ClassContext((EnvironmentFactory)this.getEnvironmentFactory(), null, contextType, null);
                    csResource = (BaseCSResource)classContext.createBaseResource(expression);
                    PivotUtil.checkResourceErrors((String)StringUtil.bind((String)PivotMessagesInternal.ErrorsInResource, (Object[])new Object[]{expression}), (Resource)csResource);
                    ASResource asResource = csResource.getASResource();
                    String expectedMessage = StringUtil.bind((String)messageTemplate, (Object[])bindings);
                    PivotTestSuite.assertValidationDiagnostics("Validating", (Resource)asResource, PivotTestCase.getMessages(expectedMessage));
                    PivotTestSuite.appendLog(this.testName, contextType, expression, expectedMessage, null, null);
                }
                catch (Exception e) {
                    TestCase.fail((String)e.getMessage());
                    if (csResource != null) {
                        EnvironmentFactoryAdapter.disposeAll(csResource);
                    }
                    break block8;
                }
            }
            catch (Throwable throwable) {
                if (csResource != null) {
                    EnvironmentFactoryAdapter.disposeAll(csResource);
                }
                throw throwable;
            }
            if (csResource != null) {
                EnvironmentFactoryAdapter.disposeAll((Resource)csResource);
            }
        }
    }

    public boolean check(Object context, @NonNull String expression) throws ParserException {
        MetamodelManagerInternal metamodelManager = this.getMetamodelManager();
        Class contextType = this.getContextType(context);
        ExpressionInOCL constraint = this.createInvariant((EObject)contextType, expression);
        if (constraint.getOwnedBody().getType() != metamodelManager.getStandardLibrary().getBooleanType()) {
            throw new IllegalArgumentException("constraint is not boolean");
        }
        try {
            Object result = this.evaluate(constraint, context);
            return result == ValueUtil.TRUE_VALUE;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void createDocument(String text) {
        throw new UnsupportedOperationException();
    }

    public void createGeneralization(Class special, Class general) {
        special.getSuperClasses().add(general);
    }

    public Property createOwnedAttribute(Class aClass, String name, Type type) {
        Property eAttribute = PivotFactory.eINSTANCE.createProperty();
        eAttribute.setName(name);
        eAttribute.setType(type);
        aClass.getOwnedProperties().add(eAttribute);
        return eAttribute;
    }

    public @NonNull Class createOwnedClass(Package aPackage, String name, boolean isAbstract) {
        Class eClass = PivotFactory.eINSTANCE.createClass();
        eClass.setName(name);
        eClass.setIsAbstract(isAbstract);
        aPackage.getOwnedClasses().add(eClass);
        return eClass;
    }

    public Enumeration createOwnedEnumeration(Package aPackage, String name) {
        Enumeration eEnum = PivotFactory.eINSTANCE.createEnumeration();
        eEnum.setName(name);
        aPackage.getOwnedClasses().add(eEnum);
        return eEnum;
    }

    public EnumerationLiteral createOwnedLiteral(Enumeration anEnumeration, String name) {
        EnumerationLiteral eLiteral = PivotFactory.eINSTANCE.createEnumerationLiteral();
        eLiteral.setName(name);
        anEnumeration.getOwnedLiterals().add(eLiteral);
        return eLiteral;
    }

    public Operation createOwnedOperation(Class aClass, String name, List<String> paramNames, List<Type> paramTypes, Type type, boolean isQuery) {
        Operation eOperation = PivotFactory.eINSTANCE.createOperation();
        eOperation.setName(name);
        eOperation.setType(type);
        if (paramNames != null) {
            int i = 0;
            while (i < paramNames.size()) {
                this.createOwnedParameter(eOperation, paramNames.get(i), paramTypes.get(i));
                ++i;
            }
        }
        aClass.getOwnedOperations().add(eOperation);
        return eOperation;
    }

    public Parameter createOwnedParameter(Operation eOperation, String name, Type type) {
        Parameter eParameter = PivotFactory.eINSTANCE.createParameter();
        eParameter.setName(name);
        eParameter.setType(type);
        eOperation.getOwnedParameters().add(eParameter);
        return eParameter;
    }

    public Property createOwnedReference(Class aClass, String name, Class type) {
        Property eReference = PivotFactory.eINSTANCE.createProperty();
        eReference.setName(name);
        eReference.setType((Type)type);
        aClass.getOwnedProperties().add(eReference);
        return eReference;
    }

    public @Nullable Object evaluate(Object unusedHelper, @Nullable Object context, @NonNull String expression) throws Exception {
        MetamodelManagerInternal metamodelManager = this.getMetamodelManager();
        Class classContext = this.getContextType(context);
        ClassContext parserContext = new ClassContext((EnvironmentFactory)this.getEnvironmentFactory(), null, classContext, context instanceof Type && !(context instanceof ElementExtension) ? (Type)context : null);
        ExpressionInOCL query = parserContext.parse((EObject)classContext, expression);
        PivotTestSuite.assertNoValidationErrors(expression, (EObject)query);
        try {
            Object object = this.evaluate(query, context);
            return object;
        }
        finally {
            metamodelManager.getASResourceSet().getResources().remove((Object)query.eResource());
        }
    }

    public @Nullable Object evaluate(@NonNull ExpressionInOCL expr, @Nullable Object self) throws Exception {
        Object result = null;
        if (!PivotTestSuite.useCodeGen) {
            result = super.evaluate(self, expr);
        } else {
            CodeGenHelper genModelHelper = this.getCodeGenHelper(this.getEnvironmentFactory());
            String packagePath = String.valueOf(this.testPackageName) + "/" + this.testName;
            String packageName = String.valueOf(this.testPackageName) + "." + this.testName;
            if (this.testProject == null) {
                this.testProject = this.testFileSystem.getTestProject("_OCLtests", false);
                this.testProject.getOutputFile("test-src/" + packagePath).getFile().mkdirs();
                this.testProject.getOutputFile("test-bin/" + packagePath).getFile().mkdirs();
            }
            File targetFolder = this.testProject.getOutputFile("test-src").getFile();
            String className = "TestClass" + this.testCounter++;
            LibraryUnaryOperation.LibraryUnaryOperationExtension testInstance = (LibraryUnaryOperation.LibraryUnaryOperationExtension)genModelHelper.loadClass(expr, targetFolder, packageName, className, true);
            assert (testInstance != null);
            EcoreExecutorManager executor = new EcoreExecutorManager(self, PivotTables.LIBRARY);
            OperationCallExp callExp = PivotFactory.eINSTANCE.createOperationCallExp();
            callExp.setType(expr.getType());
            result = testInstance.evaluate((Executor)executor, callExp.getTypeId(), self);
        }
        return result;
    }

    public @Nullable Object evaluateLocal(@Nullable Object context, @NonNull String expression) throws Exception {
        MetamodelManagerInternal metamodelManager = this.getMetamodelManager();
        Class contextType = this.getContextType(context);
        ExpressionInOCL query = this.createQuery((EObject)contextType, expression);
        try {
            Object object = this.evaluate(context, query);
            return object;
        }
        finally {
            metamodelManager.getASResourceSet().getResources().remove((Object)query.eResource());
        }
    }

    public @Nullable Object evaluateWithoutValidation(@Nullable Object unusedHelper, @Nullable Object context, @NonNull String expression) throws Exception {
        MetamodelManagerInternal metamodelManager = this.getMetamodelManager();
        Class contextType = this.getContextType(context);
        ExpressionInOCL query = this.createQuery((EObject)contextType, expression);
        try {
            Object object = this.evaluate(query, context);
            return object;
        }
        finally {
            metamodelManager.getASResourceSet().getResources().remove((Object)query.eResource());
        }
    }

    public CodeGenHelper getCodeGenHelper(@NonNull EnvironmentFactoryInternal environmentFactory) throws IOException {
        URI genModelURI = URI.createPlatformResourceURI((String)"/org.eclipse.ocl.pivot/model/Pivot.genmodel", (boolean)true);
        ResourceSet resourceSet = this.getResourceSet();
        Resource genModelResource = resourceSet.getResource(genModelURI, true);
        String errorsString = PivotUtil.formatResourceDiagnostics((List)genModelResource.getErrors(), (String)("Loading " + genModelURI), (String)"\n");
        if (errorsString != null) {
            return null;
        }
        GenModel genModel = (GenModel)genModelResource.getContents().get(0);
        return new JavaGenModelCodeGenHelper(genModel, environmentFactory);
    }

    public @NonNull Type getCollectionType(@NonNull String collectionName, @NonNull Type type, boolean isNullFree) {
        MetamodelManagerInternal metamodelManager = this.getMetamodelManager();
        Class collectionType = metamodelManager.getCollectionType(collectionName, type, isNullFree, null, null);
        metamodelManager.addLockedElement((Object)collectionType);
        return collectionType;
    }

    @Deprecated
    public Resource.Diagnostic getDiagnostic(@NonNull Resource resource) {
        return this.getError(resource);
    }

    public @NonNull Value getEmptyBagValue() {
        return this.getIdResolver().createBagOfEach(TypeId.BAG.getSpecializedId(new ElementId[]{TypeId.OCL_VOID}), new Object[0]);
    }

    public @NonNull Value getEmptyOrderedSetValue() {
        return this.getIdResolver().createOrderedSetOfEach(TypeId.ORDERED_SET.getSpecializedId(new ElementId[]{TypeId.OCL_VOID}), new Object[0]);
    }

    public @NonNull Value getEmptySequenceValue() {
        return this.getIdResolver().createSequenceOfEach(TypeId.SEQUENCE.getSpecializedId(new ElementId[]{TypeId.OCL_VOID}), new Object[0]);
    }

    public @NonNull Value getEmptySetValue() {
        return this.getIdResolver().createSetOfEach(TypeId.SET.getSpecializedId(new ElementId[]{TypeId.OCL_VOID}), new Object[0]);
    }

    public Resource.Diagnostic getError(@NonNull Resource resource) {
        Resource.Diagnostic diagnostic = (Resource.Diagnostic)resource.getErrors().get(0);
        return diagnostic;
    }

    public @NonNull Package getUMLMetamodel() {
        MetamodelManagerInternal metamodelManager = this.getMetamodelManager();
        return (Package)ClassUtil.nonNullState((Object)metamodelManager.getASmetamodel());
    }

    public Resource.Diagnostic getWarning(@NonNull Resource resource) {
        TestCase.assertTrue((boolean)resource.getErrors().isEmpty());
        Resource.Diagnostic diagnostic = (Resource.Diagnostic)resource.getWarnings().get(0);
        return diagnostic;
    }

    public void loadEPackage(@NonNull String alias, EPackage ePackage) {
        Element ecoreElement = Ecore2AS.importFromEcore((EnvironmentFactoryInternal)this.getEnvironmentFactory(), (String)alias, (EObject)ePackage);
        this.getMetamodelManager().addGlobalNamespace(alias, (Namespace)ecoreElement);
    }

    public @NonNull Package registerPackage(@NonNull Package pkg, @NonNull String nsPrefix, @NonNull String nsUri) {
        pkg.setNsPrefix(nsPrefix);
        pkg.setURI(nsUri);
        ResourceImpl resource = new ResourceImpl(URI.createURI((String)nsUri));
        resource.getContents().add((Object)pkg);
        this.getResourceSet().getResources().add((Object)resource);
        this.getResourceSet().getPackageRegistry().put((Object)nsUri, (Object)pkg);
        return pkg;
    }
}

