/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.test.xtext;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.debug.core.OCLDebugTarget;
import org.eclipse.ocl.examples.debug.vm.core.VMVariable;
import org.eclipse.ocl.examples.test.xtext.AbstractConsoleTests;
import org.eclipse.ocl.examples.xtext.tests.TestUIUtil;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.NullLiteralExp;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.PropertyCallExp;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ui.internal.Workbench;

public class ConsoleTests
extends AbstractConsoleTests {
    public void testConsole_oclLog() throws Exception {
        ConsoleTests.assertConsoleResult(this.consolePage, null, "7", "7\n");
        ConsoleTests.assertConsoleResult(this.consolePage, null, "7.oclLog('seven = ')", "seven = 7\n7\n");
    }

    public void testConsole_debugger() throws Exception {
        if (Boolean.getBoolean("TYCHO_TEST")) {
            System.err.println(String.valueOf(this.getName()) + " has been disabled -see Bug 526252");
            return;
        }
        ILaunch launch = null;
        try {
            try {
                TestUIUtil.enableSwitchToDebugPerspectivePreference();
                ConsoleTests.assertConsoleResult(this.consolePage, (EObject)EcorePackage.Literals.ECLASS, "self.name <> null", "true\n");
                launch = this.consolePage.launchDebugger();
                ConsoleTests.assertNotNull((Object)launch);
                Map attributes = launch.getLaunchConfiguration().getAttributes();
                ExpressionInOCL asExpressionInOCL = (ExpressionInOCL)attributes.get("expressionObject");
                assert (asExpressionInOCL != null);
                OperationCallExp asOperationCallExp = (OperationCallExp)asExpressionInOCL.getOwnedBody();
                PropertyCallExp asPropertyCallExpCallExp = (PropertyCallExp)asOperationCallExp.getOwnedSource();
                VariableExp asVariableExp = (VariableExp)asPropertyCallExpCallExp.getOwnedSource();
                NullLiteralExp asNullLiteralExp = (NullLiteralExp)asOperationCallExp.getOwnedArguments().get(0);
                OCLDebugTarget debugTarget = (OCLDebugTarget)launch.getDebugTarget();
                IThread vmThread = debugTarget.getThreads()[0];
                assert (vmThread != null);
                TestUIUtil.waitForSuspended(vmThread);
                this.checkPosition(vmThread, 5, 112, 116);
                this.checkVariables(vmThread, "$pc", "self");
                this.checkVariable(vmThread, "$pc", asVariableExp);
                this.checkVariable(vmThread, "self", EcorePackage.Literals.ECLASS);
                vmThread.stepInto();
                TestUIUtil.waitForSuspended(vmThread);
                this.checkPosition(vmThread, 5, 117, 121);
                this.checkVariables(vmThread, "$pc", "self", "$ownedSource");
                this.checkVariable(vmThread, "$pc", asPropertyCallExpCallExp);
                this.checkVariable(vmThread, "self", EcorePackage.Literals.ECLASS);
                this.checkVariable(vmThread, "$ownedSource", EcorePackage.Literals.ECLASS);
                vmThread.stepInto();
                TestUIUtil.waitForSuspended(vmThread);
                this.checkPosition(vmThread, 5, 125, 129);
                this.checkVariables(vmThread, "$pc", "self");
                this.checkVariable(vmThread, "$pc", asNullLiteralExp);
                this.checkVariable(vmThread, "self", EcorePackage.Literals.ECLASS);
                vmThread.stepInto();
                TestUIUtil.waitForSuspended(vmThread);
                this.checkPosition(vmThread, 5, 122, 124);
                this.checkVariables(vmThread, "$pc", "self", "$ownedSource", "$ownedArguments[0]");
                this.checkVariable(vmThread, "$pc", asOperationCallExp);
                this.checkVariable(vmThread, "self", EcorePackage.Literals.ECLASS);
                this.checkVariable(vmThread, "$ownedSource", "EClass");
                this.checkVariable(vmThread, "$ownedArguments[0]", null);
                vmThread.stepInto();
                TestUIUtil.waitForSuspended(vmThread);
                this.checkPosition(vmThread, 5, 112, 129);
                this.checkVariables(vmThread, "$pc", "self", "$ownedBody");
                this.checkVariable(vmThread, "$pc", asExpressionInOCL);
                this.checkVariable(vmThread, "self", EcorePackage.Literals.ECLASS);
                this.checkVariable(vmThread, "$ownedBody", true);
                vmThread.stepInto();
                TestUIUtil.waitForTerminated(vmThread);
            }
            catch (Throwable e) {
                if (launch != null) {
                    launch.terminate();
                    TestUIUtil.wait(1000);
                }
                throw e;
            }
        }
        finally {
            ILaunch[] launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
            TestUIUtil.removeTerminatedLaunches(launches);
            Workbench.getInstance().getActiveWorkbenchWindow().getActivePage().closeAllEditors(false);
            TestUIUtil.wait(1000);
        }
    }

    public void testConsole_printCollections_474933() {
        ConsoleTests.assertConsoleResult(this.consolePage, null, "Set{}", "");
        ConsoleTests.assertConsoleResult(this.consolePage, null, "Set{1}", "1\n");
        ConsoleTests.assertConsoleResult(this.consolePage, null, "OrderedSet{1, 2, 3}", "1\n2\n3\n");
        ConsoleTests.assertConsoleResult(this.consolePage, null, "Set{Set{}}", "Set{}\n");
        ConsoleTests.assertConsoleResult(this.consolePage, null, "Sequence{OrderedSet{42, 314}, OrderedSet{271}}", "OrderedSet{42,314}\nOrderedSet{271}\n");
        ConsoleTests.assertConsoleResult(this.consolePage, null, "OrderedSet{Sequence{Bag{2, 2}, Bag{3}, Bag{4, 4, 4}}, Sequence{Bag{5}}, Sequence{Bag{}, Bag{5, 5}}, Sequence{Bag{4}}}", "Sequence{Bag{2,2},Bag{3},Bag{4,4,4}}\nSequence{Bag{5}}\nSequence{Bag{},Bag{5,5}}\nSequence{Bag{4}}\n");
    }

    private void checkPosition(@NonNull IThread vmThread, int lineNumber, int charStart, int charEnd) throws DebugException {
        IStackFrame topStackFrame = vmThread.getTopStackFrame();
        ConsoleTests.assertEquals((String)"lineNumber", (int)lineNumber, (int)topStackFrame.getLineNumber());
        ConsoleTests.assertEquals((String)"charStart", (int)charStart, (int)topStackFrame.getCharStart());
        ConsoleTests.assertEquals((String)"charEnd", (int)charEnd, (int)topStackFrame.getCharEnd());
    }

    private void checkVariable(@NonNull IThread vmThread, @NonNull String name, @Nullable Object expectedValue) throws DebugException {
        IStackFrame topStackFrame = vmThread.getTopStackFrame();
        IVariable[] variables = topStackFrame.getVariables();
        if (variables != null) {
            IVariable[] iVariableArray = variables;
            int n = variables.length;
            int n2 = 0;
            while (n2 < n) {
                IVariable variable = iVariableArray[n2];
                if (name.equals(variable.getName()) && variable instanceof VMVariable) {
                    Object valueObject = ((VMVariable)variable).getVmVar().valueObject;
                    ConsoleTests.assertEquals((Object)expectedValue, (Object)valueObject);
                    return;
                }
                ++n2;
            }
        }
        ConsoleTests.fail((String)("Unknown variable '" + name + "'"));
    }

    private void checkVariables(@NonNull IThread vmThread, String ... names) throws DebugException {
        ArrayList<String> expectedNames = new ArrayList<String>();
        if (names != null) {
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                expectedNames.add(name);
                ++n2;
            }
        }
        Collections.sort(expectedNames);
        IStackFrame topStackFrame = vmThread.getTopStackFrame();
        IVariable[] variables = topStackFrame.getVariables();
        ArrayList<String> actualNames = new ArrayList<String>();
        if (variables != null) {
            IVariable[] iVariableArray = variables;
            int n = variables.length;
            int n3 = 0;
            while (n3 < n) {
                IVariable variable = iVariableArray[n3];
                actualNames.add(variable.getName());
                ++n3;
            }
        }
        Collections.sort(actualNames);
        ConsoleTests.assertEquals(expectedNames, actualNames);
    }
}

