/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.test.xtext;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.common.internal.options.CommonOptions;
import org.eclipse.ocl.examples.pivot.tests.TestOCL;
import org.eclipse.ocl.examples.xtext.tests.TestUtil;
import org.eclipse.ocl.examples.xtext.tests.XtextTestCase;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.CompletePackage;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.Import;
import org.eclipse.ocl.pivot.LanguageExpression;
import org.eclipse.ocl.pivot.Library;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.Namespace;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.internal.ecore.as2es.AS2Ecore;
import org.eclipse.ocl.pivot.internal.ecore.es2as.Ecore2AS;
import org.eclipse.ocl.pivot.internal.manager.MetamodelManagerInternal;
import org.eclipse.ocl.pivot.internal.messages.PivotMessagesInternal;
import org.eclipse.ocl.pivot.internal.resource.AS2ID;
import org.eclipse.ocl.pivot.internal.resource.ASResourceFactoryRegistry;
import org.eclipse.ocl.pivot.internal.resource.StandaloneProjectMap;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.External2AS;
import org.eclipse.ocl.pivot.messages.StatusCodes;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.uml.UMLStandaloneSetup;
import org.eclipse.ocl.pivot.uml.internal.es2as.UML2AS;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.MetamodelManager;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.utilities.StringUtil;
import org.eclipse.ocl.pivot.utilities.XMIUtil;
import org.eclipse.ocl.pivot.values.Unlimited;
import org.eclipse.ocl.xtext.base.cs2as.CS2AS;
import org.eclipse.ocl.xtext.base.utilities.BaseCSResource;
import org.eclipse.ocl.xtext.completeoclcs.CompleteOCLDocumentCS;
import org.eclipse.ocl.xtext.essentialocl.EssentialOCLStandaloneSetup;
import org.eclipse.ocl.xtext.oclstdlib.scoping.JavaClassScope;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.resources.util.UMLResourcesUtil;
import org.eclipse.xtext.diagnostics.IDiagnosticConsumer;
import org.eclipse.xtext.resource.impl.ListBasedDiagnosticConsumer;

public class LoadTests
extends XtextTestCase {
    protected static final @NonNull String @NonNull [] NO_MESSAGES = new String[0];

    public @NonNull TestOCL createOCL() {
        return new TestOCL(this.getTestFileSystem(), "LoadTests", this.getName(), OCL.NO_PROJECTS);
    }

    public @NonNull TestOCL createOCLWithProjectMap() {
        return new TestOCL(this.getTestFileSystem(), "LoadTests", this.getName(), (ProjectManager)LoadTests.getProjectMap());
    }

    public Resource doLoad(@NonNull OCL ocl, String stem, String extension) throws IOException {
        String inputName = String.valueOf(stem) + "." + extension;
        URI inputURI = this.getProjectFileURI(inputName);
        return this.doLoad(ocl, inputURI, stem, extension);
    }

    public Resource doLoad(@NonNull OCL ocl, @NonNull URI inputURI, String stem, String extension) throws IOException {
        String outputName = String.valueOf(stem) + "." + extension + ".xmi";
        String output2Name = String.valueOf(stem) + ".saved." + extension;
        URI outputURI = this.getProjectFileURI(outputName);
        URI output2URI = this.getProjectFileURI(output2Name);
        Resource resource = null;
        try {
            CS2AS cs2as;
            resource = ocl.getResourceSet().getResource(inputURI, true);
            LoadTests.assertNoResourceErrors("Load failed", resource);
            LoadTests.assertNoUnresolvedProxies("Unresolved proxies", resource);
            if (resource.getContents().size() > 0) {
                LoadTests.assertNoValidationErrors("Validation errors", (EObject)resource.getContents().get(0));
            }
            if (resource instanceof BaseCSResource && (cs2as = ((BaseCSResource)resource).findCS2AS()) != null) {
                ASResource asResource = cs2as.getASResource();
                LoadTests.assertNoValidationErrors("Loaded pivot", (Resource)asResource);
            }
            resource.setURI(output2URI);
            resource.save(XMIUtil.createSaveOptions());
            LoadTests.assertNoResourceErrors("Save failed", resource);
        }
        finally {
            if (resource instanceof BaseCSResource) {
                ((BaseCSResource)resource).dispose();
            }
        }
        Resource xmiResource = ocl.getResourceSet().createResource(outputURI);
        xmiResource.getContents().addAll((Collection)resource.getContents());
        return xmiResource;
    }

    public Resource doLoad_OCL(@NonNull OCL ocl, URI inputURI) throws IOException {
        ResourceSet resourceSet = ocl.getResourceSet();
        LoadTests.getProjectMap().initializeResourceSet(resourceSet);
        String extension = inputURI.fileExtension();
        String stem = inputURI.trimFileExtension().lastSegment();
        String outputName = String.valueOf(stem) + "." + extension + ".xmi";
        String output2Name = String.valueOf(stem) + ".saved." + extension;
        URI outputURI = this.getProjectFileURI(outputName);
        URI output2URI = this.getProjectFileURI(output2Name);
        BaseCSResource xtextResource = null;
        try {
            xtextResource = (BaseCSResource)resourceSet.getResource(inputURI, true);
            LoadTests.assertNoResourceErrors("Load failed", (Resource)xtextResource);
            LoadTests.assertNoUnresolvedProxies("Unresolved proxies", (Resource)xtextResource);
            LoadTests.assertNoValidationErrors("Validation errors", (EObject)xtextResource.getContents().get(0));
            xtextResource.setURI(output2URI);
            xtextResource.save(XMIUtil.createSaveOptions());
            LoadTests.assertNoResourceErrors("Save failed", (Resource)xtextResource);
            CS2AS cs2as = xtextResource.findCS2AS();
            if (cs2as != null) {
                ASResource asResource = cs2as.getASResource();
                LoadTests.assertNoValidationErrors("Loaded pivot", (Resource)asResource);
            }
        }
        finally {
            xtextResource.dispose();
        }
        Resource xmiResource = resourceSet.createResource(outputURI);
        xmiResource.getContents().addAll((Collection)xtextResource.getContents());
        return xmiResource;
    }

    public void doLoadEcore(@NonNull OCL ocl, @NonNull ResourceSet resourceSet, URI inputURI) throws IOException {
        String extension = inputURI.fileExtension();
        String stem = inputURI.trimFileExtension().lastSegment();
        String output2Name = String.valueOf(stem) + ".saved." + extension;
        URI output2URI = this.getProjectFileURI(output2Name);
        Resource ecoreResource = null;
        ecoreResource = resourceSet.getResource(inputURI, true);
        EcoreUtil.resolveAll((Resource)ecoreResource);
        LoadTests.assertNoResourceErrors("Load failed", ecoreResource);
        LoadTests.assertNoUnresolvedProxies("Unresolved proxies", ecoreResource);
        LoadTests.assertNoValidationErrors("Validation errors", (EObject)ecoreResource.getContents().get(0));
        ecoreResource.setURI(output2URI);
        ecoreResource.save(XMIUtil.createSaveOptions());
        LoadTests.assertNoResourceErrors("Save failed", ecoreResource);
        ecoreResource.setURI(inputURI);
    }

    public Model doLoadUML(@NonNull OCL ocl, @NonNull URI inputURI, boolean ignoreNonExistence, boolean validateEmbeddedOCL, @NonNull String @Nullable [] validateCompleteOCLMessages, @NonNull String @Nullable [] messages) throws IOException, ParserException {
        return this.doLoadUML(ocl, inputURI, new AbstractLoadCallBack(ignoreNonExistence, validateCompleteOCLMessages, validateEmbeddedOCL), messages);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public Model doLoadUML(@NonNull OCL ocl, @NonNull URI inputURI, @NonNull ILoadCallBack loadCallBacks, @NonNull String @Nullable [] messages) throws IOException, ParserException {
        UMLStandaloneSetup.init();
        ResourceSet resourceSet = ocl.getResourceSet();
        UMLResourcesUtil.init((ResourceSet)resourceSet);
        LoadTests.getProjectMap().initializeResourceSet(resourceSet);
        if (!resourceSet.getURIConverter().exists(inputURI, null)) {
            if (loadCallBacks.ignoreNonExistence()) {
                return null;
            }
            TestCase.fail((String)("No such resource + '" + inputURI + "'"));
        }
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            ProjectManager.IProjectDescriptor projectDescriptor = LoadTests.getProjectMap().getProjectDescriptor("org.eclipse.uml2.uml");
            projectDescriptor.initializeURIMap(URIConverter.URI_MAP);
        }
        String extension = inputURI.fileExtension();
        String stem = inputURI.trimFileExtension().lastSegment();
        String output2Name = String.valueOf(stem) + ".saved." + extension;
        String oclName = String.valueOf(stem) + ".ocl";
        URI output2URI = this.getProjectFileURI(output2Name);
        URI oclURI = this.getProjectFileURI(oclName);
        EnvironmentFactoryInternal environmentFactory = (EnvironmentFactoryInternal)ocl.getEnvironmentFactory();
        Resource umlResource = null;
        try {
            Resource asResource3;
            umlResource = resourceSet.getResource(inputURI, true);
            LoadTests.assertNoResourceErrors("Load failed", umlResource);
            LoadTests.assertNoUnresolvedProxies("Unresolved proxies", umlResource);
            umlResource.setURI(output2URI);
            umlResource.save(XMIUtil.createSaveOptions());
            LoadTests.assertNoResourceErrors("Save failed", umlResource);
            umlResource.setURI(inputURI);
            UML2AS adapter = UML2AS.getAdapter((Resource)umlResource, (EnvironmentFactoryInternal)environmentFactory);
            UML2AS.Outer rootAdapter = adapter.getRoot();
            Model pivotModel = rootAdapter.getASModel();
            ArrayList<Resource> allResources = new ArrayList<Resource>();
            allResources.add(pivotModel.eResource());
            List importedResources = rootAdapter.getImportedResources();
            if (importedResources != null) {
                for (Resource uResource : importedResources) {
                    External2AS anAdapter = UML2AS.findAdapter((Resource)uResource, (EnvironmentFactoryInternal)environmentFactory);
                    if (anAdapter == null) {
                        anAdapter = UML2AS.getAdapter((Resource)uResource, (EnvironmentFactoryInternal)environmentFactory);
                    }
                    Model asModel = anAdapter.getASModel();
                    Resource asResource2 = asModel.eResource();
                    allResources.add(asResource2);
                }
            }
            int exceptions = 0;
            StringBuilder s = new StringBuilder();
            s.append("Parsing errors");
            for (Resource asResource3 : allResources) {
                LoadTests.assertNoResourceErrors("Load failed", asResource3);
            }
            asResource3 = (ASResource)allResources.get(0);
            URI savedURI = asResource3.getURI();
            TreeIterator tit = asResource3.getAllContents();
            while (tit.hasNext()) {
                EObject eObject = (EObject)tit.next();
                if (!(eObject instanceof Constraint)) continue;
                Constraint constraint = (Constraint)eObject;
                try {
                    loadCallBacks.validateEmbeddedOCL(ocl, constraint);
                }
                catch (ParserException e) {
                    System.out.println("\n" + constraint);
                    System.out.println((Object)e);
                    ++exceptions;
                    s.append("\n" + (Object)((Object)e) + "\n");
                }
            }
            LoadTests.assertValidationDiagnostics("Overall validation", asResource3, messages);
            LoadTests.assertEquals((String)s.toString(), (int)0, (int)exceptions);
            loadCallBacks.postLoad(ocl, (ASResource)asResource3);
            ASResource oclResource = (ASResource)allResources.get(0);
            if (oclResource != null) {
                URI xtextURI = oclURI;
                ResourceSet csResourceSet = ocl.getResourceSet();
                environmentFactory.adapt((Notifier)csResourceSet);
                boolean hasOCLcontent = false;
                BaseCSResource xtextResource = (BaseCSResource)csResourceSet.createResource(xtextURI, "org.eclipse.ocl.xtext.oclinecore");
                if (xtextResource != null) {
                    CompleteOCLDocumentCS csDocument;
                    EObject csRoot;
                    xtextResource.updateFrom(oclResource, (EnvironmentFactory)environmentFactory);
                    @NonNull EList csContents = xtextResource.getContents();
                    if (csContents.size() > 0 && (csRoot = (EObject)csContents.get(0)) instanceof CompleteOCLDocumentCS && (csDocument = (CompleteOCLDocumentCS)csRoot).getOwnedPackages().size() > 0) {
                        hasOCLcontent = true;
                        xtextResource.save(XMIUtil.createSaveOptions());
                    }
                }
                if (hasOCLcontent) {
                    TestOCL ocl2 = this.createOCLWithProjectMap();
                    ResourceSet resourceSet2 = ocl2.getResourceSet();
                    BaseCSResource reloadCS = (BaseCSResource)resourceSet2.createResource(oclURI);
                    ocl2.getEnvironmentFactory().adapt((Notifier)reloadCS);
                    loadCallBacks.validateCompleteOCL((OCL)ocl2, reloadCS);
                    ocl2.dispose();
                }
            }
            Model model = pivotModel;
            return model;
        }
        finally {
            LoadTests.unloadResourceSet(resourceSet);
        }
    }

    private static void validateConstraint(@NonNull OCL ocl, @NonNull Constraint constraint) throws ParserException {
        ExpressionInOCL specification = ocl.getSpecification(constraint);
        constraint.setOwnedSpecification((LanguageExpression)specification);
        if (specification != null) {
            String language;
            LanguageExpression specification2 = constraint.getOwnedSpecification();
            String body = specification2.getBody();
            if (body != null && (language = specification2.getLanguage()) != null) {
                "OCL".equals(language);
            }
            LoadTests.assertNoValidationErrors("Local validation", (EObject)specification);
        }
    }

    public Resource doLoad_Concrete(@NonNull OCL ocl, @NonNull String stem, @NonNull String extension, String ... resourceErrors) throws IOException {
        ASResource asResource;
        BaseCSResource xtextResource = this.doLoad_Concrete1(ocl, stem, extension);
        CS2AS cs2as = xtextResource.findCS2AS();
        if (cs2as != null) {
            asResource = cs2as.getASResource();
            LoadTests.assertResourceErrors("Pre-save", (Resource)asResource, resourceErrors);
        }
        asResource = this.doLoad_Concrete2(xtextResource, stem, extension);
        return asResource;
    }

    protected BaseCSResource doLoad_Concrete1(@NonNull OCL ocl, @NonNull String stem, @NonNull String extension) throws IOException {
        String inputName = String.valueOf(stem) + "." + extension;
        URI inputURI = this.getProjectFileURI(inputName);
        BaseCSResource xtextResource = (BaseCSResource)ocl.getResourceSet().createResource(inputURI);
        xtextResource.setProjectManager((ProjectManager)LoadTests.getProjectMap());
        JavaClassScope.getAdapter((BaseCSResource)xtextResource, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        ocl.getEnvironmentFactory().adapt((Notifier)xtextResource);
        xtextResource.load(null);
        LoadTests.assertNoResourceErrors("Load failed", (Resource)xtextResource);
        CS2AS cs2as = xtextResource.findCS2AS();
        if (cs2as != null) {
            ASResource asResource = cs2as.getASResource();
            Map saveOptions = XMIUtil.createSaveOptions();
            saveOptions.put("DEBUG_LUSSID_COLLISIONS", Boolean.TRUE);
            saveOptions.put("DEBUG_XMIID_COLLISIONS", Boolean.TRUE);
            AS2ID.assignIds((ASResource)asResource, (Map)saveOptions);
            LoadTests.assertNoValidationErrors("Loaded pivot", (Resource)asResource);
        }
        return xtextResource;
    }

    protected Resource doLoad_Concrete2(@NonNull BaseCSResource xtextResource, @NonNull String stem, @NonNull String extension) throws IOException {
        String inputName = String.valueOf(stem) + "." + extension;
        URI inputURI = this.getProjectFileURI(inputName);
        String cstName = String.valueOf(inputName) + ".xmi";
        String pivotName = String.valueOf(inputName) + ".oclas";
        String savedName = String.valueOf(stem) + ".saved." + extension;
        URI cstURI = this.getProjectFileURI(cstName);
        URI pivotURI = this.getProjectFileURI(pivotName);
        URI savedURI = this.getProjectFileURI(savedName);
        ASResource asResource = xtextResource.getASResource();
        LoadTests.assertNoUnresolvedProxies("Unresolved proxies", (Resource)xtextResource);
        xtextResource.setURI(savedURI);
        Map saveOptions = XMIUtil.createSaveOptions();
        saveOptions.put("DEBUG_LUSSID_COLLISIONS", Boolean.TRUE);
        saveOptions.put("DEBUG_XMIID_COLLISIONS", Boolean.TRUE);
        xtextResource.save(saveOptions);
        xtextResource.setURI(inputURI);
        LoadTests.assertNoResourceErrors("Save failed", (Resource)xtextResource);
        this.saveAsXMI((Resource)xtextResource, cstURI);
        asResource.setURI(pivotURI);
        LoadTests.assertNoValidationErrors("Pivot validation errors", (EObject)asResource.getContents().get(0));
        asResource.save(saveOptions);
        return asResource;
    }

    public Resource doLoad_Pivot(@NonNull OCL ocl, @NonNull String stem, @NonNull String extension) throws IOException {
        String inputName = String.valueOf(stem) + "." + extension;
        URI inputURI = this.getProjectFileURI(inputName);
        Resource asResource = null;
        asResource = ocl.getMetamodelManager().getASResourceSet().getResource(inputURI, true);
        LoadTests.assertNoResourceErrors("Load failed", asResource);
        LoadTests.assertNoUnresolvedProxies("Unresolved proxies", asResource);
        LoadTests.assertNoValidationErrors("Validation errors", (EObject)asResource.getContents().get(0));
        return asResource;
    }

    public Resource doLoad_CS(@NonNull OCL ocl, @NonNull String stem, @NonNull String extension) throws IOException {
        String inputName = String.valueOf(stem) + "." + extension;
        URI inputURI = this.getProjectFileURI(inputName);
        BaseCSResource csResource = null;
        csResource = (BaseCSResource)ocl.getResourceSet().getResource(inputURI, true);
        LoadTests.assertNoResourceErrors("Load failed", (Resource)csResource);
        LoadTests.assertNoUnresolvedProxies("Unresolved proxies", (Resource)csResource);
        LoadTests.assertNoValidationErrors("Validation errors", (EObject)csResource.getContents().get(0));
        CS2AS cs2as = csResource.findCS2AS();
        if (cs2as != null) {
            ASResource asResource = cs2as.getASResource();
            LoadTests.assertNoValidationErrors("Loaded pivot", (Resource)asResource);
        }
        return csResource;
    }

    protected void saveAsXMI(Resource resource, URI xmiURI) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        Resource xmiResource = resourceSet.createResource(xmiURI);
        xmiResource.getContents().addAll((Collection)resource.getContents());
        Map options = XMIUtil.createSaveOptions();
        xmiResource.save(options);
        LoadTests.assertNoResourceErrors("Save failed", xmiResource);
        resource.getContents().addAll((Collection)xmiResource.getContents());
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        LoadTests.configurePlatformResources();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testLoad_Annotations_ecore() throws IOException, InterruptedException {
        TestOCL ocl = this.createOCL();
        this.doLoad((OCL)ocl, "Annotations", "ecore");
        ocl.dispose();
    }

    public void testLoad_Annotations_oclinecore() throws IOException, InterruptedException {
        TestOCL ocl = this.createOCL();
        this.doLoad_Concrete((OCL)ocl, "Annotations", "oclinecore", new String[0]);
        ocl.dispose();
    }

    public void testLoad_Ecore_ecore() throws IOException, InterruptedException {
        TestOCL ocl = this.createOCL();
        this.doLoad((OCL)ocl, "Ecore", "ecore");
        ocl.dispose();
    }

    public void testLoad_Empty_ecore() throws IOException, InterruptedException {
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            TestUtil.initializeEcoreEAnnotationValidators();
        }
        TestOCL ocl = this.createOCL();
        this.doLoad((OCL)ocl, "Empty", "ecore");
        ocl.dispose();
    }

    public void testLoad_Expression_oclinecore() throws IOException, InterruptedException {
        TestOCL ocl = this.createOCL();
        Resource asResource = this.doLoad_Concrete((OCL)ocl, "Expression", "oclinecore", new String[0]);
        String ecoreName = "Expression.saved.ecore";
        URI ecoreURI = this.getProjectFileURI(ecoreName);
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("PRIMITIVE_TYPES_URI_PREFIX", "primitives.ecore#//");
        XMLResource ecoreResource = AS2Ecore.createResource((EnvironmentFactoryInternal)((EnvironmentFactoryInternal)ocl.getEnvironmentFactory()), (Resource)asResource, (URI)ecoreURI, options);
        ecoreResource.save(XMIUtil.createSaveOptions());
        ocl.dispose();
    }

    public void testLoad_Imports_ecore() throws IOException, InterruptedException {
        TestOCL ocl = this.createOCL();
        this.doLoad((OCL)ocl, "Imports", "ecore");
        ocl.dispose();
    }

    public void testLoad_Names_ecore() throws IOException, InterruptedException {
        TestOCL ocl = this.createOCL();
        this.doLoad((OCL)ocl, "Names", "ecore");
        ocl.dispose();
    }

    public void testLoad_Names_oclinecore() throws IOException, InterruptedException {
        TestOCL ocl = this.createOCL();
        this.doLoad_Concrete((OCL)ocl, "Names", "oclinecore", new String[0]);
        ocl.dispose();
    }

    public void testLoad_Overloads_oclinecore() throws IOException, InterruptedException {
        TestOCL ocl = this.createOCL();
        this.doLoad_Concrete((OCL)ocl, "Overloads", "oclinecore", new String[0]);
        ocl.dispose();
    }

    public void testLoad_Refresh_oclinecore() throws IOException, InterruptedException {
        TestOCL ocl = this.createOCL();
        CommonOptions.DEFAULT_DELEGATION_MODE.setDefaultValue((Object)"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot");
        String testFile = "package tutorial : tuttut = 'http://www.eclipse.org/mdt/ocl/oclinecore/tutorial'\n{\n\tclass Library\n\t{\n\t\tproperty books#library : Book[*] { composes };\n\t}\n\tclass Book\n\t{\n\t\tproperty library#books : Library[?];\n\t\tproperty name : String;\n\t\tinvariant NameNotEmpty: name->notEmpty();\n\t}\n}\n";
        this.createOCLinEcoreFile("Refresh.oclinecore", testFile);
        BaseCSResource xtextResource = this.doLoad_Concrete1((OCL)ocl, "Refresh", "oclinecore");
        Resource asResource = this.doLoad_Concrete2(xtextResource, "Refresh", "oclinecore");
        LoadTests.assertNoValidationErrors("First validation", asResource);
        try {
            xtextResource.update((IDiagnosticConsumer)new ListBasedDiagnosticConsumer());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LoadTests.assertNoUnresolvedProxies("Unresolved proxies", (Resource)xtextResource);
        LoadTests.assertNoValidationErrors("Second validation", asResource);
        ocl.dispose();
    }

    public void testLoad_Refresh2_oclinecore() throws IOException, InterruptedException {
        TestOCL ocl = this.createOCL();
        CommonOptions.DEFAULT_DELEGATION_MODE.setDefaultValue((Object)"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot");
        String testFile = "package example : ex = 'http://www.example.org/examples/example.ecore'\n{\n\tclass NamedElement;\n\tclass Package;\n\tclass Class;\n\tclass Operation;\n\tclass Property;\n\n\tclass CompletePackageParent extends NamedElement\n\t{\n\t\tproperty nestedPackages#completePackage : Set(CompletePackage) { composes };\n\t}\n\t/** MetamodelManager/PackageManager API */\n\tclass CompleteModel extends CompletePackageParent\n\t{\n\t}\n\tclass CompletePackage extends CompletePackageParent\n\t{\n\t\tproperty completePackage#nestedPackages : CompletePackageParent;\n\t\tproperty nestedPackages : Set(CompletePackage) { composes };\n\t\tproperty partialPackages : OrderedSet(Package);\n\t\tproperty nestedClasses#completePackage : CompleteClass[*] { composes };\n\t}\n\tclass CompleteClass extends NamedElement\n\t{\n\t\tproperty completePackage#nestedClasses : CompletePackage;\n\t\tproperty partialClasses : OrderedSet(Class);\n\t}\n\tclass CompleteOperation extends NamedElement\n\t{\n\t}\n\tclass CompleteProperty extends NamedElement\n\t{\n\t}\n}";
        this.createOCLinEcoreFile("Refresh2.oclinecore", testFile);
        BaseCSResource xtextResource = this.doLoad_Concrete1((OCL)ocl, "Refresh2", "oclinecore");
        Resource asResource = this.doLoad_Concrete2(xtextResource, "Refresh2", "oclinecore");
        LoadTests.assertNoValidationErrors("First validation", asResource);
        try {
            xtextResource.update((IDiagnosticConsumer)new ListBasedDiagnosticConsumer());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LoadTests.assertNoUnresolvedProxies("Unresolved proxies", (Resource)xtextResource);
        LoadTests.assertNoValidationErrors("Second validation", asResource);
        ocl.dispose();
    }

    public void testLoad_RoyalAndLoyal_ecore() throws IOException, InterruptedException {
        TestOCL ocl = this.createOCLWithProjectMap();
        @NonNull URI inputURI = URI.createPlatformResourceURI((String)"/org.eclipse.ocl.examples.project.royalandloyal/model/RoyalAndLoyal.ecore", (boolean)true);
        this.doLoad((OCL)ocl, inputURI, "RoyalAndLoyal", "ecore");
        ocl.dispose();
    }

    public void testLoad_oclstdlib_oclstdlib() throws IOException, InterruptedException {
        TestOCL ocl = this.createOCL();
        Resource asResource = this.doLoad_Concrete((OCL)ocl, "oclstdlib", "oclstdlib", new String[0]);
        String ecoreName = "oclstdlib.saved.ecore";
        URI ecoreURI = this.getProjectFileURI(ecoreName);
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("PRIMITIVE_TYPES_URI_PREFIX", "primitives.ecore#//");
        XMLResource ecoreResource = AS2Ecore.createResource((EnvironmentFactoryInternal)((EnvironmentFactoryInternal)ocl.getEnvironmentFactory()), (Resource)asResource, (URI)ecoreURI, options);
        ecoreResource.save(XMIUtil.createSaveOptions());
        ocl.dispose();
    }

    public void testLoad_OCL_ecore() throws IOException, InterruptedException {
        TestOCL ocl = this.createOCL();
        this.doLoad((OCL)ocl, "OCL", "ecore");
        ocl.dispose();
    }

    public void testLoad_Types_oclinecore() throws IOException, InterruptedException {
        TestOCL ocl = this.createOCL();
        this.doLoad_Concrete((OCL)ocl, "Types", "oclinecore", new String[0]);
        ocl.dispose();
    }

    public void testLoad_Wildcard_oclinecore() throws IOException, InterruptedException {
        TestOCL ocl = this.createOCL();
        this.doLoad_Concrete((OCL)ocl, "Wildcard", "oclinecore", new String[0]);
        ocl.dispose();
    }

    public void testLoad_BaseCST_ecore() throws IOException, InterruptedException {
        StandaloneProjectMap projectMap = LoadTests.getProjectMap();
        OCL ocl = OCL.newInstance((ProjectManager)projectMap);
        ResourceSet resourceSet = ocl.getResourceSet();
        projectMap.initializeResourceSet(resourceSet);
        ProjectManager.IProjectDescriptor projectDescriptor = projectMap.getProjectDescriptor("org.eclipse.emf.ecore");
        ProjectManager.IPackageDescriptor packageDescriptor = projectDescriptor.getPackageDescriptor(URI.createURI((String)"http://www.eclipse.org/emf/2002/Ecore"));
        packageDescriptor.configure(resourceSet, StandaloneProjectMap.LoadGeneratedPackageStrategy.INSTANCE, StandaloneProjectMap.MapToFirstConflictHandler.INSTANCE);
        URI uri = URI.createPlatformResourceURI((String)"/org.eclipse.ocl.xtext.base/model/BaseCS.ecore", (boolean)true);
        try {
            this.doLoadEcore(ocl, resourceSet, uri);
        }
        finally {
            LoadTests.unloadResourceSet(resourceSet);
        }
        ocl.dispose();
    }

    public void testLoad_Bug321171_oclinecore() throws IOException, InterruptedException {
        TestOCL ocl = this.createOCL();
        this.doLoad_Concrete((OCL)ocl, "Bug321171", "oclinecore", new String[0]);
        ocl.dispose();
    }

    public void testLoad_Bug321903_oclinecore() throws IOException, InterruptedException {
        TestOCL ocl = this.createOCL();
        this.doLoad_Concrete((OCL)ocl, "Bug321903", "oclinecore", new String[0]);
        ocl.dispose();
    }

    public void testLoad_Bug323741_ecore() throws IOException, InterruptedException {
        TestOCL ocl = this.createOCL();
        this.doLoad((OCL)ocl, "Bug323741", "ecore");
        ocl.dispose();
    }

    public void testLoad_Bug323741_oclinecore() throws IOException, InterruptedException {
        TestOCL ocl = this.createOCL();
        this.doLoad_Concrete((OCL)ocl, "Bug323741", "oclinecore", new String[0]);
        ocl.dispose();
    }

    public void testLoad_Bug328480_oclinecore() throws IOException, InterruptedException {
        TestOCL ocl = this.createOCL();
        this.doLoad_Concrete((OCL)ocl, "Bug328480", "oclinecore", new String[0]);
        ocl.dispose();
    }

    public void testLoad_Bug328485_oclinecore() throws IOException, InterruptedException {
        TestOCL ocl = this.createOCL();
        Resource asResource = this.doLoad_Concrete((OCL)ocl, "Bug328485", "oclinecore", new String[0]);
        VariableDeclaration referredVariable = null;
        TreeIterator tit = asResource.getAllContents();
        while (tit.hasNext()) {
            EObject eObject = (EObject)tit.next();
            if (!(eObject instanceof VariableExp)) continue;
            LoadTests.assertNull(referredVariable);
            VariableExp variableExp = (VariableExp)eObject;
            if (!"name".equals(variableExp.getReferredVariable().getName())) continue;
            referredVariable = variableExp.getReferredVariable();
            LoadTests.assertEquals((String)"Named", (String)referredVariable.getType().getName());
        }
        LoadTests.assertNotNull(referredVariable);
        ocl.dispose();
    }

    public void testLoad_Bug401921_oclinecore() throws IOException, InterruptedException {
        TestOCL ocl = this.createOCL();
        this.doLoad_Concrete((OCL)ocl, "Bug401921", "oclinecore", new String[0]);
        ocl.dispose();
    }

    public void testLoad_Bug402767_oclinecore() throws IOException, InterruptedException {
        TestOCL ocl = this.createOCL();
        String testFile = "package b : bb = 'bbb'\n{\nclass B\n{\nproperty vBlank : Real;\nproperty vQuery : Real[?];\nproperty vPlus : Real[+];\nproperty vStar : Real[*];\nproperty vOne : Real[1];\nproperty vThree : Real[3];\nproperty vOne2Three : Real[1..3];\nproperty vThree2Three : Real[3..3];\nproperty vThree2Star : Real[3..*];\n}\n}\n";
        this.createOCLinEcoreFile("Bug402767.oclinecore", testFile);
        Resource resource = this.doLoad_Concrete((OCL)ocl, "Bug402767", "oclinecore", new String[0]);
        Model root = (Model)resource.getContents().get(0);
        Package pkg = (Package)root.getOwnedPackages().get(0);
        Class cls = (Class)pkg.getOwnedClasses().get(0);
        List ownedAttributes = cls.getOwnedProperties();
        this.checkMultiplicity((TypedElement)NameUtil.getNameable((Iterable)ownedAttributes, (String)"vBlank"), 0, 1);
        this.checkMultiplicity((TypedElement)NameUtil.getNameable((Iterable)ownedAttributes, (String)"vQuery"), 0, 1);
        this.checkMultiplicity((TypedElement)NameUtil.getNameable((Iterable)ownedAttributes, (String)"vPlus"), 1, -1);
        this.checkMultiplicity((TypedElement)NameUtil.getNameable((Iterable)ownedAttributes, (String)"vStar"), 0, -1);
        this.checkMultiplicity((TypedElement)NameUtil.getNameable((Iterable)ownedAttributes, (String)"vOne"), 1, 1);
        this.checkMultiplicity((TypedElement)NameUtil.getNameable((Iterable)ownedAttributes, (String)"vThree"), 3, 3);
        this.checkMultiplicity((TypedElement)NameUtil.getNameable((Iterable)ownedAttributes, (String)"vOne2Three"), 1, 3);
        this.checkMultiplicity((TypedElement)NameUtil.getNameable((Iterable)ownedAttributes, (String)"vThree2Three"), 3, 3);
        this.checkMultiplicity((TypedElement)NameUtil.getNameable((Iterable)ownedAttributes, (String)"vThree2Star"), 3, -1);
        ocl.dispose();
    }

    public void testLoad_Bug403070_oclinecore() throws IOException, InterruptedException {
        TestOCL ocl = this.createOCL();
        String testFile = "import ecore : 'http://www.eclipse.org/emf/2002/Ecore#/';\npackage temp : EAAT = 'http://www.eclipse.org/mdt/ocl/oclinecore/tutorial'\n{\n\tclass Class1\n\t{\n\t\toperation testOpt(values : ecore::EDouble[*]) : ecore::EDouble\n\t\t{\n\t\t\tbody: values->sum();\n\t\t}\n\t\tattribute variable : ecore::EDouble;\n\t\tattribute testAttribute : ecore::EDoubleObject { derived volatile }\n\t\t{\n\t\t\tderivation: self.testOpt(self.variable->asSet());\n\t\t}\n\t}\n}\n";
        this.createOCLinEcoreFile("Bug403070.oclinecore", testFile);
        this.doLoad_Concrete((OCL)ocl, "Bug403070", "oclinecore", new String[0]);
        ocl.dispose();
    }

    public void testLoad_Bug401953_essentialocl() {
        TestOCL ocl = this.createOCL();
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            EssentialOCLStandaloneSetup.doSetup();
        }
        URI uri = this.getProjectFileURI("Bug401953.essentialocl");
        ResourceSet resourceSet = ocl.getResourceSet();
        long start = System.currentTimeMillis();
        Resource csResource = resourceSet.getResource(uri, true);
        long end = System.currentTimeMillis();
        if (end - start > 5000L) {
            LoadTests.fail((String)("Took " + 0.001 * (double)(end - start) + " seconds"));
        }
        ocl.dispose();
    }

    public void testLoad_Bug450950_ocl() throws IOException, InterruptedException {
        TestOCL ocl = this.createOCL();
        String bug450950A = "package bug450950 : bug450950A = 'http://www.eclipse.org/ocl/Bug450950A'\n{\n\tabstract class Bug450950A;\n}\n";
        this.createOCLinEcoreFile("Bug450950A.oclinecore", bug450950A);
        String bug450950B = "package bug450950 : bug450950B = 'http://www.eclipse.org/ocl/Bug450950B'\n{\n\tabstract class Bug450950B;\n}\n";
        this.createOCLinEcoreFile("Bug450950B.oclinecore", bug450950B);
        String bug450950 = "import bug450950a : 'Bug450950A.oclinecore'::bug450950\nimport bug450950b : 'Bug450950B.oclinecore'::bug450950\npackage bug450950a\ncontext Bug450950A\ndef : isA() : Boolean = true\nendpackage\npackage bug450950b\ncontext Bug450950B\ndef : isB() : Boolean = true\nendpackage\n";
        this.createOCLinEcoreFile("Bug450950.ocl", bug450950);
        String message = "\\nAmbiguous xmi:id TVXWp\\n\t bug450950\\n\t bug450950\\ncollision at 693728595\\n\tbug450950\\n\tbug450950";
        Resource asResource = this.doLoad_Concrete((OCL)ocl, "Bug450950", "ocl", StringUtil.bind((String)PivotMessagesInternal.UnstableXMIid_ERROR_, (Object[])new Object[]{message}));
        LoadTests.assertResourceErrors("Save", asResource, StringUtil.bind((String)PivotMessagesInternal.UnstableXMIid_ERROR_, (Object[])new Object[]{message}));
        ocl.dispose();
    }

    public void testLoad_Bug441620_completeocl() throws IOException {
        TestOCL ocl = this.createOCL();
        BaseCSResource csResource = (BaseCSResource)this.doLoad_CS((OCL)ocl, "Bug441620", "ocl");
        ASResource oclResource = csResource.getASResource();
        Model root = (Model)oclResource.getContents().get(0);
        Package oclDocPackage = (Package)root.getOwnedPackages().get(0);
        LoadTests.assertEquals((String)"pivot", (String)oclDocPackage.getName());
        LoadTests.assertEquals((String)"http://www.eclipse.org/ocl/2015/Pivot", (String)oclDocPackage.getURI());
        Import _import = (Import)root.getOwnedImports().get(0);
        LoadTests.assertEquals((String)"pivot", (String)_import.getName());
        Namespace nSpace = _import.getImportedNamespace();
        LoadTests.assertTrue((boolean)(nSpace instanceof Package));
        Package refPackage = (Package)nSpace;
        LoadTests.assertEquals((String)"pivot", (String)nSpace.getName());
        LoadTests.assertEquals((String)"http://www.eclipse.org/ocl/2015/Pivot", (String)refPackage.getURI());
        LoadTests.assertNotSame((Object)oclDocPackage, (Object)nSpace);
        MetamodelManager metamodelManager = ocl.getMetamodelManager();
        LoadTests.assertEquals((Object)metamodelManager.getPrimaryPackage(oclDocPackage), (Object)metamodelManager.getPrimaryPackage(refPackage));
        ocl.dispose();
    }

    public void testLoad_Bug441620b_completeocl() throws IOException {
        TestOCL ocl = this.createOCL();
        BaseCSResource csResource = (BaseCSResource)this.doLoad_CS((OCL)ocl, "Bug441620b", "ocl");
        ASResource oclResource = csResource.getASResource();
        Model root = (Model)oclResource.getContents().get(0);
        Package oclDocPackage = (Package)root.getOwnedPackages().get(0);
        LoadTests.assertEquals((String)"ocl", (String)oclDocPackage.getName());
        LoadTests.assertEquals((String)"http://www.eclipse.org/ocl/2015/Library", (String)oclDocPackage.getURI());
        Import _import = (Import)root.getOwnedImports().get(0);
        LoadTests.assertEquals((String)"pivot", (String)_import.getName());
        Namespace nSpace = _import.getImportedNamespace();
        LoadTests.assertTrue((boolean)(nSpace instanceof Package));
        Package refPackage = (Package)nSpace;
        LoadTests.assertEquals((String)"pivot", (String)nSpace.getName());
        LoadTests.assertEquals((String)"http://www.eclipse.org/ocl/2015/Pivot", (String)((Package)nSpace).getURI());
        LoadTests.assertNotSame((Object)oclDocPackage, (Object)nSpace);
        MetamodelManager metamodelManager = ocl.getMetamodelManager();
        LoadTests.assertEquals((Object)metamodelManager.getPrimaryPackage(oclDocPackage), (Object)metamodelManager.getPrimaryPackage(refPackage));
        ocl.dispose();
    }

    private void checkMultiplicity(TypedElement typedElement, int lower, int upper) {
        Type type = typedElement.getType();
        if (upper >= 0 && upper <= 1) {
            LoadTests.assertFalse((boolean)(type instanceof CollectionType));
            LoadTests.assertEquals((lower > 0 ? 1 : 0) != 0, (boolean)typedElement.isIsRequired());
        } else {
            LoadTests.assertTrue((boolean)typedElement.isIsRequired());
            CollectionType collType = (CollectionType)type;
            LoadTests.assertEquals((Object)lower, (Object)collType.getLower());
            LoadTests.assertEquals((Object)(upper >= 0 ? Integer.valueOf(upper) : Unlimited.INSTANCE), (Object)collType.getUpper());
        }
    }

    public void testLoad_Fruit_ocl() throws IOException, InterruptedException {
        UMLStandaloneSetup.init();
        TestOCL ocl = this.createOCL();
        UMLPackage.eINSTANCE.getClass();
        this.doLoad((OCL)ocl, "Fruit", "ocl");
        ocl.dispose();
    }

    public void testLoad_Imports_ocl() throws IOException, InterruptedException {
        TestOCL ocl = this.createOCL();
        this.doLoad((OCL)ocl, "Imports", "ocl");
        ocl.dispose();
    }

    public void testLoad_Names_ocl() throws IOException, InterruptedException {
        TestOCL ocl = this.createOCL();
        this.doLoad((OCL)ocl, "Names", "ocl");
        ocl.dispose();
    }

    public void testLoad_OCLTest_ocl() throws IOException, InterruptedException {
        TestOCL ocl = this.createOCL();
        this.doLoad((OCL)ocl, "OCLTest", "ocl");
        ocl.dispose();
    }

    public void testLoad_Pivot_ocl() throws IOException, InterruptedException {
        TestOCL ocl = this.createOCL();
        ocl.getEnvironmentFactory().setSafeNavigationValidationSeverity(StatusCodes.Severity.WARNING);
        this.doLoad_OCL((OCL)ocl, URI.createPlatformResourceURI((String)"/org.eclipse.ocl.pivot/model/Pivot.ocl", (boolean)true));
        ocl.dispose();
    }

    public void testLoad_RoyalAndLoyal_ocl() throws IOException, InterruptedException {
        TestOCL ocl = this.createOCLWithProjectMap();
        @NonNull URI inputURI = URI.createPlatformResourceURI((String)"/org.eclipse.ocl.examples.project.royalandloyal/model/RoyalAndLoyal.ocl", (boolean)true);
        this.doLoad((OCL)ocl, inputURI, "RoyalAndLoyal", "ocl");
        ocl.dispose();
    }

    public void testLoad_Internationalized_profile_uml() throws IOException, InterruptedException, ParserException {
        TestOCL ocl = this.createOCL();
        URI uri = URI.createPlatformResourceURI((String)"/org.eclipse.ocl.examples.xtext.tests/model/Internationalized.profile.uml", (boolean)true);
        this.doLoadUML((OCL)ocl, uri, false, false, null, null);
        ocl.dispose();
    }

    public void testLoad_NullFree_uml() throws IOException, InterruptedException, ParserException {
        TestOCL ocl = this.createOCL();
        URI uri = this.getProjectFileURI("NullFree.uml");
        Model model = this.doLoadUML((OCL)ocl, uri, false, true, NO_MESSAGES, null);
        Package asPackage = (Package)model.getOwnedPackages().get(0);
        Class asInheritedNullFree = (Class)NameUtil.getNameable((Iterable)asPackage.getOwnedClasses(), (String)"InheritedNullFree");
        Class asNonNullFree = (Class)NameUtil.getNameable((Iterable)asPackage.getOwnedClasses(), (String)"NonNullFree");
        Property inf_nf = (Property)NameUtil.getNameable((Iterable)asInheritedNullFree.getOwnedProperties(), (String)"nf");
        Property inf_nnf = (Property)NameUtil.getNameable((Iterable)asInheritedNullFree.getOwnedProperties(), (String)"nnf");
        Property inf_inf = (Property)NameUtil.getNameable((Iterable)asInheritedNullFree.getOwnedProperties(), (String)"inf");
        Property nnf_nf = (Property)NameUtil.getNameable((Iterable)asNonNullFree.getOwnedProperties(), (String)"nf");
        Property nnf_nnf = (Property)NameUtil.getNameable((Iterable)asNonNullFree.getOwnedProperties(), (String)"nnf");
        Property nnf_inf = (Property)NameUtil.getNameable((Iterable)asNonNullFree.getOwnedProperties(), (String)"inf");
        LoadTests.assertEquals((boolean)true, (boolean)((CollectionType)inf_nf.getType()).isIsNullFree());
        LoadTests.assertEquals((boolean)false, (boolean)((CollectionType)inf_nnf.getType()).isIsNullFree());
        LoadTests.assertEquals((boolean)true, (boolean)((CollectionType)inf_inf.getType()).isIsNullFree());
        LoadTests.assertEquals((boolean)true, (boolean)((CollectionType)nnf_nf.getType()).isIsNullFree());
        LoadTests.assertEquals((boolean)false, (boolean)((CollectionType)nnf_nnf.getType()).isIsNullFree());
        LoadTests.assertEquals((boolean)false, (boolean)((CollectionType)nnf_inf.getType()).isIsNullFree());
        ocl.dispose();
    }

    public void testLoad_StereotypeApplications_uml() throws IOException, InterruptedException, ParserException {
        TestOCL ocl = this.createOCL();
        URI uri = this.getProjectFileURI("StereotypeApplications.uml");
        this.doLoadUML((OCL)ocl, uri, new AbstractLoadCallBack(false, NO_MESSAGES, false){

            @Override
            public void postLoad(@NonNull OCL ocl, @NonNull ASResource asResource) {
                TreeIterator tit = asResource.getAllContents();
                while (tit.hasNext()) {
                    EObject obj = (EObject)tit.next();
                    if (!(obj instanceof Type)) continue;
                    ((MetamodelManagerInternal)ocl.getMetamodelManager()).getAllInvariants((Type)obj);
                }
            }
        }, null);
        ocl.dispose();
    }

    public void testReload_AsReload() throws Exception {
        TestOCL ocl1 = this.createOCL();
        String oclinecoreFileA = "package PackageA : nsPrefixA = 'http://A3'{\n    class ClassA {\n    \tinvariant InvA: self.toString() = 'ClassA';\n    }\n}\n";
        String ecoreFileA = this.createEcoreString((OCL)ocl1, "Bug382230A", oclinecoreFileA, false);
        String oclinecoreFileB = "package PackageB : nsPrefixB = 'http://A3'{\n    datatype ClassB {\n    \tinvariant InvB: self.toString() = 'ClassB';\n    }\n}\n";
        String ecoreFileB = this.createEcoreString((OCL)ocl1, "Bug382230B", oclinecoreFileB, false);
        String ecoreFileName = "Bug382230.ecore";
        ocl1.dispose();
        TestOCL ocl2 = this.createOCL();
        URI ecoreURI = URI.createURI((String)ecoreFileName);
        XMLResource ecoreResource = (XMLResource)ocl2.getResourceSet().createResource(ecoreURI, null);
        ecoreResource.load((InputStream)new URIConverter.ReadableInputStream(ecoreFileA), null);
        Ecore2AS conversion = Ecore2AS.getAdapter((Resource)ecoreResource, (EnvironmentFactoryInternal)((EnvironmentFactoryInternal)ocl2.getEnvironmentFactory()));
        Resource asResource = conversion.getASModel().eResource();
        LoadTests.assertEquals((int)1, (int)asResource.getContents().size());
        Model pivotModel1 = (Model)asResource.getContents().get(0);
        LoadTests.assertEquals((String)ecoreFileName, (String)pivotModel1.getName());
        LoadTests.assertEquals((int)1, (int)pivotModel1.getOwnedPackages().size());
        Package pivotPackage1 = (Package)pivotModel1.getOwnedPackages().get(0);
        LoadTests.assertEquals((String)"PackageA", (String)pivotPackage1.getName());
        LoadTests.assertEquals((String)"nsPrefixA", (String)pivotPackage1.getNsPrefix());
        LoadTests.assertEquals((int)1, (int)pivotPackage1.getOwnedClasses().size());
        Type pivotType1 = (Type)pivotPackage1.getOwnedClasses().get(0);
        LoadTests.assertEquals((String)"ClassA", (String)pivotType1.getName());
        LoadTests.assertEquals((String)"Class", (String)pivotType1.eClass().getName());
        ecoreResource.unload();
        ecoreResource.load((InputStream)new URIConverter.ReadableInputStream(ecoreFileB), null);
        conversion.update(asResource, (Collection)ecoreResource.getContents());
        LoadTests.assertEquals((int)1, (int)asResource.getContents().size());
        Model pivotModel2 = (Model)asResource.getContents().get(0);
        LoadTests.assertEquals((String)ecoreFileName, (String)pivotModel2.getName());
        LoadTests.assertEquals((int)1, (int)pivotModel2.getOwnedPackages().size());
        Package pivotPackage2 = (Package)pivotModel2.getOwnedPackages().get(0);
        LoadTests.assertEquals((String)"PackageB", (String)pivotPackage2.getName());
        LoadTests.assertEquals((String)"nsPrefixB", (String)pivotPackage2.getNsPrefix());
        LoadTests.assertEquals((int)1, (int)pivotPackage2.getOwnedClasses().size());
        Type pivotType2 = (Type)pivotPackage2.getOwnedClasses().get(0);
        LoadTests.assertEquals((String)"ClassB", (String)pivotType2.getName());
        LoadTests.assertEquals((String)"DataType", (String)pivotType2.eClass().getName());
        ArrayList<Package> allPackages = new ArrayList<Package>();
        for (CompletePackage completePackage : ocl2.getStandardLibrary().getAllCompletePackages()) {
            Package aPackage = completePackage.getPrimaryPackage();
            if (aPackage instanceof Model || aPackage instanceof Library || "$$".equals(aPackage.getName())) continue;
            allPackages.add(aPackage);
        }
        LoadTests.assertEquals((int)1, (int)allPackages.size());
        ocl2.dispose();
    }

    public void testReload_AsUpdate() throws Exception {
        TestOCL ocl1 = this.createOCL();
        String oclinecoreFileXXX = "package PackageXXX : nsPrefixXXX = 'http://XXX'{\n    class MutableXXX {\n    }\n    class ClassXXX {\n    \tinvariant InvXXX: self.toString() = 'ClassXXX';\n    \tproperty fromXXX#toXXX: ClassXXX;\n    \tproperty toXXX#fromXXX: ClassXXX;\n    }\n}\n";
        String ecoreFileXXX = this.createEcoreString((OCL)ocl1, "Bug382230", oclinecoreFileXXX, true);
        String ecoreFileYYY = ecoreFileXXX.replaceFirst("xsi:type=\"ecore:EClass\"", "xsi:type=\"ecore:EDataType\"").replaceAll("XXX", "YYY");
        String ecoreFileName = "Bug382230.ecore";
        ocl1.dispose();
        TestOCL ocl2 = this.createOCL();
        URI ecoreURI = URI.createURI((String)ecoreFileName);
        XMLResource ecoreResource = (XMLResource)ocl2.getResourceSet().createResource(ecoreURI, null);
        ecoreResource.load((InputStream)new URIConverter.ReadableInputStream(ecoreFileXXX), null);
        Ecore2AS conversion = Ecore2AS.getAdapter((Resource)ecoreResource, (EnvironmentFactoryInternal)((EnvironmentFactoryInternal)ocl2.getEnvironmentFactory()));
        Resource asResource = conversion.getASModel().eResource();
        LoadTests.assertEquals((int)1, (int)asResource.getContents().size());
        Model pivotModelXXX = (Model)asResource.getContents().get(0);
        LoadTests.assertEquals((String)ecoreFileName, (String)pivotModelXXX.getName());
        LoadTests.assertEquals((int)1, (int)pivotModelXXX.getOwnedPackages().size());
        Package pivotPackageXXX = (Package)pivotModelXXX.getOwnedPackages().get(0);
        LoadTests.assertEquals((String)"PackageXXX", (String)pivotPackageXXX.getName());
        LoadTests.assertEquals((String)"nsPrefixXXX", (String)pivotPackageXXX.getNsPrefix());
        LoadTests.assertEquals((int)2, (int)pivotPackageXXX.getOwnedClasses().size());
        Class pivotTypeXXX0 = (Class)pivotPackageXXX.getOwnedClasses().get(0);
        LoadTests.assertEquals((String)"MutableXXX", (String)pivotTypeXXX0.getName());
        LoadTests.assertEquals((String)"Class", (String)pivotTypeXXX0.eClass().getName());
        Class pivotTypeXXX1 = (Class)pivotPackageXXX.getOwnedClasses().get(1);
        LoadTests.assertEquals((String)"ClassXXX", (String)pivotTypeXXX1.getName());
        LoadTests.assertEquals((String)"Class", (String)pivotTypeXXX1.eClass().getName());
        LoadTests.assertEquals((int)2, (int)pivotTypeXXX1.getOwnedProperties().size());
        Property pivotPropertyXXX0 = (Property)pivotTypeXXX1.getOwnedProperties().get(0);
        Property pivotPropertyXXX1 = (Property)pivotTypeXXX1.getOwnedProperties().get(1);
        LoadTests.assertEquals((String)"fromXXX", (String)pivotPropertyXXX0.getName());
        LoadTests.assertEquals((String)"toXXX", (String)pivotPropertyXXX1.getName());
        LoadTests.assertEquals((Object)pivotPropertyXXX1, (Object)pivotPropertyXXX0.getOpposite());
        LoadTests.assertEquals((Object)pivotPropertyXXX0, (Object)pivotPropertyXXX1.getOpposite());
        ecoreResource.unload();
        ecoreResource.load((InputStream)new URIConverter.ReadableInputStream(ecoreFileYYY), null);
        conversion.update(asResource, (Collection)ecoreResource.getContents());
        LoadTests.assertEquals((int)1, (int)asResource.getContents().size());
        Model pivotModelYYY = (Model)asResource.getContents().get(0);
        LoadTests.assertEquals((String)ecoreFileName, (String)pivotModelYYY.getName());
        LoadTests.assertEquals((int)1, (int)pivotModelYYY.getOwnedPackages().size());
        Package pivotPackageYYY = (Package)pivotModelYYY.getOwnedPackages().get(0);
        LoadTests.assertEquals((String)"PackageYYY", (String)pivotPackageYYY.getName());
        LoadTests.assertEquals((String)"nsPrefixYYY", (String)pivotPackageYYY.getNsPrefix());
        LoadTests.assertEquals((int)2, (int)pivotPackageYYY.getOwnedClasses().size());
        Class pivotTypeYYY0 = (Class)pivotPackageYYY.getOwnedClasses().get(0);
        LoadTests.assertEquals((String)"MutableYYY", (String)pivotTypeYYY0.getName());
        LoadTests.assertEquals((String)"DataType", (String)pivotTypeYYY0.eClass().getName());
        Class pivotTypeYYY1 = (Class)pivotPackageYYY.getOwnedClasses().get(1);
        LoadTests.assertEquals((String)"ClassYYY", (String)pivotTypeYYY1.getName());
        LoadTests.assertEquals((String)"Class", (String)pivotTypeYYY1.eClass().getName());
        LoadTests.assertEquals((int)2, (int)pivotTypeYYY1.getOwnedProperties().size());
        Property pivotPropertyYYY0 = (Property)pivotTypeYYY1.getOwnedProperties().get(0);
        Property pivotPropertyYYY1 = (Property)pivotTypeYYY1.getOwnedProperties().get(1);
        LoadTests.assertEquals((String)"fromYYY", (String)pivotPropertyYYY0.getName());
        LoadTests.assertEquals((String)"toYYY", (String)pivotPropertyYYY1.getName());
        LoadTests.assertEquals((Object)pivotPropertyYYY1, (Object)pivotPropertyYYY0.getOpposite());
        LoadTests.assertEquals((Object)pivotPropertyYYY0, (Object)pivotPropertyYYY1.getOpposite());
        ArrayList<Package> allPackages = new ArrayList<Package>();
        for (CompletePackage completePackage : ocl2.getStandardLibrary().getAllCompletePackages()) {
            Package aPackage = completePackage.getPrimaryPackage();
            if (aPackage instanceof Model || aPackage instanceof Library || "$$".equals(aPackage.getName())) continue;
            allPackages.add(aPackage);
        }
        LoadTests.assertEquals((int)1, (int)allPackages.size());
        ocl2.dispose();
    }

    public void testReload_As418412() throws Exception {
        TestOCL ocl1 = this.createOCL();
        String oclinecoreFileXXX = "package PackageXXX : nsPrefixXXX = 'http://XXX'{\n    class ClassXXX {\n    \tproperty children: ClassXXX[*];\n    }\n}\n";
        String ecoreFileXXX = this.createEcoreString((OCL)ocl1, "Bug418412", oclinecoreFileXXX, true);
        String ecoreFileName = "Bug418412.ecore";
        ocl1.dispose();
        TestOCL ocl2 = this.createOCL();
        URI ecoreURI = URI.createURI((String)ecoreFileName);
        XMLResource ecoreResource = (XMLResource)ocl2.getResourceSet().createResource(ecoreURI, null);
        ecoreResource.load((InputStream)new URIConverter.ReadableInputStream(ecoreFileXXX), null);
        Ecore2AS conversion = Ecore2AS.getAdapter((Resource)ecoreResource, (EnvironmentFactoryInternal)((EnvironmentFactoryInternal)ocl2.getEnvironmentFactory()));
        ASResource asResource = (ASResource)conversion.getASModel().eResource();
        URI esasURI = this.getProjectFileURI(String.valueOf(ecoreFileName) + ".oclas");
        asResource.setURI(esasURI);
        HashMap options = new HashMap();
        asResource.save(options);
        HashMap<EObject, String> eObject2id = new HashMap<EObject, String>();
        HashMap<String, EObject> id2eObject = new HashMap<String, EObject>();
        int oldIdCount = 0;
        TreeIterator tit = asResource.getAllContents();
        while (tit.hasNext()) {
            EObject eObject = (EObject)tit.next();
            String id = asResource.getID(eObject);
            eObject2id.put(eObject, id);
            if (id == null) continue;
            id2eObject.put(id, eObject);
            ++oldIdCount;
        }
        LoadTests.assertEquals((int)9, (int)oldIdCount);
        LoadTests.assertEquals((int)oldIdCount, (int)id2eObject.size());
        URI asURI = esasURI.trimFileExtension().trimFileExtension().appendFileExtension("oclas");
        asResource.setURI(asURI);
        asResource.save(XMIUtil.createSaveOptions());
        TreeIterator tit2 = asResource.getAllContents();
        while (tit2.hasNext()) {
            EObject eObject = (EObject)tit2.next();
            String id = asResource.getID(eObject);
            LoadTests.assertEquals((String)((String)eObject2id.get(eObject)), (String)id);
        }
        ocl2.dispose();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        ASResourceFactoryRegistry.INSTANCE.configureResourceSet((ResourceSet)resourceSet);
        ASResource reloadedAsResource = (ASResource)resourceSet.getResource(asURI, true);
        int newIdCount = 0;
        TreeIterator tit3 = reloadedAsResource.getAllContents();
        while (tit3.hasNext()) {
            EObject eObject = (EObject)tit3.next();
            String id = reloadedAsResource.getID(eObject);
            if (id == null) continue;
            EObject eObject2 = (EObject)id2eObject.get(id);
            LoadTests.assertNotNull((Object)eObject2);
            LoadTests.assertEquals(eObject2.getClass(), eObject.getClass());
            ++newIdCount;
        }
        LoadTests.assertEquals((int)oldIdCount, (int)newIdCount);
    }

    private static class AbstractLoadCallBack
    implements ILoadCallBack {
        private final boolean ignoreNonExistence;
        private final @NonNull String @Nullable [] validateCompleteOCLMessages;
        private final boolean validateEmbeddedOCL;

        private AbstractLoadCallBack(boolean ignoreNonExistence, @NonNull String @Nullable [] validateCompleteOCLMessages, boolean validateEmbeddedOCL) {
            this.ignoreNonExistence = ignoreNonExistence;
            this.validateCompleteOCLMessages = validateCompleteOCLMessages;
            this.validateEmbeddedOCL = validateEmbeddedOCL;
        }

        @Override
        public boolean ignoreNonExistence() {
            return this.ignoreNonExistence;
        }

        @Override
        public void postLoad(@NonNull OCL ocl, @NonNull ASResource asResource) {
        }

        @Override
        public void validateCompleteOCL(@NonNull OCL ocl, @NonNull BaseCSResource reloadCS) throws IOException {
            if (this.validateCompleteOCLMessages != null) {
                reloadCS.load(null);
                LoadTests.assertNoResourceErrors("Load failed", (Resource)reloadCS);
                ASResource reloadAS = reloadCS.getASResource();
                LoadTests.assertNoUnresolvedProxies("Unresolved proxies", (Resource)reloadAS);
                LoadTests.assertValidationDiagnostics("Reloading", (Resource)reloadAS, this.validateCompleteOCLMessages);
            }
        }

        @Override
        public void validateEmbeddedOCL(@NonNull OCL ocl, @NonNull Constraint constraint) throws ParserException {
            if (this.validateEmbeddedOCL) {
                LoadTests.validateConstraint(ocl, constraint);
            }
        }

        /* synthetic */ AbstractLoadCallBack(boolean bl, String[] stringArray, boolean bl2, AbstractLoadCallBack abstractLoadCallBack, AbstractLoadCallBack abstractLoadCallBack2) {
            this(bl, stringArray, bl2);
        }
    }

    public static interface ILoadCallBack {
        public boolean ignoreNonExistence();

        public void postLoad(@NonNull OCL var1, @NonNull ASResource var2);

        public void validateCompleteOCL(@NonNull OCL var1, @NonNull BaseCSResource var2) throws IOException;

        public void validateEmbeddedOCL(@NonNull OCL var1, @NonNull Constraint var2) throws ParserException;
    }
}

