/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.test.xtext;

import java.io.IOException;
import java.util.HashMap;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ocl.examples.xtext.tests.XtextTestCase;
import org.eclipse.ocl.pivot.internal.ecore.Ecore2Moniker;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.utilities.XMIUtil;
import org.eclipse.ocl.xtext.base.utilities.BaseCSResource;
import org.eclipse.ocl.xtext.oclstdlib.scoping.JavaClassScope;

public class MonikerTests
extends XtextTestCase {
    public void doMonikerTestEcore(String stem) throws IOException {
        OCL ocl = OCL.newInstance((ProjectManager)MonikerTests.getProjectMap());
        String inputName = String.valueOf(stem) + ".ecore";
        URI inputURI = this.getProjectFileURI(inputName);
        Resource ecoreResource = ocl.getResourceSet().getResource(inputURI, true);
        MonikerTests.assertNoResourceErrors("Load failed", ecoreResource);
        MonikerTests.assertNoUnresolvedProxies("Unresolved proxies", ecoreResource);
        HashMap<String, EModelElement> monikerMap = new HashMap<String, EModelElement>();
        TreeIterator tit = ecoreResource.getAllContents();
        while (tit.hasNext()) {
            EObject eObject = (EObject)tit.next();
            if (!(eObject instanceof EModelElement)) continue;
            EModelElement eElement = (EModelElement)eObject;
            String moniker = Ecore2Moniker.toString((EModelElement)eElement);
            EModelElement oldElement = (EModelElement)monikerMap.get(moniker);
            if (oldElement != null) {
                MonikerTests.fail((String)("Duplicate moniker " + moniker + " for " + eElement.eClass().getName()));
            }
            monikerMap.put(moniker, eElement);
        }
        ocl.dispose();
    }

    public void doMonikerTestOCLstdlib(String stem) throws IOException {
        OCL ocl = OCL.newInstance((ProjectManager)MonikerTests.getProjectMap());
        String inputName = String.valueOf(stem) + ".oclstdlib";
        String pivotName = String.valueOf(stem) + ".oclas";
        URI inputURI = this.getProjectFileURI(inputName);
        URI pivotURI = this.getProjectFileURI(pivotName);
        BaseCSResource csResource = (BaseCSResource)ocl.getResourceSet().createResource(inputURI);
        csResource.setProjectManager((ProjectManager)MonikerTests.getProjectMap());
        JavaClassScope.getAdapter((BaseCSResource)csResource, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        csResource.load(null);
        MonikerTests.assertNoResourceErrors("Load failed", (Resource)csResource);
        MonikerTests.assertNoUnresolvedProxies("Unresolved proxies", (Resource)csResource);
        MonikerTests.assertNoValidationErrors("CS validation problems", (Resource)csResource);
        ASResource asResource = csResource.getASResource();
        MonikerTests.assertNoValidationErrors("Pivot validation problems", (Resource)asResource);
        asResource.setURI(pivotURI);
        asResource.save(XMIUtil.createSaveOptions());
        ocl.dispose();
    }

    public void testMoniker_Ecore_ecore() throws IOException, InterruptedException {
        this.doMonikerTestEcore("Ecore");
    }

    public void testMoniker_OCL_ecore() throws IOException, InterruptedException {
        this.doMonikerTestEcore("OCL");
    }

    public void testMoniker_OCLEcore_ecore() throws IOException, InterruptedException {
        this.doMonikerTestEcore("OCLEcore");
    }

    public void testMoniker_oclstdlib_oclstdlib() throws IOException, InterruptedException {
        this.doMonikerTestOCLstdlib("oclstdlib");
    }
}

