/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.test.xtext;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.xtext.tests.XtextTestCase;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.internal.ecore.es2as.Ecore2AS;
import org.eclipse.ocl.pivot.internal.manager.MetamodelManagerInternal;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.OCLInternal;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.utilities.XMIUtil;
import org.eclipse.ocl.xtext.base.cs2as.BaseCS2AS;
import org.eclipse.ocl.xtext.base.cs2as.CS2AS;
import org.eclipse.ocl.xtext.base.services.BaseLinkingService;
import org.eclipse.ocl.xtext.base.utilities.BaseCSResource;
import org.eclipse.ocl.xtext.oclinecore.as2cs.OCLinEcoreAS2CS;
import org.eclipse.ocl.xtext.oclstdlib.cs2as.OCLstdlibCS2AS;
import org.eclipse.ocl.xtext.oclstdlib.scoping.JavaClassScope;
import org.eclipse.xtext.diagnostics.IDiagnosticConsumer;
import org.eclipse.xtext.resource.impl.ListBasedDiagnosticConsumer;

public class PivotTests
extends XtextTestCase {
    public BaseCSResource doLoadOCLstdlib(@NonNull OCL ocl, @NonNull String stem, @NonNull String extension) throws IOException {
        ResourceSet resourceSet = ocl.getResourceSet();
        String inputName = String.valueOf(stem) + "." + extension;
        String outputName = String.valueOf(stem) + "." + extension + ".xmi";
        String output2Name = String.valueOf(stem) + ".saved." + extension;
        URI inputURI = this.getProjectFileURI(inputName);
        URI outputURI = this.getProjectFileURI(outputName);
        URI output2URI = this.getProjectFileURI(output2Name);
        BaseCSResource xtextResource = (BaseCSResource)resourceSet.createResource(inputURI);
        JavaClassScope.getAdapter((BaseCSResource)xtextResource, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        ocl.getEnvironmentFactory().adapt((Notifier)xtextResource);
        xtextResource.load(null);
        PivotTests.assertNoResourceErrors("Load failed", (Resource)xtextResource);
        PivotTests.assertNoUnresolvedProxies("Unresolved proxies", (Resource)xtextResource);
        xtextResource.setURI(output2URI);
        xtextResource.save(XMIUtil.createSaveOptions());
        PivotTests.assertNoResourceErrors("Save failed", (Resource)xtextResource);
        Resource xmiResource = resourceSet.createResource(outputURI);
        xmiResource.getContents().addAll((Collection)xtextResource.getContents());
        xmiResource.save(XMIUtil.createSaveOptions());
        PivotTests.assertNoResourceErrors("Save failed", xmiResource);
        xtextResource.getContents().addAll((Collection)xmiResource.getContents());
        return xtextResource;
    }

    protected void doPivotTestOCLstdlib(@NonNull OCL ocl, @NonNull String stem) throws IOException {
        String pivotName = String.valueOf(stem) + ".oclas";
        URI pivotURI = this.getProjectFileURI(pivotName);
        BaseCSResource csResource = this.doLoadOCLstdlib(ocl, stem, "oclstdlib");
        CS2AS cs2as = csResource.findCS2AS();
        ASResource asResource = cs2as.getASResource();
        OCLstdlibCS2AS creator = (OCLstdlibCS2AS)cs2as;
        new Checker((BaseCS2AS)creator).assertContainedBy((CS2AS)creator);
        PivotTests.assertNoValidationErrors("Pivot validation problems", (Resource)asResource);
        URI savedPivotURI = asResource.getURI();
        asResource.setURI(pivotURI);
        asResource.save(XMIUtil.createSaveOptions());
        asResource.setURI(savedPivotURI);
        new Checker((BaseCS2AS)creator).assertSameContents();
        OCLstdlibCS2AS updater = new OCLstdlibCS2AS(creator);
        updater.update((IDiagnosticConsumer)new ListBasedDiagnosticConsumer());
        new Checker((BaseCS2AS)creator).assertSameContents();
        this.assertPivotIsValid(pivotURI);
        ocl.dispose();
    }

    public void doPivotTestEcore(@NonNull String stem) throws IOException {
        OCLInternal ocl = OCLInternal.newInstance((ProjectManager)PivotTests.getProjectMap(), null);
        MetamodelManagerInternal metamodelManager = ocl.getMetamodelManager();
        ResourceSet asResourceSet = metamodelManager.getASResourceSet();
        String inputName = String.valueOf(stem) + ".ecore";
        String csName = String.valueOf(stem) + ".ecore.cs";
        URI inputURI = this.getProjectFileURI(inputName);
        URI csURI = this.getProjectFileURI(csName);
        Resource ecoreResource = ocl.getResourceSet().getResource(inputURI, true);
        PivotTests.assertNoResourceErrors("Load failed", ecoreResource);
        PivotTests.assertNoUnresolvedProxies("Unresolved proxies", ecoreResource);
        Ecore2AS ecore2as = Ecore2AS.getAdapter((Resource)ecoreResource, (EnvironmentFactoryInternal)metamodelManager.getEnvironmentFactory());
        Model pivotModel = ecore2as.getASModel();
        ASResource asResource = (ASResource)pivotModel.eResource();
        for (Resource pResource : asResourceSet.getResources()) {
            URI uri = pResource.getURI();
            if (uri.isFile()) {
                Map saveOptions = XMIUtil.createSaveOptions();
                saveOptions.put("DEBUG_LUSSID_COLLISIONS", Boolean.TRUE);
                saveOptions.put("DEBUG_XMIID_COLLISIONS", Boolean.TRUE);
                pResource.save(saveOptions);
            }
            PivotTests.assertNoResourceErrors("Pivot Save failed", pResource);
        }
        ResourceSetImpl csResourceSet = new ResourceSetImpl();
        csResourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("cs", new EcoreResourceFactoryImpl());
        csResourceSet.getPackageRegistry().put((Object)"http://www.eclipse.org/ocl/2015/Pivot", (Object)PivotPackage.eINSTANCE);
        Resource csResource = csResourceSet.createResource(csURI);
        HashMap cs2asResourceMap = new HashMap();
        OCLinEcoreAS2CS as2cs = new OCLinEcoreAS2CS(cs2asResourceMap, metamodelManager.getEnvironmentFactory());
        as2cs.update();
        csResource.save(XMIUtil.createSaveOptions());
        ocl.dispose();
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testPivot_oclstdlib_oclstdlib() throws IOException, InterruptedException {
        OCL ocl = OCL.newInstance((ProjectManager)PivotTests.getProjectMap());
        BaseLinkingService.DEBUG_RETRY.setState(true);
        this.doPivotTestOCLstdlib(ocl, "oclstdlib");
        ocl.dispose();
    }

    public void testPivot_Ecore_ecore() throws IOException, InterruptedException {
        this.doPivotTestEcore("Ecore");
    }

    public void testPivot_Names_ecore() throws IOException, InterruptedException {
        this.doPivotTestEcore("Names");
    }

    public static class Checker
    extends BaseCS2AS {
        private Checker(@NonNull BaseCS2AS aConverter) {
            super(aConverter);
        }

        public void assertContainedBy(@NonNull CS2AS thatConverter) {
        }

        public void assertSameContents() {
        }
    }
}

