/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.ecore.tests;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.ecore.CollectionType;
import org.eclipse.ocl.ecore.tests.AbstractTestSuite;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.ocl.expressions.CollectionLiteralExp;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.lpg.ProblemHandler;
import org.eclipse.ocl.options.Option;
import org.eclipse.ocl.options.ParsingOptions;
import org.eclipse.ocl.options.ProblemOption;

public class ComparisonTest
extends AbstractTestSuite {
    EPackage pkg;
    EClass thingType;
    EAttribute values;
    EAttribute bdValue;
    EAttribute biValue;
    EDataType valueType;
    EClass numeroType;
    EReference numeros;
    EClass comparable;
    EDataType myDataType;
    EObject thing;

    public void test_lessThan() {
        this.helper.setContext((Object)this.thingType);
        try {
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "1 < 2"));
            ComparisonTest.assertFalse((boolean)this.check(this.helper, this.thing, "21 < 2"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "1 < 2.0"));
            ComparisonTest.assertFalse((boolean)this.check(this.helper, this.thing, "21 < 2.0"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "1.0 < 2"));
            ComparisonTest.assertFalse((boolean)this.check(this.helper, this.thing, "21.0 < 2"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "1.0 < 2.0"));
            ComparisonTest.assertFalse((boolean)this.check(this.helper, this.thing, "21.0 < 2.0"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "'a' < 'b'"));
            ComparisonTest.assertFalse((boolean)this.check(this.helper, this.thing, "'ba' < 'b'"));
            this.thing.eSet((EStructuralFeature)this.bdValue, (Object)new BigDecimal("1"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue < 1.1"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue < 2"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue < 2.0"));
            this.thing.eSet((EStructuralFeature)this.bdValue, (Object)new BigDecimal("1.0"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue < 1.1"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue < 2"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue < 2.0"));
            this.thing.eSet((EStructuralFeature)this.bdValue, (Object)new BigDecimal("1.1"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue < 1.2"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue < 2"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue < 2.0"));
            this.thing.eSet((EStructuralFeature)this.biValue, (Object)new BigInteger("1"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "biValue < 2"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "biValue < 2.1"));
            List valuesList = (List)this.thing.eGet((EStructuralFeature)this.values);
            valuesList.add(new Value("a"));
            valuesList.add(new Value("b"));
            ParsingOptions.setOption((Environment)this.helper.getOCL().getEnvironment(), (Option)ParsingOptions.USE_COMPARE_TO_OPERATION, (Object)true);
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "values->at(1) < values->at(2)"));
            ComparisonTest.assertFalse((boolean)this.check(this.helper, this.thing, "values->at(2) < values->at(1)"));
        }
        catch (Exception e) {
            ComparisonTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_lessThanOrEqual() {
        this.helper.setContext((Object)this.thingType);
        try {
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "1 <= 2"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "1 <= 1"));
            ComparisonTest.assertFalse((boolean)this.check(this.helper, this.thing, "21 <= 2"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "1 <= 2.0"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "1 <= 1.0"));
            ComparisonTest.assertFalse((boolean)this.check(this.helper, this.thing, "21 <= 2.0"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "1.0 <= 2"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "1.0 <= 1"));
            ComparisonTest.assertFalse((boolean)this.check(this.helper, this.thing, "21.0 <= 2"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "1.0 <= 2.0"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "1.0 <= 1.0"));
            ComparisonTest.assertFalse((boolean)this.check(this.helper, this.thing, "21.0 <= 2.0"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "'a' <= 'b'"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "'a' <= 'a'"));
            ComparisonTest.assertFalse((boolean)this.check(this.helper, this.thing, "'ba' <= 'b'"));
            this.thing.eSet((EStructuralFeature)this.bdValue, (Object)new BigDecimal("1"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue <= 1"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue <= 1.0"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue <= 1.1"));
            this.thing.eSet((EStructuralFeature)this.bdValue, (Object)new BigDecimal("1.0"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue <= 1"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue <= 1.0"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue <= 1.1"));
            this.thing.eSet((EStructuralFeature)this.bdValue, (Object)new BigDecimal("1.1"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue <= 1.1"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue <= 2.0"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue <= 2"));
            this.thing.eSet((EStructuralFeature)this.biValue, (Object)new BigInteger("1"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "biValue <= 1"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "biValue <= 1.0"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "biValue <= 1.1"));
            List valuesList = (List)this.thing.eGet((EStructuralFeature)this.values);
            valuesList.add(new Value("a"));
            valuesList.add(new Value("b"));
            ParsingOptions.setOption((Environment)this.helper.getOCL().getEnvironment(), (Option)ParsingOptions.USE_COMPARE_TO_OPERATION, (Object)true);
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "values->at(1) <= values->at(2)"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "values->at(1) <= values->at(1)"));
            ComparisonTest.assertFalse((boolean)this.check(this.helper, this.thing, "values->at(2) <= values->at(1)"));
        }
        catch (Exception e) {
            ComparisonTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_greaterThan() {
        this.helper.setContext((Object)this.thingType);
        try {
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "2 > 1"));
            ComparisonTest.assertFalse((boolean)this.check(this.helper, this.thing, "2 > 21"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "2 > 1.0"));
            ComparisonTest.assertFalse((boolean)this.check(this.helper, this.thing, "2 > 21.0"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "2.0 > 1"));
            ComparisonTest.assertFalse((boolean)this.check(this.helper, this.thing, "2.0 > 21"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "2.0 > 1.0"));
            ComparisonTest.assertFalse((boolean)this.check(this.helper, this.thing, "2.0 > 21.0"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "'b' > 'a'"));
            ComparisonTest.assertFalse((boolean)this.check(this.helper, this.thing, "'a' > 'b'"));
            this.thing.eSet((EStructuralFeature)this.bdValue, (Object)new BigDecimal("1"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue > 0"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue > 0.0"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue > 0.1"));
            this.thing.eSet((EStructuralFeature)this.bdValue, (Object)new BigDecimal("1.0"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue > 0"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue > 0.0"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue > 0.1"));
            this.thing.eSet((EStructuralFeature)this.bdValue, (Object)new BigDecimal("1.1"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue > 1"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue > 1.0"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue > 1.09"));
            this.thing.eSet((EStructuralFeature)this.biValue, (Object)new BigInteger("1"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "biValue > 0"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "biValue > 0.1"));
            List valuesList = (List)this.thing.eGet((EStructuralFeature)this.values);
            valuesList.add(new Value("b"));
            valuesList.add(new Value("a"));
            ParsingOptions.setOption((Environment)this.helper.getOCL().getEnvironment(), (Option)ParsingOptions.USE_COMPARE_TO_OPERATION, (Object)true);
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "values->at(1) > values->at(2)"));
            ComparisonTest.assertFalse((boolean)this.check(this.helper, this.thing, "values->at(2) > values->at(1)"));
        }
        catch (Exception e) {
            ComparisonTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_greaterThanOrEqual() {
        this.helper.setContext((Object)this.thingType);
        try {
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "2 >= 1"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "2 >= 2"));
            ComparisonTest.assertFalse((boolean)this.check(this.helper, this.thing, "2 >= 21"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "2 >= 1.0"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "2 >= 2.0"));
            ComparisonTest.assertFalse((boolean)this.check(this.helper, this.thing, "2 >= 21.0"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "2.0 >= 1"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "2.0 >= 2"));
            ComparisonTest.assertFalse((boolean)this.check(this.helper, this.thing, "2.0 >= 21"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "2.0 >= 1.0"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "2.0 >= 2.0"));
            ComparisonTest.assertFalse((boolean)this.check(this.helper, this.thing, "2.0 >= 21.0"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "'b' >= 'a'"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "'b' >= 'b'"));
            ComparisonTest.assertFalse((boolean)this.check(this.helper, this.thing, "'a' >= 'b'"));
            this.thing.eSet((EStructuralFeature)this.bdValue, (Object)new BigDecimal("1"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue >= 1"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue >= 1.0"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue >= 0.9"));
            this.thing.eSet((EStructuralFeature)this.bdValue, (Object)new BigDecimal("1.0"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue >= 1"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue >= 1.0"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue >= 0.9"));
            this.thing.eSet((EStructuralFeature)this.bdValue, (Object)new BigDecimal("1.1"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue >= 1"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue >= 1.0"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "bdValue >= 1.1"));
            this.thing.eSet((EStructuralFeature)this.biValue, (Object)new BigInteger("1"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "biValue >= 0.9"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "biValue >= 1"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "biValue >= 1.0"));
            List valuesList = (List)this.thing.eGet((EStructuralFeature)this.values);
            valuesList.add(new Value("b"));
            valuesList.add(new Value("a"));
            ParsingOptions.setOption((Environment)this.helper.getOCL().getEnvironment(), (Option)ParsingOptions.USE_COMPARE_TO_OPERATION, (Object)true);
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "values->at(1) >= values->at(2)"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "values->at(1) >= values->at(1)"));
            ComparisonTest.assertFalse((boolean)this.check(this.helper, this.thing, "values->at(2) >= values->at(1)"));
        }
        catch (Exception e) {
            ComparisonTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_sortedBy() {
        this.helper.setContext((Object)this.thingType);
        try {
            List valuesList = (List)this.thing.eGet((EStructuralFeature)this.values);
            valuesList.add(new Value("b"));
            valuesList.add(new Value("c"));
            valuesList.add(new Value("a"));
            LinkedHashSet<Value> expected = new LinkedHashSet<Value>();
            expected.add((Value)valuesList.get(2));
            expected.add((Value)valuesList.get(0));
            expected.add((Value)valuesList.get(1));
            ComparisonTest.assertEquals(expected, (Object)this.evaluate(this.helper, this.thing, "values->sortedBy(e | e)"));
        }
        catch (Exception e) {
            ComparisonTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_invalid_equality() {
        this.helper.setContext((Object)this.thingType);
        try {
            ComparisonTest.assertFalse((boolean)this.check(this.helper, this.thing, "OclInvalid = 'a'"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "OclInvalid <> 'a'"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "OclInvalid = OclInvalid"));
            ComparisonTest.assertFalse((boolean)this.check(this.helper, this.thing, "OclInvalid <> OclInvalid"));
        }
        catch (Exception e) {
            ComparisonTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_void_equality() {
        this.helper.setContext((Object)this.thingType);
        try {
            ComparisonTest.assertFalse((boolean)this.check(this.helper, this.thing, "null = 'a'"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "null <> 'a'"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "null = null"));
            ComparisonTest.assertFalse((boolean)this.check(this.helper, this.thing, "null <> null"));
        }
        catch (Exception e) {
            ComparisonTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_integerArithmetic() {
        this.helper.setContext((Object)this.thingType);
        try {
            ComparisonTest.assertEquals((Object)new Integer(1), (Object)this.evaluate(this.helper, this.thing, "3 - 2"));
            ComparisonTest.assertEquals((Object)new Integer(3), (Object)this.evaluate(this.helper, this.thing, "1 + 2"));
            ComparisonTest.assertEquals((Object)new Double(2.0), (Object)this.evaluate(this.helper, this.thing, "6 / 3"));
            ComparisonTest.assertEquals((Object)new Integer(6), (Object)this.evaluate(this.helper, this.thing, "2 * 3"));
            ComparisonTest.assertEquals((Object)new Integer(-1), (Object)this.evaluate(this.helper, this.thing, "- 1"));
            ComparisonTest.assertEquals((Object)new Integer(3), (Object)this.evaluate(this.helper, this.thing, "(2 - 5).abs()"));
            ComparisonTest.assertEquals((Object)new Integer(3), (Object)this.evaluate(this.helper, this.thing, "3.max(2)"));
            ComparisonTest.assertEquals((Object)new Integer(2), (Object)this.evaluate(this.helper, this.thing, "3.min(2)"));
            ComparisonTest.assertEquals((Object)new Integer(3), (Object)this.evaluate(this.helper, this.thing, "7.div(2)"));
            ComparisonTest.assertEquals((Object)new Integer(1), (Object)this.evaluate(this.helper, this.thing, "7.mod(2)"));
        }
        catch (Exception e) {
            ComparisonTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_realArithmetic() {
        this.helper.setContext((Object)this.thingType);
        try {
            ComparisonTest.assertEquals((Object)new Double(1.0), (Object)this.evaluate(this.helper, this.thing, "3.0 - 2.0"));
            ComparisonTest.assertEquals((Object)new Double(3.0), (Object)this.evaluate(this.helper, this.thing, "1.0 + 2.0"));
            ComparisonTest.assertEquals((Object)new Double(2.0), (Object)this.evaluate(this.helper, this.thing, "6.0 / 3.0"));
            ComparisonTest.assertEquals((Object)new Double(6.0), (Object)this.evaluate(this.helper, this.thing, "2.0 * 3.0"));
            ComparisonTest.assertEquals((Object)new Double(-1.0), (Object)this.evaluate(this.helper, this.thing, "- 1.0"));
            ComparisonTest.assertEquals((Object)new Double(3.0), (Object)this.evaluate(this.helper, this.thing, "(2.0 - 5.0).abs()"));
            ComparisonTest.assertEquals((Object)new Double(3.0), (Object)this.evaluate(this.helper, this.thing, "3.0.max(2.0)"));
            ComparisonTest.assertEquals((Object)new Double(2.0), (Object)this.evaluate(this.helper, this.thing, "3.0.min(2.0)"));
        }
        catch (Exception e) {
            ComparisonTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_mixedArithmetic() {
        this.helper.setContext((Object)this.thingType);
        try {
            ComparisonTest.assertEquals((Object)new Double(1.0), (Object)this.evaluate(this.helper, this.thing, "3 - 2.0"));
            ComparisonTest.assertEquals((Object)new Double(3.0), (Object)this.evaluate(this.helper, this.thing, "1 + 2.0"));
            ComparisonTest.assertEquals((Object)new Double(2.0), (Object)this.evaluate(this.helper, this.thing, "6 / 3.0"));
            ComparisonTest.assertEquals((Object)new Double(6.0), (Object)this.evaluate(this.helper, this.thing, "2 * 3.0"));
            ComparisonTest.assertEquals((Object)new Double(3.0), (Object)this.evaluate(this.helper, this.thing, "3.max(2.0)"));
            ComparisonTest.assertEquals((Object)new Double(2.0), (Object)this.evaluate(this.helper, this.thing, "3.min(2.0)"));
        }
        catch (Exception e) {
            ComparisonTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_dotNotationForSymbolicOperationNames() {
        ParsingOptions.setOption((Environment)this.helper.getEnvironment(), (Option)ProblemOption.CONCEPTUAL_OPERATION_NAME, (Object)ProblemHandler.Severity.OK);
        this.helper.setContext((Object)EcorePackage.Literals.EINT);
        Integer minusOne = new Integer(-1);
        Integer one = new Integer(1);
        Integer two = new Integer(2);
        Double doubleTwo = new Double(2.0);
        Integer three = new Integer(3);
        Integer six = new Integer(6);
        try {
            ComparisonTest.assertEquals((Object)one, (Object)this.evaluate(this.helper, one, "3.-(2)"));
            ComparisonTest.assertEquals((Object)three, (Object)this.evaluate(this.helper, one, "1.+(2)"));
            ComparisonTest.assertEquals((Object)doubleTwo, (Object)this.evaluate(this.helper, one, "6./(3)"));
            ComparisonTest.assertEquals((Object)six, (Object)this.evaluate(this.helper, one, "2.*(3)"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, one, "1.<(2)"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, one, "1.<=(2)"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, one, "2.>=(1)"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, one, "2.>(1)"));
            ComparisonTest.assertEquals((Object)one, (Object)this.evaluate(this.helper, three, "self.-(2)"));
            ComparisonTest.assertEquals((Object)three, (Object)this.evaluate(this.helper, one, "self.+(2)"));
            ComparisonTest.assertEquals((Object)doubleTwo, (Object)this.evaluate(this.helper, six, "self./(3)"));
            ComparisonTest.assertEquals((Object)six, (Object)this.evaluate(this.helper, two, "self.*(3)"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, one, "self.<(2)"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, one, "self.<=(2)"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, two, "self.>=(1)"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, two, "self.>(1)"));
            ComparisonTest.assertEquals((Object)minusOne, (Object)this.evaluate(this.helper, one, "-1"));
            ComparisonTest.assertEquals((Object)minusOne, (Object)this.evaluate(this.helper, one, "-self"));
            ComparisonTest.assertEquals((Object)minusOne, (Object)this.evaluate(this.helper, one, "self.\"-\"()"));
            ComparisonTest.assertEquals((Object)minusOne, (Object)this.evaluate(this.helper, one, "self.-()"));
            ComparisonTest.assertEquals((Object)one, (Object)this.evaluate(this.helper, one, "- self.\"-\"()"));
            ComparisonTest.assertEquals((Object)one, (Object)this.evaluate(this.helper, one, "- self.-()"));
            ComparisonTest.assertEquals((Object)one, (Object)this.evaluate(this.helper, one, "- -1"));
            ComparisonTest.assertEquals((Object)one, (Object)this.evaluate(this.helper, one, "- -self"));
            this.helper.setContext((Object)EcorePackage.Literals.EBOOLEAN);
            ComparisonTest.assertEquals((Object)Boolean.FALSE, (Object)this.evaluate(this.helper, Boolean.TRUE, "not self"));
            ComparisonTest.assertEquals((Object)Boolean.FALSE, (Object)this.evaluate(this.helper, Boolean.TRUE, "self.\"not\"()"));
            ComparisonTest.assertEquals((Object)Boolean.FALSE, (Object)this.evaluate(this.helper, Boolean.TRUE, "self.not()"));
            ComparisonTest.assertEquals((Object)Boolean.TRUE, (Object)this.evaluate(this.helper, Boolean.TRUE, "not not self"));
            ComparisonTest.assertEquals((Object)Boolean.TRUE, (Object)this.evaluate(this.helper, Boolean.TRUE, "not self._not()"));
            ComparisonTest.assertEquals((Object)Boolean.TRUE, (Object)this.evaluate(this.helper, Boolean.TRUE, "not self.not()"));
        }
        catch (Exception e) {
            ComparisonTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
        ParsingOptions.setOption((Environment)this.helper.getEnvironment(), (Option)ProblemOption.CONCEPTUAL_OPERATION_NAME, (Object)ProblemHandler.Severity.ERROR);
        try {
            ComparisonTest.assertEquals((Object)one, (Object)this.evaluate(this.helper, one, "3.-(2)"));
            ComparisonTest.fail((String)"Missing exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void test_javaImplementationsOfInfixOperators() {
        this.helper.setContext((Object)this.thingType);
        Numero three = new Numero(3L);
        Numero four = new Numero(4L);
        Numero eight = new Numero(8L);
        Numero twelve = new Numero(12L);
        try {
            ComparisonTest.assertEquals((Object)((Object)four), (Object)this.evaluate(this.helper, this.thing, "numeros->at(1) - numeros->at(2)"));
            ComparisonTest.assertEquals((Object)((Object)eight), (Object)this.evaluate(this.helper, this.thing, "numeros->at(1) + numeros->at(2)"));
            ComparisonTest.assertEquals((Object)((Object)three), (Object)this.evaluate(this.helper, this.thing, "numeros->at(1) / numeros->at(2)"));
            ComparisonTest.assertEquals((Object)((Object)twelve), (Object)this.evaluate(this.helper, this.thing, "numeros->at(1) * numeros->at(2)"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "numeros->at(2) < numeros->at(1)"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "numeros->at(2) <= numeros->at(1)"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "numeros->at(1) > numeros->at(2)"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "numeros->at(1) >= numeros->at(2)"));
        }
        catch (Exception e) {
            ComparisonTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_comparisonOfBooleanOperations_137487() {
        EClass ctx = EcorePackage.eINSTANCE.getEClass();
        this.helper.setContext((Object)ctx.eClass());
        try {
            ComparisonTest.assertTrue((boolean)this.check(this.helper, ctx, "self.isSuperTypeOf(self)"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, ctx, "self.isSuperTypeOf(self) and true"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, ctx, "self.isSuperTypeOf(self) or false"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, ctx, "self.isSuperTypeOf(self) xor false"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, ctx, "self.isSuperTypeOf(self) implies true"));
            ComparisonTest.assertFalse((boolean)this.check(this.helper, ctx, "self.isSuperTypeOf(self) implies false"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, ctx, "self.isSuperTypeOf(self) = true"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, ctx, "self.isSuperTypeOf(self) <> false"));
        }
        catch (Exception e) {
            ComparisonTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_enumerationLiteralEquality_137546() {
        CollectionKind[] collectionKindArray = CollectionKind.values();
        int n = collectionKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            CollectionKind kind = collectionKindArray[n2];
            CollectionLiteralExp ctx = this.oclFactory.createCollectionLiteralExp();
            ctx.setKind(kind);
            this.helper.setInstanceContext((Object)ctx);
            try {
                ComparisonTest.assertTrue((boolean)this.check(this.helper, ctx, "ocl::expressions::CollectionKind::\"" + kind.getLiteral() + "\" = self.kind"));
                ComparisonTest.assertTrue((boolean)this.check(this.helper, ctx, "self.kind = ocl::expressions::CollectionKind::\"" + kind.getLiteral() + '\"'));
            }
            catch (Exception e) {
                ComparisonTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
            }
            ++n2;
        }
    }

    public void test_dataTypes_137158() {
        EPackage epackage = EcoreFactory.eINSTANCE.createEPackage();
        epackage.setName("mypkg");
        EClass eclass = EcoreFactory.eINSTANCE.createEClass();
        eclass.setName("B");
        epackage.getEClassifiers().add((Object)eclass);
        EOperation eoperation = EcoreFactory.eINSTANCE.createEOperation();
        eoperation.setName("f");
        EDataType edatatype = EcoreFactory.eINSTANCE.createEDataType();
        edatatype.setName("Thread");
        edatatype.setInstanceClass(Thread.class);
        epackage.getEClassifiers().add((Object)edatatype);
        eoperation.setEType((EClassifier)edatatype);
        eclass.getEOperations().add((Object)eoperation);
        this.helper.setContext((Object)eclass);
        try {
            OCLExpression expr = this.helper.createQuery("self.f()");
            EClassifier type = (EClassifier)expr.getType();
            ComparisonTest.assertSame((Object)edatatype, (Object)type);
            eoperation.setUpperBound(-1);
            expr = this.helper.createQuery("self.f()");
            type = (EClassifier)expr.getType();
            ComparisonTest.assertTrue((boolean)(type instanceof org.eclipse.ocl.types.CollectionType));
            type = (EClassifier)((CollectionType)type).getElementType();
            ComparisonTest.assertSame((Object)edatatype, (Object)type);
            eoperation.setUpperBound(1);
            eoperation.setEType((EClassifier)EcorePackage.Literals.EJAVA_OBJECT);
            expr = this.helper.createQuery("self.f()");
            type = (EClassifier)expr.getType();
            ComparisonTest.assertSame((Object)this.getOCLStandardLibrary().getOclAny(), (Object)type);
        }
        catch (Exception e) {
            ComparisonTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_supportForELongAttributes_198451() {
        this.helper.setContext((Object)this.thingType);
        long maxInt = Integer.MAX_VALUE;
        long maxIntMinusOne = 0x7FFFFFFEL;
        long maxIntSquared = 4611686014132420609L;
        double quotient = (double)maxIntSquared / (double)maxIntMinusOne;
        Numero maxIntN = new Numero(maxInt);
        Numero maxIntMinusOneN = new Numero(maxIntMinusOne);
        Numero maxIntSquaredN = new Numero(maxIntSquared);
        EList list = (EList)this.thing.eGet((EStructuralFeature)this.numeros);
        list.clear();
        list.add((Object)maxIntN);
        list.add((Object)maxIntMinusOneN);
        list.add((Object)maxIntSquaredN);
        list.add((Object)new Numero(1L));
        try {
            ComparisonTest.assertEquals((Object)1, (Object)this.evaluate(this.helper, this.thing, "numeros->at(1).asLong() - numeros->at(2).asLong()"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "numeros->at(4).asLong() = 1"));
            ComparisonTest.assertTrue((boolean)this.check(this.helper, this.thing, "numeros->at(4).asLong() <> 2"));
            ComparisonTest.assertEquals((Object)quotient, (Object)this.evaluate(this.helper, this.thing, "numeros->at(3).asLong() / numeros->at(2).asLong()"));
            ComparisonTest.assertEquals((Object)((int)maxIntMinusOne), (Object)this.evaluate(this.helper, this.thing, String.format("(%d + %d).div(2) - 1", maxInt, maxInt)));
            ComparisonTest.assertEquals((Object)maxIntSquared, (Object)this.evaluate(this.helper, this.thing, String.format("%d * %d", maxInt, maxInt)));
        }
        catch (Exception e) {
            ComparisonTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_OclAny_equals_unrelatedArgumentTypes() {
        this.helper.setContext((Object)this.fruit);
        try {
            this.helper.createInvariant("not Apple.allInstances()->exists(a | a = self)");
            this.helper.createInvariant("not ecore::EClass.allInstances()->exists(c | c = self)");
        }
        catch (Exception e) {
            ComparisonTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_OclAny_notEquals_unrelatedArgumentTypes() {
        this.helper.setContext((Object)this.fruit);
        try {
            this.helper.createInvariant("Apple.allInstances()->forAll(a | a <> self)");
            this.helper.createInvariant("ecore::EClass.allInstances()->forAll(c | c <> self)");
        }
        catch (Exception e) {
            ComparisonTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_compareToOnlyUsedByJavaImplementation_212804() {
        this.helper.setContext((Object)this.comparable);
        try {
            this.helper.createInvariant("Comparable.allInstances()->forAll(c | self >= c)");
            ComparisonTest.fail((String)"Should not have parsed");
        }
        catch (ParserException e) {
            ComparisonTest.debugPrintln((String)("Got expected exception: " + e.getLocalizedMessage()));
        }
        catch (Exception e) {
            ComparisonTest.fail((String)("Unexpected exception during parse: " + e.getLocalizedMessage()));
        }
    }

    public void test_comparableDataTypes_212804() {
        this.helper.setContext((Object)this.myDataType);
        try {
            this.helper.createInvariant("MyDataType.allInstances()->forAll(d | self >= d)");
            ComparisonTest.fail((String)"Should not have parsed");
        }
        catch (ParserException e) {
            ComparisonTest.debugPrintln((String)("Got expected exception: " + e.getLocalizedMessage()));
        }
        catch (Exception e) {
            ComparisonTest.fail((String)("Unexpected exception during parse: " + e.getLocalizedMessage()));
        }
    }

    protected void setUp() {
        super.setUp();
        this.pkg = EcoreFactory.eINSTANCE.createEPackage();
        this.pkg.setName("pkg");
        EFactory factory = EcoreFactory.eINSTANCE.createEFactory();
        this.pkg.setEFactoryInstance(factory);
        this.valueType = EcoreFactory.eINSTANCE.createEDataType();
        this.valueType.setName("Value");
        this.valueType.setInstanceClass(Value.class);
        this.pkg.getEClassifiers().add((Object)this.valueType);
        this.thingType = EcoreFactory.eINSTANCE.createEClass();
        this.thingType.setName("Thing");
        this.pkg.getEClassifiers().add((Object)this.thingType);
        this.bdValue = EcoreFactory.eINSTANCE.createEAttribute();
        this.bdValue.setName("bdValue");
        this.bdValue.setEType((EClassifier)EcorePackage.Literals.EBIG_DECIMAL);
        this.bdValue.setUpperBound(1);
        this.thingType.getEStructuralFeatures().add((Object)this.bdValue);
        this.biValue = EcoreFactory.eINSTANCE.createEAttribute();
        this.biValue.setName("biValue");
        this.biValue.setEType((EClassifier)EcorePackage.Literals.EBIG_INTEGER);
        this.biValue.setUpperBound(1);
        this.thingType.getEStructuralFeatures().add((Object)this.biValue);
        this.values = EcoreFactory.eINSTANCE.createEAttribute();
        this.values.setName("values");
        this.values.setEType((EClassifier)this.valueType);
        this.values.setUpperBound(-1);
        this.thingType.getEStructuralFeatures().add((Object)this.values);
        this.numeroType = EcoreFactory.eINSTANCE.createEClass();
        this.numeroType.setName("Numero");
        this.numeroType.setInstanceClass(Numero.class);
        this.pkg.getEClassifiers().add((Object)this.numeroType);
        EOperation oper = EcoreFactory.eINSTANCE.createEOperation();
        oper.setName("+");
        EParameter parm = EcoreFactory.eINSTANCE.createEParameter();
        parm.setName("n");
        parm.setEType((EClassifier)this.numeroType);
        oper.getEParameters().add((Object)parm);
        oper.setEType((EClassifier)this.numeroType);
        this.numeroType.getEOperations().add((Object)oper);
        oper = EcoreFactory.eINSTANCE.createEOperation();
        oper.setName("-");
        parm = EcoreFactory.eINSTANCE.createEParameter();
        parm.setName("n");
        parm.setEType((EClassifier)this.numeroType);
        oper.getEParameters().add((Object)parm);
        oper.setEType((EClassifier)this.numeroType);
        this.numeroType.getEOperations().add((Object)oper);
        oper = EcoreFactory.eINSTANCE.createEOperation();
        oper.setName("*");
        parm = EcoreFactory.eINSTANCE.createEParameter();
        parm.setName("n");
        parm.setEType((EClassifier)this.numeroType);
        oper.getEParameters().add((Object)parm);
        oper.setEType((EClassifier)this.numeroType);
        this.numeroType.getEOperations().add((Object)oper);
        oper = EcoreFactory.eINSTANCE.createEOperation();
        oper.setName("/");
        parm = EcoreFactory.eINSTANCE.createEParameter();
        parm.setName("n");
        parm.setEType((EClassifier)this.numeroType);
        oper.getEParameters().add((Object)parm);
        oper.setEType((EClassifier)this.numeroType);
        this.numeroType.getEOperations().add((Object)oper);
        oper = EcoreFactory.eINSTANCE.createEOperation();
        oper.setName("-");
        oper.setEType((EClassifier)this.numeroType);
        this.numeroType.getEOperations().add((Object)oper);
        oper = EcoreFactory.eINSTANCE.createEOperation();
        oper.setName("<");
        parm = EcoreFactory.eINSTANCE.createEParameter();
        parm.setName("n");
        parm.setEType((EClassifier)this.numeroType);
        oper.getEParameters().add((Object)parm);
        oper.setEType((EClassifier)EcorePackage.Literals.EBOOLEAN);
        this.numeroType.getEOperations().add((Object)oper);
        oper = EcoreFactory.eINSTANCE.createEOperation();
        oper.setName("<=");
        parm = EcoreFactory.eINSTANCE.createEParameter();
        parm.setName("n");
        parm.setEType((EClassifier)this.numeroType);
        oper.getEParameters().add((Object)parm);
        oper.setEType((EClassifier)EcorePackage.Literals.EBOOLEAN);
        this.numeroType.getEOperations().add((Object)oper);
        oper = EcoreFactory.eINSTANCE.createEOperation();
        oper.setName(">");
        parm = EcoreFactory.eINSTANCE.createEParameter();
        parm.setName("n");
        parm.setEType((EClassifier)this.numeroType);
        oper.getEParameters().add((Object)parm);
        oper.setEType((EClassifier)EcorePackage.Literals.EBOOLEAN);
        this.numeroType.getEOperations().add((Object)oper);
        oper = EcoreFactory.eINSTANCE.createEOperation();
        oper.setName(">=");
        parm = EcoreFactory.eINSTANCE.createEParameter();
        parm.setName("n");
        parm.setEType((EClassifier)this.numeroType);
        oper.getEParameters().add((Object)parm);
        oper.setEType((EClassifier)EcorePackage.Literals.EBOOLEAN);
        this.numeroType.getEOperations().add((Object)oper);
        oper = EcoreFactory.eINSTANCE.createEOperation();
        oper.setName("asLong");
        oper.setEType((EClassifier)EcorePackage.Literals.ELONG);
        this.numeroType.getEOperations().add((Object)oper);
        this.numeros = EcoreFactory.eINSTANCE.createEReference();
        this.numeros.setName("numeros");
        this.numeros.setEType((EClassifier)this.numeroType);
        this.numeros.setUpperBound(-1);
        this.numeros.setOrdered(true);
        this.thingType.getEStructuralFeatures().add((Object)this.numeros);
        this.thing = factory.create(this.thingType);
        this.comparable = EcoreFactory.eINSTANCE.createEClass();
        this.comparable.setName("Comparable");
        this.comparable.setAbstract(true);
        this.pkg.getEClassifiers().add((Object)this.comparable);
        oper = EcoreFactory.eINSTANCE.createEOperation();
        oper.setName("compareTo");
        parm = EcoreFactory.eINSTANCE.createEParameter();
        parm.setName("c");
        parm.setEType((EClassifier)this.comparable);
        oper.getEParameters().add((Object)parm);
        oper.setEType((EClassifier)EcorePackage.Literals.EINT);
        this.comparable.getEOperations().add((Object)oper);
        this.myDataType = EcoreFactory.eINSTANCE.createEDataType();
        this.myDataType.setName("MyDataType");
        this.myDataType.setInstanceClass(Thread.State.class);
        this.pkg.getEClassifiers().add((Object)this.myDataType);
        EList list = (EList)this.thing.eGet((EStructuralFeature)this.numeros);
        list.add((Object)new Numero(6L));
        list.add((Object)new Numero(2L));
    }

    public static class Numero
    extends EObjectImpl {
        private long value;

        Numero() {
        }

        Numero(long value) {
            this.value = value;
        }

        public Numero plus(Numero n) {
            return new Numero(this.value + n.value);
        }

        public Numero minus(Numero n) {
            return new Numero(this.value - n.value);
        }

        public Numero times(Numero n) {
            return new Numero(this.value * n.value);
        }

        public Numero divide(Numero n) {
            return new Numero(this.value / n.value);
        }

        public Numero minus() {
            return new Numero(-this.value);
        }

        public boolean lessThan(Numero n) {
            return this.value < n.value;
        }

        public boolean lessThanEqual(Numero n) {
            return this.value <= n.value;
        }

        public boolean greaterThan(Numero n) {
            return this.value > n.value;
        }

        public boolean greaterThanEqual(Numero n) {
            return this.value >= n.value;
        }

        public long asLong() {
            return this.value;
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + (int)(this.value & 0xFFFFL);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Numero other = (Numero)((Object)obj);
            return this.value == other.value;
        }

        public String toString() {
            return "Numero(" + this.value + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Value
    implements Comparable<Value> {
        private final String value;

        Value(String value) {
            this.value = value;
        }

        @Override
        public int compareTo(Value arg0) {
            return this.value.compareTo(arg0.value);
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Value other = (Value)obj;
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }
    }
}

