/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.uml.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.types.CollectionType;
import org.eclipse.ocl.uml.TupleType;
import org.eclipse.ocl.uml.tests.AbstractTestSuite;
import org.eclipse.ocl.util.Tuple;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;

public class CollectionsTest
extends AbstractTestSuite {
    public void test_insertAt_sequence_126722() {
        this.helper.setContext((Object)((Classifier)this.getUMLString()));
        try {
            OCLExpression expr = this.helper.createQuery("Sequence{'a', 'b', 'd', 'e'}->insertAt(3, 'c')");
            List result = (List)this.ocl.evaluate((Object)"", expr);
            List<Object> expected = Arrays.asList("a", "b", "c", "d", "e");
            CollectionsTest.assertEquals(expected, (Object)result);
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_insertAt_orderedSet_126722() {
        this.helper.setContext((Object)((Classifier)this.getUMLString()));
        try {
            OCLExpression expr = this.helper.createQuery("OrderedSet{'a', 'b', 'd', 'e'}->insertAt(3, 'c')");
            Set result = (Set)this.ocl.evaluate((Object)"", expr);
            List<Object> expected = Arrays.asList("a", "b", "c", "d", "e");
            CollectionsTest.assertEquals(expected, new ArrayList(result));
            expr = this.helper.createQuery("OrderedSet{'a', 'b', 'c', 'd', 'e'}->insertAt(5, 'c')");
            result = (Set)this.ocl.evaluate((Object)"", expr);
            expected = Arrays.asList("a", "b", "c", "d", "e");
            CollectionsTest.assertEquals(expected, new ArrayList(result));
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_prepend_sequence_126722() {
        this.helper.setContext((Object)((Classifier)this.getUMLString()));
        try {
            OCLExpression expr = this.helper.createQuery("Sequence{'a', 'b', 'd', 'e'}->prepend('c')");
            List result = (List)this.ocl.evaluate((Object)"", expr);
            List<Object> expected = Arrays.asList("c", "a", "b", "d", "e");
            CollectionsTest.assertEquals(expected, (Object)result);
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_prepend_orderedSet_126722() {
        this.helper.setContext((Object)((Classifier)this.getUMLString()));
        try {
            OCLExpression expr = this.helper.createQuery("OrderedSet{'a', 'b', 'd', 'e'}->prepend('c')");
            Set result = (Set)this.ocl.evaluate((Object)"", expr);
            List<Object> expected = Arrays.asList("c", "a", "b", "d", "e");
            CollectionsTest.assertEquals(expected, new ArrayList(result));
            expr = this.helper.createQuery("OrderedSet{'a', 'b', 'c', 'd', 'e'}->prepend('c')");
            result = (Set)this.ocl.evaluate((Object)"", expr);
            expected = Arrays.asList("c", "a", "b", "d", "e");
            CollectionsTest.assertEquals(expected, new ArrayList(result));
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_append_sequence_126722() {
        this.helper.setContext((Object)((Classifier)this.getUMLString()));
        try {
            OCLExpression expr = this.helper.createQuery("Sequence{'a', 'b', 'd', 'e'}->append('c')");
            List result = (List)this.ocl.evaluate((Object)"", expr);
            List<Object> expected = Arrays.asList("a", "b", "d", "e", "c");
            CollectionsTest.assertEquals(expected, (Object)result);
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_append_orderedSet_126722() {
        this.helper.setContext((Object)((Classifier)this.getUMLString()));
        try {
            OCLExpression expr = this.helper.createQuery("OrderedSet{'a', 'b', 'd', 'e'}->append('c')");
            Set result = (Set)this.ocl.evaluate((Object)"", expr);
            List<Object> expected = Arrays.asList("a", "b", "d", "e", "c");
            CollectionsTest.assertEquals(expected, new ArrayList(result));
            expr = this.helper.createQuery("OrderedSet{'a', 'b', 'c', 'd', 'e'}->append('c')");
            result = (Set)this.ocl.evaluate((Object)"", expr);
            expected = Arrays.asList("a", "b", "d", "e", "c");
            CollectionsTest.assertEquals(expected, new ArrayList(result));
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_including_sequence_126722() {
        this.helper.setContext((Object)((Classifier)this.getUMLString()));
        try {
            OCLExpression expr = this.helper.createQuery("Sequence{'a', 'b', 'd', 'e'}->including('c')");
            List result = (List)this.ocl.evaluate((Object)"", expr);
            List<Object> expected = Arrays.asList("a", "b", "d", "e", "c");
            CollectionsTest.assertEquals(expected, (Object)result);
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_including_orderedSet_126722() {
        this.helper.setContext((Object)((Classifier)this.getUMLString()));
        try {
            OCLExpression expr = this.helper.createQuery("OrderedSet{'a', 'b', 'd', 'e'}->including('c')");
            Set result = (Set)this.ocl.evaluate((Object)"", expr);
            HashSet<Object> expected = new HashSet<Object>(Arrays.asList("a", "b", "d", "e", "c"));
            CollectionsTest.assertEquals(expected, (Object)result);
            expr = this.helper.createQuery("OrderedSet{'a', 'b', 'c', 'd', 'e'}->including('c')");
            result = (Set)this.ocl.evaluate((Object)"", expr);
            expected = new HashSet<Object>(Arrays.asList("a", "b", "c", "d", "e"));
            CollectionsTest.assertEquals(expected, (Object)result);
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_excluding_sequence_126722() {
        this.helper.setContext((Object)((Classifier)this.getUMLString()));
        try {
            OCLExpression expr = this.helper.createQuery("Sequence{'a', 'b', 'c', 'd', 'e'}->excluding('c')");
            List result = (List)this.ocl.evaluate((Object)"", expr);
            List<Object> expected = Arrays.asList("a", "b", "d", "e");
            CollectionsTest.assertEquals(expected, (Object)result);
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_excluding_orderedSet_126722() {
        this.helper.setContext((Object)((Classifier)this.getUMLString()));
        try {
            OCLExpression expr = this.helper.createQuery("OrderedSet{'a', 'b', 'c', 'd', 'e'}->excluding('c')");
            Set result = (Set)this.ocl.evaluate((Object)"", expr);
            HashSet<Object> expected = new HashSet<Object>(Arrays.asList("a", "b", "d", "e"));
            CollectionsTest.assertEquals(expected, (Object)result);
            expr = this.helper.createQuery("OrderedSet{'a', 'b', 'd', 'e'}->excluding('c')");
            result = (Set)this.ocl.evaluate((Object)"", expr);
            expected = new HashSet<Object>(Arrays.asList("a", "b", "d", "e"));
            CollectionsTest.assertEquals(expected, (Object)result);
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_first() {
        this.helper.setContext((Object)((Classifier)this.getUMLString()));
        try {
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Sequence{'a', 'b', 'c', 'd', 'e'}->first() = 'a'"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "OrderedSet{'a', 'b', 'c', 'd', 'e'}->first() = 'a'"));
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_last() {
        this.helper.setContext((Object)((Classifier)this.getUMLString()));
        try {
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Sequence{'a', 'b', 'c', 'd', 'e'}->last() = 'e'"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "OrderedSet{'a', 'b', 'c', 'd', 'e'}->last() = 'e'"));
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_at() {
        this.helper.setContext((Object)((Classifier)this.getUMLString()));
        try {
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Sequence{'a', 'b', 'c', 'd', 'e'}->at(3) = 'c'"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "OrderedSet{'a', 'b', 'c', 'd', 'e'}->at(3)= 'c'"));
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_indexOf() {
        this.helper.setContext((Object)((Classifier)this.getUMLString()));
        try {
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Sequence{'a', 'b', 'c', 'd', 'e'}->indexOf('c') = 3"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "OrderedSet{'a', 'b', 'c', 'd', 'e'}->indexOf('c')= 3"));
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_subsequence_suborderedset() {
        this.helper.setContext((Object)((Classifier)this.getUMLString()));
        try {
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Sequence{'a', 'b', 'c', 'd', 'e'}->subSequence(2, 4) = Sequence{'b', 'c', 'd'}"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "OrderedSet{'a', 'b', 'c', 'd', 'e'}->subOrderedSet(2, 4) = OrderedSet{'b', 'c', 'd'}"));
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_flatten() {
        this.helper.setContext((Object)((Classifier)this.getUMLString()));
        try {
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Set{Sequence{'a', 'b'}, Sequence{'b', 'c', 'd'}}->flatten() = Set{'b', 'c', 'a', 'd'}"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "OrderedSet{Sequence{'a', 'b'}, Sequence{'b', 'c', 'd'}}->flatten() = Set{'b', 'c', 'a', 'd'}"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Sequence{OrderedSet{'a', 'b', 'd'}, OrderedSet{'b', 'c', 'd'}}->flatten() = Sequence{'a', 'b', 'd', 'b', 'c', 'd'}"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Bag{Bag{'b', 'a', 'b'}, Bag{'b', 'a', 'c', 'd'}}->flatten() = Bag{'a', 'a', 'b', 'b', 'b', 'c', 'd'}"));
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_flatten_notNested() {
        this.helper.setContext((Object)((Classifier)this.getUMLString()));
        try {
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Set{'a', 'b', 'c', 'd'}->flatten() = Set{'b', 'c', 'a', 'd'}"));
            CollectionsTest.assertFalse((boolean)this.check(this.helper, "", "OrderedSet{'a', 'b', 'b', 'c', 'd'}->flatten() = Set{'b', 'c', 'a', 'd'}"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "OrderedSet{'a', 'b', 'b', 'c', 'd'}->flatten() = OrderedSet{'a', 'b', 'c', 'd'}"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Sequence{'a', 'b', 'd', 'b', 'c', 'd'}->flatten() = Sequence{'a', 'b', 'd', 'b', 'c', 'd'}"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Bag{'b', 'a', 'b', 'b', 'a', 'c', 'd'}->flatten() = Bag{'a', 'a', 'b', 'b', 'b', 'c', 'd'}"));
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_count() {
        this.helper.setContext((Object)((Classifier)this.getUMLInteger()));
        try {
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Sequence{1, 2, 3, 3, 4, 5}->count(3) = 2"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Sequence{1, 2, 3, 3, 4, 5}->count(6) = 0"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "OrderedSet{1, 2, 3, 3, 4, 5}->count(3) = 1"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "OrderedSet{1, 2, 3, 3, 4, 5}->count(6) = 0"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Set{1, 2, 3, 3, 4, 5}->count(3) = 1"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Set{1, 2, 3, 3, 4, 5}->count(6) = 0"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Bag{1, 2, 3, 3, 4, 5}->count(3) = 2"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Bag{1, 2, 3, 3, 4, 5}->count(6) = 0"));
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_sum() {
        this.helper.setContext((Object)((Classifier)this.getUMLInteger()));
        try {
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Sequence{1, 2, 3, 3, 4, 5}->sum() = 18"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "OrderedSet{1, 2, 3, 3, 4, 5}->sum() = 15"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Set{1, 2, 3, 3, 4, 5}->sum() = 15"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Bag{1, 2, 3, 3, 4, 5}->sum() = 18"));
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_includes() {
        this.helper.setContext((Object)((Classifier)this.getUMLInteger()));
        try {
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Sequence{1, 2, 3, 3, 4, 5}->includes(3)"));
            CollectionsTest.assertFalse((boolean)this.check(this.helper, "", "Sequence{1, 2, 3, 3, 4, 5}->includes(6)"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Set{1, 2, 3, 3, 4, 5}->includes(3)"));
            CollectionsTest.assertFalse((boolean)this.check(this.helper, "", "Set{1, 2, 3, 3, 4, 5}->includes(6)"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "OrderedSet{1, 2, 3, 3, 4, 5}->includes(3)"));
            CollectionsTest.assertFalse((boolean)this.check(this.helper, "", "OrderedSet{1, 2, 3, 3, 4, 5}->includes(6)"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Bag{1, 2, 3, 3, 4, 5}->includes(3)"));
            CollectionsTest.assertFalse((boolean)this.check(this.helper, "", "Bag{1, 2, 3, 3, 4, 5}->includes(6)"));
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_includesAll() {
        this.helper.setContext((Object)((Classifier)this.getUMLInteger()));
        try {
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Sequence{1, 2, 3, 3, 4, 5}->includesAll(Sequence{1, 3})"));
            CollectionsTest.assertFalse((boolean)this.check(this.helper, "", "Sequence{1, 2, 3, 3, 4, 5}->includesAll(Sequence{1, 6})"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Set{1, 2, 3, 3, 4, 5}->includesAll(Set{1, 3})"));
            CollectionsTest.assertFalse((boolean)this.check(this.helper, "", "Set{1, 2, 3, 3, 4, 5}->includesAll(Set{1, 6})"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "OrderedSet{1, 2, 3, 3, 4, 5}->includesAll(OrderedSet{1, 3})"));
            CollectionsTest.assertFalse((boolean)this.check(this.helper, "", "OrderedSet{1, 2, 3, 3, 4, 5}->includesAll(OrderedSet{1, 6})"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Bag{1, 2, 3, 3, 4, 5}->includesAll(Bag{1, 3})"));
            CollectionsTest.assertFalse((boolean)this.check(this.helper, "", "Bag{1, 2, 3, 3, 4, 5}->includesAll(Bag{1, 6})"));
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_union() {
        this.helper.setContext((Object)((Classifier)this.getUMLInteger()));
        try {
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Set{1, 2, 3}->union(Set{3, 4, 5}) = Set{1, 2, 3, 4, 5}"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "OrderedSet{1, 2, 3}->union(Set{3, 4, 5}) = Set{1, 2, 3, 4, 5}"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Bag{1, 2, 2, 3}->union(Set{3, 4, 5}) = Bag{1, 2, 2, 3, 3, 4, 5}"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Bag{1, 2, 3}->union(Bag{3, 3, 4, 5}) = Bag{1, 2, 3, 3, 3, 4, 5}"));
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_intersection() {
        this.helper.setContext((Object)((Classifier)this.getUMLInteger()));
        try {
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Set{1, 2, 3}->intersection(Set{3, 4, 5}) = Set{3}"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "OrderedSet{1, 2, 3}->intersection(Set{3, 4, 5}) = Set{3}"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Bag{1, 2, 2, 3, 3, 3}->intersection(Bag{3, 3, 4, 5}) = Bag{3, 3}"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Bag{1, 2, 2, 3, 3, 3}->intersection(Set{3, 4, 5}) = Set{3}"));
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_difference() {
        this.helper.setContext((Object)((Classifier)this.getUMLInteger()));
        try {
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Set{1, 2, 3} - Set{3, 4, 5} = Set{1, 2}"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "OrderedSet{1, 2, 3} - Set{3, 4, 5} = Set{1, 2}"));
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_symmetricDifference() {
        this.helper.setContext((Object)((Classifier)this.getUMLInteger()));
        try {
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Set{1, 2, 3}->symmetricDifference(Set{3, 4, 5}) = Set{1, 2, 4, 5}"));
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "OrderedSet{1, 2, 3}->symmetricDifference(Set{3, 4, 5}) = Set{1, 2, 4, 5}"));
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_dotNavigationOfReferenceCollections_130239() {
        this.helper.setContext((Object)((Classifier)this.getMetaclass("Package")));
        try {
            OCLExpression expr = this.helper.createQuery("self.ownedType->union(self.nestedPackage.ownedType->asSet())->asSet()");
            CollectionsTest.assertEquals(new HashSet(((Package)this.fruitPackage).getOwnedTypes()), (Object)this.ocl.evaluate((Object)this.fruitPackage, expr));
        }
        catch (Exception exc) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + exc.getLocalizedMessage()));
        }
    }

    public void test_dotNavigationOfOperationCollections_130239() {
        Package fakePkg = umlf.createPackage();
        fakePkg.setName("fake");
        Class fake = fakePkg.createOwnedClass("Fake", false);
        Operation getFakes = fake.createOwnedOperation("getFakes", null, null, (Type)fake);
        getFakes.setUpper(-1);
        getFakes.setIsQuery(true);
        this.helper.setContext((Object)fake);
        try {
            this.helper.createQuery("self.getFakes()->union(self.getFakes().getFakes()->asSet())");
        }
        catch (Exception exc) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + exc.getLocalizedMessage()));
        }
    }

    public void test_collectionRange_152208() {
        this.helper.setContext((Object)((Classifier)this.getUMLInteger()));
        try {
            Collection result = (Collection)this.evaluate(this.helper, new Integer(1), "Sequence{1 .. 10}");
            int i = 1;
            while (i <= 10) {
                CollectionsTest.assertTrue((boolean)result.contains(new Integer(i)));
                ++i;
            }
            result = (Collection)this.evaluate(this.helper, new Integer(1), "Sequence{1, (2+1)..(3+4), 10}");
            CollectionsTest.assertTrue((boolean)result.contains(new Integer(1)));
            i = 3;
            while (i <= 7) {
                CollectionsTest.assertTrue((boolean)result.contains(new Integer(i)));
                ++i;
            }
            CollectionsTest.assertTrue((boolean)result.contains(new Integer(10)));
            result = (Collection)this.evaluate(this.helper, new Integer(1), "Sequence{1..10}");
            i = 1;
            while (i <= 10) {
                CollectionsTest.assertTrue((boolean)result.contains(new Integer(i)));
                ++i;
            }
            result = (Collection)this.evaluate(this.helper, new Integer(1), "Sequence{-20, -10..-1, 1}");
            CollectionsTest.assertTrue((boolean)result.contains(new Integer(-20)));
            i = -10;
            while (i <= -1) {
                CollectionsTest.assertTrue((boolean)result.contains(new Integer(i)));
                ++i;
            }
            CollectionsTest.assertTrue((boolean)result.contains(new Integer(1)));
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_collectionRange_330489() {
        this.helper.setContext((Object)((Classifier)this.getUMLInteger()));
        try {
            Collection result = (Collection)this.evaluate(this.helper, new Integer(1), "Sequence{1 .. 1}");
            CollectionsTest.assertEquals((int)1, (int)result.size());
            CollectionsTest.assertTrue((boolean)result.contains(new Integer(1)));
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_tupleWithCollectionPart_175490() {
        this.helper.setContext((Object)((Classifier)this.getMetaclass("Package")));
        try {
            OCLExpression expr = this.helper.createQuery("Tuple{a = self.ownedType}");
            CollectionsTest.assertTrue((boolean)(expr.getType() instanceof TupleType));
            TupleType tt = (TupleType)expr.getType();
            CollectionsTest.assertEquals((int)1, (int)tt.getOwnedAttributes().size());
            Property part = tt.getOwnedAttribute("a", null);
            CollectionsTest.assertNotNull((Object)part);
            CollectionsTest.assertTrue((boolean)(part.getType() instanceof CollectionType));
            CollectionType collType = (CollectionType)part.getType();
            CollectionsTest.assertSame((Object)this.getMetaclass("Type"), (Object)collType.getElementType());
            Object result = this.ocl.evaluate((Object)this.getUMLMetamodel(), expr);
            CollectionsTest.assertTrue((boolean)(result instanceof Tuple));
            Tuple tuple = (Tuple)result;
            CollectionsTest.assertTrue((boolean)(tuple.getValue("a") instanceof Collection));
            CollectionsTest.assertTrue((boolean)((Collection)tuple.getValue("a")).contains(this.getMetaclass("Classifier")));
        }
        catch (Exception exc) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + exc.getLocalizedMessage()));
        }
    }

    public void test_tupleWithCollectionLiteralPart_175490() {
        this.helper.setContext((Object)((Classifier)this.getMetaclass("Package")));
        try {
            OCLExpression expr = this.helper.createQuery("Tuple{a = Sequence{'a', 'b', 'c'}}");
            CollectionsTest.assertTrue((boolean)(expr.getType() instanceof TupleType));
            TupleType tt = (TupleType)expr.getType();
            CollectionsTest.assertEquals((int)1, (int)tt.getOwnedAttributes().size());
            Property part = tt.getOwnedAttribute("a", null);
            CollectionsTest.assertNotNull((Object)part);
            CollectionsTest.assertTrue((boolean)(part.getType() instanceof CollectionType));
            CollectionType collType = (CollectionType)part.getType();
            CollectionsTest.assertSame((Object)this.getOCLStandardLibrary().getString(), (Object)collType.getElementType());
            Object result = this.ocl.evaluate((Object)this.getUMLMetamodel(), expr);
            CollectionsTest.assertTrue((boolean)(result instanceof Tuple));
            Tuple tuple = (Tuple)result;
            CollectionsTest.assertTrue((boolean)(tuple.getValue("a") instanceof Collection));
            CollectionsTest.assertTrue((boolean)((Collection)tuple.getValue("a")).contains("b"));
        }
        catch (Exception exc) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + exc.getLocalizedMessage()));
        }
    }

    public void test_operationValueCollectionType_183667() {
        this.helper.setContext((Object)((Classifier)this.getMetaclass("Element")));
        try {
            OCLExpression expr = this.helper.createQuery("self.getKeywords()");
            Object value = this.ocl.evaluate((Object)this.getUMLMetamodel(), expr);
            CollectionsTest.assertTrue((boolean)(value instanceof Set));
            CollectionsTest.assertFalse((boolean)(value instanceof EList));
        }
        catch (Exception exc) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + exc.getLocalizedMessage()));
        }
    }

    public void test_propertyValueCollectionType_183667() {
        this.helper.setContext((Object)((Classifier)this.getMetaclass("Element")));
        try {
            OCLExpression expr = this.helper.createQuery("self.ownedComment");
            Object value = this.ocl.evaluate((Object)this.getUMLMetamodel(), expr);
            CollectionsTest.assertTrue((boolean)(value instanceof Set));
            CollectionsTest.assertFalse((boolean)(value instanceof EList));
        }
        catch (Exception exc) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + exc.getLocalizedMessage()));
        }
    }

    public void test_coercionOfCollectionParameters_184789() {
        Package pkg = UMLFactory.eINSTANCE.createPackage();
        pkg.createOwnedClass("Foo", false);
        pkg.createOwnedClass("Foo", false);
        pkg.createOwnedClass("Foo", false);
        Class bar = pkg.createOwnedClass("Bar", false);
        this.helper.setContext((Object)((Classifier)this.getMetaclass("Package")));
        try {
            OCLExpression expr = this.helper.createQuery("self.excludeCollisions(ownedType)");
            Object value = this.ocl.evaluate((Object)pkg, expr);
            CollectionsTest.assertEquals(Collections.singleton(bar), (Object)value);
        }
        catch (Exception exc) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + exc.getLocalizedMessage()));
        }
    }

    public void test_sequenceNotEqualSignature_184327() {
        this.helper.setContext((Object)((Classifier)this.getUMLString()));
        try {
            CollectionsTest.assertTrue((boolean)this.check(this.helper, "", "Sequence{1, 2, 3} <> Sequence{3, 2, 1}"));
            CollectionsTest.assertFalse((boolean)this.check(this.helper, "", "Sequence{1, 2, 3} <> Sequence{1, 2, 3}"));
        }
        catch (Exception e) {
            CollectionsTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }
}

