/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.test.xtext;

import java.io.IOException;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.pivot.tests.TestOCL;
import org.eclipse.ocl.examples.xtext.tests.XtextTestCase;
import org.eclipse.ocl.pivot.CallExp;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.IfExp;
import org.eclipse.ocl.pivot.IteratorExp;
import org.eclipse.ocl.pivot.LetExp;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.NullLiteralExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.PropertyCallExp;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.internal.manager.FlowAnalysis;
import org.eclipse.ocl.pivot.internal.manager.MetamodelManagerInternal;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.XMIUtil;
import org.eclipse.ocl.xtext.base.cs2as.CS2AS;
import org.eclipse.ocl.xtext.base.utilities.BaseCSResource;
import org.eclipse.ocl.xtext.oclstdlib.scoping.JavaClassScope;

public class FlowAnalysisTests
extends XtextTestCase {
    public void testFlowAnalysis_SimpleProperty() throws Exception {
        MyOCL ocl = new MyOCL();
        OperationCallExp asBody = (OperationCallExp)ocl.createTestModel("SimpleProperty", "x <> null");
        PropertyCallExp asPropertyCallExp = (PropertyCallExp)PivotUtil.getOwnedSource((CallExp)asBody);
        NullLiteralExp asNullLiteralExp = (NullLiteralExp)PivotUtil.getOwnedArgument((OperationCallExp)asBody, (int)0);
        ocl.assertIsNotKnown((OCLExpression)asPropertyCallExp);
        ocl.assertIsNull((OCLExpression)asNullLiteralExp);
        ocl.dispose();
    }

    public void testFlowAnalysis_SimpleNonNullVariable() throws Exception {
        MyOCL ocl = new MyOCL();
        LetExp asLetExp = (LetExp)ocl.createTestModel("SimpleNonNullVariable", "let v : Integer[1] = 1 in v <> null");
        OperationCallExp asIn = (OperationCallExp)PivotUtil.getOwnedIn((LetExp)asLetExp);
        VariableExp asVariableExp = (VariableExp)PivotUtil.getOwnedSource((CallExp)asIn);
        NullLiteralExp asNullLiteralExp = (NullLiteralExp)PivotUtil.getOwnedArgument((OperationCallExp)asIn, (int)0);
        ocl.assertIsNonNull((OCLExpression)asVariableExp);
        ocl.assertIsNull((OCLExpression)asNullLiteralExp);
        ocl.dispose();
    }

    public void testFlowAnalysis_SimpleNullVariable() throws Exception {
        MyOCL ocl = new MyOCL();
        LetExp asLetExp = (LetExp)ocl.createTestModel("SimpleNullVariable", "let v : Integer[?] = null in v <> null");
        OperationCallExp asIn = (OperationCallExp)PivotUtil.getOwnedIn((LetExp)asLetExp);
        VariableExp asVariableExp = (VariableExp)PivotUtil.getOwnedSource((CallExp)asIn);
        NullLiteralExp asNullLiteralExp = (NullLiteralExp)PivotUtil.getOwnedArgument((OperationCallExp)asIn, (int)0);
        ocl.assertIsNull((OCLExpression)asVariableExp);
        ocl.assertIsNull((OCLExpression)asNullLiteralExp);
        ocl.dispose();
    }

    public void testFlowAnalysis_SimpleNotKnownVariable() throws Exception {
        MyOCL ocl = new MyOCL();
        LetExp asLetExp = (LetExp)ocl.createTestModel("SimpleNotKnownVariable", "let v : Integer[?] = x in v <> null");
        OperationCallExp asIn = (OperationCallExp)PivotUtil.getOwnedIn((LetExp)asLetExp);
        VariableExp asVariableExp = (VariableExp)PivotUtil.getOwnedSource((CallExp)asIn);
        NullLiteralExp asNullLiteralExp = (NullLiteralExp)PivotUtil.getOwnedArgument((OperationCallExp)asIn, (int)0);
        ocl.assertIsNotKnown((OCLExpression)asVariableExp);
        ocl.assertIsNull((OCLExpression)asNullLiteralExp);
        ocl.dispose();
    }

    public void testFlowAnalysis_SimpleIfGuard() throws Exception {
        MyOCL ocl = new MyOCL();
        LetExp asLetExp = (LetExp)ocl.createTestModel("SimpleIfGuard", "let v : Integer[?] = x in if v <> null then v.toString() else v.toString() endif");
        IfExp asIn = (IfExp)PivotUtil.getOwnedIn((LetExp)asLetExp);
        OperationCallExp asCondition = (OperationCallExp)PivotUtil.getOwnedCondition((IfExp)asIn);
        OperationCallExp asThen = (OperationCallExp)PivotUtil.getOwnedThen((IfExp)asIn);
        OperationCallExp asElse = (OperationCallExp)PivotUtil.getOwnedElse((IfExp)asIn);
        VariableExp asConditionVariableExp = (VariableExp)PivotUtil.getOwnedSource((CallExp)asCondition);
        VariableExp asThenVariableExp = (VariableExp)PivotUtil.getOwnedSource((CallExp)asThen);
        VariableExp asElseVariableExp = (VariableExp)PivotUtil.getOwnedSource((CallExp)asElse);
        ocl.assertIsNotKnown((OCLExpression)asConditionVariableExp);
        ocl.assertIsNonNull((OCLExpression)asThenVariableExp);
        ocl.assertIsNull((OCLExpression)asElseVariableExp);
        ocl.dispose();
    }

    public void testFlowAnalysis_ImpliesPropertyGuard() throws Exception {
        MyOCL ocl = new MyOCL();
        OperationCallExp asImplies = (OperationCallExp)ocl.createTestModel("ImpliesVariableGuard", "x <> null implies x.toString() <> null");
        OperationCallExp asSource = (OperationCallExp)PivotUtil.getOwnedSource((CallExp)asImplies);
        OperationCallExp asArgument1 = (OperationCallExp)PivotUtil.getOwnedArgument((OperationCallExp)asImplies, (int)0);
        OperationCallExp asArgument2 = (OperationCallExp)PivotUtil.getOwnedSource((CallExp)asArgument1);
        PropertyCallExp asSourcePropertyCallExp = (PropertyCallExp)PivotUtil.getOwnedSource((CallExp)asSource);
        PropertyCallExp asArgumentPropertyCallExp = (PropertyCallExp)PivotUtil.getOwnedSource((CallExp)asArgument2);
        ocl.assertIsNotKnown((OCLExpression)asSourcePropertyCallExp);
        ocl.assertIsNonNull((OCLExpression)asArgumentPropertyCallExp);
        ocl.dispose();
    }

    public void testFlowAnalysis_ImpliesVariableGuard() throws Exception {
        MyOCL ocl = new MyOCL();
        LetExp asLetExp = (LetExp)ocl.createTestModel("ImpliesGuard", "let v : Integer[?] = x in v <> null implies v.toString() <> null");
        OperationCallExp asImplies = (OperationCallExp)PivotUtil.getOwnedIn((LetExp)asLetExp);
        OperationCallExp asSource = (OperationCallExp)PivotUtil.getOwnedSource((CallExp)asImplies);
        OperationCallExp asArgument1 = (OperationCallExp)PivotUtil.getOwnedArgument((OperationCallExp)asImplies, (int)0);
        OperationCallExp asArgument2 = (OperationCallExp)PivotUtil.getOwnedSource((CallExp)asArgument1);
        VariableExp asSourceVariableExp = (VariableExp)PivotUtil.getOwnedSource((CallExp)asSource);
        VariableExp asArgumentVariableExp = (VariableExp)PivotUtil.getOwnedSource((CallExp)asArgument2);
        ocl.assertIsNotKnown((OCLExpression)asSourceVariableExp);
        ocl.assertIsNonNull((OCLExpression)asArgumentVariableExp);
        ocl.dispose();
    }

    public void testFlowAnalysis_DoubleIfGuard() throws Exception {
        MyOCL ocl = new MyOCL();
        LetExp asLetExp = (LetExp)ocl.createTestModel("DoubleIfGuard", "let v : Integer[?] = x in if v <> null and x <> null then v.toString() else v.toString() endif");
        IfExp asIn = (IfExp)PivotUtil.getOwnedIn((LetExp)asLetExp);
        OperationCallExp asCondition1 = (OperationCallExp)PivotUtil.getOwnedCondition((IfExp)asIn);
        OperationCallExp asCondition1left = (OperationCallExp)PivotUtil.getOwnedSource((CallExp)asCondition1);
        OperationCallExp asThen = (OperationCallExp)PivotUtil.getOwnedThen((IfExp)asIn);
        OperationCallExp asElse = (OperationCallExp)PivotUtil.getOwnedElse((IfExp)asIn);
        VariableExp asConditionVariableExp = (VariableExp)PivotUtil.getOwnedSource((CallExp)asCondition1left);
        VariableExp asThenVariableExp = (VariableExp)PivotUtil.getOwnedSource((CallExp)asThen);
        VariableExp asElseVariableExp = (VariableExp)PivotUtil.getOwnedSource((CallExp)asElse);
        ocl.assertIsNotKnown((OCLExpression)asConditionVariableExp);
        ocl.assertIsNonNull((OCLExpression)asThenVariableExp);
        ocl.assertIsNotKnown((OCLExpression)asElseVariableExp);
        ocl.dispose();
    }

    public void testFlowAnalysis_DoubleImpliesPropertyGuard() throws Exception {
        MyOCL ocl = new MyOCL();
        OperationCallExp asImplies = (OperationCallExp)ocl.createTestModel("DoubleImpliesVariableGuard", "dummy <> null and dummy.dummy <> null implies dummy <> null xor dummy.dummy <> null xor dummy.dummy.dummy <> null");
        OperationCallExp asAnd12 = (OperationCallExp)PivotUtil.getOwnedSource((CallExp)asImplies);
        OperationCallExp asGuard1 = (OperationCallExp)PivotUtil.getOwnedSource((CallExp)asAnd12);
        PropertyCallExp asRef1 = (PropertyCallExp)PivotUtil.getOwnedSource((CallExp)asGuard1);
        OperationCallExp asGuard2 = (OperationCallExp)PivotUtil.getOwnedArgument((OperationCallExp)asAnd12, (int)0);
        PropertyCallExp asRef2 = (PropertyCallExp)PivotUtil.getOwnedSource((CallExp)asGuard2);
        OperationCallExp asOr123 = (OperationCallExp)PivotUtil.getOwnedArgument((OperationCallExp)asImplies, (int)0);
        OperationCallExp asOr12 = (OperationCallExp)PivotUtil.getOwnedSource((CallExp)asOr123);
        OperationCallExp asOr3 = (OperationCallExp)PivotUtil.getOwnedArgument((OperationCallExp)asOr123, (int)0);
        OperationCallExp asOr1 = (OperationCallExp)PivotUtil.getOwnedSource((CallExp)asOr12);
        OperationCallExp asOr2 = (OperationCallExp)PivotUtil.getOwnedArgument((OperationCallExp)asOr12, (int)0);
        PropertyCallExp asUse1 = (PropertyCallExp)PivotUtil.getOwnedSource((CallExp)asOr1);
        PropertyCallExp asUse2 = (PropertyCallExp)PivotUtil.getOwnedSource((CallExp)asOr2);
        PropertyCallExp asUse3 = (PropertyCallExp)PivotUtil.getOwnedSource((CallExp)asOr3);
        ocl.assertIsNotKnown((OCLExpression)asRef1);
        ocl.assertIsNotKnown((OCLExpression)asRef2);
        ocl.assertIsNonNull((OCLExpression)asUse1);
        ocl.assertIsNonNull((OCLExpression)asUse2);
        ocl.assertIsNotKnown((OCLExpression)asUse3);
        ocl.dispose();
    }

    public void testFlowAnalysis_DoubleBiImpliesPropertyGuard() throws Exception {
        MyOCL ocl = new MyOCL();
        OperationCallExp asImplies = (OperationCallExp)ocl.createTestModel("DoubleBiImpliesVariableGuard", "dummy <> null and dummy.dummy <> null implies dummy <> null or dummy.dummy <> null or dummy.dummy.dummy <> null");
        OperationCallExp asAnd12 = (OperationCallExp)PivotUtil.getOwnedSource((CallExp)asImplies);
        OperationCallExp asGuard1 = (OperationCallExp)PivotUtil.getOwnedSource((CallExp)asAnd12);
        PropertyCallExp asRef1 = (PropertyCallExp)PivotUtil.getOwnedSource((CallExp)asGuard1);
        OperationCallExp asGuard2 = (OperationCallExp)PivotUtil.getOwnedArgument((OperationCallExp)asAnd12, (int)0);
        PropertyCallExp asRef2 = (PropertyCallExp)PivotUtil.getOwnedSource((CallExp)asGuard2);
        OperationCallExp asOr123 = (OperationCallExp)PivotUtil.getOwnedArgument((OperationCallExp)asImplies, (int)0);
        OperationCallExp asOr12 = (OperationCallExp)PivotUtil.getOwnedSource((CallExp)asOr123);
        OperationCallExp asOr3 = (OperationCallExp)PivotUtil.getOwnedArgument((OperationCallExp)asOr123, (int)0);
        OperationCallExp asOr1 = (OperationCallExp)PivotUtil.getOwnedSource((CallExp)asOr12);
        OperationCallExp asOr2 = (OperationCallExp)PivotUtil.getOwnedArgument((OperationCallExp)asOr12, (int)0);
        PropertyCallExp asUse1 = (PropertyCallExp)PivotUtil.getOwnedSource((CallExp)asOr1);
        PropertyCallExp asUse2 = (PropertyCallExp)PivotUtil.getOwnedSource((CallExp)asOr2);
        PropertyCallExp asUse3 = (PropertyCallExp)PivotUtil.getOwnedSource((CallExp)asOr3);
        ocl.assertIsNull((OCLExpression)asRef1);
        ocl.assertIsNull((OCLExpression)asRef2);
        ocl.assertIsNonNull((OCLExpression)asUse1);
        ocl.assertIsNonNull((OCLExpression)asUse2);
        ocl.assertIsNotKnown((OCLExpression)asUse3);
        ocl.dispose();
    }

    public void testFlowAnalysis_IterationExpressionGuard() throws Exception {
        MyOCL ocl = new MyOCL();
        OperationCallExp asImplies = (OperationCallExp)ocl.createTestModel("IterationExpressionGuard", "dummy->select(s | s <> null) <> null implies dummy->select(s | s <> null) = null");
        OperationCallExp asStartsWith = (OperationCallExp)PivotUtil.getOwnedArgument((OperationCallExp)asImplies, (int)0);
        IteratorExp asCompare = (IteratorExp)PivotUtil.getOwnedSource((CallExp)asStartsWith);
        OperationCallExp asSource = (OperationCallExp)PivotUtil.getOwnedSource((CallExp)asCompare);
        ocl.assertIsNonNull((OCLExpression)asSource);
        ocl.dispose();
    }

    public void testFlowAnalysis_LetExpressionGuard() throws Exception {
        MyOCL ocl = new MyOCL();
        OperationCallExp asImplies = (OperationCallExp)ocl.createTestModel("LetExpressionGuard", "dummy.func(4, let q : Integer = 7 in q) <> null implies dummy.func(4, let y : Integer = 7 in y) = null");
        OperationCallExp asStartsWith = (OperationCallExp)PivotUtil.getOwnedArgument((OperationCallExp)asImplies, (int)0);
        OperationCallExp asCompare = (OperationCallExp)PivotUtil.getOwnedSource((CallExp)asStartsWith);
        ocl.assertIsNonNull((OCLExpression)asCompare);
        ocl.dispose();
    }

    public void testFlowAnalysis_OperationExpressionGuard() throws Exception {
        MyOCL ocl = new MyOCL();
        OperationCallExp asImplies = (OperationCallExp)ocl.createTestModel("OperationExpressionGuard", "dummy.func(2,5) <> null implies dummy.func(2,5).func(1,5) = null");
        OperationCallExp asStartsWith = (OperationCallExp)PivotUtil.getOwnedArgument((OperationCallExp)asImplies, (int)0);
        OperationCallExp asCompare = (OperationCallExp)PivotUtil.getOwnedSource((CallExp)asStartsWith);
        OperationCallExp asSource = (OperationCallExp)PivotUtil.getOwnedSource((CallExp)asCompare);
        ocl.assertIsNonNull((OCLExpression)asSource);
        ocl.dispose();
    }

    public class MyOCL
    extends TestOCL {
        public MyOCL() {
            super(FlowAnalysisTests.this.getTestFileSystem(), "FlowAnalysisTests", FlowAnalysisTests.this.getName(), OCL.NO_PROJECTS);
        }

        public void assertIsNonNull(@NonNull OCLExpression asExpression) {
            FlowAnalysis flowAnalysis = this.getFlowAnalysis(asExpression);
            FlowAnalysisTests.assertFalse((String)("Expected not-isNull for '" + asExpression + "'"), (boolean)flowAnalysis.isNull(asExpression));
            FlowAnalysisTests.assertTrue((String)("Expected isNonNull for '" + asExpression + "'"), (boolean)flowAnalysis.isNonNull(asExpression));
        }

        public void assertIsNotKnown(@NonNull OCLExpression asExpression) {
            FlowAnalysis flowAnalysis = this.getFlowAnalysis(asExpression);
            FlowAnalysisTests.assertFalse((String)("Expected not-isNull for '" + asExpression + "'"), (boolean)flowAnalysis.isNull(asExpression));
            FlowAnalysisTests.assertFalse((String)("Expected not-isNonNull for '" + asExpression + "'"), (boolean)flowAnalysis.isNonNull(asExpression));
        }

        public void assertIsNull(@NonNull OCLExpression asExpression) {
            FlowAnalysis flowAnalysis = this.getFlowAnalysis(asExpression);
            FlowAnalysisTests.assertTrue((String)("Expected isNull for '" + asExpression + "'"), (boolean)flowAnalysis.isNull(asExpression));
            FlowAnalysisTests.assertFalse((String)("Expected not-isNonNull for '" + asExpression + "'"), (boolean)flowAnalysis.isNonNull(asExpression));
        }

        protected @NonNull OCLExpression createTestModel(@NonNull String invariantName, @NonNull String invariantBody) throws IOException, ParserException {
            String testContext = "package deductions : ded = 'http://deductions'\n{\n  class Deductions\n  {\n    property dummy : Dummy[?];\n    property x : Integer[?];\n    invariant " + invariantName + ": " + invariantBody + ";\n" + "  }\n" + "  class Dummy\n" + "  {\n" + "    property dummy : Dummy[?];\n" + "    operation func(i : Integer, j : Integer) : Dummy[?];\n" + "  }\n" + "}";
            String fileName = "FlowAnalysis_" + invariantName;
            FlowAnalysisTests.this.createOCLinEcoreFile(String.valueOf(fileName) + ".oclinecore", testContext);
            Resource asResource = this.doLoad_Concrete(fileName, "oclinecore");
            Model model = PivotUtil.getModel((Resource)asResource);
            Package deductionsPackage = (Package)NameUtil.getNameable((Iterable)model.getOwnedPackages(), (String)"deductions");
            Class deductionsClass = (Class)NameUtil.getNameable((Iterable)deductionsPackage.getOwnedClasses(), (String)"Deductions");
            Constraint asInvariant = (Constraint)NameUtil.getNameable((Iterable)deductionsClass.getOwnedInvariants(), (String)invariantName);
            return ((EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension)this.environmentFactory).parseSpecification(asInvariant.getOwnedSpecification()).getOwnedBody();
        }

        public Resource doLoad_Concrete(@NonNull String stem, @NonNull String extension) throws IOException {
            ASResource asResource;
            String inputName = String.valueOf(stem) + "." + extension;
            String pivotName = String.valueOf(inputName) + ".oclas";
            URI inputURI = FlowAnalysisTests.this.getTestFileURI(inputName);
            URI pivotURI = FlowAnalysisTests.this.getTestFileURI(pivotName);
            BaseCSResource xtextResource = (BaseCSResource)this.getResourceSet().createResource(inputURI);
            xtextResource.setProjectManager((ProjectManager)FlowAnalysisTests.getProjectMap());
            JavaClassScope.getAdapter((BaseCSResource)xtextResource, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
            this.getEnvironmentFactory().adapt((Notifier)xtextResource);
            xtextResource.load(null);
            FlowAnalysisTests.assertNoResourceErrors("Load failed", (Resource)xtextResource);
            CS2AS cs2as = xtextResource.findCS2AS();
            if (cs2as != null) {
                asResource = cs2as.getASResource();
                FlowAnalysisTests.assertNoValidationErrors("Loaded pivot", (Resource)asResource);
            }
            asResource = xtextResource.getASResource();
            FlowAnalysisTests.assertNoUnresolvedProxies("Unresolved proxies", (Resource)xtextResource);
            FlowAnalysisTests.assertNoResourceErrors("Save failed", (Resource)xtextResource);
            asResource.setURI(pivotURI);
            FlowAnalysisTests.assertNoValidationErrors("Pivot validation errors", (EObject)asResource.getContents().get(0));
            asResource.save(XMIUtil.createSaveOptions());
            return asResource;
        }

        protected FlowAnalysis getFlowAnalysis(@NonNull OCLExpression asExpression) {
            MetamodelManagerInternal metamodelManager = this.getMetamodelManager();
            return ((MetamodelManagerInternal.MetamodelManagerInternalExtension2)metamodelManager).getFlowAnalysis(asExpression);
        }
    }
}

