/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.test.xtext;

import java.io.IOException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.pivot.tests.TestOCL;
import org.eclipse.ocl.examples.test.xtext.LoadTests;
import org.eclipse.ocl.examples.uml25.XMI252UMLResourceFactoryImpl;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.internal.utilities.GlobalEnvironmentFactory;
import org.eclipse.ocl.pivot.messages.StatusCodes;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.uml.UMLStandaloneSetup;
import org.eclipse.ocl.pivot.util.PivotValidator;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.resource.XMI2UMLResource;

public class UML25LoadTests
extends LoadTests {
    @Override
    public @NonNull TestOCL createOCL() {
        UMLStandaloneSetup.init();
        TestOCL ocl = new TestOCL(this.getTestFileSystem(), "UML25LoadTests", this.getName(), OCL.NO_PROJECTS);
        ResourceSet resourceSet = ocl.getResourceSet();
        XMI252UMLResourceFactoryImpl.install((ResourceSet)resourceSet, (URI)URI.createPlatformResourceURI((String)"/org.eclipse.ocl.examples.uml25/model/", (boolean)true));
        return ocl;
    }

    @Override
    public @NonNull TestOCL createOCLWithProjectMap() {
        UMLStandaloneSetup.init();
        TestOCL ocl = new TestOCL(this.getTestFileSystem(), "UML25LoadTests", this.getName(), (ProjectManager)UML25LoadTests.getProjectMap());
        ResourceSet resourceSet = ocl.getResourceSet();
        XMI252UMLResourceFactoryImpl.install((ResourceSet)resourceSet, (URI)URI.createPlatformResourceURI((String)"/org.eclipse.ocl.examples.uml25/model/", (boolean)true));
        return ocl;
    }

    @Override
    protected void tearDown() throws Exception {
        EValidator.Registry.INSTANCE.put((Object)PivotPackage.eINSTANCE, (Object)PivotValidator.INSTANCE);
        super.tearDown();
    }

    public void testLoad_UML_2_5_Beta_PrimitiveTypes() throws IOException, InterruptedException, ParserException {
        TestOCL ocl = this.createOCL();
        EPackage.Registry.INSTANCE.put((Object)"http://www.omg.org/spec/UML/20120801", (Object)UMLPackage.eINSTANCE);
        ocl.getResourceSet().getResourceFactoryRegistry().getExtensionToFactoryMap().put("xmi", XMI2UMLResource.Factory.INSTANCE);
        URI uml_2_5 = URI.createPlatformResourceURI((String)"/UML-2.5/XMI-2.5-Beta/PrimitiveTypes.xmi", (boolean)true);
        this.doLoadUML((OCL)ocl, uml_2_5, true, true, NO_MESSAGES, null);
        ocl.dispose();
    }

    public void testLoad_UML_2_5_Final_PrimitiveTypes() throws IOException, InterruptedException, ParserException {
        TestOCL ocl = this.createOCL();
        URI uml_2_5 = URI.createPlatformResourceURI((String)"/org.eclipse.ocl.examples.uml25/model/PrimitiveTypes.xmi", (boolean)true);
        this.doLoadUML((OCL)ocl, uml_2_5, true, true, NO_MESSAGES, null);
        ocl.dispose();
    }

    public void testLoad_UML_2_5_Final_DC() throws IOException, InterruptedException, ParserException {
        TestOCL ocl = this.createOCL();
        URI uml_2_5 = URI.createPlatformResourceURI((String)"/org.eclipse.ocl.examples.uml25/model/DC.xmi", (boolean)true);
        this.doLoadUML((OCL)ocl, uml_2_5, true, true, NO_MESSAGES, null);
        ocl.dispose();
    }

    public void testLoad_UML_2_5_Final_DI() throws IOException, InterruptedException, ParserException {
        TestOCL ocl = this.createOCL();
        URI uml_2_5 = URI.createPlatformResourceURI((String)"/org.eclipse.ocl.examples.uml25/model/DI.xmi", (boolean)true);
        this.doLoadUML((OCL)ocl, uml_2_5, true, true, NO_MESSAGES, null);
        ocl.dispose();
    }

    public void testLoad_UML_2_5_Final_DG() throws IOException, InterruptedException, ParserException {
        TestOCL ocl = this.createOCL();
        URI uml_2_5 = URI.createPlatformResourceURI((String)"/org.eclipse.ocl.examples.uml25/model/DG.xmi", (boolean)true);
        this.doLoadUML((OCL)ocl, uml_2_5, true, true, NO_MESSAGES, new String[]{"The 'Class::NameIsNotNull' constraint is violated for 'DG::null'"});
        ocl.dispose();
    }

    public void testLoad_UML_2_5_Final_UML() throws IOException, InterruptedException, ParserException {
        TestOCL ocl = this.createOCL();
        GlobalEnvironmentFactory.getInstance().setSafeNavigationValidationSeverity(StatusCodes.Severity.IGNORE);
        URI uml_2_5 = URI.createPlatformResourceURI((String)"/org.eclipse.ocl.examples.uml25/model/UML.xmi", (boolean)true);
        this.doLoadUML((OCL)ocl, uml_2_5, true, true, new String[]{"The 'Operation::CompatibleReturn' constraint is violated for 'UML::Classification::Operation::returnResult() : Set(UML::Classification::Parameter)'", "The 'Operation::CompatibleReturn' constraint is violated for 'UML::StructuredClassifiers::Association::endType() : Set(UML::CommonStructure::Type[+|1])'", "The 'Operation::CompatibleReturn' constraint is violated for 'UML::StructuredClassifiers::StructuredClassifier::part() : Set(UML::Classification::Property)'"}, null);
        ocl.dispose();
    }

    public void testLoad_UML_2_5_Final_UMLDI() throws IOException, InterruptedException, ParserException {
        TestOCL ocl = this.createOCL();
        GlobalEnvironmentFactory.getInstance().setSafeNavigationValidationSeverity(StatusCodes.Severity.IGNORE);
        URI uml_2_5 = URI.createPlatformResourceURI((String)"/org.eclipse.ocl.examples.uml25/model/UMLDI.xmi", (boolean)true);
        this.doLoadUML((OCL)ocl, uml_2_5, true, true, NO_MESSAGES, null);
        ocl.dispose();
    }

    public void testLoad_UML_2_5_Final_StandardProfile() throws IOException, InterruptedException, ParserException {
        TestOCL ocl = this.createOCL();
        URI uml_2_5 = URI.createPlatformResourceURI((String)"/org.eclipse.ocl.examples.uml25/model/StandardProfile.xmi", (boolean)true);
        this.doLoadUML((OCL)ocl, uml_2_5, true, true, NO_MESSAGES, null);
        ocl.dispose();
    }
}

